/* rygel-main.c generated by valac 0.25.3.10-37e0, the Vala compiler
 * generated from rygel-main.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Openismus GmbH.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <glib-unix.h>
#include <signal.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgssdp/gssdp.h>
#include <locale.h>
#include <rygel-server.h>
#include <unistd.h>


#define RYGEL_TYPE_MAIN (rygel_main_get_type ())
#define RYGEL_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MAIN, RygelMain))
#define RYGEL_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MAIN, RygelMainClass))
#define RYGEL_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MAIN))
#define RYGEL_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MAIN))
#define RYGEL_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MAIN, RygelMainClass))

typedef struct _RygelMain RygelMain;
typedef struct _RygelMainClass RygelMainClass;
typedef struct _RygelMainPrivate RygelMainPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMainCreateDeviceData RygelMainCreateDeviceData;

#define RYGEL_TYPE_CMDLINE_CONFIG (rygel_cmdline_config_get_type ())
#define RYGEL_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfig))
#define RYGEL_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))
#define RYGEL_IS_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_IS_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_CMDLINE_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))

typedef struct _RygelCmdlineConfig RygelCmdlineConfig;
typedef struct _RygelCmdlineConfigClass RygelCmdlineConfigClass;

#define RYGEL_TYPE_ENVIRONMENT_CONFIG (rygel_environment_config_get_type ())
#define RYGEL_ENVIRONMENT_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfig))
#define RYGEL_ENVIRONMENT_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfigClass))
#define RYGEL_IS_ENVIRONMENT_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG))
#define RYGEL_IS_ENVIRONMENT_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ENVIRONMENT_CONFIG))
#define RYGEL_ENVIRONMENT_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfigClass))

typedef struct _RygelEnvironmentConfig RygelEnvironmentConfig;
typedef struct _RygelEnvironmentConfigClass RygelEnvironmentConfigClass;

#define RYGEL_TYPE_USER_CONFIG (rygel_user_config_get_type ())
#define RYGEL_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfig))
#define RYGEL_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))
#define RYGEL_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))

typedef struct _RygelUserConfig RygelUserConfig;
typedef struct _RygelUserConfigClass RygelUserConfigClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_DBUS_SERVICE (rygel_dbus_service_get_type ())
#define RYGEL_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusService))
#define RYGEL_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))
#define RYGEL_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))

typedef struct _RygelDBusService RygelDBusService;
typedef struct _RygelDBusServiceClass RygelDBusServiceClass;

struct _RygelMain {
	GObject parent_instance;
	RygelMainPrivate * priv;
	gboolean need_restart;
};

struct _RygelMainClass {
	GObjectClass parent_class;
};

struct _RygelMainPrivate {
	RygelPluginLoader* plugin_loader;
	GUPnPContextManager* context_manager;
	GeeArrayList* factories;
	GeeArrayList* root_devices;
	RygelConfiguration* config;
	RygelLogHandler* log_handler;
	GMainLoop* main_loop;
	gint exit_code;
};

struct _RygelMainCreateDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMain* self;
	RygelPlugin* plugin;
	RygelRootDeviceFactory* factory;
	RygelRootDevice* device;
	RygelRootDeviceFactory* _tmp0_;
	RygelPlugin* _tmp1_;
	RygelRootDevice* _tmp2_;
	gboolean _tmp3_;
	RygelPlugin* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	RygelConfiguration* _tmp8_;
	gboolean _tmp9_;
	RygelRootDevice* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	RygelRootDevice* _tmp13_;
	RygelPlugin* _tmp14_;
	GError* _error_;
	const gchar* _tmp15_;
	RygelPlugin* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY
} RygelCmdlineConfigError;
#define RYGEL_CMDLINE_CONFIG_ERROR rygel_cmdline_config_error_quark ()

static gpointer rygel_main_parent_class = NULL;
static gint rygel_main_PLUGIN_TIMEOUT;
static gint rygel_main_PLUGIN_TIMEOUT = 5;

GType rygel_main_get_type (void) G_GNUC_CONST;
#define RYGEL_MAIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MAIN, RygelMainPrivate))
enum  {
	RYGEL_MAIN_DUMMY_PROPERTY
};
static RygelMain* rygel_main_new (GError** error);
static RygelMain* rygel_main_construct (GType object_type, GError** error);
static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin);
static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self);
static gboolean __lambda4_ (RygelMain* self);
void rygel_main_restart (RygelMain* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean __lambda5_ (RygelMain* self);
void rygel_main_exit (RygelMain* self, gint exit_code);
static gboolean ___lambda5__gsource_func (gpointer self);
static gboolean __lambda6_ (RygelMain* self);
static gboolean ___lambda6__gsource_func (gpointer self);
static gint rygel_main_run (RygelMain* self);
void rygel_main_dbus_available (RygelMain* self);
static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self);
static gboolean __lambda7_ (RygelMain* self);
static gboolean ___lambda7__gsource_func (gpointer self);
static void rygel_main_create_device (RygelMain* self, RygelPlugin* plugin, RygelRootDeviceFactory* factory, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_main_create_device_finish (RygelMain* self, GAsyncResult* _res_);
static void rygel_main_on_context_available (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context);
static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self);
static void rygel_main_on_context_unavailable (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context);
static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void rygel_main_create_device_data_free (gpointer _data);
static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* _data_);
static gboolean _rygel_main_create_device_co_gsource_func (gpointer self);
static void rygel_main_on_plugin_active_notify (RygelMain* self, GObject* obj, GParamSpec* spec);
static void _rygel_main_on_plugin_active_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_main_register_default_configurations (void);
GType rygel_cmdline_config_get_type (void) G_GNUC_CONST;
RygelCmdlineConfig* rygel_cmdline_config_get_default (void);
GType rygel_environment_config_get_type (void) G_GNUC_CONST;
RygelEnvironmentConfig* rygel_environment_config_get_default (void);
gchar* rygel_cmdline_config_get_config_file (RygelCmdlineConfig* self, GError** error);
GType rygel_user_config_get_type (void) G_GNUC_CONST;
RygelUserConfig* rygel_user_config_new (const gchar* local_path, GError** error);
RygelUserConfig* rygel_user_config_construct (GType object_type, const gchar* local_path, GError** error);
RygelUserConfig* rygel_user_config_get_default (GError** error);
static gint rygel_main_main (gchar** args, int args_length1);
GType rygel_dbus_service_get_type (void) G_GNUC_CONST;
guint rygel_dbus_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
static gchar** _vala_array_dup1 (gchar** self, int length);
GQuark rygel_cmdline_config_error_quark (void);
void rygel_cmdline_config_parse_args (gchar*** args, int* args_length1, GError** error);
RygelDBusService* rygel_dbus_service_new (RygelMain* main);
RygelDBusService* rygel_dbus_service_construct (GType object_type, RygelMain* main);
void rygel_dbus_service_publish (RygelDBusService* self);
void rygel_dbus_service_unpublish (RygelDBusService* self);
static void rygel_main_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self) {
	rygel_main_on_plugin_loaded ((RygelMain*) self, _sender, plugin);
}


static gboolean __lambda4_ (RygelMain* self) {
	gboolean result = FALSE;
	rygel_main_restart (self);
	result = TRUE;
	return result;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ ((RygelMain*) self);
	return result;
}


static gboolean __lambda5_ (RygelMain* self) {
	gboolean result = FALSE;
	rygel_main_exit (self, 0);
	result = FALSE;
	return result;
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ ((RygelMain*) self);
	return result;
}


static gboolean __lambda6_ (RygelMain* self) {
	gboolean result = FALSE;
	rygel_main_exit (self, 0);
	result = FALSE;
	return result;
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ ((RygelMain*) self);
	return result;
}


static RygelMain* rygel_main_construct (GType object_type, GError** error) {
	RygelMain * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelLogHandler* _tmp1_ = NULL;
	RygelMetaConfig* _tmp2_ = NULL;
	RygelPluginLoader* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	GMainLoop* _tmp6_ = NULL;
	RygelPluginLoader* _tmp7_ = NULL;
	self = (RygelMain*) g_object_new (object_type, NULL);
	_tmp0_ = _ (PACKAGE_NAME);
	g_set_application_name (_tmp0_);
	_tmp1_ = rygel_log_handler_get_default ();
	_g_object_unref0 (self->priv->log_handler);
	self->priv->log_handler = _tmp1_;
	_tmp2_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->config);
	self->priv->config = (RygelConfiguration*) _tmp2_;
	_tmp3_ = rygel_plugin_loader_new ();
	_g_object_unref0 (self->priv->plugin_loader);
	self->priv->plugin_loader = _tmp3_;
	_tmp4_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->root_devices);
	self->priv->root_devices = _tmp4_;
	_tmp5_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE_FACTORY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->factories);
	self->priv->factories = _tmp5_;
	_tmp6_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp6_;
	self->priv->exit_code = 0;
	_tmp7_ = self->priv->plugin_loader;
	g_signal_connect_object (_tmp7_, "plugin-available", (GCallback) _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available, self, 0);
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, SIGHUP, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, SIGINT, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, SIGTERM, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
	return self;
}


static RygelMain* rygel_main_new (GError** error) {
	return rygel_main_construct (RYGEL_TYPE_MAIN, error);
}


void rygel_main_exit (RygelMain* self, gint exit_code) {
	gint _tmp0_ = 0;
	GMainLoop* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = exit_code;
	self->priv->exit_code = _tmp0_;
	_g_object_unref0 (self->priv->root_devices);
	self->priv->root_devices = NULL;
	_tmp1_ = self->priv->main_loop;
	g_main_loop_quit (_tmp1_);
}


void rygel_main_restart (RygelMain* self) {
	g_return_if_fail (self != NULL);
	self->need_restart = TRUE;
	rygel_main_exit (self, 0);
}


static gint rygel_main_run (RygelMain* self) {
	gint result = 0;
	const gchar* _tmp4_ = NULL;
	GMainLoop* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		gboolean _tmp0_ = FALSE;
		RygelConfiguration* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = self->priv->config;
		_tmp2_ = rygel_configuration_get_upnp_enabled (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		if (!_tmp0_) {
			const gchar* _tmp3_ = NULL;
			_tmp3_ = _ ("Rygel is running in streaming-only mode.");
			g_message ("rygel-main.vala:83: %s", _tmp3_);
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp4_ = _ ("Rygel v%s starting…");
	g_message (_tmp4_, PACKAGE_VERSION);
	_tmp5_ = self->priv->main_loop;
	g_main_loop_run (_tmp5_);
	_tmp6_ = self->priv->exit_code;
	result = _tmp6_;
	return result;
}


static gboolean __lambda7_ (RygelMain* self) {
	gboolean result = FALSE;
	RygelPluginLoader* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	_tmp0_ = self->priv->plugin_loader;
	_tmp1_ = rygel_plugin_loader_list_plugins (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		gint _tmp6_ = 0;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp6_ = rygel_main_PLUGIN_TIMEOUT;
		_tmp7_ = ngettext ("No plugins found in %d second; giving up...", "No plugins found in %d seconds; giving up...", (gulong) _tmp6_);
		_tmp8_ = rygel_main_PLUGIN_TIMEOUT;
		g_warning (_tmp7_, _tmp8_);
		rygel_main_exit (self, -82);
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda7_ ((RygelMain*) self);
	return result;
}


void rygel_main_dbus_available (RygelMain* self) {
	GUPnPContextManager* _tmp0_ = NULL;
	RygelPluginLoader* _tmp1_ = NULL;
	gint timeout = 0;
	gint _tmp2_ = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = rygel_main_create_context_manager (self);
	_g_object_unref0 (self->priv->context_manager);
	self->priv->context_manager = _tmp0_;
	_tmp1_ = self->priv->plugin_loader;
	rygel_recursive_module_loader_load_modules ((RygelRecursiveModuleLoader*) _tmp1_);
	_tmp2_ = rygel_main_PLUGIN_TIMEOUT;
	timeout = _tmp2_;
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp3_ = rygel_meta_config_get_default ();
		config = _tmp3_;
		_tmp5_ = rygel_main_PLUGIN_TIMEOUT;
		_tmp6_ = rygel_configuration_get_int ((RygelConfiguration*) config, "plugin", "TIMEOUT", _tmp5_, G_MAXINT, &_inner_error_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch3_g_error;
		}
		timeout = _tmp4_;
		_g_object_unref0 (config);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = timeout;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp7_, ___lambda7__gsource_func, g_object_ref (self), g_object_unref);
}


static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin) {
	GeeIterator* iterator = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_loader != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = self->priv->factories;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	iterator = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		RygelPlugin* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		gpointer _tmp6_ = NULL;
		RygelRootDeviceFactory* _tmp7_ = NULL;
		_tmp2_ = iterator;
		_tmp3_ = gee_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = plugin;
		_tmp5_ = iterator;
		_tmp6_ = gee_iterator_get (_tmp5_);
		_tmp7_ = (RygelRootDeviceFactory*) _tmp6_;
		rygel_main_create_device (self, _tmp4_, _tmp7_, NULL, NULL);
		_g_object_unref0 (_tmp7_);
	}
	_g_object_unref0 (iterator);
}


static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self) {
	rygel_main_on_context_available ((RygelMain*) self, _sender, context);
}


static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self) {
	rygel_main_on_context_unavailable ((RygelMain*) self, _sender, context);
}


static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self) {
	GUPnPContextManager* result = NULL;
	gint port = 0;
	GUPnPContextManager* manager = NULL;
	gint _tmp3_ = 0;
	GUPnPContextManager* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	port = 0;
	{
		gint _tmp0_ = 0;
		RygelConfiguration* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = self->priv->config;
		_tmp2_ = rygel_configuration_get_port (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		port = _tmp0_;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp3_ = port;
	_tmp4_ = gupnp_context_manager_create ((guint) _tmp3_);
	manager = _tmp4_;
	g_signal_connect_object (manager, "context-available", (GCallback) _rygel_main_on_context_available_gupnp_context_manager_context_available, self, 0);
	g_signal_connect_object (manager, "context-unavailable", (GCallback) _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable, self, 0);
	result = manager;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void rygel_main_on_context_available (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context) {
	gchar** ifaces = NULL;
	gint ifaces_length1 = 0;
	gint _ifaces_size_ = 0;
	GUPnPContext* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPContext* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPContext* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	g_return_if_fail (context != NULL);
	ifaces = NULL;
	ifaces_length1 = 0;
	_ifaces_size_ = ifaces_length1;
	_tmp0_ = context;
	_tmp1_ = gssdp_client_get_network ((GSSDPClient*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = context;
	_tmp4_ = gssdp_client_get_interface ((GSSDPClient*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	_tmp7_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_debug ("rygel-main.vala:149: New network %s (%s) context available. IP: %s", _tmp2_, _tmp5_, _tmp8_);
	{
		gchar** _tmp9_ = NULL;
		RygelConfiguration* _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		gchar** _tmp12_ = NULL;
		gint _tmp9__length1 = 0;
		gint __tmp9__size_ = 0;
		gchar** _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		_tmp10_ = self->priv->config;
		_tmp12_ = _tmp11_ = rygel_configuration_get_interfaces (_tmp10_, &_inner_error_);
		_tmp9_ = _tmp12_;
		_tmp9__length1 = _vala_array_length (_tmp11_);
		__tmp9__size_ = _tmp9__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_tmp13_ = _tmp9_;
		_tmp13__length1 = _tmp9__length1;
		_tmp9_ = NULL;
		_tmp9__length1 = 0;
		ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
		ifaces = _tmp13_;
		ifaces_length1 = _tmp13__length1;
		_ifaces_size_ = ifaces_length1;
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp16_ = ifaces;
	_tmp16__length1 = ifaces_length1;
	if (_tmp16_ == NULL) {
		_tmp15_ = TRUE;
	} else {
		GUPnPContext* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		_tmp17_ = context;
		_tmp18_ = gssdp_client_get_interface ((GSSDPClient*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = ifaces;
		_tmp20__length1 = ifaces_length1;
		_tmp15_ = _vala_string_array_contains (_tmp20_, _tmp20__length1, _tmp19_);
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		GUPnPContext* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		_tmp21_ = context;
		_tmp22_ = gssdp_client_get_network ((GSSDPClient*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = ifaces;
		_tmp24__length1 = ifaces_length1;
		_tmp14_ = _vala_string_array_contains (_tmp24_, _tmp24__length1, _tmp23_);
	}
	if (_tmp14_) {
		{
			RygelRootDeviceFactory* factory = NULL;
			GUPnPContext* _tmp25_ = NULL;
			RygelRootDeviceFactory* _tmp26_ = NULL;
			GeeArrayList* _tmp27_ = NULL;
			RygelRootDeviceFactory* _tmp28_ = NULL;
			GeeIterator* iterator = NULL;
			RygelPluginLoader* _tmp29_ = NULL;
			GeeCollection* _tmp30_ = NULL;
			GeeCollection* _tmp31_ = NULL;
			GeeIterator* _tmp32_ = NULL;
			GeeIterator* _tmp33_ = NULL;
			_tmp25_ = context;
			_tmp26_ = rygel_root_device_factory_new (_tmp25_, &_inner_error_);
			factory = _tmp26_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch6_g_error;
			}
			_tmp27_ = self->priv->factories;
			_tmp28_ = factory;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
			_tmp29_ = self->priv->plugin_loader;
			_tmp30_ = rygel_plugin_loader_list_plugins (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
			_tmp33_ = _tmp32_;
			_g_object_unref0 (_tmp31_);
			iterator = _tmp33_;
			while (TRUE) {
				GeeIterator* _tmp34_ = NULL;
				gboolean _tmp35_ = FALSE;
				GeeIterator* _tmp36_ = NULL;
				gpointer _tmp37_ = NULL;
				RygelPlugin* _tmp38_ = NULL;
				RygelRootDeviceFactory* _tmp39_ = NULL;
				_tmp34_ = iterator;
				_tmp35_ = gee_iterator_next (_tmp34_);
				if (!_tmp35_) {
					break;
				}
				_tmp36_ = iterator;
				_tmp37_ = gee_iterator_get (_tmp36_);
				_tmp38_ = (RygelPlugin*) _tmp37_;
				_tmp39_ = factory;
				rygel_main_create_device (self, _tmp38_, _tmp39_, NULL, NULL);
				_g_object_unref0 (_tmp38_);
			}
			_g_object_unref0 (iterator);
			_g_object_unref0 (factory);
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp40_ = NULL;
			GError* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp40_ = _ ("Failed to create root device factory: %s");
			_tmp41_ = err;
			_tmp42_ = _tmp41_->message;
			g_warning (_tmp40_, _tmp42_);
			_g_error_free0 (err);
		}
		__finally6:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		GUPnPContext* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		GUPnPContext* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		_tmp43_ = context;
		_tmp44_ = gssdp_client_get_network ((GSSDPClient*) _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = context;
		_tmp47_ = gssdp_client_get_interface ((GSSDPClient*) _tmp46_);
		_tmp48_ = _tmp47_;
		g_debug ("rygel-main.vala:174: Ignoring network %s (%s) context.", _tmp45_, _tmp48_);
	}
	ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
}


static void rygel_main_on_context_unavailable (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context) {
	GUPnPContext* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPContext* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPContext* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GeeIterator* factory_iter = NULL;
	GeeArrayList* _tmp9_ = NULL;
	GeeIterator* _tmp10_ = NULL;
	GeeIterator* device_iter = NULL;
	GeeArrayList* _tmp21_ = NULL;
	GeeIterator* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp1_ = gssdp_client_get_network ((GSSDPClient*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = context;
	_tmp4_ = gssdp_client_get_interface ((GSSDPClient*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	_tmp7_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_debug ("rygel-main.vala:182: Network %s (%s) context now unavailable. IP: %s", _tmp2_, _tmp5_, _tmp8_);
	_tmp9_ = self->priv->factories;
	_tmp10_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp9_);
	factory_iter = _tmp10_;
	while (TRUE) {
		GeeIterator* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		GUPnPContext* _tmp13_ = NULL;
		GeeIterator* _tmp14_ = NULL;
		gpointer _tmp15_ = NULL;
		RygelRootDeviceFactory* _tmp16_ = NULL;
		GUPnPContext* _tmp17_ = NULL;
		GUPnPContext* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		_tmp11_ = factory_iter;
		_tmp12_ = gee_iterator_next (_tmp11_);
		if (!_tmp12_) {
			break;
		}
		_tmp13_ = context;
		_tmp14_ = factory_iter;
		_tmp15_ = gee_iterator_get (_tmp14_);
		_tmp16_ = (RygelRootDeviceFactory*) _tmp15_;
		_tmp17_ = rygel_root_device_factory_get_context (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp13_ == _tmp18_;
		_g_object_unref0 (_tmp16_);
		if (_tmp19_) {
			GeeIterator* _tmp20_ = NULL;
			_tmp20_ = factory_iter;
			gee_iterator_remove (_tmp20_);
		}
	}
	_tmp21_ = self->priv->root_devices;
	_tmp22_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp21_);
	device_iter = _tmp22_;
	while (TRUE) {
		GeeIterator* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
		GUPnPContext* _tmp25_ = NULL;
		GeeIterator* _tmp26_ = NULL;
		gpointer _tmp27_ = NULL;
		RygelRootDevice* _tmp28_ = NULL;
		GUPnPContext* _tmp29_ = NULL;
		GUPnPContext* _tmp30_ = NULL;
		gboolean _tmp31_ = FALSE;
		_tmp23_ = device_iter;
		_tmp24_ = gee_iterator_next (_tmp23_);
		if (!_tmp24_) {
			break;
		}
		_tmp25_ = context;
		_tmp26_ = device_iter;
		_tmp27_ = gee_iterator_get (_tmp26_);
		_tmp28_ = (RygelRootDevice*) _tmp27_;
		_tmp29_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp25_ == _tmp30_;
		_g_object_unref0 (_tmp28_);
		if (_tmp31_) {
			GeeIterator* _tmp32_ = NULL;
			_tmp32_ = device_iter;
			gee_iterator_remove (_tmp32_);
		}
	}
	_g_object_unref0 (device_iter);
	_g_object_unref0 (factory_iter);
}


static void rygel_main_create_device_data_free (gpointer _data) {
	RygelMainCreateDeviceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->plugin);
	_g_object_unref0 (_data_->factory);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMainCreateDeviceData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_main_create_device (RygelMain* self, RygelPlugin* plugin, RygelRootDeviceFactory* factory, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMainCreateDeviceData* _data_;
	RygelMain* _tmp0_ = NULL;
	RygelPlugin* _tmp1_ = NULL;
	RygelPlugin* _tmp2_ = NULL;
	RygelRootDeviceFactory* _tmp3_ = NULL;
	RygelRootDeviceFactory* _tmp4_ = NULL;
	_data_ = g_slice_new0 (RygelMainCreateDeviceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_main_create_device);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_main_create_device_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = plugin;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->plugin);
	_data_->plugin = _tmp2_;
	_tmp3_ = factory;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->factory);
	_data_->factory = _tmp4_;
	rygel_main_create_device_co (_data_);
}


static void rygel_main_create_device_finish (RygelMain* self, GAsyncResult* _res_) {
	RygelMainCreateDeviceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _rygel_main_create_device_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_main_create_device_co (self);
	return result;
}


static void _rygel_main_on_plugin_active_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_main_on_plugin_active_notify ((RygelMain*) self, _sender, pspec);
}


static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_main_create_device_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->factory;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->plugin;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = rygel_root_device_factory_create (_data_->_tmp0_, _data_->_tmp1_, &_data_->_inner_error_);
		_data_->device = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->plugin;
		_data_->_tmp5_ = FALSE;
		_data_->_tmp5_ = rygel_plugin_get_active (_data_->_tmp4_);
		_data_->_tmp6_ = FALSE;
		_data_->_tmp6_ = _data_->_tmp5_;
		if (_data_->_tmp6_) {
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->self->priv->config;
			_data_->_tmp9_ = FALSE;
			_data_->_tmp9_ = rygel_configuration_get_upnp_enabled (_data_->_tmp8_, &_data_->_inner_error_);
			_data_->_tmp7_ = _data_->_tmp9_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->device);
				goto __catch7_g_error;
			}
			_data_->_tmp3_ = _data_->_tmp7_;
		} else {
			_data_->_tmp3_ = FALSE;
		}
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->device;
		gupnp_root_device_set_available ((GUPnPRootDevice*) _data_->_tmp10_, _data_->_tmp3_);
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->self->priv->root_devices;
		if (_data_->_tmp11_ != NULL) {
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->self->priv->root_devices;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->device;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp12_, _data_->_tmp13_);
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->plugin;
			g_signal_connect_object ((GObject*) _data_->_tmp14_, "notify::active", (GCallback) _rygel_main_on_plugin_active_notify_g_object_notify, _data_->self, 0);
		}
		_g_object_unref0 (_data_->device);
	}
	goto __finally7;
	__catch7_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _ ("Failed to create RootDevice for %s. Reason: %s");
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->plugin;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = rygel_plugin_get_name (_data_->_tmp16_);
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_error_;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_warning (_data_->_tmp15_, _data_->_tmp18_, _data_->_tmp20_);
		_g_error_free0 (_data_->_error_);
	}
	__finally7:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_main_on_plugin_active_notify (RygelMain* self, GObject* obj, GParamSpec* spec) {
	GeeArrayList* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelPlugin* plugin = NULL;
	GObject* _tmp2_ = NULL;
	RygelPlugin* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = self->priv->root_devices;
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = obj;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_PLUGIN) ? ((RygelPlugin*) _tmp2_) : NULL);
	plugin = _tmp3_;
	{
		GeeArrayList* _device_list = NULL;
		GeeArrayList* _tmp4_ = NULL;
		GeeArrayList* _tmp5_ = NULL;
		gint _device_size = 0;
		GeeArrayList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _device_index = 0;
		_tmp4_ = self->priv->root_devices;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_device_list = _tmp5_;
		_tmp6_ = _device_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_device_size = _tmp8_;
		_device_index = -1;
		while (TRUE) {
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			RygelRootDevice* device = NULL;
			GeeArrayList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			RygelRootDevice* _tmp15_ = NULL;
			GUPnPResourceFactory* _tmp16_ = NULL;
			GUPnPResourceFactory* _tmp17_ = NULL;
			RygelPlugin* _tmp18_ = NULL;
			_tmp9_ = _device_index;
			_device_index = _tmp9_ + 1;
			_tmp10_ = _device_index;
			_tmp11_ = _device_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _device_list;
			_tmp13_ = _device_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			device = (RygelRootDevice*) _tmp14_;
			_tmp15_ = device;
			_tmp16_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = plugin;
			if (_tmp17_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gupnp_resource_factory_get_type (), GUPnPResourceFactory)) {
				RygelRootDevice* _tmp19_ = NULL;
				RygelPlugin* _tmp20_ = NULL;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				_tmp19_ = device;
				_tmp20_ = plugin;
				_tmp21_ = rygel_plugin_get_active (_tmp20_);
				_tmp22_ = _tmp21_;
				gupnp_root_device_set_available ((GUPnPRootDevice*) _tmp19_, _tmp22_);
			}
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_list);
	}
	_g_object_unref0 (plugin);
}


static void rygel_main_register_default_configurations (void) {
	RygelCmdlineConfig* cmdline_config = NULL;
	RygelCmdlineConfig* _tmp0_ = NULL;
	RygelCmdlineConfig* _tmp1_ = NULL;
	RygelEnvironmentConfig* _tmp2_ = NULL;
	RygelEnvironmentConfig* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_cmdline_config_get_default ();
	cmdline_config = _tmp0_;
	_tmp1_ = cmdline_config;
	rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp1_);
	_tmp2_ = rygel_environment_config_get_default ();
	_tmp3_ = _tmp2_;
	rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	{
		gchar* config_file = NULL;
		RygelCmdlineConfig* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		RygelUserConfig* user_config = NULL;
		const gchar* _tmp6_ = NULL;
		RygelUserConfig* _tmp7_ = NULL;
		RygelUserConfig* _tmp8_ = NULL;
		_tmp4_ = cmdline_config;
		_tmp5_ = rygel_cmdline_config_get_config_file (_tmp4_, &_inner_error_);
		config_file = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
		_tmp6_ = config_file;
		_tmp7_ = rygel_user_config_new (_tmp6_, &_inner_error_);
		user_config = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (config_file);
			goto __catch8_g_error;
		}
		_tmp8_ = user_config;
		rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp8_);
		_g_object_unref0 (user_config);
		_g_free0 (config_file);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			RygelUserConfig* user_config = NULL;
			RygelUserConfig* _tmp9_ = NULL;
			RygelUserConfig* _tmp10_ = NULL;
			_tmp9_ = rygel_user_config_get_default (&_inner_error_);
			user_config = _tmp9_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch9_g_error;
			}
			_tmp10_ = user_config;
			rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp10_);
			_g_object_unref0 (user_config);
		}
		goto __finally9;
		__catch9_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp11_ = NULL;
			GError* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp11_ = _ ("Failed to load user configuration: %s");
			_tmp12_ = err;
			_tmp13_ = _tmp12_->message;
			g_warning (_tmp11_, _tmp13_);
			_g_error_free0 (err);
		}
		__finally9:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_error_free0 (_error_);
			_g_error_free0 (_error_);
			_g_object_unref0 (cmdline_config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_error_free0 (_error_);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (cmdline_config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (cmdline_config);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gint rygel_main_main (gchar** args, int args_length1) {
	gint result = 0;
	RygelMain* main = NULL;
	RygelDBusService* service = NULL;
	gchar** original_args = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint original_args_length1 = 0;
	gint _original_args_size_ = 0;
	gint exit_code = 0;
	RygelMain* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	RygelDBusService* _tmp11_ = NULL;
	RygelMain* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GError * _inner_error_ = NULL;
	main = NULL;
	service = NULL;
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	original_args = _tmp1_;
	original_args_length1 = _tmp1__length1;
	_original_args_size_ = original_args_length1;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	{
		RygelMain* _tmp2_ = NULL;
		RygelMain* _tmp3_ = NULL;
		RygelMain* _tmp4_ = NULL;
		RygelMain* _tmp5_ = NULL;
		RygelDBusService* _tmp6_ = NULL;
		RygelDBusService* _tmp7_ = NULL;
		rygel_cmdline_config_parse_args (&args, &args_length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
				goto __catch10_rygel_cmdline_config_error_version_only;
			}
			goto __catch10_g_error;
		}
		rygel_main_register_default_configurations ();
		rygel_media_engine_init (&_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
				goto __catch10_rygel_cmdline_config_error_version_only;
			}
			goto __catch10_g_error;
		}
		_tmp3_ = rygel_main_new (&_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
				goto __catch10_rygel_cmdline_config_error_version_only;
			}
			goto __catch10_g_error;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (main);
		main = _tmp4_;
		_tmp5_ = main;
		_tmp6_ = rygel_dbus_service_new (_tmp5_);
		_g_object_unref0 (service);
		service = _tmp6_;
		_tmp7_ = service;
		rygel_dbus_service_publish (_tmp7_);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally10;
	__catch10_rygel_cmdline_config_error_version_only:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		result = 0;
		_g_error_free0 (err);
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (service);
		_g_object_unref0 (main);
		return result;
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp8_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = err->message;
		g_error ("rygel-main.vala:295: %s", _tmp8_);
		_g_error_free0 (err);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (service);
		_g_object_unref0 (main);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = main;
	_tmp10_ = rygel_main_run (_tmp9_);
	exit_code = _tmp10_;
	_tmp11_ = service;
	if (_tmp11_ != NULL) {
		RygelDBusService* _tmp12_ = NULL;
		_tmp12_ = service;
		rygel_dbus_service_unpublish (_tmp12_);
	}
	_tmp13_ = main;
	_tmp14_ = _tmp13_->need_restart;
	if (_tmp14_) {
		gchar** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		const gchar* _tmp16_ = NULL;
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		_tmp15_ = original_args;
		_tmp15__length1 = original_args_length1;
		_tmp16_ = _tmp15_[0];
		_tmp17_ = original_args;
		_tmp17__length1 = original_args_length1;
		execvp (_tmp16_, _tmp17_);
	}
	result = exit_code;
	original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (service);
	_g_object_unref0 (main);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return rygel_main_main (argv, argc);
}


static void rygel_main_class_init (RygelMainClass * klass) {
	rygel_main_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMainPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_main_finalize;
}


static void rygel_main_instance_init (RygelMain * self) {
	self->priv = RYGEL_MAIN_GET_PRIVATE (self);
}


static void rygel_main_finalize (GObject* obj) {
	RygelMain * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MAIN, RygelMain);
	_g_object_unref0 (self->priv->plugin_loader);
	_g_object_unref0 (self->priv->context_manager);
	_g_object_unref0 (self->priv->factories);
	_g_object_unref0 (self->priv->root_devices);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->log_handler);
	_g_main_loop_unref0 (self->priv->main_loop);
	G_OBJECT_CLASS (rygel_main_parent_class)->finalize (obj);
}


GType rygel_main_get_type (void) {
	static volatile gsize rygel_main_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMain), 0, (GInstanceInitFunc) rygel_main_instance_init, NULL };
		GType rygel_main_type_id;
		rygel_main_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMain", &g_define_type_info, 0);
		g_once_init_leave (&rygel_main_type_id__volatile, rygel_main_type_id);
	}
	return rygel_main_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



