/* gitg-repository-list-box.c generated by valac 0.26.1, the Vala compiler
 * generated from gitg-repository-list-box.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Ignacio Casal Quinteiro
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>


#define GITG_TYPE_SELECTION_MODE (gitg_selection_mode_get_type ())

#define GITG_TYPE_REPOSITORY_LIST_BOX (gitg_repository_list_box_get_type ())
#define GITG_REPOSITORY_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox))
#define GITG_REPOSITORY_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxClass))
#define GITG_IS_REPOSITORY_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY_LIST_BOX))
#define GITG_IS_REPOSITORY_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY_LIST_BOX))
#define GITG_REPOSITORY_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxClass))

typedef struct _GitgRepositoryListBox GitgRepositoryListBox;
typedef struct _GitgRepositoryListBoxClass GitgRepositoryListBoxClass;
typedef struct _GitgRepositoryListBoxPrivate GitgRepositoryListBoxPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GITG_REPOSITORY_LIST_BOX_TYPE_ROW (gitg_repository_list_box_row_get_type ())
#define GITG_REPOSITORY_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow))
#define GITG_REPOSITORY_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowClass))
#define GITG_REPOSITORY_LIST_BOX_IS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW))
#define GITG_REPOSITORY_LIST_BOX_IS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_ROW))
#define GITG_REPOSITORY_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowClass))

typedef struct _GitgRepositoryListBoxRow GitgRepositoryListBoxRow;
typedef struct _GitgRepositoryListBoxRowClass GitgRepositoryListBoxRowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))
#define __g_list_free__gtk_recent_info_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_recent_info_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block8Data Block8Data;

#define GITG_TYPE_REF (gitg_ref_get_type ())
#define GITG_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF, GitgRef))
#define GITG_IS_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF))
#define GITG_REF_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_REF, GitgRefIface))

typedef struct _GitgRef GitgRef;
typedef struct _GitgRefIface GitgRefIface;

#define GITG_TYPE_PARSED_REF_NAME (gitg_parsed_ref_name_get_type ())
#define GITG_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName))
#define GITG_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))
#define GITG_IS_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PARSED_REF_NAME))
#define GITG_IS_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PARSED_REF_NAME))
#define GITG_PARSED_REF_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))

typedef struct _GitgParsedRefName GitgParsedRefName;
typedef struct _GitgParsedRefNameClass GitgParsedRefNameClass;

#define GITG_TYPE_REF_STATE (gitg_ref_state_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block9Data Block9Data;

#define GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS (gitg_repository_list_box_clone_progress_get_type ())
#define GITG_REPOSITORY_LIST_BOX_CLONE_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS, GitgRepositoryListBoxCloneProgress))
#define GITG_REPOSITORY_LIST_BOX_CLONE_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS, GitgRepositoryListBoxCloneProgressClass))
#define GITG_REPOSITORY_LIST_BOX_IS_CLONE_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS))
#define GITG_REPOSITORY_LIST_BOX_IS_CLONE_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS))
#define GITG_REPOSITORY_LIST_BOX_CLONE_PROGRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS, GitgRepositoryListBoxCloneProgressClass))

typedef struct _GitgRepositoryListBoxCloneProgress GitgRepositoryListBoxCloneProgress;
typedef struct _GitgRepositoryListBoxCloneProgressClass GitgRepositoryListBoxCloneProgressClass;
#define __vala_GgitCloneOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitCloneOptions_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _GitgRepositoryListBoxCloneData GitgRepositoryListBoxCloneData;
typedef struct _Block10Data Block10Data;
typedef struct _GitgRepositoryListBoxRowPrivate GitgRepositoryListBoxRowPrivate;

#define GITG_TYPE_PROGRESS_BIN (gitg_progress_bin_get_type ())
#define GITG_PROGRESS_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PROGRESS_BIN, GitgProgressBin))
#define GITG_PROGRESS_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PROGRESS_BIN, GitgProgressBinClass))
#define GITG_IS_PROGRESS_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PROGRESS_BIN))
#define GITG_IS_PROGRESS_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PROGRESS_BIN))
#define GITG_PROGRESS_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PROGRESS_BIN, GitgProgressBinClass))

typedef struct _GitgProgressBin GitgProgressBin;
typedef struct _GitgProgressBinClass GitgProgressBinClass;
typedef struct _GitgRepositoryListBoxCloneProgressPrivate GitgRepositoryListBoxCloneProgressPrivate;

typedef enum  {
	GITG_SELECTION_MODE_NORMAL,
	GITG_SELECTION_MODE_SELECTION
} GitgSelectionMode;

struct _GitgRepositoryListBox {
	GtkListBox parent_instance;
	GitgRepositoryListBoxPrivate * priv;
};

struct _GitgRepositoryListBoxClass {
	GtkListBoxClass parent_class;
};

struct _GitgRepositoryListBoxPrivate {
	gchar* d_filter_text;
	GitgSelectionMode _mode;
};

struct _Block8Data {
	int _ref_count_;
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* row;
	GFile* f;
};

typedef enum  {
	GITG_REF_STATE_NONE,
	GITG_REF_STATE_SELECTED,
	GITG_REF_STATE_PRELIGHT
} GitgRefState;

struct _GitgRefIface {
	GTypeInterface parent_iface;
	GitgRepository* (*get_owner) (GitgRef* self);
	GitgParsedRefName* (*get_d_parsed_name) (GitgRef* self);
	void (*set_d_parsed_name) (GitgRef* self, GitgParsedRefName* value);
	GList* (*get_d_pushes) (GitgRef* self);
	void (*set_d_pushes) (GitgRef* self, GList* value);
	GitgRefState (*get_state) (GitgRef* self);
	void (*set_state) (GitgRef* self, GitgRefState value);
	gboolean (*get_working) (GitgRef* self);
	void (*set_working) (GitgRef* self, gboolean value);
};

struct _Block9Data {
	int _ref_count_;
	GitgRepositoryListBox* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GitgRepository* repository;
	GitgRepositoryListBoxRow* row;
	gchar* url;
	GFile* location;
	gboolean is_bare;
	gpointer _async_data_;
};

struct _GitgRepositoryListBoxCloneData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* row;
	gchar* url;
	GFile* location;
	gboolean is_bare;
	GitgRepository* result;
	Block9Data* _data9_;
	GitgRepositoryListBoxRow* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	GThreadFunc run;
	void* run_target;
	GDestroyNotify run_target_destroy_notify;
	GThreadFunc _tmp4_;
	void* _tmp4__target;
	GDestroyNotify _tmp4__target_destroy_notify;
	GThread* _tmp5_;
	GThread* _tmp6_;
	GitgRepository* _tmp7_;
	GError * _inner_error_;
};

struct _Block10Data {
	int _ref_count_;
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* row;
};

struct _GitgRepositoryListBoxRow {
	GtkListBoxRow parent_instance;
	GitgRepositoryListBoxRowPrivate * priv;
};

struct _GitgRepositoryListBoxRowClass {
	GtkListBoxRowClass parent_class;
};

struct _GitgRepositoryListBoxRowPrivate {
	GitgRepository* d_repository;
	GDateTime* d_time;
	gboolean d_loading;
	gboolean d_has_remote;
	GitgProgressBin* d_progress_bin;
	GtkImage* d_image;
	GtkLabel* d_repository_label;
	GtkLabel* d_branch_label;
	GtkArrow* d_arrow;
	GtkSpinner* d_spinner;
	GtkCheckButton* d_remove_check_button;
	GtkRevealer* d_remove_revealer;
	GitgSelectionMode d_mode;
	gboolean _selected;
};

struct _GitgRepositoryListBoxCloneProgress {
	GgitRemoteCallbacks parent_instance;
	GitgRepositoryListBoxCloneProgressPrivate * priv;
};

struct _GitgRepositoryListBoxCloneProgressClass {
	GgitRemoteCallbacksClass parent_class;
};

struct _GitgRepositoryListBoxCloneProgressPrivate {
	GitgRepositoryListBoxRow* d_row;
};


static gpointer gitg_repository_list_box_parent_class = NULL;
static gpointer gitg_repository_list_box_row_parent_class = NULL;
static GtkIconSize gitg_repository_list_box_row_s_icon_size;
static GtkIconSize gitg_repository_list_box_row_s_icon_size = 0;
static gpointer gitg_repository_list_box_clone_progress_parent_class = NULL;

GType gitg_selection_mode_get_type (void) G_GNUC_CONST;
GType gitg_repository_list_box_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_LIST_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxPrivate))
enum  {
	GITG_REPOSITORY_LIST_BOX_DUMMY_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_MODE,
	GITG_REPOSITORY_LIST_BOX_HAS_SELECTION
};
static gboolean gitg_repository_list_box_real_button_press_event (GtkWidget* base, GdkEventButton* event);
GitgSelectionMode gitg_repository_list_box_get_mode (GitgRepositoryListBox* self);
void gitg_repository_list_box_set_mode (GitgRepositoryListBox* self, GitgSelectionMode value);
static void gitg_repository_list_box_real_row_activated (GtkListBox* base, GtkListBoxRow* row);
GType gitg_repository_list_box_row_get_type (void) G_GNUC_CONST;
gboolean gitg_repository_list_box_row_get_selected (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_selected (GitgRepositoryListBoxRow* self, gboolean value);
GType gitg_repository_get_type (void) G_GNUC_CONST;
GitgRepository* gitg_repository_list_box_row_get_repository (GitgRepositoryListBoxRow* self);
static void gitg_repository_list_box_update_header (GitgRepositoryListBox* self, GtkListBoxRow* row, GtkListBoxRow* before);
static gboolean gitg_repository_list_box_filter (GitgRepositoryListBox* self, GtkListBoxRow* row);
const gchar* gitg_repository_list_box_row_get_repository_name (GitgRepositoryListBoxRow* self);
static gint gitg_repository_list_box_compare_widgets (GitgRepositoryListBox* self, GtkListBoxRow* a, GtkListBoxRow* b);
GDateTime* gitg_repository_list_box_row_get_time (GitgRepositoryListBoxRow* self);
static void gitg_repository_list_box_add_recent_info (GitgRepositoryListBox* self);
static void _gtk_recent_info_unref0_ (gpointer var);
static void _g_list_free__gtk_recent_info_unref0_ (GList* self);
GitgRepository* gitg_repository_new (GFile* location, GFile* workdir, GError** error);
GitgRepository* gitg_repository_construct (GType object_type, GFile* location, GFile* workdir, GError** error);
void gitg_repository_list_box_add_repository (GitgRepositoryListBox* self, GitgRepository* repository);
static GitgRepositoryListBoxRow* gitg_repository_list_box_get_row_for_repository (GitgRepositoryListBox* self, GitgRepository* repository);
static void gitg_repository_list_box_add_repository_to_recent_manager (GitgRepositoryListBox* self, const gchar* uri);
static void gtk_recent_data_destroy (GtkRecentData* self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
GType gitg_parsed_ref_name_get_type (void) G_GNUC_CONST;
GType gitg_ref_state_get_type (void) G_GNUC_CONST;
GType gitg_ref_get_type (void) G_GNUC_CONST;
GitgRef* gitg_repository_get_head (GitgRepository* self, GError** error);
GitgParsedRefName* gitg_ref_get_parsed_name (GitgRef* self);
gchar* gitg_parsed_ref_name_get_shortname (GitgParsedRefName* self);
gchar* gitg_repository_get_name (GitgRepository* self);
GitgRepositoryListBoxRow* gitg_repository_list_box_row_new (const gchar* name, const gchar* branch_name, gboolean has_remote);
GitgRepositoryListBoxRow* gitg_repository_list_box_row_construct (GType object_type, const gchar* name, const gchar* branch_name, gboolean has_remote);
void gitg_repository_list_box_row_set_repository (GitgRepositoryListBoxRow* self, GitgRepository* value);
static void ____lambda43_ (GitgRepositoryListBox* self);
static void _____lambda43__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ____lambda44_ (Block8Data* _data8_);
static void _____lambda44__gitg_repository_list_box_row_request_remove (GitgRepositoryListBoxRow* _sender, gpointer self);
void gitg_repository_list_box_row_set_can_remove (GitgRepositoryListBoxRow* self, gboolean value);
void gitg_repository_list_box_row_set_time (GitgRepositoryListBoxRow* self, GDateTime* value);
static void gitg_repository_list_box_clone_data_free (gpointer _data);
static void gitg_repository_list_box_clone (GitgRepositoryListBox* self, GitgRepositoryListBoxRow* row, const gchar* url, GFile* location, gboolean is_bare, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GitgRepository* gitg_repository_list_box_clone_finish (GitgRepositoryListBox* self, GAsyncResult* _res_);
static gboolean gitg_repository_list_box_clone_co (GitgRepositoryListBoxCloneData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static gboolean _gitg_repository_list_box_clone_co_gsource_func (gpointer self);
static void* __lambda45_ (Block9Data* _data9_);
static GitgRepositoryListBoxCloneProgress* gitg_repository_list_box_clone_progress_new (GitgRepositoryListBoxRow* row);
static GitgRepositoryListBoxCloneProgress* gitg_repository_list_box_clone_progress_construct (GType object_type, GitgRepositoryListBoxRow* row);
static GType gitg_repository_list_box_clone_progress_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _vala_GgitCloneOptions_free (GgitCloneOptions* self);
static gpointer ___lambda45__gthread_func (gpointer self);
void gitg_repository_list_box_clone_repository (GitgRepositoryListBox* self, const gchar* url, GFile* location, gboolean is_bare);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
void gitg_repository_list_box_row_set_loading (GitgRepositoryListBoxRow* self, gboolean value);
static void __lambda46_ (Block10Data* _data10_, GObject* obj, GAsyncResult* res);
static void ___lambda46__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void gitg_repository_list_box_filter_text (GitgRepositoryListBox* self, const gchar* text);
GitgRepositoryListBox* gitg_repository_list_box_new (void);
GitgRepositoryListBox* gitg_repository_list_box_construct (GType object_type);
GitgRepositoryListBoxRow** gitg_repository_list_box_get_selection (GitgRepositoryListBox* self, int* result_length1);
static void _vala_array_add2 (GitgRepositoryListBoxRow*** array, int* length, int* size, GitgRepositoryListBoxRow* value);
gboolean gitg_repository_list_box_get_has_selection (GitgRepositoryListBox* self);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * gitg_repository_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _gitg_repository_list_box_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
static gboolean _gitg_repository_list_box_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self);
static gint _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
GType gitg_progress_bin_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_LIST_BOX_ROW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowPrivate))
enum  {
	GITG_REPOSITORY_LIST_BOX_ROW_DUMMY_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_MODE,
	GITG_REPOSITORY_LIST_BOX_ROW_SELECTED,
	GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY,
	GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE,
	GITG_REPOSITORY_LIST_BOX_ROW_TIME,
	GITG_REPOSITORY_LIST_BOX_ROW_FRACTION,
	GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME,
	GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME,
	GITG_REPOSITORY_LIST_BOX_ROW_LOADING,
	GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE
};
GitgSelectionMode gitg_repository_list_box_row_get_mode (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_mode (GitgRepositoryListBoxRow* self, GitgSelectionMode value);
void gitg_repository_list_box_row_set_branch_name (GitgRepositoryListBoxRow* self, const gchar* value);
gboolean gitg_repository_list_box_row_get_can_remove (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_fraction (GitgRepositoryListBoxRow* self, gdouble value);
void gitg_progress_bin_set_fraction (GitgProgressBin* self, gdouble value);
void gitg_repository_list_box_row_set_repository_name (GitgRepositoryListBoxRow* self, const gchar* value);
const gchar* gitg_repository_list_box_row_get_branch_name (GitgRepositoryListBoxRow* self);
gboolean gitg_repository_list_box_row_get_loading (GitgRepositoryListBoxRow* self);
gboolean gitg_repository_list_box_row_get_has_remote (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_has_remote (GitgRepositoryListBoxRow* self, gboolean value);
static GObject * gitg_repository_list_box_row_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gitg_repository_list_box_row_finalize (GObject* obj);
static void _vala_gitg_repository_list_box_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_repository_list_box_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GITG_REPOSITORY_LIST_BOX_CLONE_PROGRESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS, GitgRepositoryListBoxCloneProgressPrivate))
enum  {
	GITG_REPOSITORY_LIST_BOX_CLONE_PROGRESS_DUMMY_PROPERTY
};
static gboolean gitg_repository_list_box_clone_progress_real_transfer_progress (GgitRemoteCallbacks* base, GgitTransferProgress* stats, GError** error);
static void gitg_repository_list_box_clone_progress_finalize (GObject* obj);
static void gitg_repository_list_box_finalize (GObject* obj);
static void _vala_gitg_repository_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_repository_list_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType gitg_selection_mode_get_type (void) {
	static volatile gsize gitg_selection_mode_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_selection_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{GITG_SELECTION_MODE_NORMAL, "GITG_SELECTION_MODE_NORMAL", "normal"}, {GITG_SELECTION_MODE_SELECTION, "GITG_SELECTION_MODE_SELECTION", "selection"}, {0, NULL, NULL}};
		GType gitg_selection_mode_type_id;
		gitg_selection_mode_type_id = g_enum_register_static ("GitgSelectionMode", values);
		g_once_init_leave (&gitg_selection_mode_type_id__volatile, gitg_selection_mode_type_id);
	}
	return gitg_selection_mode_type_id__volatile;
}


static gboolean gitg_repository_list_box_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GitgRepositoryListBox * self;
	gboolean result = FALSE;
	GdkEvent* ev = NULL;
	GdkEventButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GdkEvent* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GdkEventButton* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 197 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) base;
#line 197 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 199 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = event;
#line 199 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	ev = (GdkEvent*) _tmp0_;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = ev;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gdk_event_triggers_context_menu (_tmp2_);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp3_) {
#line 422 "gitg-repository-list-box.c"
		GitgSelectionMode _tmp4_ = 0;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->_mode;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = _tmp4_ == GITG_SELECTION_MODE_NORMAL;
#line 428 "gitg-repository-list-box.c"
	} else {
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = FALSE;
#line 432 "gitg-repository-list-box.c"
	}
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_) {
#line 203 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_set_mode (self, GITG_SELECTION_MODE_SELECTION);
#line 204 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		result = TRUE;
#line 204 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		return result;
#line 442 "gitg-repository-list-box.c"
	}
#line 207 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = event;
#line 207 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = GTK_WIDGET_CLASS (gitg_repository_list_box_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), _tmp5_);
#line 207 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp6_;
#line 207 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 452 "gitg-repository-list-box.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? g_object_ref (self) : NULL;
#line 459 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_real_row_activated (GtkListBox* base, GtkListBoxRow* row) {
	GitgRepositoryListBox * self;
	GitgRepositoryListBoxRow* r = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GitgSelectionMode _tmp2_ = 0;
	GitgRepositoryListBoxRow* _tmp7_ = NULL;
	GitgRepository* _tmp8_ = NULL;
	GitgRepository* _tmp9_ = NULL;
#line 210 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) base;
#line 210 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = row;
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	r = _tmp1_;
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->_mode;
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_ == GITG_SELECTION_MODE_SELECTION) {
#line 486 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* _tmp3_ = NULL;
		GitgRepositoryListBoxRow* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = r;
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = r;
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = gitg_repository_list_box_row_get_selected (_tmp4_);
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = _tmp5_;
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_selected (_tmp3_, !_tmp6_);
#line 217 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (r);
#line 217 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 505 "gitg-repository-list-box.c"
	}
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = r;
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = gitg_repository_list_box_row_get_repository (_tmp7_);
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = _tmp8_;
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp9_ != NULL) {
#line 515 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* _tmp10_ = NULL;
		GitgRepository* _tmp11_ = NULL;
		GitgRepository* _tmp12_ = NULL;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = r;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = gitg_repository_list_box_row_get_repository (_tmp10_);
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = _tmp11_;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_signal_emit_by_name (self, "repository-activated", _tmp12_);
#line 527 "gitg-repository-list-box.c"
	}
#line 210 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (r);
#line 531 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_update_header (GitgRepositoryListBox* self, GtkListBoxRow* row, GtkListBoxRow* before) {
	GtkSeparator* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
#line 238 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 238 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = before;
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ != NULL) {
#line 547 "gitg-repository-list-box.c"
		GtkSeparator* _tmp2_ = NULL;
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_ref_sink (_tmp2_);
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp0_);
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = _tmp2_;
#line 557 "gitg-repository-list-box.c"
	} else {
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp0_);
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = NULL;
#line 563 "gitg-repository-list-box.c"
	}
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = row;
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_row_set_header (_tmp3_, (GtkWidget*) _tmp0_);
#line 238 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp0_);
#line 571 "gitg-repository-list-box.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 591 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_filter (GitgRepositoryListBox* self, GtkListBoxRow* row) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 243 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 243 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (row != NULL, FALSE);
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_filter_text;
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ != NULL) {
#line 607 "gitg-repository-list-box.c"
		GtkListBoxRow* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = row;
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = gitg_repository_list_box_row_get_repository_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _tmp3_;
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_filter_text;
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = string_contains (_tmp4_, _tmp5_);
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = _tmp6_;
#line 625 "gitg-repository-list-box.c"
	} else {
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = TRUE;
#line 629 "gitg-repository-list-box.c"
	}
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 635 "gitg-repository-list-box.c"
}


static gint gitg_repository_list_box_compare_widgets (GitgRepositoryListBox* self, GtkListBoxRow* a, GtkListBoxRow* b) {
	gint result = 0;
	GtkListBoxRow* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
	GDateTime* _tmp4_ = NULL;
	GDateTime* _tmp5_ = NULL;
	gint _tmp6_ = 0;
#line 248 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 248 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 248 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 250 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = a;
#line 250 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gitg_repository_list_box_row_get_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 250 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _tmp1_;
#line 250 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = b;
#line 250 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = gitg_repository_list_box_row_get_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 250 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _tmp4_;
#line 250 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = g_date_time_compare (_tmp2_, _tmp5_);
#line 250 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = -_tmp6_;
#line 250 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 672 "gitg-repository-list-box.c"
}


static gpointer _gtk_recent_info_ref0 (gpointer self) {
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? gtk_recent_info_ref (self) : NULL;
#line 679 "gitg-repository-list-box.c"
}


static void _gtk_recent_info_unref0_ (gpointer var) {
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
#line 686 "gitg-repository-list-box.c"
}


static void _g_list_free__gtk_recent_info_unref0_ (GList* self) {
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_list_foreach (self, (GFunc) _gtk_recent_info_unref0_, NULL);
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_list_free (self);
#line 695 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_add_recent_info (GitgRepositoryListBox* self) {
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_ = NULL;
	GtkRecentManager* _tmp1_ = NULL;
	GList* reversed_items = NULL;
	GtkRecentManager* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 253 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 255 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_recent_manager_get_default ();
#line 255 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 255 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	recent_manager = _tmp1_;
#line 256 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = recent_manager;
#line 256 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gtk_recent_manager_get_items (_tmp2_);
#line 256 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	reversed_items = _tmp3_;
#line 257 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	reversed_items = g_list_reverse (reversed_items);
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = reversed_items;
#line 726 "gitg-repository-list-box.c"
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		item_collection = _tmp4_;
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
#line 734 "gitg-repository-list-box.c"
			GtkRecentInfo* _tmp5_ = NULL;
			GtkRecentInfo* item = NULL;
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) item_it->data);
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			item = _tmp5_;
#line 741 "gitg-repository-list-box.c"
			{
				GtkRecentInfo* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
#line 261 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = item;
#line 261 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp7_ = gtk_recent_info_has_group (_tmp6_, "gitg");
#line 261 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp7_) {
#line 751 "gitg-repository-list-box.c"
					GFile* info_file = NULL;
					GtkRecentInfo* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					GFile* _tmp10_ = NULL;
					GFile* repo_file = NULL;
					GitgRepository* repo = NULL;
					GitgRepository* _tmp25_ = NULL;
#line 263 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp8_ = item;
#line 263 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp9_ = gtk_recent_info_get_uri (_tmp8_);
#line 263 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp10_ = g_file_new_for_uri (_tmp9_);
#line 263 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					info_file = _tmp10_;
#line 767 "gitg-repository-list-box.c"
					{
						GFile* _tmp11_ = NULL;
						GFile* _tmp12_ = NULL;
						GFile* _tmp13_ = NULL;
						GFile* _tmp14_ = NULL;
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp12_ = info_file;
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp13_ = ggit_repository_discover (_tmp12_, &_inner_error_);
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp11_ = _tmp13_;
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 781 "gitg-repository-list-box.c"
							goto __catch36_g_error;
						}
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp14_ = _tmp11_;
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp11_ = NULL;
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						repo_file = _tmp14_;
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (_tmp11_);
#line 794 "gitg-repository-list-box.c"
					}
					goto __finally36;
					__catch36_g_error:
					{
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_inner_error_ = NULL;
#line 803 "gitg-repository-list-box.c"
						{
							GtkRecentManager* _tmp15_ = NULL;
							GtkRecentInfo* _tmp16_ = NULL;
							const gchar* _tmp17_ = NULL;
#line 274 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp15_ = recent_manager;
#line 274 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp16_ = item;
#line 274 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp17_ = gtk_recent_info_get_uri (_tmp16_);
#line 274 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_recent_manager_remove_item (_tmp15_, _tmp17_, &_inner_error_);
#line 274 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 818 "gitg-repository-list-box.c"
								goto __catch37_g_error;
							}
						}
						goto __finally37;
						__catch37_g_error:
						{
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_inner_error_ = NULL;
#line 829 "gitg-repository-list-box.c"
						}
						__finally37:
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (repo_file);
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (info_file);
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_gtk_recent_info_unref0 (item);
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (recent_manager);
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							return;
#line 850 "gitg-repository-list-box.c"
						}
#line 277 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 277 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (info_file);
#line 277 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 277 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 277 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (recent_manager);
#line 277 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 864 "gitg-repository-list-box.c"
					}
					__finally36:
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (info_file);
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (recent_manager);
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 885 "gitg-repository-list-box.c"
					}
					{
						GitgRepository* _tmp18_ = NULL;
						GFile* _tmp19_ = NULL;
						GitgRepository* _tmp20_ = NULL;
						GitgRepository* _tmp21_ = NULL;
#line 284 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp19_ = repo_file;
#line 284 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp20_ = gitg_repository_new (_tmp19_, NULL, &_inner_error_);
#line 284 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp18_ = _tmp20_;
#line 284 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 900 "gitg-repository-list-box.c"
							goto __catch38_g_error;
						}
#line 284 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp21_ = _tmp18_;
#line 284 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp18_ = NULL;
#line 284 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 284 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						repo = _tmp21_;
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (_tmp18_);
#line 913 "gitg-repository-list-box.c"
					}
					goto __finally38;
					__catch38_g_error:
					{
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_inner_error_ = NULL;
#line 922 "gitg-repository-list-box.c"
						{
							GtkRecentManager* _tmp22_ = NULL;
							GtkRecentInfo* _tmp23_ = NULL;
							const gchar* _tmp24_ = NULL;
#line 290 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp22_ = recent_manager;
#line 290 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp23_ = item;
#line 290 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp24_ = gtk_recent_info_get_uri (_tmp23_);
#line 290 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_recent_manager_remove_item (_tmp22_, _tmp24_, &_inner_error_);
#line 290 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 937 "gitg-repository-list-box.c"
								goto __catch39_g_error;
							}
						}
						goto __finally39;
						__catch39_g_error:
						{
#line 288 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 288 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_inner_error_ = NULL;
#line 948 "gitg-repository-list-box.c"
						}
						__finally39:
#line 288 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 288 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (repo);
#line 288 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (repo_file);
#line 288 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (info_file);
#line 288 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_gtk_recent_info_unref0 (item);
#line 288 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 288 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (recent_manager);
#line 288 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 288 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 288 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							return;
#line 971 "gitg-repository-list-box.c"
						}
#line 293 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 293 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 293 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (info_file);
#line 293 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 293 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 293 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (recent_manager);
#line 293 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 987 "gitg-repository-list-box.c"
					}
					__finally38:
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (info_file);
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (recent_manager);
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 1010 "gitg-repository-list-box.c"
					}
#line 296 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp25_ = repo;
#line 296 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					gitg_repository_list_box_add_repository (self, _tmp25_);
#line 261 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo);
#line 261 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo_file);
#line 261 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (info_file);
#line 1022 "gitg-repository-list-box.c"
				}
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_gtk_recent_info_unref0 (item);
#line 1026 "gitg-repository-list-box.c"
			}
		}
	}
#line 253 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 253 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (recent_manager);
#line 1034 "gitg-repository-list-box.c"
}


static GitgRepositoryListBoxRow* gitg_repository_list_box_get_row_for_repository (GitgRepositoryListBox* self, GitgRepository* repository) {
	GitgRepositoryListBoxRow* result = NULL;
	GitgRepositoryListBoxRow* row = NULL;
	GList* _tmp0_ = NULL;
#line 301 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 301 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (repository != NULL, NULL);
#line 303 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	row = NULL;
#line 305 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 1050 "gitg-repository-list-box.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 305 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		child_collection = _tmp0_;
#line 305 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 1058 "gitg-repository-list-box.c"
			GtkWidget* child = NULL;
#line 305 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			child = (GtkWidget*) child_it->data;
#line 1062 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* d = NULL;
				GtkWidget* _tmp1_ = NULL;
				GitgRepositoryListBoxRow* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				GitgRepository* _tmp4_ = NULL;
				GitgRepository* _tmp5_ = NULL;
				GFile* _tmp6_ = NULL;
				GFile* _tmp7_ = NULL;
				GitgRepository* _tmp8_ = NULL;
				GFile* _tmp9_ = NULL;
				GFile* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
#line 307 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp1_ = child;
#line 307 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 307 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				d = _tmp2_;
#line 309 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = d;
#line 309 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = gitg_repository_list_box_row_get_repository (_tmp3_);
#line 309 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = _tmp4_;
#line 309 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = ggit_repository_get_location ((GgitRepository*) _tmp5_);
#line 309 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp7_ = _tmp6_;
#line 309 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp8_ = repository;
#line 309 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp9_ = ggit_repository_get_location ((GgitRepository*) _tmp8_);
#line 309 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp10_ = _tmp9_;
#line 309 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp11_ = g_file_equal (_tmp7_, _tmp10_);
#line 309 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp12_ = _tmp11_;
#line 309 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (_tmp10_);
#line 309 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (_tmp7_);
#line 309 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp12_) {
#line 1109 "gitg-repository-list-box.c"
					GitgRepositoryListBoxRow* _tmp13_ = NULL;
					GitgRepositoryListBoxRow* _tmp14_ = NULL;
#line 311 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp13_ = d;
#line 311 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp14_ = _g_object_ref0 (_tmp13_);
#line 311 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (row);
#line 311 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					row = _tmp14_;
#line 312 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (d);
#line 312 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					break;
#line 1124 "gitg-repository-list-box.c"
				}
#line 305 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (d);
#line 1128 "gitg-repository-list-box.c"
			}
		}
#line 305 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (child_collection);
#line 1133 "gitg-repository-list-box.c"
	}
#line 316 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = row;
#line 316 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1139 "gitg-repository-list-box.c"
}


static void gtk_recent_data_destroy (GtkRecentData* self) {
#line 319 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).display_name);
#line 319 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).description);
#line 319 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).mime_type);
#line 319 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).app_name);
#line 319 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).app_exec);
#line 319 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	(*self).groups = (_vala_array_free ((*self).groups, _vala_array_length ((*self).groups), (GDestroyNotify) g_free), NULL);
#line 1156 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_add_repository_to_recent_manager (GitgRepositoryListBox* self, const gchar* uri) {
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_ = NULL;
	GtkRecentManager* _tmp1_ = NULL;
	GtkRecentData item = {0};
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkRecentData _tmp10_ = {0};
#line 319 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 319 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (uri != NULL);
#line 321 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_recent_manager_get_default ();
#line 321 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 321 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	recent_manager = _tmp1_;
#line 322 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	memset (&item, 0, sizeof (GtkRecentData));
#line 323 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = g_get_application_name ();
#line 323 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 323 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.app_name);
#line 323 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	item.app_name = _tmp3_;
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = g_strdup ("inode/directory");
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.mime_type);
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	item.mime_type = _tmp4_;
#line 325 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = g_get_prgname ();
#line 325 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = g_strjoin (" ", _tmp5_, "%f", NULL);
#line 325 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.app_exec);
#line 325 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	item.app_exec = _tmp6_;
#line 326 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = g_strdup ("gitg");
#line 326 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = g_new0 (gchar*, 2 + 1);
#line 326 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_[0] = _tmp7_;
#line 326 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_[1] = NULL;
#line 326 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	item.groups = (_vala_array_free (item.groups, _vala_array_length (item.groups), (GDestroyNotify) g_free), NULL);
#line 326 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	item.groups = _tmp8_;
#line 327 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = uri;
#line 327 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = item;
#line 327 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_recent_manager_add_full (recent_manager, _tmp9_, &_tmp10_);
#line 319 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_recent_data_destroy (&item);
#line 319 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (recent_manager);
#line 1230 "gitg-repository-list-box.c"
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return _data8_;
#line 1239 "gitg-repository-list-box.c"
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 1248 "gitg-repository-list-box.c"
		GitgRepositoryListBox* self;
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		self = _data8_->self;
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data8_->f);
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data8_->row);
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (self);
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_slice_free (Block8Data, _data8_);
#line 1260 "gitg-repository-list-box.c"
	}
}


static void ____lambda43_ (GitgRepositoryListBox* self) {
#line 367 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject*) self, "has-selection");
#line 1268 "gitg-repository-list-box.c"
}


static void _____lambda43__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 366 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	____lambda43_ ((GitgRepositoryListBox*) self);
#line 1275 "gitg-repository-list-box.c"
}


static void ____lambda44_ (Block8Data* _data8_) {
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 370 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = _data8_->self;
#line 1285 "gitg-repository-list-box.c"
	{
		GtkRecentManager* recent_manager = NULL;
		GtkRecentManager* _tmp0_ = NULL;
		GtkRecentManager* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 373 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = gtk_recent_manager_get_default ();
#line 373 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 373 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		recent_manager = _tmp1_;
#line 374 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _data8_->f;
#line 374 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = g_file_get_uri (_tmp2_);
#line 374 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _tmp3_;
#line 374 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_recent_manager_remove_item (recent_manager, _tmp4_, &_inner_error_);
#line 374 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp4_);
#line 374 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 374 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (recent_manager);
#line 1313 "gitg-repository-list-box.c"
			goto __catch41_g_error;
		}
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (recent_manager);
#line 1318 "gitg-repository-list-box.c"
	}
	goto __finally41;
	__catch41_g_error:
	{
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 1327 "gitg-repository-list-box.c"
	}
	__finally41:
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 1338 "gitg-repository-list-box.c"
	}
#line 377 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _data8_->row;
#line 377 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _tmp5_);
#line 1344 "gitg-repository-list-box.c"
}


static void _____lambda44__gitg_repository_list_box_row_request_remove (GitgRepositoryListBoxRow* _sender, gpointer self) {
#line 370 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	____lambda44_ (self);
#line 1351 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_add_repository (GitgRepositoryListBox* self, GitgRepository* repository) {
	Block8Data* _data8_;
	GitgRepository* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GitgRepository* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GFile* _tmp14_ = NULL;
	GitgRepositoryListBoxRow* _tmp15_ = NULL;
	GFile* _tmp50_ = NULL;
	GError * _inner_error_ = NULL;
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (repository != NULL);
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data8_->_ref_count_ = 1;
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data8_->self = g_object_ref (self);
#line 332 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = repository;
#line 332 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gitg_repository_list_box_get_row_for_repository (self, _tmp0_);
#line 332 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data8_->row = _tmp1_;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = repository;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_get ((GgitRepository*) _tmp3_, "workdir", &_tmp4_, NULL);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _tmp4_;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = _tmp5_;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = _tmp6_ != NULL;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp6_);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp7_) {
#line 1399 "gitg-repository-list-box.c"
		GitgRepository* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = repository;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_get ((GgitRepository*) _tmp8_, "workdir", &_tmp9_, NULL);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = _tmp9_;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp2_);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _tmp10_;
#line 1413 "gitg-repository-list-box.c"
	} else {
		GitgRepository* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = repository;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = ggit_repository_get_location ((GgitRepository*) _tmp11_);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = _tmp12_;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp2_);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _tmp13_;
#line 1428 "gitg-repository-list-box.c"
	}
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp14_ = _g_object_ref0 (_tmp2_);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data8_->f = _tmp14_;
#line 336 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp15_ = _data8_->row;
#line 336 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp15_ == NULL) {
#line 1438 "gitg-repository-list-box.c"
		gchar* head_name = NULL;
		gchar* _tmp16_ = NULL;
		gboolean has_remote = FALSE;
		GitgRepository* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		GitgRepositoryListBoxRow* _tmp35_ = NULL;
		GitgRepositoryListBoxRow* _tmp36_ = NULL;
		GitgRepository* _tmp37_ = NULL;
		GitgRepositoryListBoxRow* _tmp38_ = NULL;
		GFile* _tmp39_ = NULL;
		GFile* _tmp41_ = NULL;
		GitgRepositoryListBoxRow* _tmp46_ = NULL;
#line 338 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp16_ = g_strdup ("");
#line 338 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		head_name = _tmp16_;
#line 339 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		has_remote = TRUE;
#line 1461 "gitg-repository-list-box.c"
		{
			GitgRef* head = NULL;
			GitgRepository* _tmp17_ = NULL;
			GitgRef* _tmp18_ = NULL;
			GitgRef* _tmp19_ = NULL;
			GitgParsedRefName* _tmp20_ = NULL;
			GitgParsedRefName* _tmp21_ = NULL;
			GitgParsedRefName* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar** remotes = NULL;
			GitgRepository* _tmp25_ = NULL;
			gchar** _tmp26_ = NULL;
			gchar** _tmp27_ = NULL;
			gint remotes_length1 = 0;
			gint _remotes_size_ = 0;
			gchar** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
#line 343 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp17_ = repository;
#line 343 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp18_ = gitg_repository_get_head (_tmp17_, &_inner_error_);
#line 343 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			head = _tmp18_;
#line 343 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1488 "gitg-repository-list-box.c"
				goto __catch40_g_error;
			}
#line 344 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp19_ = head;
#line 344 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp20_ = gitg_ref_get_parsed_name (_tmp19_);
#line 344 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp21_ = _tmp20_;
#line 344 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp22_ = _tmp21_;
#line 344 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp23_ = gitg_parsed_ref_name_get_shortname (_tmp22_);
#line 344 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp24_ = _tmp23_;
#line 344 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_name);
#line 344 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			head_name = _tmp24_;
#line 344 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp22_);
#line 345 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp25_ = repository;
#line 345 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp27_ = _tmp26_ = ggit_repository_list_remotes ((GgitRepository*) _tmp25_, &_inner_error_);
#line 345 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			remotes = _tmp27_;
#line 345 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			remotes_length1 = _vala_array_length (_tmp26_);
#line 345 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_remotes_size_ = remotes_length1;
#line 345 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 345 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (head);
#line 1523 "gitg-repository-list-box.c"
				goto __catch40_g_error;
			}
#line 346 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp28_ = remotes;
#line 346 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp28__length1 = remotes_length1;
#line 346 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			if (_tmp28__length1 == 0) {
#line 348 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				has_remote = FALSE;
#line 1534 "gitg-repository-list-box.c"
			}
#line 341 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			remotes = (_vala_array_free (remotes, remotes_length1, (GDestroyNotify) g_free), NULL);
#line 341 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (head);
#line 1540 "gitg-repository-list-box.c"
		}
		goto __finally40;
		__catch40_g_error:
		{
#line 341 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 341 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_inner_error_ = NULL;
#line 1549 "gitg-repository-list-box.c"
		}
		__finally40:
#line 341 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 341 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_name);
#line 341 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp2_);
#line 341 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			block8_data_unref (_data8_);
#line 341 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_data8_ = NULL;
#line 341 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 341 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 341 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			return;
#line 1568 "gitg-repository-list-box.c"
		}
#line 353 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp29_ = repository;
#line 353 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp30_ = gitg_repository_get_name (_tmp29_);
#line 353 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp31_ = _tmp30_;
#line 353 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp32_ = _tmp31_;
#line 353 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp33_ = head_name;
#line 353 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp34_ = has_remote;
#line 353 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp35_ = gitg_repository_list_box_row_new (_tmp32_, _tmp33_, _tmp34_);
#line 353 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_ref_sink (_tmp35_);
#line 353 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data8_->row);
#line 353 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data8_->row = _tmp35_;
#line 353 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp32_);
#line 354 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp36_ = _data8_->row;
#line 354 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp37_ = repository;
#line 354 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository (_tmp36_, _tmp37_);
#line 355 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp38_ = _data8_->row;
#line 355 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp38_);
#line 357 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp39_ = _data8_->f;
#line 357 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp39_ != NULL) {
#line 1606 "gitg-repository-list-box.c"
			GitgRepositoryListBoxRow* _tmp40_ = NULL;
#line 359 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp40_ = _data8_->row;
#line 359 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_object_bind_property_with_closures ((GObject*) self, "mode", (GObject*) _tmp40_, "mode", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 1612 "gitg-repository-list-box.c"
		}
#line 364 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp41_ = _data8_->f;
#line 364 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp41_ != NULL) {
#line 1618 "gitg-repository-list-box.c"
			GitgRepositoryListBoxRow* _tmp42_ = NULL;
			GitgRepositoryListBoxRow* _tmp43_ = NULL;
			GitgRepositoryListBoxRow* _tmp44_ = NULL;
#line 366 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp42_ = _data8_->row;
#line 366 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_signal_connect_object ((GObject*) _tmp42_, "notify::selected", (GCallback) _____lambda43__g_object_notify, self, 0);
#line 370 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp43_ = _data8_->row;
#line 370 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_signal_connect_data (_tmp43_, "request-remove", (GCallback) _____lambda44__gitg_repository_list_box_row_request_remove, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
#line 380 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp44_ = _data8_->row;
#line 380 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_can_remove (_tmp44_, TRUE);
#line 1634 "gitg-repository-list-box.c"
		} else {
			GitgRepositoryListBoxRow* _tmp45_ = NULL;
#line 384 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp45_ = _data8_->row;
#line 384 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_can_remove (_tmp45_, FALSE);
#line 1641 "gitg-repository-list-box.c"
		}
#line 387 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp46_ = _data8_->row;
#line 387 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp46_);
#line 336 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (head_name);
#line 1649 "gitg-repository-list-box.c"
	} else {
		GitgRepositoryListBoxRow* _tmp47_ = NULL;
		GDateTime* _tmp48_ = NULL;
		GDateTime* _tmp49_ = NULL;
#line 392 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp47_ = _data8_->row;
#line 392 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp48_ = g_date_time_new_now_local ();
#line 392 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp49_ = _tmp48_;
#line 392 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_time (_tmp47_, _tmp49_);
#line 392 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_date_time_unref0 (_tmp49_);
#line 393 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_list_box_invalidate_sort ((GtkListBox*) self);
#line 1666 "gitg-repository-list-box.c"
	}
#line 396 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp50_ = _data8_->f;
#line 396 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp50_ != NULL) {
#line 1672 "gitg-repository-list-box.c"
		GFile* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
#line 398 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp51_ = _data8_->f;
#line 398 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp52_ = g_file_get_uri (_tmp51_);
#line 398 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp53_ = _tmp52_;
#line 398 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_add_repository_to_recent_manager (self, _tmp53_);
#line 398 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp53_);
#line 1686 "gitg-repository-list-box.c"
	}
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp2_);
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	block8_data_unref (_data8_);
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data8_ = NULL;
#line 1694 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_clone_data_free (gpointer _data) {
	GitgRepositoryListBoxCloneData* _data_;
	_data_ = _data;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_data_->result);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_data_->self);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_slice_free (GitgRepositoryListBoxCloneData, _data_);
#line 1707 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_clone (GitgRepositoryListBox* self, GitgRepositoryListBoxRow* row, const gchar* url, GFile* location, gboolean is_bare, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgRepositoryListBoxCloneData* _data_;
	GitgRepositoryListBox* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GitgRepositoryListBoxRow* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_ = g_slice_new0 (GitgRepositoryListBoxCloneData);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_repository_list_box_clone);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_repository_list_box_clone_data_free);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->self = _tmp0_;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = row;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_data_->row);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->row = _tmp2_;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = url;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_data_->url);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->url = _tmp4_;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = location;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_data_->location);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->location = _tmp6_;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = is_bare;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->is_bare = _tmp7_;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_clone_co (_data_);
#line 1761 "gitg-repository-list-box.c"
}


static GitgRepository* gitg_repository_list_box_clone_finish (GitgRepositoryListBox* self, GAsyncResult* _res_) {
	GitgRepository* result;
	GitgRepositoryListBoxCloneData* _data_;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _data_->result;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->result = NULL;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1776 "gitg-repository-list-box.c"
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return _data9_;
#line 1785 "gitg-repository-list-box.c"
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 1794 "gitg-repository-list-box.c"
		GitgRepositoryListBox* self;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		self = _data9_->self;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data9_->repository);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		(_data9_->callback_target_destroy_notify == NULL) ? NULL : (_data9_->callback_target_destroy_notify (_data9_->callback_target), NULL);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data9_->callback = NULL;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data9_->callback_target = NULL;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data9_->callback_target_destroy_notify = NULL;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data9_->row);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_data9_->url);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data9_->location);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (self);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_slice_free (Block9Data, _data9_);
#line 1818 "gitg-repository-list-box.c"
	}
}


static gboolean _gitg_repository_list_box_clone_co_gsource_func (gpointer self) {
	gboolean result;
	result = gitg_repository_list_box_clone_co (self);
#line 462 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1828 "gitg-repository-list-box.c"
}


static void _vala_GgitCloneOptions_free (GgitCloneOptions* self) {
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_boxed_free (ggit_clone_options_get_type (), self);
#line 1835 "gitg-repository-list-box.c"
}


static void* __lambda45_ (Block9Data* _data9_) {
	GitgRepositoryListBox* self;
	void* result = NULL;
	GSourceFunc _tmp17_ = NULL;
	void* _tmp17__target = NULL;
	GDestroyNotify _tmp17__target_destroy_notify = NULL;
	GError * _inner_error_ = NULL;
#line 465 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = _data9_->self;
#line 1848 "gitg-repository-list-box.c"
	{
		GgitCloneOptions* options = NULL;
		GgitCloneOptions* _tmp0_ = NULL;
		GgitCloneOptions* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		GgitCloneOptions* _tmp3_ = NULL;
		GitgRepositoryListBoxRow* _tmp4_ = NULL;
		GitgRepositoryListBoxCloneProgress* _tmp5_ = NULL;
		GitgRepositoryListBoxCloneProgress* _tmp6_ = NULL;
		GgitRepository* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		GgitCloneOptions* _tmp10_ = NULL;
		GgitRepository* _tmp11_ = NULL;
		GgitRepository* _tmp12_ = NULL;
#line 468 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = ggit_clone_options_new ();
#line 468 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		options = _tmp0_;
#line 470 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = options;
#line 470 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _data9_->is_bare;
#line 470 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		ggit_clone_options_set_is_bare (_tmp1_, _tmp2_);
#line 471 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = options;
#line 471 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _data9_->row;
#line 471 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = gitg_repository_list_box_clone_progress_new (_tmp4_);
#line 471 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = _tmp5_;
#line 471 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		ggit_clone_options_set_remote_callbacks (_tmp3_, (GgitRemoteCallbacks*) _tmp6_);
#line 471 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp6_);
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = _data9_->url;
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = _data9_->location;
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = options;
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = ggit_repository_clone (_tmp8_, _tmp9_, _tmp10_, &_inner_error_);
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = _tmp11_;
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			__vala_GgitCloneOptions_free0 (options);
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			if (_inner_error_->domain == GGIT_ERROR) {
#line 1902 "gitg-repository-list-box.c"
				goto __catch42_ggit_error;
			}
			goto __catch42_g_error;
		}
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = _tmp7_;
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = NULL;
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data9_->repository);
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data9_->repository = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GITG_TYPE_REPOSITORY, GitgRepository);
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp7_);
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		__vala_GgitCloneOptions_free0 (options);
#line 1919 "gitg-repository-list-box.c"
	}
	goto __finally42;
	__catch42_ggit_error:
	{
		GError* e = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		e = _inner_error_;
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 477 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = e;
#line 477 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp14_ = _tmp13_->message;
#line 477 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_signal_emit_by_name (self, "show-error", "Gitg could not clone the git repository.", _tmp14_);
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_error_free0 (e);
#line 1939 "gitg-repository-list-box.c"
	}
	goto __finally42;
	__catch42_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		e = _inner_error_;
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 481 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp15_ = e;
#line 481 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp16_ = _tmp15_->message;
#line 481 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_signal_emit_by_name (self, "show-error", "Gitg could not clone the git repository.", _tmp16_);
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_error_free0 (e);
#line 1959 "gitg-repository-list-box.c"
	}
	__finally42:
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		return NULL;
#line 1970 "gitg-repository-list-box.c"
	}
#line 484 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp17_ = _data9_->callback;
#line 484 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp17__target = _data9_->callback_target;
#line 484 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp17__target_destroy_notify = _data9_->callback_target_destroy_notify;
#line 484 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data9_->callback_target_destroy_notify = NULL;
#line 484 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp17_, _tmp17__target, _tmp17__target_destroy_notify);
#line 485 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = NULL;
#line 485 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1986 "gitg-repository-list-box.c"
}


static gpointer ___lambda45__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda45_ (self);
#line 465 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	block9_data_unref (self);
#line 465 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1997 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_clone_co (GitgRepositoryListBoxCloneData* _data_) {
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	switch (_data_->_state_) {
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case 0:
#line 2006 "gitg-repository-list-box.c"
		goto _state_0;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case 1:
#line 2010 "gitg-repository-list-box.c"
		goto _state_1;
		default:
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_assert_not_reached ();
#line 2015 "gitg-repository-list-box.c"
	}
	_state_0:
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data9_ = g_slice_new0 (Block9Data);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data9_->_ref_count_ = 1;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data9_->self = g_object_ref (_data_->self);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp0_ = NULL;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp0_ = _data_->row;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_data_->_data9_->row);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data9_->row = _data_->_tmp0_;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp1_ = NULL;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp1_ = _data_->url;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_data_->_data9_->url);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data9_->url = _data_->_tmp1_;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp2_ = NULL;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp2_ = _data_->location;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_data_->_data9_->location);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data9_->location = _data_->_tmp2_;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp3_ = FALSE;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp3_ = _data_->is_bare;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data9_->is_bare = _data_->_tmp3_;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data9_->_async_data_ = _data_;
#line 462 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data9_->callback = _gitg_repository_list_box_clone_co_gsource_func;
#line 462 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data9_->callback_target = _data_;
#line 462 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data9_->callback_target_destroy_notify = NULL;
#line 463 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data9_->repository = NULL;
#line 465 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->run_target = NULL;
#line 465 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->run_target_destroy_notify = NULL;
#line 465 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->run = ___lambda45__gthread_func;
#line 465 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->run_target = block9_data_ref (_data_->_data9_);
#line 465 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->run_target_destroy_notify = block9_data_unref;
#line 2074 "gitg-repository-list-box.c"
	{
#line 490 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp4_ = NULL;
#line 490 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp4__target = NULL;
#line 490 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp4__target_destroy_notify = NULL;
#line 490 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp4_ = _data_->run;
#line 490 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp4__target = _data_->run_target;
#line 490 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp4__target_destroy_notify = _data_->run_target_destroy_notify;
#line 490 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->run_target_destroy_notify = NULL;
#line 490 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp5_ = NULL;
#line 490 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp5_ = g_thread_try_new ("gitg-clone-thread", _data_->_tmp4_, _data_->_tmp4__target, &_data_->_inner_error_);
#line 490 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp6_ = NULL;
#line 490 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 490 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_thread_unref0 (_data_->_tmp6_);
#line 490 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 2102 "gitg-repository-list-box.c"
			goto __catch43_g_error;
		}
#line 491 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_state_ = 1;
#line 491 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		return FALSE;
#line 2109 "gitg-repository-list-box.c"
		_state_1:
		;
	}
	goto __finally43;
	__catch43_g_error:
	{
#line 488 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_data_->_inner_error_);
#line 488 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_inner_error_ = NULL;
#line 2120 "gitg-repository-list-box.c"
	}
	__finally43:
#line 488 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 488 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		block9_data_unref (_data_->_data9_);
#line 488 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_data9_ = NULL;
#line 488 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 488 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_data_->_inner_error_);
#line 488 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		return FALSE;
#line 2135 "gitg-repository-list-box.c"
	}
#line 495 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp7_ = NULL;
#line 495 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp7_ = _g_object_ref0 (_data_->_data9_->repository);
#line 495 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->result = _data_->_tmp7_;
#line 495 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	block9_data_unref (_data_->_data9_);
#line 495 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data9_ = NULL;
#line 495 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_data_->_state_ == 0) {
#line 495 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2151 "gitg-repository-list-box.c"
	} else {
#line 495 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2155 "gitg-repository-list-box.c"
	}
#line 495 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_unref (_data_->_async_result);
#line 495 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return FALSE;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	block9_data_unref (_data_->_data9_);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data9_ = NULL;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_data_->_state_ == 0) {
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2169 "gitg-repository-list-box.c"
	} else {
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2173 "gitg-repository-list-box.c"
	}
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_unref (_data_->_async_result);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return FALSE;
#line 2179 "gitg-repository-list-box.c"
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_atomic_int_inc (&_data10_->_ref_count_);
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return _data10_;
#line 2188 "gitg-repository-list-box.c"
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
#line 2197 "gitg-repository-list-box.c"
		GitgRepositoryListBox* self;
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		self = _data10_->self;
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data10_->row);
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (self);
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_slice_free (Block10Data, _data10_);
#line 2207 "gitg-repository-list-box.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 2231 "gitg-repository-list-box.c"
		glong _tmp4_ = 0L;
#line 1199 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 2239 "gitg-repository-list-box.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 2251 "gitg-repository-list-box.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2275 "gitg-repository-list-box.c"
		glong _tmp2_ = 0L;
#line 1210 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2281 "gitg-repository-list-box.c"
	} else {
#line 1210 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2285 "gitg-repository-list-box.c"
	}
#line 1210 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 2289 "gitg-repository-list-box.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 2301 "gitg-repository-list-box.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 2311 "gitg-repository-list-box.c"
	}
#line 1217 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 2317 "gitg-repository-list-box.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 2331 "gitg-repository-list-box.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 2341 "gitg-repository-list-box.c"
	}
#line 1223 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 2347 "gitg-repository-list-box.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 2356 "gitg-repository-list-box.c"
	}
#line 1226 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 2376 "gitg-repository-list-box.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 930 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 931 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 931 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 931 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 931 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 933 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 933 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 2401 "gitg-repository-list-box.c"
		gchar* _tmp4_ = NULL;
#line 934 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 934 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 934 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 2409 "gitg-repository-list-box.c"
	} else {
#line 936 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		result = -1;
#line 936 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 2415 "gitg-repository-list-box.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1230 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1231 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1231 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1231 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1232 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1232 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 2449 "gitg-repository-list-box.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1233 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1233 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1233 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 2458 "gitg-repository-list-box.c"
	}
#line 1235 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1235 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 2464 "gitg-repository-list-box.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1236 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1236 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1236 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 2473 "gitg-repository-list-box.c"
	}
#line 1238 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1238 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 2479 "gitg-repository-list-box.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1238 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1238 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1238 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 2488 "gitg-repository-list-box.c"
	} else {
#line 1238 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 2492 "gitg-repository-list-box.c"
	}
#line 1238 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1239 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1239 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 2500 "gitg-repository-list-box.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1239 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1239 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1239 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 2509 "gitg-repository-list-box.c"
	} else {
#line 1239 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 2513 "gitg-repository-list-box.c"
	}
#line 1239 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1240 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1240 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1240 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1241 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1241 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1241 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1241 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1241 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1241 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 2535 "gitg-repository-list-box.c"
}


static void __lambda46_ (Block10Data* _data10_, GObject* obj, GAsyncResult* res) {
	GitgRepositoryListBox* self;
	GitgRepository* repository = NULL;
	GAsyncResult* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
	GitgRepository* _tmp2_ = NULL;
	GitgRepositoryListBoxRow* _tmp15_ = NULL;
	GitgRepository* _tmp16_ = NULL;
	GitgRepositoryListBoxRow* _tmp17_ = NULL;
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = _data10_->self;
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (res != NULL);
#line 530 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = res;
#line 530 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gitg_repository_list_box_clone_finish (self, _tmp0_);
#line 530 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	repository = _tmp1_;
#line 533 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = repository;
#line 533 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_ != NULL) {
#line 2562 "gitg-repository-list-box.c"
		GFile* workdir = NULL;
		GitgRepository* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFile* repo_file = NULL;
		GitgRepository* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		gchar* uri = NULL;
		gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 535 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = repository;
#line 535 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = ggit_repository_get_workdir ((GgitRepository*) _tmp3_);
#line 535 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		workdir = _tmp4_;
#line 536 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = repository;
#line 536 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = ggit_repository_get_location ((GgitRepository*) _tmp5_);
#line 536 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		repo_file = _tmp6_;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = workdir;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp8_ != NULL) {
#line 2590 "gitg-repository-list-box.c"
			GFile* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp9_ = workdir;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = g_file_get_uri (_tmp9_);
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp7_);
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp7_ = _tmp10_;
#line 2601 "gitg-repository-list-box.c"
		} else {
			GFile* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp11_ = repo_file;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp12_ = g_file_get_uri (_tmp11_);
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp7_);
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp7_ = _tmp12_;
#line 2613 "gitg-repository-list-box.c"
		}
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = g_strdup (_tmp7_);
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		uri = _tmp13_;
#line 538 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp14_ = uri;
#line 538 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_add_repository_to_recent_manager (self, _tmp14_);
#line 533 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (uri);
#line 533 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp7_);
#line 533 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (repo_file);
#line 533 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (workdir);
#line 2631 "gitg-repository-list-box.c"
	}
#line 541 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp15_ = _data10_->row;
#line 541 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp16_ = repository;
#line 541 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_repository (_tmp15_, _tmp16_);
#line 542 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp17_ = _data10_->row;
#line 542 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_loading (_tmp17_, FALSE);
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (repository);
#line 2645 "gitg-repository-list-box.c"
}


static void ___lambda46__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	__lambda46_ (self, source_object, res);
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	block10_data_unref (self);
#line 2654 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_clone_repository (GitgRepositoryListBox* self, const gchar* url, GFile* location, gboolean is_bare) {
	Block10Data* _data10_;
	gchar* subfolder_name = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GFile* subfolder = NULL;
	GFile* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GFile* _tmp17_ = NULL;
	const gchar* _tmp21_ = NULL;
	GitgRepositoryListBoxRow* _tmp22_ = NULL;
	GitgRepositoryListBoxRow* _tmp23_ = NULL;
	GitgRepositoryListBoxRow* _tmp24_ = NULL;
	GitgRepositoryListBoxRow* _tmp25_ = NULL;
	GitgRepositoryListBoxRow* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GFile* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	GError * _inner_error_ = NULL;
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (url != NULL);
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (location != NULL);
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data10_ = g_slice_new0 (Block10Data);
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data10_->_ref_count_ = 1;
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data10_->self = g_object_ref (self);
#line 501 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = url;
#line 501 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = url;
#line 501 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = string_last_index_of_char (_tmp1_, (gunichar) '/', 0);
#line 501 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = string_substring (_tmp0_, (glong) (_tmp2_ + 1), (glong) (-1));
#line 501 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	subfolder_name = _tmp3_;
#line 502 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = subfolder_name;
#line 502 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = g_str_has_suffix (_tmp5_, ".git");
#line 502 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp6_) {
#line 2710 "gitg-repository-list-box.c"
		gboolean _tmp7_ = FALSE;
#line 502 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = is_bare;
#line 502 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = !_tmp7_;
#line 2716 "gitg-repository-list-box.c"
	} else {
#line 502 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = FALSE;
#line 2720 "gitg-repository-list-box.c"
	}
#line 502 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp4_) {
#line 2724 "gitg-repository-list-box.c"
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gchar* _tmp11_ = NULL;
#line 504 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = subfolder_name;
#line 504 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = strlen (".git");
#line 504 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = _tmp9_;
#line 504 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = string_slice (_tmp8_, (glong) 0, (glong) (-_tmp10_));
#line 504 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (subfolder_name);
#line 504 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		subfolder_name = _tmp11_;
#line 2741 "gitg-repository-list-box.c"
	} else {
		gboolean _tmp12_ = FALSE;
#line 506 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = is_bare;
#line 506 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp12_) {
#line 2748 "gitg-repository-list-box.c"
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
#line 508 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp13_ = subfolder_name;
#line 508 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp14_ = g_strconcat (_tmp13_, ".git", NULL);
#line 508 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (subfolder_name);
#line 508 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			subfolder_name = _tmp14_;
#line 2759 "gitg-repository-list-box.c"
		}
	}
#line 511 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp15_ = location;
#line 511 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp16_ = subfolder_name;
#line 511 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp17_ = g_file_resolve_relative_path (_tmp15_, _tmp16_);
#line 511 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	subfolder = _tmp17_;
#line 2770 "gitg-repository-list-box.c"
	{
		GFile* _tmp18_ = NULL;
#line 515 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp18_ = subfolder;
#line 515 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_file_make_directory_with_parents (_tmp18_, NULL, &_inner_error_);
#line 515 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2779 "gitg-repository-list-box.c"
			goto __catch44_g_error;
		}
	}
	goto __finally44;
	__catch44_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		e = _inner_error_;
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 519 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp19_ = e;
#line 519 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp20_ = _tmp19_->message;
#line 519 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_signal_emit_by_name (self, "show-error", "Gitg could not clone the git repository.", _tmp20_);
#line 520 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_error_free0 (e);
#line 520 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (subfolder);
#line 520 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (subfolder_name);
#line 520 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		block10_data_unref (_data10_);
#line 520 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data10_ = NULL;
#line 520 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 2811 "gitg-repository-list-box.c"
	}
	__finally44:
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (subfolder);
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (subfolder_name);
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		block10_data_unref (_data10_);
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data10_ = NULL;
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 2830 "gitg-repository-list-box.c"
	}
#line 524 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp21_ = subfolder_name;
#line 524 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp22_ = gitg_repository_list_box_row_new (_tmp21_, "Cloning...", TRUE);
#line 524 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp22_);
#line 524 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data10_->row = _tmp22_;
#line 525 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp23_ = _data10_->row;
#line 525 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_loading (_tmp23_, TRUE);
#line 526 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp24_ = _data10_->row;
#line 526 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) _tmp24_);
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp25_ = _data10_->row;
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp25_);
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp26_ = _data10_->row;
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp27_ = url;
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp28_ = subfolder;
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp29_ = is_bare;
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_clone (self, _tmp26_, _tmp27_, _tmp28_, _tmp29_, ___lambda46__gasync_ready_callback, block10_data_ref (_data10_));
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (subfolder);
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (subfolder_name);
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	block10_data_unref (_data10_);
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data10_ = NULL;
#line 2870 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_filter_text (GitgRepositoryListBox* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 546 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = text;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_filter_text);
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_filter_text = _tmp1_;
#line 550 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_invalidate_filter ((GtkListBox*) self);
#line 2889 "gitg-repository-list-box.c"
}


GitgRepositoryListBox* gitg_repository_list_box_construct (GType object_type) {
	GitgRepositoryListBox * self = NULL;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) g_object_new (object_type, NULL);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return self;
#line 2899 "gitg-repository-list-box.c"
}


GitgRepositoryListBox* gitg_repository_list_box_new (void) {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return gitg_repository_list_box_construct (GITG_TYPE_REPOSITORY_LIST_BOX);
#line 2906 "gitg-repository-list-box.c"
}


GitgSelectionMode gitg_repository_list_box_get_mode (GitgRepositoryListBox* self) {
	GitgSelectionMode result;
	GitgSelectionMode _tmp0_ = 0;
#line 195 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 195 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->_mode;
#line 195 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 195 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2921 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_set_mode (GitgRepositoryListBox* self, GitgSelectionMode value) {
	GitgSelectionMode _tmp0_ = 0;
#line 195 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 195 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 195 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->_mode = _tmp0_;
#line 195 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "mode");
#line 2935 "gitg-repository-list-box.c"
}


static void _vala_array_add2 (GitgRepositoryListBoxRow*** array, int* length, int* size, GitgRepositoryListBoxRow* value) {
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if ((*length) == (*size)) {
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		*array = g_renew (GitgRepositoryListBoxRow*, *array, (*size) + 1);
#line 2946 "gitg-repository-list-box.c"
	}
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	(*array)[(*length)++] = value;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	(*array)[*length] = NULL;
#line 2952 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow** gitg_repository_list_box_get_selection (GitgRepositoryListBox* self, int* result_length1) {
	GitgRepositoryListBoxRow** result;
	GitgRepositoryListBoxRow** ret = NULL;
	GitgRepositoryListBoxRow** _tmp0_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	GList* _tmp1_ = NULL;
	GitgRepositoryListBoxRow** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
#line 404 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 406 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = g_new0 (GitgRepositoryListBoxRow*, 0 + 1);
#line 406 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	ret = _tmp0_;
#line 406 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	ret_length1 = 0;
#line 406 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_ret_size_ = ret_length1;
#line 408 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) self);
#line 2977 "gitg-repository-list-box.c"
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
#line 408 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		row_collection = _tmp1_;
#line 408 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
#line 2985 "gitg-repository-list-box.c"
			GtkWidget* row = NULL;
#line 408 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			row = (GtkWidget*) row_it->data;
#line 2989 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* r = NULL;
				GtkWidget* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				GitgRepositoryListBoxRow* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
#line 410 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = row;
#line 410 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 410 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				r = _tmp3_;
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = r;
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = gitg_repository_list_box_row_get_selected (_tmp4_);
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = _tmp5_;
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp6_) {
#line 3011 "gitg-repository-list-box.c"
					GitgRepositoryListBoxRow** _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					GitgRepositoryListBoxRow* _tmp8_ = NULL;
					GitgRepositoryListBoxRow* _tmp9_ = NULL;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp7_ = ret;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp7__length1 = ret_length1;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp8_ = r;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp9_ = _g_object_ref0 (_tmp8_);
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_vala_array_add2 (&ret, &ret_length1, &_ret_size_, _tmp9_);
#line 3026 "gitg-repository-list-box.c"
				}
#line 408 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (r);
#line 3030 "gitg-repository-list-box.c"
			}
		}
#line 408 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (row_collection);
#line 3035 "gitg-repository-list-box.c"
	}
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = ret;
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10__length1 = ret_length1;
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (result_length1) {
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		*result_length1 = _tmp10__length1;
#line 3045 "gitg-repository-list-box.c"
	}
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp10_;
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3051 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_get_has_selection (GitgRepositoryListBox* self) {
	gboolean result;
	GList* _tmp0_ = NULL;
#line 424 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 426 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 3062 "gitg-repository-list-box.c"
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
#line 426 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		row_collection = _tmp0_;
#line 426 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
#line 3070 "gitg-repository-list-box.c"
			GtkWidget* row = NULL;
#line 426 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			row = (GtkWidget*) row_it->data;
#line 3074 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* r = NULL;
				GtkWidget* _tmp1_ = NULL;
				GitgRepositoryListBoxRow* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
#line 428 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp1_ = row;
#line 428 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 428 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				r = _tmp2_;
#line 430 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = r;
#line 430 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = gitg_repository_list_box_row_get_selected (_tmp3_);
#line 430 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = _tmp4_;
#line 430 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp5_) {
#line 432 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					result = TRUE;
#line 432 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (r);
#line 432 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_list_free0 (row_collection);
#line 432 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					return result;
#line 3104 "gitg-repository-list-box.c"
				}
#line 426 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (r);
#line 3108 "gitg-repository-list-box.c"
			}
		}
#line 426 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (row_collection);
#line 3113 "gitg-repository-list-box.c"
	}
#line 436 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = FALSE;
#line 436 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3119 "gitg-repository-list-box.c"
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (n_param_values == 3);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		data1 = closure->data;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		data2 = param_values->data[0].v_pointer;
#line 3138 "gitg-repository-list-box.c"
	} else {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		data1 = param_values->data[0].v_pointer;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		data2 = closure->data;
#line 3144 "gitg-repository-list-box.c"
	}
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 3150 "gitg-repository-list-box.c"
}


static void _gitg_repository_list_box_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
#line 228 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_update_header ((GitgRepositoryListBox*) self, row, before);
#line 3157 "gitg-repository-list-box.c"
}


static gboolean _gitg_repository_list_box_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self) {
	gboolean result;
	result = gitg_repository_list_box_filter ((GitgRepositoryListBox*) self, row);
#line 229 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3166 "gitg-repository-list-box.c"
}


static gint _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = gitg_repository_list_box_compare_widgets ((GitgRepositoryListBox*) self, row1, row2);
#line 230 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3175 "gitg-repository-list-box.c"
}


static GObject * gitg_repository_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GitgRepositoryListBox * self;
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	parent_class = G_OBJECT_CLASS (gitg_repository_list_box_parent_class);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 228 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_header_func ((GtkListBox*) self, _gitg_repository_list_box_update_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
#line 229 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_filter_func ((GtkListBox*) self, _gitg_repository_list_box_filter_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
#line 230 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_sort_func ((GtkListBox*) self, _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
#line 231 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 233 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_selection_mode ((GtkListBox*) self, GTK_SELECTION_NONE);
#line 235 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_add_recent_info (self);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return obj;
#line 3203 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow* gitg_repository_list_box_row_construct (GType object_type, const gchar* name, const gchar* branch_name, gboolean has_remote) {
	GitgRepositoryListBoxRow * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 188 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 188 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (branch_name != NULL, NULL);
#line 190 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = name;
#line 190 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = branch_name;
#line 190 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = has_remote;
#line 190 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBoxRow*) g_object_new (object_type, "repository-name", _tmp0_, "branch-name", _tmp1_, "has-remote", _tmp2_, NULL);
#line 188 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return self;
#line 3226 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow* gitg_repository_list_box_row_new (const gchar* name, const gchar* branch_name, gboolean has_remote) {
#line 188 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return gitg_repository_list_box_row_construct (GITG_REPOSITORY_LIST_BOX_TYPE_ROW, name, branch_name, has_remote);
#line 3233 "gitg-repository-list-box.c"
}


GitgSelectionMode gitg_repository_list_box_row_get_mode (GitgRepositoryListBoxRow* self) {
	GitgSelectionMode result;
	GitgSelectionMode _tmp0_ = 0;
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_mode;
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3248 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_mode (GitgRepositoryListBoxRow* self, GitgSelectionMode value) {
	GitgSelectionMode _tmp0_ = 0;
	GitgSelectionMode _tmp1_ = 0;
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 76 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_mode;
#line 76 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 76 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_ != _tmp1_) {
#line 3263 "gitg-repository-list-box.c"
		GitgSelectionMode _tmp2_ = 0;
		GtkRevealer* _tmp3_ = NULL;
		GitgSelectionMode _tmp4_ = 0;
		GtkCheckButton* _tmp5_ = NULL;
#line 78 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = value;
#line 78 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		self->priv->d_mode = _tmp2_;
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = self->priv->d_remove_revealer;
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->d_mode;
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_revealer_set_reveal_child (_tmp3_, _tmp4_ == GITG_SELECTION_MODE_SELECTION);
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_remove_check_button;
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp5_, FALSE);
#line 3282 "gitg-repository-list-box.c"
	}
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "mode");
#line 3286 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_selected (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 90 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 90 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->_selected;
#line 90 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 90 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3301 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_selected (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 90 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 90 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 90 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->_selected = _tmp0_;
#line 90 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "selected");
#line 3315 "gitg-repository-list-box.c"
}


GitgRepository* gitg_repository_list_box_row_get_repository (GitgRepositoryListBoxRow* self) {
	GitgRepository* result;
	GitgRepository* _tmp0_ = NULL;
#line 104 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 104 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository;
#line 104 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 104 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3330 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_repository (GitgRepositoryListBoxRow* self, GitgRepository* value) {
	GitgRepository* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
	GitgRepository* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 105 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 107 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 107 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 107 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository);
#line 107 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_repository = _tmp1_;
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_branch_name (self, "");
#line 111 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->d_repository;
#line 111 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_ != NULL) {
#line 3355 "gitg-repository-list-box.c"
		{
			GitgRef* head = NULL;
			GitgRepository* _tmp3_ = NULL;
			GitgRef* _tmp4_ = NULL;
			GitgRef* _tmp5_ = NULL;
			GitgParsedRefName* _tmp6_ = NULL;
			GitgParsedRefName* _tmp7_ = NULL;
			GitgParsedRefName* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
#line 115 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp3_ = self->priv->d_repository;
#line 115 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp4_ = gitg_repository_get_head (_tmp3_, &_inner_error_);
#line 115 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			head = _tmp4_;
#line 115 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3375 "gitg-repository-list-box.c"
				goto __catch45_g_error;
			}
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = head;
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp6_ = gitg_ref_get_parsed_name (_tmp5_);
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp7_ = _tmp6_;
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = _tmp7_;
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp9_ = gitg_parsed_ref_name_get_shortname (_tmp8_);
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = _tmp9_;
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp11_ = _tmp10_;
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_branch_name (self, _tmp11_);
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp11_);
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp8_);
#line 113 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (head);
#line 3400 "gitg-repository-list-box.c"
		}
		goto __finally45;
		__catch45_g_error:
		{
#line 113 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 113 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_inner_error_ = NULL;
#line 3409 "gitg-repository-list-box.c"
		}
		__finally45:
#line 113 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 113 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 113 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 113 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			return;
#line 3420 "gitg-repository-list-box.c"
		}
	}
#line 105 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "repository");
#line 3425 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_can_remove (GitgRepositoryListBoxRow* self) {
	gboolean result;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 125 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 125 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 125 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp0_);
#line 125 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _tmp1_;
#line 125 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp2_;
#line 125 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3446 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_can_remove (GitgRepositoryListBoxRow* self, gboolean value) {
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 126 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 126 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 126 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 126 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_);
#line 126 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "can-remove");
#line 3463 "gitg-repository-list-box.c"
}


GDateTime* gitg_repository_list_box_row_get_time (GitgRepositoryListBoxRow* self) {
	GDateTime* result;
	GDateTime* _tmp0_ = NULL;
#line 131 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 131 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_time;
#line 131 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 131 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3478 "gitg-repository-list-box.c"
}


static gpointer _g_date_time_ref0 (gpointer self) {
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? g_date_time_ref (self) : NULL;
#line 3485 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_time (GitgRepositoryListBoxRow* self, GDateTime* value) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_date_time_unref0 (self->priv->d_time);
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_time = _tmp1_;
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "time");
#line 3504 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_fraction (GitgRepositoryListBoxRow* self, gdouble value) {
	GitgProgressBin* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_progress_bin;
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_progress_bin_set_fraction (_tmp0_, _tmp1_);
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "fraction");
#line 3521 "gitg-repository-list-box.c"
}


const gchar* gitg_repository_list_box_row_get_repository_name (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository_label;
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_label_get_text (_tmp0_);
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp1_;
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3539 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_repository_name (GitgRepositoryListBoxRow* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository_label;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = g_strdup_printf ("<b>%s</b>", _tmp1_);
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = _tmp2_;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_label_set_markup (_tmp0_, _tmp3_);
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp3_);
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "repository-name");
#line 3564 "gitg-repository-list-box.c"
}


const gchar* gitg_repository_list_box_row_get_branch_name (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 149 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 149 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_branch_label;
#line 149 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_label_get_text (_tmp0_);
#line 149 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp1_;
#line 149 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3582 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_branch_name (GitgRepositoryListBoxRow* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_branch_label;
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = g_strdup_printf ("<small>%s</small>", _tmp1_);
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = _tmp2_;
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_label_set_markup (_tmp0_, _tmp3_);
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp3_);
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "branch-name");
#line 3607 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_loading (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 155 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 155 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_loading;
#line 155 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 155 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3622 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_loading (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 156 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_loading = _tmp0_;
#line 160 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_loading;
#line 160 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_) {
#line 3639 "gitg-repository-list-box.c"
		GtkSpinner* _tmp2_ = NULL;
		GtkSpinner* _tmp3_ = NULL;
		GtkArrow* _tmp4_ = NULL;
		GitgProgressBin* _tmp5_ = NULL;
#line 162 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = self->priv->d_spinner;
#line 162 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_spinner_stop (_tmp2_);
#line 163 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = self->priv->d_spinner;
#line 163 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->d_arrow;
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp4_);
#line 165 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_progress_bin;
#line 165 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_progress_bin_set_fraction (_tmp5_, (gdouble) 0);
#line 3660 "gitg-repository-list-box.c"
	} else {
		GtkArrow* _tmp6_ = NULL;
		GtkSpinner* _tmp7_ = NULL;
		GtkSpinner* _tmp8_ = NULL;
#line 169 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = self->priv->d_arrow;
#line 169 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_hide ((GtkWidget*) _tmp6_);
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = self->priv->d_spinner;
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp7_);
#line 171 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = self->priv->d_spinner;
#line 171 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_spinner_start (_tmp8_);
#line 3677 "gitg-repository-list-box.c"
	}
#line 156 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "loading");
#line 3681 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_has_remote (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 178 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 178 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_has_remote;
#line 178 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 178 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3696 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_has_remote (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* folder_icon_name = NULL;
	gchar* _tmp3_ = NULL;
	GtkImage* _tmp4_ = NULL;
	GtkIconSize _tmp5_ = 0;
#line 179 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 181 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 181 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_has_remote = _tmp0_;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->d_has_remote;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_) {
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = "folder-remote";
#line 3720 "gitg-repository-list-box.c"
	} else {
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = "folder";
#line 3724 "gitg-repository-list-box.c"
	}
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = g_strdup (_tmp1_);
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	folder_icon_name = _tmp3_;
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = self->priv->d_image;
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = gitg_repository_list_box_row_s_icon_size;
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_image_set_from_icon_name (_tmp4_, folder_icon_name, _tmp5_);
#line 179 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (folder_icon_name);
#line 179 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "has-remote");
#line 3740 "gitg-repository-list-box.c"
}


static GObject * gitg_repository_list_box_row_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GitgRepositoryListBoxRow * self;
	GtkCheckButton* _tmp0_ = NULL;
#line 93 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	parent_class = G_OBJECT_CLASS (gitg_repository_list_box_row_parent_class);
#line 93 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 93 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 95 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 95 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_bind_property_with_closures ((GObject*) _tmp0_, "active", (GObject*) self, "selected", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 93 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return obj;
#line 3761 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_class_init (GitgRepositoryListBoxRowClass * klass) {
	gint GitgRepositoryListBoxRow_private_offset;
	GtkIconSize _tmp0_ = 0;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryListBoxRowPrivate));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_list_box_row_get_property;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_repository_list_box_row_set_property;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->constructor = gitg_repository_list_box_row_constructor;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_row_finalize;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_MODE, g_param_spec_enum ("mode", "mode", "mode", GITG_TYPE_SELECTION_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_SELECTED, g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY, g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE, g_param_spec_boolean ("can-remove", "can-remove", "can-remove", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_TIME, g_param_spec_boxed ("time", "time", "time", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_FRACTION, g_param_spec_double ("fraction", "fraction", "fraction", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME, g_param_spec_string ("repository-name", "repository-name", "repository-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME, g_param_spec_string ("branch-name", "branch-name", "branch-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_LOADING, g_param_spec_boolean ("loading", "loading", "loading", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE, g_param_spec_boolean ("has-remote", "has-remote", "has-remote", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	GitgRepositoryListBoxRow_private_offset = g_type_class_get_instance_private_offset (klass);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/gtk/gitg-repository-list-box-row.ui");
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("request_remove", GITG_REPOSITORY_LIST_BOX_TYPE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_progress_bin", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_progress_bin));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_image", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_image));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_repository_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_repository_label));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_branch_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_branch_label));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_arrow", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_arrow));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_spinner", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_spinner));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_remove_check_button", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_remove_check_button));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_remove_revealer", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_remove_revealer));
#line 67 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_icon_size_register ("gitg", 64, 64);
#line 67 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_s_icon_size = _tmp0_;
#line 3826 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_instance_init (GitgRepositoryListBoxRow * self) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv = GITG_REPOSITORY_LIST_BOX_ROW_GET_PRIVATE (self);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = g_date_time_new_now_local ();
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _tmp0_;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_time (self, _tmp1_);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_ensure (GITG_TYPE_PROGRESS_BIN);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 3845 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_finalize (GObject* obj) {
	GitgRepositoryListBoxRow * self;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 38 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository);
#line 39 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_date_time_unref0 (self->priv->d_time);
#line 43 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_progress_bin);
#line 45 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_image);
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository_label);
#line 49 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_branch_label);
#line 51 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_arrow);
#line 53 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_spinner);
#line 55 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_remove_check_button);
#line 57 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_remove_revealer);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (gitg_repository_list_box_row_parent_class)->finalize (obj);
#line 3875 "gitg-repository-list-box.c"
}


GType gitg_repository_list_box_row_get_type (void) {
	static volatile gsize gitg_repository_list_box_row_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_list_box_row_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBoxRow), 0, (GInstanceInitFunc) gitg_repository_list_box_row_instance_init, NULL };
		GType gitg_repository_list_box_row_type_id;
		gitg_repository_list_box_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "GitgRepositoryListBoxRow", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_list_box_row_type_id__volatile, gitg_repository_list_box_row_type_id);
	}
	return gitg_repository_list_box_row_type_id__volatile;
}


static void _vala_gitg_repository_list_box_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_MODE:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_enum (value, gitg_repository_list_box_row_get_mode (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_SELECTED:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_selected (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_object (value, gitg_repository_list_box_row_get_repository (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_can_remove (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_TIME:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boxed (value, gitg_repository_list_box_row_get_time (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_repository_name (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_branch_name (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_LOADING:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_loading (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_has_remote (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3950 "gitg-repository-list-box.c"
		default:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3956 "gitg-repository-list-box.c"
	}
}


static void _vala_gitg_repository_list_box_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_MODE:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_mode (self, g_value_get_enum (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_SELECTED:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_selected (self, g_value_get_boolean (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository (self, g_value_get_object (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_can_remove (self, g_value_get_boolean (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_TIME:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_time (self, g_value_get_boxed (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_FRACTION:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_fraction (self, g_value_get_double (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository_name (self, g_value_get_string (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_branch_name (self, g_value_get_string (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_LOADING:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_loading (self, g_value_get_boolean (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_has_remote (self, g_value_get_boolean (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 4026 "gitg-repository-list-box.c"
		default:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 4032 "gitg-repository-list-box.c"
	}
}


static GitgRepositoryListBoxCloneProgress* gitg_repository_list_box_clone_progress_construct (GType object_type, GitgRepositoryListBoxRow* row) {
	GitgRepositoryListBoxCloneProgress * self = NULL;
	GitgRepositoryListBoxRow* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
#line 444 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (row != NULL, NULL);
#line 444 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBoxCloneProgress*) g_object_new (object_type, NULL);
#line 446 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = row;
#line 446 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 446 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_row);
#line 446 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_row = _tmp1_;
#line 444 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return self;
#line 4055 "gitg-repository-list-box.c"
}


static GitgRepositoryListBoxCloneProgress* gitg_repository_list_box_clone_progress_new (GitgRepositoryListBoxRow* row) {
#line 444 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return gitg_repository_list_box_clone_progress_construct (GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS, row);
#line 4062 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_clone_progress_real_transfer_progress (GgitRemoteCallbacks* base, GgitTransferProgress* stats, GError** error) {
	GitgRepositoryListBoxCloneProgress * self;
	gboolean result = FALSE;
	guint recvobj = 0U;
	GgitTransferProgress* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint indxobj = 0U;
	GgitTransferProgress* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint totaobj = 0U;
	GgitTransferProgress* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	GitgRepositoryListBoxRow* _tmp6_ = NULL;
#line 449 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBoxCloneProgress*) base;
#line 449 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (stats != NULL, FALSE);
#line 451 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = stats;
#line 451 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = ggit_transfer_progress_get_received_objects (_tmp0_);
#line 451 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	recvobj = _tmp1_;
#line 452 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = stats;
#line 452 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = ggit_transfer_progress_get_indexed_objects (_tmp2_);
#line 452 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	indxobj = _tmp3_;
#line 453 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = stats;
#line 453 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = ggit_transfer_progress_get_total_objects (_tmp4_);
#line 453 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	totaobj = _tmp5_;
#line 455 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = self->priv->d_row;
#line 455 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_fraction (_tmp6_, (recvobj + indxobj) / ((gdouble) (2 * totaobj)));
#line 456 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = TRUE;
#line 456 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 4109 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_clone_progress_class_init (GitgRepositoryListBoxCloneProgressClass * klass) {
#line 440 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_clone_progress_parent_class = g_type_class_peek_parent (klass);
#line 440 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryListBoxCloneProgressPrivate));
#line 440 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	((GgitRemoteCallbacksClass *) klass)->transfer_progress = gitg_repository_list_box_clone_progress_real_transfer_progress;
#line 440 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_clone_progress_finalize;
#line 4122 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_clone_progress_instance_init (GitgRepositoryListBoxCloneProgress * self) {
#line 440 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv = GITG_REPOSITORY_LIST_BOX_CLONE_PROGRESS_GET_PRIVATE (self);
#line 4129 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_clone_progress_finalize (GObject* obj) {
	GitgRepositoryListBoxCloneProgress * self;
#line 440 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS, GitgRepositoryListBoxCloneProgress);
#line 442 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_row);
#line 440 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (gitg_repository_list_box_clone_progress_parent_class)->finalize (obj);
#line 4141 "gitg-repository-list-box.c"
}


static GType gitg_repository_list_box_clone_progress_get_type (void) {
	static volatile gsize gitg_repository_list_box_clone_progress_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_list_box_clone_progress_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxCloneProgressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_clone_progress_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBoxCloneProgress), 0, (GInstanceInitFunc) gitg_repository_list_box_clone_progress_instance_init, NULL };
		GType gitg_repository_list_box_clone_progress_type_id;
		gitg_repository_list_box_clone_progress_type_id = g_type_register_static (ggit_remote_callbacks_get_type (), "GitgRepositoryListBoxCloneProgress", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_list_box_clone_progress_type_id__volatile, gitg_repository_list_box_clone_progress_type_id);
	}
	return gitg_repository_list_box_clone_progress_type_id__volatile;
}


static void gitg_repository_list_box_class_init (GitgRepositoryListBoxClass * klass) {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryListBoxPrivate));
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	((GtkWidgetClass *) klass)->button_press_event = gitg_repository_list_box_real_button_press_event;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	((GtkListBoxClass *) klass)->row_activated = gitg_repository_list_box_real_row_activated;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_list_box_get_property;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_repository_list_box_set_property;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->constructor = gitg_repository_list_box_constructor;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_finalize;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_MODE, g_param_spec_enum ("mode", "mode", "mode", GITG_TYPE_SELECTION_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_HAS_SELECTION, g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("repository_activated", GITG_TYPE_REPOSITORY_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GITG_TYPE_REPOSITORY);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("show_error", GITG_TYPE_REPOSITORY_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
#line 4182 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_instance_init (GitgRepositoryListBox * self) {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv = GITG_REPOSITORY_LIST_BOX_GET_PRIVATE (self);
#line 4189 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_finalize (GObject* obj) {
	GitgRepositoryListBox * self;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 30 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_filter_text);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (gitg_repository_list_box_parent_class)->finalize (obj);
#line 4201 "gitg-repository-list-box.c"
}


GType gitg_repository_list_box_get_type (void) {
	static volatile gsize gitg_repository_list_box_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_list_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBox), 0, (GInstanceInitFunc) gitg_repository_list_box_instance_init, NULL };
		GType gitg_repository_list_box_type_id;
		gitg_repository_list_box_type_id = g_type_register_static (gtk_list_box_get_type (), "GitgRepositoryListBox", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_list_box_type_id__volatile, gitg_repository_list_box_type_id);
	}
	return gitg_repository_list_box_type_id__volatile;
}


static void _vala_gitg_repository_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_MODE:
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_enum (value, gitg_repository_list_box_get_mode (self));
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_HAS_SELECTION:
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_get_has_selection (self));
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 4234 "gitg-repository-list-box.c"
		default:
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 4240 "gitg-repository-list-box.c"
	}
}


static void _vala_gitg_repository_list_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_MODE:
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_set_mode (self, g_value_get_enum (value));
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 4256 "gitg-repository-list-box.c"
		default:
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 4262 "gitg-repository-list-box.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



