/* rygel-media-renderer-plugin.c generated by valac 0.27.1.26-9b1a5, the Vala compiler
 * generated from rygel-media-renderer-plugin.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libgupnp-av/gupnp-av.h>
#include <config.h>
#include <libgupnp/gupnp.h>


#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;
typedef struct _RygelMediaRendererPluginPrivate RygelMediaRendererPluginPrivate;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;

#define RYGEL_TYPE_PLAYER_CONTROLLER (rygel_player_controller_get_type ())
#define RYGEL_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController))
#define RYGEL_IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_PLAYER_CONTROLLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerIface))

typedef struct _RygelPlayerController RygelPlayerController;
typedef struct _RygelPlayerControllerIface RygelPlayerControllerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__rygel_dlna_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__rygel_dlna_profile_unref0_ (var), NULL)))

#define RYGEL_TYPE_SINK_CONNECTION_MANAGER (rygel_sink_connection_manager_get_type ())
#define RYGEL_SINK_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SINK_CONNECTION_MANAGER, RygelSinkConnectionManager))
#define RYGEL_SINK_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SINK_CONNECTION_MANAGER, RygelSinkConnectionManagerClass))
#define RYGEL_IS_SINK_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SINK_CONNECTION_MANAGER))
#define RYGEL_IS_SINK_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SINK_CONNECTION_MANAGER))
#define RYGEL_SINK_CONNECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SINK_CONNECTION_MANAGER, RygelSinkConnectionManagerClass))

typedef struct _RygelSinkConnectionManager RygelSinkConnectionManager;
typedef struct _RygelSinkConnectionManagerClass RygelSinkConnectionManagerClass;

#define RYGEL_TYPE_AV_TRANSPORT (rygel_av_transport_get_type ())
#define RYGEL_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport))
#define RYGEL_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))
#define RYGEL_IS_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_IS_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))

typedef struct _RygelAVTransport RygelAVTransport;
typedef struct _RygelAVTransportClass RygelAVTransportClass;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))

#define RYGEL_TYPE_RENDERING_CONTROL (rygel_rendering_control_get_type ())
#define RYGEL_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl))
#define RYGEL_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))
#define RYGEL_IS_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_IS_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_RENDERING_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))

typedef struct _RygelRenderingControl RygelRenderingControl;
typedef struct _RygelRenderingControlClass RygelRenderingControlClass;

#define RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER (rygel_default_player_controller_get_type ())
#define RYGEL_DEFAULT_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerController))
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerControllerClass))
#define RYGEL_IS_DEFAULT_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER))
#define RYGEL_IS_DEFAULT_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER))
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerControllerClass))

typedef struct _RygelDefaultPlayerController RygelDefaultPlayerController;
typedef struct _RygelDefaultPlayerControllerClass RygelDefaultPlayerControllerClass;

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gboolean (*seek_bytes) (RygelMediaPlayer* self, gint64 bytes);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_size) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gboolean (*get_can_seek_bytes) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
	gint64 (*get_byte_position) (RygelMediaPlayer* self);
};

struct _RygelPlayerControllerIface {
	GTypeInterface parent_iface;
	gboolean (*next) (RygelPlayerController* self);
	gboolean (*previous) (RygelPlayerController* self);
	void (*set_single_play_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
	void (*set_playlist_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
	void (*set_next_single_play_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
	void (*set_next_playlist_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
	gboolean (*is_play_mode_valid) (RygelPlayerController* self, const gchar* play_mode);
	const gchar* (*get_playback_state) (RygelPlayerController* self);
	void (*set_playback_state) (RygelPlayerController* self, const gchar* value);
	guint (*get_n_tracks) (RygelPlayerController* self);
	void (*set_n_tracks) (RygelPlayerController* self, guint value);
	guint (*get_track) (RygelPlayerController* self);
	void (*set_track) (RygelPlayerController* self, guint value);
	gchar* (*get_uri) (RygelPlayerController* self);
	void (*set_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_metadata) (RygelPlayerController* self);
	void (*set_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_track_uri) (RygelPlayerController* self);
	void (*set_track_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_track_metadata) (RygelPlayerController* self);
	void (*set_track_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_next_uri) (RygelPlayerController* self);
	void (*set_next_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_next_metadata) (RygelPlayerController* self);
	void (*set_next_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_current_transport_actions) (RygelPlayerController* self);
	const gchar* (*get_play_mode) (RygelPlayerController* self);
	void (*set_play_mode) (RygelPlayerController* self, const gchar* value);
};

struct _RygelMediaRendererPlugin {
	RygelPlugin parent_instance;
	RygelMediaRendererPluginPrivate * priv;
};

struct _RygelMediaRendererPluginClass {
	RygelPluginClass parent_class;
	RygelMediaPlayer* (*get_player) (RygelMediaRendererPlugin* self);
	RygelPlayerController* (*get_controller) (RygelMediaRendererPlugin* self);
};

struct _RygelMediaRendererPluginPrivate {
	gchar* sink_protocol_info;
	RygelPlayerController* controller;
	GList* _supported_profiles;
};


static gpointer rygel_media_renderer_plugin_parent_class = NULL;

GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
GType rygel_player_controller_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginPrivate))
enum  {
	RYGEL_MEDIA_RENDERER_PLUGIN_DUMMY_PROPERTY,
	RYGEL_MEDIA_RENDERER_PLUGIN_SUPPORTED_PROFILES
};
static void _rygel_dlna_profile_unref0_ (gpointer var);
static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self);
#define RYGEL_MEDIA_RENDERER_PLUGIN_MEDIA_RENDERER_DESC_PATH DATA_DIR "/xml/MediaRenderer2.xml"
#define RYGEL_MEDIA_RENDERER_PLUGIN_DMR "urn:schemas-upnp-org:device:MediaRenderer"
RygelMediaRendererPlugin* rygel_media_renderer_plugin_new (const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities);
RygelMediaRendererPlugin* rygel_media_renderer_plugin_construct (GType object_type, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities);
static void rygel_media_renderer_plugin_real_constructed (GObject* base);
GType rygel_sink_connection_manager_get_type (void) G_GNUC_CONST;
#define RYGEL_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
GType rygel_av_transport_get_type (void) G_GNUC_CONST;
#define RYGEL_RENDERING_CONTROL_UPNP_ID "urn:upnp-org:serviceId:RenderingControl"
#define RYGEL_RENDERING_CONTROL_UPNP_TYPE "urn:schemas-upnp-org:service:RenderingControl:2"
#define RYGEL_RENDERING_CONTROL_DESCRIPTION_PATH "xml/RenderingControl2.xml"
GType rygel_rendering_control_get_type (void) G_GNUC_CONST;
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
static RygelMediaPlayer* rygel_media_renderer_plugin_real_get_player (RygelMediaRendererPlugin* self);
RygelPlayerController* rygel_media_renderer_plugin_get_controller (RygelMediaRendererPlugin* self);
static RygelPlayerController* rygel_media_renderer_plugin_real_get_controller (RygelMediaRendererPlugin* self);
gchar* rygel_media_renderer_plugin_get_protocol_info (RygelMediaRendererPlugin* self);
RygelDefaultPlayerController* rygel_default_player_controller_new (RygelMediaPlayer* player, const gchar* protocol_info);
RygelDefaultPlayerController* rygel_default_player_controller_construct (GType object_type, RygelMediaPlayer* player, const gchar* protocol_info);
GType rygel_default_player_controller_get_type (void) G_GNUC_CONST;
static void rygel_media_renderer_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error);
gchar** rygel_media_player_get_protocols (RygelMediaPlayer* self, int* result_length1);
GList* rygel_media_renderer_plugin_get_supported_profiles (RygelMediaRendererPlugin* self);
gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
void rygel_media_renderer_plugin_set_supported_profiles (RygelMediaRendererPlugin* self, GList* value);
static void rygel_media_renderer_plugin_finalize (GObject* obj);
static void _vala_rygel_media_renderer_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_renderer_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _rygel_dlna_profile_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL));
}


static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _rygel_dlna_profile_unref0_, NULL);
	g_list_free (self);
}


/**
     * Create an instance of the plugin.
     *
     * @param name The non-human-readable name for the plugin and its renderer, used in UPnP messages and in the Rygel configuration file.
     * @param title An optional human-readable name (friendlyName) of the UPnP renderer provided by the plugin. If the title is empty then the name will be used.
     * @param description An optional human-readable description (modelDescription) of the UPnP renderer provided by the plugin.
     */
RygelMediaRendererPlugin* rygel_media_renderer_plugin_construct (GType object_type, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities) {
	RygelMediaRendererPlugin * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	RygelPluginCapabilities _tmp3_ = 0;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = title;
	_tmp2_ = description;
	_tmp3_ = capabilities;
	self = (RygelMediaRendererPlugin*) g_object_new (object_type, "desc-path", RYGEL_MEDIA_RENDERER_PLUGIN_MEDIA_RENDERER_DESC_PATH, "name", _tmp0_, "title", _tmp1_, "description", _tmp2_, "capabilities", _tmp3_, NULL);
	return self;
}


RygelMediaRendererPlugin* rygel_media_renderer_plugin_new (const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities) {
	return rygel_media_renderer_plugin_construct (RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, name, title, description, capabilities);
}


static void rygel_media_renderer_plugin_real_constructed (GObject* base) {
	RygelMediaRendererPlugin * self;
	RygelResourceInfo* resource = NULL;
	RygelResourceInfo* _tmp0_ = NULL;
	RygelResourceInfo* _tmp1_ = NULL;
	RygelResourceInfo* _tmp2_ = NULL;
	RygelResourceInfo* _tmp3_ = NULL;
	RygelResourceInfo* _tmp4_ = NULL;
	RygelResourceInfo* _tmp5_ = NULL;
	self = (RygelMediaRendererPlugin*) base;
	G_OBJECT_CLASS (rygel_media_renderer_plugin_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_PLUGIN, RygelPlugin));
	_tmp0_ = rygel_resource_info_new (RYGEL_CONNECTION_MANAGER_UPNP_ID, RYGEL_CONNECTION_MANAGER_UPNP_TYPE, RYGEL_CONNECTION_MANAGER_DESCRIPTION_PATH, RYGEL_TYPE_SINK_CONNECTION_MANAGER);
	resource = _tmp0_;
	_tmp1_ = resource;
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp1_);
	_tmp2_ = rygel_resource_info_new (RYGEL_AV_TRANSPORT_UPNP_ID, RYGEL_AV_TRANSPORT_UPNP_TYPE, RYGEL_AV_TRANSPORT_DESCRIPTION_PATH, RYGEL_TYPE_AV_TRANSPORT);
	_rygel_resource_info_unref0 (resource);
	resource = _tmp2_;
	_tmp3_ = resource;
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp3_);
	_tmp4_ = rygel_resource_info_new (RYGEL_RENDERING_CONTROL_UPNP_ID, RYGEL_RENDERING_CONTROL_UPNP_TYPE, RYGEL_RENDERING_CONTROL_DESCRIPTION_PATH, RYGEL_TYPE_RENDERING_CONTROL);
	_rygel_resource_info_unref0 (resource);
	resource = _tmp4_;
	_tmp5_ = resource;
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp5_);
	_rygel_resource_info_unref0 (resource);
}


static RygelMediaPlayer* rygel_media_renderer_plugin_real_get_player (RygelMediaRendererPlugin* self) {
	RygelMediaPlayer* result = NULL;
	result = NULL;
	return result;
}


RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS (self)->get_player (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static RygelPlayerController* rygel_media_renderer_plugin_real_get_controller (RygelMediaRendererPlugin* self) {
	RygelPlayerController* result = NULL;
	RygelPlayerController* _tmp0_ = NULL;
	RygelPlayerController* _tmp6_ = NULL;
	RygelPlayerController* _tmp7_ = NULL;
	_tmp0_ = self->priv->controller;
	if (_tmp0_ == NULL) {
		RygelMediaPlayer* _tmp1_ = NULL;
		RygelMediaPlayer* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		RygelDefaultPlayerController* _tmp5_ = NULL;
		_tmp1_ = rygel_media_renderer_plugin_get_player (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = rygel_media_renderer_plugin_get_protocol_info (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = rygel_default_player_controller_new (_tmp2_, _tmp4_);
		_g_object_unref0 (self->priv->controller);
		self->priv->controller = (RygelPlayerController*) _tmp5_;
		_g_free0 (_tmp4_);
		_g_object_unref0 (_tmp2_);
	}
	_tmp6_ = self->priv->controller;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


RygelPlayerController* rygel_media_renderer_plugin_get_controller (RygelMediaRendererPlugin* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS (self)->get_controller (self);
}


static void rygel_media_renderer_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error) {
	RygelMediaRendererPlugin * self;
	gchar** services = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint services_length1 = 0;
	gint _services_size_ = 0;
	RygelV1Hacks* v1_hacks = NULL;
	RygelV1Hacks* _tmp4_ = NULL;
	RygelRootDevice* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMediaRendererPlugin*) base;
	g_return_if_fail (device != NULL);
	g_return_if_fail (description_path != NULL);
	_tmp0_ = g_strdup (RYGEL_AV_TRANSPORT_UPNP_TYPE);
	_tmp1_ = g_strdup (RYGEL_RENDERING_CONTROL_UPNP_TYPE);
	_tmp2_ = g_strdup (RYGEL_CONNECTION_MANAGER_UPNP_TYPE);
	_tmp3_ = g_new0 (gchar*, 3 + 1);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	services = _tmp3_;
	services_length1 = 3;
	_services_size_ = services_length1;
	_tmp4_ = rygel_v1_hacks_new (RYGEL_MEDIA_RENDERER_PLUGIN_DMR, services, services_length1);
	v1_hacks = _tmp4_;
	_tmp5_ = device;
	_tmp6_ = description_path;
	rygel_v1_hacks_apply_on_device (v1_hacks, _tmp5_, _tmp6_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (v1_hacks);
		services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_g_object_unref0 (v1_hacks);
	services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar* rygel_media_renderer_plugin_get_protocol_info (RygelMediaRendererPlugin* self) {
	gchar* result = NULL;
	RygelMediaPlayer* player = NULL;
	RygelMediaPlayer* _tmp0_ = NULL;
	RygelMediaPlayer* _tmp1_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp75_ = NULL;
	gchar* _tmp76_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_media_renderer_plugin_get_player (self);
	player = _tmp0_;
	_tmp1_ = player;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_ = NULL;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		_g_object_unref0 (player);
		return result;
	}
	_tmp3_ = self->priv->sink_protocol_info;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_ = NULL;
		gchar** protocols = NULL;
		RygelMediaPlayer* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gchar** _tmp7_ = NULL;
		gint protocols_length1 = 0;
		gint _protocols_size_ = 0;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gchar** mime_types = NULL;
		RygelMediaPlayer* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		gchar** _tmp40_ = NULL;
		gint mime_types_length1 = 0;
		gint _mime_types_size_ = 0;
		gchar** _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		gchar* _tmp44_ = NULL;
		gchar** _tmp45_ = NULL;
		gint _tmp45__length1 = 0;
		gchar* _tmp46_ = NULL;
		gchar** _tmp47_ = NULL;
		gint _tmp47__length1 = 0;
		gchar* _tmp48_ = NULL;
		gchar** _tmp49_ = NULL;
		gint _tmp49__length1 = 0;
		_tmp4_ = g_strdup ("");
		_g_free0 (self->priv->sink_protocol_info);
		self->priv->sink_protocol_info = _tmp4_;
		_tmp5_ = player;
		_tmp7_ = rygel_media_player_get_protocols (_tmp5_, &_tmp6_);
		protocols = _tmp7_;
		protocols_length1 = _tmp6_;
		_protocols_size_ = protocols_length1;
		_tmp8_ = protocols;
		_tmp8__length1 = protocols_length1;
		{
			gchar** protocol_collection = NULL;
			gint protocol_collection_length1 = 0;
			gint _protocol_collection_size_ = 0;
			gint protocol_it = 0;
			protocol_collection = _tmp8_;
			protocol_collection_length1 = _tmp8__length1;
			for (protocol_it = 0; protocol_it < _tmp8__length1; protocol_it = protocol_it + 1) {
				gchar* _tmp9_ = NULL;
				gchar* protocol = NULL;
				_tmp9_ = g_strdup (protocol_collection[protocol_it]);
				protocol = _tmp9_;
				{
					gchar** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					const gchar* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					GList* _tmp15_ = NULL;
					GList* _tmp16_ = NULL;
					_tmp10_ = protocols;
					_tmp10__length1 = protocols_length1;
					_tmp11_ = _tmp10_[0];
					_tmp12_ = protocol;
					if (g_strcmp0 (_tmp11_, _tmp12_) != 0) {
						const gchar* _tmp13_ = NULL;
						gchar* _tmp14_ = NULL;
						_tmp13_ = self->priv->sink_protocol_info;
						_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
						_g_free0 (self->priv->sink_protocol_info);
						self->priv->sink_protocol_info = _tmp14_;
					}
					_tmp15_ = rygel_media_renderer_plugin_get_supported_profiles (self);
					_tmp16_ = _tmp15_;
					{
						GList* profile_collection = NULL;
						GList* profile_it = NULL;
						profile_collection = _tmp16_;
						for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
							RygelDLNAProfile* profile = NULL;
							profile = (RygelDLNAProfile*) profile_it->data;
							{
								GList* _tmp17_ = NULL;
								GList* _tmp18_ = NULL;
								gconstpointer _tmp19_ = NULL;
								RygelDLNAProfile* _tmp20_ = NULL;
								const gchar* _tmp23_ = NULL;
								const gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
								gchar* _tmp26_ = NULL;
								RygelDLNAProfile* _tmp27_ = NULL;
								const gchar* _tmp28_ = NULL;
								gchar* _tmp29_ = NULL;
								gchar* _tmp30_ = NULL;
								gchar* _tmp31_ = NULL;
								gchar* _tmp32_ = NULL;
								RygelDLNAProfile* _tmp33_ = NULL;
								const gchar* _tmp34_ = NULL;
								gchar* _tmp35_ = NULL;
								gchar* _tmp36_ = NULL;
								gchar* _tmp37_ = NULL;
								_tmp17_ = rygel_media_renderer_plugin_get_supported_profiles (self);
								_tmp18_ = _tmp17_;
								_tmp19_ = _tmp18_->data;
								_tmp20_ = profile;
								if (((RygelDLNAProfile*) _tmp19_) != _tmp20_) {
									const gchar* _tmp21_ = NULL;
									gchar* _tmp22_ = NULL;
									_tmp21_ = self->priv->sink_protocol_info;
									_tmp22_ = g_strconcat (_tmp21_, ",", NULL);
									_g_free0 (self->priv->sink_protocol_info);
									self->priv->sink_protocol_info = _tmp22_;
								}
								_tmp23_ = self->priv->sink_protocol_info;
								_tmp24_ = protocol;
								_tmp25_ = g_strconcat (_tmp24_, ":*:", NULL);
								_tmp26_ = _tmp25_;
								_tmp27_ = profile;
								_tmp28_ = _tmp27_->mime;
								_tmp29_ = g_strconcat (_tmp26_, _tmp28_, NULL);
								_tmp30_ = _tmp29_;
								_tmp31_ = g_strconcat (_tmp30_, ":DLNA.ORG_PN=", NULL);
								_tmp32_ = _tmp31_;
								_tmp33_ = profile;
								_tmp34_ = _tmp33_->name;
								_tmp35_ = g_strconcat (_tmp32_, _tmp34_, NULL);
								_tmp36_ = _tmp35_;
								_tmp37_ = g_strconcat (_tmp23_, _tmp36_, NULL);
								_g_free0 (self->priv->sink_protocol_info);
								self->priv->sink_protocol_info = _tmp37_;
								_g_free0 (_tmp36_);
								_g_free0 (_tmp32_);
								_g_free0 (_tmp30_);
								_g_free0 (_tmp26_);
							}
						}
					}
					_g_free0 (protocol);
				}
			}
		}
		_tmp38_ = player;
		_tmp40_ = rygel_media_player_get_mime_types (_tmp38_, &_tmp39_);
		mime_types = _tmp40_;
		mime_types_length1 = _tmp39_;
		_mime_types_size_ = mime_types_length1;
		_tmp41_ = mime_types;
		_tmp41__length1 = mime_types_length1;
		_tmp42_ = g_strdup ("audio/mpegurl");
		_vala_array_add1 (&mime_types, &mime_types_length1, &_mime_types_size_, _tmp42_);
		_tmp43_ = mime_types;
		_tmp43__length1 = mime_types_length1;
		_tmp44_ = g_strdup ("audio/x-mpegurl");
		_vala_array_add2 (&mime_types, &mime_types_length1, &_mime_types_size_, _tmp44_);
		_tmp45_ = mime_types;
		_tmp45__length1 = mime_types_length1;
		_tmp46_ = g_strdup ("video/mpegurl");
		_vala_array_add3 (&mime_types, &mime_types_length1, &_mime_types_size_, _tmp46_);
		_tmp47_ = mime_types;
		_tmp47__length1 = mime_types_length1;
		_tmp48_ = g_strdup ("video/x-mpegurl");
		_vala_array_add4 (&mime_types, &mime_types_length1, &_mime_types_size_, _tmp48_);
		_tmp49_ = protocols;
		_tmp49__length1 = protocols_length1;
		{
			gchar** protocol_collection = NULL;
			gint protocol_collection_length1 = 0;
			gint _protocol_collection_size_ = 0;
			gint protocol_it = 0;
			protocol_collection = _tmp49_;
			protocol_collection_length1 = _tmp49__length1;
			for (protocol_it = 0; protocol_it < _tmp49__length1; protocol_it = protocol_it + 1) {
				gchar* _tmp50_ = NULL;
				gchar* protocol = NULL;
				_tmp50_ = g_strdup (protocol_collection[protocol_it]);
				protocol = _tmp50_;
				{
					gboolean _tmp51_ = FALSE;
					gchar** _tmp52_ = NULL;
					gint _tmp52__length1 = 0;
					const gchar* _tmp53_ = NULL;
					const gchar* _tmp54_ = NULL;
					gchar** _tmp58_ = NULL;
					gint _tmp58__length1 = 0;
					_tmp52_ = protocols;
					_tmp52__length1 = protocols_length1;
					_tmp53_ = _tmp52_[0];
					_tmp54_ = protocol;
					if (g_strcmp0 (_tmp53_, _tmp54_) != 0) {
						_tmp51_ = TRUE;
					} else {
						const gchar* _tmp55_ = NULL;
						_tmp55_ = self->priv->sink_protocol_info;
						_tmp51_ = g_strcmp0 (_tmp55_, "") != 0;
					}
					if (_tmp51_) {
						const gchar* _tmp56_ = NULL;
						gchar* _tmp57_ = NULL;
						_tmp56_ = self->priv->sink_protocol_info;
						_tmp57_ = g_strconcat (_tmp56_, ",", NULL);
						_g_free0 (self->priv->sink_protocol_info);
						self->priv->sink_protocol_info = _tmp57_;
					}
					_tmp58_ = mime_types;
					_tmp58__length1 = mime_types_length1;
					{
						gchar** mime_type_collection = NULL;
						gint mime_type_collection_length1 = 0;
						gint _mime_type_collection_size_ = 0;
						gint mime_type_it = 0;
						mime_type_collection = _tmp58_;
						mime_type_collection_length1 = _tmp58__length1;
						for (mime_type_it = 0; mime_type_it < _tmp58__length1; mime_type_it = mime_type_it + 1) {
							gchar* _tmp59_ = NULL;
							gchar* mime_type = NULL;
							_tmp59_ = g_strdup (mime_type_collection[mime_type_it]);
							mime_type = _tmp59_;
							{
								gchar** _tmp60_ = NULL;
								gint _tmp60__length1 = 0;
								const gchar* _tmp61_ = NULL;
								const gchar* _tmp62_ = NULL;
								const gchar* _tmp65_ = NULL;
								const gchar* _tmp66_ = NULL;
								gchar* _tmp67_ = NULL;
								gchar* _tmp68_ = NULL;
								const gchar* _tmp69_ = NULL;
								gchar* _tmp70_ = NULL;
								gchar* _tmp71_ = NULL;
								gchar* _tmp72_ = NULL;
								gchar* _tmp73_ = NULL;
								gchar* _tmp74_ = NULL;
								_tmp60_ = mime_types;
								_tmp60__length1 = mime_types_length1;
								_tmp61_ = _tmp60_[0];
								_tmp62_ = mime_type;
								if (g_strcmp0 (_tmp61_, _tmp62_) != 0) {
									const gchar* _tmp63_ = NULL;
									gchar* _tmp64_ = NULL;
									_tmp63_ = self->priv->sink_protocol_info;
									_tmp64_ = g_strconcat (_tmp63_, ",", NULL);
									_g_free0 (self->priv->sink_protocol_info);
									self->priv->sink_protocol_info = _tmp64_;
								}
								_tmp65_ = self->priv->sink_protocol_info;
								_tmp66_ = protocol;
								_tmp67_ = g_strconcat (_tmp66_, ":*:", NULL);
								_tmp68_ = _tmp67_;
								_tmp69_ = mime_type;
								_tmp70_ = g_strconcat (_tmp68_, _tmp69_, NULL);
								_tmp71_ = _tmp70_;
								_tmp72_ = g_strconcat (_tmp71_, ":*", NULL);
								_tmp73_ = _tmp72_;
								_tmp74_ = g_strconcat (_tmp65_, _tmp73_, NULL);
								_g_free0 (self->priv->sink_protocol_info);
								self->priv->sink_protocol_info = _tmp74_;
								_g_free0 (_tmp73_);
								_g_free0 (_tmp71_);
								_g_free0 (_tmp68_);
								_g_free0 (mime_type);
							}
						}
					}
					_g_free0 (protocol);
				}
			}
		}
		mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
		protocols = (_vala_array_free (protocols, protocols_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp75_ = self->priv->sink_protocol_info;
	_tmp76_ = g_strdup (_tmp75_);
	result = _tmp76_;
	_g_object_unref0 (player);
	return result;
}


GList* rygel_media_renderer_plugin_get_supported_profiles (RygelMediaRendererPlugin* self) {
	GList* result;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_supported_profiles;
	result = _tmp0_;
	return result;
}


static gpointer _rygel_dlna_profile_ref0 (gpointer self) {
	return self ? rygel_dlna_profile_ref (self) : NULL;
}


void rygel_media_renderer_plugin_set_supported_profiles (RygelMediaRendererPlugin* self, GList* value) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_supported_profiles);
	self->priv->_supported_profiles = NULL;
	_tmp0_ = value;
	if (_tmp0_ != NULL) {
		GList* _tmp1_ = NULL;
		RygelDLNAProfile* _tmp4_ = NULL;
		_tmp1_ = value;
		{
			GList* profile_collection = NULL;
			GList* profile_it = NULL;
			profile_collection = _tmp1_;
			for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
				RygelDLNAProfile* profile = NULL;
				profile = (RygelDLNAProfile*) profile_it->data;
				{
					RygelDLNAProfile* _tmp2_ = NULL;
					RygelDLNAProfile* _tmp3_ = NULL;
					_tmp2_ = profile;
					_tmp3_ = _rygel_dlna_profile_ref0 (_tmp2_);
					self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp3_);
				}
			}
		}
		_tmp4_ = rygel_dlna_profile_new ("DIDL_S", "text/xml");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp4_);
		self->priv->_supported_profiles = g_list_reverse (self->priv->_supported_profiles);
	}
	g_object_notify ((GObject *) self, "supported-profiles");
}


static void rygel_media_renderer_plugin_class_init (RygelMediaRendererPluginClass * klass) {
	rygel_media_renderer_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaRendererPluginPrivate));
	((GObjectClass *) klass)->constructed = rygel_media_renderer_plugin_real_constructed;
	((RygelMediaRendererPluginClass *) klass)->get_player = rygel_media_renderer_plugin_real_get_player;
	((RygelMediaRendererPluginClass *) klass)->get_controller = rygel_media_renderer_plugin_real_get_controller;
	((RygelPluginClass *) klass)->apply_hacks = rygel_media_renderer_plugin_real_apply_hacks;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_renderer_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_renderer_plugin_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_renderer_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RENDERER_PLUGIN_SUPPORTED_PROFILES, g_param_spec_pointer ("supported-profiles", "supported-profiles", "supported-profiles", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void rygel_media_renderer_plugin_instance_init (RygelMediaRendererPlugin * self) {
	self->priv = RYGEL_MEDIA_RENDERER_PLUGIN_GET_PRIVATE (self);
}


static void rygel_media_renderer_plugin_finalize (GObject* obj) {
	RygelMediaRendererPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin);
	_g_free0 (self->priv->sink_protocol_info);
	_g_object_unref0 (self->priv->controller);
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_supported_profiles);
	G_OBJECT_CLASS (rygel_media_renderer_plugin_parent_class)->finalize (obj);
}


/**
 * This is the base class for every Rygel UPnP renderer plugin.
 *
 * This class is useful when implementing Rygel renderer plugins.
 *
 * Renderer plugins should also implement their own #RygelMediaPlayer
 * and return an instance of it from their get_player() implementation.
 */
GType rygel_media_renderer_plugin_get_type (void) {
	static volatile gsize rygel_media_renderer_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_renderer_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaRendererPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_renderer_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaRendererPlugin), 0, (GInstanceInitFunc) rygel_media_renderer_plugin_instance_init, NULL };
		GType rygel_media_renderer_plugin_type_id;
		rygel_media_renderer_plugin_type_id = g_type_register_static (RYGEL_TYPE_PLUGIN, "RygelMediaRendererPlugin", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_renderer_plugin_type_id__volatile, rygel_media_renderer_plugin_type_id);
	}
	return rygel_media_renderer_plugin_type_id__volatile;
}


static void _vala_rygel_media_renderer_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaRendererPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin);
	switch (property_id) {
		case RYGEL_MEDIA_RENDERER_PLUGIN_SUPPORTED_PROFILES:
		g_value_set_pointer (value, rygel_media_renderer_plugin_get_supported_profiles (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_renderer_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaRendererPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin);
	switch (property_id) {
		case RYGEL_MEDIA_RENDERER_PLUGIN_SUPPORTED_PROFILES:
		rygel_media_renderer_plugin_set_supported_profiles (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



