/* chess-scene.c generated by valac 0.32.0.13-d82f, the Vala compiler
 * generated from chess-scene.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2014 Robert Ancell
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include "libchess.h"
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
typedef struct _ChessScenePrivate ChessScenePrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ChessModel {
	GObject parent_instance;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GObjectClass parent_class;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessScenePrivate {
	gboolean _can_move[64];
	GTimer* animation_timer;
	gdouble animation_time;
	guint animate_timeout_id;
	ChessGame* _game;
	gint _move_number;
	gboolean _show_numbering;
	gboolean _show_move_hints;
	gchar* _theme_name;
	gboolean _show_3d_smooth;
	gchar* _board_side;
	gchar* _move_format;
};


static gpointer chess_model_parent_class = NULL;
static gpointer chess_scene_parent_class = NULL;

GType chess_model_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_MODEL_DUMMY_PROPERTY,
	CHESS_MODEL_MOVING
};
ChessModel* chess_model_new (ChessPiece* piece, gdouble x, gdouble y);
ChessModel* chess_model_construct (GType object_type, ChessPiece* piece, gdouble x, gdouble y);
gboolean chess_model_move_to (ChessModel* self, gdouble x, gdouble y);
gboolean chess_model_animate (ChessModel* self, gdouble timestep);
gboolean chess_model_get_moving (ChessModel* self);
static gdouble chess_model_update_position (ChessModel* self, gdouble timestep, gdouble value, gdouble target);
static void chess_model_finalize (GObject* obj);
static void _vala_chess_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType chess_scene_get_type (void) G_GNUC_CONST;
#define CHESS_SCENE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_SCENE, ChessScenePrivate))
enum  {
	CHESS_SCENE_DUMMY_PROPERTY,
	CHESS_SCENE_GAME,
	CHESS_SCENE_MOVE_NUMBER,
	CHESS_SCENE_SHOW_NUMBERING,
	CHESS_SCENE_SHOW_MOVE_HINTS,
	CHESS_SCENE_THEME_NAME,
	CHESS_SCENE_SHOW_3D_SMOOTH,
	CHESS_SCENE_BOARD_SIDE,
	CHESS_SCENE_BOARD_ANGLE,
	CHESS_SCENE_MOVE_FORMAT
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
ChessGame* chess_scene_get_game (ChessScene* self);
gint chess_scene_get_move_number (ChessScene* self);
ChessScene* chess_scene_new (void);
ChessScene* chess_scene_construct (GType object_type);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
static void chess_scene_update_board (ChessScene* self);
static void chess_scene_moved_cb (ChessScene* self, ChessGame* game, ChessMove* move);
static void chess_scene_paused_cb (ChessScene* self, ChessGame* game);
static void chess_scene_unpaused_cb (ChessScene* self, ChessGame* game);
static void chess_scene_undo_cb (ChessScene* self, ChessGame* game);
static ChessModel* chess_scene_find_model (ChessScene* self, ChessPiece* piece);
static gboolean chess_scene_animate_cb (ChessScene* self);
static gboolean _chess_scene_animate_cb_gsource_func (gpointer self);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
void chess_scene_set_game (ChessScene* self, ChessGame* value);
static void _chess_scene_moved_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self);
static void _chess_scene_paused_cb_chess_game_paused (ChessGame* _sender, gpointer self);
static void _chess_scene_unpaused_cb_chess_game_unpaused (ChessGame* _sender, gpointer self);
static void _chess_scene_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self);
void chess_scene_set_move_number (ChessScene* self, gint value);
gboolean chess_scene_get_show_numbering (ChessScene* self);
void chess_scene_set_show_numbering (ChessScene* self, gboolean value);
gboolean chess_scene_get_show_move_hints (ChessScene* self);
void chess_scene_set_show_move_hints (ChessScene* self, gboolean value);
const gchar* chess_scene_get_theme_name (ChessScene* self);
void chess_scene_set_theme_name (ChessScene* self, const gchar* value);
gboolean chess_scene_get_show_3d_smooth (ChessScene* self);
void chess_scene_set_show_3d_smooth (ChessScene* self, gboolean value);
const gchar* chess_scene_get_board_side (ChessScene* self);
void chess_scene_set_board_side (ChessScene* self, const gchar* value);
gdouble chess_scene_get_board_angle (ChessScene* self);
const gchar* chess_scene_get_move_format (ChessScene* self);
void chess_scene_set_move_format (ChessScene* self, const gchar* value);
static void g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_ENUM__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void chess_scene_finalize (GObject* obj);
static void _vala_chess_scene_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_scene_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
#line 30 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return self ? g_object_ref (self) : NULL;
#line 173 "chess-scene.c"
}


ChessModel* chess_model_construct (GType object_type, ChessPiece* piece, gdouble x, gdouble y) {
	ChessModel * self = NULL;
	ChessPiece* _tmp0_ = NULL;
	ChessPiece* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
#line 28 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (piece != NULL, NULL);
#line 28 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self = (ChessModel*) g_object_new (object_type, NULL);
#line 30 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = piece;
#line 30 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 30 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_g_object_unref0 (self->piece);
#line 30 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->piece = _tmp1_;
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp2_ = x;
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->target_x = _tmp2_;
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp3_ = self->target_x;
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->x = _tmp3_;
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp4_ = y;
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->target_y = _tmp4_;
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp5_ = self->target_y;
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->y = _tmp5_;
#line 28 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return self;
#line 215 "chess-scene.c"
}


ChessModel* chess_model_new (ChessPiece* piece, gdouble x, gdouble y) {
#line 28 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return chess_model_construct (TYPE_CHESS_MODEL, piece, x, y);
#line 222 "chess-scene.c"
}


gboolean chess_model_move_to (ChessModel* self, gdouble x, gdouble y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = self->target_x;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp2_ = x;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp1_ == _tmp2_) {
#line 241 "chess-scene.c"
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp3_ = self->target_y;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp4_ = y;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp0_ = _tmp3_ == _tmp4_;
#line 250 "chess-scene.c"
	} else {
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp0_ = FALSE;
#line 254 "chess-scene.c"
	}
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp0_) {
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		result = FALSE;
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		return result;
#line 262 "chess-scene.c"
	}
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp5_ = x;
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->target_x = _tmp5_;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp6_ = y;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->target_y = _tmp6_;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = TRUE;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 276 "chess-scene.c"
}


gboolean chess_model_animate (ChessModel* self, gdouble timestep) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = chess_model_get_moving (self);
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = _tmp0_;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (!_tmp1_) {
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		result = FALSE;
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		return result;
#line 304 "chess-scene.c"
	}
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp2_ = timestep;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp3_ = self->x;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp4_ = self->target_x;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp5_ = chess_model_update_position (self, _tmp2_, _tmp3_, _tmp4_);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->x = _tmp5_;
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp6_ = timestep;
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp7_ = self->y;
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp8_ = self->target_y;
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp9_ = chess_model_update_position (self, _tmp6_, _tmp7_, _tmp8_);
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->y = _tmp9_;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = TRUE;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 330 "chess-scene.c"
}


static gdouble chess_model_update_position (ChessModel* self, gdouble timestep, gdouble value, gdouble target) {
	gdouble result = 0.0;
	gdouble distance = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble step = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = target;
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = value;
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp2_ = fabs (_tmp0_ - _tmp1_);
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	distance = _tmp2_;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp3_ = timestep;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	step = _tmp3_ * 4.0;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp4_ = step;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp5_ = distance;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp4_ > _tmp5_) {
#line 366 "chess-scene.c"
		gdouble _tmp6_ = 0.0;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp6_ = distance;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		step = _tmp6_;
#line 372 "chess-scene.c"
	}
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp7_ = target;
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp8_ = value;
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp7_ > _tmp8_) {
#line 380 "chess-scene.c"
		gdouble _tmp9_ = 0.0;
		gdouble _tmp10_ = 0.0;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp9_ = value;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp10_ = step;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		result = _tmp9_ + _tmp10_;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		return result;
#line 391 "chess-scene.c"
	} else {
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp11_ = value;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp12_ = step;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		result = _tmp11_ - _tmp12_;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		return result;
#line 403 "chess-scene.c"
	}
}


gboolean chess_model_get_moving (ChessModel* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = self->x;
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp2_ = self->target_x;
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp1_ != _tmp2_) {
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp0_ = TRUE;
#line 423 "chess-scene.c"
	} else {
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp3_ = self->y;
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp4_ = self->target_y;
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp0_ = _tmp3_ != _tmp4_;
#line 433 "chess-scene.c"
	}
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 439 "chess-scene.c"
}


static void chess_model_class_init (ChessModelClass * klass) {
#line 13 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	chess_model_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_model_get_property;
#line 13 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_model_finalize;
#line 13 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_MODEL_MOVING, g_param_spec_boolean ("moving", "moving", "moving", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 452 "chess-scene.c"
}


static void chess_model_instance_init (ChessModel * self) {
}


static void chess_model_finalize (GObject* obj) {
	ChessModel * self;
#line 13 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_MODEL, ChessModel);
#line 15 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_g_object_unref0 (self->piece);
#line 13 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	G_OBJECT_CLASS (chess_model_parent_class)->finalize (obj);
#line 468 "chess-scene.c"
}


GType chess_model_get_type (void) {
	static volatile gsize chess_model_type_id__volatile = 0;
	if (g_once_init_enter (&chess_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessModel), 0, (GInstanceInitFunc) chess_model_instance_init, NULL };
		GType chess_model_type_id;
		chess_model_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessModel", &g_define_type_info, 0);
		g_once_init_leave (&chess_model_type_id__volatile, chess_model_type_id);
	}
	return chess_model_type_id__volatile;
}


static void _vala_chess_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_MODEL, ChessModel);
#line 13 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	switch (property_id) {
#line 13 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_MODEL_MOVING:
#line 13 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		g_value_set_boolean (value, chess_model_get_moving (self));
#line 13 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 495 "chess-scene.c"
		default:
#line 13 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 13 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 501 "chess-scene.c"
	}
}


static void _g_object_unref0_ (gpointer var) {
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 509 "chess-scene.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_list_free (self);
#line 518 "chess-scene.c"
}


ChessPiece* chess_scene_get_selected_piece (ChessScene* self) {
	ChessPiece* result = NULL;
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessGame* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	ChessPiece* _tmp10_ = NULL;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = chess_scene_get_game (self);
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp2_ = _tmp1_;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp2_ == NULL) {
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp0_ = TRUE;
#line 544 "chess-scene.c"
	} else {
		gint _tmp3_ = 0;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp3_ = self->selected_rank;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp0_ = _tmp3_ < 0;
#line 551 "chess-scene.c"
	}
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp0_) {
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		result = NULL;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		return result;
#line 559 "chess-scene.c"
	}
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp4_ = chess_scene_get_game (self);
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp5_ = _tmp4_;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp6_ = self->selected_rank;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp7_ = self->selected_file;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp8_ = chess_scene_get_move_number (self);
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp9_ = _tmp8_;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp10_ = chess_game_get_piece (_tmp5_, _tmp6_, _tmp7_, _tmp9_);
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = _tmp10_;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 579 "chess-scene.c"
}


ChessScene* chess_scene_construct (GType object_type) {
	ChessScene * self = NULL;
	GTimer* _tmp0_ = NULL;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self = (ChessScene*) g_object_new (object_type, NULL);
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = g_timer_new ();
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_g_timer_destroy0 (self->priv->animation_timer);
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->animation_timer = _tmp0_;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return self;
#line 596 "chess-scene.c"
}


ChessScene* chess_scene_new (void) {
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return chess_scene_construct (TYPE_CHESS_SCENE);
#line 603 "chess-scene.c"
}


void chess_scene_select_square (ChessScene* self, gint file, gint rank) {
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	ChessPiece* piece = NULL;
	ChessGame* _tmp11_ = NULL;
	ChessGame* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	ChessPiece* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = chess_scene_get_game (self);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp2_ = _tmp1_;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp2_ == NULL) {
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp0_ = TRUE;
#line 634 "chess-scene.c"
	} else {
		ChessGame* _tmp3_ = NULL;
		ChessGame* _tmp4_ = NULL;
		ChessPlayer* _tmp5_ = NULL;
		ChessPlayer* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp3_ = chess_scene_get_game (self);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp4_ = _tmp3_;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp5_ = chess_game_get_current_player (_tmp4_);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp6_ = _tmp5_;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp7_ = chess_player_get_local_human (_tmp6_);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp8_ = _tmp7_;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp0_ = !_tmp8_;
#line 656 "chess-scene.c"
	}
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp0_) {
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		return;
#line 662 "chess-scene.c"
	}
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp9_ = chess_scene_get_move_number (self);
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp10_ = _tmp9_;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp10_ != -1) {
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		return;
#line 672 "chess-scene.c"
	}
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp11_ = chess_scene_get_game (self);
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp12_ = _tmp11_;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp13_ = rank;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp14_ = file;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp15_ = chess_scene_get_move_number (self);
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp16_ = _tmp15_;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp17_ = chess_game_get_piece (_tmp12_, _tmp13_, _tmp14_, _tmp16_);
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	piece = _tmp17_;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp19_ = file;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp20_ = self->selected_file;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp19_ == _tmp20_) {
#line 696 "chess-scene.c"
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp21_ = rank;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp22_ = self->selected_rank;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp18_ = _tmp21_ == _tmp22_;
#line 705 "chess-scene.c"
	} else {
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp18_ = FALSE;
#line 709 "chess-scene.c"
	}
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp18_) {
#line 713 "chess-scene.c"
		gint _tmp23_ = 0;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		self->selected_file = -1;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp23_ = self->selected_file;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		self->selected_rank = _tmp23_;
#line 721 "chess-scene.c"
	} else {
		gboolean _tmp24_ = FALSE;
		ChessPiece* _tmp25_ = NULL;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp25_ = piece;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		if (_tmp25_ != NULL) {
#line 729 "chess-scene.c"
			ChessPiece* _tmp26_ = NULL;
			ChessPlayer* _tmp27_ = NULL;
			ChessGame* _tmp28_ = NULL;
			ChessGame* _tmp29_ = NULL;
			ChessPlayer* _tmp30_ = NULL;
			ChessPlayer* _tmp31_ = NULL;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp26_ = piece;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp27_ = _tmp26_->player;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp28_ = chess_scene_get_game (self);
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp29_ = _tmp28_;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp30_ = chess_game_get_current_player (_tmp29_);
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp31_ = _tmp30_;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp24_ = _tmp27_ == _tmp31_;
#line 750 "chess-scene.c"
		} else {
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp24_ = FALSE;
#line 754 "chess-scene.c"
		}
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		if (_tmp24_) {
#line 758 "chess-scene.c"
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
#line 221 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp32_ = rank;
#line 221 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			self->selected_rank = _tmp32_;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp33_ = file;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			self->selected_file = _tmp33_;
#line 769 "chess-scene.c"
		} else {
			gint _tmp34_ = 0;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp34_ = self->selected_file;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			if (_tmp34_ != -1) {
#line 776 "chess-scene.c"
				gboolean can_move = FALSE;
				ChessGame* _tmp35_ = NULL;
				ChessGame* _tmp36_ = NULL;
				ChessPlayer* _tmp37_ = NULL;
				ChessPlayer* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				gboolean _tmp43_ = FALSE;
				gboolean _tmp44_ = FALSE;
				gboolean _tmp45_ = FALSE;
				gboolean _tmp46_ = FALSE;
				gboolean _tmp65_ = FALSE;
				gint _tmp66_ = 0;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp35_ = chess_scene_get_game (self);
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp36_ = _tmp35_;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp37_ = chess_game_get_current_player (_tmp36_);
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp38_ = _tmp37_;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp39_ = self->selected_rank;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp40_ = self->selected_file;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp41_ = rank;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp42_ = file;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp43_ = chess_player_move_with_coords (_tmp38_, _tmp39_, _tmp40_, _tmp41_, _tmp42_, FALSE, PIECE_TYPE_QUEEN);
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				can_move = _tmp43_;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp46_ = can_move;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				if (_tmp46_) {
#line 816 "chess-scene.c"
					ChessPiece* _tmp47_ = NULL;
					ChessPiece* _tmp48_ = NULL;
					PieceType _tmp49_ = 0;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp47_ = chess_scene_get_selected_piece (self);
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp48_ = _tmp47_;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp49_ = _tmp48_->type;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp45_ = _tmp49_ == PIECE_TYPE_PAWN;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_g_object_unref0 (_tmp48_);
#line 830 "chess-scene.c"
				} else {
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp45_ = FALSE;
#line 834 "chess-scene.c"
				}
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				if (_tmp45_) {
#line 838 "chess-scene.c"
					gboolean _tmp50_ = FALSE;
					gint _tmp51_ = 0;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp51_ = rank;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					if (_tmp51_ == 0) {
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
						_tmp50_ = TRUE;
#line 847 "chess-scene.c"
					} else {
						gint _tmp52_ = 0;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
						_tmp52_ = rank;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
						_tmp50_ = _tmp52_ == 7;
#line 854 "chess-scene.c"
					}
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp44_ = _tmp50_;
#line 858 "chess-scene.c"
				} else {
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp44_ = FALSE;
#line 862 "chess-scene.c"
				}
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				if (_tmp44_) {
#line 866 "chess-scene.c"
					PieceType* promotion_selection = NULL;
					PieceType* _tmp53_ = NULL;
					PieceType* _tmp54_ = NULL;
					ChessGame* _tmp55_ = NULL;
					ChessGame* _tmp56_ = NULL;
					ChessPlayer* _tmp57_ = NULL;
					ChessPlayer* _tmp58_ = NULL;
					gint _tmp59_ = 0;
					gint _tmp60_ = 0;
					gint _tmp61_ = 0;
					gint _tmp62_ = 0;
					PieceType* _tmp63_ = NULL;
					gint _tmp64_ = 0;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					g_signal_emit_by_name (self, "choose-promotion-type", &_tmp53_);
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					promotion_selection = _tmp53_;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp54_ = promotion_selection;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					if (_tmp54_ == NULL) {
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
						_g_free0 (promotion_selection);
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
						_g_object_unref0 (piece);
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
						return;
#line 894 "chess-scene.c"
					}
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp55_ = chess_scene_get_game (self);
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp56_ = _tmp55_;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp57_ = chess_game_get_current_player (_tmp56_);
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp58_ = _tmp57_;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp59_ = self->selected_rank;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp60_ = self->selected_file;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp61_ = rank;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp62_ = file;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp63_ = promotion_selection;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					chess_player_move_with_coords (_tmp58_, _tmp59_, _tmp60_, _tmp61_, _tmp62_, TRUE, *_tmp63_);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					self->selected_file = -1;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp64_ = self->selected_file;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					self->selected_rank = _tmp64_;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_g_free0 (promotion_selection);
#line 924 "chess-scene.c"
				}
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp66_ = self->selected_file;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				if (_tmp66_ != -1) {
#line 930 "chess-scene.c"
					ChessGame* _tmp67_ = NULL;
					ChessGame* _tmp68_ = NULL;
					ChessPlayer* _tmp69_ = NULL;
					ChessPlayer* _tmp70_ = NULL;
					gint _tmp71_ = 0;
					gint _tmp72_ = 0;
					gint _tmp73_ = 0;
					gint _tmp74_ = 0;
					gboolean _tmp75_ = FALSE;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp67_ = chess_scene_get_game (self);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp68_ = _tmp67_;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp69_ = chess_game_get_current_player (_tmp68_);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp70_ = _tmp69_;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp71_ = self->selected_rank;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp72_ = self->selected_file;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp73_ = rank;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp74_ = file;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp75_ = chess_player_move_with_coords (_tmp70_, _tmp71_, _tmp72_, _tmp73_, _tmp74_, TRUE, PIECE_TYPE_QUEEN);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp65_ = _tmp75_;
#line 960 "chess-scene.c"
				} else {
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp65_ = FALSE;
#line 964 "chess-scene.c"
				}
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				if (_tmp65_) {
#line 968 "chess-scene.c"
					gint _tmp76_ = 0;
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					self->selected_file = -1;
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp76_ = self->selected_file;
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					self->selected_rank = _tmp76_;
#line 976 "chess-scene.c"
				}
			}
		}
	}
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	chess_scene_update_board (self);
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_g_object_unref0 (piece);
#line 987 "chess-scene.c"
}


static void chess_scene_moved_cb (ChessScene* self, ChessGame* game, ChessMove* move) {
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (game != NULL);
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (move != NULL);
#line 255 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	chess_scene_update_board (self);
#line 1000 "chess-scene.c"
}


static void chess_scene_paused_cb (ChessScene* self, ChessGame* game) {
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (game != NULL);
#line 260 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 1011 "chess-scene.c"
}


static void chess_scene_unpaused_cb (ChessScene* self, ChessGame* game) {
#line 263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (game != NULL);
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 1022 "chess-scene.c"
}


static void chess_scene_undo_cb (ChessScene* self, ChessGame* game) {
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (game != NULL);
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	chess_scene_update_board (self);
#line 1033 "chess-scene.c"
}


static ChessModel* chess_scene_find_model (ChessScene* self, ChessPiece* piece) {
	ChessModel* result = NULL;
	GList* _tmp0_ = NULL;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (piece != NULL, NULL);
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->pieces;
#line 1046 "chess-scene.c"
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		model_collection = _tmp0_;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
#line 1054 "chess-scene.c"
			ChessModel* _tmp1_ = NULL;
			ChessModel* model = NULL;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp1_ = _g_object_ref0 ((ChessModel*) model_it->data);
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			model = _tmp1_;
#line 1061 "chess-scene.c"
			{
				ChessModel* _tmp2_ = NULL;
				ChessPiece* _tmp3_ = NULL;
				ChessPiece* _tmp4_ = NULL;
#line 276 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp2_ = model;
#line 276 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp3_ = _tmp2_->piece;
#line 276 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp4_ = piece;
#line 276 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				if (_tmp3_ == _tmp4_) {
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					result = model;
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					return result;
#line 1078 "chess-scene.c"
				}
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_g_object_unref0 (model);
#line 1082 "chess-scene.c"
			}
		}
	}
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = NULL;
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 1090 "chess-scene.c"
}


static gboolean _chess_scene_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_scene_animate_cb ((ChessScene*) self);
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 1099 "chess-scene.c"
}


static void chess_scene_update_board (ChessScene* self) {
	ChessGame* _tmp0_ = NULL;
	ChessGame* _tmp1_ = NULL;
	gboolean board_changed = FALSE;
	gboolean need_animation = FALSE;
	GList* new_pieces = NULL;
	GList* _tmp59_ = NULL;
	guint _tmp60_ = 0U;
	GList* _tmp61_ = NULL;
	guint _tmp62_ = 0U;
	gboolean _tmp63_ = FALSE;
	GList* _tmp64_ = NULL;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp69_ = FALSE;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = chess_scene_get_game (self);
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = _tmp0_;
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp1_ == NULL) {
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		return;
#line 1127 "chess-scene.c"
	}
#line 286 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	board_changed = FALSE;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	need_animation = FALSE;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	new_pieces = NULL;
#line 1135 "chess-scene.c"
	{
		gint rank = 0;
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		rank = 0;
#line 1140 "chess-scene.c"
		{
			gboolean _tmp2_ = FALSE;
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp2_ = TRUE;
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			while (TRUE) {
#line 1147 "chess-scene.c"
				gint _tmp4_ = 0;
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				if (!_tmp2_) {
#line 1151 "chess-scene.c"
					gint _tmp3_ = 0;
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp3_ = rank;
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					rank = _tmp3_ + 1;
#line 1157 "chess-scene.c"
				}
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp2_ = FALSE;
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp4_ = rank;
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				if (!(_tmp4_ < 8)) {
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					break;
#line 1167 "chess-scene.c"
				}
				{
					gint file = 0;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					file = 0;
#line 1173 "chess-scene.c"
					{
						gboolean _tmp5_ = FALSE;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
						_tmp5_ = TRUE;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
						while (TRUE) {
#line 1180 "chess-scene.c"
							gint _tmp7_ = 0;
							gboolean can_move = FALSE;
							gboolean _tmp8_ = FALSE;
							gboolean _tmp9_ = FALSE;
							gint _tmp10_ = 0;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							gboolean _tmp24_ = FALSE;
							gboolean _tmp25_ = FALSE;
							ChessPiece* piece = NULL;
							ChessGame* _tmp26_ = NULL;
							ChessGame* _tmp27_ = NULL;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							ChessPiece* _tmp32_ = NULL;
							ChessPiece* _tmp33_ = NULL;
							ChessModel* model = NULL;
							ChessPiece* _tmp34_ = NULL;
							ChessModel* _tmp35_ = NULL;
							ChessModel* _tmp36_ = NULL;
							ChessModel* _tmp41_ = NULL;
							gboolean _tmp42_ = FALSE;
							ChessModel* _tmp43_ = NULL;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gboolean _tmp46_ = FALSE;
							gboolean _tmp47_ = FALSE;
							gboolean _tmp48_ = FALSE;
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							ChessModel* _tmp57_ = NULL;
							ChessModel* _tmp58_ = NULL;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							if (!_tmp5_) {
#line 1217 "chess-scene.c"
								gint _tmp6_ = 0;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp6_ = file;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								file = _tmp6_ + 1;
#line 1223 "chess-scene.c"
							}
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp5_ = FALSE;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp7_ = file;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							if (!(_tmp7_ < 8)) {
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								break;
#line 1233 "chess-scene.c"
							}
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							can_move = FALSE;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp10_ = self->selected_rank;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							if (_tmp10_ >= 0) {
#line 1241 "chess-scene.c"
								gint _tmp11_ = 0;
								gint _tmp12_ = 0;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp11_ = chess_scene_get_move_number (self);
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp12_ = _tmp11_;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp9_ = _tmp12_ == -1;
#line 1250 "chess-scene.c"
							} else {
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp9_ = FALSE;
#line 1254 "chess-scene.c"
							}
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							if (_tmp9_) {
#line 1258 "chess-scene.c"
								ChessGame* _tmp13_ = NULL;
								ChessGame* _tmp14_ = NULL;
								ChessPlayer* _tmp15_ = NULL;
								ChessPlayer* _tmp16_ = NULL;
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								gboolean _tmp21_ = FALSE;
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp13_ = chess_scene_get_game (self);
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp14_ = _tmp13_;
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp15_ = chess_game_get_current_player (_tmp14_);
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp16_ = _tmp15_;
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp17_ = self->selected_rank;
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp18_ = self->selected_file;
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp19_ = rank;
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp20_ = file;
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp21_ = chess_player_move_with_coords (_tmp16_, _tmp17_, _tmp18_, _tmp19_, _tmp20_, FALSE, PIECE_TYPE_QUEEN);
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp8_ = _tmp21_;
#line 1288 "chess-scene.c"
							} else {
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp8_ = FALSE;
#line 1292 "chess-scene.c"
							}
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							if (_tmp8_) {
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								can_move = TRUE;
#line 1298 "chess-scene.c"
							}
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp22_ = rank;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp23_ = file;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp24_ = can_move;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							self->priv->_can_move[(_tmp22_ * 8) + _tmp23_] = _tmp24_;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp25_ = self->priv->_can_move[(_tmp22_ * 8) + _tmp23_];
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp26_ = chess_scene_get_game (self);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp27_ = _tmp26_;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp28_ = rank;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp29_ = file;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp30_ = chess_scene_get_move_number (self);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp31_ = _tmp30_;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp32_ = chess_game_get_piece (_tmp27_, _tmp28_, _tmp29_, _tmp31_);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							piece = _tmp32_;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp33_ = piece;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							if (_tmp33_ == NULL) {
#line 301 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_g_object_unref0 (piece);
#line 301 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								continue;
#line 1334 "chess-scene.c"
							}
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp34_ = piece;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp35_ = chess_scene_find_model (self, _tmp34_);
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							model = _tmp35_;
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp36_ = model;
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							if (_tmp36_ == NULL) {
#line 1346 "chess-scene.c"
								ChessPiece* _tmp37_ = NULL;
								gint _tmp38_ = 0;
								gint _tmp39_ = 0;
								ChessModel* _tmp40_ = NULL;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp37_ = piece;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp38_ = file;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp39_ = rank;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp40_ = chess_model_new (_tmp37_, (gdouble) _tmp38_, (gdouble) _tmp39_);
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_g_object_unref0 (model);
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								model = _tmp40_;
#line 306 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								board_changed = TRUE;
#line 1365 "chess-scene.c"
							}
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp41_ = model;
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp42_ = can_move;
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp41_->under_threat = _tmp42_;
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp43_ = model;
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp44_ = file;
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp45_ = rank;
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp46_ = chess_model_move_to (_tmp43_, (gdouble) _tmp44_, (gdouble) _tmp45_);
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							if (_tmp46_) {
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								board_changed = TRUE;
#line 313 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								need_animation = TRUE;
#line 1387 "chess-scene.c"
							}
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp49_ = chess_scene_get_move_number (self);
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp50_ = _tmp49_;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							if (_tmp50_ == -1) {
#line 1395 "chess-scene.c"
								gint _tmp51_ = 0;
								gint _tmp52_ = 0;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp51_ = rank;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp52_ = self->selected_rank;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp48_ = _tmp51_ == _tmp52_;
#line 1404 "chess-scene.c"
							} else {
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp48_ = FALSE;
#line 1408 "chess-scene.c"
							}
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							if (_tmp48_) {
#line 1412 "chess-scene.c"
								gint _tmp53_ = 0;
								gint _tmp54_ = 0;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp53_ = file;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp54_ = self->selected_file;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp47_ = _tmp53_ == _tmp54_;
#line 1421 "chess-scene.c"
							} else {
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp47_ = FALSE;
#line 1425 "chess-scene.c"
							}
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							if (_tmp47_) {
#line 1429 "chess-scene.c"
								ChessModel* _tmp55_ = NULL;
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp55_ = model;
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp55_->is_selected = TRUE;
#line 1435 "chess-scene.c"
							} else {
								ChessModel* _tmp56_ = NULL;
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp56_ = model;
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
								_tmp56_->is_selected = FALSE;
#line 1442 "chess-scene.c"
							}
#line 321 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp57_ = model;
#line 321 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_tmp58_ = _g_object_ref0 (_tmp57_);
#line 321 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							new_pieces = g_list_append (new_pieces, _tmp58_);
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_g_object_unref0 (model);
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
							_g_object_unref0 (piece);
#line 1454 "chess-scene.c"
						}
					}
				}
			}
		}
	}
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp59_ = new_pieces;
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp60_ = g_list_length (_tmp59_);
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp61_ = self->pieces;
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp62_ = g_list_length (_tmp61_);
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp60_ != _tmp62_) {
#line 326 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		board_changed = TRUE;
#line 1473 "chess-scene.c"
	}
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp63_ = board_changed;
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (!_tmp63_) {
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		__g_list_free__g_object_unref0_0 (new_pieces);
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		return;
#line 1483 "chess-scene.c"
	}
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	__g_list_free__g_object_unref0_0 (self->pieces);
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->pieces = NULL;
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp64_ = new_pieces;
#line 1491 "chess-scene.c"
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		model_collection = _tmp64_;
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
#line 1499 "chess-scene.c"
			ChessModel* _tmp65_ = NULL;
			ChessModel* model = NULL;
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp65_ = _g_object_ref0 ((ChessModel*) model_it->data);
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			model = _tmp65_;
#line 1506 "chess-scene.c"
			{
				ChessModel* _tmp66_ = NULL;
				ChessModel* _tmp67_ = NULL;
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp66_ = model;
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp67_ = _g_object_ref0 (_tmp66_);
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				self->pieces = g_list_append (self->pieces, _tmp67_);
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_g_object_unref0 (model);
#line 1518 "chess-scene.c"
			}
		}
	}
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp69_ = need_animation;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp69_) {
#line 1528 "chess-scene.c"
		gboolean _tmp70_ = FALSE;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp70_ = self->animating;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp68_ = !_tmp70_;
#line 1534 "chess-scene.c"
	} else {
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp68_ = FALSE;
#line 1538 "chess-scene.c"
	}
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp68_) {
#line 1542 "chess-scene.c"
		GTimer* _tmp71_ = NULL;
		ChessGame* _tmp72_ = NULL;
		ChessGame* _tmp73_ = NULL;
		guint _tmp74_ = 0U;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		self->animating = TRUE;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp71_ = self->priv->animation_timer;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		g_timer_start (_tmp71_);
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		self->priv->animation_time = (gdouble) 0;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp72_ = chess_scene_get_game (self);
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp73_ = _tmp72_;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		chess_game_add_hold (_tmp73_);
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp74_ = g_timeout_add_full (G_PRIORITY_DEFAULT_IDLE, (guint) 10, _chess_scene_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		self->priv->animate_timeout_id = _tmp74_;
#line 1565 "chess-scene.c"
	}
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	__g_list_free__g_object_unref0_0 (new_pieces);
#line 1569 "chess-scene.c"
}


gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = rank;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = file;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp2_ = self->priv->_can_move[(_tmp0_ * 8) + _tmp1_];
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = _tmp2_;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 1590 "chess-scene.c"
}


static gboolean chess_scene_animate_cb (ChessScene* self) {
	gboolean result = FALSE;
	gdouble old_time = 0.0;
	gdouble _tmp0_ = 0.0;
	GTimer* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble timestep = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gint animate_count = 0;
	GList* _tmp5_ = NULL;
	gint _tmp11_ = 0;
	gboolean _tmp12_ = FALSE;
	ChessGame* _tmp13_ = NULL;
	ChessGame* _tmp14_ = NULL;
#line 354 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 357 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->animation_time;
#line 357 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	old_time = _tmp0_;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = self->priv->animation_timer;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp2_ = g_timer_elapsed (_tmp1_, NULL);
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->animation_time = _tmp2_;
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp3_ = self->priv->animation_time;
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp4_ = old_time;
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	timestep = _tmp3_ - _tmp4_;
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	animate_count = 0;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp5_ = self->pieces;
#line 1631 "chess-scene.c"
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		model_collection = _tmp5_;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
#line 1639 "chess-scene.c"
			ChessModel* _tmp6_ = NULL;
			ChessModel* model = NULL;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			_tmp6_ = _g_object_ref0 ((ChessModel*) model_it->data);
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
			model = _tmp6_;
#line 1646 "chess-scene.c"
			{
				ChessModel* _tmp7_ = NULL;
				gdouble _tmp8_ = 0.0;
				gboolean _tmp9_ = FALSE;
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp7_ = model;
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp8_ = timestep;
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp9_ = chess_model_animate (_tmp7_, _tmp8_);
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				if (_tmp9_) {
#line 1659 "chess-scene.c"
					gint _tmp10_ = 0;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp10_ = animate_count;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					animate_count = _tmp10_ + 1;
#line 1665 "chess-scene.c"
				}
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_g_object_unref0 (model);
#line 1669 "chess-scene.c"
			}
		}
	}
#line 367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp11_ = animate_count;
#line 367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->animating = _tmp11_ > 0;
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp12_ = self->animating;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp12_) {
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		result = G_SOURCE_CONTINUE;
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		return result;
#line 1687 "chess-scene.c"
	}
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp13_ = chess_scene_get_game (self);
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp14_ = _tmp13_;
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	chess_game_remove_hold (_tmp14_);
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = G_SOURCE_REMOVE;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 1699 "chess-scene.c"
}


ChessGame* chess_scene_get_game (ChessScene* self) {
	ChessGame* result;
	ChessGame* _tmp0_ = NULL;
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_game;
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 1714 "chess-scene.c"
}


static void _chess_scene_moved_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self) {
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	chess_scene_moved_cb ((ChessScene*) self, _sender, move);
#line 1721 "chess-scene.c"
}


static void _chess_scene_paused_cb_chess_game_paused (ChessGame* _sender, gpointer self) {
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	chess_scene_paused_cb ((ChessScene*) self, _sender);
#line 1728 "chess-scene.c"
}


static void _chess_scene_unpaused_cb_chess_game_unpaused (ChessGame* _sender, gpointer self) {
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	chess_scene_unpaused_cb ((ChessScene*) self, _sender);
#line 1735 "chess-scene.c"
}


static void _chess_scene_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self) {
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	chess_scene_undo_cb ((ChessScene*) self, _sender);
#line 1742 "chess-scene.c"
}


void chess_scene_set_game (ChessScene* self, ChessGame* value) {
	guint _tmp0_ = 0U;
	ChessGame* _tmp2_ = NULL;
	ChessGame* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessGame* _tmp5_ = NULL;
	ChessGame* _tmp6_ = NULL;
	ChessGame* _tmp7_ = NULL;
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->animate_timeout_id;
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 1760 "chess-scene.c"
		guint _tmp1_ = 0U;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		_tmp1_ = self->priv->animate_timeout_id;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		g_source_remove (_tmp1_);
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		self->priv->animate_timeout_id = (guint) 0;
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		self->animating = FALSE;
#line 1770 "chess-scene.c"
	}
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp2_ = value;
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_g_object_unref0 (self->priv->_game);
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_game = _tmp3_;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_move_number = -1;
#line 103 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->selected_rank = -1;
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->selected_file = -1;
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp4_ = self->priv->_game;
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_connect_object (_tmp4_, "moved", (GCallback) _chess_scene_moved_cb_chess_game_moved, self, 0);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp5_ = self->priv->_game;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_connect_object (_tmp5_, "paused", (GCallback) _chess_scene_paused_cb_chess_game_paused, self, 0);
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp6_ = self->priv->_game;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_connect_object (_tmp6_, "unpaused", (GCallback) _chess_scene_unpaused_cb_chess_game_unpaused, self, 0);
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp7_ = self->priv->_game;
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_connect_object (_tmp7_, "undo", (GCallback) _chess_scene_undo_cb_chess_game_undo, self, 0);
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	chess_scene_update_board (self);
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "game");
#line 1806 "chess-scene.c"
}


gint chess_scene_get_move_number (ChessScene* self) {
	gint result;
	gint _tmp0_ = 0;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_move_number;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 1821 "chess-scene.c"
}


void chess_scene_set_move_number (ChessScene* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_move_number;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = value;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp0_ == _tmp1_) {
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		return;
#line 1839 "chess-scene.c"
	}
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp2_ = value;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_move_number = _tmp2_;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	chess_scene_update_board (self);
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "move-number");
#line 1849 "chess-scene.c"
}


gboolean chess_scene_get_show_numbering (ChessScene* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_show_numbering;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 1864 "chess-scene.c"
}


void chess_scene_set_show_numbering (ChessScene* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = value;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_show_numbering = _tmp0_;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "show-numbering");
#line 1880 "chess-scene.c"
}


gboolean chess_scene_get_show_move_hints (ChessScene* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_show_move_hints;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 1895 "chess-scene.c"
}


void chess_scene_set_show_move_hints (ChessScene* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = value;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_show_move_hints = _tmp0_;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "show-move-hints");
#line 1911 "chess-scene.c"
}


const gchar* chess_scene_get_theme_name (ChessScene* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_theme_name;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 1926 "chess-scene.c"
}


void chess_scene_set_theme_name (ChessScene* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = value;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_g_free0 (self->priv->_theme_name);
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_theme_name = _tmp1_;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "theme-name");
#line 1947 "chess-scene.c"
}


gboolean chess_scene_get_show_3d_smooth (ChessScene* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_show_3d_smooth;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 1962 "chess-scene.c"
}


void chess_scene_set_show_3d_smooth (ChessScene* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = value;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_show_3d_smooth = _tmp0_;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "show-3d-smooth");
#line 1978 "chess-scene.c"
}


const gchar* chess_scene_get_board_side (ChessScene* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_board_side;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 1993 "chess-scene.c"
}


void chess_scene_set_board_side (ChessScene* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = value;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_g_free0 (self->priv->_board_side);
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_board_side = _tmp1_;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "board-side");
#line 2014 "chess-scene.c"
}


gdouble chess_scene_get_board_angle (ChessScene* self) {
	gdouble result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GQuark _tmp4_ = 0U;
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	static GQuark _tmp3_label0 = 0;
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	static GQuark _tmp3_label1 = 0;
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	static GQuark _tmp3_label2 = 0;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = chess_scene_get_board_side (self);
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = _tmp0_;
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp2_ = _tmp1_;
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("black")))) {
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		switch (0) {
#line 2044 "chess-scene.c"
			default:
			{
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				result = 180.0;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				return result;
#line 2051 "chess-scene.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("human")))) {
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		switch (0) {
#line 2057 "chess-scene.c"
			default:
			{
				ChessGame* _tmp5_ = NULL;
				ChessGame* _tmp6_ = NULL;
				ChessPlayer* _tmp7_ = NULL;
				ChessPlayer* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp5_ = chess_scene_get_game (self);
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp6_ = _tmp5_;
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp7_ = chess_game_get_black (_tmp6_);
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp8_ = _tmp7_;
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				g_signal_emit_by_name (self, "is-human", _tmp8_, &_tmp9_);
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				if (_tmp9_) {
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					result = 180.0;
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					return result;
#line 2081 "chess-scene.c"
				} else {
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					result = 0.0;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					return result;
#line 2087 "chess-scene.c"
				}
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("current")))) {
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		switch (0) {
#line 2094 "chess-scene.c"
			default:
			{
				gdouble _tmp10_ = 0.0;
				ChessGame* _tmp11_ = NULL;
				ChessGame* _tmp12_ = NULL;
				ChessPlayer* _tmp13_ = NULL;
				ChessPlayer* _tmp14_ = NULL;
				Color _tmp15_ = 0;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp11_ = chess_scene_get_game (self);
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp12_ = _tmp11_;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp13_ = chess_game_get_current_player (_tmp12_);
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp14_ = _tmp13_;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				_tmp15_ = _tmp14_->color;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				if (_tmp15_ == COLOR_WHITE) {
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp10_ = 0.0;
#line 2117 "chess-scene.c"
				} else {
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
					_tmp10_ = 180.0;
#line 2121 "chess-scene.c"
				}
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				result = _tmp10_;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				return result;
#line 2127 "chess-scene.c"
			}
		}
	} else {
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		switch (0) {
#line 2133 "chess-scene.c"
			default:
			{
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				result = 0.0;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
				return result;
#line 2140 "chess-scene.c"
			}
		}
	}
}


const gchar* chess_scene_get_move_format (ChessScene* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_move_format;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	return result;
#line 2158 "chess-scene.c"
}


void chess_scene_set_move_format (ChessScene* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = value;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_g_free0 (self->priv->_move_format);
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_move_format = _tmp1_;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "move-format");
#line 2179 "chess-scene.c"
}


static void g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__OBJECT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (return_value != NULL);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (n_param_values == 2);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		data1 = closure->data;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		data2 = param_values->data[0].v_pointer;
#line 2201 "chess-scene.c"
	} else {
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		data1 = param_values->data[0].v_pointer;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		data2 = closure->data;
#line 2207 "chess-scene.c"
	}
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	callback = (GMarshalFunc_BOOLEAN__OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	v_return = callback (data1, g_value_get_object (param_values + 1), data2);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_value_set_boolean (return_value, v_return);
#line 2215 "chess-scene.c"
}


static void g_cclosure_user_marshal_ENUM__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gint (*GMarshalFunc_ENUM__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_ENUM__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gint v_return;
	cc = (GCClosure *) closure;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (return_value != NULL);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (n_param_values == 1);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		data1 = closure->data;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		data2 = param_values->data[0].v_pointer;
#line 2237 "chess-scene.c"
	} else {
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		data1 = param_values->data[0].v_pointer;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		data2 = closure->data;
#line 2243 "chess-scene.c"
	}
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	callback = (GMarshalFunc_ENUM__VOID) (marshal_data ? marshal_data : cc->callback);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	v_return = callback (data1, data2);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_value_set_enum (return_value, v_return);
#line 2251 "chess-scene.c"
}


static void chess_scene_class_init (ChessSceneClass * klass) {
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	chess_scene_parent_class = g_type_class_peek_parent (klass);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_type_class_add_private (klass, sizeof (ChessScenePrivate));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_scene_get_property;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_scene_set_property;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_scene_finalize;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_GAME, g_param_spec_object ("game", "game", "game", TYPE_CHESS_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_MOVE_NUMBER, g_param_spec_int ("move-number", "move-number", "move-number", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_NUMBERING, g_param_spec_boolean ("show-numbering", "show-numbering", "show-numbering", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_MOVE_HINTS, g_param_spec_boolean ("show-move-hints", "show-move-hints", "show-move-hints", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_THEME_NAME, g_param_spec_string ("theme-name", "theme-name", "theme-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_3D_SMOOTH, g_param_spec_boolean ("show-3d-smooth", "show-3d-smooth", "show-3d-smooth", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_BOARD_SIDE, g_param_spec_string ("board-side", "board-side", "board-side", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_BOARD_ANGLE, g_param_spec_double ("board-angle", "board-angle", "board-angle", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_MOVE_FORMAT, g_param_spec_string ("move-format", "move-format", "move-format", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_new ("is_human", TYPE_CHESS_SCENE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__OBJECT, G_TYPE_BOOLEAN, 1, TYPE_CHESS_PLAYER);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_new ("choose_promotion_type", TYPE_CHESS_SCENE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_ENUM__VOID, TYPE_PIECE_TYPE, 0);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	g_signal_new ("changed", TYPE_CHESS_SCENE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 2290 "chess-scene.c"
}


static void chess_scene_instance_init (ChessScene * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv = CHESS_SCENE_GET_PRIVATE (self);
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->pieces = NULL;
#line 76 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->animating = FALSE;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->selected_rank = -1;
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->selected_file = -1;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->animate_timeout_id = (guint) 0;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_game = NULL;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_move_number = -1;
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_show_numbering = TRUE;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_show_move_hints = TRUE;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp0_ = g_strdup ("simple");
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_theme_name = _tmp0_;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_show_3d_smooth = FALSE;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp1_ = g_strdup ("human");
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_board_side = _tmp1_;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_tmp2_ = g_strdup ("human");
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self->priv->_move_format = _tmp2_;
#line 2332 "chess-scene.c"
}


static void chess_scene_finalize (GObject* obj) {
	ChessScene * self;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_SCENE, ChessScene);
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	__g_list_free__g_object_unref0_0 (self->pieces);
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_g_timer_destroy0 (self->priv->animation_timer);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_g_object_unref0 (self->priv->_game);
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_g_free0 (self->priv->_theme_name);
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_g_free0 (self->priv->_board_side);
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	_g_free0 (self->priv->_move_format);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	G_OBJECT_CLASS (chess_scene_parent_class)->finalize (obj);
#line 2354 "chess-scene.c"
}


GType chess_scene_get_type (void) {
	static volatile gsize chess_scene_type_id__volatile = 0;
	if (g_once_init_enter (&chess_scene_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessSceneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_scene_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessScene), 0, (GInstanceInitFunc) chess_scene_instance_init, NULL };
		GType chess_scene_type_id;
		chess_scene_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessScene", &g_define_type_info, 0);
		g_once_init_leave (&chess_scene_type_id__volatile, chess_scene_type_id);
	}
	return chess_scene_type_id__volatile;
}


static void _vala_chess_scene_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessScene * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_SCENE, ChessScene);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	switch (property_id) {
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_GAME:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		g_value_set_object (value, chess_scene_get_game (self));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_MOVE_NUMBER:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		g_value_set_int (value, chess_scene_get_move_number (self));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_SHOW_NUMBERING:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		g_value_set_boolean (value, chess_scene_get_show_numbering (self));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_SHOW_MOVE_HINTS:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		g_value_set_boolean (value, chess_scene_get_show_move_hints (self));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_THEME_NAME:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		g_value_set_string (value, chess_scene_get_theme_name (self));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_SHOW_3D_SMOOTH:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		g_value_set_boolean (value, chess_scene_get_show_3d_smooth (self));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_BOARD_SIDE:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		g_value_set_string (value, chess_scene_get_board_side (self));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_BOARD_ANGLE:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		g_value_set_double (value, chess_scene_get_board_angle (self));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_MOVE_FORMAT:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		g_value_set_string (value, chess_scene_get_move_format (self));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 2429 "chess-scene.c"
		default:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 2435 "chess-scene.c"
	}
}


static void _vala_chess_scene_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessScene * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_SCENE, ChessScene);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
	switch (property_id) {
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_GAME:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		chess_scene_set_game (self, g_value_get_object (value));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_MOVE_NUMBER:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		chess_scene_set_move_number (self, g_value_get_int (value));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_SHOW_NUMBERING:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		chess_scene_set_show_numbering (self, g_value_get_boolean (value));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_SHOW_MOVE_HINTS:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		chess_scene_set_show_move_hints (self, g_value_get_boolean (value));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_THEME_NAME:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		chess_scene_set_theme_name (self, g_value_get_string (value));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_SHOW_3D_SMOOTH:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		chess_scene_set_show_3d_smooth (self, g_value_get_boolean (value));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_BOARD_SIDE:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		chess_scene_set_board_side (self, g_value_get_string (value));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_MOVE_FORMAT:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		chess_scene_set_move_format (self, g_value_get_string (value));
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 2493 "chess-scene.c"
		default:
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-chess/src/chess-scene.vala"
		break;
#line 2499 "chess-scene.c"
	}
}



