/* database.c generated by valac 0.32.0, the Vala compiler
 * generated from database.vala, do not modify */

/*
 * Copyright (C) 2009,2011 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <rygel-core.h>


#define RYGEL_DATABASE_TYPE_FLAVOR (rygel_database_flavor_get_type ())

#define RYGEL_DATABASE_TYPE_FLAGS (rygel_database_flags_get_type ())

#define RYGEL_DATABASE_TYPE_DATABASE (rygel_database_database_get_type ())
#define RYGEL_DATABASE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_DATABASE_TYPE_DATABASE, RygelDatabaseDatabase))
#define RYGEL_DATABASE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_DATABASE_TYPE_DATABASE, RygelDatabaseDatabaseClass))
#define RYGEL_DATABASE_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_DATABASE_TYPE_DATABASE))
#define RYGEL_DATABASE_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_DATABASE_TYPE_DATABASE))
#define RYGEL_DATABASE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_DATABASE_TYPE_DATABASE, RygelDatabaseDatabaseClass))

typedef struct _RygelDatabaseDatabase RygelDatabaseDatabase;
typedef struct _RygelDatabaseDatabaseClass RygelDatabaseDatabaseClass;
typedef struct _RygelDatabaseDatabasePrivate RygelDatabaseDatabasePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_DATABASE_TYPE_CURSOR (rygel_database_cursor_get_type ())
#define RYGEL_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_DATABASE_TYPE_CURSOR, RygelDatabaseCursor))
#define RYGEL_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_DATABASE_TYPE_CURSOR, RygelDatabaseCursorClass))
#define RYGEL_DATABASE_IS_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_DATABASE_TYPE_CURSOR))
#define RYGEL_DATABASE_IS_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_DATABASE_TYPE_CURSOR))
#define RYGEL_DATABASE_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_DATABASE_TYPE_CURSOR, RygelDatabaseCursorClass))

typedef struct _RygelDatabaseCursor RygelDatabaseCursor;
typedef struct _RygelDatabaseCursorClass RygelDatabaseCursorClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_DATABASE_DATABASE_ERROR_SQLITE_ERROR,
	RYGEL_DATABASE_DATABASE_ERROR_OPEN,
	RYGEL_DATABASE_DATABASE_ERROR_PREPARE,
	RYGEL_DATABASE_DATABASE_ERROR_BIND,
	RYGEL_DATABASE_DATABASE_ERROR_STEP
} RygelDatabaseDatabaseError;
#define RYGEL_DATABASE_DATABASE_ERROR rygel_database_database_error_quark ()
typedef enum  {
	RYGEL_DATABASE_FLAVOR_CACHE,
	RYGEL_DATABASE_FLAVOR_CONFIG,
	RYGEL_DATABASE_FLAVOR_FOREIGN
} RygelDatabaseFlavor;

typedef enum  {
	RYGEL_DATABASE_FLAGS_READ_ONLY = 1,
	RYGEL_DATABASE_FLAGS_WRITE_ONLY = 1 << 1,
	RYGEL_DATABASE_FLAGS_READ_WRITE = RYGEL_DATABASE_FLAGS_READ_ONLY | RYGEL_DATABASE_FLAGS_WRITE_ONLY,
	RYGEL_DATABASE_FLAGS_SHARED = 1 << 2
} RygelDatabaseFlags;

struct _RygelDatabaseDatabase {
	GObject parent_instance;
	RygelDatabaseDatabasePrivate * priv;
};

struct _RygelDatabaseDatabaseClass {
	GObjectClass parent_class;
};

struct _RygelDatabaseDatabasePrivate {
	gchar* _name;
	RygelDatabaseFlavor _flavor;
	RygelDatabaseFlags _flags;
	sqlite3* db;
};


static gpointer rygel_database_database_parent_class = NULL;
static GInitableIface* rygel_database_database_g_initable_parent_iface = NULL;

GQuark rygel_database_database_error_quark (void);
GType rygel_database_flavor_get_type (void) G_GNUC_CONST;
GType rygel_database_flags_get_type (void) G_GNUC_CONST;
gint rygel_database_utf8_collate_str (guint8* a, int a_length1, guint8* b, int b_length1);
void rygel_database_null (GValue* result);
GType rygel_database_database_get_type (void) G_GNUC_CONST;
#define RYGEL_DATABASE_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_DATABASE_TYPE_DATABASE, RygelDatabaseDatabasePrivate))
enum  {
	RYGEL_DATABASE_DATABASE_DUMMY_PROPERTY,
	RYGEL_DATABASE_DATABASE_NAME,
	RYGEL_DATABASE_DATABASE_FLAVOR,
	RYGEL_DATABASE_DATABASE_FLAGS
};
void rygel_database_database_utf8_contains (sqlite3_context* context, sqlite3_value** args, int args_length1);
gint rygel_database_database_utf8_collate (gint alen, void* a, gint blen, void* b);
static gchar* rygel_database_database_build_path (RygelDatabaseDatabase* self);
static const gchar* rygel_database_database_get_name (RygelDatabaseDatabase* self);
static RygelDatabaseFlavor rygel_database_database_get_flavor (RygelDatabaseDatabase* self);
void rygel_database_database_set_flavor (RygelDatabaseDatabase* self, RygelDatabaseFlavor value);
RygelDatabaseDatabase* rygel_database_database_new (const gchar* name, RygelDatabaseFlavor flavor, RygelDatabaseFlags flags, GError** error);
RygelDatabaseDatabase* rygel_database_database_construct (GType object_type, const gchar* name, RygelDatabaseFlavor flavor, RygelDatabaseFlags flags, GError** error);
static gboolean rygel_database_database_real_init (GInitable* base, GCancellable* cancellable, GError** error);
static RygelDatabaseFlags rygel_database_database_get_flags (RygelDatabaseDatabase* self);
void rygel_database_database_exec (RygelDatabaseDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
static void _rygel_database_database_utf8_contains_sqlite_user_func_callback (sqlite3_context* context, int values_length1, sqlite3_value** values);
static gint _rygel_database_database_utf8_collate_sqlite_compare_callback (gpointer self, gint alen, void* a, gint blen, void* b);
static void rygel_database_database_on_trace (RygelDatabaseDatabase* self, const gchar* message);
static void _rygel_database_database_on_trace_sqlite_trace_callback (gpointer self, const gchar* message);
GType rygel_database_cursor_get_type (void) G_GNUC_CONST;
RygelDatabaseCursor* rygel_database_database_exec_cursor (RygelDatabaseDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
RygelDatabaseCursor* rygel_database_cursor_new (sqlite3* db, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
RygelDatabaseCursor* rygel_database_cursor_construct (GType object_type, sqlite3* db, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
gboolean rygel_database_cursor_has_next (RygelDatabaseCursor* self, GError** error);
sqlite3_stmt* rygel_database_cursor_next (RygelDatabaseCursor* self, GError** error);
gint rygel_database_database_query_value (RygelDatabaseDatabase* self, const gchar* sql, GValue* args, int args_length1, GError** error);
void rygel_database_database_analyze (RygelDatabaseDatabase* self);
void rygel_database_database_begin (RygelDatabaseDatabase* self, GError** error);
void rygel_database_database_commit (RygelDatabaseDatabase* self, GError** error);
void rygel_database_database_rollback (RygelDatabaseDatabase* self);
void rygel_database_database_set_name (RygelDatabaseDatabase* self, const gchar* value);
void rygel_database_database_set_flags (RygelDatabaseDatabase* self, RygelDatabaseFlags value);
static void rygel_database_database_finalize (GObject* obj);
static void _vala_rygel_database_database_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_database_database_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_database_database_error_quark (void) {
	return g_quark_from_static_string ("rygel_database_database_error-quark");
}


GType rygel_database_flavor_get_type (void) {
	static volatile gsize rygel_database_flavor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_database_flavor_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_DATABASE_FLAVOR_CACHE, "RYGEL_DATABASE_FLAVOR_CACHE", "cache"}, {RYGEL_DATABASE_FLAVOR_CONFIG, "RYGEL_DATABASE_FLAVOR_CONFIG", "config"}, {RYGEL_DATABASE_FLAVOR_FOREIGN, "RYGEL_DATABASE_FLAVOR_FOREIGN", "foreign"}, {0, NULL, NULL}};
		GType rygel_database_flavor_type_id;
		rygel_database_flavor_type_id = g_enum_register_static ("RygelDatabaseFlavor", values);
		g_once_init_leave (&rygel_database_flavor_type_id__volatile, rygel_database_flavor_type_id);
	}
	return rygel_database_flavor_type_id__volatile;
}


GType rygel_database_flags_get_type (void) {
	static volatile gsize rygel_database_flags_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_database_flags_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_DATABASE_FLAGS_READ_ONLY, "RYGEL_DATABASE_FLAGS_READ_ONLY", "read-only"}, {RYGEL_DATABASE_FLAGS_WRITE_ONLY, "RYGEL_DATABASE_FLAGS_WRITE_ONLY", "write-only"}, {RYGEL_DATABASE_FLAGS_READ_WRITE, "RYGEL_DATABASE_FLAGS_READ_WRITE", "read-write"}, {RYGEL_DATABASE_FLAGS_SHARED, "RYGEL_DATABASE_FLAGS_SHARED", "shared"}, {0, NULL, NULL}};
		GType rygel_database_flags_type_id;
		rygel_database_flags_type_id = g_enum_register_static ("RygelDatabaseFlags", values);
		g_once_init_leave (&rygel_database_flags_type_id__volatile, rygel_database_flags_type_id);
	}
	return rygel_database_flags_type_id__volatile;
}


/**
     * Special GValue to pass to exec or exec_cursor to bind a column to
     * NULL
     */
void rygel_database_null (GValue* result) {
	GValue v = {0};
	GValue _tmp0_ = {0};
	g_value_init (&_tmp0_, G_TYPE_POINTER);
	v = _tmp0_;
	g_value_set_pointer (&v, NULL);
	*result = v;
	return;
}


/**
     * Function to implement the custom SQL function 'contains'
     */
void rygel_database_database_utf8_contains (sqlite3_context* context, sqlite3_value** args, int args_length1) {
	sqlite3_value** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean _tmp1_ = FALSE;
	sqlite3_value** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	sqlite3_value* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* pattern = NULL;
	sqlite3_value** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	sqlite3_value* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	sqlite3_value** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	sqlite3_value* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (context != NULL);
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	_vala_return_if_fail (_tmp0__length1 == 2, "args.length == 2");
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = _tmp2_[0];
	_tmp4_ = sqlite3_value_text (_tmp3_);
	if (_tmp4_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		sqlite3_value** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		sqlite3_value* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp5_ = args;
		_tmp5__length1 = args_length1;
		_tmp6_ = _tmp5_[1];
		_tmp7_ = sqlite3_value_text (_tmp6_);
		_tmp1_ = _tmp7_ == NULL;
	}
	if (_tmp1_) {
		sqlite3_context* _tmp8_ = NULL;
		_tmp8_ = context;
		sqlite3_result_int (_tmp8_, 0);
		return;
	}
	_tmp9_ = args;
	_tmp9__length1 = args_length1;
	_tmp10_ = _tmp9_[1];
	_tmp11_ = sqlite3_value_text (_tmp10_);
	_tmp12_ = g_regex_escape_string (_tmp11_, -1);
	pattern = _tmp12_;
	_tmp13_ = pattern;
	_tmp14_ = args;
	_tmp14__length1 = args_length1;
	_tmp15_ = _tmp14_[0];
	_tmp16_ = sqlite3_value_text (_tmp15_);
	_tmp17_ = g_regex_match_simple (_tmp13_, _tmp16_, G_REGEX_CASELESS, 0);
	if (_tmp17_) {
		sqlite3_context* _tmp18_ = NULL;
		_tmp18_ = context;
		sqlite3_result_int (_tmp18_, 1);
	} else {
		sqlite3_context* _tmp19_ = NULL;
		_tmp19_ = context;
		sqlite3_result_int (_tmp19_, 0);
	}
	_g_free0 (pattern);
}


/**
     * Function to implement the custom SQLite collation 'CASEFOLD'.
     *
     * Uses utf8 case-fold to compare the strings.
     */
gint rygel_database_database_utf8_collate (gint alen, void* a, gint blen, void* b) {
	gint result = 0;
	guint8* _a = NULL;
	void* _tmp0_ = NULL;
	gint _a_length1 = 0;
	gint __a_size_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _b = NULL;
	void* _tmp3_ = NULL;
	gint _b_length1 = 0;
	gint __b_size_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	_tmp0_ = a;
	_a = (guint8*) _tmp0_;
	_a_length1 = -1;
	__a_size_ = _a_length1;
	_tmp1_ = alen;
	_a_length1 = _tmp1_;
	_tmp2_ = _a_length1;
	_tmp3_ = b;
	_b = (guint8*) _tmp3_;
	_b_length1 = -1;
	__b_size_ = _b_length1;
	_tmp4_ = blen;
	_b_length1 = _tmp4_;
	_tmp5_ = _b_length1;
	_tmp6_ = rygel_database_utf8_collate_str (_a, _a_length1, _b, _b_length1);
	result = _tmp6_;
	return result;
}


static gchar* rygel_database_database_build_path (RygelDatabaseDatabase* self) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean name_is_path = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp2_ = self->priv->_name;
	if (g_strcmp0 (_tmp2_, ":memory:") == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = self->priv->_name;
		_tmp4_ = g_path_is_absolute (_tmp3_);
		_tmp1_ = _tmp4_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		RygelDatabaseFlavor _tmp5_ = 0;
		_tmp5_ = self->priv->_flavor;
		_tmp0_ = _tmp5_ == RYGEL_DATABASE_FLAVOR_FOREIGN;
	}
	name_is_path = _tmp0_;
	_tmp6_ = name_is_path;
	if (!_tmp6_) {
		const gchar* _tmp7_ = NULL;
		RygelDatabaseFlavor _tmp8_ = 0;
		gchar* dirname = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp8_ = self->priv->_flavor;
		if (_tmp8_ == RYGEL_DATABASE_FLAVOR_CACHE) {
			const gchar* _tmp9_ = NULL;
			_tmp9_ = g_get_user_cache_dir ();
			_tmp7_ = _tmp9_;
		} else {
			const gchar* _tmp10_ = NULL;
			_tmp10_ = g_get_user_config_dir ();
			_tmp7_ = _tmp10_;
		}
		_tmp11_ = g_build_filename (_tmp7_, "rygel", NULL);
		dirname = _tmp11_;
		_tmp12_ = dirname;
		g_mkdir_with_parents (_tmp12_, 0750);
		_tmp13_ = dirname;
		_tmp14_ = self->priv->_name;
		_tmp15_ = g_strdup_printf ("%s.db", _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_build_filename (_tmp13_, _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		result = _tmp18_;
		_g_free0 (dirname);
		return result;
	} else {
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		rygel_database_database_set_flavor (self, RYGEL_DATABASE_FLAVOR_FOREIGN);
		_tmp19_ = self->priv->_name;
		_tmp20_ = g_strdup (_tmp19_);
		result = _tmp20_;
		return result;
	}
}


/**
     * Connect to a SQLite database file
     *
     * @param name Name of the database which is used to create the file-name
     * @param flavor Specifies the flavor of the database
     * @param flags How to open the database
     */
RygelDatabaseDatabase* rygel_database_database_construct (GType object_type, const gchar* name, RygelDatabaseFlavor flavor, RygelDatabaseFlags flags, GError** error) {
	RygelDatabaseDatabase * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelDatabaseFlavor _tmp1_ = 0;
	RygelDatabaseFlags _tmp2_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = flavor;
	_tmp2_ = flags;
	self = (RygelDatabaseDatabase*) g_object_new (object_type, "name", _tmp0_, "flavor", _tmp1_, "flags", _tmp2_, NULL);
	g_initable_init ((GInitable*) self, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


RygelDatabaseDatabase* rygel_database_database_new (const gchar* name, RygelDatabaseFlavor flavor, RygelDatabaseFlags flags, GError** error) {
	return rygel_database_database_construct (RYGEL_DATABASE_TYPE_DATABASE, name, flavor, flags, error);
}


/**
     * Initialize database. Implemented for Initiable interface.
     *
     * @param cancellable a cancellable (unused)
     * @return true on success, false on error
     * @throws DatabaseError if anything goes wrong
     */
static void _rygel_database_database_utf8_contains_sqlite_user_func_callback (sqlite3_context* context, int values_length1, sqlite3_value** values) {
	rygel_database_database_utf8_contains (context, values, values_length1);
}


static gint _rygel_database_database_utf8_collate_sqlite_compare_callback (gpointer self, gint alen, void* a, gint blen, void* b) {
	gint result;
	result = rygel_database_database_utf8_collate (alen, a, blen, b);
	return result;
}


static void _rygel_database_database_on_trace_sqlite_trace_callback (gpointer self, const gchar* message) {
	rygel_database_database_on_trace ((RygelDatabaseDatabase*) self, message);
}


static gboolean rygel_database_database_real_init (GInitable* base, GCancellable* cancellable, GError** error) {
	RygelDatabaseDatabase * self;
	gboolean result = FALSE;
	gchar* path = NULL;
	gchar* _tmp0_ = NULL;
	RygelDatabaseFlags _tmp1_ = 0;
	sqlite3* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	const gchar* _tmp15_ = NULL;
	RygelDatabaseFlags _tmp16_ = 0;
	RygelDatabaseFlags _tmp17_ = 0;
	sqlite3* _tmp18_ = NULL;
	sqlite3* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelDatabaseDatabase*) base;
	_tmp0_ = rygel_database_database_build_path (self);
	path = _tmp0_;
	_tmp1_ = self->priv->_flags;
	if (_tmp1_ == RYGEL_DATABASE_FLAGS_READ_ONLY) {
		const gchar* _tmp2_ = NULL;
		sqlite3* _tmp3_ = NULL;
		_tmp2_ = path;
		sqlite3_open_v2 (_tmp2_, &_tmp3_, SQLITE_OPEN_READONLY, NULL);
		_sqlite3_close0 (self->priv->db);
		self->priv->db = _tmp3_;
	} else {
		const gchar* _tmp4_ = NULL;
		sqlite3* _tmp5_ = NULL;
		_tmp4_ = path;
		sqlite3_open (_tmp4_, &_tmp5_);
		_sqlite3_close0 (self->priv->db);
		self->priv->db = _tmp5_;
	}
	_tmp6_ = self->priv->db;
	_tmp7_ = sqlite3_errcode (_tmp6_);
	if (_tmp7_ != SQLITE_OK) {
		gchar* msg = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		sqlite3* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		_tmp8_ = _ ("Error while opening SQLite database %s: %s");
		_tmp9_ = g_strdup (_tmp8_);
		msg = _tmp9_;
		_tmp10_ = msg;
		_tmp11_ = path;
		_tmp12_ = self->priv->db;
		_tmp13_ = sqlite3_errmsg (_tmp12_);
		_tmp14_ = g_error_new (RYGEL_DATABASE_DATABASE_ERROR, RYGEL_DATABASE_DATABASE_ERROR_OPEN, _tmp10_, _tmp11_, _tmp13_);
		_inner_error_ = _tmp14_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		_g_free0 (path);
		return FALSE;
	}
	_tmp15_ = path;
	g_debug ("database.vala:179: Using database file %s", _tmp15_);
	_tmp16_ = self->priv->_flags;
	if (_tmp16_ != RYGEL_DATABASE_FLAGS_READ_ONLY) {
		rygel_database_database_exec (self, "PRAGMA synchronous = OFF", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (path);
			return FALSE;
		}
	}
	_tmp17_ = self->priv->_flags;
	if ((_tmp17_ & RYGEL_DATABASE_FLAGS_SHARED) == RYGEL_DATABASE_FLAGS_SHARED) {
		rygel_database_database_exec (self, "PRAGMA journal_mode = WAL", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (path);
			return FALSE;
		}
	} else {
		rygel_database_database_exec (self, "PRAGMA temp_store = MEMORY", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (path);
			return FALSE;
		}
	}
	_tmp18_ = self->priv->db;
	sqlite3_create_function (_tmp18_, "contains", 2, SQLITE_UTF8, NULL, _rygel_database_database_utf8_contains_sqlite_user_func_callback, NULL, NULL);
	_tmp19_ = self->priv->db;
	sqlite3_create_collation (_tmp19_, "CASEFOLD", SQLITE_UTF8, NULL, (int (*)(void *, int,  const void *, int,  const void *)) _rygel_database_database_utf8_collate_sqlite_compare_callback);
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		RygelMetaConfig* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		_tmp20_ = rygel_meta_config_get_default ();
		config = _tmp20_;
		_tmp22_ = config;
		_tmp23_ = rygel_configuration_get_bool ((RygelConfiguration*) _tmp22_, "Database", "Debug", &_inner_error_);
		_tmp21_ = _tmp23_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		if (_tmp21_) {
			sqlite3* _tmp24_ = NULL;
			_tmp24_ = self->priv->db;
			sqlite3_trace (_tmp24_, _rygel_database_database_on_trace_sqlite_trace_callback, self);
		}
		_g_object_unref0 (config);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_debug ("database.vala:209: Not setting up SQL tracing");
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		return FALSE;
	}
	result = TRUE;
	_g_free0 (path);
	return result;
}


static void rygel_database_database_on_trace (RygelDatabaseDatabase* self, const gchar* message) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	g_debug ("database.vala:216: SQLITE: %s", _tmp0_);
}


/**
     * SQL query function.
     *
     * Use for all queries that return a result set.
     *
     * @param sql The SQL query to run.
     * @param arguments Values to bind in the SQL query or null.
     * @throws DatabaseError if the underlying SQLite operation fails.
     */
RygelDatabaseCursor* rygel_database_database_exec_cursor (RygelDatabaseDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error) {
	RygelDatabaseCursor* result = NULL;
	RygelDatabaseCursor* _tmp0_ = NULL;
	sqlite3* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GValue* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	RygelDatabaseCursor* _tmp4_ = NULL;
	RygelDatabaseCursor* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	_tmp1_ = self->priv->db;
	_tmp2_ = sql;
	_tmp3_ = arguments;
	_tmp3__length1 = arguments_length1;
	_tmp4_ = rygel_database_cursor_new (_tmp1_, _tmp2_, _tmp3_, _tmp3__length1, &_inner_error_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp0_);
	return result;
}


/**
     * Simple SQL query execution function.
     *
     * Use for all queries that don't return anything.
     *
     * @param sql The SQL query to run.
     * @param arguments Values to bind in the SQL query or null.
     * @throws DatabaseError if the underlying SQLite operation fails.
     */
static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	sqlite3_callback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


void rygel_database_database_exec (RygelDatabaseDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error) {
	GValue* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	RygelDatabaseCursor* cursor = NULL;
	const gchar* _tmp11_ = NULL;
	GValue* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	RygelDatabaseCursor* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = arguments;
	_tmp0__length1 = arguments_length1;
	if (_tmp0_ == NULL) {
		sqlite3* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		sqlite3* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp1_ = self->priv->db;
		_tmp2_ = sql;
		_sqlite3_exec (_tmp1_, _tmp2_, NULL, NULL, NULL);
		_tmp3_ = self->priv->db;
		_tmp4_ = sqlite3_errcode (_tmp3_);
		if (_tmp4_ != SQLITE_OK) {
			gchar* msg = NULL;
			gchar* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			sqlite3* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			GError* _tmp10_ = NULL;
			_tmp5_ = g_strdup ("Failed to run query %s: %s");
			msg = _tmp5_;
			_tmp6_ = msg;
			_tmp7_ = sql;
			_tmp8_ = self->priv->db;
			_tmp9_ = sqlite3_errmsg (_tmp8_);
			_tmp10_ = g_error_new (RYGEL_DATABASE_DATABASE_ERROR, RYGEL_DATABASE_DATABASE_ERROR_SQLITE_ERROR, _tmp6_, _tmp7_, _tmp9_);
			_inner_error_ = _tmp10_;
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_free0 (msg);
		}
		return;
	}
	_tmp11_ = sql;
	_tmp12_ = arguments;
	_tmp12__length1 = arguments_length1;
	_tmp13_ = rygel_database_database_exec_cursor (self, _tmp11_, _tmp12_, _tmp12__length1, &_inner_error_);
	cursor = _tmp13_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		gboolean _tmp14_ = FALSE;
		RygelDatabaseCursor* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		RygelDatabaseCursor* _tmp17_ = NULL;
		_tmp15_ = cursor;
		_tmp16_ = rygel_database_cursor_has_next (_tmp15_, &_inner_error_);
		_tmp14_ = _tmp16_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (cursor);
				return;
			} else {
				_g_object_unref0 (cursor);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (!_tmp14_) {
			break;
		}
		_tmp17_ = cursor;
		rygel_database_cursor_next (_tmp17_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (cursor);
				return;
			} else {
				_g_object_unref0 (cursor);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_object_unref0 (cursor);
}


/**
     * Execute a SQL query that returns a single number.
     *
     * @param sql The SQL query to run.
     * @param args Values to bind in the SQL query or null.
     * @return The contents of the first row's column as an int.
     * @throws DatabaseError if the underlying SQLite operation fails.
     */
gint rygel_database_database_query_value (RygelDatabaseDatabase* self, const gchar* sql, GValue* args, int args_length1, GError** error) {
	gint result = 0;
	RygelDatabaseCursor* cursor = NULL;
	const gchar* _tmp0_ = NULL;
	GValue* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	RygelDatabaseCursor* _tmp2_ = NULL;
	sqlite3_stmt* statement = NULL;
	RygelDatabaseCursor* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	sqlite3_stmt* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = rygel_database_database_exec_cursor (self, _tmp0_, _tmp1_, _tmp1__length1, &_inner_error_);
	cursor = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp3_ = cursor;
	_tmp4_ = rygel_database_cursor_next (_tmp3_, &_inner_error_);
	statement = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (cursor);
			return 0;
		} else {
			_g_object_unref0 (cursor);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp5_ = statement;
	_tmp6_ = sqlite3_column_int (_tmp5_, 0);
	result = _tmp6_;
	_g_object_unref0 (cursor);
	return result;
}


/**
     * Analyze triggers of database
     */
void rygel_database_database_analyze (RygelDatabaseDatabase* self) {
	sqlite3* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->db;
	_sqlite3_exec (_tmp0_, "ANALYZE", NULL, NULL, NULL);
}


/**
     * Start a transaction
     */
void rygel_database_database_begin (RygelDatabaseDatabase* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_database_database_exec (self, "BEGIN", NULL, 0, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Commit a transaction
     */
void rygel_database_database_commit (RygelDatabaseDatabase* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_database_database_exec (self, "COMMIT", NULL, 0, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Rollback a transaction
     */
void rygel_database_database_rollback (RygelDatabaseDatabase* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		rygel_database_database_exec (self, "ROLLBACK", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch1_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = _ ("Failed to roll back transaction: %s");
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_critical (_tmp0_, _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static const gchar* rygel_database_database_get_name (RygelDatabaseDatabase* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void rygel_database_database_set_name (RygelDatabaseDatabase* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


static RygelDatabaseFlavor rygel_database_database_get_flavor (RygelDatabaseDatabase* self) {
	RygelDatabaseFlavor result;
	RygelDatabaseFlavor _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_flavor;
	result = _tmp0_;
	return result;
}


void rygel_database_database_set_flavor (RygelDatabaseDatabase* self, RygelDatabaseFlavor value) {
	RygelDatabaseFlavor _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_flavor = _tmp0_;
	g_object_notify ((GObject *) self, "flavor");
}


static RygelDatabaseFlags rygel_database_database_get_flags (RygelDatabaseDatabase* self) {
	RygelDatabaseFlags result;
	RygelDatabaseFlags _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_flags;
	result = _tmp0_;
	return result;
}


void rygel_database_database_set_flags (RygelDatabaseDatabase* self, RygelDatabaseFlags value) {
	RygelDatabaseFlags _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_flags = _tmp0_;
	g_object_notify ((GObject *) self, "flags");
}


static void rygel_database_database_class_init (RygelDatabaseDatabaseClass * klass) {
	rygel_database_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelDatabaseDatabasePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_database_database_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_database_database_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_database_database_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DATABASE_DATABASE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DATABASE_DATABASE_FLAVOR, g_param_spec_enum ("flavor", "flavor", "flavor", RYGEL_DATABASE_TYPE_FLAVOR, RYGEL_DATABASE_FLAVOR_CACHE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DATABASE_DATABASE_FLAGS, g_param_spec_enum ("flags", "flags", "flags", RYGEL_DATABASE_TYPE_FLAGS, RYGEL_DATABASE_FLAGS_READ_WRITE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void rygel_database_database_g_initable_interface_init (GInitableIface * iface) {
	rygel_database_database_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*)(GInitable*, GCancellable*, GError**)) rygel_database_database_real_init;
}


static void rygel_database_database_instance_init (RygelDatabaseDatabase * self) {
	self->priv = RYGEL_DATABASE_DATABASE_GET_PRIVATE (self);
	self->priv->_flavor = RYGEL_DATABASE_FLAVOR_CACHE;
	self->priv->_flags = RYGEL_DATABASE_FLAGS_READ_WRITE;
}


static void rygel_database_database_finalize (GObject* obj) {
	RygelDatabaseDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_DATABASE_TYPE_DATABASE, RygelDatabaseDatabase);
	_g_free0 (self->priv->_name);
	_sqlite3_close0 (self->priv->db);
	G_OBJECT_CLASS (rygel_database_database_parent_class)->finalize (obj);
}


/**
 * This class is a thin wrapper around SQLite's database object.
 *
 * It adds statement preparation based on GValue and a cancellable exec
 * function.
 */
GType rygel_database_database_get_type (void) {
	static volatile gsize rygel_database_database_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_database_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDatabaseDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_database_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDatabaseDatabase), 0, (GInstanceInitFunc) rygel_database_database_instance_init, NULL };
		static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) rygel_database_database_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_database_database_type_id;
		rygel_database_database_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelDatabaseDatabase", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_database_database_type_id, G_TYPE_INITABLE, &g_initable_info);
		g_once_init_leave (&rygel_database_database_type_id__volatile, rygel_database_database_type_id);
	}
	return rygel_database_database_type_id__volatile;
}


static void _vala_rygel_database_database_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelDatabaseDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_DATABASE_TYPE_DATABASE, RygelDatabaseDatabase);
	switch (property_id) {
		case RYGEL_DATABASE_DATABASE_NAME:
		g_value_set_string (value, rygel_database_database_get_name (self));
		break;
		case RYGEL_DATABASE_DATABASE_FLAVOR:
		g_value_set_enum (value, rygel_database_database_get_flavor (self));
		break;
		case RYGEL_DATABASE_DATABASE_FLAGS:
		g_value_set_enum (value, rygel_database_database_get_flags (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_database_database_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelDatabaseDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_DATABASE_TYPE_DATABASE, RygelDatabaseDatabase);
	switch (property_id) {
		case RYGEL_DATABASE_DATABASE_NAME:
		rygel_database_database_set_name (self, g_value_get_string (value));
		break;
		case RYGEL_DATABASE_DATABASE_FLAVOR:
		rygel_database_database_set_flavor (self, g_value_get_enum (value));
		break;
		case RYGEL_DATABASE_DATABASE_FLAGS:
		rygel_database_database_set_flags (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



