/* gitg-label-renderer.c generated by valac 0.30.0.38-a55d, the Vala compiler
 * generated from gitg-label-renderer.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>


#define GITG_TYPE_LABEL_RENDERER (gitg_label_renderer_get_type ())
#define GITG_LABEL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_LABEL_RENDERER, GitgLabelRenderer))
#define GITG_LABEL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_LABEL_RENDERER, GitgLabelRendererClass))
#define GITG_IS_LABEL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_LABEL_RENDERER))
#define GITG_IS_LABEL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_LABEL_RENDERER))
#define GITG_LABEL_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_LABEL_RENDERER, GitgLabelRendererClass))

typedef struct _GitgLabelRenderer GitgLabelRenderer;
typedef struct _GitgLabelRendererClass GitgLabelRendererClass;
typedef struct _GitgLabelRendererPrivate GitgLabelRendererPrivate;

#define GITG_TYPE_REF (gitg_ref_get_type ())
#define GITG_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF, GitgRef))
#define GITG_IS_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF))
#define GITG_REF_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_REF, GitgRefIface))

typedef struct _GitgRef GitgRef;
typedef struct _GitgRefIface GitgRefIface;

#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;

#define GITG_TYPE_PARSED_REF_NAME (gitg_parsed_ref_name_get_type ())
#define GITG_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName))
#define GITG_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))
#define GITG_IS_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PARSED_REF_NAME))
#define GITG_IS_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PARSED_REF_NAME))
#define GITG_PARSED_REF_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))

typedef struct _GitgParsedRefName GitgParsedRefName;
typedef struct _GitgParsedRefNameClass GitgParsedRefNameClass;

#define GITG_TYPE_REF_STATE (gitg_ref_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_REF_TYPE (gitg_ref_type_get_type ())
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _GitgParamSpecLabelRenderer GitgParamSpecLabelRenderer;

struct _GitgLabelRenderer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgLabelRendererPrivate * priv;
};

struct _GitgLabelRendererClass {
	GTypeClass parent_class;
	void (*finalize) (GitgLabelRenderer *self);
};

typedef enum  {
	GITG_REF_STATE_NONE,
	GITG_REF_STATE_SELECTED,
	GITG_REF_STATE_PRELIGHT
} GitgRefState;

struct _GitgRefIface {
	GTypeInterface parent_iface;
	GitgRepository* (*get_owner) (GitgRef* self);
	GitgParsedRefName* (*get_d_parsed_name) (GitgRef* self);
	void (*set_d_parsed_name) (GitgRef* self, GitgParsedRefName* value);
	GList* (*get_d_pushes) (GitgRef* self);
	void (*set_d_pushes) (GitgRef* self, GList* value);
	GitgRefState (*get_state) (GitgRef* self);
	void (*set_state) (GitgRef* self, GitgRefState value);
	gboolean (*get_working) (GitgRef* self);
	void (*set_working) (GitgRef* self, gboolean value);
};

typedef enum  {
	GITG_REF_TYPE_NONE,
	GITG_REF_TYPE_BRANCH,
	GITG_REF_TYPE_REMOTE,
	GITG_REF_TYPE_TAG,
	GITG_REF_TYPE_STASH
} GitgRefType;

struct _GitgParamSpecLabelRenderer {
	GParamSpec parent_instance;
};


static gpointer gitg_label_renderer_parent_class = NULL;

gpointer gitg_label_renderer_ref (gpointer instance);
void gitg_label_renderer_unref (gpointer instance);
GParamSpec* gitg_param_spec_label_renderer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gitg_value_set_label_renderer (GValue* value, gpointer v_object);
void gitg_value_take_label_renderer (GValue* value, gpointer v_object);
gpointer gitg_value_get_label_renderer (const GValue* value);
GType gitg_label_renderer_get_type (void) G_GNUC_CONST;
enum  {
	GITG_LABEL_RENDERER_DUMMY_PROPERTY
};
#define GITG_LABEL_RENDERER_margin 2
#define GITG_LABEL_RENDERER_padding 6
GType gitg_repository_get_type (void) G_GNUC_CONST;
GType gitg_parsed_ref_name_get_type (void) G_GNUC_CONST;
GType gitg_ref_state_get_type (void) G_GNUC_CONST;
GType gitg_ref_get_type (void) G_GNUC_CONST;
static gchar* gitg_label_renderer_label_text (GitgRef* r);
GitgParsedRefName* gitg_ref_get_parsed_name (GitgRef* self);
gchar* gitg_parsed_ref_name_get_shortname (GitgParsedRefName* self);
static gint gitg_label_renderer_get_label_width (PangoLayout* layout, GitgRef* r);
gint gitg_label_renderer_width (GtkWidget* widget, PangoFontDescription* font, GSList* labels);
GType gitg_ref_type_get_type (void) G_GNUC_CONST;
static gchar* gitg_label_renderer_class_from_ref (GitgRefType type);
static gint gitg_label_renderer_render_label (GtkWidget* widget, cairo_t* cr, PangoLayout* layout, GitgRef* r, gdouble x, gdouble y, gint height, gboolean use_state);
GitgRefType gitg_parsed_ref_name_get_rtype (GitgParsedRefName* self);
void gitg_label_renderer_draw (GtkWidget* widget, PangoFontDescription* font, cairo_t* context, GSList* labels, GdkRectangle* area);
GitgRef* gitg_label_renderer_get_ref_at_pos (GtkWidget* widget, PangoFontDescription* font, GSList* labels, gint x, gint* hot_x);
static guchar gitg_label_renderer_convert_color_channel (guchar color, guchar alpha);
static void gitg_label_renderer_convert_bgra_to_rgba (guchar* src, int src_length1, guchar* dst, int dst_length1, gint width, gint height);
GdkPixbuf* gitg_label_renderer_render_ref (GtkWidget* widget, PangoFontDescription* font, GitgRef* r, gint height, gint minwidth);
static guchar* _vala_array_dup15 (guchar* self, int length);
static guint8* _vala_array_dup16 (guint8* self, int length);
GitgLabelRenderer* gitg_label_renderer_new (void);
GitgLabelRenderer* gitg_label_renderer_construct (GType object_type);
static void gitg_label_renderer_finalize (GitgLabelRenderer* obj);


static gchar* gitg_label_renderer_label_text (GitgRef* r) {
	gchar* result = NULL;
	gchar* escaped = NULL;
	GitgRef* _tmp0_ = NULL;
	GitgParsedRefName* _tmp1_ = NULL;
	GitgParsedRefName* _tmp2_ = NULL;
	GitgParsedRefName* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
#line 27 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 29 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp0_ = r;
#line 29 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp1_ = gitg_ref_get_parsed_name (_tmp0_);
#line 29 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp2_ = _tmp1_;
#line 29 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp3_ = _tmp2_;
#line 29 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp4_ = gitg_parsed_ref_name_get_shortname (_tmp3_);
#line 29 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp5_ = _tmp4_;
#line 29 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp6_ = _tmp5_;
#line 29 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp7_ = g_markup_escape_text (_tmp6_, (gssize) -1);
#line 29 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp8_ = _tmp7_;
#line 29 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_free0 (_tmp6_);
#line 29 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_object_unref0 (_tmp3_);
#line 29 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	escaped = _tmp8_;
#line 30 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp9_ = g_strdup_printf ("<span size='smaller'>%s</span>", escaped);
#line 30 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	result = _tmp9_;
#line 30 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_free0 (escaped);
#line 30 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return result;
#line 216 "gitg-label-renderer.c"
}


static gint gitg_label_renderer_get_label_width (PangoLayout* layout, GitgRef* r) {
	gint result = 0;
	gchar* smaller = NULL;
	GitgRef* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint w = 0;
	PangoLayout* _tmp2_ = NULL;
	PangoLayout* _tmp3_ = NULL;
	gint _tmp4_ = 0;
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (layout != NULL, 0);
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (r != NULL, 0);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp0_ = r;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp1_ = gitg_label_renderer_label_text (_tmp0_);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	smaller = _tmp1_;
#line 40 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp2_ = layout;
#line 40 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	pango_layout_set_markup (_tmp2_, smaller, -1);
#line 41 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp3_ = layout;
#line 41 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	pango_layout_get_pixel_size (_tmp3_, &_tmp4_, NULL);
#line 41 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	w = _tmp4_;
#line 43 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	result = w + (GITG_LABEL_RENDERER_padding * 2);
#line 43 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_free0 (smaller);
#line 43 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return result;
#line 255 "gitg-label-renderer.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 57 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return self ? g_object_ref (self) : NULL;
#line 262 "gitg-label-renderer.c"
}


gint gitg_label_renderer_width (GtkWidget* widget, PangoFontDescription* font, GSList* labels) {
	gint result = 0;
	GSList* _tmp0_ = NULL;
	gint ret = 0;
	PangoContext* ctx = NULL;
	GtkWidget* _tmp1_ = NULL;
	PangoContext* _tmp2_ = NULL;
	PangoContext* _tmp3_ = NULL;
	PangoLayout* layout = NULL;
	PangoContext* _tmp4_ = NULL;
	PangoLayout* _tmp5_ = NULL;
	PangoLayout* _tmp6_ = NULL;
	PangoFontDescription* _tmp7_ = NULL;
	GSList* _tmp8_ = NULL;
	gint _tmp14_ = 0;
#line 46 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (widget != NULL, 0);
#line 50 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp0_ = labels;
#line 50 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (_tmp0_ == NULL) {
#line 52 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		result = 0;
#line 52 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		return result;
#line 291 "gitg-label-renderer.c"
	}
#line 55 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	ret = 0;
#line 57 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp1_ = widget;
#line 57 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp2_ = gtk_widget_get_pango_context (_tmp1_);
#line 57 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 57 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	ctx = _tmp3_;
#line 58 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp4_ = ctx;
#line 58 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp5_ = pango_layout_new (_tmp4_);
#line 58 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	layout = _tmp5_;
#line 60 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp6_ = layout;
#line 60 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp7_ = font;
#line 60 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	pango_layout_set_font_description (_tmp6_, _tmp7_);
#line 62 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp8_ = labels;
#line 317 "gitg-label-renderer.c"
	{
		GSList* r_collection = NULL;
		GSList* r_it = NULL;
#line 62 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		r_collection = _tmp8_;
#line 62 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
#line 325 "gitg-label-renderer.c"
			GitgRef* _tmp9_ = NULL;
			GitgRef* r = NULL;
#line 62 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			_tmp9_ = _g_object_ref0 ((GitgRef*) r_it->data);
#line 62 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			r = _tmp9_;
#line 332 "gitg-label-renderer.c"
			{
				gint _tmp10_ = 0;
				PangoLayout* _tmp11_ = NULL;
				GitgRef* _tmp12_ = NULL;
				gint _tmp13_ = 0;
#line 64 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp10_ = ret;
#line 64 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp11_ = layout;
#line 64 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp12_ = r;
#line 64 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp13_ = gitg_label_renderer_get_label_width (_tmp11_, _tmp12_);
#line 64 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				ret = _tmp10_ + (_tmp13_ + GITG_LABEL_RENDERER_margin);
#line 62 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_g_object_unref0 (r);
#line 350 "gitg-label-renderer.c"
			}
		}
	}
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp14_ = ret;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	result = _tmp14_ + GITG_LABEL_RENDERER_margin;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_object_unref0 (layout);
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_object_unref0 (ctx);
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return result;
#line 364 "gitg-label-renderer.c"
}


static gchar* gitg_label_renderer_class_from_ref (GitgRefType type) {
	gchar* result = NULL;
	gchar* style_class = NULL;
	GitgRefType _tmp0_ = 0;
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp0_ = type;
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	switch (_tmp0_) {
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		case GITG_REF_TYPE_BRANCH:
#line 378 "gitg-label-renderer.c"
		{
			gchar* _tmp1_ = NULL;
#line 77 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			_tmp1_ = g_strdup ("branch");
#line 77 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			_g_free0 (style_class);
#line 77 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			style_class = _tmp1_;
#line 78 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			break;
#line 389 "gitg-label-renderer.c"
		}
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		case GITG_REF_TYPE_REMOTE:
#line 393 "gitg-label-renderer.c"
		{
			gchar* _tmp2_ = NULL;
#line 80 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			_tmp2_ = g_strdup ("remote");
#line 80 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			_g_free0 (style_class);
#line 80 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			style_class = _tmp2_;
#line 81 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			break;
#line 404 "gitg-label-renderer.c"
		}
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		case GITG_REF_TYPE_TAG:
#line 408 "gitg-label-renderer.c"
		{
			gchar* _tmp3_ = NULL;
#line 83 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			_tmp3_ = g_strdup ("tag");
#line 83 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			_g_free0 (style_class);
#line 83 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			style_class = _tmp3_;
#line 84 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			break;
#line 419 "gitg-label-renderer.c"
		}
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		case GITG_REF_TYPE_STASH:
#line 423 "gitg-label-renderer.c"
		{
			gchar* _tmp4_ = NULL;
#line 86 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			_tmp4_ = g_strdup ("stash");
#line 86 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			_g_free0 (style_class);
#line 86 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			style_class = _tmp4_;
#line 87 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			break;
#line 434 "gitg-label-renderer.c"
		}
		default:
		{
#line 89 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			_g_free0 (style_class);
#line 89 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			style_class = NULL;
#line 90 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			break;
#line 444 "gitg-label-renderer.c"
		}
	}
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	result = style_class;
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return result;
#line 451 "gitg-label-renderer.c"
}


static gint gitg_label_renderer_render_label (GtkWidget* widget, cairo_t* cr, PangoLayout* layout, GitgRef* r, gdouble x, gdouble y, gint height, gboolean use_state) {
	gint result = 0;
	GtkStyleContext* context = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	gchar* smaller = NULL;
	GitgRef* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	PangoLayout* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint w = 0;
	gint h = 0;
	PangoLayout* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GtkStyleContext* _tmp10_ = NULL;
	gchar* style_class = NULL;
	GitgRef* _tmp11_ = NULL;
	GitgParsedRefName* _tmp12_ = NULL;
	GitgParsedRefName* _tmp13_ = NULL;
	GitgParsedRefName* _tmp14_ = NULL;
	GitgRefType _tmp15_ = 0;
	GitgRefType _tmp16_ = 0;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gboolean rtl = FALSE;
	GtkWidget* _tmp22_ = NULL;
	GtkStyleContext* _tmp23_ = NULL;
	GtkStateFlags _tmp24_ = 0;
	gboolean _tmp25_ = FALSE;
	GtkStyleContext* _tmp28_ = NULL;
	cairo_t* _tmp29_ = NULL;
	gdouble _tmp30_ = 0.0;
	gdouble _tmp31_ = 0.0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	GtkStyleContext* _tmp34_ = NULL;
	cairo_t* _tmp35_ = NULL;
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	GtkStyleContext* _tmp40_ = NULL;
	cairo_t* _tmp41_ = NULL;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_ = 0.0;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	PangoLayout* _tmp46_ = NULL;
	GtkStyleContext* _tmp47_ = NULL;
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (widget != NULL, 0);
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (cr != NULL, 0);
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (layout != NULL, 0);
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (r != NULL, 0);
#line 105 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp0_ = widget;
#line 105 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp1_ = gtk_widget_get_style_context (_tmp0_);
#line 105 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 105 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	context = _tmp2_;
#line 106 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp3_ = r;
#line 106 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp4_ = gitg_label_renderer_label_text (_tmp3_);
#line 106 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	smaller = _tmp4_;
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp5_ = layout;
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp6_ = smaller;
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	pango_layout_set_markup (_tmp5_, _tmp6_, -1);
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp7_ = layout;
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	pango_layout_get_pixel_size (_tmp7_, &_tmp8_, &_tmp9_);
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	w = _tmp8_;
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	h = _tmp9_;
#line 115 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp10_ = context;
#line 115 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	gtk_style_context_save (_tmp10_);
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp11_ = r;
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp12_ = gitg_ref_get_parsed_name (_tmp11_);
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp13_ = _tmp12_;
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp14_ = _tmp13_;
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp15_ = gitg_parsed_ref_name_get_rtype (_tmp14_);
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp16_ = _tmp15_;
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp17_ = gitg_label_renderer_class_from_ref (_tmp16_);
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp18_ = _tmp17_;
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_object_unref0 (_tmp14_);
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	style_class = _tmp18_;
#line 119 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp19_ = style_class;
#line 119 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (_tmp19_ != NULL) {
#line 571 "gitg-label-renderer.c"
		GtkStyleContext* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
#line 121 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		_tmp20_ = context;
#line 121 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		_tmp21_ = style_class;
#line 121 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		gtk_style_context_add_class (_tmp20_, _tmp21_);
#line 580 "gitg-label-renderer.c"
	}
#line 124 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp22_ = widget;
#line 124 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp23_ = gtk_widget_get_style_context (_tmp22_);
#line 124 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp24_ = gtk_style_context_get_state (_tmp23_);
#line 124 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	rtl = (_tmp24_ & GTK_STATE_FLAG_DIR_RTL) != 0;
#line 126 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp25_ = rtl;
#line 126 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (_tmp25_) {
#line 594 "gitg-label-renderer.c"
		gdouble _tmp26_ = 0.0;
		gint _tmp27_ = 0;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		_tmp26_ = x;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		_tmp27_ = w;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		x = _tmp26_ - (_tmp27_ + (GITG_LABEL_RENDERER_padding * 2));
#line 603 "gitg-label-renderer.c"
	}
#line 131 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp28_ = context;
#line 131 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp29_ = cr;
#line 131 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp30_ = x;
#line 131 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp31_ = y;
#line 131 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp32_ = w;
#line 131 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp33_ = height;
#line 131 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	gtk_render_background (_tmp28_, _tmp29_, _tmp30_, _tmp31_ + GITG_LABEL_RENDERER_margin, (gdouble) (_tmp32_ + (GITG_LABEL_RENDERER_padding * 2)), (gdouble) (_tmp33_ - (GITG_LABEL_RENDERER_margin * 2)));
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp34_ = context;
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp35_ = cr;
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp36_ = x;
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp37_ = y;
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp38_ = w;
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp39_ = height;
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	gtk_render_frame (_tmp34_, _tmp35_, _tmp36_, _tmp37_ + GITG_LABEL_RENDERER_margin, (gdouble) (_tmp38_ + (GITG_LABEL_RENDERER_padding * 2)), (gdouble) (_tmp39_ - (GITG_LABEL_RENDERER_margin * 2)));
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp40_ = context;
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp41_ = cr;
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp42_ = x;
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp43_ = y;
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp44_ = height;
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp45_ = h;
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp46_ = layout;
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	gtk_render_layout (_tmp40_, _tmp41_, _tmp42_ + GITG_LABEL_RENDERER_padding, (_tmp43_ + ((_tmp44_ - _tmp45_) / 2.0)) - 1, _tmp46_);
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp47_ = context;
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	gtk_style_context_restore (_tmp47_);
#line 149 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	result = w;
#line 149 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_free0 (style_class);
#line 149 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_free0 (smaller);
#line 149 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_object_unref0 (context);
#line 149 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return result;
#line 663 "gitg-label-renderer.c"
}


void gitg_label_renderer_draw (GtkWidget* widget, PangoFontDescription* font, cairo_t* context, GSList* labels, GdkRectangle* area) {
	gdouble pos = 0.0;
	gboolean rtl = FALSE;
	GtkWidget* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStateFlags _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	cairo_t* _tmp10_ = NULL;
	cairo_t* _tmp11_ = NULL;
	PangoContext* ctx = NULL;
	GtkWidget* _tmp12_ = NULL;
	PangoContext* _tmp13_ = NULL;
	PangoContext* _tmp14_ = NULL;
	PangoLayout* layout = NULL;
	PangoContext* _tmp15_ = NULL;
	PangoLayout* _tmp16_ = NULL;
	PangoLayout* _tmp17_ = NULL;
	PangoFontDescription* _tmp18_ = NULL;
	GSList* _tmp19_ = NULL;
	cairo_t* _tmp37_ = NULL;
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_if_fail (widget != NULL);
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_if_fail (font != NULL);
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_if_fail (context != NULL);
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_if_fail (area != NULL);
#line 160 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp0_ = widget;
#line 160 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp1_ = gtk_widget_get_style_context (_tmp0_);
#line 160 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp2_ = gtk_style_context_get_state (_tmp1_);
#line 160 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	rtl = (_tmp2_ & GTK_STATE_FLAG_DIR_RTL) != 0;
#line 162 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp3_ = rtl;
#line 162 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (!_tmp3_) {
#line 707 "gitg-label-renderer.c"
		GdkRectangle _tmp4_ = {0};
		gint _tmp5_ = 0;
#line 164 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		_tmp4_ = *area;
#line 164 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		_tmp5_ = _tmp4_.x;
#line 164 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		pos = (_tmp5_ + GITG_LABEL_RENDERER_margin) + 0.5;
#line 716 "gitg-label-renderer.c"
	} else {
		GdkRectangle _tmp6_ = {0};
		gint _tmp7_ = 0;
		GdkRectangle _tmp8_ = {0};
		gint _tmp9_ = 0;
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		_tmp6_ = *area;
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		_tmp7_ = _tmp6_.x;
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		_tmp8_ = *area;
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		_tmp9_ = _tmp8_.width;
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		pos = ((_tmp7_ + _tmp9_) - GITG_LABEL_RENDERER_margin) - 0.5;
#line 732 "gitg-label-renderer.c"
	}
#line 171 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp10_ = context;
#line 171 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	cairo_save (_tmp10_);
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp11_ = context;
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	cairo_set_line_width (_tmp11_, 1.0);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp12_ = widget;
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp13_ = gtk_widget_get_pango_context (_tmp12_);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	ctx = _tmp14_;
#line 175 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp15_ = ctx;
#line 175 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp16_ = pango_layout_new (_tmp15_);
#line 175 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	layout = _tmp16_;
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp17_ = layout;
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp18_ = font;
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	pango_layout_set_font_description (_tmp17_, _tmp18_);
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp19_ = labels;
#line 764 "gitg-label-renderer.c"
	{
		GSList* r_collection = NULL;
		GSList* r_it = NULL;
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		r_collection = _tmp19_;
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
#line 772 "gitg-label-renderer.c"
			GitgRef* _tmp20_ = NULL;
			GitgRef* r = NULL;
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			_tmp20_ = _g_object_ref0 ((GitgRef*) r_it->data);
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			r = _tmp20_;
#line 779 "gitg-label-renderer.c"
			{
				gint w = 0;
				GtkWidget* _tmp21_ = NULL;
				cairo_t* _tmp22_ = NULL;
				PangoLayout* _tmp23_ = NULL;
				GitgRef* _tmp24_ = NULL;
				gdouble _tmp25_ = 0.0;
				GdkRectangle _tmp26_ = {0};
				gint _tmp27_ = 0;
				GdkRectangle _tmp28_ = {0};
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				gint o = 0;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gboolean _tmp33_ = FALSE;
				gdouble _tmp36_ = 0.0;
#line 181 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp21_ = widget;
#line 181 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp22_ = context;
#line 181 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp23_ = layout;
#line 181 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp24_ = r;
#line 181 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp25_ = pos;
#line 181 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp26_ = *area;
#line 181 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp27_ = _tmp26_.y;
#line 181 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp28_ = *area;
#line 181 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp29_ = _tmp28_.height;
#line 181 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp30_ = gitg_label_renderer_render_label (_tmp21_, _tmp22_, _tmp23_, _tmp24_, (gdouble) ((gint) _tmp25_), (gdouble) _tmp27_, _tmp29_, TRUE);
#line 181 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				w = _tmp30_;
#line 190 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp31_ = w;
#line 190 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				o = (_tmp31_ + (GITG_LABEL_RENDERER_padding * 2)) + GITG_LABEL_RENDERER_margin;
#line 191 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp33_ = rtl;
#line 191 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				if (_tmp33_) {
#line 827 "gitg-label-renderer.c"
					gint _tmp34_ = 0;
#line 191 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_tmp34_ = o;
#line 191 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_tmp32_ = -_tmp34_;
#line 833 "gitg-label-renderer.c"
				} else {
					gint _tmp35_ = 0;
#line 191 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_tmp35_ = o;
#line 191 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_tmp32_ = _tmp35_;
#line 840 "gitg-label-renderer.c"
				}
#line 191 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp36_ = pos;
#line 191 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				pos = _tmp36_ + _tmp32_;
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_g_object_unref0 (r);
#line 848 "gitg-label-renderer.c"
			}
		}
	}
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp37_ = context;
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	cairo_restore (_tmp37_);
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_object_unref0 (layout);
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_object_unref0 (ctx);
#line 860 "gitg-label-renderer.c"
}


GitgRef* gitg_label_renderer_get_ref_at_pos (GtkWidget* widget, PangoFontDescription* font, GSList* labels, gint x, gint* hot_x) {
	gint _vala_hot_x = 0;
	GitgRef* result = NULL;
	GSList* _tmp0_ = NULL;
	PangoContext* ctx = NULL;
	GtkWidget* _tmp1_ = NULL;
	PangoContext* _tmp2_ = NULL;
	PangoContext* _tmp3_ = NULL;
	PangoLayout* layout = NULL;
	PangoContext* _tmp4_ = NULL;
	PangoLayout* _tmp5_ = NULL;
	PangoLayout* _tmp6_ = NULL;
	PangoFontDescription* _tmp7_ = NULL;
	gint start = 0;
	GitgRef* ret = NULL;
	GSList* _tmp8_ = NULL;
#line 197 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (widget != NULL, NULL);
#line 197 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (font != NULL, NULL);
#line 203 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_vala_hot_x = 0;
#line 205 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp0_ = labels;
#line 205 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (_tmp0_ == NULL) {
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		result = NULL;
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		if (hot_x) {
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			*hot_x = _vala_hot_x;
#line 896 "gitg-label-renderer.c"
		}
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		return result;
#line 900 "gitg-label-renderer.c"
	}
#line 210 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp1_ = widget;
#line 210 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp2_ = gtk_widget_get_pango_context (_tmp1_);
#line 210 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 210 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	ctx = _tmp3_;
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp4_ = ctx;
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp5_ = pango_layout_new (_tmp4_);
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	layout = _tmp5_;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp6_ = layout;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp7_ = font;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	pango_layout_set_font_description (_tmp6_, _tmp7_);
#line 215 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	start = GITG_LABEL_RENDERER_margin;
#line 216 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	ret = NULL;
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp8_ = labels;
#line 928 "gitg-label-renderer.c"
	{
		GSList* r_collection = NULL;
		GSList* r_it = NULL;
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		r_collection = _tmp8_;
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
#line 936 "gitg-label-renderer.c"
			GitgRef* _tmp9_ = NULL;
			GitgRef* r = NULL;
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			_tmp9_ = _g_object_ref0 ((GitgRef*) r_it->data);
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			r = _tmp9_;
#line 943 "gitg-label-renderer.c"
			{
				gint width = 0;
				PangoLayout* _tmp10_ = NULL;
				GitgRef* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gboolean _tmp13_ = FALSE;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
#line 220 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp10_ = layout;
#line 220 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp11_ = r;
#line 220 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp12_ = gitg_label_renderer_get_label_width (_tmp10_, _tmp11_);
#line 220 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				width = _tmp12_;
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp14_ = x;
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp15_ = start;
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				if (_tmp14_ >= _tmp15_) {
#line 968 "gitg-label-renderer.c"
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_tmp16_ = x;
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_tmp17_ = start;
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_tmp18_ = width;
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_tmp13_ = _tmp16_ <= (_tmp17_ + _tmp18_);
#line 980 "gitg-label-renderer.c"
				} else {
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_tmp13_ = FALSE;
#line 984 "gitg-label-renderer.c"
				}
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				if (_tmp13_) {
#line 988 "gitg-label-renderer.c"
					GitgRef* _tmp19_ = NULL;
					GitgRef* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					gint _tmp22_ = 0;
#line 224 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_tmp19_ = r;
#line 224 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_tmp20_ = _g_object_ref0 (_tmp19_);
#line 224 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_g_object_unref0 (ret);
#line 224 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					ret = _tmp20_;
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_tmp21_ = x;
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_tmp22_ = start;
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_vala_hot_x = _tmp21_ - _tmp22_;
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_g_object_unref0 (r);
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					break;
#line 1011 "gitg-label-renderer.c"
				}
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp23_ = start;
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp24_ = width;
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				start = _tmp23_ + (_tmp24_ + GITG_LABEL_RENDERER_margin);
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_g_object_unref0 (r);
#line 1021 "gitg-label-renderer.c"
			}
		}
	}
#line 233 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	result = ret;
#line 233 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_object_unref0 (layout);
#line 233 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_object_unref0 (ctx);
#line 233 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (hot_x) {
#line 233 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		*hot_x = _vala_hot_x;
#line 1035 "gitg-label-renderer.c"
	}
#line 233 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return result;
#line 1039 "gitg-label-renderer.c"
}


static guchar gitg_label_renderer_convert_color_channel (guchar color, guchar alpha) {
	guchar result = '\0';
	gdouble _tmp0_ = 0.0;
	guchar _tmp1_ = '\0';
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp1_ = alpha;
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (((gint) _tmp1_) != 0) {
#line 1051 "gitg-label-renderer.c"
		guchar _tmp2_ = '\0';
		guchar _tmp3_ = '\0';
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		_tmp2_ = color;
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		_tmp3_ = alpha;
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		_tmp0_ = _tmp2_ / (_tmp3_ / 255.0);
#line 1060 "gitg-label-renderer.c"
	} else {
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		_tmp0_ = (gdouble) 0;
#line 1064 "gitg-label-renderer.c"
	}
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	result = (guchar) _tmp0_;
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return result;
#line 1070 "gitg-label-renderer.c"
}


static void gitg_label_renderer_convert_bgra_to_rgba (guchar* src, int src_length1, guchar* dst, int dst_length1, gint width, gint height) {
	gint i = 0;
#line 247 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	i = 0;
#line 1078 "gitg-label-renderer.c"
	{
		gint y = 0;
#line 249 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		y = 0;
#line 1083 "gitg-label-renderer.c"
		{
			gboolean _tmp0_ = FALSE;
#line 249 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			_tmp0_ = TRUE;
#line 249 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			while (TRUE) {
#line 1090 "gitg-label-renderer.c"
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
#line 249 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				if (!_tmp0_) {
#line 1095 "gitg-label-renderer.c"
					gint _tmp1_ = 0;
#line 249 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					_tmp1_ = y;
#line 249 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					y = _tmp1_ + 1;
#line 1101 "gitg-label-renderer.c"
				}
#line 249 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp0_ = FALSE;
#line 249 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp2_ = y;
#line 249 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				_tmp3_ = height;
#line 249 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
				if (!(_tmp2_ < _tmp3_)) {
#line 249 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					break;
#line 1113 "gitg-label-renderer.c"
				}
				{
					gint x = 0;
#line 251 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
					x = 0;
#line 1119 "gitg-label-renderer.c"
					{
						gboolean _tmp4_ = FALSE;
#line 251 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
						_tmp4_ = TRUE;
#line 251 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
						while (TRUE) {
#line 1126 "gitg-label-renderer.c"
							gint _tmp6_ = 0;
							gint _tmp7_ = 0;
							guchar* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp9_ = 0;
							guchar* _tmp10_ = NULL;
							gint _tmp10__length1 = 0;
							gint _tmp11_ = 0;
							guchar _tmp12_ = '\0';
							guchar* _tmp13_ = NULL;
							gint _tmp13__length1 = 0;
							gint _tmp14_ = 0;
							guchar _tmp15_ = '\0';
							guchar _tmp16_ = '\0';
							guchar _tmp17_ = '\0';
							guchar* _tmp18_ = NULL;
							gint _tmp18__length1 = 0;
							gint _tmp19_ = 0;
							guchar* _tmp20_ = NULL;
							gint _tmp20__length1 = 0;
							gint _tmp21_ = 0;
							guchar _tmp22_ = '\0';
							guchar* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp24_ = 0;
							guchar _tmp25_ = '\0';
							guchar _tmp26_ = '\0';
							guchar _tmp27_ = '\0';
							guchar* _tmp28_ = NULL;
							gint _tmp28__length1 = 0;
							gint _tmp29_ = 0;
							guchar* _tmp30_ = NULL;
							gint _tmp30__length1 = 0;
							gint _tmp31_ = 0;
							guchar _tmp32_ = '\0';
							guchar* _tmp33_ = NULL;
							gint _tmp33__length1 = 0;
							gint _tmp34_ = 0;
							guchar _tmp35_ = '\0';
							guchar _tmp36_ = '\0';
							guchar _tmp37_ = '\0';
							guchar* _tmp38_ = NULL;
							gint _tmp38__length1 = 0;
							gint _tmp39_ = 0;
							guchar* _tmp40_ = NULL;
							gint _tmp40__length1 = 0;
							gint _tmp41_ = 0;
							guchar _tmp42_ = '\0';
							guchar _tmp43_ = '\0';
							gint _tmp44_ = 0;
#line 251 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							if (!_tmp4_) {
#line 1179 "gitg-label-renderer.c"
								gint _tmp5_ = 0;
#line 251 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
								_tmp5_ = x;
#line 251 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
								x = _tmp5_ + 1;
#line 1185 "gitg-label-renderer.c"
							}
#line 251 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp4_ = FALSE;
#line 251 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp6_ = x;
#line 251 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp7_ = width;
#line 251 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							if (!(_tmp6_ < _tmp7_)) {
#line 251 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
								break;
#line 1197 "gitg-label-renderer.c"
							}
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp8_ = dst;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp8__length1 = dst_length1;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp9_ = i;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp10_ = src;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp10__length1 = src_length1;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp11_ = i;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp12_ = _tmp10_[_tmp11_ + 2];
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp13_ = src;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp13__length1 = src_length1;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp14_ = i;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp15_ = _tmp13_[_tmp14_ + 3];
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp16_ = gitg_label_renderer_convert_color_channel (_tmp12_, _tmp15_);
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp8_[_tmp9_] = _tmp16_;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp17_ = _tmp8_[_tmp9_];
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp18_ = dst;
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp18__length1 = dst_length1;
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp19_ = i;
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp20_ = src;
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp20__length1 = src_length1;
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp21_ = i;
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp22_ = _tmp20_[_tmp21_ + 1];
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp23_ = src;
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp23__length1 = src_length1;
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp24_ = i;
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp25_ = _tmp23_[_tmp24_ + 3];
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp26_ = gitg_label_renderer_convert_color_channel (_tmp22_, _tmp25_);
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp18_[_tmp19_ + 1] = _tmp26_;
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp27_ = _tmp18_[_tmp19_ + 1];
#line 255 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp28_ = dst;
#line 255 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp28__length1 = dst_length1;
#line 255 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp29_ = i;
#line 255 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp30_ = src;
#line 255 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp30__length1 = src_length1;
#line 255 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp31_ = i;
#line 255 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp32_ = _tmp30_[_tmp31_];
#line 255 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp33_ = src;
#line 255 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp33__length1 = src_length1;
#line 255 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp34_ = i;
#line 255 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp35_ = _tmp33_[_tmp34_ + 3];
#line 255 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp36_ = gitg_label_renderer_convert_color_channel (_tmp32_, _tmp35_);
#line 255 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp28_[_tmp29_ + 2] = _tmp36_;
#line 255 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp37_ = _tmp28_[_tmp29_ + 2];
#line 256 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp38_ = dst;
#line 256 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp38__length1 = dst_length1;
#line 256 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp39_ = i;
#line 256 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp40_ = src;
#line 256 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp40__length1 = src_length1;
#line 256 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp41_ = i;
#line 256 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp42_ = _tmp40_[_tmp41_ + 3];
#line 256 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp38_[_tmp39_ + 3] = _tmp42_;
#line 256 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp43_ = _tmp38_[_tmp39_ + 3];
#line 258 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							_tmp44_ = i;
#line 258 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
							i = _tmp44_ + 4;
#line 1305 "gitg-label-renderer.c"
						}
					}
				}
			}
		}
	}
}


static guchar* _vala_array_dup15 (guchar* self, int length) {
#line 284 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return g_memdup (self, length * sizeof (guchar));
#line 1318 "gitg-label-renderer.c"
}


static guint8* _vala_array_dup16 (guint8* self, int length) {
#line 292 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1325 "gitg-label-renderer.c"
}


GdkPixbuf* gitg_label_renderer_render_ref (GtkWidget* widget, PangoFontDescription* font, GitgRef* r, gint height, gint minwidth) {
	GdkPixbuf* result = NULL;
	PangoContext* ctx = NULL;
	GtkWidget* _tmp0_ = NULL;
	PangoContext* _tmp1_ = NULL;
	PangoContext* _tmp2_ = NULL;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp3_ = NULL;
	PangoFontDescription* _tmp4_ = NULL;
	gint width = 0;
	GitgRef* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	cairo_surface_t* surface = NULL;
	gint _tmp9_ = 0;
	cairo_surface_t* _tmp10_ = NULL;
	cairo_t* context = NULL;
	cairo_t* _tmp11_ = NULL;
	GtkWidget* _tmp12_ = NULL;
	GitgRef* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	guchar* data = NULL;
	guchar* _tmp15_ = NULL;
	guchar* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	GdkPixbuf* ret = NULL;
	gint _tmp17_ = 0;
	GdkPixbuf* _tmp18_ = NULL;
	guint8* pixdata = NULL;
	guint8* _tmp19_ = NULL;
	guint8* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint pixdata_length1 = 0;
	gint _pixdata_size_ = 0;
	gint _tmp21_ = 0;
#line 263 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (widget != NULL, NULL);
#line 263 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (font != NULL, NULL);
#line 263 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 269 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp0_ = widget;
#line 269 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp1_ = gtk_widget_get_pango_context (_tmp0_);
#line 269 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 269 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	ctx = _tmp2_;
#line 270 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp3_ = pango_layout_new (ctx);
#line 270 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	layout = _tmp3_;
#line 272 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp4_ = font;
#line 272 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	pango_layout_set_font_description (layout, _tmp4_);
#line 274 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp5_ = r;
#line 274 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp6_ = gitg_label_renderer_get_label_width (layout, _tmp5_);
#line 274 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp7_ = minwidth;
#line 274 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp8_ = MAX (_tmp6_, _tmp7_);
#line 274 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	width = _tmp8_;
#line 276 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp9_ = height;
#line 276 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp10_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width + 2, _tmp9_ + 2);
#line 276 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	surface = _tmp10_;
#line 280 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp11_ = cairo_create (surface);
#line 280 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	context = _tmp11_;
#line 281 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	cairo_set_line_width (context, (gdouble) 1);
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp12_ = widget;
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp13_ = r;
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp14_ = height;
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	gitg_label_renderer_render_label (_tmp12_, context, layout, _tmp13_, (gdouble) 1, (gdouble) 1, _tmp14_, FALSE);
#line 284 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp15_ = cairo_image_surface_get_data (surface);
#line 284 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup15 (_tmp15_, -1) : ((gpointer) _tmp15_);
#line 284 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp16__length1 = -1;
#line 284 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	data = _tmp16_;
#line 284 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	data_length1 = _tmp16__length1;
#line 284 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_data_size_ = data_length1;
#line 286 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp17_ = height;
#line 286 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp18_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, width + 2, _tmp17_ + 2);
#line 286 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	ret = _tmp18_;
#line 292 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp19_ = gdk_pixbuf_get_pixels (ret);
#line 292 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp20_ = (_tmp19_ != NULL) ? _vala_array_dup16 (_tmp19_, -1) : ((gpointer) _tmp19_);
#line 292 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp20__length1 = -1;
#line 292 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	pixdata = _tmp20_;
#line 292 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	pixdata_length1 = _tmp20__length1;
#line 292 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_pixdata_size_ = pixdata_length1;
#line 293 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_tmp21_ = height;
#line 293 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	gitg_label_renderer_convert_bgra_to_rgba (data, data_length1, pixdata, pixdata_length1, width + 2, _tmp21_ + 2);
#line 295 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	result = ret;
#line 295 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	pixdata = (g_free (pixdata), NULL);
#line 295 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	data = (g_free (data), NULL);
#line 295 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_cairo_destroy0 (context);
#line 295 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_cairo_surface_destroy0 (surface);
#line 295 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_object_unref0 (layout);
#line 295 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	_g_object_unref0 (ctx);
#line 295 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return result;
#line 1469 "gitg-label-renderer.c"
}


GitgLabelRenderer* gitg_label_renderer_construct (GType object_type) {
	GitgLabelRenderer* self = NULL;
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	self = (GitgLabelRenderer*) g_type_create_instance (object_type);
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return self;
#line 1479 "gitg-label-renderer.c"
}


GitgLabelRenderer* gitg_label_renderer_new (void) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return gitg_label_renderer_construct (GITG_TYPE_LABEL_RENDERER);
#line 1486 "gitg-label-renderer.c"
}


static void gitg_value_label_renderer_init (GValue* value) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	value->data[0].v_pointer = NULL;
#line 1493 "gitg-label-renderer.c"
}


static void gitg_value_label_renderer_free_value (GValue* value) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (value->data[0].v_pointer) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		gitg_label_renderer_unref (value->data[0].v_pointer);
#line 1502 "gitg-label-renderer.c"
	}
}


static void gitg_value_label_renderer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		dest_value->data[0].v_pointer = gitg_label_renderer_ref (src_value->data[0].v_pointer);
#line 1512 "gitg-label-renderer.c"
	} else {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1516 "gitg-label-renderer.c"
	}
}


static gpointer gitg_value_label_renderer_peek_pointer (const GValue* value) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return value->data[0].v_pointer;
#line 1524 "gitg-label-renderer.c"
}


static gchar* gitg_value_label_renderer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (collect_values[0].v_pointer) {
#line 1531 "gitg-label-renderer.c"
		GitgLabelRenderer* object;
		object = collect_values[0].v_pointer;
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1538 "gitg-label-renderer.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1542 "gitg-label-renderer.c"
		}
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		value->data[0].v_pointer = gitg_label_renderer_ref (object);
#line 1546 "gitg-label-renderer.c"
	} else {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		value->data[0].v_pointer = NULL;
#line 1550 "gitg-label-renderer.c"
	}
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return NULL;
#line 1554 "gitg-label-renderer.c"
}


static gchar* gitg_value_label_renderer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GitgLabelRenderer** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (!object_p) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1565 "gitg-label-renderer.c"
	}
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (!value->data[0].v_pointer) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		*object_p = NULL;
#line 1571 "gitg-label-renderer.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		*object_p = value->data[0].v_pointer;
#line 1575 "gitg-label-renderer.c"
	} else {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		*object_p = gitg_label_renderer_ref (value->data[0].v_pointer);
#line 1579 "gitg-label-renderer.c"
	}
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return NULL;
#line 1583 "gitg-label-renderer.c"
}


GParamSpec* gitg_param_spec_label_renderer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GitgParamSpecLabelRenderer* spec;
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GITG_TYPE_LABEL_RENDERER), NULL);
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return G_PARAM_SPEC (spec);
#line 1597 "gitg-label-renderer.c"
}


gpointer gitg_value_get_label_renderer (const GValue* value) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_LABEL_RENDERER), NULL);
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return value->data[0].v_pointer;
#line 1606 "gitg-label-renderer.c"
}


void gitg_value_set_label_renderer (GValue* value, gpointer v_object) {
	GitgLabelRenderer* old;
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_LABEL_RENDERER));
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (v_object) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_LABEL_RENDERER));
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		value->data[0].v_pointer = v_object;
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		gitg_label_renderer_ref (value->data[0].v_pointer);
#line 1626 "gitg-label-renderer.c"
	} else {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		value->data[0].v_pointer = NULL;
#line 1630 "gitg-label-renderer.c"
	}
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (old) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		gitg_label_renderer_unref (old);
#line 1636 "gitg-label-renderer.c"
	}
}


void gitg_value_take_label_renderer (GValue* value, gpointer v_object) {
	GitgLabelRenderer* old;
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_LABEL_RENDERER));
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (v_object) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_LABEL_RENDERER));
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		value->data[0].v_pointer = v_object;
#line 1655 "gitg-label-renderer.c"
	} else {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		value->data[0].v_pointer = NULL;
#line 1659 "gitg-label-renderer.c"
	}
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (old) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		gitg_label_renderer_unref (old);
#line 1665 "gitg-label-renderer.c"
	}
}


static void gitg_label_renderer_class_init (GitgLabelRendererClass * klass) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	gitg_label_renderer_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	((GitgLabelRendererClass *) klass)->finalize = gitg_label_renderer_finalize;
#line 1675 "gitg-label-renderer.c"
}


static void gitg_label_renderer_instance_init (GitgLabelRenderer * self) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	self->ref_count = 1;
#line 1682 "gitg-label-renderer.c"
}


static void gitg_label_renderer_finalize (GitgLabelRenderer* obj) {
	GitgLabelRenderer * self;
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_LABEL_RENDERER, GitgLabelRenderer);
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_signal_handlers_destroy (self);
#line 1692 "gitg-label-renderer.c"
}


GType gitg_label_renderer_get_type (void) {
	static volatile gsize gitg_label_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_label_renderer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gitg_value_label_renderer_init, gitg_value_label_renderer_free_value, gitg_value_label_renderer_copy_value, gitg_value_label_renderer_peek_pointer, "p", gitg_value_label_renderer_collect_value, "p", gitg_value_label_renderer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GitgLabelRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_label_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgLabelRenderer), 0, (GInstanceInitFunc) gitg_label_renderer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gitg_label_renderer_type_id;
		gitg_label_renderer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgLabelRenderer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gitg_label_renderer_type_id__volatile, gitg_label_renderer_type_id);
	}
	return gitg_label_renderer_type_id__volatile;
}


gpointer gitg_label_renderer_ref (gpointer instance) {
	GitgLabelRenderer* self;
	self = instance;
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	return instance;
#line 1717 "gitg-label-renderer.c"
}


void gitg_label_renderer_unref (gpointer instance) {
	GitgLabelRenderer* self;
	self = instance;
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		GITG_LABEL_RENDERER_GET_CLASS (self)->finalize (self);
#line 22 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-label-renderer.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1730 "gitg-label-renderer.c"
	}
}



