/* rygel-description-file.c generated by valac 0.34.4, the Vala compiler
 * generated from rygel-description-file.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <mail@jensge.org>
 *         Parthiban Balasubramanian <P.Balasubramanian-contractor@cablelabs.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libxml/tree.h>
#include <gee.h>
#include <libxml/xpath.h>
#include <libxml/parser.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define RYGEL_TYPE_DESCRIPTION_FILE (rygel_description_file_get_type ())
#define RYGEL_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile))
#define RYGEL_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))
#define RYGEL_IS_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_IS_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_DESCRIPTION_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))

typedef struct _RygelDescriptionFile RygelDescriptionFile;
typedef struct _RygelDescriptionFileClass RygelDescriptionFileClass;
typedef struct _RygelDescriptionFilePrivate RygelDescriptionFilePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelDescriptionFile {
	GObject parent_instance;
	RygelDescriptionFilePrivate * priv;
};

struct _RygelDescriptionFileClass {
	GObjectClass parent_class;
};

struct _RygelDescriptionFilePrivate {
	gchar** device_elements;
	gint device_elements_length1;
	gint _device_elements_size_;
	GUPnPXMLDoc* doc;
};

typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4,
	RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS = 1 << 5,
	RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT = 1 << 6
} RygelPluginCapabilities;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};


static gpointer rygel_description_file_parent_class = NULL;

GType rygel_description_file_get_type (void) G_GNUC_CONST;
#define RYGEL_DESCRIPTION_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFilePrivate))
enum  {
	RYGEL_DESCRIPTION_FILE_DUMMY_PROPERTY
};
#define RYGEL_DESCRIPTION_FILE_SERVICE_TYPE_TEMPLATE "//*[.='%s']"
#define RYGEL_DESCRIPTION_FILE_X_DLNADOC_NODE "X_DLNADOC"
#define RYGEL_DESCRIPTION_FILE_X_DLNADOC_NON_DEVCAP_XPATH "//*[local-name()=" " 'X_DLNADOC'" " and not(contains(.,\"DIAGE\"))" " and not(contains(.,\"LPE\"))]"
#define RYGEL_DESCRIPTION_FILE_X_DLNADOC_DIAGE_XPATH "//*[local-name()='X_DLNADOC'" " and contains(.,\"DIAGE\")]"
#define RYGEL_DESCRIPTION_FILE_DIAGE_DEV_CAP "+DIAGE+"
#define RYGEL_DESCRIPTION_FILE_X_DLNADOC_LPE_XPATH "//*[local-name()='X_DLNADOC'" " and contains(.,\"LPE\")]"
#define RYGEL_DESCRIPTION_FILE_LPE_DEV_CAP "+LPE+"
RygelDescriptionFile* rygel_description_file_new (const gchar* template_file, GError** error);
RygelDescriptionFile* rygel_description_file_construct (GType object_type, const gchar* template_file, GError** error);
RygelDescriptionFile* rygel_description_file_new_from_xml_document (GUPnPXMLDoc* doc);
RygelDescriptionFile* rygel_description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc);
void rygel_description_file_set_device_type (RygelDescriptionFile* self, const gchar* device_type);
static xmlNode* rygel_description_file_set_device_element (RygelDescriptionFile* self, const gchar* element, const gchar* new_value, const gchar* ns);
void rygel_description_file_set_model_description (RygelDescriptionFile* self, const gchar* model_description);
void rygel_description_file_set_model_name (RygelDescriptionFile* self, const gchar* model_name);
void rygel_description_file_set_model_number (RygelDescriptionFile* self, const gchar* model_number);
void rygel_description_file_set_friendly_name (RygelDescriptionFile* self, const gchar* friendly_name);
gchar* rygel_description_file_get_friendly_name (RygelDescriptionFile* self);
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
void rygel_description_file_set_udn (RygelDescriptionFile* self, const gchar* udn);
gchar* rygel_description_file_get_udn (RygelDescriptionFile* self);
void rygel_description_file_set_serial_number (RygelDescriptionFile* self, const gchar* serial);
GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
void rygel_description_file_set_dlna_caps (RygelDescriptionFile* self, RygelPluginCapabilities capabilities);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gboolean rygel_configuration_get_allow_upload (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_allow_deletion (RygelConfiguration* self, GError** error);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value);
void rygel_description_file_add_dlna_doc_element (RygelDescriptionFile* self, const gchar* dlnadoc_xpath, const gchar* dlnadoc_non_xpath, const gchar* dev_cap);
void rygel_description_file_remove_dlna_doc_element (RygelDescriptionFile* self, const gchar* dlnadoc_xpath);
static void _vala_array_add12 (gchar*** array, int* length, int* size, gchar* value);
static void rygel_description_file_remove_device_element (RygelDescriptionFile* self, const gchar* element);
void rygel_description_file_clear_service_list (RygelDescriptionFile* self);
static gboolean rygel_description_file_apply_xpath (RygelDescriptionFile* self, const gchar* xpath, xmlXPathObject** xpo);
static xmlNode* rygel_description_file_get_device_element (RygelDescriptionFile* self);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
void rygel_description_file_add_service (RygelDescriptionFile* self, const gchar* device_name, RygelResourceInfo* resource_info);
void rygel_description_file_clear_icon_list (RygelDescriptionFile* self);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
void rygel_description_file_add_icon (RygelDescriptionFile* self, const gchar* device_name, RygelIconInfo* icon_info, const gchar* url);
void rygel_description_file_modify_service_type (RygelDescriptionFile* self, const gchar* old_type, const gchar* new_type);
void rygel_description_file_save (RygelDescriptionFile* self, const gchar* path, GError** error);
static gint rygel_description_file_index_of_device_element (RygelDescriptionFile* self, const gchar* element);
static void rygel_description_file_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
     * Constructor to load a description file from disk
     *
     * @param template_file the path to the description file.
     * @throws GUPnP.XMLError.PARSE if there was an error reading or parsing
     * the file.
     */
RygelDescriptionFile* rygel_description_file_construct (GType object_type, const gchar* template_file, GError** error) {
	RygelDescriptionFile * self = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GUPnPXMLDoc* _tmp2_ = NULL;
	GUPnPXMLDoc* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (template_file != NULL, NULL);
	self = (RygelDescriptionFile*) g_object_new (object_type, NULL);
	_tmp1_ = template_file;
	_tmp2_ = gupnp_xml_doc_new_from_path (_tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->doc);
	self->priv->doc = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return self;
}


RygelDescriptionFile* rygel_description_file_new (const gchar* template_file, GError** error) {
	return rygel_description_file_construct (RYGEL_TYPE_DESCRIPTION_FILE, template_file, error);
}


/**
     * Constructor which wraps an existing GUPnP.XMLDoc as a description file.
     *
     * @param doc is the GUPnP.XMLDoc to wrap.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelDescriptionFile* rygel_description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc) {
	RygelDescriptionFile * self = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	GUPnPXMLDoc* _tmp1_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	self = (RygelDescriptionFile*) g_object_new (object_type, NULL);
	_tmp0_ = doc;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->doc);
	self->priv->doc = _tmp1_;
	return self;
}


RygelDescriptionFile* rygel_description_file_new_from_xml_document (GUPnPXMLDoc* doc) {
	return rygel_description_file_construct_from_xml_document (RYGEL_TYPE_DESCRIPTION_FILE, doc);
}


/**
     * Change the type of a service.
     *
     * Usually used to modify the device version, e.g. default device type is
     * "MediaServer:2" and device_type = "MediaServer:1".
     *
     * @param device_type is the current content of serviceType.
     */
void rygel_description_file_set_device_type (RygelDescriptionFile* self, const gchar* device_type) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_type != NULL);
	_tmp0_ = device_type;
	rygel_description_file_set_device_element (self, "deviceType", _tmp0_, NULL);
}


/**
     * Modify the model description.
     *
     * A longer user friendly description of the device.
     *
     * @param model_description is the new model description.
     */
void rygel_description_file_set_model_description (RygelDescriptionFile* self, const gchar* model_description) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model_description != NULL);
	_tmp0_ = model_description;
	rygel_description_file_set_device_element (self, "modelDescription", _tmp0_, NULL);
}


/**
     * Modify the model name.
     *
     * Usually the name of the software implementing this device.
     *
     * @param model_name is the new model name.
     */
void rygel_description_file_set_model_name (RygelDescriptionFile* self, const gchar* model_name) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model_name != NULL);
	_tmp0_ = model_name;
	rygel_description_file_set_device_element (self, "modelName", _tmp0_, NULL);
}


/**
     * Modify the model number.
     *
     * Usually the version of the software implementing this device.
     *
     * @param model_number is the new model number.
     */
void rygel_description_file_set_model_number (RygelDescriptionFile* self, const gchar* model_number) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model_number != NULL);
	_tmp0_ = model_number;
	rygel_description_file_set_device_element (self, "modelNumber", _tmp0_, NULL);
}


/**
     * Set the friendly name of the device.
     *
     * The friendly name is the one usually presented to the user in control
     * points or DMPs
     *
     * @param friendly_name is the new friendly name of the device.
     */
void rygel_description_file_set_friendly_name (RygelDescriptionFile* self, const gchar* friendly_name) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (friendly_name != NULL);
	_tmp0_ = friendly_name;
	rygel_description_file_set_device_element (self, "friendlyName", _tmp0_, NULL);
}


/**
     * Get the current friendly name of the device.
     *
     * @return The currenly set friendly name.
     */
gchar* rygel_description_file_get_friendly_name (RygelDescriptionFile* self) {
	gchar* result = NULL;
	xmlNode* element = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "friendlyName", NULL);
	element = _tmp2_;
	_vala_assert (element != NULL, "element != null");
	_tmp3_ = (gchar*) xmlNodeGetContent (element);
	result = _tmp3_;
	return result;
}


/**
     * Set the Unique Device Name of the device.
     *
     * Unique Device Name is the UUID of this particular device instance.
     *
     * @param udn is the Unique Device Name of the device.
     */
void rygel_description_file_set_udn (RygelDescriptionFile* self, const gchar* udn) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (udn != NULL);
	_tmp0_ = udn;
	rygel_description_file_set_device_element (self, "UDN", _tmp0_, NULL);
}


/**
     * Get the current UDN of the device.
     *
     * @return The currenly set UDN.
     */
gchar* rygel_description_file_get_udn (RygelDescriptionFile* self) {
	gchar* result = NULL;
	xmlNode* element = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "UDN", NULL);
	element = _tmp2_;
	_tmp3_ = element;
	if (_tmp3_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp4_ = element;
	_tmp5_ = (gchar*) xmlNodeGetContent (_tmp4_);
	result = _tmp5_;
	return result;
}


/**
     * Set the Serial number of the device.
     *
     * @param serial is the Unique Device Name of the device.
     */
void rygel_description_file_set_serial_number (RygelDescriptionFile* self, const gchar* serial) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (serial != NULL);
	_tmp0_ = serial;
	rygel_description_file_set_device_element (self, "serialNumber", _tmp0_, NULL);
}


/**
     * Set the DLNA caps of this root device and while taking the
     * capabilities of the plugin into account.
     *
     * @param capabilities RygelPluginCapabilities flags
     */
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add12 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_ = NULL;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


void rygel_description_file_set_dlna_caps (RygelDescriptionFile* self, RygelPluginCapabilities capabilities) {
	gchar** flags = NULL;
	gchar** _tmp0_ = NULL;
	gint flags_length1 = 0;
	gint _flags_size_ = 0;
	RygelPluginCapabilities _tmp1_ = 0;
	RygelPluginCapabilities _tmp24_ = 0;
	gboolean _tmp29_ = FALSE;
	RygelPluginCapabilities _tmp30_ = 0;
	RygelPluginCapabilities _tmp34_ = 0;
	RygelPluginCapabilities _tmp37_ = 0;
	gchar** _tmp40_ = NULL;
	gint _tmp40__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	flags = _tmp0_;
	flags_length1 = 0;
	_flags_size_ = flags_length1;
	_tmp1_ = capabilities;
	if ((RYGEL_PLUGIN_CAPABILITIES_UPLOAD & _tmp1_) != 0) {
		gboolean allow_upload = FALSE;
		gboolean allow_delete = FALSE;
		gboolean _tmp9_ = FALSE;
		allow_upload = TRUE;
		allow_delete = FALSE;
		{
			RygelMetaConfig* config = NULL;
			RygelMetaConfig* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			RygelMetaConfig* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			RygelMetaConfig* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			_tmp2_ = rygel_meta_config_get_default ();
			config = _tmp2_;
			_tmp4_ = config;
			_tmp5_ = rygel_configuration_get_allow_upload ((RygelConfiguration*) _tmp4_, &_inner_error_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (config);
				goto __catch5_g_error;
			}
			allow_upload = _tmp3_;
			_tmp7_ = config;
			_tmp8_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp7_, &_inner_error_);
			_tmp6_ = _tmp8_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (config);
				goto __catch5_g_error;
			}
			allow_delete = _tmp6_;
			_g_object_unref0 (config);
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* _error_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (_error_);
		}
		__finally5:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = allow_upload;
		if (_tmp9_) {
			gboolean can_upload = FALSE;
			RygelPluginCapabilities _tmp10_ = 0;
			RygelPluginCapabilities _tmp13_ = 0;
			RygelPluginCapabilities _tmp16_ = 0;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			can_upload = FALSE;
			_tmp10_ = capabilities;
			if ((_tmp10_ & RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD) {
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gchar* _tmp12_ = NULL;
				_tmp11_ = flags;
				_tmp11__length1 = flags_length1;
				_tmp12_ = g_strdup ("image-upload");
				_vala_array_add4 (&flags, &flags_length1, &_flags_size_, _tmp12_);
				can_upload = TRUE;
			}
			_tmp13_ = capabilities;
			if ((_tmp13_ & RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) {
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gchar* _tmp15_ = NULL;
				_tmp14_ = flags;
				_tmp14__length1 = flags_length1;
				_tmp15_ = g_strdup ("av-upload");
				_vala_array_add5 (&flags, &flags_length1, &_flags_size_, _tmp15_);
				can_upload = TRUE;
			}
			_tmp16_ = capabilities;
			if ((_tmp16_ & RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD) {
				gchar** _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				gchar* _tmp18_ = NULL;
				_tmp17_ = flags;
				_tmp17__length1 = flags_length1;
				_tmp18_ = g_strdup ("audio-upload");
				_vala_array_add6 (&flags, &flags_length1, &_flags_size_, _tmp18_);
				can_upload = TRUE;
			}
			_tmp20_ = allow_delete;
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				_tmp21_ = can_upload;
				_tmp19_ = _tmp21_;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gchar* _tmp23_ = NULL;
				_tmp22_ = flags;
				_tmp22__length1 = flags_length1;
				_tmp23_ = g_strdup ("create-item-with-OCM-destroy-item");
				_vala_array_add7 (&flags, &flags_length1, &_flags_size_, _tmp23_);
			}
		}
	}
	_tmp24_ = capabilities;
	if ((_tmp24_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) {
		gchar** _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gchar* _tmp26_ = NULL;
		gchar** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gchar* _tmp28_ = NULL;
		_tmp25_ = flags;
		_tmp25__length1 = flags_length1;
		_tmp26_ = g_strdup ("content-synchronization");
		_vala_array_add8 (&flags, &flags_length1, &_flags_size_, _tmp26_);
		_tmp27_ = flags;
		_tmp27__length1 = flags_length1;
		_tmp28_ = g_strdup ("create-child-container");
		_vala_array_add9 (&flags, &flags_length1, &_flags_size_, _tmp28_);
	}
	_tmp30_ = capabilities;
	if ((_tmp30_ & RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS) == RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS) {
		RygelPluginCapabilities _tmp31_ = 0;
		_tmp31_ = capabilities;
		_tmp29_ = !((_tmp31_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES);
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		gchar* _tmp33_ = NULL;
		_tmp32_ = flags;
		_tmp32__length1 = flags_length1;
		_tmp33_ = g_strdup ("create-child-container");
		_vala_array_add10 (&flags, &flags_length1, &_flags_size_, _tmp33_);
	}
	_tmp34_ = capabilities;
	if ((_tmp34_ & RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS) == RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS) {
		gchar** _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		gchar* _tmp36_ = NULL;
		_tmp35_ = flags;
		_tmp35__length1 = flags_length1;
		_tmp36_ = g_strdup (RYGEL_DESCRIPTION_FILE_DIAGE_DEV_CAP);
		_vala_array_add11 (&flags, &flags_length1, &_flags_size_, _tmp36_);
		rygel_description_file_add_dlna_doc_element (self, RYGEL_DESCRIPTION_FILE_X_DLNADOC_DIAGE_XPATH, RYGEL_DESCRIPTION_FILE_X_DLNADOC_NON_DEVCAP_XPATH, RYGEL_DESCRIPTION_FILE_DIAGE_DEV_CAP);
	} else {
		rygel_description_file_remove_dlna_doc_element (self, RYGEL_DESCRIPTION_FILE_X_DLNADOC_DIAGE_XPATH);
	}
	_tmp37_ = capabilities;
	if ((_tmp37_ & RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT) == RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT) {
		gchar** _tmp38_ = NULL;
		gint _tmp38__length1 = 0;
		gchar* _tmp39_ = NULL;
		_tmp38_ = flags;
		_tmp38__length1 = flags_length1;
		_tmp39_ = g_strdup (RYGEL_DESCRIPTION_FILE_LPE_DEV_CAP);
		_vala_array_add12 (&flags, &flags_length1, &_flags_size_, _tmp39_);
		rygel_description_file_add_dlna_doc_element (self, RYGEL_DESCRIPTION_FILE_X_DLNADOC_LPE_XPATH, RYGEL_DESCRIPTION_FILE_X_DLNADOC_NON_DEVCAP_XPATH, RYGEL_DESCRIPTION_FILE_LPE_DEV_CAP);
	} else {
		rygel_description_file_remove_dlna_doc_element (self, RYGEL_DESCRIPTION_FILE_X_DLNADOC_LPE_XPATH);
	}
	_tmp40_ = flags;
	_tmp40__length1 = flags_length1;
	if (_tmp40__length1 > 0) {
		gchar* content = NULL;
		gchar** _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		gchar* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		_tmp41_ = flags;
		_tmp41__length1 = flags_length1;
		_tmp42_ = _vala_g_strjoinv (",", _tmp41_, _tmp41__length1);
		content = _tmp42_;
		_tmp43_ = content;
		rygel_description_file_set_device_element (self, "X_DLNACAP", _tmp43_, "dlna");
		_g_free0 (content);
	} else {
		rygel_description_file_remove_device_element (self, "X_DLNACAP");
	}
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
}


void rygel_description_file_clear_service_list (RygelDescriptionFile* self) {
	g_return_if_fail (self != NULL);
	rygel_description_file_remove_device_element (self, "serviceList");
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


void rygel_description_file_add_dlna_doc_element (RygelDescriptionFile* self, const gchar* dlnadoc_xpath, const gchar* dlnadoc_non_xpath, const gchar* dev_cap) {
	xmlXPathObject* dlna_doc_object = NULL;
	xmlXPathObject* tmp = NULL;
	const gchar* _tmp0_ = NULL;
	xmlXPathObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp4_ = NULL;
	xmlXPathObject* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	xmlXPathObject* _tmp50_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlnadoc_xpath != NULL);
	g_return_if_fail (dlnadoc_non_xpath != NULL);
	g_return_if_fail (dev_cap != NULL);
	dlna_doc_object = NULL;
	_tmp0_ = dlnadoc_xpath;
	_tmp2_ = rygel_description_file_apply_xpath (self, _tmp0_, &_tmp1_);
	tmp = _tmp1_;
	if (_tmp2_) {
		xmlXPathObject* _tmp3_ = NULL;
		_tmp3_ = tmp;
		xmlXPathFreeObject (_tmp3_);
		return;
	}
	_tmp4_ = dlnadoc_non_xpath;
	_tmp6_ = rygel_description_file_apply_xpath (self, _tmp4_, &_tmp5_);
	dlna_doc_object = _tmp5_;
	if (!_tmp6_) {
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				xmlXPathObject* _tmp10_ = NULL;
				xmlNodeSet* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp13_ = NULL;
				xmlNodeSet* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				xmlNode* _tmp16_ = NULL;
				gchar* node_content = NULL;
				xmlNode* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gint doc_index = 0;
				const gchar* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gchar* devcap_content = NULL;
				xmlNode* device = NULL;
				xmlNode* _tmp21_ = NULL;
				xmlNode* devcap_element = NULL;
				xmlNode* _tmp22_ = NULL;
				xmlNode* _tmp23_ = NULL;
				xmlNs* _tmp24_ = NULL;
				xmlNode* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				const gchar* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				xmlNode* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				xmlNode* _tmp48_ = NULL;
				xmlNode* _tmp49_ = NULL;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = dlna_doc_object;
				_tmp11_ = _tmp10_->nodesetval;
				_tmp12_ = xmlXPathNodeSetGetLength (_tmp11_);
				if (!(_tmp9_ < _tmp12_)) {
					break;
				}
				_tmp13_ = dlna_doc_object;
				_tmp14_ = _tmp13_->nodesetval;
				_tmp15_ = i;
				_tmp16_ = xmlXPathNodeSetItem (_tmp14_, _tmp15_);
				node = _tmp16_;
				_tmp17_ = node;
				_tmp18_ = (gchar*) xmlNodeGetContent (_tmp17_);
				node_content = _tmp18_;
				_tmp19_ = node_content;
				_tmp20_ = string_last_index_of (_tmp19_, "/", 0);
				doc_index = _tmp20_;
				_tmp21_ = rygel_description_file_get_device_element (self);
				device = _tmp21_;
				_tmp22_ = device;
				_tmp23_ = node;
				_tmp24_ = _tmp23_->ns;
				_tmp25_ = xmlNewChild (_tmp22_, _tmp24_, (xmlChar*) RYGEL_DESCRIPTION_FILE_X_DLNADOC_NODE, (xmlChar*) NULL);
				devcap_element = _tmp25_;
				_tmp26_ = doc_index;
				if (_tmp26_ != -1) {
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					const gchar* _tmp29_ = NULL;
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
					gchar* _tmp32_ = NULL;
					_tmp27_ = node_content;
					_tmp28_ = doc_index;
					_tmp29_ = node_content;
					_tmp30_ = strlen (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = string_slice (_tmp27_, (glong) (_tmp28_ + 1), (glong) _tmp31_);
					_g_free0 (devcap_content);
					devcap_content = _tmp32_;
				} else {
					const gchar* _tmp33_ = NULL;
					gchar* _tmp34_ = NULL;
					_tmp33_ = node_content;
					_tmp34_ = g_strdup (_tmp33_);
					_g_free0 (devcap_content);
					devcap_content = _tmp34_;
				}
				_tmp35_ = dev_cap;
				_tmp36_ = g_strconcat (_tmp35_, "/", NULL);
				_tmp37_ = _tmp36_;
				_tmp38_ = devcap_content;
				_tmp39_ = g_strconcat (_tmp37_, _tmp38_, NULL);
				_tmp40_ = _tmp39_;
				g_debug ("rygel-description-file.vala:348: %s", _tmp40_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp37_);
				_tmp41_ = devcap_element;
				_tmp42_ = dev_cap;
				_tmp43_ = g_strconcat (_tmp42_, "/", NULL);
				_tmp44_ = _tmp43_;
				_tmp45_ = devcap_content;
				_tmp46_ = g_strconcat (_tmp44_, _tmp45_, NULL);
				_tmp47_ = _tmp46_;
				xmlNodeSetContent (_tmp41_, (xmlChar*) _tmp47_);
				_g_free0 (_tmp47_);
				_g_free0 (_tmp44_);
				_tmp48_ = node;
				_tmp49_ = devcap_element;
				xmlAddNextSibling (_tmp48_, _tmp49_);
				_g_free0 (devcap_content);
				_g_free0 (node_content);
			}
		}
	}
	_tmp50_ = dlna_doc_object;
	xmlXPathFreeObject (_tmp50_);
}


void rygel_description_file_remove_dlna_doc_element (RygelDescriptionFile* self, const gchar* dlnadoc_xpath) {
	xmlXPathObject* devcap_object = NULL;
	const gchar* _tmp0_ = NULL;
	xmlXPathObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	xmlXPathObject* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlnadoc_xpath != NULL);
	devcap_object = NULL;
	_tmp0_ = dlnadoc_xpath;
	_tmp2_ = rygel_description_file_apply_xpath (self, _tmp0_, &_tmp1_);
	devcap_object = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				xmlXPathObject* _tmp6_ = NULL;
				xmlNodeSet* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp9_ = NULL;
				xmlNodeSet* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				xmlNode* _tmp12_ = NULL;
				xmlNode* _tmp13_ = NULL;
				xmlNode* _tmp14_ = NULL;
				xmlNode* _tmp15_ = NULL;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = devcap_object;
				_tmp7_ = _tmp6_->nodesetval;
				_tmp8_ = xmlXPathNodeSetGetLength (_tmp7_);
				if (!(_tmp5_ < _tmp8_)) {
					break;
				}
				_tmp9_ = devcap_object;
				_tmp10_ = _tmp9_->nodesetval;
				_tmp11_ = i;
				_tmp12_ = xmlXPathNodeSetItem (_tmp10_, _tmp11_);
				node = _tmp12_;
				_tmp13_ = node;
				if (_tmp13_ == NULL) {
					continue;
				}
				_tmp14_ = node;
				xmlUnlinkNode (_tmp14_);
				_tmp15_ = node;
				xmlFreeNode (_tmp15_);
			}
		}
	}
	_tmp16_ = devcap_object;
	xmlXPathFreeObject (_tmp16_);
}


static xmlNode* rygel_description_file_get_device_element (RygelDescriptionFile* self) {
	xmlNode* result = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", NULL);
	result = _tmp2_;
	return result;
}


static gboolean rygel_description_file_apply_xpath (RygelDescriptionFile* self, const gchar* xpath, xmlXPathObject** xpo) {
	xmlXPathObject* _vala_xpo = NULL;
	gboolean result = FALSE;
	xmlXPathContext* context = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlXPathContext* _tmp2_ = NULL;
	xmlXPathObject* _result_ = NULL;
	xmlXPathContext* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	xmlXPathObject* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	xmlXPathObject* _tmp8_ = NULL;
	gboolean retval = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (xpath != NULL, FALSE);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = xmlXPathNewContext (_tmp1_);
	context = _tmp2_;
	_tmp3_ = context;
	_tmp4_ = xpath;
	_tmp5_ = xmlXPathEvalExpression ((xmlChar*) _tmp4_, _tmp3_);
	_result_ = _tmp5_;
	_tmp8_ = _result_;
	if (_tmp8_ != NULL) {
		xmlXPathObject* _tmp9_ = NULL;
		xmlXPathObjectType _tmp10_ = 0;
		_tmp9_ = _result_;
		_tmp10_ = _tmp9_->type;
		_tmp7_ = _tmp10_ == XPATH_NODESET;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		xmlXPathObject* _tmp11_ = NULL;
		xmlNodeSet* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp11_ = _result_;
		_tmp12_ = _tmp11_->nodesetval;
		_tmp13_ = xmlXPathNodeSetIsEmpty (_tmp12_);
		_tmp6_ = !_tmp13_;
	} else {
		_tmp6_ = FALSE;
	}
	retval = _tmp6_;
	_tmp15_ = retval;
	if (!_tmp15_) {
		xmlXPathObject* _tmp16_ = NULL;
		_tmp16_ = _result_;
		_tmp14_ = _tmp16_ != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		xmlXPathObject* _tmp17_ = NULL;
		_vala_xpo = NULL;
		_tmp17_ = _result_;
		xmlXPathFreeObject (_tmp17_);
	} else {
		xmlXPathObject* _tmp18_ = NULL;
		_tmp18_ = _result_;
		_vala_xpo = _tmp18_;
	}
	result = retval;
	_xmlXPathFreeContext0 (context);
	if (xpo) {
		*xpo = _vala_xpo;
	}
	return result;
}


void rygel_description_file_add_service (RygelDescriptionFile* self, const gchar* device_name, RygelResourceInfo* resource_info) {
	xmlNode* list = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* service_node = NULL;
	xmlNode* _tmp5_ = NULL;
	xmlNode* _tmp6_ = NULL;
	RygelResourceInfo* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	RygelResourceInfo* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* url = NULL;
	RygelResourceInfo* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	RygelResourceInfo* _tmp20_ = NULL;
	GType _tmp21_ = 0UL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	RygelResourceInfo* _tmp30_ = NULL;
	GType _tmp31_ = 0UL;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_name != NULL);
	g_return_if_fail (resource_info != NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "serviceList", NULL);
	list = _tmp2_;
	_tmp3_ = list;
	if (_tmp3_ == NULL) {
		xmlNode* _tmp4_ = NULL;
		_tmp4_ = rygel_description_file_set_device_element (self, "serviceList", NULL, NULL);
		list = _tmp4_;
	}
	_tmp5_ = list;
	_tmp6_ = xmlNewChild (_tmp5_, NULL, (xmlChar*) "service", (xmlChar*) NULL);
	service_node = _tmp6_;
	_tmp7_ = resource_info;
	_tmp8_ = _tmp7_->upnp_type;
	xmlNewChild (service_node, NULL, (xmlChar*) "serviceType", (xmlChar*) _tmp8_);
	_tmp9_ = resource_info;
	_tmp10_ = _tmp9_->upnp_id;
	xmlNewChild (service_node, NULL, (xmlChar*) "serviceId", (xmlChar*) _tmp10_);
	_tmp11_ = resource_info;
	_tmp12_ = _tmp11_->description_path;
	_tmp13_ = g_strconcat ("/", _tmp12_, NULL);
	url = _tmp13_;
	_tmp14_ = url;
	xmlNewChild (service_node, NULL, (xmlChar*) "SCPDURL", (xmlChar*) _tmp14_);
	_tmp15_ = device_name;
	_tmp16_ = g_strconcat ("/Control/", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, "/", NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = resource_info;
	_tmp21_ = _tmp20_->type;
	_tmp22_ = g_type_name (_tmp21_);
	_tmp23_ = g_strconcat (_tmp19_, _tmp22_, NULL);
	_g_free0 (url);
	url = _tmp23_;
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_tmp24_ = url;
	xmlNewChild (service_node, NULL, (xmlChar*) "controlURL", (xmlChar*) _tmp24_);
	_tmp25_ = device_name;
	_tmp26_ = g_strconcat ("/Event/", _tmp25_, NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat (_tmp27_, "/", NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = resource_info;
	_tmp31_ = _tmp30_->type;
	_tmp32_ = g_type_name (_tmp31_);
	_tmp33_ = g_strconcat (_tmp29_, _tmp32_, NULL);
	_g_free0 (url);
	url = _tmp33_;
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_tmp34_ = url;
	xmlNewChild (service_node, NULL, (xmlChar*) "eventSubURL", (xmlChar*) _tmp34_);
	_g_free0 (url);
}


void rygel_description_file_clear_icon_list (RygelDescriptionFile* self) {
	g_return_if_fail (self != NULL);
	rygel_description_file_remove_device_element (self, "iconList");
}


void rygel_description_file_add_icon (RygelDescriptionFile* self, const gchar* device_name, RygelIconInfo* icon_info, const gchar* url) {
	xmlNode* list = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* icon_node = NULL;
	xmlNode* _tmp5_ = NULL;
	xmlNode* _tmp6_ = NULL;
	gchar* width = NULL;
	RygelIconInfo* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* height = NULL;
	RygelIconInfo* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	gchar* depth = NULL;
	RygelIconInfo* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gchar* _tmp15_ = NULL;
	RygelIconInfo* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_name != NULL);
	g_return_if_fail (icon_info != NULL);
	g_return_if_fail (url != NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "iconList", NULL);
	list = _tmp2_;
	_tmp3_ = list;
	if (_tmp3_ == NULL) {
		xmlNode* _tmp4_ = NULL;
		_tmp4_ = rygel_description_file_set_device_element (self, "iconList", NULL, NULL);
		list = _tmp4_;
	}
	_tmp5_ = list;
	_tmp6_ = xmlNewChild (_tmp5_, NULL, (xmlChar*) "icon", (xmlChar*) NULL);
	icon_node = _tmp6_;
	_tmp7_ = icon_info;
	_tmp8_ = _tmp7_->width;
	_tmp9_ = g_strdup_printf ("%i", _tmp8_);
	width = _tmp9_;
	_tmp10_ = icon_info;
	_tmp11_ = _tmp10_->height;
	_tmp12_ = g_strdup_printf ("%i", _tmp11_);
	height = _tmp12_;
	_tmp13_ = icon_info;
	_tmp14_ = _tmp13_->depth;
	_tmp15_ = g_strdup_printf ("%i", _tmp14_);
	depth = _tmp15_;
	_tmp16_ = icon_info;
	_tmp17_ = _tmp16_->mime_type;
	xmlNewChild (icon_node, NULL, (xmlChar*) "mimetype", (xmlChar*) _tmp17_);
	xmlNewChild (icon_node, NULL, (xmlChar*) "width", (xmlChar*) width);
	xmlNewChild (icon_node, NULL, (xmlChar*) "height", (xmlChar*) height);
	xmlNewChild (icon_node, NULL, (xmlChar*) "depth", (xmlChar*) depth);
	_tmp18_ = url;
	xmlNewChild (icon_node, NULL, (xmlChar*) "url", (xmlChar*) _tmp18_);
	_g_free0 (depth);
	_g_free0 (height);
	_g_free0 (width);
}


/**
     * Change the type of a service.
     *
     * Usually used to modify the service version, e.g. old_type =
     * "ContentDirectory:2" and new_type = "ContentDirectory:1".
     *
     * @param old_type is the current content of serviceType.
     * @param new_type is the content serviceType will be set to.
     */
void rygel_description_file_modify_service_type (RygelDescriptionFile* self, const gchar* old_type, const gchar* new_type) {
	xmlXPathObject* xpath_object = NULL;
	gchar* xpath = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	xmlXPathObject* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	xpath_object = NULL;
	_tmp0_ = old_type;
	_tmp1_ = g_strdup_printf (RYGEL_DESCRIPTION_FILE_SERVICE_TYPE_TEMPLATE, _tmp0_);
	xpath = _tmp1_;
	_tmp2_ = xpath;
	_tmp4_ = rygel_description_file_apply_xpath (self, _tmp2_, &_tmp3_);
	xpath_object = _tmp3_;
	if (_tmp4_) {
		xmlXPathObject* _tmp5_ = NULL;
		xmlNodeSet* _tmp6_ = NULL;
		xmlNode* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		xmlXPathObject* _tmp9_ = NULL;
		_tmp5_ = xpath_object;
		_tmp6_ = _tmp5_->nodesetval;
		_tmp7_ = xmlXPathNodeSetItem (_tmp6_, 0);
		_tmp8_ = new_type;
		xmlNodeSetContent (_tmp7_, (xmlChar*) _tmp8_);
		_tmp9_ = xpath_object;
		xmlXPathFreeObject (_tmp9_);
	}
	_g_free0 (xpath);
}


/**
     * Writes the current document to a file.
     *
     * It makes sure that the resulting file has the correct UTF-8 encoding
     * and does not have any kind of newlines. This is necessary as some
     * devices with broken XML parsers can't cope with UNIX newlines.
     * If a file with the same name exists it will be overwritten.
     *
     * @param path is a path to a file.
     * @throws GLib.Error if anything fails while creating the XML dump.
     */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void rygel_description_file_save (RygelDescriptionFile* self, const gchar* path, GError** error) {
	gchar* mem = NULL;
	gint len = 0;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	mem = NULL;
	len = -1;
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	xmlDocDumpMemoryEnc (_tmp1_, (xmlChar**) (&_tmp2_), &_tmp3_, "UTF-8");
	_g_free0 (mem);
	mem = _tmp2_;
	len = _tmp3_;
	_tmp4_ = len;
	_tmp5_ = G_UNLIKELY (_tmp4_ <= 0);
	if (_tmp5_) {
		gchar* message = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		_tmp6_ = _ ("Failed to write modified description to %s");
		_tmp7_ = g_strdup (_tmp6_);
		message = _tmp7_;
		_tmp8_ = message;
		_tmp9_ = path;
		_tmp10_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp8_, _tmp9_);
		_inner_error_ = _tmp10_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (message);
		_g_free0 (mem);
		return;
	}
	_tmp11_ = path;
	_tmp12_ = mem;
	_tmp13_ = string_replace (_tmp12_, "\n", "");
	_tmp14_ = _tmp13_;
	g_file_set_contents (_tmp11_, _tmp14_, (gssize) -1, &_inner_error_);
	_g_free0 (_tmp14_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (mem);
		return;
	}
	_g_free0 (mem);
}


static gint rygel_description_file_index_of_device_element (RygelDescriptionFile* self, const gchar* element) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (element != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gchar** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gchar** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp5_ = 0;
				const gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->device_elements;
				_tmp3__length1 = self->priv->device_elements_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = self->priv->device_elements;
				_tmp4__length1 = self->priv->device_elements_length1;
				_tmp5_ = i;
				_tmp6_ = _tmp4_[_tmp5_];
				_tmp7_ = element;
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


/**
     * Internal helper function to set an element to a new value,
     * creating it if needed.
     *
     * @param element below /root/device to be set.
     * @param new_value is the new content of that element.
     *
     * @returns the element that was modified (or created) or null
     */
static xmlNode* rygel_description_file_set_device_element (RygelDescriptionFile* self, const gchar* element, const gchar* new_value, const gchar* ns) {
	xmlNode* result = NULL;
	xmlNode* xml_element = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* _tmp4_ = NULL;
	xmlNode* device_element = NULL;
	GUPnPXMLDoc* _tmp8_ = NULL;
	xmlDoc* _tmp9_ = NULL;
	xmlNode* _tmp10_ = NULL;
	xmlNs* xml_ns = NULL;
	const gchar* _tmp11_ = NULL;
	xmlNode* _tmp17_ = NULL;
	xmlNs* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	xmlNode* _tmp21_ = NULL;
	gint index = 0;
	const gchar* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	xmlNode* _tmp46_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = element;
	_tmp3_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", _tmp2_, NULL);
	xml_element = _tmp3_;
	_tmp4_ = xml_element;
	if (_tmp4_ != NULL) {
		xmlNode* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		xmlNode* _tmp7_ = NULL;
		_tmp5_ = xml_element;
		_tmp6_ = new_value;
		xmlNodeSetContent (_tmp5_, (xmlChar*) _tmp6_);
		_tmp7_ = xml_element;
		result = _tmp7_;
		return result;
	}
	_tmp8_ = self->priv->doc;
	_tmp9_ = _tmp8_->doc;
	_tmp10_ = rygel_xml_utils_get_element ((xmlNode*) _tmp9_, "root", "device", NULL);
	device_element = _tmp10_;
	xml_ns = NULL;
	_tmp11_ = ns;
	if (_tmp11_ != NULL) {
		GUPnPXMLDoc* _tmp12_ = NULL;
		xmlDoc* _tmp13_ = NULL;
		xmlNode* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		xmlNs* _tmp16_ = NULL;
		_tmp12_ = self->priv->doc;
		_tmp13_ = _tmp12_->doc;
		_tmp14_ = device_element;
		_tmp15_ = ns;
		_tmp16_ = xmlSearchNs (_tmp13_, _tmp14_, _tmp15_);
		xml_ns = _tmp16_;
	}
	_tmp17_ = device_element;
	_tmp18_ = xml_ns;
	_tmp19_ = element;
	_tmp20_ = new_value;
	_tmp21_ = xmlNewChild (_tmp17_, _tmp18_, (xmlChar*) _tmp19_, (xmlChar*) _tmp20_);
	xml_element = _tmp21_;
	_tmp22_ = element;
	_tmp23_ = rygel_description_file_index_of_device_element (self, _tmp22_);
	index = _tmp23_;
	_tmp24_ = index;
	if (_tmp24_ > -1) {
		xmlNode* sibling = NULL;
		xmlNode* _tmp39_ = NULL;
		sibling = NULL;
		{
			gint _tmp25_ = 0;
			gboolean _tmp26_ = FALSE;
			_tmp25_ = index;
			index = _tmp25_ - 1;
			_tmp26_ = TRUE;
			while (TRUE) {
				gint _tmp28_ = 0;
				GUPnPXMLDoc* _tmp29_ = NULL;
				xmlDoc* _tmp30_ = NULL;
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				const gchar* _tmp33_ = NULL;
				xmlNode* _tmp34_ = NULL;
				xmlNode* _tmp35_ = NULL;
				if (!_tmp26_) {
					gint _tmp27_ = 0;
					_tmp27_ = index;
					index = _tmp27_ - 1;
				}
				_tmp26_ = FALSE;
				_tmp28_ = index;
				if (!(_tmp28_ > 0)) {
					break;
				}
				_tmp29_ = self->priv->doc;
				_tmp30_ = _tmp29_->doc;
				_tmp31_ = self->priv->device_elements;
				_tmp31__length1 = self->priv->device_elements_length1;
				_tmp32_ = index;
				_tmp33_ = _tmp31_[_tmp32_];
				_tmp34_ = rygel_xml_utils_get_element ((xmlNode*) _tmp30_, "root", "device", _tmp33_, NULL);
				sibling = _tmp34_;
				_tmp35_ = sibling;
				if (_tmp35_ != NULL) {
					xmlNode* _tmp36_ = NULL;
					xmlNode* _tmp37_ = NULL;
					xmlNode* _tmp38_ = NULL;
					_tmp36_ = sibling;
					_tmp37_ = xml_element;
					_tmp38_ = xmlAddNextSibling (_tmp36_, _tmp37_);
					xml_element = _tmp38_;
					break;
				}
			}
		}
		_tmp39_ = sibling;
		if (_tmp39_ == NULL) {
			xmlNode* _tmp40_ = NULL;
			xmlNode* _tmp41_ = NULL;
			xmlNode* _tmp42_ = NULL;
			_tmp40_ = device_element;
			_tmp41_ = xmlFirstElementChild (_tmp40_);
			sibling = _tmp41_;
			_tmp42_ = sibling;
			if (_tmp42_ != NULL) {
				xmlNode* _tmp43_ = NULL;
				xmlNode* _tmp44_ = NULL;
				xmlNode* _tmp45_ = NULL;
				_tmp43_ = sibling;
				_tmp44_ = xml_element;
				_tmp45_ = xmlAddPrevSibling (_tmp43_, _tmp44_);
				xml_element = _tmp45_;
			}
		}
	}
	_tmp46_ = xml_element;
	result = _tmp46_;
	return result;
}


/**
     * Internal helper function to remove an element (if it exists).
     *
     * @param element below /root/device to be removed.
     */
static void rygel_description_file_remove_device_element (RygelDescriptionFile* self, const gchar* element) {
	xmlNode* xml_element = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = element;
	_tmp3_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", _tmp2_, NULL);
	xml_element = _tmp3_;
	_tmp4_ = xml_element;
	if (_tmp4_ != NULL) {
		xmlNode* _tmp5_ = NULL;
		xmlNode* _tmp6_ = NULL;
		_tmp5_ = xml_element;
		xmlUnlinkNode (_tmp5_);
		_tmp6_ = xml_element;
		xmlFreeNode (_tmp6_);
	}
}


static void rygel_description_file_class_init (RygelDescriptionFileClass * klass) {
	rygel_description_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelDescriptionFilePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_description_file_finalize;
}


static void rygel_description_file_instance_init (RygelDescriptionFile * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	self->priv = RYGEL_DESCRIPTION_FILE_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("deviceType");
	_tmp1_ = g_strdup ("friendlyName");
	_tmp2_ = g_strdup ("manufacturer");
	_tmp3_ = g_strdup ("manufacturerURL");
	_tmp4_ = g_strdup ("modelDescription");
	_tmp5_ = g_strdup ("modelName");
	_tmp6_ = g_strdup ("modelNumber");
	_tmp7_ = g_strdup ("modelURL");
	_tmp8_ = g_strdup ("serialNumber");
	_tmp9_ = g_strdup ("UDN");
	_tmp10_ = g_strdup ("UPC");
	_tmp11_ = g_strdup ("iconList");
	_tmp12_ = g_strdup ("serviceList");
	_tmp13_ = g_strdup ("deviceList");
	_tmp14_ = g_strdup ("presentationURL");
	_tmp15_ = g_new0 (gchar*, 15 + 1);
	_tmp15_[0] = _tmp0_;
	_tmp15_[1] = _tmp1_;
	_tmp15_[2] = _tmp2_;
	_tmp15_[3] = _tmp3_;
	_tmp15_[4] = _tmp4_;
	_tmp15_[5] = _tmp5_;
	_tmp15_[6] = _tmp6_;
	_tmp15_[7] = _tmp7_;
	_tmp15_[8] = _tmp8_;
	_tmp15_[9] = _tmp9_;
	_tmp15_[10] = _tmp10_;
	_tmp15_[11] = _tmp11_;
	_tmp15_[12] = _tmp12_;
	_tmp15_[13] = _tmp13_;
	_tmp15_[14] = _tmp14_;
	self->priv->device_elements = _tmp15_;
	self->priv->device_elements_length1 = 15;
	self->priv->_device_elements_size_ = self->priv->device_elements_length1;
}


static void rygel_description_file_finalize (GObject* obj) {
	RygelDescriptionFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile);
	self->priv->device_elements = (_vala_array_free (self->priv->device_elements, self->priv->device_elements_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->doc);
	G_OBJECT_CLASS (rygel_description_file_parent_class)->finalize (obj);
}


/**
 * Represents a device description document and offers methods for easy
 * manipulation of those.
 */
GType rygel_description_file_get_type (void) {
	static volatile gsize rygel_description_file_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_description_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDescriptionFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_description_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDescriptionFile), 0, (GInstanceInitFunc) rygel_description_file_instance_init, NULL };
		GType rygel_description_file_type_id;
		rygel_description_file_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelDescriptionFile", &g_define_type_info, 0);
		g_once_init_leave (&rygel_description_file_type_id__volatile, rygel_description_file_type_id);
	}
	return rygel_description_file_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



