/* rygel-lms-image-year.c generated by valac 0.34.7, the Vala compiler
 * generated from rygel-lms-image-year.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-db.h>
#include <gio/gio.h>


#define RYGEL_LMS_TYPE_CATEGORY_CONTAINER (rygel_lms_category_container_get_type ())
#define RYGEL_LMS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer))
#define RYGEL_LMS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerClass))
#define RYGEL_LMS_IS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER))
#define RYGEL_LMS_IS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_CATEGORY_CONTAINER))
#define RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerClass))

typedef struct _RygelLMSCategoryContainer RygelLMSCategoryContainer;
typedef struct _RygelLMSCategoryContainerClass RygelLMSCategoryContainerClass;
typedef struct _RygelLMSCategoryContainerPrivate RygelLMSCategoryContainerPrivate;

#define RYGEL_LMS_TYPE_IMAGE_YEAR (rygel_lms_image_year_get_type ())
#define RYGEL_LMS_IMAGE_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_IMAGE_YEAR, RygelLMSImageYear))
#define RYGEL_LMS_IMAGE_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_IMAGE_YEAR, RygelLMSImageYearClass))
#define RYGEL_LMS_IS_IMAGE_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_IMAGE_YEAR))
#define RYGEL_LMS_IS_IMAGE_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_IMAGE_YEAR))
#define RYGEL_LMS_IMAGE_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_IMAGE_YEAR, RygelLMSImageYearClass))

typedef struct _RygelLMSImageYear RygelLMSImageYear;
typedef struct _RygelLMSImageYearClass RygelLMSImageYearClass;
typedef struct _RygelLMSImageYearPrivate RygelLMSImageYearPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_LMS_TYPE_DATABASE (rygel_lms_database_get_type ())
#define RYGEL_LMS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabase))
#define RYGEL_LMS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))
#define RYGEL_LMS_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))

typedef struct _RygelLMSDatabase RygelLMSDatabase;
typedef struct _RygelLMSDatabaseClass RygelLMSDatabaseClass;

struct _RygelLMSCategoryContainer {
	RygelMediaContainer parent_instance;
	RygelLMSCategoryContainerPrivate * priv;
	RygelDatabaseCursor* cursor_all;
	RygelDatabaseCursor* cursor_find_object;
	RygelDatabaseCursor* cursor_added;
	RygelDatabaseCursor* cursor_removed;
	gchar* child_prefix;
	gchar* ref_prefix;
};

struct _RygelLMSCategoryContainerClass {
	RygelMediaContainerClass parent_class;
	RygelMediaObject* (*object_from_statement) (RygelLMSCategoryContainer* self, sqlite3_stmt* statement);
	gchar* (*get_sql_all_with_filter) (RygelLMSCategoryContainer* self, const gchar* filter);
	gchar* (*get_sql_count_with_filter) (RygelLMSCategoryContainer* self, const gchar* filter);
	guint (*get_child_count_with_filter) (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args);
	RygelMediaObjects* (*get_children_with_filter) (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args, const gchar* sort_criteria, guint offset, guint max_count);
};

struct _RygelLMSImageYear {
	RygelLMSCategoryContainer parent_instance;
	RygelLMSImageYearPrivate * priv;
};

struct _RygelLMSImageYearClass {
	RygelLMSCategoryContainerClass parent_class;
};


static gpointer rygel_lms_image_year_parent_class = NULL;

GType rygel_lms_category_container_get_type (void) G_GNUC_CONST;
GType rygel_lms_image_year_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_LMS_IMAGE_YEAR_DUMMY_PROPERTY
};
#define RYGEL_LMS_IMAGE_YEAR_SQL_ALL_TEMPLATE "SELECT images.id, title, artist, date, width, height, path, size, " "dlna_profile, dlna_mime, strftime('%Y', date, 'unixepoch') as year " "FROM images, files " "WHERE dtime = 0 AND images.id = files.id AND year = '%s' " "LIMIT ? OFFSET ?;"
#define RYGEL_LMS_IMAGE_YEAR_SQL_COUNT_TEMPLATE "SELECT count(images.id), strftime('%Y', date, 'unixepoch') as year " "FROM images, files " "WHERE dtime = 0 AND images.id = files.id AND year = '%s';"
#define RYGEL_LMS_IMAGE_YEAR_SQL_FIND_OBJECT_TEMPLATE "SELECT images.id, title, artist, date, width, height, path, size, " "dlna_profile, dlna_mime, strftime('%Y', date, 'unixepoch') as year " "FROM images, files " "WHERE dtime = 0 AND files.id = ? AND images.id = files.id AND year = '" \
"%s';"
#define RYGEL_LMS_IMAGE_YEAR_SQL_ADDED_TEMPLATE "SELECT images.id, title, artist, date, width, height, path, size, " "dlna_profile, dlna_mime, strftime('%Y', date, 'unixepoch') as year " "FROM images, files " "WHERE dtime = 0 AND images.id = files.id AND year = '%s' " "AND update_id > ? AND update_id <= ?;"
#define RYGEL_LMS_IMAGE_YEAR_SQL_REMOVED_TEMPLATE "SELECT images.id, title, artist, date, width, height, path, size, " "dlna_profile, dlna_mime, strftime('%Y', date, 'unixepoch') as year " "FROM images, files " "WHERE dtime <> 0 AND images.id = files.id AND year = '%s' " "AND update_id > ? AND update_id <= ?;"
static RygelMediaObject* rygel_lms_image_year_real_object_from_statement (RygelLMSCategoryContainer* base, sqlite3_stmt* statement);
gchar* rygel_lms_category_container_build_child_id (RygelLMSCategoryContainer* self, gint db_id);
gchar* rygel_lms_category_container_build_reference_id (RygelLMSCategoryContainer* self, gint db_id);
static gchar* rygel_lms_image_year_get_sql_all (const gchar* year);
static gchar* rygel_lms_image_year_get_sql_find_object (const gchar* year);
static gchar* rygel_lms_image_year_get_sql_count (const gchar* year);
static gchar* rygel_lms_image_year_get_sql_added (const gchar* year);
static gchar* rygel_lms_image_year_get_sql_removed (const gchar* year);
GType rygel_lms_database_get_type (void) G_GNUC_CONST;
RygelLMSImageYear* rygel_lms_image_year_new (RygelMediaContainer* parent, const gchar* year, RygelLMSDatabase* lms_db);
RygelLMSImageYear* rygel_lms_image_year_construct (GType object_type, RygelMediaContainer* parent, const gchar* year, RygelLMSDatabase* lms_db);
RygelLMSCategoryContainer* rygel_lms_category_container_construct (GType object_type, const gchar* db_id, RygelMediaContainer* parent, const gchar* title, RygelLMSDatabase* lms_db, const gchar* sql_all, const gchar* sql_find_object, const gchar* sql_count, const gchar* sql_added, const gchar* sql_removed);


static RygelMediaObject* rygel_lms_image_year_real_object_from_statement (RygelLMSCategoryContainer* base, sqlite3_stmt* statement) {
	RygelLMSImageYear * self;
	RygelMediaObject* result = NULL;
	gint id = 0;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* path = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* mime_type = NULL;
	sqlite3_stmt* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	gchar* title = NULL;
	sqlite3_stmt* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	RygelImageItem* image = NULL;
	gint _tmp18_ = 0;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	RygelImageItem* _tmp21_ = NULL;
	RygelImageItem* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	sqlite3_stmt* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GTimeVal tv = {0};
	sqlite3_stmt* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	GTimeVal _tmp30_ = {0};
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	sqlite3_stmt* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	sqlite3_stmt* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	sqlite3_stmt* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	const gchar* _tmp39_ = NULL;
	sqlite3_stmt* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp42_ = NULL;
	GFile* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	self = (RygelLMSImageYear*) base;
	g_return_val_if_fail (statement != NULL, NULL);
	_tmp0_ = statement;
	_tmp1_ = sqlite3_column_int (_tmp0_, 0);
	id = _tmp1_;
	_tmp2_ = statement;
	_tmp3_ = sqlite3_column_text (_tmp2_, 6);
	_tmp4_ = g_strdup (_tmp3_);
	path = _tmp4_;
	_tmp5_ = statement;
	_tmp6_ = sqlite3_column_text (_tmp5_, 9);
	_tmp7_ = g_strdup (_tmp6_);
	mime_type = _tmp7_;
	_tmp9_ = mime_type;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp10_ = mime_type;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_ == 0;
	}
	if (_tmp8_) {
		gint _tmp13_ = 0;
		const gchar* _tmp14_ = NULL;
		_tmp13_ = id;
		_tmp14_ = path;
		g_debug ("rygel-lms-image-year.vala:67: Image item %d (%s) has no MIME type", _tmp13_, _tmp14_);
	}
	_tmp15_ = statement;
	_tmp16_ = sqlite3_column_text (_tmp15_, 1);
	_tmp17_ = g_strdup (_tmp16_);
	title = _tmp17_;
	_tmp18_ = id;
	_tmp19_ = rygel_lms_category_container_build_child_id ((RygelLMSCategoryContainer*) self, _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = rygel_image_item_new (_tmp20_, (RygelMediaContainer*) self, title, RYGEL_IMAGE_ITEM_UPNP_CLASS);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp20_);
	image = _tmp22_;
	_tmp23_ = id;
	_tmp24_ = rygel_lms_category_container_build_reference_id ((RygelLMSCategoryContainer*) self, _tmp23_);
	_tmp25_ = _tmp24_;
	rygel_media_object_set_ref_id ((RygelMediaObject*) image, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = statement;
	_tmp27_ = sqlite3_column_text (_tmp26_, 2);
	rygel_media_object_set_creator ((RygelMediaObject*) image, _tmp27_);
	_tmp28_ = statement;
	_tmp29_ = sqlite3_column_int (_tmp28_, 3);
	_tmp30_.tv_sec = (glong) _tmp29_;
	_tmp30_.tv_usec = (glong) 0;
	tv = _tmp30_;
	_tmp31_ = g_time_val_to_iso8601 (&tv);
	_tmp32_ = _tmp31_;
	rygel_media_object_set_date ((RygelMediaObject*) image, _tmp32_);
	_g_free0 (_tmp32_);
	_tmp33_ = statement;
	_tmp34_ = sqlite3_column_int (_tmp33_, 4);
	rygel_visual_item_set_width ((RygelVisualItem*) image, _tmp34_);
	_tmp35_ = statement;
	_tmp36_ = sqlite3_column_int (_tmp35_, 5);
	rygel_visual_item_set_height ((RygelVisualItem*) image, _tmp36_);
	_tmp37_ = statement;
	_tmp38_ = sqlite3_column_int (_tmp37_, 7);
	rygel_media_file_item_set_size ((RygelMediaFileItem*) image, (gint64) _tmp38_);
	_tmp39_ = mime_type;
	rygel_media_file_item_set_mime_type ((RygelMediaFileItem*) image, _tmp39_);
	_tmp40_ = statement;
	_tmp41_ = sqlite3_column_text (_tmp40_, 8);
	rygel_media_file_item_set_dlna_profile ((RygelMediaFileItem*) image, _tmp41_);
	_tmp42_ = path;
	_tmp43_ = g_file_new_for_path (_tmp42_);
	file = _tmp43_;
	_tmp44_ = g_file_get_uri (file);
	_tmp45_ = _tmp44_;
	rygel_media_object_add_uri ((RygelMediaObject*) image, _tmp45_);
	_g_free0 (_tmp45_);
	result = (RygelMediaObject*) image;
	_g_object_unref0 (file);
	_g_free0 (title);
	_g_free0 (mime_type);
	_g_free0 (path);
	return result;
}


static gchar* rygel_lms_image_year_get_sql_all (const gchar* year) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (year != NULL, NULL);
	_tmp0_ = year;
	_tmp1_ = g_strdup_printf (RYGEL_LMS_IMAGE_YEAR_SQL_ALL_TEMPLATE, _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* rygel_lms_image_year_get_sql_find_object (const gchar* year) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (year != NULL, NULL);
	_tmp0_ = year;
	_tmp1_ = g_strdup_printf (RYGEL_LMS_IMAGE_YEAR_SQL_FIND_OBJECT_TEMPLATE, _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* rygel_lms_image_year_get_sql_count (const gchar* year) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (year != NULL, NULL);
	_tmp0_ = year;
	_tmp1_ = g_strdup_printf (RYGEL_LMS_IMAGE_YEAR_SQL_COUNT_TEMPLATE, _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* rygel_lms_image_year_get_sql_added (const gchar* year) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (year != NULL, NULL);
	_tmp0_ = year;
	_tmp1_ = g_strdup_printf (RYGEL_LMS_IMAGE_YEAR_SQL_ADDED_TEMPLATE, _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* rygel_lms_image_year_get_sql_removed (const gchar* year) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (year != NULL, NULL);
	_tmp0_ = year;
	_tmp1_ = g_strdup_printf (RYGEL_LMS_IMAGE_YEAR_SQL_REMOVED_TEMPLATE, _tmp0_);
	result = _tmp1_;
	return result;
}


RygelLMSImageYear* rygel_lms_image_year_construct (GType object_type, RygelMediaContainer* parent, const gchar* year, RygelLMSDatabase* lms_db) {
	RygelLMSImageYear * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelMediaContainer* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	RygelLMSDatabase* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (year != NULL, NULL);
	g_return_val_if_fail (lms_db != NULL, NULL);
	_tmp0_ = year;
	_tmp1_ = g_strdup_printf ("%s", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = parent;
	_tmp4_ = year;
	_tmp5_ = lms_db;
	_tmp6_ = year;
	_tmp7_ = rygel_lms_image_year_get_sql_all (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = year;
	_tmp10_ = rygel_lms_image_year_get_sql_find_object (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = year;
	_tmp13_ = rygel_lms_image_year_get_sql_count (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = year;
	_tmp16_ = rygel_lms_image_year_get_sql_added (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = year;
	_tmp19_ = rygel_lms_image_year_get_sql_removed (_tmp18_);
	_tmp20_ = _tmp19_;
	self = (RygelLMSImageYear*) rygel_lms_category_container_construct (object_type, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp8_, _tmp11_, _tmp14_, _tmp17_, _tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp2_);
	return self;
}


RygelLMSImageYear* rygel_lms_image_year_new (RygelMediaContainer* parent, const gchar* year, RygelLMSDatabase* lms_db) {
	return rygel_lms_image_year_construct (RYGEL_LMS_TYPE_IMAGE_YEAR, parent, year, lms_db);
}


static void rygel_lms_image_year_class_init (RygelLMSImageYearClass * klass) {
	rygel_lms_image_year_parent_class = g_type_class_peek_parent (klass);
	((RygelLMSCategoryContainerClass *) klass)->object_from_statement = (RygelMediaObject* (*)(RygelLMSCategoryContainer*, sqlite3_stmt*)) rygel_lms_image_year_real_object_from_statement;
}


static void rygel_lms_image_year_instance_init (RygelLMSImageYear * self) {
}


GType rygel_lms_image_year_get_type (void) {
	static volatile gsize rygel_lms_image_year_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_lms_image_year_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelLMSImageYearClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_image_year_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSImageYear), 0, (GInstanceInitFunc) rygel_lms_image_year_instance_init, NULL };
		GType rygel_lms_image_year_type_id;
		rygel_lms_image_year_type_id = g_type_register_static (RYGEL_LMS_TYPE_CATEGORY_CONTAINER, "RygelLMSImageYear", &g_define_type_info, 0);
		g_once_init_leave (&rygel_lms_image_year_type_id__volatile, rygel_lms_image_year_type_id);
	}
	return rygel_lms_image_year_type_id__volatile;
}



