/* lightsoff-window.c generated by valac 0.32.1, the Vala compiler
 * generated from lightsoff-window.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2014 Michael Catanzaro
 * Copyright (C) 2016 Arnaud Bonatti
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <clutter/clutter.h>
#include <clutter-gtk/clutter-gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_LIGHTSOFF_WINDOW (lightsoff_window_get_type ())
#define LIGHTSOFF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIGHTSOFF_WINDOW, LightsoffWindow))
#define LIGHTSOFF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIGHTSOFF_WINDOW, LightsoffWindowClass))
#define IS_LIGHTSOFF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIGHTSOFF_WINDOW))
#define IS_LIGHTSOFF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIGHTSOFF_WINDOW))
#define LIGHTSOFF_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIGHTSOFF_WINDOW, LightsoffWindowClass))

typedef struct _LightsoffWindow LightsoffWindow;
typedef struct _LightsoffWindowClass LightsoffWindowClass;
typedef struct _LightsoffWindowPrivate LightsoffWindowPrivate;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _LightsoffWindow {
	GtkApplicationWindow parent_instance;
	LightsoffWindowPrivate * priv;
};

struct _LightsoffWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _LightsoffWindowPrivate {
	GtkHeaderBar* headerbar;
	GSettings* settings;
	GameView* game_view;
	GSimpleAction* previous_level;
};


static gpointer lightsoff_window_parent_class = NULL;

GType lightsoff_window_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
#define LIGHTSOFF_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIGHTSOFF_WINDOW, LightsoffWindowPrivate))
enum  {
	LIGHTSOFF_WINDOW_DUMMY_PROPERTY
};
static void lightsoff_window_new_game_cb (LightsoffWindow* self);
static void _lightsoff_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void lightsoff_window_previous_level_cb (LightsoffWindow* self);
static void _lightsoff_window_previous_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void lightsoff_window_next_level_cb (LightsoffWindow* self);
static void _lightsoff_window_next_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
LightsoffWindow* lightsoff_window_new (void);
LightsoffWindow* lightsoff_window_construct (GType object_type);
static void lightsoff_window_level_changed_cb (LightsoffWindow* self, gint level);
static gboolean lightsoff_window_key_release_event_cb (LightsoffWindow* self, ClutterActor* actor, ClutterKeyEvent* event);
static gboolean _lightsoff_window_key_release_event_cb_clutter_actor_key_release_event (ClutterActor* _sender, ClutterKeyEvent* event, gpointer self);
GameView* game_view_new (gint level);
GameView* game_view_construct (GType object_type, gint level);
static void _lightsoff_window_level_changed_cb_game_view_level_changed (GameView* _sender, gint level, gpointer self);
static void lightsoff_window_update_subtitle (LightsoffWindow* self, gint moves);
static void _lightsoff_window_update_subtitle_game_view_moves_changed (GameView* _sender, gint moves, gpointer self);
static void lightsoff_window_update_title (LightsoffWindow* self, gint level);
void game_view_swap_board (GameView* self, gint direction);
void game_view_hide_cursor (GameView* self);
void game_view_move_cursor (GameView* self, gint x_step, gint y_step);
void game_view_activate_cursor (GameView* self);
void game_view_reset_game (GameView* self);
static void lightsoff_window_finalize (GObject* obj);

static const GActionEntry LIGHTSOFF_WINDOW_window_actions[3] = {{"new-game", _lightsoff_window_new_game_cb_gsimple_action_activate_callback}, {"previous-level", _lightsoff_window_previous_level_cb_gsimple_action_activate_callback}, {"next-level", _lightsoff_window_next_level_cb_gsimple_action_activate_callback}};

static void _lightsoff_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	lightsoff_window_new_game_cb ((LightsoffWindow*) self);
}


static void _lightsoff_window_previous_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	lightsoff_window_previous_level_cb ((LightsoffWindow*) self);
}


static void _lightsoff_window_next_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	lightsoff_window_next_level_cb ((LightsoffWindow*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _lightsoff_window_key_release_event_cb_clutter_actor_key_release_event (ClutterActor* _sender, ClutterKeyEvent* event, gpointer self) {
	gboolean result;
	result = lightsoff_window_key_release_event_cb ((LightsoffWindow*) self, _sender, event);
	return result;
}


static void _lightsoff_window_level_changed_cb_game_view_level_changed (GameView* _sender, gint level, gpointer self) {
	lightsoff_window_level_changed_cb ((LightsoffWindow*) self, level);
}


static void _lightsoff_window_update_subtitle_game_view_moves_changed (GameView* _sender, gint moves, gpointer self) {
	lightsoff_window_update_subtitle ((LightsoffWindow*) self, moves);
}


LightsoffWindow* lightsoff_window_construct (GType object_type) {
	LightsoffWindow * self = NULL;
	GSettings* _tmp0_ = NULL;
	GAction* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GtkClutterEmbed* clutter_embed = NULL;
	GtkClutterEmbed* _tmp5_ = NULL;
	ClutterStage* stage = NULL;
	ClutterActor* _tmp6_ = NULL;
	ClutterStage* _tmp7_ = NULL;
	ClutterColor _tmp8_ = {0};
	GSettings* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GameView* _tmp11_ = NULL;
	GameView* _tmp12_ = NULL;
	GameView* _tmp13_ = NULL;
	GameView* _tmp14_ = NULL;
	GameView* _tmp15_ = NULL;
	GameView* _tmp16_ = NULL;
	gfloat _tmp17_ = 0.0F;
	gfloat _tmp18_ = 0.0F;
	GameView* _tmp19_ = NULL;
	gfloat _tmp20_ = 0.0F;
	gfloat _tmp21_ = 0.0F;
	gfloat _tmp22_ = 0.0F;
	gfloat _tmp23_ = 0.0F;
	gfloat _tmp24_ = 0.0F;
	gfloat _tmp25_ = 0.0F;
	self = (LightsoffWindow*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("org.gnome.lightsoff");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) self, LIGHTSOFF_WINDOW_window_actions, G_N_ELEMENTS (LIGHTSOFF_WINDOW_window_actions), self);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) self, "previous-level");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->previous_level);
	self->priv->previous_level = _tmp2_;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, "level");
	lightsoff_window_level_changed_cb (self, _tmp4_);
	_tmp5_ = (GtkClutterEmbed*) gtk_clutter_embed_new ();
	g_object_ref_sink (_tmp5_);
	clutter_embed = _tmp5_;
	gtk_widget_show ((GtkWidget*) clutter_embed);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) clutter_embed);
	_tmp6_ = gtk_clutter_embed_get_stage (clutter_embed);
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, clutter_stage_get_type (), ClutterStage));
	stage = _tmp7_;
	g_signal_connect_object ((ClutterActor*) stage, "key-release-event", (GCallback) _lightsoff_window_key_release_event_cb_clutter_actor_key_release_event, self, 0);
	clutter_color_from_string (&_tmp8_, "#000000");
	clutter_actor_set_background_color ((ClutterActor*) stage, &_tmp8_);
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_get_int (_tmp9_, "level");
	_tmp11_ = game_view_new (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->game_view);
	self->priv->game_view = _tmp11_;
	_tmp12_ = self->priv->game_view;
	g_signal_connect_object (_tmp12_, "level-changed", (GCallback) _lightsoff_window_level_changed_cb_game_view_level_changed, self, 0);
	_tmp13_ = self->priv->game_view;
	g_signal_connect_object (_tmp13_, "moves-changed", (GCallback) _lightsoff_window_update_subtitle_game_view_moves_changed, self, 0);
	_tmp14_ = self->priv->game_view;
	clutter_actor_show ((ClutterActor*) _tmp14_);
	_tmp15_ = self->priv->game_view;
	clutter_actor_add_child ((ClutterActor*) stage, (ClutterActor*) _tmp15_);
	_tmp16_ = self->priv->game_view;
	_tmp17_ = clutter_actor_get_width ((ClutterActor*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->game_view;
	_tmp20_ = clutter_actor_get_height ((ClutterActor*) _tmp19_);
	_tmp21_ = _tmp20_;
	clutter_actor_set_size ((ClutterActor*) stage, _tmp18_, _tmp21_);
	_tmp22_ = clutter_actor_get_width ((ClutterActor*) stage);
	_tmp23_ = _tmp22_;
	_tmp24_ = clutter_actor_get_height ((ClutterActor*) stage);
	_tmp25_ = _tmp24_;
	gtk_widget_set_size_request ((GtkWidget*) clutter_embed, (gint) _tmp23_, (gint) _tmp25_);
	_g_object_unref0 (stage);
	_g_object_unref0 (clutter_embed);
	return self;
}


LightsoffWindow* lightsoff_window_new (void) {
	return lightsoff_window_construct (TYPE_LIGHTSOFF_WINDOW);
}


static void lightsoff_window_update_subtitle (LightsoffWindow* self, gint moves) {
	GtkHeaderBar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	_tmp1_ = moves;
	_tmp2_ = ngettext ("%d move", "%d moves", (gulong) _tmp1_);
	_tmp3_ = moves;
	_tmp4_ = g_strdup_printf (_tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_header_bar_set_subtitle (_tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
}


static void lightsoff_window_update_title (LightsoffWindow* self, gint level) {
	GtkHeaderBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	_tmp1_ = _ ("Level %d");
	_tmp2_ = level;
	_tmp3_ = g_strdup_printf (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_header_bar_set_title (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = level;
	if (_tmp5_ == 1) {
		GtkHeaderBar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = self->priv->headerbar;
		_tmp7_ = _ ("Turn off all the lights!");
		gtk_header_bar_set_subtitle (_tmp6_, _tmp7_);
	} else {
		lightsoff_window_update_subtitle (self, 0);
	}
}


static void lightsoff_window_previous_level_cb (LightsoffWindow* self) {
	GameView* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	game_view_swap_board (_tmp0_, -1);
}


static void lightsoff_window_next_level_cb (LightsoffWindow* self) {
	GameView* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	game_view_swap_board (_tmp0_, 1);
}


static void lightsoff_window_level_changed_cb (LightsoffWindow* self, gint level) {
	GSimpleAction* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->previous_level;
	_tmp1_ = level;
	g_simple_action_set_enabled (_tmp0_, _tmp1_ > 1);
	_tmp2_ = level;
	lightsoff_window_update_title (self, _tmp2_);
	_tmp3_ = level;
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_get_int (_tmp4_, "level");
	if (_tmp3_ != _tmp5_) {
		GSettings* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp6_ = self->priv->settings;
		_tmp7_ = level;
		g_settings_set_int (_tmp6_, "level", _tmp7_);
	}
}


static gboolean lightsoff_window_key_release_event_cb (LightsoffWindow* self, ClutterActor* actor, ClutterKeyEvent* event) {
	gboolean result = FALSE;
	ClutterKeyEvent* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->keyval;
	switch (_tmp1_) {
		case CLUTTER_KEY_Escape:
		{
			GameView* _tmp2_ = NULL;
			_tmp2_ = self->priv->game_view;
			game_view_hide_cursor (_tmp2_);
			result = TRUE;
			return result;
		}
		case CLUTTER_KEY_Down:
		{
			GameView* _tmp3_ = NULL;
			_tmp3_ = self->priv->game_view;
			game_view_move_cursor (_tmp3_, 0, 1);
			result = TRUE;
			return result;
		}
		case CLUTTER_KEY_Up:
		{
			GameView* _tmp4_ = NULL;
			_tmp4_ = self->priv->game_view;
			game_view_move_cursor (_tmp4_, 0, -1);
			result = TRUE;
			return result;
		}
		case CLUTTER_KEY_Left:
		{
			GameView* _tmp5_ = NULL;
			_tmp5_ = self->priv->game_view;
			game_view_move_cursor (_tmp5_, -1, 0);
			result = TRUE;
			return result;
		}
		case CLUTTER_KEY_Right:
		{
			GameView* _tmp6_ = NULL;
			_tmp6_ = self->priv->game_view;
			game_view_move_cursor (_tmp6_, 1, 0);
			result = TRUE;
			return result;
		}
		case CLUTTER_KEY_Return:
		{
			GameView* _tmp7_ = NULL;
			_tmp7_ = self->priv->game_view;
			game_view_activate_cursor (_tmp7_);
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static void lightsoff_window_new_game_cb (LightsoffWindow* self) {
	GameView* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	game_view_reset_game (_tmp0_);
}


static void lightsoff_window_class_init (LightsoffWindowClass * klass) {
	gint LightsoffWindow_private_offset;
	lightsoff_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LightsoffWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = lightsoff_window_finalize;
	LightsoffWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/lightsoff/ui/lightsoff.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, LightsoffWindow_private_offset + G_STRUCT_OFFSET (LightsoffWindowPrivate, headerbar));
}


static void lightsoff_window_instance_init (LightsoffWindow * self) {
	self->priv = LIGHTSOFF_WINDOW_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void lightsoff_window_finalize (GObject* obj) {
	LightsoffWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIGHTSOFF_WINDOW, LightsoffWindow);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game_view);
	_g_object_unref0 (self->priv->previous_level);
	G_OBJECT_CLASS (lightsoff_window_parent_class)->finalize (obj);
}


GType lightsoff_window_get_type (void) {
	static volatile gsize lightsoff_window_type_id__volatile = 0;
	if (g_once_init_enter (&lightsoff_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LightsoffWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lightsoff_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LightsoffWindow), 0, (GInstanceInitFunc) lightsoff_window_instance_init, NULL };
		GType lightsoff_window_type_id;
		lightsoff_window_type_id = g_type_register_static (gtk_application_window_get_type (), "LightsoffWindow", &g_define_type_info, 0);
		g_once_init_leave (&lightsoff_window_type_id__volatile, lightsoff_window_type_id);
	}
	return lightsoff_window_type_id__volatile;
}



