/* report.c generated by valac 0.14.0, the Vala compiler
 * generated from report.vala, do not modify */

/*
 * Copyright (C) 2008-2009 Abderrahim Kitouni
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* A Vala.Report subclass for reporting errors in Anjuta UI */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <libanjuta/interfaces/libanjuta-interfaces.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>


#define TYPE_ANJUTA_REPORT (anjuta_report_get_type ())
#define ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANJUTA_REPORT, AnjutaReport))
#define ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANJUTA_REPORT, AnjutaReportClass))
#define IS_ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANJUTA_REPORT))
#define IS_ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANJUTA_REPORT))
#define ANJUTA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANJUTA_REPORT, AnjutaReportClass))

typedef struct _AnjutaReport AnjutaReport;
typedef struct _AnjutaReportClass AnjutaReportClass;
typedef struct _AnjutaReportPrivate AnjutaReportPrivate;

#define ANJUTA_REPORT_TYPE_ERROR (anjuta_report_error_get_type ())
typedef struct _AnjutaReportError AnjutaReportError;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _anjuta_report_error_free0(var) ((var == NULL) ? NULL : (var = (anjuta_report_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _AnjutaReport {
	ValaReport parent_instance;
	AnjutaReportPrivate * priv;
};

struct _AnjutaReportClass {
	ValaReportClass parent_class;
};

struct _AnjutaReportError {
	ValaSourceReference* source;
	gboolean error;
	gchar* message;
};

struct _AnjutaReportPrivate {
	IAnjutaDocumentManager* _docman;
	ValaList* errors_list;
	GStaticRecMutex __lock_errors_list;
	gboolean general_error;
};


static gpointer anjuta_report_parent_class = NULL;
static GType anjuta_report_type_id = 0;

GType anjuta_report_get_type (void) G_GNUC_CONST;
GType anjuta_report_register_type (GTypeModule * module);
static GType anjuta_report_error_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static AnjutaReportError* anjuta_report_error_dup (const AnjutaReportError* self);
static void anjuta_report_error_free (AnjutaReportError* self);
static void anjuta_report_error_copy (const AnjutaReportError* self, AnjutaReportError* dest);
static void anjuta_report_error_destroy (AnjutaReportError* self);
#define ANJUTA_REPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ANJUTA_REPORT, AnjutaReportPrivate))
enum  {
	ANJUTA_REPORT_DUMMY_PROPERTY,
	ANJUTA_REPORT_DOCMAN
};
void anjuta_report_update_errors (AnjutaReport* self, IAnjutaEditor* editor);
void anjuta_report_clear_error_indicators (AnjutaReport* self, ValaSourceFile* file);
IAnjutaDocumentManager* anjuta_report_get_docman (AnjutaReport* self);
static void anjuta_report_real_warn (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void anjuta_report_real_err (ValaReport* base, ValaSourceReference* source, const gchar* message);
AnjutaReport* anjuta_report_new (void);
AnjutaReport* anjuta_report_construct (GType object_type);
void anjuta_report_set_docman (AnjutaReport* self, IAnjutaDocumentManager* value);
static void anjuta_report_finalize (GObject* obj);
static void _vala_anjuta_report_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_anjuta_report_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


void anjuta_report_update_errors (AnjutaReport* self, IAnjutaEditor* editor) {
	IAnjutaEditor* _tmp0_;
	IAnjutaIndicable* _tmp1_;
	IAnjutaIndicable* ind;
	IAnjutaEditor* _tmp2_;
	IAnjutaMarkable* _tmp3_;
	IAnjutaMarkable* mark;
	gboolean _tmp4_ = FALSE;
	IAnjutaIndicable* _tmp5_;
	gboolean _tmp7_;
	IAnjutaIndicable* _tmp8_;
	IAnjutaMarkable* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	_tmp0_ = editor;
	_tmp1_ = _g_object_ref0 (IANJUTA_IS_INDICABLE (_tmp0_) ? ((IAnjutaIndicable*) _tmp0_) : NULL);
	ind = _tmp1_;
	_tmp2_ = editor;
	_tmp3_ = _g_object_ref0 (IANJUTA_IS_MARKABLE (_tmp2_) ? ((IAnjutaMarkable*) _tmp2_) : NULL);
	mark = _tmp3_;
	_tmp5_ = ind;
	if (_tmp5_ == NULL) {
		IAnjutaMarkable* _tmp6_;
		_tmp6_ = mark;
		_tmp4_ = _tmp6_ == NULL;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		_g_object_unref0 (mark);
		_g_object_unref0 (ind);
		return;
	}
	_tmp8_ = ind;
	if (_tmp8_ != NULL) {
		IAnjutaIndicable* _tmp9_;
		_tmp9_ = ind;
		ianjuta_indicable_clear (_tmp9_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (mark);
			_g_object_unref0 (ind);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp10_ = mark;
	if (_tmp10_ != NULL) {
		IAnjutaMarkable* _tmp11_;
		_tmp11_ = mark;
		ianjuta_markable_delete_all_markers (_tmp11_, IANJUTA_MARKABLE_MESSAGE, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (mark);
			_g_object_unref0 (ind);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		ValaList* _e_list;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _e_size;
		gint _e_index;
		_tmp12_ = self->priv->errors_list;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_e_list = _tmp13_;
		_tmp14_ = _e_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_e_size = _tmp16_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_ = NULL;
			AnjutaReportError* e;
			IAnjutaEditor* _tmp23_;
			const gchar* _tmp24_ = NULL;
			const gchar* _tmp25_;
			AnjutaReportError* _tmp26_;
			ValaSourceReference* _tmp27_;
			ValaSourceFile* _tmp28_;
			ValaSourceFile* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gboolean _tmp32_ = FALSE;
			_tmp17_ = _e_index;
			_e_index = _tmp17_ + 1;
			_tmp18_ = _e_index;
			_tmp19_ = _e_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _e_list;
			_tmp21_ = _e_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			e = (AnjutaReportError*) _tmp22_;
			_tmp23_ = editor;
			_tmp24_ = ianjuta_document_get_filename (IANJUTA_DOCUMENT (_tmp23_), &_inner_error_);
			_tmp25_ = _tmp24_;
			if (_inner_error_ != NULL) {
				_anjuta_report_error_free0 (e);
				_vala_iterable_unref0 (_e_list);
				_g_object_unref0 (mark);
				_g_object_unref0 (ind);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp26_ = e;
			_tmp27_ = (*_tmp26_).source;
			_tmp28_ = vala_source_reference_get_file (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = vala_source_file_get_filename (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_str_has_suffix (_tmp31_, _tmp25_);
			if (_tmp32_) {
				IAnjutaIndicable* _tmp33_;
				IAnjutaEditor* _tmp71_;
				_tmp33_ = ind;
				if (_tmp33_ != NULL) {
					IAnjutaEditor* _tmp34_;
					AnjutaReportError* _tmp35_;
					ValaSourceReference* _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					IAnjutaIterable* _tmp39_ = NULL;
					IAnjutaIterable* begin_iter;
					IAnjutaEditor* _tmp49_;
					AnjutaReportError* _tmp50_;
					ValaSourceReference* _tmp51_;
					gint _tmp52_;
					gint _tmp53_;
					IAnjutaIterable* _tmp54_ = NULL;
					IAnjutaIterable* end_iter;
					IAnjutaIndicableIndicator _tmp64_ = 0;
					AnjutaReportError* _tmp65_;
					gboolean _tmp66_;
					IAnjutaIndicable* _tmp67_;
					IAnjutaIterable* _tmp68_;
					IAnjutaIterable* _tmp69_;
					IAnjutaIndicableIndicator _tmp70_;
					_tmp34_ = editor;
					_tmp35_ = e;
					_tmp36_ = (*_tmp35_).source;
					_tmp37_ = vala_source_reference_get_first_line (_tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = ianjuta_editor_get_line_begin_position (_tmp34_, _tmp38_, &_inner_error_);
					begin_iter = _tmp39_;
					if (_inner_error_ != NULL) {
						_anjuta_report_error_free0 (e);
						_vala_iterable_unref0 (_e_list);
						_g_object_unref0 (mark);
						_g_object_unref0 (ind);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					{
						gint i;
						i = 1;
						{
							gboolean _tmp40_;
							_tmp40_ = TRUE;
							while (TRUE) {
								gboolean _tmp41_;
								gint _tmp43_;
								AnjutaReportError* _tmp44_;
								ValaSourceReference* _tmp45_;
								gint _tmp46_;
								gint _tmp47_;
								IAnjutaIterable* _tmp48_;
								_tmp41_ = _tmp40_;
								if (!_tmp41_) {
									gint _tmp42_;
									_tmp42_ = i;
									i = _tmp42_ + 1;
								}
								_tmp40_ = FALSE;
								_tmp43_ = i;
								_tmp44_ = e;
								_tmp45_ = (*_tmp44_).source;
								_tmp46_ = vala_source_reference_get_first_column (_tmp45_);
								_tmp47_ = _tmp46_;
								if (!(_tmp43_ < _tmp47_)) {
									break;
								}
								_tmp48_ = begin_iter;
								ianjuta_iterable_next (_tmp48_, &_inner_error_);
								if (_inner_error_ != NULL) {
									_g_object_unref0 (begin_iter);
									_anjuta_report_error_free0 (e);
									_vala_iterable_unref0 (_e_list);
									_g_object_unref0 (mark);
									_g_object_unref0 (ind);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						}
					}
					_tmp49_ = editor;
					_tmp50_ = e;
					_tmp51_ = (*_tmp50_).source;
					_tmp52_ = vala_source_reference_get_last_line (_tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = ianjuta_editor_get_line_begin_position (_tmp49_, _tmp53_, &_inner_error_);
					end_iter = _tmp54_;
					if (_inner_error_ != NULL) {
						_g_object_unref0 (begin_iter);
						_anjuta_report_error_free0 (e);
						_vala_iterable_unref0 (_e_list);
						_g_object_unref0 (mark);
						_g_object_unref0 (ind);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					{
						gint i;
						i = 0;
						{
							gboolean _tmp55_;
							_tmp55_ = TRUE;
							while (TRUE) {
								gboolean _tmp56_;
								gint _tmp58_;
								AnjutaReportError* _tmp59_;
								ValaSourceReference* _tmp60_;
								gint _tmp61_;
								gint _tmp62_;
								IAnjutaIterable* _tmp63_;
								_tmp56_ = _tmp55_;
								if (!_tmp56_) {
									gint _tmp57_;
									_tmp57_ = i;
									i = _tmp57_ + 1;
								}
								_tmp55_ = FALSE;
								_tmp58_ = i;
								_tmp59_ = e;
								_tmp60_ = (*_tmp59_).source;
								_tmp61_ = vala_source_reference_get_last_column (_tmp60_);
								_tmp62_ = _tmp61_;
								if (!(_tmp58_ < _tmp62_)) {
									break;
								}
								_tmp63_ = end_iter;
								ianjuta_iterable_next (_tmp63_, &_inner_error_);
								if (_inner_error_ != NULL) {
									_g_object_unref0 (end_iter);
									_g_object_unref0 (begin_iter);
									_anjuta_report_error_free0 (e);
									_vala_iterable_unref0 (_e_list);
									_g_object_unref0 (mark);
									_g_object_unref0 (ind);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						}
					}
					_tmp65_ = e;
					_tmp66_ = (*_tmp65_).error;
					if (_tmp66_) {
						_tmp64_ = IANJUTA_INDICABLE_CRITICAL;
					} else {
						_tmp64_ = IANJUTA_INDICABLE_WARNING;
					}
					_tmp67_ = ind;
					_tmp68_ = begin_iter;
					_tmp69_ = end_iter;
					_tmp70_ = _tmp64_;
					ianjuta_indicable_set (_tmp67_, _tmp68_, _tmp69_, _tmp70_, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (end_iter);
						_g_object_unref0 (begin_iter);
						_anjuta_report_error_free0 (e);
						_vala_iterable_unref0 (_e_list);
						_g_object_unref0 (mark);
						_g_object_unref0 (ind);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (end_iter);
					_g_object_unref0 (begin_iter);
				}
				_tmp71_ = editor;
				if (IANJUTA_IS_MARKABLE (_tmp71_)) {
					IAnjutaMarkable* _tmp72_;
					AnjutaReportError* _tmp73_;
					ValaSourceReference* _tmp74_;
					gint _tmp75_;
					gint _tmp76_;
					AnjutaReportError* _tmp77_;
					const gchar* _tmp78_;
					_tmp72_ = mark;
					_tmp73_ = e;
					_tmp74_ = (*_tmp73_).source;
					_tmp75_ = vala_source_reference_get_first_line (_tmp74_);
					_tmp76_ = _tmp75_;
					_tmp77_ = e;
					_tmp78_ = (*_tmp77_).message;
					ianjuta_markable_mark (_tmp72_, _tmp76_, IANJUTA_MARKABLE_MESSAGE, _tmp78_, &_inner_error_);
					if (_inner_error_ != NULL) {
						_anjuta_report_error_free0 (e);
						_vala_iterable_unref0 (_e_list);
						_g_object_unref0 (mark);
						_g_object_unref0 (ind);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			_anjuta_report_error_free0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_g_object_unref0 (mark);
	_g_object_unref0 (ind);
}


void anjuta_report_clear_error_indicators (AnjutaReport* self, ValaSourceFile* file) {
	ValaSourceFile* _tmp0_;
	IAnjutaDocumentManager* _tmp35_;
	GList* _tmp36_ = NULL;
	GList* _tmp37_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = file;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (ANJUTA_REPORT_TYPE_ERROR, (GBoxedCopyFunc) anjuta_report_error_dup, anjuta_report_error_free, _tmp1_);
		_vala_iterable_unref0 (self->priv->errors_list);
		self->priv->errors_list = (ValaList*) _tmp2_;
		((ValaReport*) self)->errors = 0;
	} else {
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp3_;
				_tmp3_ = TRUE;
				while (TRUE) {
					gboolean _tmp4_;
					gint _tmp6_;
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					ValaList* _tmp10_;
					gint _tmp11_;
					gpointer _tmp12_ = NULL;
					AnjutaReportError* _tmp13_;
					ValaSourceReference* _tmp14_;
					ValaSourceFile* _tmp15_;
					ValaSourceFile* _tmp16_;
					ValaSourceFile* _tmp17_;
					gboolean _tmp18_;
					_tmp4_ = _tmp3_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp6_ = i;
					_tmp7_ = self->priv->errors_list;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(_tmp6_ < _tmp9_)) {
						break;
					}
					_tmp10_ = self->priv->errors_list;
					_tmp11_ = i;
					_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
					_tmp13_ = (AnjutaReportError*) _tmp12_;
					_tmp14_ = (*_tmp13_).source;
					_tmp15_ = vala_source_reference_get_file (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = file;
					_tmp18_ = _tmp16_ == _tmp17_;
					_anjuta_report_error_free0 (_tmp13_);
					if (_tmp18_) {
						ValaList* _tmp19_;
						gint _tmp20_;
						gpointer _tmp21_ = NULL;
						AnjutaReportError* _tmp22_;
						gboolean _tmp23_;
						gboolean _tmp24_;
						ValaList* _tmp27_;
						gint _tmp28_;
						gint _tmp29_;
						_tmp19_ = self->priv->errors_list;
						_tmp20_ = i;
						_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
						_tmp22_ = (AnjutaReportError*) _tmp21_;
						_tmp23_ = (*_tmp22_).error;
						_tmp24_ = _tmp23_;
						_anjuta_report_error_free0 (_tmp22_);
						if (_tmp24_) {
							gint _tmp25_;
							_tmp25_ = ((ValaReport*) self)->errors;
							((ValaReport*) self)->errors = _tmp25_ - 1;
						} else {
							gint _tmp26_;
							_tmp26_ = ((ValaReport*) self)->warnings;
							((ValaReport*) self)->warnings = _tmp26_ - 1;
						}
						_tmp27_ = self->priv->errors_list;
						_tmp28_ = i;
						vala_list_remove_at (_tmp27_, _tmp28_);
						_tmp29_ = i;
						i = _tmp29_ - 1;
					}
				}
			}
		}
		_tmp30_ = self->priv->errors_list;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = ((ValaReport*) self)->errors;
		_tmp34_ = ((ValaReport*) self)->warnings;
		g_assert (_tmp32_ <= (_tmp33_ + _tmp34_));
	}
	_tmp35_ = self->priv->_docman;
	_tmp36_ = ianjuta_document_manager_get_doc_widgets (_tmp35_, &_inner_error_);
	_tmp37_ = _tmp36_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GList* doc_collection = NULL;
		GList* doc_it = NULL;
		doc_collection = _tmp37_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			GtkWidget* doc = NULL;
			doc = (GtkWidget*) doc_it->data;
			{
				GtkWidget* _tmp38_;
				GtkWidget* _tmp40_;
				_tmp38_ = doc;
				if (IANJUTA_IS_INDICABLE (_tmp38_)) {
					GtkWidget* _tmp39_;
					_tmp39_ = doc;
					ianjuta_indicable_clear (IANJUTA_INDICABLE (_tmp39_), &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_list_free0 (doc_collection);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp40_ = doc;
				if (IANJUTA_IS_MARKABLE (_tmp40_)) {
					GtkWidget* _tmp41_;
					_tmp41_ = doc;
					ianjuta_markable_delete_all_markers (IANJUTA_MARKABLE (_tmp41_), IANJUTA_MARKABLE_MESSAGE, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_list_free0 (doc_collection);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
		_g_list_free0 (doc_collection);
	}
}


static gpointer _vala_source_reference_ref0 (gpointer self) {
	return self ? vala_source_reference_ref (self) : NULL;
}


static void anjuta_report_real_warn (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	AnjutaReport * self;
	gint _tmp0_;
	ValaSourceReference* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (AnjutaReport*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = ((ValaReport*) self)->warnings;
	((ValaReport*) self)->warnings = _tmp0_ + 1;
	_tmp1_ = source;
	if (_tmp1_ == NULL) {
		return;
	}
	{
		ValaList* _tmp2_;
		_tmp2_ = self->priv->errors_list;
		g_static_rec_mutex_lock (&self->priv->__lock_errors_list);
		{
			ValaList* _tmp3_;
			ValaSourceReference* _tmp4_;
			ValaSourceReference* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			AnjutaReportError _tmp8_ = {0};
			AnjutaReportError _tmp9_;
			AnjutaReportError _tmp10_;
			_tmp3_ = self->priv->errors_list;
			_tmp4_ = source;
			_tmp5_ = _vala_source_reference_ref0 (_tmp4_);
			_tmp6_ = message;
			_tmp7_ = g_strdup (_tmp6_);
			memset (&_tmp8_, 0, sizeof (AnjutaReportError));
			_vala_source_reference_unref0 (_tmp8_.source);
			_tmp8_.source = _tmp5_;
			_g_free0 (_tmp8_.message);
			_tmp8_.message = _tmp7_;
			_tmp8_.error = FALSE;
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_;
			vala_collection_add ((ValaCollection*) _tmp3_, &_tmp10_);
			anjuta_report_error_destroy (&_tmp9_);
		}
		__finally10:
		{
			ValaList* _tmp11_;
			_tmp11_ = self->priv->errors_list;
			g_static_rec_mutex_unlock (&self->priv->__lock_errors_list);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void anjuta_report_real_err (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	AnjutaReport * self;
	gint _tmp0_;
	ValaSourceReference* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (AnjutaReport*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = ((ValaReport*) self)->errors;
	((ValaReport*) self)->errors = _tmp0_ + 1;
	_tmp1_ = source;
	if (_tmp1_ == NULL) {
		self->priv->general_error = TRUE;
		return;
	}
	{
		ValaList* _tmp2_;
		_tmp2_ = self->priv->errors_list;
		g_static_rec_mutex_lock (&self->priv->__lock_errors_list);
		{
			ValaList* _tmp3_;
			ValaSourceReference* _tmp4_;
			ValaSourceReference* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			AnjutaReportError _tmp8_ = {0};
			AnjutaReportError _tmp9_;
			AnjutaReportError _tmp10_;
			_tmp3_ = self->priv->errors_list;
			_tmp4_ = source;
			_tmp5_ = _vala_source_reference_ref0 (_tmp4_);
			_tmp6_ = message;
			_tmp7_ = g_strdup (_tmp6_);
			memset (&_tmp8_, 0, sizeof (AnjutaReportError));
			_vala_source_reference_unref0 (_tmp8_.source);
			_tmp8_.source = _tmp5_;
			_g_free0 (_tmp8_.message);
			_tmp8_.message = _tmp7_;
			_tmp8_.error = TRUE;
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_;
			vala_collection_add ((ValaCollection*) _tmp3_, &_tmp10_);
			anjuta_report_error_destroy (&_tmp9_);
		}
		__finally11:
		{
			ValaList* _tmp11_;
			_tmp11_ = self->priv->errors_list;
			g_static_rec_mutex_unlock (&self->priv->__lock_errors_list);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


AnjutaReport* anjuta_report_construct (GType object_type) {
	AnjutaReport * self = NULL;
	self = (AnjutaReport*) vala_report_construct (object_type);
	return self;
}


AnjutaReport* anjuta_report_new (void) {
	return anjuta_report_construct (TYPE_ANJUTA_REPORT);
}


IAnjutaDocumentManager* anjuta_report_get_docman (AnjutaReport* self) {
	IAnjutaDocumentManager* result;
	IAnjutaDocumentManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_docman;
	result = _tmp0_;
	return result;
}


void anjuta_report_set_docman (AnjutaReport* self, IAnjutaDocumentManager* value) {
	IAnjutaDocumentManager* _tmp0_;
	IAnjutaDocumentManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_docman);
	self->priv->_docman = _tmp1_;
	g_object_notify ((GObject *) self, "docman");
}


static void anjuta_report_error_copy (const AnjutaReportError* self, AnjutaReportError* dest) {
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	_tmp0_ = (*self).source;
	_tmp1_ = _vala_source_reference_ref0 (_tmp0_);
	_vala_source_reference_unref0 ((*dest).source);
	(*dest).source = _tmp1_;
	_tmp2_ = (*self).error;
	(*dest).error = _tmp2_;
	_tmp3_ = (*self).message;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).message);
	(*dest).message = _tmp4_;
}


static void anjuta_report_error_destroy (AnjutaReportError* self) {
	_vala_source_reference_unref0 ((*self).source);
	_g_free0 ((*self).message);
}


static AnjutaReportError* anjuta_report_error_dup (const AnjutaReportError* self) {
	AnjutaReportError* dup;
	dup = g_new0 (AnjutaReportError, 1);
	anjuta_report_error_copy (self, dup);
	return dup;
}


static void anjuta_report_error_free (AnjutaReportError* self) {
	anjuta_report_error_destroy (self);
	g_free (self);
}


static GType anjuta_report_error_get_type (void) {
	static volatile gsize anjuta_report_error_type_id__volatile = 0;
	if (g_once_init_enter (&anjuta_report_error_type_id__volatile)) {
		GType anjuta_report_error_type_id;
		anjuta_report_error_type_id = g_boxed_type_register_static ("AnjutaReportError", (GBoxedCopyFunc) anjuta_report_error_dup, (GBoxedFreeFunc) anjuta_report_error_free);
		g_once_init_leave (&anjuta_report_error_type_id__volatile, anjuta_report_error_type_id);
	}
	return anjuta_report_error_type_id__volatile;
}


static void anjuta_report_class_init (AnjutaReportClass * klass) {
	anjuta_report_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AnjutaReportPrivate));
	VALA_REPORT_CLASS (klass)->warn = anjuta_report_real_warn;
	VALA_REPORT_CLASS (klass)->err = anjuta_report_real_err;
	G_OBJECT_CLASS (klass)->get_property = _vala_anjuta_report_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_anjuta_report_set_property;
	G_OBJECT_CLASS (klass)->finalize = anjuta_report_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANJUTA_REPORT_DOCMAN, g_param_spec_object ("docman", "docman", "docman", ianjuta_document_manager_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void anjuta_report_instance_init (AnjutaReport * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = ANJUTA_REPORT_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_errors_list);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (ANJUTA_REPORT_TYPE_ERROR, (GBoxedCopyFunc) anjuta_report_error_dup, anjuta_report_error_free, _tmp0_);
	self->priv->errors_list = (ValaList*) _tmp1_;
	self->priv->general_error = FALSE;
}


static void anjuta_report_finalize (GObject* obj) {
	AnjutaReport * self;
	self = ANJUTA_REPORT (obj);
	_g_object_unref0 (self->priv->_docman);
	g_static_rec_mutex_free (&self->priv->__lock_errors_list);
	_vala_iterable_unref0 (self->priv->errors_list);
	G_OBJECT_CLASS (anjuta_report_parent_class)->finalize (obj);
}


GType anjuta_report_get_type (void) {
	return anjuta_report_type_id;
}


GType anjuta_report_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (AnjutaReportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) anjuta_report_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AnjutaReport), 0, (GInstanceInitFunc) anjuta_report_instance_init, NULL };
	anjuta_report_type_id = g_type_module_register_type (module, VALA_TYPE_REPORT, "AnjutaReport", &g_define_type_info, 0);
	return anjuta_report_type_id;
}


static void _vala_anjuta_report_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AnjutaReport * self;
	self = ANJUTA_REPORT (object);
	switch (property_id) {
		case ANJUTA_REPORT_DOCMAN:
		g_value_set_object (value, anjuta_report_get_docman (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_anjuta_report_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AnjutaReport * self;
	self = ANJUTA_REPORT (object);
	switch (property_id) {
		case ANJUTA_REPORT_DOCMAN:
		anjuta_report_set_docman (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



