/* vinagre-utils.c generated by valac 0.14.0, the Vala compiler
 * generated from vinagre-utils.vala, do not modify */

/*  Vinagre - GNOME Remote Desktop viewer
 *
 *  Copyright (C) 2011  David King <amigadave@amigadave.com>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <config.h>
#include <gdk/gdk.h>

typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _Block1Data {
	int _ref_count_;
	GtkMessageDialog* dialog;
};

struct _Block2Data {
	int _ref_count_;
	gchar* messages;
};

struct _Block3Data {
	int _ref_count_;
	GtkButton* ok_button;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
};



gboolean vinagre_utils_parse_boolean (const gchar* str);
void vinagre_utils_set_widget_visible (GtkWidget* widget, gboolean visible);
void vinagre_utils_show_error_dialog (const gchar* title, const gchar* message, GtkWindow* parent);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void __lambda0_ (Block1Data* _data1_, GtkDialog* d, gint response);
static void ___lambda0__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void vinagre_utils_show_many_errors (const gchar* title, GSList* items, GtkWindow* parent);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void __lambda1_ (Block2Data* _data2_, const gchar* message);
static void ___lambda1__gfunc (gconstpointer data, gpointer self);
gboolean vinagre_utils_create_dir_for_file (const gchar* filename, GError** error);
GtkBuilder* vinagre_utils_get_builder (void);
gchar* vinagre_dirs_get_package_data_file (const gchar* filename);
gboolean vinagre_utils_request_credential (GtkWindow* parent, const gchar* protocol, const gchar* host, gboolean need_username, gboolean need_password, gint password_limit, gchar** username, gchar** password, gboolean* save_in_keyring);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void __lambda2_ (Block3Data* _data3_);
static void ___lambda2__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void __lambda3_ (Block3Data* _data3_);
static void ___lambda3__gtk_editable_changed (GtkEditable* _sender, gpointer self);
void vinagre_utils_show_help (GtkWindow* window, const gchar* page);
void vinagre_utils_show_help_about (GtkWindow* parent);


gboolean vinagre_utils_parse_boolean (const gchar* str) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = str;
	if (g_strcmp0 (_tmp1_, "true") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = str;
		_tmp0_ = g_strcmp0 (_tmp2_, "1") == 0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


void vinagre_utils_set_widget_visible (GtkWidget* widget, gboolean visible) {
	gboolean _tmp0_;
	g_return_if_fail (widget != NULL);
	_tmp0_ = visible;
	if (_tmp0_) {
		GtkWidget* _tmp1_;
		_tmp1_ = widget;
		gtk_widget_show_all (_tmp1_);
	} else {
		GtkWidget* _tmp2_;
		_tmp2_ = widget;
		gtk_widget_hide (_tmp2_);
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->dialog);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda0_ (Block1Data* _data1_, GtkDialog* d, gint response) {
	GtkMessageDialog* _tmp0_;
	g_return_if_fail (d != NULL);
	_tmp0_ = _data1_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void ___lambda0__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda0_ (self, _sender, response_id);
}


void vinagre_utils_show_error_dialog (const gchar* title, const gchar* message, GtkWindow* parent) {
	Block1Data* _data1_;
	const gchar* _tmp0_;
	GtkWindow* _tmp2_;
	const gchar* _tmp3_;
	GtkMessageDialog* _tmp4_;
	GtkMessageDialog* _tmp5_;
	const gchar* _tmp6_;
	GtkMessageDialog* _tmp9_;
	GtkMessageDialog* _tmp10_;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = title;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("An error occurred");
		title = _tmp1_;
	}
	_tmp2_ = parent;
	_tmp3_ = title;
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp2_, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp3_);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_data1_->dialog = _tmp5_;
	_tmp6_ = message;
	if (_tmp6_ != NULL) {
		GtkMessageDialog* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = _data1_->dialog;
		_tmp8_ = message;
		gtk_message_dialog_format_secondary_markup (_tmp7_, "%s", _tmp8_);
	}
	_tmp9_ = _data1_->dialog;
	g_signal_connect_data ((GtkDialog*) _tmp9_, "response", (GCallback) ___lambda0__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp10_ = _data1_->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp10_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_free0 (_data2_->messages);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda1_ (Block2Data* _data2_, const gchar* message) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	_tmp1_ = g_strdup_printf (_data2_->messages, "%s\n", _tmp0_);
	_tmp2_ = _tmp1_;
	_g_free0 (_tmp2_);
}


static void ___lambda1__gfunc (gconstpointer data, gpointer self) {
	__lambda1_ (self, data);
}


void vinagre_utils_show_many_errors (const gchar* title, GSList* items, GtkWindow* parent) {
	Block2Data* _data2_;
	gchar* _tmp0_;
	GSList* _tmp1_;
	const gchar* _tmp2_;
	GtkWindow* _tmp3_;
	g_return_if_fail (parent != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = g_strdup ("");
	_data2_->messages = _tmp0_;
	_tmp1_ = items;
	g_slist_foreach (_tmp1_, ___lambda1__gfunc, _data2_);
	_tmp2_ = title;
	_tmp3_ = parent;
	vinagre_utils_show_error_dialog (_tmp2_, _data2_->messages, _tmp3_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


gboolean vinagre_utils_create_dir_for_file (const gchar* filename, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFile* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* parent;
	GFile* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* parent_path;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = filename;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_get_parent (_tmp2_);
	parent = _tmp3_;
	_tmp4_ = parent;
	_tmp5_ = g_file_get_path (_tmp4_);
	parent_path = _tmp5_;
	_tmp6_ = parent_path;
	_tmp7_ = g_file_test (_tmp6_, G_FILE_TEST_EXISTS);
	if (!_tmp7_) {
		GFile* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_;
		_tmp8_ = parent;
		_tmp9_ = g_file_make_directory_with_parents (_tmp8_, NULL, &_inner_error_);
		_tmp10_ = _tmp9_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (parent_path);
			_g_object_unref0 (parent);
			_g_object_unref0 (file);
			return FALSE;
		}
		result = _tmp10_;
		_g_free0 (parent_path);
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
		return result;
	} else {
		result = TRUE;
		_g_free0 (parent_path);
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
		return result;
	}
	_g_free0 (parent_path);
	_g_object_unref0 (parent);
	_g_object_unref0 (file);
}


GtkBuilder* vinagre_utils_get_builder (void) {
	GtkBuilder* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* filename;
	GtkBuilder* _tmp1_;
	GtkBuilder* builder;
	GError * _inner_error_ = NULL;
	_tmp0_ = vinagre_dirs_get_package_data_file ("vinagre.ui");
	filename = _tmp0_;
	_tmp1_ = gtk_builder_new ();
	builder = _tmp1_;
	{
		gtk_builder_add_from_file (builder, filename, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* subtitle;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* closing;
		const gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* message;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Vinagre failed to open a UI file, with the error message:");
		_tmp3_ = g_strdup (_tmp2_);
		subtitle = _tmp3_;
		_tmp4_ = _ ("Please check your installation.");
		_tmp5_ = g_strdup (_tmp4_);
		closing = _tmp5_;
		_tmp6_ = subtitle;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = closing;
		_tmp10_ = g_strdup_printf ("%s\n\n%s\n\n%s", _tmp6_, _tmp8_, _tmp9_);
		message = _tmp10_;
		_tmp11_ = _ ("Error loading UI file");
		_tmp12_ = message;
		vinagre_utils_show_error_dialog (_tmp11_, _tmp12_, NULL);
		_g_free0 (message);
		_g_free0 (closing);
		_g_free0 (subtitle);
		_g_error_free0 (err);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = builder;
	_g_free0 (filename);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->password_entry);
		_g_object_unref0 (_data3_->username_entry);
		_g_object_unref0 (_data3_->ok_button);
		g_slice_free (Block3Data, _data3_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda2_ (Block3Data* _data3_) {
	gboolean enabled;
	GtkEntry* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkEntry* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GtkButton* _tmp18_;
	gboolean _tmp19_;
	enabled = TRUE;
	_tmp0_ = _data3_->username_entry;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		gboolean _tmp8_;
		_tmp4_ = enabled;
		if (_tmp4_) {
			GtkEntry* _tmp5_;
			guint _tmp6_;
			guint _tmp7_;
			_tmp5_ = _data3_->username_entry;
			_tmp6_ = gtk_entry_get_text_length (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp3_ = _tmp7_ > ((guint) 0);
		} else {
			_tmp3_ = FALSE;
		}
		_tmp8_ = _tmp3_;
		enabled = _tmp8_;
	}
	_tmp9_ = _data3_->password_entry;
	_tmp10_ = gtk_widget_get_visible ((GtkWidget*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		gboolean _tmp17_;
		_tmp13_ = enabled;
		if (_tmp13_) {
			GtkEntry* _tmp14_;
			guint _tmp15_;
			guint _tmp16_;
			_tmp14_ = _data3_->password_entry;
			_tmp15_ = gtk_entry_get_text_length (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ > ((guint) 0);
		} else {
			_tmp12_ = FALSE;
		}
		_tmp17_ = _tmp12_;
		enabled = _tmp17_;
	}
	_tmp18_ = _data3_->ok_button;
	_tmp19_ = enabled;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp18_, _tmp19_);
}


static void ___lambda2__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda2_ (self);
}


static void __lambda3_ (Block3Data* _data3_) {
	gboolean enabled;
	GtkEntry* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkEntry* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GtkButton* _tmp18_;
	gboolean _tmp19_;
	enabled = TRUE;
	_tmp0_ = _data3_->username_entry;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		gboolean _tmp8_;
		_tmp4_ = enabled;
		if (_tmp4_) {
			GtkEntry* _tmp5_;
			guint _tmp6_;
			guint _tmp7_;
			_tmp5_ = _data3_->username_entry;
			_tmp6_ = gtk_entry_get_text_length (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp3_ = _tmp7_ > ((guint) 0);
		} else {
			_tmp3_ = FALSE;
		}
		_tmp8_ = _tmp3_;
		enabled = _tmp8_;
	}
	_tmp9_ = _data3_->password_entry;
	_tmp10_ = gtk_widget_get_visible ((GtkWidget*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		gboolean _tmp17_;
		_tmp13_ = enabled;
		if (_tmp13_) {
			GtkEntry* _tmp14_;
			guint _tmp15_;
			guint _tmp16_;
			_tmp14_ = _data3_->password_entry;
			_tmp15_ = gtk_entry_get_text_length (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ > ((guint) 0);
		} else {
			_tmp12_ = FALSE;
		}
		_tmp17_ = _tmp12_;
		enabled = _tmp17_;
	}
	_tmp18_ = _data3_->ok_button;
	_tmp19_ = enabled;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp18_, _tmp19_);
}


static void ___lambda3__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda3_ (self);
}


gboolean vinagre_utils_request_credential (GtkWindow* parent, const gchar* protocol, const gchar* host, gboolean need_username, gboolean need_password, gint password_limit, gchar** username, gchar** password, gboolean* save_in_keyring) {
	gchar* _vala_username = NULL;
	gchar* _vala_password = NULL;
	gboolean _vala_save_in_keyring = FALSE;
	gboolean result = FALSE;
	Block3Data* _data3_;
	GtkBuilder* _tmp0_ = NULL;
	GtkBuilder* xml;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_ = NULL;
	GtkDialog* _tmp3_;
	GtkDialog* password_dialog;
	GtkDialog* _tmp4_;
	GtkWindow* _tmp5_;
	GtkBuilder* _tmp6_;
	GObject* _tmp7_ = NULL;
	GtkLabel* _tmp8_;
	GtkLabel* auth_label;
	GtkLabel* _tmp9_;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	GtkBuilder* _tmp14_;
	GObject* _tmp15_ = NULL;
	GtkLabel* _tmp16_;
	GtkLabel* host_label;
	GtkLabel* _tmp17_;
	const gchar* _tmp18_;
	GtkBuilder* _tmp19_;
	GObject* _tmp20_ = NULL;
	GtkLabel* _tmp21_;
	GtkLabel* password_label;
	GtkBuilder* _tmp22_;
	GObject* _tmp23_ = NULL;
	GtkLabel* _tmp24_;
	GtkLabel* username_label;
	GtkBuilder* _tmp25_;
	GObject* _tmp26_ = NULL;
	GtkCheckButton* _tmp27_;
	GtkCheckButton* save_credential_check;
	GtkBuilder* _tmp28_;
	GObject* _tmp29_ = NULL;
	GtkButton* _tmp30_;
	GtkImage* _tmp31_;
	GtkImage* _tmp32_;
	GtkImage* image;
	GtkButton* _tmp33_;
	GtkImage* _tmp34_;
	GtkBuilder* _tmp35_;
	GObject* _tmp36_ = NULL;
	GtkEntry* _tmp37_;
	GtkBuilder* _tmp38_;
	GObject* _tmp39_ = NULL;
	GtkEntry* _tmp40_;
	GtkEntry* _tmp41_;
	gboolean _tmp42_;
	GtkEntry* _tmp45_;
	gboolean _tmp46_;
	GtkDialog* _tmp51_;
	gint _tmp52_ = 0;
	gint _result_;
	gint _tmp53_;
	GtkDialog* _tmp72_;
	gint _tmp73_;
	g_return_val_if_fail (parent != NULL, FALSE);
	g_return_val_if_fail (protocol != NULL, FALSE);
	g_return_val_if_fail (host != NULL, FALSE);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = vinagre_utils_get_builder ();
	xml = _tmp0_;
	_tmp1_ = xml;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "auth_required_dialog");
	_tmp3_ = _g_object_ref0 (GTK_IS_DIALOG (_tmp2_) ? ((GtkDialog*) _tmp2_) : NULL);
	password_dialog = _tmp3_;
	_tmp4_ = password_dialog;
	_tmp5_ = parent;
	gtk_window_set_transient_for ((GtkWindow*) _tmp4_, _tmp5_);
	_tmp6_ = xml;
	_tmp7_ = gtk_builder_get_object (_tmp6_, "auth_required_label");
	_tmp8_ = _g_object_ref0 (GTK_IS_LABEL (_tmp7_) ? ((GtkLabel*) _tmp7_) : NULL);
	auth_label = _tmp8_;
	_tmp9_ = auth_label;
	_tmp10_ = _ ("%s authentication is required");
	_tmp11_ = protocol;
	_tmp12_ = g_strdup_printf (_tmp10_, _tmp11_);
	_tmp13_ = _tmp12_;
	gtk_label_set_label (_tmp9_, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = xml;
	_tmp15_ = gtk_builder_get_object (_tmp14_, "host_label");
	_tmp16_ = _g_object_ref0 (GTK_IS_LABEL (_tmp15_) ? ((GtkLabel*) _tmp15_) : NULL);
	host_label = _tmp16_;
	_tmp17_ = host_label;
	_tmp18_ = host;
	gtk_label_set_label (_tmp17_, _tmp18_);
	_tmp19_ = xml;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "password_label");
	_tmp21_ = _g_object_ref0 (GTK_IS_LABEL (_tmp20_) ? ((GtkLabel*) _tmp20_) : NULL);
	password_label = _tmp21_;
	_tmp22_ = xml;
	_tmp23_ = gtk_builder_get_object (_tmp22_, "username_label");
	_tmp24_ = _g_object_ref0 (GTK_IS_LABEL (_tmp23_) ? ((GtkLabel*) _tmp23_) : NULL);
	username_label = _tmp24_;
	_tmp25_ = xml;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "save_credential_check");
	_tmp27_ = _g_object_ref0 (GTK_IS_CHECK_BUTTON (_tmp26_) ? ((GtkCheckButton*) _tmp26_) : NULL);
	save_credential_check = _tmp27_;
	_tmp28_ = xml;
	_tmp29_ = gtk_builder_get_object (_tmp28_, "ok_button");
	_tmp30_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp29_) ? ((GtkButton*) _tmp29_) : NULL);
	_data3_->ok_button = _tmp30_;
	_tmp31_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_DIALOG_AUTHENTICATION, GTK_ICON_SIZE_BUTTON);
	_tmp32_ = g_object_ref_sink (_tmp31_);
	image = _tmp32_;
	_tmp33_ = _data3_->ok_button;
	_tmp34_ = image;
	gtk_button_set_image (_tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = xml;
	_tmp36_ = gtk_builder_get_object (_tmp35_, "username_entry");
	_tmp37_ = _g_object_ref0 (GTK_IS_ENTRY (_tmp36_) ? ((GtkEntry*) _tmp36_) : NULL);
	_data3_->username_entry = _tmp37_;
	_tmp38_ = xml;
	_tmp39_ = gtk_builder_get_object (_tmp38_, "password_entry");
	_tmp40_ = _g_object_ref0 (GTK_IS_ENTRY (_tmp39_) ? ((GtkEntry*) _tmp39_) : NULL);
	_data3_->password_entry = _tmp40_;
	_tmp41_ = _data3_->username_entry;
	g_signal_connect_data ((GtkEditable*) _tmp41_, "changed", (GCallback) ___lambda2__gtk_editable_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp42_ = need_username;
	if (!_tmp42_) {
		GtkLabel* _tmp43_;
		GtkEntry* _tmp44_;
		_tmp43_ = username_label;
		gtk_widget_hide ((GtkWidget*) _tmp43_);
		_tmp44_ = _data3_->username_entry;
		gtk_widget_hide ((GtkWidget*) _tmp44_);
	}
	_tmp45_ = _data3_->password_entry;
	g_signal_connect_data ((GtkEditable*) _tmp45_, "changed", (GCallback) ___lambda3__gtk_editable_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp46_ = need_password;
	if (_tmp46_) {
		GtkEntry* _tmp47_;
		gint _tmp48_;
		_tmp47_ = _data3_->password_entry;
		_tmp48_ = password_limit;
		gtk_entry_set_max_length (_tmp47_, _tmp48_);
	} else {
		GtkLabel* _tmp49_;
		GtkEntry* _tmp50_;
		_tmp49_ = password_label;
		gtk_widget_hide ((GtkWidget*) _tmp49_);
		_tmp50_ = _data3_->password_entry;
		gtk_widget_hide ((GtkWidget*) _tmp50_);
	}
	_tmp51_ = password_dialog;
	_tmp52_ = gtk_dialog_run (_tmp51_);
	_result_ = _tmp52_;
	_tmp53_ = _result_;
	if (_tmp53_ == ((gint) GTK_RESPONSE_OK)) {
		GtkEntry* _tmp54_;
		guint _tmp55_;
		guint _tmp56_;
		GtkEntry* _tmp61_;
		guint _tmp62_;
		guint _tmp63_;
		gboolean _tmp68_;
		_tmp54_ = _data3_->username_entry;
		_tmp55_ = gtk_entry_get_text_length (_tmp54_);
		_tmp56_ = _tmp55_;
		if (_tmp56_ > ((guint) 0)) {
			GtkEntry* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			_tmp57_ = _data3_->username_entry;
			_tmp58_ = gtk_entry_get_text (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = g_strdup (_tmp59_);
			_g_free0 (_vala_username);
			_vala_username = _tmp60_;
		}
		_tmp61_ = _data3_->password_entry;
		_tmp62_ = gtk_entry_get_text_length (_tmp61_);
		_tmp63_ = _tmp62_;
		if (_tmp63_ > ((guint) 0)) {
			GtkEntry* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			_tmp64_ = _data3_->password_entry;
			_tmp65_ = gtk_entry_get_text (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strdup (_tmp66_);
			_g_free0 (_vala_password);
			_vala_password = _tmp67_;
		}
		_tmp68_ = _vala_save_in_keyring;
		if (_tmp68_) {
			GtkCheckButton* _tmp69_;
			gboolean _tmp70_;
			gboolean _tmp71_;
			_tmp69_ = save_credential_check;
			_tmp70_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp69_);
			_tmp71_ = _tmp70_;
			_vala_save_in_keyring = _tmp71_;
		}
	}
	_tmp72_ = password_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp72_);
	_tmp73_ = _result_;
	result = _tmp73_ == ((gint) GTK_RESPONSE_OK);
	_g_object_unref0 (image);
	_g_object_unref0 (save_credential_check);
	_g_object_unref0 (username_label);
	_g_object_unref0 (password_label);
	_g_object_unref0 (host_label);
	_g_object_unref0 (auth_label);
	_g_object_unref0 (password_dialog);
	_g_object_unref0 (xml);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	if (username) {
		*username = _vala_username;
	} else {
		_g_free0 (_vala_username);
	}
	if (password) {
		*password = _vala_password;
	} else {
		_g_free0 (_vala_password);
	}
	if (save_in_keyring) {
		*save_in_keyring = _vala_save_in_keyring;
	}
	return result;
}


void vinagre_utils_show_help (GtkWindow* window, const gchar* page) {
	gchar* uri = NULL;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (window != NULL);
	_tmp0_ = page;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = page;
		_tmp2_ = g_strconcat ("help:" PACKAGE_TARNAME "?", _tmp1_, NULL);
		_g_free0 (uri);
		uri = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("help:" PACKAGE_TARNAME);
		_g_free0 (uri);
		uri = _tmp3_;
	}
	{
		GtkWindow* _tmp4_;
		GdkScreen* _tmp5_ = NULL;
		const gchar* _tmp6_;
		_tmp4_ = window;
		_tmp5_ = gtk_window_get_screen (_tmp4_);
		_tmp6_ = uri;
		gtk_show_uri (_tmp5_, _tmp6_, (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GtkWindow* _tmp10_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = _ ("Error showing help");
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = window;
		vinagre_utils_show_error_dialog (_tmp7_, _tmp9_, _tmp10_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (uri);
}


void vinagre_utils_show_help_about (GtkWindow* parent) {
	GtkBuilder* _tmp0_ = NULL;
	GtkBuilder* builder;
	GObject* _tmp1_ = NULL;
	GtkAboutDialog* _tmp2_;
	GtkAboutDialog* dialog;
	GtkWindow* _tmp3_;
	g_return_if_fail (parent != NULL);
	_tmp0_ = vinagre_utils_get_builder ();
	builder = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "about_dialog");
	_tmp2_ = _g_object_ref0 (GTK_IS_ABOUT_DIALOG (_tmp1_) ? ((GtkAboutDialog*) _tmp1_) : NULL);
	dialog = _tmp2_;
	gtk_about_dialog_set_logo_icon_name (dialog, "preferences-desktop-remote-desktop");
	gtk_about_dialog_set_version (dialog, PACKAGE_VERSION);
	gtk_about_dialog_set_website (dialog, PACKAGE_URL);
	_tmp3_ = parent;
	gtk_window_set_transient_for ((GtkWindow*) dialog, _tmp3_);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_hide ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_object_unref0 (builder);
}



