/* cheese-shareable-media.c generated by valac 0.14.0, the Vala compiler
 * generated from cheese-shareable-media.vala, do not modify */

/*
 * Copyright © 2011 Patricia Santana Cruz <patriciasantanacruz@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <sys/wait.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <gdk/gdkx.h>


#define CHEESE_TYPE_SHAREABLE_MEDIA (cheese_shareable_media_get_type ())
#define CHEESE_SHAREABLE_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_SHAREABLE_MEDIA, CheeseShareableMedia))
#define CHEESE_SHAREABLE_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_SHAREABLE_MEDIA, CheeseShareableMediaClass))
#define CHEESE_IS_SHAREABLE_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_SHAREABLE_MEDIA))
#define CHEESE_IS_SHAREABLE_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_SHAREABLE_MEDIA))
#define CHEESE_SHAREABLE_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_SHAREABLE_MEDIA, CheeseShareableMediaClass))

typedef struct _CheeseShareableMedia CheeseShareableMedia;
typedef struct _CheeseShareableMediaClass CheeseShareableMediaClass;
typedef struct _CheeseShareableMediaPrivate CheeseShareableMediaPrivate;

#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CheeseShareableMedia {
	GObject parent_instance;
	CheeseShareableMediaPrivate * priv;
};

struct _CheeseShareableMediaClass {
	GObjectClass parent_class;
};

struct _CheeseShareableMediaPrivate {
	guint num_children;
	CheeseMainWindow* window;
};

struct _Block3Data {
	int _ref_count_;
	CheeseShareableMedia * self;
	gchar** argv;
	gint argv_length1;
	gint _argv_size_;
};


static gpointer cheese_shareable_media_parent_class = NULL;

GType cheese_shareable_media_get_type (void) G_GNUC_CONST;
GType cheese_main_window_get_type (void) G_GNUC_CONST;
#define CHEESE_SHAREABLE_MEDIA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_SHAREABLE_MEDIA, CheeseShareableMediaPrivate))
enum  {
	CHEESE_SHAREABLE_MEDIA_DUMMY_PROPERTY
};
#define CHEESE_SHAREABLE_MEDIA_XID "--xid="
CheeseShareableMedia* cheese_shareable_media_new (CheeseMainWindow* main_window);
CheeseShareableMedia* cheese_shareable_media_construct (GType object_type, CheeseMainWindow* main_window);
static void cheese_shareable_media_child_finished (CheeseShareableMedia* self, GPid pid, gint status);
void cheese_shareable_media_share_files (CheeseShareableMedia* self, GList* files);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
#define SENDTO_EXEC "nautilus-sendto"
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void __lambda2_ (Block3Data* _data3_, GFile* file);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void ___lambda2__gfunc (gconstpointer data, gpointer self);
static void _cheese_shareable_media_child_finished_gchild_watch_func (GPid pid, gint status, gpointer self);
static void cheese_shareable_media_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
     * Create a new ShareableMedia instance.
     *
     * @param main_window the main window of the Cheese application
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CheeseShareableMedia* cheese_shareable_media_construct (GType object_type, CheeseMainWindow* main_window) {
	CheeseShareableMedia * self = NULL;
	CheeseMainWindow* _tmp0_;
	CheeseMainWindow* _tmp1_;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (CheeseShareableMedia*) g_object_new (object_type, NULL);
	_tmp0_ = main_window;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp1_;
	return self;
}


CheeseShareableMedia* cheese_shareable_media_new (CheeseMainWindow* main_window) {
	return cheese_shareable_media_construct (CHEESE_TYPE_SHAREABLE_MEDIA, main_window);
}


/**
     * Callback to be called when the child exits.
     *
     * Cleans up the child process spawned by {@link ShareableMedia.share_files}
     * and if that child is the last one, it will also set the cursor
     * back to normal.
     *
     * @param pid the process id of the child process
     * @param status the status information about the child process
     *
     * @see ShareableMedia.share_files
     */
static void cheese_shareable_media_child_finished (CheeseShareableMedia* self, GPid pid, gint status) {
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	GPid _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = status;
	_tmp1_ = WIFEXITED (_tmp0_);
	if (!_tmp1_) {
		g_warning ("cheese-shareable-media.vala:58: nautilus-sendto exited abnormally");
	}
	_tmp2_ = pid;
	g_spawn_close_pid (_tmp2_);
	_tmp3_ = self->priv->num_children;
	self->priv->num_children = _tmp3_ - 1;
	_tmp4_ = self->priv->num_children;
	if (_tmp4_ == ((guint) 0)) {
		CheeseMainWindow* _tmp5_;
		GdkWindow* _tmp6_ = NULL;
		GdkCursor* _tmp7_;
		GdkCursor* _tmp8_;
		_tmp5_ = self->priv->window;
		_tmp6_ = gtk_widget_get_window ((GtkWidget*) _tmp5_);
		_tmp7_ = gdk_cursor_new (GDK_LEFT_PTR);
		_tmp8_ = _tmp7_;
		gdk_window_set_cursor (_tmp6_, _tmp8_);
		_g_object_unref0 (_tmp8_);
	}
}


/**
     * Used for sharing one or more images and/or one or more videos through
     * different technologies.
     *
     * It works asynchronously and will create a new child every time it is
     * called. When the child exists, the {@link ShareableMedia.child_finished}
     * callback is called.
     *
     * It will also set the cursor to busy to indicate to the user that
     * there is some task that is being done.
     *
     * @param files a list of the files (videos and/or images that are going to
     * be shared.
     *
     * @see ShareableMedia.child_finished.
     */
static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_data3_->argv = (_vala_array_free (_data3_->argv, _data3_->argv_length1, (GDestroyNotify) g_free), NULL);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void __lambda2_ (Block3Data* _data3_, GFile* file) {
	CheeseShareableMedia * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	GFile* _tmp1_;
	gchar* _tmp2_ = NULL;
	self = _data3_->self;
	g_return_if_fail (file != NULL);
	_tmp0_ = _data3_->argv;
	_tmp0__length1 = _data3_->argv_length1;
	_tmp1_ = file;
	_tmp2_ = g_file_get_path (_tmp1_);
	_vala_array_add3 (&_data3_->argv, &_data3_->argv_length1, &_data3_->_argv_size_, _tmp2_);
}


static void ___lambda2__gfunc (gconstpointer data, gpointer self) {
	__lambda2_ (self, data);
}


static void _cheese_shareable_media_child_finished_gchild_watch_func (GPid pid, gint status, gpointer self) {
	cheese_shareable_media_child_finished (self, pid, status);
}


void cheese_shareable_media_share_files (CheeseShareableMedia* self, GList* files) {
	Block3Data* _data3_;
	gchar** _tmp0_ = NULL;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	CheeseMainWindow* _tmp4_;
	GdkWindow* _tmp5_ = NULL;
	Window _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GList* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data3_->argv = _tmp0_;
	_data3_->argv_length1 = 0;
	_data3_->_argv_size_ = _data3_->argv_length1;
	_tmp1_ = _data3_->argv;
	_tmp1__length1 = _data3_->argv_length1;
	_tmp2_ = g_strdup (SENDTO_EXEC);
	_vala_array_add1 (&_data3_->argv, &_data3_->argv_length1, &_data3_->_argv_size_, _tmp2_);
	_tmp3_ = _data3_->argv;
	_tmp3__length1 = _data3_->argv_length1;
	_tmp4_ = self->priv->window;
	_tmp5_ = gtk_widget_get_window ((GtkWidget*) _tmp4_);
	_tmp6_ = gdk_x11_window_get_xid (_tmp5_);
	_tmp7_ = g_strdup_printf ("%lu", (gulong) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (CHEESE_SHAREABLE_MEDIA_XID, _tmp8_, NULL);
	_vala_array_add2 (&_data3_->argv, &_data3_->argv_length1, &_data3_->_argv_size_, _tmp9_);
	_g_free0 (_tmp8_);
	_tmp10_ = files;
	g_list_foreach (_tmp10_, ___lambda2__gfunc, _data3_);
	{
		GPid child_pid = 0;
		gchar** _tmp11_;
		gint _tmp11__length1;
		GPid _tmp12_ = 0;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_;
		_tmp11_ = _data3_->argv;
		_tmp11__length1 = _data3_->argv_length1;
		_tmp13_ = g_spawn_async ("/", _tmp11_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp12_, &_inner_error_);
		child_pid = _tmp12_;
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch13_g_spawn_error;
			}
			block3_data_unref (_data3_);
			_data3_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (_tmp14_) {
			guint _tmp15_;
			guint _tmp16_;
			g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, child_pid, _cheese_shareable_media_child_finished_gchild_watch_func, g_object_ref (self), g_object_unref);
			_tmp15_ = self->priv->num_children;
			self->priv->num_children = _tmp15_ + 1;
			_tmp16_ = self->priv->num_children;
			if (_tmp16_ == ((guint) 1)) {
				CheeseMainWindow* _tmp17_;
				GdkWindow* _tmp18_ = NULL;
				GdkCursor* _tmp19_;
				GdkCursor* _tmp20_;
				_tmp17_ = self->priv->window;
				_tmp18_ = gtk_widget_get_window ((GtkWidget*) _tmp17_);
				_tmp19_ = gdk_cursor_new (GDK_WATCH);
				_tmp20_ = _tmp19_;
				gdk_window_set_cursor (_tmp18_, _tmp20_);
				_g_object_unref0 (_tmp20_);
			}
		}
	}
	goto __finally13;
	__catch13_g_spawn_error:
	{
		GError* _error_ = NULL;
		CheeseMainWindow* _tmp21_;
		GdkWindow* _tmp22_ = NULL;
		GdkCursor* _tmp23_;
		GdkCursor* _tmp24_;
		GError* _tmp25_;
		const gchar* _tmp26_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = self->priv->window;
		_tmp22_ = gtk_widget_get_window ((GtkWidget*) _tmp21_);
		_tmp23_ = gdk_cursor_new (GDK_LEFT_PTR);
		_tmp24_ = _tmp23_;
		gdk_window_set_cursor (_tmp22_, _tmp24_);
		_g_object_unref0 (_tmp24_);
		_tmp25_ = _error_;
		_tmp26_ = _tmp25_->message;
		g_warning ("cheese-shareable-media.vala:121: Unable to launch nautilus-sendto: %s\n", _tmp26_);
		_g_error_free0 (_error_);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void cheese_shareable_media_class_init (CheeseShareableMediaClass * klass) {
	cheese_shareable_media_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheeseShareableMediaPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_shareable_media_finalize;
}


static void cheese_shareable_media_instance_init (CheeseShareableMedia * self) {
	self->priv = CHEESE_SHAREABLE_MEDIA_GET_PRIVATE (self);
	self->priv->num_children = (guint) 0;
}


static void cheese_shareable_media_finalize (GObject* obj) {
	CheeseShareableMedia * self;
	self = CHEESE_SHAREABLE_MEDIA (obj);
	_g_object_unref0 (self->priv->window);
	G_OBJECT_CLASS (cheese_shareable_media_parent_class)->finalize (obj);
}


/**
 * Class used for sharing images or videos with different technologies through
 * nautilus-sendto.
 */
GType cheese_shareable_media_get_type (void) {
	static volatile gsize cheese_shareable_media_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_shareable_media_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseShareableMediaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_shareable_media_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseShareableMedia), 0, (GInstanceInitFunc) cheese_shareable_media_instance_init, NULL };
		GType cheese_shareable_media_type_id;
		cheese_shareable_media_type_id = g_type_register_static (G_TYPE_OBJECT, "CheeseShareableMedia", &g_define_type_info, 0);
		g_once_init_leave (&cheese_shareable_media_type_id__volatile, cheese_shareable_media_type_id);
	}
	return cheese_shareable_media_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



