/* rygel-tracker-insertion-query.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-tracker-insertion-query.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rygel.h>


#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE (rygel_tracker_resources_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIface))
#define RYGEL_TRACKER_IS_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE))
#define RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIfaceIface))

typedef struct _RygelTrackerResourcesIface RygelTrackerResourcesIface;
typedef struct _RygelTrackerResourcesIfaceIface RygelTrackerResourcesIfaceIface;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE_PROXY (rygel_tracker_resources_iface_proxy_get_type ())

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;

#define RYGEL_TRACKER_TYPE_INSERTION_QUERY (rygel_tracker_insertion_query_get_type ())
#define RYGEL_TRACKER_INSERTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQuery))
#define RYGEL_TRACKER_INSERTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryClass))
#define RYGEL_TRACKER_IS_INSERTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY))
#define RYGEL_TRACKER_IS_INSERTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_INSERTION_QUERY))
#define RYGEL_TRACKER_INSERTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryClass))

typedef struct _RygelTrackerInsertionQuery RygelTrackerInsertionQuery;
typedef struct _RygelTrackerInsertionQueryClass RygelTrackerInsertionQueryClass;
typedef struct _RygelTrackerInsertionQueryPrivate RygelTrackerInsertionQueryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLET (rygel_tracker_query_triplet_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTriplet))
#define RYGEL_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_QUERY_TRIPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))

typedef struct _RygelTrackerQueryTriplet RygelTrackerQueryTriplet;
typedef struct _RygelTrackerQueryTripletClass RygelTrackerQueryTripletClass;
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE (rygel_tracker_miner_files_index_iface_get_type ())
#define RYGEL_TRACKER_MINER_FILES_INDEX_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE, RygelTrackerMinerFilesIndexIface))
#define RYGEL_TRACKER_IS_MINER_FILES_INDEX_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE))
#define RYGEL_TRACKER_MINER_FILES_INDEX_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE, RygelTrackerMinerFilesIndexIfaceIface))

typedef struct _RygelTrackerMinerFilesIndexIface RygelTrackerMinerFilesIndexIface;
typedef struct _RygelTrackerMinerFilesIndexIfaceIface RygelTrackerMinerFilesIndexIfaceIface;

#define RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE_PROXY (rygel_tracker_miner_files_index_iface_proxy_get_type ())
typedef struct _RygelTrackerInsertionQueryExecuteData RygelTrackerInsertionQueryExecuteData;

struct _RygelTrackerResourcesIfaceIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*sparql_query_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*sparql_update) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*sparql_update_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, GError** error);
	void (*sparql_update_blank) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*sparql_update_blank_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerInsertionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerInsertionQueryPrivate * priv;
	gchar* id;
};

struct _RygelTrackerInsertionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerInsertionQueryPrivate {
	gchar* uri;
};

struct _RygelTrackerMinerFilesIndexIfaceIface {
	GTypeInterface parent_iface;
	void (*index_file) (RygelTrackerMinerFilesIndexIface* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*index_file_finish) (RygelTrackerMinerFilesIndexIface* self, GAsyncResult* _res_, GError** error);
};

struct _RygelTrackerInsertionQueryExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerInsertionQuery* self;
	RygelTrackerResourcesIface* resources;
	gchar* _tmp0_;
	gchar* str;
	const gchar* _tmp1_;
	RygelTrackerResourcesIface* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GHashTable** _tmp6_;
	GHashTable** _result_;
	gint _result__length1;
	gint _result__length2;
	gboolean _tmp7_;
	GHashTable** _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	GHashTable* _tmp9_;
	GHashTable** _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	GHashTable* _tmp11_;
	gconstpointer _tmp12_;
	gboolean _tmp13_;
	RygelTrackerResourcesIface* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gint _tmp20__length2;
	gchar** ids;
	gint ids_length1;
	gint ids_length2;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gint _tmp21__length2;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	GHashTable** _tmp24_;
	gint _tmp24__length1;
	gint _tmp24__length2;
	GHashTable* _tmp25_;
	gconstpointer _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	GFile* _tmp29_;
	GFile* file;
	gboolean _tmp30_;
	GFile* _tmp31_;
	gboolean _tmp32_;
	GFile* _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	RygelTrackerMinerFilesIndexIface* _tmp36_;
	RygelTrackerMinerFilesIndexIface* miner;
	RygelTrackerMinerFilesIndexIface* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	GError * _inner_error_;
};


static gpointer rygel_tracker_insertion_query_parent_class = NULL;

gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_resources_iface_proxy_get_type (void) G_GNUC_CONST;
guint rygel_tracker_resources_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_tracker_resources_iface_get_type (void) G_GNUC_CONST;
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
GType rygel_tracker_insertion_query_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_INSERTION_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryPrivate))
enum  {
	RYGEL_TRACKER_INSERTION_QUERY_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_INSERTION_QUERY_TEMP_ID "x"
#define RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID "_:" RYGEL_TRACKER_INSERTION_QUERY_TEMP_ID
#define RYGEL_TRACKER_INSERTION_QUERY_MINER_SERVICE "org.freedesktop.Tracker1.Miner.Files.Index"
#define RYGEL_TRACKER_INSERTION_QUERY_MINER_PATH "/org/freedesktop/Tracker1/Miner/Files/Index"
#define RYGEL_TRACKER_INSERTION_QUERY_MINER_GRAPH "urn:uuid:472ed0cc-40ff-4e37-9c0c-062d78656540"
#define RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_ID_QUERY_TEMPLATE "SELECT ?resource WHERE { ?resource a nie:DataObject; nie:url '%s' }"
#define RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_NOT_BOUND_TEMPLATE "OPTIONAL { ?resource a nie:DataObject; nie:url '%s' } " "FILTER (!bound(?resource))"
RygelTrackerInsertionQuery* rygel_tracker_insertion_query_new (RygelMediaItem* item, const gchar* category);
RygelTrackerInsertionQuery* rygel_tracker_insertion_query_construct (GType object_type, RygelMediaItem* item, const gchar* category);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct (GType object_type);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new (const gchar* subject, const gchar* predicate, const gchar* obj);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct (GType object_type, const gchar* subject, const gchar* predicate, const gchar* obj);
gpointer rygel_tracker_query_triplet_ref (gpointer instance);
void rygel_tracker_query_triplet_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query_triplet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query_triplet (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query_triplet (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query_triplet (const GValue* value);
GType rygel_tracker_query_triplet_get_type (void) G_GNUC_CONST;
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new_with_graph (const gchar* graph, const gchar* subject, const gchar* predicate, const gchar* object);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct_with_graph (GType object_type, const gchar* graph, const gchar* subject, const gchar* predicate, const gchar* object);
RygelTrackerQuery* rygel_tracker_query_construct (GType object_type, RygelTrackerQueryTriplets* triplets);
static void rygel_tracker_insertion_query_real_execute_data_free (gpointer _data);
static void rygel_tracker_insertion_query_real_execute (RygelTrackerQuery* base, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_insertion_query_real_execute_co (RygelTrackerInsertionQueryExecuteData* _data_);
gchar* rygel_tracker_query_to_string (RygelTrackerQuery* self);
void rygel_tracker_resources_iface_sparql_update_blank (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** rygel_tracker_resources_iface_sparql_update_blank_finish (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void rygel_tracker_insertion_query_execute_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_tracker_resources_iface_sparql_query (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** rygel_tracker_resources_iface_sparql_query_finish (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static gchar* rygel_tracker_insertion_query_get_resource_id_query (RygelTrackerInsertionQuery* self);
GType rygel_tracker_miner_files_index_iface_proxy_get_type (void) G_GNUC_CONST;
guint rygel_tracker_miner_files_index_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_tracker_miner_files_index_iface_get_type (void) G_GNUC_CONST;
void rygel_tracker_miner_files_index_iface_index_file (RygelTrackerMinerFilesIndexIface* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_miner_files_index_iface_index_file_finish (RygelTrackerMinerFilesIndexIface* self, GAsyncResult* _res_, GError** error);
static gchar* rygel_tracker_insertion_query_real_to_string (RygelTrackerQuery* base);
static void rygel_tracker_insertion_query_finalize (RygelTrackerQuery* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


RygelTrackerInsertionQuery* rygel_tracker_insertion_query_construct (GType object_type, RygelMediaItem* item, const gchar* category) {
	RygelTrackerInsertionQuery* self = NULL;
	gchar* _tmp0_;
	gchar* type;
	RygelMediaItem* _tmp1_;
	GeeArrayList* _tmp2_;
	gpointer _tmp3_ = NULL;
	gchar* _tmp4_;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_;
	GFile* file;
	GFile* _tmp7_;
	gboolean _tmp8_ = FALSE;
	RygelTrackerQueryTriplets* _tmp10_;
	RygelTrackerQueryTriplets* triplets;
	RygelTrackerQueryTriplets* _tmp11_;
	RygelTrackerQueryTriplet* _tmp12_;
	RygelTrackerQueryTriplet* _tmp13_;
	RygelTrackerQueryTriplets* _tmp14_;
	const gchar* _tmp15_;
	RygelTrackerQueryTriplet* _tmp16_;
	RygelTrackerQueryTriplet* _tmp17_;
	RygelTrackerQueryTriplets* _tmp18_;
	RygelTrackerQueryTriplet* _tmp19_;
	RygelTrackerQueryTriplet* _tmp20_;
	RygelTrackerQueryTriplets* _tmp21_;
	RygelTrackerQueryTriplet* _tmp22_;
	RygelTrackerQueryTriplet* _tmp23_;
	RygelTrackerQueryTriplets* _tmp24_;
	RygelTrackerQueryTriplet* _tmp25_;
	RygelTrackerQueryTriplet* _tmp26_;
	RygelTrackerQueryTriplets* _tmp27_;
	RygelMediaItem* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	RygelTrackerQueryTriplet* _tmp35_;
	RygelTrackerQueryTriplet* _tmp36_;
	RygelTrackerQueryTriplets* _tmp37_;
	RygelMediaItem* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	RygelTrackerQueryTriplet* _tmp44_;
	RygelTrackerQueryTriplet* _tmp45_;
	gchar* _tmp46_;
	gchar* dlna_profile;
	RygelMediaItem* _tmp47_;
	const gchar* _tmp48_;
	RygelTrackerQueryTriplets* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	RygelTrackerQueryTriplet* _tmp58_;
	RygelTrackerQueryTriplet* _tmp59_;
	RygelTrackerQueryTriplets* _tmp60_;
	RygelMediaItem* _tmp61_;
	GeeArrayList* _tmp62_;
	gpointer _tmp63_ = NULL;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	RygelTrackerQueryTriplet* _tmp69_;
	RygelTrackerQueryTriplet* _tmp70_;
	GTimeVal now = {0};
	gchar* _tmp71_ = NULL;
	gchar* date;
	RygelTrackerQueryTriplets* _tmp72_;
	const gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	RygelTrackerQueryTriplet* _tmp78_;
	RygelTrackerQueryTriplet* _tmp79_;
	RygelMediaItem* _tmp80_;
	gint64 _tmp81_;
	gint64 _tmp82_;
	RygelTrackerQueryTriplets* _tmp95_;
	RygelMediaItem* _tmp96_;
	GeeArrayList* _tmp97_;
	gpointer _tmp98_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (category != NULL, NULL);
	_tmp0_ = g_strdup ("nie:DataObject");
	type = _tmp0_;
	_tmp1_ = item;
	_tmp2_ = ((RygelMediaObject*) _tmp1_)->uris;
	_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp2_, 0);
	_tmp4_ = (gchar*) _tmp3_;
	_tmp5_ = g_file_new_for_uri (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	file = _tmp6_;
	_tmp7_ = file;
	_tmp8_ = g_file_is_native (_tmp7_);
	if (!_tmp8_) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("nfo:RemoteDataObject");
		_g_free0 (type);
		type = _tmp9_;
	}
	_tmp10_ = rygel_tracker_query_triplets_new ();
	triplets = _tmp10_;
	_tmp11_ = triplets;
	_tmp12_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "a", "nfo:Media");
	_tmp13_ = _tmp12_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp13_);
	_rygel_tracker_query_triplet_unref0 (_tmp13_);
	_tmp14_ = triplets;
	_tmp15_ = type;
	_tmp16_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "a", _tmp15_);
	_tmp17_ = _tmp16_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp17_);
	_rygel_tracker_query_triplet_unref0 (_tmp17_);
	_tmp18_ = triplets;
	_tmp19_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nmm:uPnPShared", "true");
	_tmp20_ = _tmp19_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp20_);
	_rygel_tracker_query_triplet_unref0 (_tmp20_);
	_tmp21_ = triplets;
	_tmp22_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "tracker:available", "true");
	_tmp23_ = _tmp22_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp23_);
	_rygel_tracker_query_triplet_unref0 (_tmp23_);
	_tmp24_ = triplets;
	_tmp25_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:generator", "\"rygel\"");
	_tmp26_ = _tmp25_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp26_);
	_rygel_tracker_query_triplet_unref0 (_tmp26_);
	_tmp27_ = triplets;
	_tmp28_ = item;
	_tmp29_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat ("\"", _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strconcat (_tmp32_, "\"", NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:title", _tmp34_);
	_tmp36_ = _tmp35_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp36_);
	_rygel_tracker_query_triplet_unref0 (_tmp36_);
	_g_free0 (_tmp34_);
	_g_free0 (_tmp32_);
	_tmp37_ = triplets;
	_tmp38_ = item;
	_tmp39_ = _tmp38_->mime_type;
	_tmp40_ = g_strconcat ("\"", _tmp39_, NULL);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strconcat (_tmp41_, "\"", NULL);
	_tmp43_ = _tmp42_;
	_tmp44_ = rygel_tracker_query_triplet_new_with_graph (RYGEL_TRACKER_INSERTION_QUERY_MINER_GRAPH, RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:mimeType", _tmp43_);
	_tmp45_ = _tmp44_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, _tmp45_);
	_rygel_tracker_query_triplet_unref0 (_tmp45_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp41_);
	_tmp46_ = g_strdup ("");
	dlna_profile = _tmp46_;
	_tmp47_ = item;
	_tmp48_ = _tmp47_->dlna_profile;
	if (_tmp48_ != NULL) {
		RygelMediaItem* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp49_ = item;
		_tmp50_ = _tmp49_->dlna_profile;
		_tmp51_ = g_strdup (_tmp50_);
		_g_free0 (dlna_profile);
		dlna_profile = _tmp51_;
	}
	_tmp52_ = triplets;
	_tmp53_ = dlna_profile;
	_tmp54_ = g_strconcat ("\"", _tmp53_, NULL);
	_tmp55_ = _tmp54_;
	_tmp56_ = g_strconcat (_tmp55_, "\"", NULL);
	_tmp57_ = _tmp56_;
	_tmp58_ = rygel_tracker_query_triplet_new_with_graph (RYGEL_TRACKER_INSERTION_QUERY_MINER_GRAPH, RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nmm:dlnaProfile", _tmp57_);
	_tmp59_ = _tmp58_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, _tmp59_);
	_rygel_tracker_query_triplet_unref0 (_tmp59_);
	_g_free0 (_tmp57_);
	_g_free0 (_tmp55_);
	_tmp60_ = triplets;
	_tmp61_ = item;
	_tmp62_ = ((RygelMediaObject*) _tmp61_)->uris;
	_tmp63_ = gee_abstract_list_get ((GeeAbstractList*) _tmp62_, 0);
	_tmp64_ = (gchar*) _tmp63_;
	_tmp65_ = g_strconcat ("\"", _tmp64_, NULL);
	_tmp66_ = _tmp65_;
	_tmp67_ = g_strconcat (_tmp66_, "\"", NULL);
	_tmp68_ = _tmp67_;
	_tmp69_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:url", _tmp68_);
	_tmp70_ = _tmp69_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp60_, _tmp70_);
	_rygel_tracker_query_triplet_unref0 (_tmp70_);
	_g_free0 (_tmp68_);
	_g_free0 (_tmp66_);
	_g_free0 (_tmp64_);
	g_get_current_time (&now);
	_tmp71_ = g_time_val_to_iso8601 (&now);
	date = _tmp71_;
	_tmp72_ = triplets;
	_tmp73_ = date;
	_tmp74_ = g_strconcat ("\"", _tmp73_, NULL);
	_tmp75_ = _tmp74_;
	_tmp76_ = g_strconcat (_tmp75_, "\"", NULL);
	_tmp77_ = _tmp76_;
	_tmp78_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:contentCreated", _tmp77_);
	_tmp79_ = _tmp78_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp72_, _tmp79_);
	_rygel_tracker_query_triplet_unref0 (_tmp79_);
	_g_free0 (_tmp77_);
	_g_free0 (_tmp75_);
	_tmp80_ = item;
	_tmp81_ = rygel_media_item_get_size (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ > ((gint64) 0)) {
		RygelTrackerQueryTriplets* _tmp83_;
		RygelMediaItem* _tmp84_;
		gint64 _tmp85_;
		gint64 _tmp86_;
		gchar* _tmp87_ = NULL;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		RygelTrackerQueryTriplet* _tmp93_;
		RygelTrackerQueryTriplet* _tmp94_;
		_tmp83_ = triplets;
		_tmp84_ = item;
		_tmp85_ = rygel_media_item_get_size (_tmp84_);
		_tmp86_ = _tmp85_;
		_tmp87_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp86_);
		_tmp88_ = _tmp87_;
		_tmp89_ = g_strconcat ("\"", _tmp88_, NULL);
		_tmp90_ = _tmp89_;
		_tmp91_ = g_strconcat (_tmp90_, "\"", NULL);
		_tmp92_ = _tmp91_;
		_tmp93_ = rygel_tracker_query_triplet_new_with_graph (RYGEL_TRACKER_INSERTION_QUERY_MINER_GRAPH, RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:byteSize", _tmp92_);
		_tmp94_ = _tmp93_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp83_, _tmp94_);
		_rygel_tracker_query_triplet_unref0 (_tmp94_);
		_g_free0 (_tmp92_);
		_g_free0 (_tmp90_);
		_g_free0 (_tmp88_);
	}
	_tmp95_ = triplets;
	self = (RygelTrackerInsertionQuery*) rygel_tracker_query_construct (object_type, _tmp95_);
	_tmp96_ = item;
	_tmp97_ = ((RygelMediaObject*) _tmp96_)->uris;
	_tmp98_ = gee_abstract_list_get ((GeeAbstractList*) _tmp97_, 0);
	_g_free0 (self->priv->uri);
	self->priv->uri = (gchar*) _tmp98_;
	_g_free0 (date);
	_g_free0 (dlna_profile);
	_g_object_unref0 (triplets);
	_g_object_unref0 (file);
	_g_free0 (type);
	return self;
}


RygelTrackerInsertionQuery* rygel_tracker_insertion_query_new (RygelMediaItem* item, const gchar* category) {
	return rygel_tracker_insertion_query_construct (RYGEL_TRACKER_TYPE_INSERTION_QUERY, item, category);
}


static void rygel_tracker_insertion_query_real_execute_data_free (gpointer _data) {
	RygelTrackerInsertionQueryExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->resources);
	_rygel_tracker_query_unref0 (_data_->self);
	g_slice_free (RygelTrackerInsertionQueryExecuteData, _data_);
}


static gpointer _rygel_tracker_query_ref0 (gpointer self) {
	return self ? rygel_tracker_query_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_tracker_insertion_query_real_execute (RygelTrackerQuery* base, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerInsertionQuery * self;
	RygelTrackerInsertionQueryExecuteData* _data_;
	RygelTrackerInsertionQuery* _tmp0_;
	RygelTrackerResourcesIface* _tmp1_;
	RygelTrackerResourcesIface* _tmp2_;
	self = (RygelTrackerInsertionQuery*) base;
	_data_ = g_slice_new0 (RygelTrackerInsertionQueryExecuteData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_tracker_insertion_query_real_execute);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_insertion_query_real_execute_data_free);
	_tmp0_ = _rygel_tracker_query_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = resources;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->resources = _tmp2_;
	rygel_tracker_insertion_query_real_execute_co (_data_);
}


static void rygel_tracker_insertion_query_real_execute_finish (RygelTrackerQuery* base, GAsyncResult* _res_, GError** error) {
	RygelTrackerInsertionQueryExecuteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_insertion_query_execute_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerInsertionQueryExecuteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_insertion_query_real_execute_co (_data_);
}


static gboolean rygel_tracker_insertion_query_real_execute_co (RygelTrackerInsertionQueryExecuteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = rygel_tracker_query_to_string ((RygelTrackerQuery*) _data_->self);
	_data_->str = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->str;
	g_debug ("rygel-tracker-insertion-query.vala:117: Executing SPARQL query: %s", _data_->_tmp1_);
	_data_->_tmp2_ = _data_->resources;
	_data_->_tmp3_ = _data_->str;
	_data_->_tmp4_ = 0;
	_data_->_tmp5_ = 0;
	_data_->_state_ = 1;
	rygel_tracker_resources_iface_sparql_update_blank (_data_->_tmp2_, _data_->_tmp3_, rygel_tracker_insertion_query_execute_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = rygel_tracker_resources_iface_sparql_update_blank_finish (_data_->_tmp2_, _data_->_res_, &_data_->_tmp4_, &_data_->_tmp5_, &_data_->_inner_error_);
	_data_->_result_ = _data_->_tmp6_;
	_data_->_result__length1 = _data_->_tmp4_;
	_data_->_result__length2 = _data_->_tmp5_;
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->str);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp8_ = _data_->_result_;
	_data_->_tmp8__length1 = _data_->_result__length1;
	_data_->_tmp8__length2 = _data_->_result__length2;
	_data_->_tmp9_ = _data_->_tmp8_[(0 * _data_->_tmp8__length2) + 0];
	if (_data_->_tmp9_ == NULL) {
		_data_->_tmp7_ = TRUE;
	} else {
		_data_->_tmp10_ = _data_->_result_;
		_data_->_tmp10__length1 = _data_->_result__length1;
		_data_->_tmp10__length2 = _data_->_result__length2;
		_data_->_tmp11_ = _data_->_tmp10_[(0 * _data_->_tmp10__length2) + 0];
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_hash_table_lookup (_data_->_tmp11_, RYGEL_TRACKER_INSERTION_QUERY_TEMP_ID);
		_data_->_tmp7_ = ((const gchar*) _data_->_tmp12_) == NULL;
	}
	_data_->_tmp13_ = _data_->_tmp7_;
	if (_data_->_tmp13_) {
		_data_->_tmp14_ = _data_->resources;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = rygel_tracker_insertion_query_get_resource_id_query (_data_->self);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = 0;
		_data_->_tmp18_ = 0;
		_data_->_state_ = 2;
		rygel_tracker_resources_iface_sparql_query (_data_->_tmp14_, _data_->_tmp16_, rygel_tracker_insertion_query_execute_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = rygel_tracker_resources_iface_sparql_query_finish (_data_->_tmp14_, _data_->_res_, &_data_->_tmp17_, &_data_->_tmp18_, &_data_->_inner_error_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_tmp20__length1 = _data_->_tmp17_;
		_data_->_tmp20__length2 = _data_->_tmp18_;
		_g_free0 (_data_->_tmp16_);
		_data_->ids = _data_->_tmp20_;
		_data_->ids_length1 = _data_->_tmp20__length1;
		_data_->ids_length2 = _data_->_tmp20__length2;
		if (_data_->_inner_error_ != NULL) {
			if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1 * _data_->_result__length2, (GDestroyNotify) g_hash_table_unref), NULL);
				_g_free0 (_data_->str);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1 * _data_->_result__length2, (GDestroyNotify) g_hash_table_unref), NULL);
				_g_free0 (_data_->str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_data_->_tmp21_ = _data_->ids;
		_data_->_tmp21__length1 = _data_->ids_length1;
		_data_->_tmp21__length2 = _data_->ids_length2;
		_data_->_tmp22_ = _data_->_tmp21_[(0 * _data_->_tmp21__length2) + 0];
		_data_->_tmp23_ = g_strdup (_data_->_tmp22_);
		_g_free0 (_data_->self->id);
		_data_->self->id = _data_->_tmp23_;
		_data_->ids = (_vala_array_free (_data_->ids, _data_->ids_length1 * _data_->ids_length2, (GDestroyNotify) g_free), NULL);
	} else {
		_data_->_tmp24_ = _data_->_result_;
		_data_->_tmp24__length1 = _data_->_result__length1;
		_data_->_tmp24__length2 = _data_->_result__length2;
		_data_->_tmp25_ = _data_->_tmp24_[(0 * _data_->_tmp24__length2) + 0];
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = g_hash_table_lookup (_data_->_tmp25_, RYGEL_TRACKER_INSERTION_QUERY_TEMP_ID);
		_data_->_tmp27_ = g_strdup ((const gchar*) _data_->_tmp26_);
		_g_free0 (_data_->self->id);
		_data_->self->id = _data_->_tmp27_;
		_data_->_tmp28_ = _data_->self->priv->uri;
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = g_file_new_for_uri (_data_->_tmp28_);
		_data_->file = _data_->_tmp29_;
		_data_->_tmp31_ = _data_->file;
		_data_->_tmp32_ = FALSE;
		_data_->_tmp32_ = g_file_is_native (_data_->_tmp31_);
		if (_data_->_tmp32_) {
			_data_->_tmp33_ = _data_->file;
			_data_->_tmp34_ = FALSE;
			_data_->_tmp34_ = g_file_query_exists (_data_->_tmp33_, NULL);
			_data_->_tmp30_ = _data_->_tmp34_;
		} else {
			_data_->_tmp30_ = FALSE;
		}
		_data_->_tmp35_ = _data_->_tmp30_;
		if (_data_->_tmp35_) {
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = g_initable_new (RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE_PROXY, NULL, &_data_->_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", RYGEL_TRACKER_INSERTION_QUERY_MINER_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_TRACKER_INSERTION_QUERY_MINER_PATH, "g-interface-name", "org.freedesktop.Tracker1.Miner.Files.Index", NULL);
			_data_->miner = (RygelTrackerMinerFilesIndexIface*) _data_->_tmp36_;
			if (_data_->_inner_error_ != NULL) {
				if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					_g_object_unref0 (_data_->file);
					_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1 * _data_->_result__length2, (GDestroyNotify) g_hash_table_unref), NULL);
					_g_free0 (_data_->str);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				} else {
					_g_object_unref0 (_data_->file);
					_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1 * _data_->_result__length2, (GDestroyNotify) g_hash_table_unref), NULL);
					_g_free0 (_data_->str);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_data_->_tmp37_ = _data_->miner;
			_data_->_tmp38_ = _data_->self->priv->uri;
			rygel_tracker_miner_files_index_iface_index_file (_data_->_tmp37_, _data_->_tmp38_, NULL, NULL);
			_g_object_unref0 (_data_->miner);
		}
		_g_object_unref0 (_data_->file);
	}
	_data_->_tmp39_ = _data_->self->id;
	g_debug ("rygel-tracker-insertion-query.vala:141: Created item in Tracker store " \
"with ID '%s'", _data_->_tmp39_);
	_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1 * _data_->_result__length2, (GDestroyNotify) g_hash_table_unref), NULL);
	_g_free0 (_data_->str);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* rygel_tracker_insertion_query_real_to_string (RygelTrackerQuery* base) {
	RygelTrackerInsertionQuery * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* query;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	self = (RygelTrackerInsertionQuery*) base;
	_tmp0_ = RYGEL_TRACKER_QUERY_CLASS (rygel_tracker_insertion_query_parent_class)->to_string (RYGEL_TRACKER_QUERY (self));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("INSERT { ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, " }", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	query = _tmp5_;
	_tmp6_ = query;
	_tmp7_ = self->priv->uri;
	_tmp8_ = g_strdup_printf (RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_NOT_BOUND_TEMPLATE, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("WHERE {", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "}", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp6_, _tmp13_, NULL);
	_g_free0 (query);
	query = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	result = query;
	return result;
}


static gchar* rygel_tracker_insertion_query_get_resource_id_query (RygelTrackerInsertionQuery* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->uri;
	_tmp1_ = g_strdup_printf (RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_ID_QUERY_TEMPLATE, _tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_tracker_insertion_query_class_init (RygelTrackerInsertionQueryClass * klass) {
	rygel_tracker_insertion_query_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRACKER_QUERY_CLASS (klass)->finalize = rygel_tracker_insertion_query_finalize;
	g_type_class_add_private (klass, sizeof (RygelTrackerInsertionQueryPrivate));
	RYGEL_TRACKER_QUERY_CLASS (klass)->execute = rygel_tracker_insertion_query_real_execute;
	RYGEL_TRACKER_QUERY_CLASS (klass)->execute_finish = rygel_tracker_insertion_query_real_execute_finish;
	RYGEL_TRACKER_QUERY_CLASS (klass)->to_string = rygel_tracker_insertion_query_real_to_string;
}


static void rygel_tracker_insertion_query_instance_init (RygelTrackerInsertionQuery * self) {
	self->priv = RYGEL_TRACKER_INSERTION_QUERY_GET_PRIVATE (self);
}


static void rygel_tracker_insertion_query_finalize (RygelTrackerQuery* obj) {
	RygelTrackerInsertionQuery * self;
	self = RYGEL_TRACKER_INSERTION_QUERY (obj);
	_g_free0 (self->id);
	_g_free0 (self->priv->uri);
	RYGEL_TRACKER_QUERY_CLASS (rygel_tracker_insertion_query_parent_class)->finalize (obj);
}


/**
 * Represents Tracker SPARQL Insertion query
 */
GType rygel_tracker_insertion_query_get_type (void) {
	static volatile gsize rygel_tracker_insertion_query_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_insertion_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerInsertionQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_insertion_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerInsertionQuery), 0, (GInstanceInitFunc) rygel_tracker_insertion_query_instance_init, NULL };
		GType rygel_tracker_insertion_query_type_id;
		rygel_tracker_insertion_query_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_QUERY, "RygelTrackerInsertionQuery", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_insertion_query_type_id__volatile, rygel_tracker_insertion_query_type_id);
	}
	return rygel_tracker_insertion_query_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



