/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-search.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-editor-search
 * @title: IAnjutaEditorSearch
 * @short_description: Text editor search interface
 * @see_also:
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor-search.h
 *
 */

#include "ianjuta-editor-search.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_search_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-search-quark");
	}
	
	return quark;
}

/**
 * ianjuta_editor_search_backward:
 * @obj: Self
 * @search: String to search for
 * @start: Where to search from
 * @end: Where to stop searching
 * @result_start: Will be set to the start of the search_result (or NULL)
 * @result_end: Will be set to the end of the search_result (or NULL)
 * @err: Error propagation and reporting
 *
 * Search backward from end to start
 *
 */
gboolean
ianjuta_editor_search_backward (IAnjutaEditorSearch *obj, const gchar* search,   gboolean case_sensitive,   IAnjutaEditorCell* start,   IAnjutaEditorCell* end,   IAnjutaEditorCell** result_start,   IAnjutaEditorCell** result_end, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_SEARCH(obj), FALSE);
	g_return_val_if_fail ((start == NULL) ||IANJUTA_IS_EDITOR_CELL(start), FALSE);
	g_return_val_if_fail ((end == NULL) ||IANJUTA_IS_EDITOR_CELL(end), FALSE);
	return IANJUTA_EDITOR_SEARCH_GET_IFACE (obj)->backward (obj, search, case_sensitive, start, end, result_start, result_end, err);
}

/* Default implementation */
static gboolean
ianjuta_editor_search_backward_default (IAnjutaEditorSearch *obj, const gchar* search,   gboolean case_sensitive,   IAnjutaEditorCell* start,   IAnjutaEditorCell* end,   IAnjutaEditorCell** result_start,   IAnjutaEditorCell** result_end, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
 * ianjuta_editor_search_forward:
 * @obj: Self
 * @search: String to search for
 * @start: Where to search from
 	 * @end: Where to stop searching
 	 * @result_start: Will be set to the start of the search_result (or NULL)
 	 * @result_end: Will be set to the end of the search_result (or NULL)
 	 * @err: Error propagation and reporting
 	 *
 	 * Search forward from start to end
 	 *
 	 */
gboolean
ianjuta_editor_search_forward (IAnjutaEditorSearch *obj, const gchar* search,   gboolean case_sensitive,   IAnjutaEditorCell* start,   IAnjutaEditorCell* end,   IAnjutaEditorCell** result_start,   IAnjutaEditorCell** result_end, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_SEARCH(obj), FALSE);
	g_return_val_if_fail ((start == NULL) ||IANJUTA_IS_EDITOR_CELL(start), FALSE);
	g_return_val_if_fail ((end == NULL) ||IANJUTA_IS_EDITOR_CELL(end), FALSE);
	return IANJUTA_EDITOR_SEARCH_GET_IFACE (obj)->forward (obj, search, case_sensitive, start, end, result_start, result_end, err);
}

/* Default implementation */
static gboolean
ianjuta_editor_search_forward_default (IAnjutaEditorSearch *obj, const gchar* search,   gboolean case_sensitive,   IAnjutaEditorCell* start,   IAnjutaEditorCell* end,   IAnjutaEditorCell** result_start,   IAnjutaEditorCell** result_end, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_editor_search_base_init (IAnjutaEditorSearchIface* klass)
{
	static gboolean initialized = FALSE;

	klass->backward = ianjuta_editor_search_backward_default;
	klass->forward = ianjuta_editor_search_forward_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_editor_search_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorSearchIface),
			(GBaseInitFunc) ianjuta_editor_search_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorSearch", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_EDITOR);
	}
	return type;			
}
