/* rygel-searchable-container.c generated by valac 0.15.1.36-84b2b, the Vala compiler
 * generated from rygel-searchable-container.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define TYPE_MEDIA_OBJECT (media_object_get_type ())
#define MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT, MediaObject))
#define MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECT, MediaObjectClass))
#define IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT))
#define IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECT))
#define MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECT, MediaObjectClass))

typedef struct _MediaObject MediaObject;
typedef struct _MediaObjectClass MediaObjectClass;

#define TYPE_MEDIA_CONTAINER (media_container_get_type ())
#define MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER, MediaContainer))
#define MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_CONTAINER, MediaContainerClass))
#define IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER))
#define IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_CONTAINER))
#define MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_CONTAINER, MediaContainerClass))

typedef struct _MediaContainer MediaContainer;
typedef struct _MediaContainerClass MediaContainerClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define TYPE_SEARCH_EXPRESSION (search_expression_get_type ())
#define SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_EXPRESSION, SearchExpression))
#define SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))
#define IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_EXPRESSION))
#define IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_EXPRESSION))
#define SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))

typedef struct _SearchExpression SearchExpression;
typedef struct _SearchExpressionClass SearchExpressionClass;

#define TYPE_MEDIA_OBJECTS (media_objects_get_type ())
#define MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECTS, MediaObjects))
#define MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECTS, MediaObjectsClass))
#define IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECTS))
#define IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECTS))
#define MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECTS, MediaObjectsClass))

typedef struct _MediaObjects MediaObjects;
typedef struct _MediaObjectsClass MediaObjectsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _MediaObjectPrivate MediaObjectPrivate;
typedef struct _MediaContainerPrivate MediaContainerPrivate;
typedef struct _RygelSearchableContainerSimpleSearchData RygelSearchableContainerSimpleSearchData;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_RELATIONAL_EXPRESSION (relational_expression_get_type ())
#define RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpression))
#define RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))
#define IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RELATIONAL_EXPRESSION))
#define IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RELATIONAL_EXPRESSION))
#define RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))

typedef struct _RelationalExpression RelationalExpression;
typedef struct _RelationalExpressionClass RelationalExpressionClass;
typedef struct _SearchExpressionPrivate SearchExpressionPrivate;
typedef struct _RygelSearchableContainerFindObjectData RygelSearchableContainerFindObjectData;
typedef struct _RygelSearchableContainerSearchInChildrenData RygelSearchableContainerSearchInChildrenData;

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	MediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _MediaObject {
	GObject parent_instance;
	MediaObjectPrivate * priv;
};

struct _MediaObjectClass {
	GObjectClass parent_class;
};

struct _MediaContainer {
	MediaObject parent_instance;
	MediaContainerPrivate * priv;
	guint child_count;
};

struct _MediaContainerClass {
	MediaObjectClass parent_class;
};

struct _RygelSearchableContainerSimpleSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	SearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	MediaObjects* result;
	MediaObjects* _tmp0_;
	MediaObjects* _result_;
	guint _tmp1_;
	GCancellable* _tmp2_;
	MediaObjects* _tmp3_;
	MediaObjects* children;
	guint limit;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	MediaObjects* _tmp7_;
	MediaObjects* _tmp8_;
	MediaObjects* _child_list;
	MediaObjects* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _child_size;
	gint _child_index;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	MediaObjects* _tmp15_;
	gint _tmp16_;
	gpointer _tmp17_;
	MediaObject* child;
	gboolean _tmp18_;
	SearchExpression* _tmp19_;
	SearchExpression* _tmp20_;
	MediaObject* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	MediaObjects* _tmp24_;
	MediaObject* _tmp25_;
	gboolean _tmp26_;
	guint _tmp27_;
	MediaObjects* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	guint _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	guint _tmp34_;
	MediaObjects* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	guint _tmp38_;
	gboolean _tmp39_;
	guint _tmp40_;
	guint _tmp41_;
	guint _tmp42_;
	MediaObjects* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	guint _tmp46_;
	guint child_limit;
	SearchExpression* _tmp47_;
	MediaObjects* _tmp48_;
	guint _tmp49_;
	GCancellable* _tmp50_;
	MediaObjects* _tmp51_;
	MediaObjects* child_results;
	MediaObjects* _tmp52_;
	MediaObjects* _tmp53_;
	guint _tmp54_;
	MediaObjects* _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	guint _tmp58_;
	MediaObjects* _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	MediaObjects* _tmp62_;
	gboolean _tmp63_;
	MediaObjects* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	gboolean _tmp67_;
	guint _tmp68_;
	guint _tmp69_;
	gboolean _tmp70_;
	gboolean _tmp71_;
	guint stop;
	gboolean _tmp72_;
	guint _tmp73_;
	guint _tmp74_;
	guint _tmp75_;
	MediaObjects* _tmp76_;
	gint _tmp77_;
	gint _tmp78_;
	gboolean _tmp79_;
	guint _tmp80_;
	guint _tmp81_;
	MediaObjects* _tmp82_;
	gint _tmp83_;
	gint _tmp84_;
	MediaObjects* _tmp85_;
	guint _tmp86_;
	guint _tmp87_;
	GeeList* _tmp88_;
	GError * _inner_error_;
};

struct _SearchExpression {
	GObject parent_instance;
	SearchExpressionPrivate * priv;
	gchar* operand1;
	gchar* operand2;
	gchar* op;
};

struct _SearchExpressionClass {
	GObjectClass parent_class;
};

struct _RygelSearchableContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	gchar* id;
	GCancellable* cancellable;
	MediaObject* result;
	RelationalExpression* _tmp0_;
	RelationalExpression* expression;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	guint total_matches;
	GCancellable* _tmp5_;
	guint _tmp6_;
	MediaObjects* _tmp7_;
	MediaObjects* results;
	gint _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	GError * _inner_error_;
};

struct _RygelSearchableContainerSearchInChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	SearchExpression* expression;
	MediaObjects* children;
	guint limit;
	GCancellable* cancellable;
	MediaObjects* result;
	MediaObjects* _tmp0_;
	MediaObjects* _result_;
	MediaObjects* _tmp1_;
	MediaObjects* _tmp2_;
	MediaObjects* _child_list;
	MediaObjects* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _child_size;
	gint _child_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	MediaObjects* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	MediaObject* child;
	MediaObject* _tmp12_;
	MediaObject* _tmp13_;
	RygelSearchableContainer* _tmp14_;
	RygelSearchableContainer* container;
	guint tmp;
	RygelSearchableContainer* _tmp15_;
	SearchExpression* _tmp16_;
	guint _tmp17_;
	GCancellable* _tmp18_;
	guint _tmp19_;
	MediaObjects* _tmp20_;
	MediaObjects* child_result;
	MediaObjects* _tmp21_;
	MediaObjects* _tmp22_;
	gboolean _tmp23_;
	guint _tmp24_;
	MediaObjects* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	guint _tmp28_;
	gboolean _tmp29_;
	GError * _inner_error_;
};



GType media_object_get_type (void) G_GNUC_CONST;
GType media_container_get_type (void) G_GNUC_CONST;
GType search_expression_get_type (void) G_GNUC_CONST;
GType media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_searchable_container_simple_search_data_free (gpointer _data);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_);
MediaObjects* media_objects_new (void);
MediaObjects* media_objects_construct (GType object_type);
void media_container_get_children (MediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* media_container_get_children_finish (MediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean search_expression_satisfied_by (SearchExpression* self, MediaObject* object);
static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, SearchExpression* expression, MediaObjects* children, guint limit, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static MediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_searchable_container_find_object_data_free (gpointer _data);
void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_);
RelationalExpression* relational_expression_new (void);
RelationalExpression* relational_expression_construct (GType object_type);
GType relational_expression_get_type (void) G_GNUC_CONST;
#define SEARCH_CRITERIA_OP_EQ "="
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_searchable_container_search_in_children_data_free (gpointer _data);
static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_);
static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value);


void rygel_searchable_container_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search (self, expression, offset, max_count, cancellable, _callback_, _user_data_);
#line 377 "rygel-searchable-container.c"
}


MediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search_finish (self, _res_, total_matches, error);
#line 384 "rygel-searchable-container.c"
}


static void rygel_searchable_container_simple_search_data_free (gpointer _data) {
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->expression);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerSimpleSearchData, _data_);
#line 401 "rygel-searchable-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 408 "rygel-searchable-container.c"
}


void rygel_searchable_container_simple_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
	RygelSearchableContainer* _tmp0_;
	SearchExpression* _tmp1_;
	SearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerSimpleSearchData);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_searchable_container_simple_search);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_simple_search_data_free);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp1_ = expression;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->expression = _tmp2_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp3_ = offset;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->offset = _tmp3_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp4_ = max_count;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->max_count = _tmp4_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp5_ = cancellable;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->cancellable = _tmp6_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_simple_search_co (_data_);
#line 453 "rygel-searchable-container.c"
}


MediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	MediaObjects* result;
	RygelSearchableContainerSimpleSearchData* _data_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return NULL;
#line 464 "rygel-searchable-container.c"
	}
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (total_matches) {
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		*total_matches = _data_->total_matches;
#line 472 "rygel-searchable-container.c"
	}
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return result;
#line 480 "rygel-searchable-container.c"
}


/**
     * Utility method that retrieves all children and recursively searches for
     * all media objects that satisfy the given search expression in this
     * container.
     *
     * @param expression the search expression or `null` for wildcard
     * @param offet zero-based index of the first object to return
     * @param max_count maximum number of objects to return
     * @param total_matches sets it to the actual number of objects that satisfy
     *                      the given search expression. If it is not possible
     *                      to compute this value (in a timely mannger), it is
     *                      set to '0'.
     * @param cancellable optional cancellable for this operation
     *
     * return A list of media objects.
     */
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_simple_search_co (_data_);
#line 510 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_) {
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 0:
#line 519 "rygel-searchable-container.c"
		goto _state_0;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 1:
#line 523 "rygel-searchable-container.c"
		goto _state_1;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 2:
#line 527 "rygel-searchable-container.c"
		goto _state_2;
		default:
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 532 "rygel-searchable-container.c"
	}
	_state_0:
#line 76 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp0_ = media_objects_new ();
#line 76 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp1_ = ((MediaContainer*) _data_->self)->child_count;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp2_ = _data_->cancellable;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_state_ = 1;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	media_container_get_children ((MediaContainer*) _data_->self, (guint) 0, _data_->_tmp1_, _data_->_tmp2_, rygel_searchable_container_simple_search_ready, _data_);
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 549 "rygel-searchable-container.c"
	_state_1:
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp3_ = NULL;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp3_ = media_container_get_children_finish ((MediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error_);
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->children = _data_->_tmp3_;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_error_free (_data_->_inner_error_);
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 569 "rygel-searchable-container.c"
		} else {
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 573 "rygel-searchable-container.c"
		}
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 579 "rygel-searchable-container.c"
	}
#line 85 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp4_ = _data_->max_count;
#line 85 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp4_ > ((guint) 0)) {
#line 86 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp5_ = _data_->offset;
#line 86 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp6_ = _data_->max_count;
#line 86 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->limit = _data_->_tmp5_ + _data_->_tmp6_;
#line 591 "rygel-searchable-container.c"
	} else {
#line 88 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->limit = (guint) 0;
#line 595 "rygel-searchable-container.c"
	}
	{
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp7_ = _data_->children;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_list = _data_->_tmp8_;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp9_ = _data_->_child_list;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp9_);
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_size = _data_->_tmp11_;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_index = -1;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		while (TRUE) {
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp12_ = _data_->_child_index;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_child_index = _data_->_tmp12_ + 1;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp13_ = _data_->_child_index;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp14_ = _data_->_child_size;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (!(_data_->_tmp13_ < _data_->_tmp14_)) {
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 628 "rygel-searchable-container.c"
			}
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp15_ = _data_->_child_list;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp16_ = _data_->_child_index;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp17_ = NULL;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp15_, _data_->_tmp16_);
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->child = (MediaObject*) _data_->_tmp17_;
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp19_ = _data_->expression;
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp19_ == NULL) {
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp18_ = TRUE;
#line 646 "rygel-searchable-container.c"
			} else {
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp20_ = _data_->expression;
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp21_ = _data_->child;
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp22_ = FALSE;
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp22_ = search_expression_satisfied_by (_data_->_tmp20_, _data_->_tmp21_);
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp18_ = _data_->_tmp22_;
#line 658 "rygel-searchable-container.c"
			}
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp23_ = _data_->_tmp18_;
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp23_) {
#line 94 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp24_ = _data_->_result_;
#line 94 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp25_ = _data_->child;
#line 94 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp24_, _data_->_tmp25_);
#line 670 "rygel-searchable-container.c"
			}
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp27_ = _data_->limit;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp27_ > ((guint) 0)) {
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp28_ = _data_->_result_;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp29_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp28_);
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp30_ = _data_->_tmp29_;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp31_ = _data_->limit;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp26_ = ((guint) _data_->_tmp30_) >= _data_->_tmp31_;
#line 686 "rygel-searchable-container.c"
			} else {
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp26_ = FALSE;
#line 690 "rygel-searchable-container.c"
			}
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp32_ = _data_->_tmp26_;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp32_) {
#line 98 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child);
#line 98 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 700 "rygel-searchable-container.c"
			}
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->child);
#line 704 "rygel-searchable-container.c"
		}
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_child_list);
#line 708 "rygel-searchable-container.c"
	}
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp34_ = _data_->limit;
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp34_ == ((guint) 0)) {
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp33_ = TRUE;
#line 716 "rygel-searchable-container.c"
	} else {
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp35_ = _data_->_result_;
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp36_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp35_);
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp37_ = _data_->_tmp36_;
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp38_ = _data_->limit;
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp33_ = ((guint) _data_->_tmp37_) < _data_->_tmp38_;
#line 728 "rygel-searchable-container.c"
	}
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp39_ = _data_->_tmp33_;
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp39_) {
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp41_ = _data_->limit;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_tmp41_ == ((guint) 0)) {
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp40_ = (guint) 0;
#line 740 "rygel-searchable-container.c"
		} else {
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp42_ = _data_->limit;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp43_ = _data_->_result_;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp43_);
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp45_ = _data_->_tmp44_;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp40_ = _data_->_tmp42_ - _data_->_tmp45_;
#line 752 "rygel-searchable-container.c"
		}
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp46_ = _data_->_tmp40_;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->child_limit = _data_->_tmp46_;
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp47_ = _data_->expression;
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp48_ = _data_->children;
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp49_ = _data_->child_limit;
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp50_ = _data_->cancellable;
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_state_ = 2;
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		rygel_searchable_container_search_in_children (_data_->self, _data_->_tmp47_, _data_->_tmp48_, _data_->_tmp49_, _data_->_tmp50_, rygel_searchable_container_simple_search_ready, _data_);
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 772 "rygel-searchable-container.c"
		_state_2:
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp51_ = NULL;
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp51_ = rygel_searchable_container_search_in_children_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->child_results = _data_->_tmp51_;
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_error_free (_data_->_inner_error_);
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->children);
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->_result_);
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_state_ == 0) {
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 794 "rygel-searchable-container.c"
			} else {
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 798 "rygel-searchable-container.c"
			}
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_object_unref (_data_->_async_result);
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			return FALSE;
#line 804 "rygel-searchable-container.c"
		}
#line 110 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp52_ = _data_->_result_;
#line 110 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp53_ = _data_->child_results;
#line 110 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		gee_abstract_collection_add_all ((GeeAbstractCollection*) _data_->_tmp52_, (GeeCollection*) _data_->_tmp53_);
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->child_results);
#line 814 "rygel-searchable-container.c"
	}
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp54_ = _data_->max_count;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp54_ > ((guint) 0)) {
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->total_matches = (guint) 0;
#line 822 "rygel-searchable-container.c"
	} else {
#line 118 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp55_ = _data_->_result_;
#line 118 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp56_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp55_);
#line 118 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp57_ = _data_->_tmp56_;
#line 118 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->total_matches = (guint) _data_->_tmp57_;
#line 832 "rygel-searchable-container.c"
	}
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp58_ = _data_->offset;
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp59_ = _data_->_result_;
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp60_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp59_);
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp61_ = _data_->_tmp60_;
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp58_ >= ((guint) _data_->_tmp61_)) {
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp62_ = media_objects_new ();
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->result = _data_->_tmp62_;
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->children);
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 856 "rygel-searchable-container.c"
		} else {
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 860 "rygel-searchable-container.c"
		}
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 866 "rygel-searchable-container.c"
	}
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp64_ = _data_->_result_;
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp65_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp64_);
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp66_ = _data_->_tmp65_;
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp66_ > 0) {
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp68_ = _data_->max_count;
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_tmp68_ > ((guint) 0)) {
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp67_ = TRUE;
#line 882 "rygel-searchable-container.c"
		} else {
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp69_ = _data_->offset;
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp67_ = _data_->_tmp69_ > ((guint) 0);
#line 888 "rygel-searchable-container.c"
		}
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp70_ = _data_->_tmp67_;
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp63_ = _data_->_tmp70_;
#line 894 "rygel-searchable-container.c"
	} else {
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp63_ = FALSE;
#line 898 "rygel-searchable-container.c"
	}
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp71_ = _data_->_tmp63_;
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp71_) {
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp73_ = _data_->max_count;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_tmp73_ != ((guint) 0)) {
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp74_ = _data_->offset;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp75_ = _data_->max_count;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp76_ = _data_->_result_;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp77_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp76_);
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp78_ = _data_->_tmp77_;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp72_ = (_data_->_tmp74_ + _data_->_tmp75_) <= ((guint) _data_->_tmp78_);
#line 920 "rygel-searchable-container.c"
		} else {
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp72_ = FALSE;
#line 924 "rygel-searchable-container.c"
		}
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp79_ = _data_->_tmp72_;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_tmp79_) {
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp80_ = _data_->offset;
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp81_ = _data_->max_count;
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->stop = _data_->_tmp80_ + _data_->_tmp81_;
#line 936 "rygel-searchable-container.c"
		} else {
#line 132 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp82_ = _data_->_result_;
#line 132 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp83_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp82_);
#line 132 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp84_ = _data_->_tmp83_;
#line 132 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->stop = (guint) _data_->_tmp84_;
#line 946 "rygel-searchable-container.c"
		}
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp85_ = _data_->_result_;
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp86_ = _data_->offset;
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp87_ = _data_->stop;
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp88_ = NULL;
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp88_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp85_, (gint) _data_->_tmp86_, (gint) _data_->_tmp87_);
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->result = IS_MEDIA_OBJECTS (_data_->_tmp88_) ? ((MediaObjects*) _data_->_tmp88_) : NULL;
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->children);
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 968 "rygel-searchable-container.c"
		} else {
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 972 "rygel-searchable-container.c"
		}
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 978 "rygel-searchable-container.c"
	}
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = _data_->_result_;
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 988 "rygel-searchable-container.c"
	} else {
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 992 "rygel-searchable-container.c"
	}
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->_result_);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1006 "rygel-searchable-container.c"
	} else {
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1010 "rygel-searchable-container.c"
	}
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 1016 "rygel-searchable-container.c"
}


static void rygel_searchable_container_find_object_data_free (gpointer _data) {
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (_data_->id);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerFindObjectData, _data_);
#line 1033 "rygel-searchable-container.c"
}


void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
	RygelSearchableContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerFindObjectData);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_searchable_container_find_object);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_find_object_data_free);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp1_ = id;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->id = _tmp2_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp3_ = cancellable;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->cancellable = _tmp4_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_find_object_co (_data_);
#line 1068 "rygel-searchable-container.c"
}


MediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	MediaObject* result;
	RygelSearchableContainerFindObjectData* _data_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return NULL;
#line 1079 "rygel-searchable-container.c"
	}
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return result;
#line 1089 "rygel-searchable-container.c"
}


/**
     * Recursively searches for media object with the given id in this
     * container.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     * @param callback function to call when result is ready
     *
     * return the found media object.
     */
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_find_object_co (_data_);
#line 1113 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_) {
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 0:
#line 1122 "rygel-searchable-container.c"
		goto _state_0;
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 1:
#line 1126 "rygel-searchable-container.c"
		goto _state_1;
		default:
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 1131 "rygel-searchable-container.c"
	}
	_state_0:
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp0_ = relational_expression_new ();
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->expression = _data_->_tmp0_;
#line 155 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp1_ = g_strdup (SEARCH_CRITERIA_OP_EQ);
#line 155 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (((SearchExpression*) _data_->expression)->op);
#line 155 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	((SearchExpression*) _data_->expression)->op = _data_->_tmp1_;
#line 156 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp2_ = g_strdup ("@id");
#line 156 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (((SearchExpression*) _data_->expression)->operand1);
#line 156 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	((SearchExpression*) _data_->expression)->operand1 = _data_->_tmp2_;
#line 157 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp3_ = _data_->id;
#line 157 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 157 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (((SearchExpression*) _data_->expression)->operand2);
#line 157 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	((SearchExpression*) _data_->expression)->operand2 = _data_->_tmp4_;
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp5_ = _data_->cancellable;
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp6_ = 0U;
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_state_ = 1;
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_search (_data_->self, (SearchExpression*) _data_->expression, (guint) 0, (guint) 1, _data_->_tmp5_, rygel_searchable_container_find_object_ready, _data_);
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 1168 "rygel-searchable-container.c"
	_state_1:
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp7_ = NULL;
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp7_ = rygel_searchable_container_search_finish (_data_->self, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->total_matches = _data_->_tmp6_;
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->results = _data_->_tmp7_;
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_error_free (_data_->_inner_error_);
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->expression);
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1190 "rygel-searchable-container.c"
		} else {
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1194 "rygel-searchable-container.c"
		}
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 160 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 1200 "rygel-searchable-container.c"
	}
#line 165 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->results);
#line 165 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 165 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp9_ > 0) {
#line 166 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp10_ = NULL;
#line 166 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _data_->results, 0);
#line 166 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->result = (MediaObject*) _data_->_tmp10_;
#line 166 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->results);
#line 166 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->expression);
#line 166 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 166 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1222 "rygel-searchable-container.c"
		} else {
#line 166 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1226 "rygel-searchable-container.c"
		}
#line 166 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 166 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 1232 "rygel-searchable-container.c"
	} else {
#line 168 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->result = NULL;
#line 168 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->results);
#line 168 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->expression);
#line 168 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 168 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1244 "rygel-searchable-container.c"
		} else {
#line 168 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1248 "rygel-searchable-container.c"
		}
#line 168 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 168 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 1254 "rygel-searchable-container.c"
	}
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->results);
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->expression);
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1264 "rygel-searchable-container.c"
	} else {
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1268 "rygel-searchable-container.c"
	}
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 1274 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children_data_free (gpointer _data) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->expression);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerSearchInChildrenData, _data_);
#line 1293 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, SearchExpression* expression, MediaObjects* children, guint limit, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	RygelSearchableContainer* _tmp0_;
	SearchExpression* _tmp1_;
	SearchExpression* _tmp2_;
	MediaObjects* _tmp3_;
	MediaObjects* _tmp4_;
	guint _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerSearchInChildrenData);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_searchable_container_search_in_children);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_search_in_children_data_free);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp1_ = expression;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->expression = _tmp2_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp3_ = children;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->children = _tmp4_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp5_ = limit;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->limit = _tmp5_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp6_ = cancellable;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->cancellable = _tmp7_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_search_in_children_co (_data_);
#line 1341 "rygel-searchable-container.c"
}


static MediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	MediaObjects* result;
	RygelSearchableContainerSearchInChildrenData* _data_;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return NULL;
#line 1352 "rygel-searchable-container.c"
	}
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return result;
#line 1362 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_search_in_children_co (_data_);
#line 1376 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_) {
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 0:
#line 1385 "rygel-searchable-container.c"
		goto _state_0;
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 1:
#line 1389 "rygel-searchable-container.c"
		goto _state_1;
		default:
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 1394 "rygel-searchable-container.c"
	}
	_state_0:
#line 177 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp0_ = media_objects_new ();
#line 177 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 1401 "rygel-searchable-container.c"
	{
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp1_ = _data_->children;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_list = _data_->_tmp2_;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp3_ = _data_->_child_list;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_size = _data_->_tmp5_;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_index = -1;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		while (TRUE) {
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp6_ = _data_->_child_index;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_child_index = _data_->_tmp6_ + 1;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp7_ = _data_->_child_index;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp8_ = _data_->_child_size;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 1433 "rygel-searchable-container.c"
			}
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp9_ = _data_->_child_list;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp10_ = _data_->_child_index;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp11_ = NULL;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->child = (MediaObject*) _data_->_tmp11_;
#line 180 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp12_ = _data_->child;
#line 180 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (RYGEL_IS_SEARCHABLE_CONTAINER (_data_->_tmp12_)) {
#line 181 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp13_ = _data_->child;
#line 181 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp14_ = _g_object_ref0 (RYGEL_IS_SEARCHABLE_CONTAINER (_data_->_tmp13_) ? ((RygelSearchableContainer*) _data_->_tmp13_) : NULL);
#line 181 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->container = _data_->_tmp14_;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp15_ = _data_->container;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp16_ = _data_->expression;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp17_ = _data_->limit;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp18_ = _data_->cancellable;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp19_ = 0U;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_state_ = 1;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				rygel_searchable_container_search (_data_->_tmp15_, _data_->_tmp16_, (guint) 0, _data_->_tmp17_, _data_->_tmp18_, rygel_searchable_container_search_in_children_ready, _data_);
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				return FALSE;
#line 1471 "rygel-searchable-container.c"
				_state_1:
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp20_ = NULL;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp20_ = rygel_searchable_container_search_finish (_data_->_tmp15_, _data_->_res_, &_data_->_tmp19_, &_data_->_inner_error_);
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->tmp = _data_->_tmp19_;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->child_result = _data_->_tmp20_;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				if (_data_->_inner_error_ != NULL) {
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					g_error_free (_data_->_inner_error_);
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->container);
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->child);
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->_child_list);
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->_result_);
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					if (_data_->_state_ == 0) {
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1499 "rygel-searchable-container.c"
					} else {
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 1503 "rygel-searchable-container.c"
					}
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					g_object_unref (_data_->_async_result);
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					return FALSE;
#line 1509 "rygel-searchable-container.c"
				}
#line 190 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp21_ = _data_->_result_;
#line 190 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp22_ = _data_->child_result;
#line 190 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				gee_abstract_collection_add_all ((GeeAbstractCollection*) _data_->_tmp21_, (GeeCollection*) _data_->_tmp22_);
#line 180 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child_result);
#line 180 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->container);
#line 1521 "rygel-searchable-container.c"
			}
#line 193 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp24_ = _data_->limit;
#line 193 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp24_ > ((guint) 0)) {
#line 193 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp25_ = _data_->_result_;
#line 193 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp25_);
#line 193 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp27_ = _data_->_tmp26_;
#line 193 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp28_ = _data_->limit;
#line 193 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp23_ = ((guint) _data_->_tmp27_) >= _data_->_tmp28_;
#line 1537 "rygel-searchable-container.c"
			} else {
#line 193 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp23_ = FALSE;
#line 1541 "rygel-searchable-container.c"
			}
#line 193 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp29_ = _data_->_tmp23_;
#line 193 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp29_) {
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child);
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 1551 "rygel-searchable-container.c"
			}
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->child);
#line 1555 "rygel-searchable-container.c"
		}
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_child_list);
#line 1559 "rygel-searchable-container.c"
	}
#line 198 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = _data_->_result_;
#line 198 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 198 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1567 "rygel-searchable-container.c"
	} else {
#line 198 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1571 "rygel-searchable-container.c"
	}
#line 198 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 198 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->_result_);
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1583 "rygel-searchable-container.c"
	} else {
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1587 "rygel-searchable-container.c"
	}
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 1593 "rygel-searchable-container.c"
}


void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container) {
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_return_if_fail (didl_container != NULL);
#line 1600 "rygel-searchable-container.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _search_class_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _search_class_size;
		gint _search_class_index;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp0_ = rygel_searchable_container_get_search_classes (self);
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp1_ = _tmp0_;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_search_class_list = _tmp2_;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp3_ = _search_class_list;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp5_ = _tmp4_;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_search_class_size = _tmp5_;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_search_class_index = -1;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		while (TRUE) {
#line 1631 "rygel-searchable-container.c"
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			gchar* search_class;
			GUPnPDIDLLiteContainer* _tmp12_;
			const gchar* _tmp13_;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp6_ = _search_class_index;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_search_class_index = _tmp6_ + 1;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp7_ = _search_class_index;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp8_ = _search_class_size;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 1653 "rygel-searchable-container.c"
			}
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp9_ = _search_class_list;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp10_ = _search_class_index;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			search_class = (gchar*) _tmp11_;
#line 204 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp12_ = didl_container;
#line 204 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp13_ = search_class;
#line 204 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			gupnp_didl_lite_container_add_search_class (_tmp12_, _tmp13_);
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_free0 (search_class);
#line 1671 "rygel-searchable-container.c"
		}
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_search_class_list);
#line 1675 "rygel-searchable-container.c"
	}
}


GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self) {
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->get_search_classes (self);
#line 1685 "rygel-searchable-container.c"
}


void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value) {
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_return_if_fail (self != NULL);
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->set_search_classes (self, value);
#line 1694 "rygel-searchable-container.c"
}


static void rygel_searchable_container_base_init (RygelSearchableContainerIface * iface) {
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	static gboolean initialized = FALSE;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (!initialized) {
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		initialized = TRUE;
#line 29 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1707 "rygel-searchable-container.c"
	}
}


GType rygel_searchable_container_get_type (void) {
	static volatile gsize rygel_searchable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_searchable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchableContainerIface), (GBaseInitFunc) rygel_searchable_container_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_searchable_container_type_id;
		rygel_searchable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelSearchableContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_searchable_container_type_id, TYPE_MEDIA_CONTAINER);
		g_once_init_leave (&rygel_searchable_container_type_id__volatile, rygel_searchable_container_type_id);
	}
	return rygel_searchable_container_type_id__volatile;
}



