/**
 * SECTION:rygel-media-container
 * @short_description: Represents a container (folder) for media items and containers. Provides basic serialization (to DIDLLiteWriter) implementation. Deriving classes are supposed to provide working implementations of get_children.
 */
/**
 * RYGEL_TYPE_MEDIA_CONTAINER
 * 
 * The type for <link linkend="RygelMediaContainer"><type>RygelMediaContainer</type></link>.
 */
/**
 * rygel_media_container_get_children
 * @self: the <link linkend="RygelMediaContainer"><type>RygelMediaContainer</type></link> instance
 * @offset: (in): zero-based index of the first item to return 
 * @max_count: (in): maximum number of objects to return 
 * @sort_criteria: (in): sorting order of objects to return 
 * @cancellable: (in) (allow-none): optional cancellable for this operation 
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Fetches the list of media objects directly under this container.
 * 
 * <emphasis>See also</emphasis>: <link linkend="rygel-media-container-get-children-finish"><function>rygel_media_container_get_children_finish()</function></link>
 */
/**
 * rygel_media_container_get_children_finish
 * @self: the <link linkend="RygelMediaContainer"><type>RygelMediaContainer</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occuring, or %NULL to ignore
 * 
 * Fetches the list of media objects directly under this container.
 * 
 * <emphasis>See also</emphasis>: <link linkend="rygel-media-container-get-children"><function>rygel_media_container_get_children()</function></link>
 * 
 * Returns: A list of media objects. 
 */
/**
 * rygel_media_container_find_object
 * @self: the <link linkend="RygelMediaContainer"><type>RygelMediaContainer</type></link> instance
 * @id: (in): ID of the media object to search for 
 * @cancellable: (in) (allow-none): optional cancellable for this operation 
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Recursively searches for media object with the given id in this container.
 * 
 * <emphasis>See also</emphasis>: <link linkend="rygel-media-container-find-object-finish"><function>rygel_media_container_find_object_finish()</function></link>
 */
/**
 * rygel_media_container_find_object_finish
 * @self: the <link linkend="RygelMediaContainer"><type>RygelMediaContainer</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occuring, or %NULL to ignore
 * 
 * Recursively searches for media object with the given id in this container.
 * 
 * <emphasis>See also</emphasis>: <link linkend="rygel-media-container-find-object"><function>rygel_media_container_find_object()</function></link>
 * 
 * Returns: the found media object. 
 */
/**
 * rygel_media_container_updated
 * @self: the <link linkend="RygelMediaContainer"><type>RygelMediaContainer</type></link> instance
 * 
 * Method to be be called each time this container is updated (metadata changes for this container, items under it gets removed/added or their metadata changes etc).
 */
/**
 * RYGEL_MEDIA_CONTAINER_UPNP_CLASS
 */
/**
 * RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER
 */
/**
 * RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM
 */
/**
 * RYGEL_MEDIA_CONTAINER_MUSIC_ARTIST
 */
/**
 * RYGEL_MEDIA_CONTAINER_MUSIC_GENRE
 */
/**
 * RYGEL_MEDIA_CONTAINER_ALBUM_SORT_CRITERIA
 */
/**
 * RygelMediaContainer:sort-criteria
 */
/**
 * rygel_media_container_get_sort_criteria
 * @self: the <link linkend="RygelMediaContainer"><type>RygelMediaContainer</type></link> instance to query
 * 
 * Returns: the value of the <link linkend="RygelMediaContainer--sort-criteria"><type>"sort-criteria"</type></link> property
 */
/**
 * rygel_media_container_set_sort_criteria
 * @self: the <link linkend="RygelMediaContainer"><type>RygelMediaContainer</type></link> instance to modify
 * @value: the new value of the <link linkend="RygelMediaContainer--sort-criteria"><type>"sort-criteria"</type></link> property
 */
/**
 * RygelMediaContainer::container-updated
 * @media_container: the <link linkend="RygelMediaContainer"><type>RygelMediaContainer</type></link> instance that received the signal
 * @container: the container that just got updated. <para></para>
 * 
 * container_updated signal that is emitted if a child container under the tree of this container gets updated.
 */
/**
 * RygelMediaContainer
 * 
 * Represents a container (folder) for media items and containers. Provides basic serialization (to DIDLLiteWriter) implementation. Deriving classes are supposed to provide working implementations of get_children.
 */
