/**
 * SECTION:rygel-writable-container
 * @short_description: Interface to be implemented by 'writable' container: ones that allow creation, removal and editing of items directly under them. Currently, only addition and removal is supported.
 * 
 * <para>In addition to implementing this interface, a writable container must also:</para><para>1. Provide one URI that points to a writable folder on a GIO supported filesystem. 2. Monitor not only it's own URI but also that of it's child items, though the latter is implied in the former if you use GIO for monitoring.</para>
 */
/**
 * rygel_writable_container_can_create
 * @self: the <link linkend="RygelWritableContainer"><type>RygelWritableContainer</type></link> instance
 * @upnp_class: (in): The class of an item to check 
 * 
 * Check if this container claims to be able to create an item with the given upnp class.
 * 
 * Returns: true if it can, false, if not.¨ 
 */
/**
 * rygel_writable_container_add_item
 * @self: the <link linkend="RygelWritableContainer"><type>RygelWritableContainer</type></link> instance
 * @item: (in): The item to add to this container 
 * @cancellable: (in) (allow-none): optional cancellable for this operation 
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Add a new item directly under this container.
 * 
 * <para>This doesn't imply creation of file(s) pointed to by item's URI(s), that is handled for you.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="rygel-writable-container-add-item-finish"><function>rygel_writable_container_add_item_finish()</function></link>
 */
/**
 * rygel_writable_container_add_item_finish
 * @self: the <link linkend="RygelWritableContainer"><type>RygelWritableContainer</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occuring, or %NULL to ignore
 * 
 * Add a new item directly under this container.
 * 
 * <para>This doesn't imply creation of file(s) pointed to by item's URI(s), that is handled for you.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="rygel-writable-container-add-item"><function>rygel_writable_container_add_item()</function></link>
 * 
 * Returns: nothing. 
 */
/**
 * rygel_writable_container_remove_item
 * @self: the <link linkend="RygelWritableContainer"><type>RygelWritableContainer</type></link> instance
 * @id: (in): The ID of the item to remove from this container 
 * @cancellable: (in) (allow-none): optional cancellable for this operation 
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Remove an item directly under this container that has the ID @id.
 * 
 * <para>This doesn't imply deletion of file(s) pointed to by item's URI(s), that is handled for you.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="rygel-writable-container-remove-item-finish"><function>rygel_writable_container_remove_item_finish()</function></link>
 */
/**
 * rygel_writable_container_remove_item_finish
 * @self: the <link linkend="RygelWritableContainer"><type>RygelWritableContainer</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occuring, or %NULL to ignore
 * 
 * Remove an item directly under this container that has the ID @id.
 * 
 * <para>This doesn't imply deletion of file(s) pointed to by item's URI(s), that is handled for you.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="rygel-writable-container-remove-item"><function>rygel_writable_container_remove_item()</function></link>
 * 
 * Returns: nothing. 
 */
/**
 * RygelWritableContainer:create-classes
 */
/**
 * rygel_writable_container_get_create_classes
 * @self: the <link linkend="RygelWritableContainer"><type>RygelWritableContainer</type></link> instance to query
 * 
 * Returns: the value of the <link linkend="RygelWritableContainer--create-classes"><type>"create-classes"</type></link> property
 */
/**
 * rygel_writable_container_set_create_classes
 * @self: the <link linkend="RygelWritableContainer"><type>RygelWritableContainer</type></link> instance to modify
 * @value: the new value of the <link linkend="RygelWritableContainer--create-classes"><type>"create-classes"</type></link> property
 */
/**
 * RygelWritableContainer
 * 
 * Interface to be implemented by 'writable' container: ones that allow creation, removal and editing of items directly under them. Currently, only addition and removal is supported.
 * 
 * <para>In addition to implementing this interface, a writable container must also:</para><para>1. Provide one URI that points to a writable folder on a GIO supported filesystem. 2. Monitor not only it's own URI but also that of it's child items, though the latter is implied in the former if you use GIO for monitoring.</para>
 */
