/* rygel-playbin-player.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-playbin-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010,2011,2012 Nokia Corporation.
 * Copyright (C) 2012 Openismus GmbH
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;

#define RYGEL_PLAYBIN_TYPE_PLAYER (rygel_playbin_player_get_type ())
#define RYGEL_PLAYBIN_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer))
#define RYGEL_PLAYBIN_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))
#define RYGEL_PLAYBIN_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))

typedef struct _RygelPlaybinPlayer RygelPlaybinPlayer;
typedef struct _RygelPlaybinPlayerClass RygelPlaybinPlayerClass;
typedef struct _RygelPlaybinPlayerPrivate RygelPlaybinPlayerPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, GstClockTime time);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
};

struct _RygelPlaybinPlayer {
	GObject parent_instance;
	RygelPlaybinPlayerPrivate * priv;
};

struct _RygelPlaybinPlayerClass {
	GObjectClass parent_class;
};

struct _RygelPlaybinPlayerPrivate {
	GstElement* _playbin;
	gchar* _playback_state;
	gchar* transfer_mode;
	gboolean uri_update_hint;
	gchar* _uri;
	gchar* _mime_type;
	gchar* _metadata;
	gchar* _content_features;
	GUPnPProtocolInfo* protocol_info;
};


static gpointer rygel_playbin_player_parent_class = NULL;
static RygelPlaybinPlayer* rygel_playbin_player_player;
static RygelPlaybinPlayer* rygel_playbin_player_player = NULL;
static RygelMediaPlayerIface* rygel_playbin_player_rygel_media_player_parent_iface = NULL;

GType rygel_media_player_get_type (void) G_GNUC_CONST;
GType rygel_playbin_player_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAYBIN_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerPrivate))
enum  {
	RYGEL_PLAYBIN_PLAYER_DUMMY_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_PLAYBIN,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE,
	RYGEL_PLAYBIN_PLAYER_URI,
	RYGEL_PLAYBIN_PLAYER_MIME_TYPE,
	RYGEL_PLAYBIN_PLAYER_METADATA,
	RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES,
	RYGEL_PLAYBIN_PLAYER_VOLUME,
	RYGEL_PLAYBIN_PLAYER_DURATION,
	RYGEL_PLAYBIN_PLAYER_POSITION
};
#define RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_STREAMING "Streaming"
#define RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE "Interactive"
#define RYGEL_PLAYBIN_PLAYER_PROTOCOL_INFO_TEMPLATE "http-get:%s:*:%s"
static RygelPlaybinPlayer* rygel_playbin_player_new (void);
static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type);
static void rygel_playbin_player_set_playbin (RygelPlaybinPlayer* self, GstElement* value);
static void rygel_playbin_player_setup_playbin (RygelPlaybinPlayer* self);
RygelPlaybinPlayer* rygel_playbin_player_new_wrap (GstElement* playbin);
RygelPlaybinPlayer* rygel_playbin_player_construct_wrap (GType object_type, GstElement* playbin);
RygelPlaybinPlayer* rygel_playbin_player_get_default (void);
static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, GstClockTime time);
GstElement* rygel_playbin_player_get_playbin (RygelPlaybinPlayer* self);
static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gboolean rygel_playbin_player_is_rendering_image (RygelPlaybinPlayer* self);
static inline GstCaps* _dynamic_get_caps0 (GstElement* obj);
static void rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message);
static inline gchar* _dynamic_get_uri1 (GstElement* obj);
static inline gchar* _dynamic_get_uri2 (GstElement* obj);
static gchar* rygel_playbin_player_generate_basic_didl (RygelPlaybinPlayer* self);
void rygel_media_player_set_metadata (RygelMediaPlayer* self, const gchar* value);
void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value);
static void rygel_playbin_player_on_source_setup (RygelPlaybinPlayer* self, GstElement* pipeline, GstElement* source);
static inline void _dynamic_set_extra_headers3 (GstElement* obj, const GstStructure* value);
static void rygel_playbin_player_on_uri_notify (RygelPlaybinPlayer* self, GParamSpec* pspec);
gchar* rygel_media_player_get_uri (RygelMediaPlayer* self);
static inline void _dynamic_set_auto_flush_bus4 (GstElement* obj, gboolean value);
static void _rygel_playbin_player_on_source_setup_dynamic_source_setup0_ (GstElement* _sender, GstElement* source, gpointer self);
void _dynamic_source_setup1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data);
static void _rygel_playbin_player_on_uri_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _rygel_playbin_player_bus_handler_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static inline void _dynamic_set_uri5 (GstElement* obj, const gchar* value);
gchar* rygel_media_player_get_mime_type (RygelMediaPlayer* self);
static inline gdouble _dynamic_get_volume6 (GstElement* obj);
static inline void _dynamic_set_volume7 (GstElement* obj, gdouble value);
static void rygel_playbin_player_finalize (GObject* obj);
gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self);
gchar* rygel_media_player_get_metadata (RygelMediaPlayer* self);
gchar* rygel_media_player_get_content_features (RygelMediaPlayer* self);
gdouble rygel_media_player_get_volume (RygelMediaPlayer* self);
gint64 rygel_media_player_get_duration (RygelMediaPlayer* self);
gint64 rygel_media_player_get_position (RygelMediaPlayer* self);
static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value);
void rygel_media_player_set_mime_type (RygelMediaPlayer* self, const gchar* value);
void rygel_media_player_set_content_features (RygelMediaPlayer* self, const gchar* value);
void rygel_media_player_set_volume (RygelMediaPlayer* self, gdouble value);
static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* RYGEL_PLAYBIN_PLAYER_protocols[2] = {"http-get", "rtsp"};
static const gchar* RYGEL_PLAYBIN_PLAYER_mime_types[38] = {"audio/mpeg", "application/ogg", "audio/x-vorbis", "audio/x-vorbis+ogg", "audio/ogg", "audio/x-ms-wma", "audio/x-ms-asf", "audio/x-flac", "audio/x-flac+ogg", "audio/flac", "audio/x-mod", "audio/x-wav", "audio/x-ac3", "audio/x-m4a", "audio/L16;rate=44100;channels=2", "audio/L16;rate=44100;channels=1", "audio/L16;channels=2;rate=44100", "audio/L16;channels=1;rate=44100", "audio/L16;rate=44100", "image/jpeg", "image/png", "video/x-theora", "video/x-theora+ogg", "video/x-oggm", "video/ogg", "video/x-dirac", "video/x-wmv", "video/x-wma", "video/x-msvideo", "video/x-3ivx", "video/x-3ivx", "video/x-matroska", "video/x-mkv", "video/mpeg", "video/mp4", "video/x-ms-asf", "video/x-xvid", "video/x-ms-wmv"};

static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type) {
	RygelPlaybinPlayer * self = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) g_object_new (object_type, NULL);
#line 251 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = gst_element_factory_make ("playbin2", NULL);
#line 251 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	if (_tmp0_ != NULL) {
#line 251 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		gst_object_ref_sink (_tmp0_);
#line 196 "rygel-playbin-player.c"
	}
#line 251 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_;
#line 251 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	rygel_playbin_player_set_playbin (self, _tmp1_);
#line 251 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_gst_object_unref0 (_tmp1_);
#line 252 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	rygel_playbin_player_setup_playbin (self);
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return self;
#line 208 "rygel-playbin-player.c"
}


static RygelPlaybinPlayer* rygel_playbin_player_new (void) {
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return rygel_playbin_player_construct (RYGEL_PLAYBIN_TYPE_PLAYER);
#line 215 "rygel-playbin-player.c"
}


RygelPlaybinPlayer* rygel_playbin_player_construct_wrap (GType object_type, GstElement* playbin) {
	RygelPlaybinPlayer * self = NULL;
	GstElement* _tmp0_;
#line 255 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_return_val_if_fail (playbin != NULL, NULL);
#line 255 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) g_object_new (object_type, NULL);
#line 256 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = playbin;
#line 256 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	rygel_playbin_player_set_playbin (self, _tmp0_);
#line 257 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	rygel_playbin_player_setup_playbin (self);
#line 255 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return self;
#line 234 "rygel-playbin-player.c"
}


RygelPlaybinPlayer* rygel_playbin_player_new_wrap (GstElement* playbin) {
#line 255 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return rygel_playbin_player_construct_wrap (RYGEL_PLAYBIN_TYPE_PLAYER, playbin);
#line 241 "rygel-playbin-player.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 265 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return self ? g_object_ref (self) : NULL;
#line 248 "rygel-playbin-player.c"
}


RygelPlaybinPlayer* rygel_playbin_player_get_default (void) {
	RygelPlaybinPlayer* result = NULL;
	RygelPlaybinPlayer* _tmp0_;
	RygelPlaybinPlayer* _tmp2_;
	RygelPlaybinPlayer* _tmp3_;
#line 261 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = rygel_playbin_player_player;
#line 261 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	if (_tmp0_ == NULL) {
#line 261 "rygel-playbin-player.c"
		RygelPlaybinPlayer* _tmp1_;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp1_ = rygel_playbin_player_new ();
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_g_object_unref0 (rygel_playbin_player_player);
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		rygel_playbin_player_player = _tmp1_;
#line 269 "rygel-playbin-player.c"
	}
#line 265 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp2_ = rygel_playbin_player_player;
#line 265 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 265 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = _tmp3_;
#line 265 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 279 "rygel-playbin-player.c"
}


static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, GstClockTime time) {
	RygelPlaybinPlayer * self;
	gboolean result = FALSE;
	GstElement* _tmp0_;
	GstClockTime _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 268 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 269 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 269 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = time;
#line 269 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp2_ = gst_element_seek (_tmp0_, 1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, (gint64) _tmp1_, GST_SEEK_TYPE_NONE, (gint64) (-1));
#line 269 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = _tmp2_;
#line 269 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 301 "rygel-playbin-player.c"
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = g_new0 (gchar*, length + 1);
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	for (i = 0; i < length; i++) {
#line 312 "rygel-playbin-player.c"
		gchar* _tmp0_;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp0_ = g_strdup (self[i]);
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		result[i] = _tmp0_;
#line 318 "rygel-playbin-player.c"
	}
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 322 "rygel-playbin-player.c"
}


static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 278 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = (RYGEL_PLAYBIN_PLAYER_protocols != NULL) ? _vala_array_dup1 (RYGEL_PLAYBIN_PLAYER_protocols, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols)) : ((gpointer) RYGEL_PLAYBIN_PLAYER_protocols);
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols);
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1__length1 = _tmp0__length1;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	if (result_length1) {
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		*result_length1 = _tmp1__length1;
#line 347 "rygel-playbin-player.c"
	}
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = _tmp1_;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 353 "rygel-playbin-player.c"
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = g_new0 (gchar*, length + 1);
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	for (i = 0; i < length; i++) {
#line 364 "rygel-playbin-player.c"
		gchar* _tmp0_;
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp0_ = g_strdup (self[i]);
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		result[i] = _tmp0_;
#line 370 "rygel-playbin-player.c"
	}
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 374 "rygel-playbin-player.c"
}


static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 282 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = (RYGEL_PLAYBIN_PLAYER_mime_types != NULL) ? _vala_array_dup2 (RYGEL_PLAYBIN_PLAYER_mime_types, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types)) : ((gpointer) RYGEL_PLAYBIN_PLAYER_mime_types);
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types);
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_;
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1__length1 = _tmp0__length1;
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	if (result_length1) {
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		*result_length1 = _tmp1__length1;
#line 399 "rygel-playbin-player.c"
	}
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = _tmp1_;
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 405 "rygel-playbin-player.c"
}


static inline GstCaps* _dynamic_get_caps0 (GstElement* obj) {
	GstCaps* result;
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_get (obj, "caps", &result, NULL);
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 415 "rygel-playbin-player.c"
}


static gpointer _gst_structure_copy0 (gpointer self) {
#line 291 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return self ? gst_structure_copy (self) : NULL;
#line 422 "rygel-playbin-player.c"
}


static gboolean rygel_playbin_player_is_rendering_image (RygelPlaybinPlayer* self) {
	gboolean result = FALSE;
	GstElement* typefind = NULL;
	GstElement* _tmp0_;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_;
	GstCaps* _tmp3_;
	GstCaps* _tmp4_;
	GstCaps* caps;
	GstCaps* _tmp5_;
	const GstStructure* _tmp6_ = NULL;
	GstStructure* _tmp7_;
	GstStructure* structure;
	gboolean _tmp8_ = FALSE;
	const GstStructure* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp13_;
#line 286 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 289 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 289 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = gst_bin_get_by_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GST_TYPE_BIN) ? ((GstBin*) _tmp0_) : NULL, "typefind");
#line 289 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_gst_object_unref0 (typefind);
#line 289 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	typefind = _tmp1_;
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp2_ = typefind;
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp3_ = _dynamic_get_caps0 (_tmp2_);
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp4_ = _tmp3_;
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	caps = _tmp4_;
#line 291 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp5_ = caps;
#line 291 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp6_ = gst_caps_get_structure (_tmp5_, (guint) 0);
#line 291 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp7_ = _gst_structure_copy0 (_tmp6_);
#line 291 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	structure = _tmp7_;
#line 293 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp9_ = structure;
#line 293 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp10_ = gst_structure_get_name (_tmp9_);
#line 293 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	if (g_strcmp0 (_tmp10_, "image/jpeg") == 0) {
#line 293 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp8_ = TRUE;
#line 477 "rygel-playbin-player.c"
	} else {
		const GstStructure* _tmp11_;
		const gchar* _tmp12_ = NULL;
#line 294 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp11_ = structure;
#line 294 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp12_ = gst_structure_get_name (_tmp11_);
#line 294 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp8_ = g_strcmp0 (_tmp12_, "image/png") == 0;
#line 487 "rygel-playbin-player.c"
	}
#line 293 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp13_ = _tmp8_;
#line 293 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = _tmp13_;
#line 293 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_gst_structure_free0 (structure);
#line 293 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_gst_caps_unref0 (caps);
#line 293 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_gst_object_unref0 (typefind);
#line 293 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 501 "rygel-playbin-player.c"
}


static inline gchar* _dynamic_get_uri1 (GstElement* obj) {
	gchar* result;
#line 311 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_get (obj, "uri", &result, NULL);
#line 311 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 511 "rygel-playbin-player.c"
}


static inline gchar* _dynamic_get_uri2 (GstElement* obj) {
	gchar* result;
#line 314 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_get (obj, "uri", &result, NULL);
#line 314 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 521 "rygel-playbin-player.c"
}


static void rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message) {
	GstMessage* _tmp0_;
	GstMessageType _tmp1_;
#line 297 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 297 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_return_if_fail (bus != NULL);
#line 297 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_return_if_fail (message != NULL);
#line 299 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = message;
#line 299 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_->type;
#line 299 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	switch (_tmp1_) {
#line 299 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case GST_MESSAGE_STATE_CHANGED:
#line 542 "rygel-playbin-player.c"
		{
			GstMessage* _tmp2_;
			GstObject* _tmp3_;
			GstElement* _tmp4_;
#line 301 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_tmp2_ = message;
#line 301 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_tmp3_ = _tmp2_->src;
#line 301 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_tmp4_ = self->priv->_playbin;
#line 301 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GST_TYPE_OBJECT, GstObject)) {
#line 555 "rygel-playbin-player.c"
				GstState old_state = 0;
				GstState new_state = 0;
				GstState pending = 0;
				GstMessage* _tmp5_;
				GstState _tmp6_ = 0;
				GstState _tmp7_ = 0;
				GstState _tmp8_ = 0;
				gboolean _tmp9_ = FALSE;
				GstState _tmp10_;
				gboolean _tmp12_;
				GstState _tmp24_;
				GstState _tmp25_;
				GstState _tmp26_;
				GstState _tmp27_;
#line 304 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_tmp5_ = message;
#line 304 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				gst_message_parse_state_changed (_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
#line 304 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				old_state = _tmp6_;
#line 304 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				new_state = _tmp7_;
#line 304 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				pending = _tmp8_;
#line 307 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_tmp10_ = old_state;
#line 307 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				if (_tmp10_ == GST_STATE_READY) {
#line 584 "rygel-playbin-player.c"
					GstState _tmp11_;
#line 307 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp11_ = new_state;
#line 307 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp9_ = _tmp11_ == GST_STATE_PAUSED;
#line 590 "rygel-playbin-player.c"
				} else {
#line 307 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp9_ = FALSE;
#line 594 "rygel-playbin-player.c"
				}
#line 307 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_tmp12_ = _tmp9_;
#line 307 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				if (_tmp12_) {
#line 600 "rygel-playbin-player.c"
					gboolean _tmp13_;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					g_object_notify ((GObject*) self, "duration");
#line 309 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp13_ = self->priv->uri_update_hint;
#line 309 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					if (_tmp13_) {
#line 608 "rygel-playbin-player.c"
						GstElement* _tmp14_;
						gchar* _tmp15_;
						gchar* _tmp16_;
						gchar* uri;
						const gchar* _tmp17_;
						const gchar* _tmp18_;
#line 310 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
						self->priv->uri_update_hint = FALSE;
#line 311 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
						_tmp14_ = self->priv->_playbin;
#line 311 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
						_tmp15_ = _dynamic_get_uri1 (_tmp14_);
#line 311 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
						_tmp16_ = _tmp15_;
#line 311 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
						uri = _tmp16_;
#line 312 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
						_tmp17_ = self->priv->_uri;
#line 312 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
						_tmp18_ = uri;
#line 312 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
						if (g_strcmp0 (_tmp17_, _tmp18_) != 0) {
#line 631 "rygel-playbin-player.c"
							GstElement* _tmp19_;
							gchar* _tmp20_;
							gchar* _tmp21_;
							gchar* _tmp22_ = NULL;
							gchar* _tmp23_;
#line 314 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							_tmp19_ = self->priv->_playbin;
#line 314 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							_tmp20_ = _dynamic_get_uri2 (_tmp19_);
#line 314 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							_tmp21_ = _tmp20_;
#line 314 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							_g_free0 (self->priv->_uri);
#line 314 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							self->priv->_uri = _tmp21_;
#line 315 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							g_object_notify ((GObject*) self, "uri");
#line 316 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							_tmp22_ = rygel_playbin_player_generate_basic_didl (self);
#line 316 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							_tmp23_ = _tmp22_;
#line 316 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							rygel_media_player_set_metadata ((RygelMediaPlayer*) self, _tmp23_);
#line 316 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							_g_free0 (_tmp23_);
#line 657 "rygel-playbin-player.c"
						}
#line 309 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
						_g_free0 (uri);
#line 661 "rygel-playbin-player.c"
					}
				}
#line 321 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_tmp24_ = old_state;
#line 321 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_tmp25_ = new_state;
#line 321 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_tmp26_ = pending;
#line 321 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				g_debug ("rygel-playbin-player.vala:321: %d %d %d", (gint) _tmp24_, (gint) _tmp25_, (gint) _tmp26_);
#line 323 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_tmp27_ = pending;
#line 323 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				if (_tmp27_ == GST_STATE_VOID_PENDING) {
#line 676 "rygel-playbin-player.c"
					GstState _tmp28_;
#line 324 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp28_ = new_state;
#line 324 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					switch (_tmp28_) {
#line 324 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
						case GST_STATE_PAUSED:
#line 684 "rygel-playbin-player.c"
						{
#line 326 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PAUSED_PLAYBACK");
#line 327 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							break;
#line 690 "rygel-playbin-player.c"
						}
#line 324 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
						case GST_STATE_NULL:
#line 694 "rygel-playbin-player.c"
						{
#line 329 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
#line 330 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							break;
#line 700 "rygel-playbin-player.c"
						}
#line 324 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
						case GST_STATE_PLAYING:
#line 704 "rygel-playbin-player.c"
						{
#line 332 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PLAYING");
#line 333 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							break;
#line 710 "rygel-playbin-player.c"
						}
						default:
						{
#line 335 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
							break;
#line 716 "rygel-playbin-player.c"
						}
					}
				}
			}
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			break;
#line 723 "rygel-playbin-player.c"
		}
#line 299 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case GST_MESSAGE_EOS:
#line 727 "rygel-playbin-player.c"
		{
			gboolean _tmp29_ = FALSE;
#line 341 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_tmp29_ = rygel_playbin_player_is_rendering_image (self);
#line 341 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			if (!_tmp29_) {
#line 342 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				g_debug ("rygel-playbin-player.vala:342: EOS");
#line 343 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
#line 738 "rygel-playbin-player.c"
			} else {
#line 345 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				g_debug ("rygel-playbin-player.vala:345: Content is image, ignoring EOS");
#line 742 "rygel-playbin-player.c"
			}
#line 348 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			break;
#line 746 "rygel-playbin-player.c"
		}
#line 299 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case GST_MESSAGE_ERROR:
#line 750 "rygel-playbin-player.c"
		{
			GError* _error_ = NULL;
			gchar* error_message = NULL;
			GstMessage* _tmp30_;
			GError* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			GstElement* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			const gchar* _tmp37_;
#line 353 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_tmp30_ = message;
#line 353 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			gst_message_parse_error (_tmp30_, &_tmp31_, &_tmp32_);
#line 353 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_g_error_free0 (_error_);
#line 353 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_error_ = _tmp31_;
#line 353 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_g_free0 (error_message);
#line 353 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			error_message = _tmp32_;
#line 355 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_tmp33_ = self->priv->_playbin;
#line 355 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_tmp34_ = gst_object_get_name ((GstObject*) _tmp33_);
#line 355 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_tmp35_ = _tmp34_;
#line 355 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_tmp36_ = _tmp35_;
#line 355 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_tmp37_ = error_message;
#line 355 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			g_warning ("rygel-playbin-player.vala:355: Error from GStreamer element %s: %s", _tmp36_, _tmp37_);
#line 355 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_g_free0 (_tmp36_);
#line 358 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			g_warning ("rygel-playbin-player.vala:358: Going to STOPPED state");
#line 360 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
#line 362 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_g_free0 (error_message);
#line 362 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_g_error_free0 (_error_);
#line 362 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			break;
#line 798 "rygel-playbin-player.c"
		}
		default:
#line 299 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 803 "rygel-playbin-player.c"
	}
}


static inline void _dynamic_set_extra_headers3 (GstElement* obj, const GstStructure* value) {
#line 374 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_set (obj, "extra-headers", value, NULL);
#line 811 "rygel-playbin-player.c"
}


static void rygel_playbin_player_on_source_setup (RygelPlaybinPlayer* self, GstElement* pipeline, GstElement* source) {
	gboolean _tmp0_ = FALSE;
	GstElement* _tmp1_;
	GType _tmp2_ = 0UL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp5_;
#line 366 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 366 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_return_if_fail (pipeline != NULL);
#line 366 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_return_if_fail (source != NULL);
#line 367 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = source;
#line 367 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp2_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp1_);
#line 367 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp3_ = g_type_name (_tmp2_);
#line 367 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	if (g_strcmp0 (_tmp3_, "GstSoupHTTPSrc") == 0) {
#line 835 "rygel-playbin-player.c"
		const gchar* _tmp4_;
#line 368 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp4_ = self->priv->transfer_mode;
#line 368 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp0_ = _tmp4_ != NULL;
#line 841 "rygel-playbin-player.c"
	} else {
#line 367 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp0_ = FALSE;
#line 845 "rygel-playbin-player.c"
	}
#line 367 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp5_ = _tmp0_;
#line 367 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	if (_tmp5_) {
#line 851 "rygel-playbin-player.c"
		const gchar* _tmp6_;
		GstStructure* _tmp7_;
		GstStructure* structure;
		const GstStructure* _tmp8_;
		const gchar* _tmp9_;
		GValue _tmp10_ = {0};
		GstElement* _tmp11_;
		const GstStructure* _tmp12_;
#line 369 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp6_ = self->priv->transfer_mode;
#line 369 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_debug ("rygel-playbin-player.vala:369: Setting transfer mode to %s", _tmp6_);
#line 371 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp7_ = gst_structure_empty_new ("Extra Headers");
#line 371 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		structure = _tmp7_;
#line 372 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp8_ = structure;
#line 372 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp9_ = self->priv->transfer_mode;
#line 372 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_value_init (&_tmp10_, G_TYPE_STRING);
#line 372 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_value_set_string (&_tmp10_, _tmp9_);
#line 372 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		gst_structure_set_value (_tmp8_, "transferMode.dlna.org", &_tmp10_);
#line 372 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		G_IS_VALUE (&_tmp10_) ? (g_value_unset (&_tmp10_), NULL) : NULL;
#line 374 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp11_ = source;
#line 374 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp12_ = structure;
#line 374 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_dynamic_set_extra_headers3 (_tmp11_, _tmp12_);
#line 367 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_gst_structure_free0 (structure);
#line 888 "rygel-playbin-player.c"
	}
}


static void rygel_playbin_player_on_uri_notify (RygelPlaybinPlayer* self, GParamSpec* pspec) {
#line 378 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 378 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_return_if_fail (pspec != NULL);
#line 379 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self->priv->uri_update_hint = TRUE;
#line 900 "rygel-playbin-player.c"
}


/**
     * Generate basic DIDLLite information.
     *
     * This is used when the URI gets changed externally. DLNA requires that a
     * minimum DIDLLite is always present if the URI is not empty.
     */
static gchar* rygel_playbin_player_generate_basic_didl (RygelPlaybinPlayer* self) {
	gchar* result = NULL;
	GUPnPDIDLLiteWriter* _tmp0_;
	GUPnPDIDLLiteWriter* writer;
	GUPnPDIDLLiteItem* _tmp1_ = NULL;
	GUPnPDIDLLiteItem* item;
	GUPnPDIDLLiteResource* _tmp2_ = NULL;
	GUPnPDIDLLiteResource* resource;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_ = NULL;
	GFile* _tmp8_;
	GFile* file;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
#line 388 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 389 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = gupnp_didl_lite_writer_new (NULL);
#line 389 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	writer = _tmp0_;
#line 390 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = gupnp_didl_lite_writer_add_item (writer);
#line 390 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	item = _tmp1_;
#line 391 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) item, "1");
#line 392 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) item, "-1");
#line 393 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) item, "object.item");
#line 394 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp2_ = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) item);
#line 394 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	resource = _tmp2_;
#line 395 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp3_ = self->priv->_uri;
#line 395 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	gupnp_didl_lite_resource_set_uri (resource, _tmp3_);
#line 396 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp4_ = rygel_media_player_get_uri ((RygelMediaPlayer*) self);
#line 396 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp5_ = _tmp4_;
#line 396 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp6_ = _tmp5_;
#line 396 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp7_ = g_file_new_for_uri (_tmp6_);
#line 396 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp8_ = _tmp7_;
#line 396 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_free0 (_tmp6_);
#line 396 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	file = _tmp8_;
#line 397 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp9_ = g_file_get_basename (file);
#line 397 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp10_ = _tmp9_;
#line 397 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) item, _tmp10_);
#line 397 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_free0 (_tmp10_);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp11_ = gupnp_didl_lite_writer_get_string (writer);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = _tmp11_;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_object_unref0 (file);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_object_unref0 (resource);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_object_unref0 (item);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_object_unref0 (writer);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 988 "rygel-playbin-player.c"
}


static inline void _dynamic_set_auto_flush_bus4 (GstElement* obj, gboolean value) {
#line 405 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_set (obj, "auto-flush-bus", value, NULL);
#line 995 "rygel-playbin-player.c"
}


static void _rygel_playbin_player_on_source_setup_dynamic_source_setup0_ (GstElement* _sender, GstElement* source, gpointer self) {
#line 408 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	rygel_playbin_player_on_source_setup (self, _sender, source);
#line 1002 "rygel-playbin-player.c"
}


void _dynamic_source_setup1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data) {
#line 408 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_signal_connect_object (obj, signal_name, handler, data, 0);
#line 1009 "rygel-playbin-player.c"
}


static void _rygel_playbin_player_on_uri_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 409 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	rygel_playbin_player_on_uri_notify (self, pspec);
#line 1016 "rygel-playbin-player.c"
}


static void _rygel_playbin_player_bus_handler_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
#line 414 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	rygel_playbin_player_bus_handler (self, _sender, message);
#line 1023 "rygel-playbin-player.c"
}


static void rygel_playbin_player_setup_playbin (RygelPlaybinPlayer* self) {
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	GstElement* _tmp2_;
	GstElement* _tmp3_;
	GstElement* _tmp4_;
	GstBus* _tmp5_ = NULL;
	GstBus* bus;
#line 402 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 405 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 405 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_dynamic_set_auto_flush_bus4 (_tmp0_, FALSE);
#line 406 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = self->priv->_playbin;
#line 406 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_vala_assert (_tmp1_ != NULL, "this.playbin != null");
#line 408 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp2_ = self->priv->_playbin;
#line 408 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_dynamic_source_setup1_connect (_tmp2_, "source_setup", (GCallback) _rygel_playbin_player_on_source_setup_dynamic_source_setup0_, self);
#line 409 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp3_ = self->priv->_playbin;
#line 409 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::uri", (GCallback) _rygel_playbin_player_on_uri_notify_g_object_notify, self, 0);
#line 412 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp4_ = self->priv->_playbin;
#line 412 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp5_ = gst_element_get_bus (_tmp4_);
#line 412 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	bus = _tmp5_;
#line 413 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	gst_bus_add_signal_watch (bus);
#line 414 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_signal_connect_object (bus, "message", (GCallback) _rygel_playbin_player_bus_handler_gst_bus_message, self, 0);
#line 402 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_gst_object_unref0 (bus);
#line 1065 "rygel-playbin-player.c"
}


GstElement* rygel_playbin_player_get_playbin (RygelPlaybinPlayer* self) {
	GstElement* result;
	GstElement* _tmp0_;
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = _tmp0_;
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 1080 "rygel-playbin-player.c"
}


static gpointer _gst_object_ref0 (gpointer self) {
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return self ? gst_object_ref (self) : NULL;
#line 1087 "rygel-playbin-player.c"
}


static void rygel_playbin_player_set_playbin (RygelPlaybinPlayer* self, GstElement* value) {
	GstElement* _tmp0_;
	GstElement* _tmp1_;
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = _gst_object_ref0 (_tmp0_);
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_gst_object_unref0 (self->priv->_playbin);
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self->priv->_playbin = _tmp1_;
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "playbin");
#line 1106 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_playback_state (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 80 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playback_state;
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = _tmp1_;
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 1125 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_playback_state (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	GstState state = 0;
	GstState pending = 0;
	GstElement* _tmp0_;
	GstState _tmp1_ = 0;
	GstState _tmp2_ = 0;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	static GQuark _tmp6_label0 = 0;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	static GQuark _tmp6_label1 = 0;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	static GQuark _tmp6_label2 = 0;
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	gst_element_get_state (_tmp0_, &_tmp1_, &_tmp2_, (GstClockTime) GST_MSECOND);
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	state = _tmp1_;
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	pending = _tmp2_;
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp3_ = value;
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_debug ("rygel-playbin-player.vala:89: Changing playback state to %s.", _tmp3_);
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp4_ = value;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp5_ = _tmp4_;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("STOPPED")))) {
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		switch (0) {
#line 1170 "rygel-playbin-player.c"
			default:
			{
				gboolean _tmp8_ = FALSE;
				GstState _tmp9_;
				gboolean _tmp11_;
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_tmp9_ = state;
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				if (_tmp9_ != GST_STATE_NULL) {
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp8_ = TRUE;
#line 1182 "rygel-playbin-player.c"
				} else {
					GstState _tmp10_;
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp10_ = pending;
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp8_ = _tmp10_ != GST_STATE_VOID_PENDING;
#line 1189 "rygel-playbin-player.c"
				}
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_tmp11_ = _tmp8_;
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				if (_tmp11_) {
#line 1195 "rygel-playbin-player.c"
					gchar* _tmp12_;
					GstElement* _tmp13_;
#line 94 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp12_ = g_strdup ("TRANSITIONING");
#line 94 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 94 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp12_;
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp13_ = self->priv->_playbin;
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					gst_element_set_state (_tmp13_, GST_STATE_NULL);
#line 1208 "rygel-playbin-player.c"
				} else {
					const gchar* _tmp14_;
					gchar* _tmp15_;
#line 97 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp14_ = value;
#line 97 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp15_ = g_strdup (_tmp14_);
#line 97 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 97 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp15_;
#line 1220 "rygel-playbin-player.c"
				}
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				break;
#line 1224 "rygel-playbin-player.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		switch (0) {
#line 1230 "rygel-playbin-player.c"
			default:
			{
				gboolean _tmp16_ = FALSE;
				GstState _tmp17_;
				gboolean _tmp19_;
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_tmp17_ = state;
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				if (_tmp17_ != GST_STATE_PAUSED) {
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp16_ = TRUE;
#line 1242 "rygel-playbin-player.c"
				} else {
					GstState _tmp18_;
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp18_ = pending;
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp16_ = _tmp18_ != GST_STATE_VOID_PENDING;
#line 1249 "rygel-playbin-player.c"
				}
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_tmp19_ = _tmp16_;
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				if (_tmp19_) {
#line 1255 "rygel-playbin-player.c"
					gchar* _tmp20_;
					GstElement* _tmp21_;
#line 102 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp20_ = g_strdup ("TRANSITIONING");
#line 102 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 102 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp20_;
#line 103 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp21_ = self->priv->_playbin;
#line 103 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					gst_element_set_state (_tmp21_, GST_STATE_PAUSED);
#line 1268 "rygel-playbin-player.c"
				} else {
					const gchar* _tmp22_;
					gchar* _tmp23_;
#line 105 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp22_ = value;
#line 105 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp23_ = g_strdup (_tmp22_);
#line 105 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 105 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp23_;
#line 1280 "rygel-playbin-player.c"
				}
#line 107 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				break;
#line 1284 "rygel-playbin-player.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("PLAYING")))) {
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		switch (0) {
#line 1290 "rygel-playbin-player.c"
			default:
			{
				gboolean _tmp24_ = FALSE;
				GstState _tmp25_;
				gboolean _tmp27_;
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_tmp25_ = state;
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				if (_tmp25_ != GST_STATE_PLAYING) {
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp24_ = TRUE;
#line 1302 "rygel-playbin-player.c"
				} else {
					GstState _tmp26_;
#line 110 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp26_ = pending;
#line 110 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp24_ = _tmp26_ != GST_STATE_VOID_PENDING;
#line 1309 "rygel-playbin-player.c"
				}
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_tmp27_ = _tmp24_;
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				if (_tmp27_) {
#line 1315 "rygel-playbin-player.c"
					gchar* _tmp28_;
					GstElement* _tmp29_;
#line 111 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp28_ = g_strdup ("TRANSITIONING");
#line 111 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 111 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp28_;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp29_ = self->priv->_playbin;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					gst_element_set_state (_tmp29_, GST_STATE_PLAYING);
#line 1328 "rygel-playbin-player.c"
				} else {
					const gchar* _tmp30_;
					gchar* _tmp31_;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp30_ = value;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp31_ = g_strdup (_tmp30_);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp31_;
#line 1340 "rygel-playbin-player.c"
				}
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				break;
#line 1344 "rygel-playbin-player.c"
			}
		}
	} else {
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		switch (0) {
#line 1350 "rygel-playbin-player.c"
			default:
			{
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				break;
#line 1355 "rygel-playbin-player.c"
			}
		}
	}
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "playback-state");
#line 1361 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_uri (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_uri;
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = _tmp1_;
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 1380 "rygel-playbin-player.c"
}


static inline void _dynamic_set_uri5 (GstElement* obj, const gchar* value) {
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_set (obj, "uri", value, NULL);
#line 1387 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_uri (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GstElement* _tmp2_;
	GstElement* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp16_;
#line 132 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_free0 (self->priv->_uri);
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self->priv->_uri = _tmp1_;
#line 134 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp2_ = self->priv->_playbin;
#line 134 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	gst_element_set_state (_tmp2_, GST_STATE_READY);
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp3_ = self->priv->_playbin;
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp4_ = value;
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_dynamic_set_uri5 (_tmp3_, _tmp4_);
#line 136 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp5_ = value;
#line 136 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	if (g_strcmp0 (_tmp5_, "") != 0) {
#line 1424 "rygel-playbin-player.c"
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GQuark _tmp9_ = 0U;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		static GQuark _tmp8_label0 = 0;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		static GQuark _tmp8_label1 = 0;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		static GQuark _tmp8_label2 = 0;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		static GQuark _tmp8_label3 = 0;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp6_ = self->priv->_playback_state;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp7_ = _tmp6_;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("NO_MEDIA_PRESENT")))) {
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			switch (0) {
#line 1446 "rygel-playbin-player.c"
				default:
				{
					GstElement* _tmp10_;
					gchar* _tmp11_;
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp10_ = self->priv->_playbin;
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					gst_element_set_state (_tmp10_, GST_STATE_READY);
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp11_ = g_strdup ("STOPPED");
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp11_;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					g_object_notify ((GObject*) self, "playback-state");
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					break;
#line 1465 "rygel-playbin-player.c"
				}
			}
		} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("STOPPED")))) {
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			switch (0) {
#line 1471 "rygel-playbin-player.c"
				default:
				{
					GstElement* _tmp12_;
#line 144 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp12_ = self->priv->_playbin;
#line 144 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					gst_element_set_state (_tmp12_, GST_STATE_READY);
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					break;
#line 1481 "rygel-playbin-player.c"
				}
			}
		} else if (_tmp9_ == ((0 != _tmp8_label2) ? _tmp8_label2 : (_tmp8_label2 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			switch (0) {
#line 1487 "rygel-playbin-player.c"
				default:
				{
					GstElement* _tmp13_;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp13_ = self->priv->_playbin;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					gst_element_set_state (_tmp13_, GST_STATE_PAUSED);
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					break;
#line 1497 "rygel-playbin-player.c"
				}
			}
		} else if (_tmp9_ == ((0 != _tmp8_label3) ? _tmp8_label3 : (_tmp8_label3 = g_quark_from_static_string ("PLAYING")))) {
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			switch (0) {
#line 1503 "rygel-playbin-player.c"
				default:
				{
					GstElement* _tmp14_;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					_tmp14_ = self->priv->_playbin;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					gst_element_set_state (_tmp14_, GST_STATE_PLAYING);
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					break;
#line 1513 "rygel-playbin-player.c"
				}
			}
		} else {
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			switch (0) {
#line 1519 "rygel-playbin-player.c"
				default:
				{
#line 153 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
					break;
#line 1524 "rygel-playbin-player.c"
				}
			}
		}
	} else {
		gchar* _tmp15_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp15_ = g_strdup ("NO_MEDIA_PRESENT");
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_g_free0 (self->priv->_playback_state);
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		self->priv->_playback_state = _tmp15_;
#line 157 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_object_notify ((GObject*) self, "playback-state");
#line 1538 "rygel-playbin-player.c"
	}
#line 159 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp16_ = value;
#line 159 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_debug ("rygel-playbin-player.vala:159: URI set to %s.", _tmp16_);
#line 132 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "uri");
#line 1546 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_mime_type (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_mime_type;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = _tmp1_;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 1565 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_mime_type (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_free0 (self->priv->_mime_type);
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self->priv->_mime_type = _tmp1_;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "mime-type");
#line 1585 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_metadata (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_metadata;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 177 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = _tmp1_;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 1604 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_metadata (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 180 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 181 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 181 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 181 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_free0 (self->priv->_metadata);
#line 181 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self->priv->_metadata = _tmp1_;
#line 180 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "metadata");
#line 1624 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_content_features (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 188 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_content_features;
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = _tmp1_;
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 1643 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_content_features (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* pi_string;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	GError * _inner_error_ = NULL;
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = rygel_media_player_get_mime_type ((RygelMediaPlayer*) self);
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_;
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp2_ = _tmp1_;
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp3_ = value;
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp4_ = g_strdup_printf (RYGEL_PLAYBIN_PLAYER_PROTOCOL_INFO_TEMPLATE, _tmp2_, _tmp3_);
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp5_ = _tmp4_;
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_free0 (_tmp2_);
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	pi_string = _tmp5_;
#line 1677 "rygel-playbin-player.c"
	{
		GUPnPProtocolInfo* _tmp6_;
		GUPnPProtocolInfo* _tmp7_;
		GUPnPProtocolInfo* _tmp8_;
		GUPnPDLNAFlags _tmp9_;
		GUPnPDLNAFlags _tmp10_;
		GUPnPDLNAFlags flags;
		GUPnPDLNAFlags _tmp11_;
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp6_ = gupnp_protocol_info_new_from_string (pi_string, &_inner_error_);
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp7_ = _tmp6_;
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		if (_inner_error_ != NULL) {
#line 1692 "rygel-playbin-player.c"
			goto __catch0_g_error;
		}
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_g_object_unref0 (self->priv->protocol_info);
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		self->priv->protocol_info = _tmp7_;
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp8_ = self->priv->protocol_info;
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp9_ = gupnp_protocol_info_get_dlna_flags (_tmp8_);
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp10_ = _tmp9_;
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		flags = _tmp10_;
#line 198 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp11_ = flags;
#line 198 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		if ((_tmp11_ & GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE) == GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE) {
#line 1711 "rygel-playbin-player.c"
			gchar* _tmp12_;
#line 199 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_tmp12_ = g_strdup (RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE);
#line 199 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_g_free0 (self->priv->transfer_mode);
#line 199 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			self->priv->transfer_mode = _tmp12_;
#line 1719 "rygel-playbin-player.c"
		} else {
			GUPnPDLNAFlags _tmp13_;
#line 200 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			_tmp13_ = flags;
#line 200 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
			if ((_tmp13_ & GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) == GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) {
#line 1726 "rygel-playbin-player.c"
				gchar* _tmp14_;
#line 201 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_tmp14_ = g_strdup (RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_STREAMING);
#line 201 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_g_free0 (self->priv->transfer_mode);
#line 201 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				self->priv->transfer_mode = _tmp14_;
#line 1734 "rygel-playbin-player.c"
			} else {
#line 203 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				_g_free0 (self->priv->transfer_mode);
#line 203 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
				self->priv->transfer_mode = NULL;
#line 1740 "rygel-playbin-player.c"
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_error_ = _inner_error_;
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_inner_error_ = NULL;
#line 206 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_g_object_unref0 (self->priv->protocol_info);
#line 206 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		self->priv->protocol_info = NULL;
#line 207 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_g_free0 (self->priv->transfer_mode);
#line 207 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		self->priv->transfer_mode = NULL;
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_g_error_free0 (_error_);
#line 1762 "rygel-playbin-player.c"
	}
	__finally0:
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	if (_inner_error_ != NULL) {
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_g_free0 (pi_string);
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_clear_error (&_inner_error_);
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		return;
#line 1775 "rygel-playbin-player.c"
	}
#line 209 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp15_ = value;
#line 209 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 209 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_free0 (self->priv->_content_features);
#line 209 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self->priv->_content_features = _tmp16_;
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_free0 (pi_string);
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "content-features");
#line 1789 "rygel-playbin-player.c"
}


static inline gdouble _dynamic_get_volume6 (GstElement* obj) {
	gdouble result;
#line 215 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_get (obj, "volume", &result, NULL);
#line 215 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 1799 "rygel-playbin-player.c"
}


static gdouble rygel_playbin_player_real_get_volume (RygelMediaPlayer* base) {
	gdouble result;
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 215 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 215 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = _dynamic_get_volume6 (_tmp0_);
#line 215 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp2_ = _tmp1_;
#line 215 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	result = _tmp2_;
#line 215 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	return result;
#line 1821 "rygel-playbin-player.c"
}


static inline void _dynamic_set_volume7 (GstElement* obj, gdouble value) {
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_set (obj, "volume", value, NULL);
#line 1828 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_volume (RygelMediaPlayer* base, gdouble value) {
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
#line 218 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = value;
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_dynamic_set_volume7 (_tmp0_, _tmp1_);
#line 220 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp2_ = value;
#line 220 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_debug ("rygel-playbin-player.vala:220: volume set to %f.", _tmp2_);
#line 218 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "volume");
#line 1851 "rygel-playbin-player.c"
}


static gint64 rygel_playbin_player_real_get_duration (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	GstFormat format;
	gint64 dur = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
#line 225 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 226 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	format = GST_FORMAT_TIME;
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp2_ = gst_element_query_duration (_tmp0_, &format, &_tmp1_);
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	dur = _tmp1_;
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	if (_tmp2_) {
#line 1875 "rygel-playbin-player.c"
		gint64 _tmp3_;
#line 230 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp3_ = dur;
#line 230 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		result = _tmp3_;
#line 230 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		return result;
#line 1883 "rygel-playbin-player.c"
	} else {
#line 232 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		result = (gint64) 0;
#line 232 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		return result;
#line 1889 "rygel-playbin-player.c"
	}
}


static gint64 rygel_playbin_player_real_get_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	GstFormat format;
	gint64 pos = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
#line 238 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 239 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	format = GST_FORMAT_TIME;
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp2_ = gst_element_query_position (_tmp0_, &format, &_tmp1_);
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	pos = _tmp1_;
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	if (_tmp2_) {
#line 1914 "rygel-playbin-player.c"
		gint64 _tmp3_;
#line 243 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		_tmp3_ = pos;
#line 243 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		result = _tmp3_;
#line 243 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		return result;
#line 1922 "rygel-playbin-player.c"
	} else {
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		result = (gint64) 0;
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		return result;
#line 1928 "rygel-playbin-player.c"
	}
}


static void rygel_playbin_player_class_init (RygelPlaybinPlayerClass * klass) {
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	rygel_playbin_player_parent_class = g_type_class_peek_parent (klass);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_type_class_add_private (klass, sizeof (RygelPlaybinPlayerPrivate));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_playbin_player_get_property;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_playbin_player_set_property;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_playbin_player_finalize;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBIN, g_param_spec_object ("playbin", "playbin", "playbin", GST_TYPE_ELEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES, g_param_spec_string ("content-features", "content-features", "content-features", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_VOLUME, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_DURATION, g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_POSITION, g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1962 "rygel-playbin-player.c"
}


static void rygel_playbin_player_rygel_media_player_interface_init (RygelMediaPlayerIface * iface) {
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	rygel_playbin_player_rygel_media_player_parent_iface = g_type_interface_peek_parent (iface);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->seek = (gboolean (*)(RygelMediaPlayer*, GstClockTime)) rygel_playbin_player_real_seek;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->get_protocols = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_playbin_player_real_get_protocols;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->get_mime_types = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_playbin_player_real_get_mime_types;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->get_playback_state = rygel_playbin_player_real_get_playback_state;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->set_playback_state = rygel_playbin_player_real_set_playback_state;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->get_uri = rygel_playbin_player_real_get_uri;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->set_uri = rygel_playbin_player_real_set_uri;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->get_mime_type = rygel_playbin_player_real_get_mime_type;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->set_mime_type = rygel_playbin_player_real_set_mime_type;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->get_metadata = rygel_playbin_player_real_get_metadata;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->set_metadata = rygel_playbin_player_real_set_metadata;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->get_content_features = rygel_playbin_player_real_get_content_features;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->set_content_features = rygel_playbin_player_real_set_content_features;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->get_volume = rygel_playbin_player_real_get_volume;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->set_volume = rygel_playbin_player_real_set_volume;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->get_duration = rygel_playbin_player_real_get_duration;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	iface->get_position = rygel_playbin_player_real_get_position;
#line 2003 "rygel-playbin-player.c"
}


static void rygel_playbin_player_instance_init (RygelPlaybinPlayer * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self->priv = RYGEL_PLAYBIN_PLAYER_GET_PRIVATE (self);
#line 78 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp0_ = g_strdup ("NO_MEDIA_PRESENT");
#line 78 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self->priv->_playback_state = _tmp0_;
#line 123 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self->priv->transfer_mode = NULL;
#line 125 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self->priv->uri_update_hint = FALSE;
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self->priv->_uri = NULL;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp1_ = g_strdup ("");
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self->priv->_mime_type = _tmp1_;
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp2_ = g_strdup ("");
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self->priv->_metadata = _tmp2_;
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_tmp3_ = g_strdup ("");
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self->priv->_content_features = _tmp3_;
#line 2036 "rygel-playbin-player.c"
}


static void rygel_playbin_player_finalize (GObject* obj) {
	RygelPlaybinPlayer * self;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_gst_object_unref0 (self->priv->_playbin);
#line 78 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_free0 (self->priv->_playback_state);
#line 123 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_free0 (self->priv->transfer_mode);
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_free0 (self->priv->_uri);
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_free0 (self->priv->_mime_type);
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_free0 (self->priv->_metadata);
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_free0 (self->priv->_content_features);
#line 186 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	_g_object_unref0 (self->priv->protocol_info);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	G_OBJECT_CLASS (rygel_playbin_player_parent_class)->finalize (obj);
#line 2062 "rygel-playbin-player.c"
}


GType rygel_playbin_player_get_type (void) {
	static volatile gsize rygel_playbin_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_playbin_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaybinPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playbin_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaybinPlayer), 0, (GInstanceInitFunc) rygel_playbin_player_instance_init, NULL };
		static const GInterfaceInfo rygel_media_player_info = { (GInterfaceInitFunc) rygel_playbin_player_rygel_media_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_playbin_player_type_id;
		rygel_playbin_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaybinPlayer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_playbin_player_type_id, RYGEL_TYPE_MEDIA_PLAYER, &rygel_media_player_info);
		g_once_init_leave (&rygel_playbin_player_type_id__volatile, rygel_playbin_player_type_id);
	}
	return rygel_playbin_player_type_id__volatile;
}


static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBIN:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_value_set_object (value, rygel_playbin_player_get_playbin (self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_playback_state ((RygelMediaPlayer*) self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_URI:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_uri ((RygelMediaPlayer*) self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_MIME_TYPE:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_mime_type ((RygelMediaPlayer*) self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_METADATA:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_metadata ((RygelMediaPlayer*) self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_content_features ((RygelMediaPlayer*) self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_value_set_double (value, rygel_media_player_get_volume ((RygelMediaPlayer*) self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_DURATION:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_value_set_int64 (value, rygel_media_player_get_duration ((RygelMediaPlayer*) self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_POSITION:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		g_value_set_int64 (value, rygel_media_player_get_position ((RygelMediaPlayer*) self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 2139 "rygel-playbin-player.c"
		default:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 2145 "rygel-playbin-player.c"
	}
}


static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBIN:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		rygel_playbin_player_set_playbin (self, g_value_get_object (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_URI:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		rygel_media_player_set_uri ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_MIME_TYPE:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		rygel_media_player_set_mime_type ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_METADATA:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		rygel_media_player_set_metadata ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		rygel_media_player_set_content_features ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		rygel_media_player_set_volume ((RygelMediaPlayer*) self, g_value_get_double (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 2197 "rygel-playbin-player.c"
		default:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-playbin-player.vala"
		break;
#line 2203 "rygel-playbin-player.c"
	}
}



