/* rygel-simple-container.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-simple-container.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_SIMPLE_CONTAINER (rygel_simple_container_get_type ())
#define RYGEL_SIMPLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer))
#define RYGEL_SIMPLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainerClass))
#define RYGEL_IS_SIMPLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SIMPLE_CONTAINER))
#define RYGEL_IS_SIMPLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SIMPLE_CONTAINER))
#define RYGEL_SIMPLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainerClass))

typedef struct _RygelSimpleContainer RygelSimpleContainer;
typedef struct _RygelSimpleContainerClass RygelSimpleContainerClass;
typedef struct _RygelSimpleContainerPrivate RygelSimpleContainerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelSimpleContainerGetChildrenData RygelSimpleContainerGetChildrenData;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _RygelSimpleContainerFindObjectData RygelSimpleContainerFindObjectData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelSimpleContainerSearchData RygelSimpleContainerSearchData;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	gint64 storage_used;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelSimpleContainer {
	RygelMediaContainer parent_instance;
	RygelSimpleContainerPrivate * priv;
	RygelMediaObjects* children;
};

struct _RygelSimpleContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelSimpleContainerPrivate {
	RygelMediaObjects* empty_children;
	GeeArrayList* _search_classes;
};

struct _RygelSimpleContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	guint _tmp0_;
	guint _tmp1_;
	guint stop;
	guint _tmp2_;
	gint _tmp3_;
	guint _tmp4_;
	RygelMediaObjects* _tmp5_;
	gint _tmp6_;
	GeeList* _tmp7_;
	RygelMediaObjects* sorted_children;
	const gchar* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	GeeList* _tmp11_;
};

struct _Block2Data {
	int _ref_count_;
	RygelSimpleContainer * self;
	gint restart_count;
	gboolean restart;
	gpointer _async_data_;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gulong updated_id;
};

struct _RygelSimpleContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	Block2Data* _data2_;
	RygelMediaObject* media_object;
	gboolean _tmp0_;
	Block3Data* _data3_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	RygelMediaObjects* _tmp6_;
	RygelMediaObjects* _tmp7_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _child_size;
	gint _child_index;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	RygelMediaObjects* _tmp14_;
	gint _tmp15_;
	gpointer _tmp16_;
	RygelMediaObject* child;
	RygelMediaObject* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	RygelMediaObject* _tmp20_;
	RygelMediaObject* _tmp21_;
	RygelMediaObject* _tmp22_;
	gulong _tmp23_;
	RygelMediaObject* _tmp24_;
	RygelMediaContainer* _tmp25_;
	RygelMediaContainer* container;
	RygelMediaContainer* _tmp26_;
	const gchar* _tmp27_;
	GCancellable* _tmp28_;
	RygelMediaObject* _tmp29_;
	RygelMediaObject* _tmp30_;
	gulong _tmp31_;
	gulong _tmp32_;
	RygelMediaObject* _tmp33_;
	gboolean _tmp34_;
	GError * _inner_error_;
};

struct _RygelSimpleContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelSearchExpression* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	const gchar* _tmp3_;
	GCancellable* _tmp4_;
	guint _tmp5_;
	RygelMediaObjects* _tmp6_;
	RygelMediaObjects* _tmp7_;
	GError * _inner_error_;
};


static gpointer rygel_simple_container_parent_class = NULL;
static RygelSearchableContainerIface* rygel_simple_container_rygel_searchable_container_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_simple_container_get_type (void) G_GNUC_CONST;
#define RYGEL_SIMPLE_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainerPrivate))
enum  {
	RYGEL_SIMPLE_CONTAINER_DUMMY_PROPERTY,
	RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES
};
RygelSimpleContainer* rygel_simple_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelSimpleContainer* rygel_simple_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelMediaContainer* rygel_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value);
RygelSimpleContainer* rygel_simple_container_new_root (const gchar* title);
RygelSimpleContainer* rygel_simple_container_construct_root (GType object_type, const gchar* title);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_simple_container_add_child_item (RygelSimpleContainer* self, RygelMediaItem* child);
static void rygel_simple_container_add_child (RygelSimpleContainer* self, RygelMediaObject* child);
RygelMediaObjects* rygel_simple_container_get_all_children (RygelSimpleContainer* self);
void rygel_simple_container_add_child_container (RygelSimpleContainer* self, RygelMediaContainer* child);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
static void rygel_simple_container_on_container_updated (RygelSimpleContainer* self, RygelMediaContainer* source, RygelMediaContainer* updated);
static void _rygel_simple_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
void rygel_simple_container_remove_child (RygelSimpleContainer* self, RygelMediaObject* child);
void rygel_simple_container_clear (RygelSimpleContainer* self);
gboolean rygel_simple_container_is_child_id_unique (RygelSimpleContainer* self, const gchar* child_id);
static void rygel_simple_container_real_get_children_data_free (gpointer _data);
static void rygel_simple_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_simple_container_real_get_children_co (RygelSimpleContainerGetChildrenData* _data_);
void rygel_media_objects_sort_by_criteria (RygelMediaObjects* self, const gchar* sort_criteria);
static void rygel_simple_container_real_find_object_data_free (gpointer _data);
static void rygel_simple_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_simple_container_real_find_object_co (RygelSimpleContainerFindObjectData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ________lambda15_ (Block3Data* _data3_, RygelMediaContainer* _, RygelMediaContainer* updated);
static void _________lambda15__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_simple_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_simple_container_real_search_data_free (gpointer _data);
static void rygel_simple_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_simple_container_real_search_co (RygelSimpleContainerSearchData* _data_);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_simple_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_updated (RygelMediaContainer* self);
static void rygel_simple_container_finalize (GObject* obj);
static void _vala_rygel_simple_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_simple_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelSimpleContainer* rygel_simple_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title) {
	RygelSimpleContainer * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = id;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = parent;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = title;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) rygel_media_container_construct (object_type, _tmp0_, _tmp1_, _tmp2_, 0);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp3_ = rygel_media_objects_new ();
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (self->children);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self->children = _tmp3_;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp4_ = rygel_media_objects_new ();
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (self->priv->empty_children);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self->priv->empty_children = _tmp4_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp6_ = _tmp5_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, _tmp6_);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_tmp6_);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return self;
#line 427 "rygel-simple-container.c"
}


RygelSimpleContainer* rygel_simple_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title) {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return rygel_simple_container_construct (RYGEL_TYPE_SIMPLE_CONTAINER, id, parent, title);
#line 434 "rygel-simple-container.c"
}


RygelSimpleContainer* rygel_simple_container_construct_root (GType object_type, const gchar* title) {
	RygelSimpleContainer * self = NULL;
	const gchar* _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = title;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) rygel_simple_container_construct (object_type, "0", NULL, _tmp0_);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return self;
#line 449 "rygel-simple-container.c"
}


RygelSimpleContainer* rygel_simple_container_new_root (const gchar* title) {
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return rygel_simple_container_construct_root (RYGEL_TYPE_SIMPLE_CONTAINER, title);
#line 456 "rygel-simple-container.c"
}


void rygel_simple_container_add_child_item (RygelSimpleContainer* self, RygelMediaItem* child) {
	RygelMediaItem* _tmp0_;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (child != NULL);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = child;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_add_child (self, (RygelMediaObject*) _tmp0_);
#line 470 "rygel-simple-container.c"
}


RygelMediaObjects* rygel_simple_container_get_all_children (RygelSimpleContainer* self) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* all;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* _tmp2_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = rygel_media_objects_new ();
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	all = _tmp0_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = self->children;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	gee_abstract_collection_add_all ((GeeAbstractCollection*) all, (GeeCollection*) _tmp1_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = self->priv->empty_children;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	gee_abstract_collection_add_all ((GeeAbstractCollection*) all, (GeeCollection*) _tmp2_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	result = all;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return result;
#line 498 "rygel-simple-container.c"
}


/**
     * NOTE: This method only actually adds the child container to the hierarchy
     * until it has any children to offer.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 509 "rygel-simple-container.c"
}


static void _rygel_simple_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_on_container_updated (self, _sender, container);
#line 516 "rygel-simple-container.c"
}


void rygel_simple_container_add_child_container (RygelSimpleContainer* self, RygelMediaContainer* child) {
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp8_;
	gint _tmp9_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (child != NULL);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = child;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_SEARCHABLE_CONTAINER)) {
#line 532 "rygel-simple-container.c"
		RygelMediaContainer* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* search_classes;
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp1_ = child;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp2_ = rygel_searchable_container_get_search_classes (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _tmp1_) : NULL);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp3_ = _tmp2_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		search_classes = _tmp4_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp5_ = rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp6_ = _tmp5_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp7_ = search_classes;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp6_, (GeeCollection*) _tmp7_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_g_object_unref0 (search_classes);
#line 561 "rygel-simple-container.c"
	}
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp8_ = child;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp9_ = _tmp8_->child_count;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_tmp9_ > 0) {
#line 569 "rygel-simple-container.c"
		RygelMediaContainer* _tmp10_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp10_ = child;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_simple_container_add_child (self, (RygelMediaObject*) _tmp10_);
#line 575 "rygel-simple-container.c"
	} else {
		RygelMediaContainer* _tmp11_;
		const gchar* _tmp12_;
		RygelMediaObjects* _tmp13_;
		RygelMediaContainer* _tmp14_;
		RygelMediaContainer* _tmp15_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp11_ = child;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp12_ = ((RygelMediaObject*) _tmp11_)->id;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_debug ("Container '%s' empty, refusing to add to hierarchy " "until it has any children to offer.", _tmp12_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp13_ = self->priv->empty_children;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp14_ = child;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, (RygelMediaObject*) _tmp14_);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp15_ = child;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_signal_connect_object (_tmp15_, "container-updated", (GCallback) _rygel_simple_container_on_container_updated_rygel_media_container_container_updated, self, 0);
#line 598 "rygel-simple-container.c"
	}
}


void rygel_simple_container_remove_child (RygelSimpleContainer* self, RygelMediaObject* child) {
	RygelMediaObjects* _tmp0_;
	RygelMediaObject* _tmp1_;
	gint _tmp2_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (child != NULL);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = self->children;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = child;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = ((RygelMediaContainer*) self)->child_count;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	((RygelMediaContainer*) self)->child_count = _tmp2_ - 1;
#line 621 "rygel-simple-container.c"
}


void rygel_simple_container_clear (RygelSimpleContainer* self) {
	RygelMediaObjects* _tmp0_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = self->children;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	((RygelMediaContainer*) self)->child_count = 0;
#line 635 "rygel-simple-container.c"
}


gboolean rygel_simple_container_is_child_id_unique (RygelSimpleContainer* self, const gchar* child_id) {
	gboolean result = FALSE;
	gboolean unique;
	gboolean _tmp14_;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_val_if_fail (child_id != NULL, FALSE);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	unique = TRUE;
#line 649 "rygel-simple-container.c"
	{
		RygelMediaObjects* _tmp0_;
		RygelMediaObjects* _tmp1_;
		RygelMediaObjects* _child_list;
		RygelMediaObjects* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _child_size;
		gint _child_index;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp0_ = self->children;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_child_list = _tmp1_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp2_ = _child_list;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp4_ = _tmp3_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_child_size = _tmp4_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_child_index = -1;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		while (TRUE) {
#line 677 "rygel-simple-container.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			RygelMediaObjects* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			RygelMediaObject* child;
			RygelMediaObject* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp5_ = _child_index;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_child_index = _tmp5_ + 1;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp6_ = _child_index;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp7_ = _child_size;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				break;
#line 700 "rygel-simple-container.c"
			}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp8_ = _child_list;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp9_ = _child_index;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			child = (RygelMediaObject*) _tmp10_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp11_ = child;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp12_ = _tmp11_->id;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp13_ = child_id;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				unique = FALSE;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_g_object_unref0 (child);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				break;
#line 724 "rygel-simple-container.c"
			}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_g_object_unref0 (child);
#line 728 "rygel-simple-container.c"
		}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_g_object_unref0 (_child_list);
#line 732 "rygel-simple-container.c"
	}
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp14_ = unique;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_tmp14_) {
#line 738 "rygel-simple-container.c"
		{
			RygelMediaObjects* _tmp15_;
			RygelMediaObjects* _tmp16_;
			RygelMediaObjects* _child_list;
			RygelMediaObjects* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _child_size;
			gint _child_index;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp15_ = self->priv->empty_children;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp16_ = _g_object_ref0 (_tmp15_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_child_list = _tmp16_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp17_ = _child_list;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp18_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp17_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp19_ = _tmp18_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_child_size = _tmp19_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_child_index = -1;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			while (TRUE) {
#line 766 "rygel-simple-container.c"
				gint _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				RygelMediaObjects* _tmp23_;
				gint _tmp24_;
				gpointer _tmp25_ = NULL;
				RygelMediaObject* child;
				RygelMediaObject* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp20_ = _child_index;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_child_index = _tmp20_ + 1;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp21_ = _child_index;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp22_ = _child_size;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				if (!(_tmp21_ < _tmp22_)) {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					break;
#line 789 "rygel-simple-container.c"
				}
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp23_ = _child_list;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp24_ = _child_index;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _tmp24_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				child = (RygelMediaObject*) _tmp25_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp26_ = child;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp27_ = _tmp26_->id;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp28_ = child_id;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				if (g_strcmp0 (_tmp27_, _tmp28_) == 0) {
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					unique = FALSE;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_g_object_unref0 (child);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					break;
#line 813 "rygel-simple-container.c"
				}
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_g_object_unref0 (child);
#line 817 "rygel-simple-container.c"
			}
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_g_object_unref0 (_child_list);
#line 821 "rygel-simple-container.c"
		}
	}
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	result = unique;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return result;
#line 828 "rygel-simple-container.c"
}


static void rygel_simple_container_real_get_children_data_free (gpointer _data) {
	RygelSimpleContainerGetChildrenData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_slice_free (RygelSimpleContainerGetChildrenData, _data_);
#line 845 "rygel-simple-container.c"
}


static void rygel_simple_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainer * self;
	RygelSimpleContainerGetChildrenData* _data_;
	RygelSimpleContainer* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = g_slice_new0 (RygelSimpleContainerGetChildrenData);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_real_get_children);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_real_get_children_data_free);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = offset;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->offset = _tmp1_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = max_count;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->max_count = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp3_ = sort_criteria;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->sort_criteria = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp5_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->cancellable = _tmp6_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_real_get_children_co (_data_);
#line 893 "rygel-simple-container.c"
}


static RygelMediaObjects* rygel_simple_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelSimpleContainerGetChildrenData* _data_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		return NULL;
#line 904 "rygel-simple-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return result;
#line 914 "rygel-simple-container.c"
}


static gboolean rygel_simple_container_real_get_children_co (RygelSimpleContainerGetChildrenData* _data_) {
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	switch (_data_->_state_) {
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case 0:
#line 923 "rygel-simple-container.c"
		goto _state_0;
		default:
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_assert_not_reached ();
#line 928 "rygel-simple-container.c"
	}
	_state_0:
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp0_ = _data_->offset;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp1_ = _data_->max_count;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->stop = _data_->_tmp0_ + _data_->_tmp1_;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp2_ = _data_->stop;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp3_ = ((RygelMediaContainer*) _data_->self)->child_count;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp4_ = 0U;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp4_ = CLAMP (_data_->_tmp2_, (guint) 0, (guint) _data_->_tmp3_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->stop = _data_->_tmp4_;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp5_ = _data_->self->children;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp6_ = ((RygelMediaContainer*) _data_->self)->child_count;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp7_ = NULL;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp7_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp5_, 0, _data_->_tmp6_);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->sorted_children = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp7_, RYGEL_TYPE_MEDIA_OBJECTS) ? ((RygelMediaObjects*) _data_->_tmp7_) : NULL;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp8_ = _data_->sort_criteria;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_media_objects_sort_by_criteria (_data_->sorted_children, _data_->_tmp8_);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp9_ = _data_->offset;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp10_ = _data_->stop;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp11_ = NULL;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp11_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->sorted_children, (gint) _data_->_tmp9_, (gint) _data_->_tmp10_);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->result = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp11_, RYGEL_TYPE_MEDIA_OBJECTS) ? ((RygelMediaObjects*) _data_->_tmp11_) : NULL;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->sorted_children);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 977 "rygel-simple-container.c"
	} else {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 981 "rygel-simple-container.c"
	}
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->sorted_children);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 993 "rygel-simple-container.c"
	} else {
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 997 "rygel-simple-container.c"
	}
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 1003 "rygel-simple-container.c"
}


static void rygel_simple_container_real_find_object_data_free (gpointer _data) {
	RygelSimpleContainerFindObjectData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_free0 (_data_->id);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_slice_free (RygelSimpleContainerFindObjectData, _data_);
#line 1020 "rygel-simple-container.c"
}


static void rygel_simple_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainer * self;
	RygelSimpleContainerFindObjectData* _data_;
	RygelSimpleContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = g_slice_new0 (RygelSimpleContainerFindObjectData);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_real_find_object);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_real_find_object_data_free);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = id;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->id = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp3_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->cancellable = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_real_find_object_co (_data_);
#line 1058 "rygel-simple-container.c"
}


static RygelMediaObject* rygel_simple_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelSimpleContainerFindObjectData* _data_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		return NULL;
#line 1069 "rygel-simple-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return result;
#line 1079 "rygel-simple-container.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return _data2_;
#line 1088 "rygel-simple-container.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1097 "rygel-simple-container.c"
		RygelSimpleContainer * self;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		self = _data2_->self;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_g_object_unref0 (self);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_slice_free (Block2Data, _data2_);
#line 1105 "rygel-simple-container.c"
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return _data3_;
#line 1115 "rygel-simple-container.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1124 "rygel-simple-container.c"
		RygelSimpleContainer * self;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		self = _data3_->_data2_->self;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		block2_data_unref (_data3_->_data2_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data3_->_data2_ = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_slice_free (Block3Data, _data3_);
#line 1134 "rygel-simple-container.c"
	}
}


static void ________lambda15_ (Block3Data* _data3_, RygelMediaContainer* _, RygelMediaContainer* updated) {
	Block2Data* _data2_;
	RygelSimpleContainer * self;
	RygelMediaContainer* _tmp0_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data2_ = _data3_->_data2_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = _data2_->self;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (_ != NULL);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (updated != NULL);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = updated;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_tmp0_ == G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer)) {
#line 1155 "rygel-simple-container.c"
		gint _tmp1_;
		gulong _tmp2_;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data2_->restart = TRUE;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp1_ = _data2_->restart_count;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data2_->restart_count = _tmp1_ + 1;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp2_ = _data3_->updated_id;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_signal_handler_disconnect ((GObject*) self, _tmp2_);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data3_->updated_id = (gulong) 0;
#line 1170 "rygel-simple-container.c"
	}
}


static void _________lambda15__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	________lambda15_ (self, _sender, container);
#line 1178 "rygel-simple-container.c"
}


static void rygel_simple_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSimpleContainerFindObjectData* _data_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = _user_data_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_source_object_ = source_object;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_res_ = _res_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_real_find_object_co (_data_);
#line 1192 "rygel-simple-container.c"
}


static gboolean rygel_simple_container_real_find_object_co (RygelSimpleContainerFindObjectData* _data_) {
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	switch (_data_->_state_) {
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case 0:
#line 1201 "rygel-simple-container.c"
		goto _state_0;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case 1:
#line 1205 "rygel-simple-container.c"
		goto _state_1;
		default:
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_assert_not_reached ();
#line 1210 "rygel-simple-container.c"
	}
	_state_0:
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_->self = g_object_ref (_data_->self);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->media_object = NULL;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_->restart_count = 0;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_->restart = FALSE;
#line 1227 "rygel-simple-container.c"
	{
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp0_ = TRUE;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		while (TRUE) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_data3_ = g_slice_new0 (Block3Data);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_data3_->_ref_count_ = 1;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_data3_->_data2_ = block2_data_ref (_data_->_data2_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_tmp1_ = _data_->_tmp0_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			if (!_data_->_tmp1_) {
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp3_ = _data_->_data2_->restart;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				if (_data_->_tmp3_) {
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp4_ = _data_->_data2_->restart_count;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp2_ = _data_->_tmp4_ < 10;
#line 1251 "rygel-simple-container.c"
				} else {
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp2_ = FALSE;
#line 1255 "rygel-simple-container.c"
				}
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp5_ = _data_->_tmp2_;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				if (!_data_->_tmp5_) {
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					block3_data_unref (_data_->_data3_);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_data3_ = NULL;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					break;
#line 1267 "rygel-simple-container.c"
				}
			}
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_tmp0_ = FALSE;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_data2_->restart = FALSE;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_data3_->updated_id = (gulong) 0;
#line 1276 "rygel-simple-container.c"
			{
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp6_ = _data_->self->children;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_child_list = _data_->_tmp7_;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp8_ = _data_->_child_list;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp9_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp8_);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp10_ = _data_->_tmp9_;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_child_size = _data_->_tmp10_;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_child_index = -1;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				while (TRUE) {
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp11_ = _data_->_child_index;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_child_index = _data_->_tmp11_ + 1;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp12_ = _data_->_child_index;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp13_ = _data_->_child_size;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					if (!(_data_->_tmp12_ < _data_->_tmp13_)) {
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						break;
#line 1308 "rygel-simple-container.c"
					}
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp14_ = _data_->_child_list;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp15_ = _data_->_child_index;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp16_ = NULL;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp14_, _data_->_tmp15_);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->child = (RygelMediaObject*) _data_->_tmp16_;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp17_ = _data_->child;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp18_ = _data_->_tmp17_->id;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp19_ = _data_->id;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					if (g_strcmp0 (_data_->_tmp18_, _data_->_tmp19_) == 0) {
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_data_->_tmp20_ = _data_->child;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_data_->_tmp21_ = _g_object_ref0 (_data_->_tmp20_);
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_g_object_unref0 (_data_->media_object);
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_data_->media_object = _data_->_tmp21_;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_g_object_unref0 (_data_->child);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						break;
#line 1340 "rygel-simple-container.c"
					} else {
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_data_->_tmp22_ = _data_->child;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp22_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp23_ = 0UL;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp23_ = g_signal_connect_data ((RygelMediaContainer*) _data_->self, "container-updated", (GCallback) _________lambda15__rygel_media_container_container_updated, block3_data_ref (_data_->_data3_), (GClosureNotify) block3_data_unref, 0);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_data3_->updated_id = _data_->_tmp23_;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp24_ = _data_->child;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp24_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _data_->_tmp24_) : NULL);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->container = _data_->_tmp25_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp26_ = _data_->container;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp27_ = _data_->id;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp28_ = _data_->cancellable;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_state_ = 1;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							rygel_media_container_find_object (_data_->_tmp26_, _data_->_tmp27_, _data_->_tmp28_, rygel_simple_container_find_object_ready, _data_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							return FALSE;
#line 1370 "rygel-simple-container.c"
							_state_1:
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp29_ = NULL;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp29_ = rygel_media_container_find_object_finish (_data_->_tmp26_, _data_->_res_, &_data_->_inner_error_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp30_ = _data_->_tmp29_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							if (_data_->_inner_error_ != NULL) {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								g_error_free (_data_->_inner_error_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->container);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->child);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->_child_list);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								block3_data_unref (_data_->_data3_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_data_->_data3_ = NULL;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->media_object);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								block2_data_unref (_data_->_data2_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_data_->_data2_ = NULL;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								if (_data_->_state_ == 0) {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
									g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1404 "rygel-simple-container.c"
								} else {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
									g_simple_async_result_complete (_data_->_async_result);
#line 1408 "rygel-simple-container.c"
								}
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								g_object_unref (_data_->_async_result);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								return FALSE;
#line 1414 "rygel-simple-container.c"
							}
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_g_object_unref0 (_data_->media_object);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->media_object = _data_->_tmp30_;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp31_ = _data_->_data3_->updated_id;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							if (_data_->_tmp31_ != ((gulong) 0)) {
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_data_->_tmp32_ = _data_->_data3_->updated_id;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								g_signal_handler_disconnect ((GObject*) _data_->self, _data_->_tmp32_);
#line 1428 "rygel-simple-container.c"
							}
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp33_ = _data_->media_object;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							if (_data_->_tmp33_ != NULL) {
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_data_->_data2_->restart = FALSE;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->container);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->child);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								break;
#line 1442 "rygel-simple-container.c"
							}
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp34_ = _data_->_data2_->restart;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							if (_data_->_tmp34_) {
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->container);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->child);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								break;
#line 1454 "rygel-simple-container.c"
							}
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_g_object_unref0 (_data_->container);
#line 1458 "rygel-simple-container.c"
						}
					}
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_g_object_unref0 (_data_->child);
#line 1463 "rygel-simple-container.c"
				}
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_g_object_unref0 (_data_->_child_list);
#line 1467 "rygel-simple-container.c"
			}
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			block3_data_unref (_data_->_data3_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_data3_ = NULL;
#line 1473 "rygel-simple-container.c"
		}
	}
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->result = _data_->media_object;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	block2_data_unref (_data_->_data2_);
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_ = NULL;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1486 "rygel-simple-container.c"
	} else {
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1490 "rygel-simple-container.c"
	}
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->media_object);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	block2_data_unref (_data_->_data2_);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_ = NULL;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1506 "rygel-simple-container.c"
	} else {
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1510 "rygel-simple-container.c"
	}
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 1516 "rygel-simple-container.c"
}


static void rygel_simple_container_real_search_data_free (gpointer _data) {
	RygelSimpleContainerSearchData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_slice_free (RygelSimpleContainerSearchData, _data_);
#line 1535 "rygel-simple-container.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 1542 "rygel-simple-container.c"
}


static void rygel_simple_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainer * self;
	RygelSimpleContainerSearchData* _data_;
	RygelSimpleContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = g_slice_new0 (RygelSimpleContainerSearchData);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_real_search);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_real_search_data_free);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = expression;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->expression = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp3_ = offset;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->offset = _tmp3_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp4_ = max_count;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->max_count = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp5_ = sort_criteria;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->sort_criteria = _tmp6_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp7_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->cancellable = _tmp8_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_real_search_co (_data_);
#line 1598 "rygel-simple-container.c"
}


static RygelMediaObjects* rygel_simple_container_real_search_finish (RygelSearchableContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelSimpleContainerSearchData* _data_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		return NULL;
#line 1609 "rygel-simple-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (total_matches) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		*total_matches = _data_->total_matches;
#line 1617 "rygel-simple-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return result;
#line 1625 "rygel-simple-container.c"
}


static void rygel_simple_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSimpleContainerSearchData* _data_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = _user_data_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_source_object_ = source_object;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_res_ = _res_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_real_search_co (_data_);
#line 1639 "rygel-simple-container.c"
}


static gboolean rygel_simple_container_real_search_co (RygelSimpleContainerSearchData* _data_) {
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	switch (_data_->_state_) {
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case 0:
#line 1648 "rygel-simple-container.c"
		goto _state_0;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case 1:
#line 1652 "rygel-simple-container.c"
		goto _state_1;
		default:
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_assert_not_reached ();
#line 1657 "rygel-simple-container.c"
	}
	_state_0:
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp0_ = _data_->expression;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp1_ = _data_->offset;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp2_ = _data_->max_count;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp3_ = _data_->sort_criteria;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp4_ = _data_->cancellable;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp5_ = 0U;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_state_ = 1;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, rygel_simple_container_search_ready, _data_);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 1678 "rygel-simple-container.c"
	_state_1:
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp6_ = NULL;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp6_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->total_matches = _data_->_tmp5_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_error_free (_data_->_inner_error_);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		if (_data_->_state_ == 0) {
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1698 "rygel-simple-container.c"
		} else {
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1702 "rygel-simple-container.c"
		}
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_object_unref (_data_->_async_result);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		return FALSE;
#line 1708 "rygel-simple-container.c"
	}
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->result = _data_->_tmp7_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1716 "rygel-simple-container.c"
	} else {
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1720 "rygel-simple-container.c"
	}
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1730 "rygel-simple-container.c"
	} else {
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1734 "rygel-simple-container.c"
	}
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 1740 "rygel-simple-container.c"
}


static void rygel_simple_container_add_child (RygelSimpleContainer* self, RygelMediaObject* child) {
	RygelMediaObjects* _tmp0_;
	RygelMediaObject* _tmp1_;
	gint _tmp2_;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (child != NULL);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = self->children;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = child;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = ((RygelMediaContainer*) self)->child_count;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	((RygelMediaContainer*) self)->child_count = _tmp2_ + 1;
#line 1762 "rygel-simple-container.c"
}


static void rygel_simple_container_on_container_updated (RygelSimpleContainer* self, RygelMediaContainer* source, RygelMediaContainer* updated) {
	RygelMediaContainer* _tmp0_;
	gint _tmp1_;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (source != NULL);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (updated != NULL);
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = updated;
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = _tmp0_->child_count;
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_tmp1_ > 0) {
#line 1781 "rygel-simple-container.c"
		RygelMediaObjects* _tmp2_;
		RygelMediaContainer* _tmp3_;
		gboolean _tmp4_ = FALSE;
		RygelMediaObjects* _tmp5_;
		RygelMediaContainer* _tmp6_;
		RygelMediaContainer* _tmp7_;
		RygelMediaContainer* _tmp8_;
		const gchar* _tmp9_;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp2_ = self->priv->empty_children;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp3_ = updated;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp4_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp2_, (RygelMediaObject*) _tmp3_);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		if (!_tmp4_) {
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			return;
#line 1800 "rygel-simple-container.c"
		}
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp5_ = self->priv->empty_children;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp6_ = updated;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp5_, (RygelMediaObject*) _tmp6_);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp7_ = updated;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_simple_container_add_child (self, (RygelMediaObject*) _tmp7_);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_media_container_updated ((RygelMediaContainer*) self);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp8_ = updated;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp9_ = ((RygelMediaObject*) _tmp8_)->id;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_debug ("rygel-simple-container.vala:228: Container '%s' now non-empty, added i" \
"t to hierarchy now.", _tmp9_);
#line 1820 "rygel-simple-container.c"
	} else {
		RygelMediaObjects* _tmp10_;
		RygelMediaContainer* _tmp11_;
		gboolean _tmp12_ = FALSE;
		RygelMediaContainer* _tmp13_;
		RygelMediaObjects* _tmp14_;
		RygelMediaContainer* _tmp15_;
		RygelMediaContainer* _tmp16_;
		const gchar* _tmp17_;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp10_ = self->children;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp11_ = updated;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp12_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp10_, (RygelMediaObject*) _tmp11_);
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		if (!_tmp12_) {
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			return;
#line 1840 "rygel-simple-container.c"
		}
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp13_ = updated;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_simple_container_remove_child (self, (RygelMediaObject*) _tmp13_);
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp14_ = self->priv->empty_children;
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp15_ = updated;
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, (RygelMediaObject*) _tmp15_);
#line 238 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_media_container_updated ((RygelMediaContainer*) self);
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp16_ = updated;
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp17_ = ((RygelMediaObject*) _tmp16_)->id;
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_debug ("rygel-simple-container.vala:240: Container '%s' now empty, removing it" \
" from hierarchy now.", _tmp17_);
#line 1860 "rygel-simple-container.c"
	}
}


static GeeArrayList* rygel_simple_container_real_get_search_classes (RygelSearchableContainer* base) {
	GeeArrayList* result;
	RygelSimpleContainer* self;
	GeeArrayList* _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = self->priv->_search_classes;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return result;
#line 1877 "rygel-simple-container.c"
}


static void rygel_simple_container_real_set_search_classes (RygelSearchableContainer* base, GeeArrayList* value) {
	RygelSimpleContainer* self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = value;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self->priv->_search_classes = _tmp1_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_notify ((GObject *) self, "search-classes");
#line 1897 "rygel-simple-container.c"
}


static void rygel_simple_container_class_init (RygelSimpleContainerClass * klass) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_type_class_add_private (klass, sizeof (RygelSimpleContainerPrivate));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_simple_container_real_get_children;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_simple_container_real_get_children_finish;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_simple_container_real_find_object;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_simple_container_real_find_object_finish;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_simple_container_get_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_simple_container_set_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_simple_container_finalize;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1922 "rygel-simple-container.c"
}


static void rygel_simple_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	iface->search = (RygelMediaObjects* (*)(RygelSearchableContainer*, RygelSearchExpression*, guint, guint, guint*, const gchar*, GCancellable*, GError**)) rygel_simple_container_real_search;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	iface->search_finish = rygel_simple_container_real_search_finish;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	iface->get_search_classes = rygel_simple_container_real_get_search_classes;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	iface->set_search_classes = rygel_simple_container_real_set_search_classes;
#line 1937 "rygel-simple-container.c"
}


static void rygel_simple_container_instance_init (RygelSimpleContainer * self) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self->priv = RYGEL_SIMPLE_CONTAINER_GET_PRIVATE (self);
#line 1944 "rygel-simple-container.c"
}


static void rygel_simple_container_finalize (GObject* obj) {
	RygelSimpleContainer * self;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (self->children);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (self->priv->empty_children);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	G_OBJECT_CLASS (rygel_simple_container_parent_class)->finalize (obj);
#line 1960 "rygel-simple-container.c"
}


/**
 * A simple implementation of MediaContainer that keeps all MediaObjects
 * in memory. In order for it to be of any use, you must add children to
 * children ArrayList field.
 */
GType rygel_simple_container_get_type (void) {
	static volatile gsize rygel_simple_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_simple_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSimpleContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_simple_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSimpleContainer), 0, (GInstanceInitFunc) rygel_simple_container_instance_init, NULL };
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_simple_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_simple_container_type_id;
		rygel_simple_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelSimpleContainer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_simple_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		g_once_init_leave (&rygel_simple_container_type_id__volatile, rygel_simple_container_type_id);
	}
	return rygel_simple_container_type_id__volatile;
}


static void _vala_rygel_simple_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelSimpleContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		break;
#line 1994 "rygel-simple-container.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		break;
#line 2000 "rygel-simple-container.c"
	}
}


static void _vala_rygel_simple_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelSimpleContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		break;
#line 2016 "rygel-simple-container.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		break;
#line 2022 "rygel-simple-container.c"
	}
}



