/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*- */
/*
 * Copyright (C) 2012 Red Hat
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA
 *
 * Written by:
 *     Jasper St. Pierre <jstpierre@mecheye.net>
 */


#include "config.h"

#include <glib-object.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>

#include "gis-assistant-gtk.h"
#include "gis-assistant-private.h"

G_DEFINE_TYPE (GisAssistantGtk, gis_assistant_gtk, GIS_TYPE_ASSISTANT)

#define GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GIS_TYPE_ASSISTANT_GTK, GisAssistantGtkPrivate))

struct _GisAssistantGtkPrivate
{
  GtkWidget *frame;
};

static void
set_current_page (GisAssistant *assistant,
                  GtkWidget    *new_page)
{
  GisAssistantGtkPrivate *priv = GIS_ASSISTANT_GTK (assistant)->priv;
  GtkBin *bin = GTK_BIN (priv->frame);

  GtkWidget *old_page = gtk_bin_get_child (bin);

  if (old_page != NULL)
    gtk_container_remove (GTK_CONTAINER (bin), old_page);

  if (new_page != NULL)
    gtk_container_add (GTK_CONTAINER (bin), new_page);

  _gis_assistant_current_page_changed (assistant, new_page);
}

static void
gis_assistant_gtk_switch_to (GisAssistant *assistant,
                             GtkWidget    *widget)
{
  set_current_page (assistant, widget);
}

static void
gis_assistant_gtk_add_page (GisAssistant *assistant,
                            GtkWidget    *widget)
{
  GisAssistantGtkPrivate *priv = GIS_ASSISTANT_GTK (assistant)->priv;
  GtkWidget *old_child = gtk_bin_get_child (GTK_BIN (priv->frame));

  if (old_child == NULL)
    set_current_page (assistant, widget);
}

static void
gis_assistant_gtk_init (GisAssistantGtk *assistant_gtk)
{
  GisAssistantGtkPrivate *priv = GET_PRIVATE (assistant_gtk);
  GisAssistant *assistant = GIS_ASSISTANT (assistant_gtk);

  assistant_gtk->priv = priv;

  priv->frame = _gis_assistant_get_frame (assistant);
}

static void
gis_assistant_gtk_class_init (GisAssistantGtkClass *klass)
{
  GisAssistantClass *assistant_class = GIS_ASSISTANT_CLASS (klass);

  g_type_class_add_private (klass, sizeof (GisAssistantGtkPrivate));

  assistant_class->switch_to = gis_assistant_gtk_switch_to;
  assistant_class->add_page = gis_assistant_gtk_add_page;
}
