/* rygel-http-get-test.c generated by valac 0.16.1, the Vala compiler
 * generated from rygel-http-get-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;
#define __vala_SoupMessageHeaders_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMessageHeaders_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelParamSpecClientHacks RygelParamSpecClientHacks;

#define RYGEL_TYPE_TEST_REQUEST_FACTORY (rygel_test_request_factory_get_type ())
#define RYGEL_TEST_REQUEST_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactory))
#define RYGEL_TEST_REQUEST_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactoryClass))
#define RYGEL_IS_TEST_REQUEST_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TEST_REQUEST_FACTORY))
#define RYGEL_IS_TEST_REQUEST_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TEST_REQUEST_FACTORY))
#define RYGEL_TEST_REQUEST_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactoryClass))

typedef struct _RygelTestRequestFactory RygelTestRequestFactory;
typedef struct _RygelTestRequestFactoryClass RygelTestRequestFactoryClass;
typedef struct _RygelTestRequestFactoryPrivate RygelTestRequestFactoryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _rygel_http_get_handler_unref0(var) ((var == NULL) ? NULL : (var = (rygel_http_get_handler_unref (var), NULL)))
typedef struct _RygelParamSpecTestRequestFactory RygelParamSpecTestRequestFactory;

#define RYGEL_TYPE_HTTP_GET_TEST (rygel_http_get_test_get_type ())
#define RYGEL_HTTP_GET_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTest))
#define RYGEL_HTTP_GET_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestClass))
#define RYGEL_IS_HTTP_GET_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_TEST))
#define RYGEL_IS_HTTP_GET_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_TEST))
#define RYGEL_HTTP_GET_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestClass))

typedef struct _RygelHTTPGetTest RygelHTTPGetTest;
typedef struct _RygelHTTPGetTestClass RygelHTTPGetTestClass;
typedef struct _RygelHTTPGetTestPrivate RygelHTTPGetTestPrivate;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_test_request_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_test_request_factory_unref (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _RygelHttpGetTestHandleClientMessageData RygelHttpGetTestHandleClientMessageData;
#define _rygel_media_object_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_object_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _Block1Data Block1Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _Block2Data Block2Data;
typedef struct _RygelMediaContainerFindObjectData RygelMediaContainerFindObjectData;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelParamSpecHTTPGetHandler RygelParamSpecHTTPGetHandler;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;
typedef struct _RygelHTTPTranscodeHandlerPrivate RygelHTTPTranscodeHandlerPrivate;

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHTTPIdentityHandlerPrivate RygelHTTPIdentityHandlerPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
typedef struct _RygelParamSpecThumbnail RygelParamSpecThumbnail;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
typedef struct _RygelParamSpecSubtitle RygelParamSpecSubtitle;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;
typedef struct _Block3Data Block3Data;
typedef struct _RygelHttpResponseRunData RygelHttpResponseRunData;
typedef struct _RygelParamSpecMediaObject RygelParamSpecMediaObject;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelClientHacks {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelClientHacksPrivate * priv;
};

struct _RygelClientHacksClass {
	GTypeClass parent_class;
	void (*finalize) (RygelClientHacks *self);
};

struct _RygelParamSpecClientHacks {
	GParamSpec parent_instance;
};

struct _RygelTestRequestFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTestRequestFactoryPrivate * priv;
	SoupMessage* msg;
	SoupKnownStatusCode expected_code;
};

struct _RygelTestRequestFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTestRequestFactory *self);
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelParamSpecTestRequestFactory {
	GParamSpec parent_instance;
};

struct _RygelHTTPGetTest {
	GObject parent_instance;
	RygelHTTPGetTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
};

struct _RygelHTTPGetTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPGetTest* self, GError** error);
};

struct _RygelHTTPGetTestPrivate {
	gboolean server_done;
	gboolean client_done;
	GMainLoop* main_loop;
	GError* error;
	GeeArrayList* requests;
	RygelTestRequestFactory* current_request;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	GUPnPContext* context;
	SoupMessage* msg;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _RygelHttpGetTestHandleClientMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGetTest* self;
	SoupMessage* msg;
	SoupMessage* _tmp0_;
	RygelHTTPGet* _tmp1_;
	RygelHTTPGet* request;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* _tmp3_;
	RygelMediaItem* _tmp4_;
	SoupMessage* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	SoupMessage* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	RygelTestRequestFactory* _tmp11_;
	SoupKnownStatusCode _tmp12_;
	gboolean _tmp13_;
	GMainLoop* _tmp14_;
	GError* _error_;
	GError* _tmp15_;
	GError* _tmp16_;
	GMainLoop* _tmp17_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* mime_type;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPClientPrivate {
	GCancellable* _cancellable;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPClient * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	Block1Data* _data1_;
	GUPnPContext* _tmp0_;
	SoupSession* _tmp1_;
	SoupSession* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	RygelMediaContainer * self;
	GSourceFunc find_object_continue;
	gpointer find_object_continue_target;
	GDestroyNotify find_object_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediaContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	gchar* item_id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	Block2Data* _data2_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	RygelVideoItem* _tmp2_;
	const gchar* _tmp3_;
	RygelAudioItem* _tmp4_;
};

struct _RygelHTTPGetHandler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GTypeClass parent_class;
	void (*finalize) (RygelHTTPGetHandler *self);
};

struct _RygelParamSpecHTTPGetHandler {
	GParamSpec parent_instance;
};

struct _RygelHTTPTranscodeHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPTranscodeHandlerPrivate * priv;
};

struct _RygelHTTPTranscodeHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPIdentityHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPIdentityHandlerPrivate * priv;
};

struct _RygelHTTPIdentityHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	GeeArrayList* subtitles;
	GeeArrayList* thumbnails;
	GeeArrayList* uris;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVideoItemPrivate {
	gint _width;
	gint _height;
	gint _pixel_width;
	gint _pixel_height;
	gint _color_depth;
	GeeArrayList* ts;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelThumbnail {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelThumbnailPrivate * priv;
	glong size;
	gchar* file_extension;
};

struct _RygelThumbnailClass {
	GTypeClass parent_class;
	void (*finalize) (RygelThumbnail *self);
};

struct _RygelParamSpecThumbnail {
	GParamSpec parent_instance;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	glong size;
	gchar* caption_type;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

struct _RygelParamSpecSubtitle {
	GParamSpec parent_instance;
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
};

struct _RygelHTTPResponsePrivate {
	GCancellable* _cancellable;
	SoupMessage* msg;
	SoupServer* server;
};

struct _Block3Data {
	int _ref_count_;
	RygelHTTPResponse * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpResponseRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPResponse* self;
	Block3Data* _data3_;
	SoupMessage* _tmp0_;
	SoupServer* _tmp1_;
	SoupMessage* _tmp2_;
};

struct _RygelParamSpecMediaObject {
	GParamSpec parent_instance;
};

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
};

struct _RygelTranscoderPrivate {
	gchar* _extension;
};


static gpointer rygel_client_hacks_parent_class = NULL;
static gpointer rygel_test_request_factory_parent_class = NULL;
static gpointer rygel_http_get_test_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;
static RygelStateMachineIface* rygel_http_client_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_http_get_handler_parent_class = NULL;
static gpointer rygel_http_transcode_handler_parent_class = NULL;
static gpointer rygel_http_identity_handler_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_audio_item_parent_class = NULL;
static gpointer rygel_video_item_parent_class = NULL;
static RygelVisualItemIface* rygel_video_item_rygel_visual_item_parent_iface = NULL;
static gpointer rygel_music_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_http_response_parent_class = NULL;
static RygelStateMachineIface* rygel_http_response_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_object_parent_class = NULL;
static gpointer rygel_transcoder_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GQuark rygel_client_hacks_error_quark (void);
gpointer rygel_client_hacks_ref (gpointer instance);
void rygel_client_hacks_unref (gpointer instance);
GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_client_hacks (GValue* value, gpointer v_object);
void rygel_value_take_client_hacks (GValue* value, gpointer v_object);
gpointer rygel_value_get_client_hacks (const GValue* value);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_CLIENT_HACKS_DUMMY_PROPERTY
};
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self);
RygelClientHacks* rygel_client_hacks_new (void);
RygelClientHacks* rygel_client_hacks_construct (GType object_type);
static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self);
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_client_hacks_apply (RygelClientHacks* self, RygelMediaItem* item);
static void rygel_client_hacks_finalize (RygelClientHacks* obj);
gpointer rygel_test_request_factory_ref (gpointer instance);
void rygel_test_request_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_test_request_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_test_request_factory (GValue* value, gpointer v_object);
void rygel_value_take_test_request_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_test_request_factory (const GValue* value);
GType rygel_test_request_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_TEST_REQUEST_FACTORY_DUMMY_PROPERTY
};
RygelTestRequestFactory* rygel_test_request_factory_new (SoupMessage* msg, SoupKnownStatusCode expected_code);
RygelTestRequestFactory* rygel_test_request_factory_construct (GType object_type, SoupMessage* msg, SoupKnownStatusCode expected_code);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
RygelHTTPGet* rygel_test_request_factory_create_get (RygelTestRequestFactory* self, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
gpointer rygel_http_get_handler_ref (gpointer instance);
void rygel_http_get_handler_unref (gpointer instance);
GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_http_get_handler (GValue* value, gpointer v_object);
void rygel_value_take_http_get_handler (GValue* value, gpointer v_object);
gpointer rygel_value_get_http_get_handler (const GValue* value);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
static void rygel_test_request_factory_finalize (RygelTestRequestFactory* obj);
GType rygel_http_get_test_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestPrivate))
enum  {
	RYGEL_HTTP_GET_TEST_DUMMY_PROPERTY
};
gint rygel_http_get_test_main (gchar** args, int args_length1);
RygelHTTPGetTest* rygel_http_get_test_new (GError** error);
RygelHTTPGetTest* rygel_http_get_test_construct (GType object_type, GError** error);
void rygel_http_get_test_run (RygelHTTPGetTest* self, GError** error);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context);
static void rygel_http_get_test_create_test_messages (RygelHTTPGetTest* self);
static void rygel_http_get_test_real_run (RygelHTTPGetTest* self, GError** error);
static gboolean rygel_http_get_test_on_timeout (RygelHTTPGetTest* self);
static gboolean _rygel_http_get_test_on_timeout_gsource_func (gpointer self);
static void rygel_http_get_test_on_message_received (RygelHTTPGetTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_get_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
static void rygel_http_get_test_on_client_completed (RygelHTTPGetTest* self, RygelStateMachine* client);
static void _rygel_http_get_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
static void rygel_http_get_test_start_next_test_request (RygelHTTPGetTest* self);
gchar* rygel_http_server_get_uri (RygelHTTPServer* self);
gchar* rygel_http_server_create_uri (RygelHTTPServer* self, const gchar* item_id);
static RygelHTTPGet* rygel_http_get_test_create_request (RygelHTTPGetTest* self, SoupMessage* msg, GError** error);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static void rygel_http_get_test_handle_client_message (RygelHTTPGetTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_test_handle_client_message_finish (RygelHTTPGetTest* self, GAsyncResult* _res_);
static void rygel_http_get_test_handle_client_message_data_free (gpointer _data);
static gboolean rygel_http_get_test_handle_client_message_co (RygelHttpGetTestHandleClientMessageData* _data_);
static void rygel_http_get_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_get_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
RygelVideoItem* rygel_video_item_new (void);
RygelVideoItem* rygel_video_item_construct (GType object_type);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client);
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self);
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
RygelTranscoder* rygel_transcoder_new (const gchar* extension);
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* extension);
GQuark rygel_http_request_error_quark (void);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientPrivate))
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY,
	RYGEL_HTTP_CLIENT_CANCELLABLE
};
static void rygel_http_client_real_run_data_free (gpointer _data);
static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self);
static void __lambda5_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg);
static void ___lambda5__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void rygel_http_client_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
static void rygel_media_container_find_object_data_free (gpointer _data);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self);
static gboolean __lambda2_ (Block2Data* _data2_);
static gboolean ___lambda2__gsource_func (gpointer self);
RygelAudioItem* rygel_audio_item_new (void);
RygelAudioItem* rygel_audio_item_construct (GType object_type);
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
enum  {
	RYGEL_HTTP_GET_HANDLER_DUMMY_PROPERTY
};
GType rygel_http_response_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* get_request);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* get_request);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
gboolean rygel_http_get_handler_knows_size (RygelHTTPGetHandler* self, RygelHTTPGet* request);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
static void rygel_http_get_handler_finalize (RygelHTTPGetHandler* obj);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TRANSCODE_HANDLER_DUMMY_PROPERTY
};
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_IDENTITY_HANDLER_DUMMY_PROPERTY
};
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable);
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_media_item_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_AUDIO_ITEM_DUMMY_PROPERTY
};
static void rygel_audio_item_finalize (RygelMediaObject* obj);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
gboolean rygel_visual_item_is_live_stream (RygelVisualItem* self);
gboolean rygel_visual_item_streamable (RygelVisualItem* self);
gint rygel_visual_item_get_width (RygelVisualItem* self);
void rygel_visual_item_set_width (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_height (RygelVisualItem* self);
void rygel_visual_item_set_height (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_pixel_width (RygelVisualItem* self);
void rygel_visual_item_set_pixel_width (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_pixel_height (RygelVisualItem* self);
void rygel_visual_item_set_pixel_height (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value);
#define RYGEL_VIDEO_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemPrivate))
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_video_item_finalize (RygelMediaObject* obj);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY
};
RygelMusicItem* rygel_music_item_new (void);
RygelMusicItem* rygel_music_item_construct (GType object_type);
static void rygel_music_item_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
static void rygel_thumbnail_finalize (RygelThumbnail* obj);
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (RygelSubtitle* obj);
#define RYGEL_HTTP_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponsePrivate))
enum  {
	RYGEL_HTTP_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_RESPONSE_CANCELLABLE
};
static void rygel_http_response_real_run_data_free (gpointer _data);
static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self);
static gboolean __lambda3_ (Block3Data* _data3_);
static gboolean ___lambda3__gsource_func (gpointer self);
static void rygel_http_response_finalize (GObject* obj);
static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
static void rygel_media_object_finalize (RygelMediaObject* obj);
#define RYGEL_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRANSCODER, RygelTranscoderPrivate))
enum  {
	RYGEL_TRANSCODER_DUMMY_PROPERTY,
	RYGEL_TRANSCODER_EXTENSION
};
void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value);
const gchar* rygel_transcoder_get_extension (RygelTranscoder* self);
static void rygel_transcoder_finalize (GObject* obj);
static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


GQuark rygel_client_hacks_error_quark (void) {
	return g_quark_from_static_string ("rygel_client_hacks_error-quark");
}


static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self) {
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return g_boxed_copy (soup_message_headers_get_type (), self);
#line 1048 "rygel-http-get-test.c"
}


static gpointer __vala_SoupMessageHeaders_copy0 (gpointer self) {
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? _vala_SoupMessageHeaders_copy (self) : NULL;
#line 1055 "rygel-http-get-test.c"
}


static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self) {
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_boxed_free (soup_message_headers_get_type (), self);
#line 1062 "rygel-http-get-test.c"
}


RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error) {
	RygelClientHacks* result = NULL;
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	SoupMessageHeaders* _tmp2_;
	SoupMessageHeaders* headers;
	SoupMessageHeaders* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = message;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _tmp0_->request_headers;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = __vala_SoupMessageHeaders_copy0 (_tmp1_);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	headers = _tmp2_;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = headers;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = soup_message_headers_get_one (_tmp3_, "clienthacks.test.rygel");
#line 39 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_tmp4_ != NULL) {
#line 1089 "rygel-http-get-test.c"
		RygelClientHacks* _tmp5_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp5_ = rygel_client_hacks_new ();
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = _tmp5_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		__vala_SoupMessageHeaders_free0 (headers);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 1099 "rygel-http-get-test.c"
	} else {
		GError* _tmp6_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp6_ = g_error_new_literal (RYGEL_CLIENT_HACKS_ERROR, RYGEL_CLIENT_HACKS_ERROR_NA, "");
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = _tmp6_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_propagate_error (error, _inner_error_);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		__vala_SoupMessageHeaders_free0 (headers);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return NULL;
#line 1112 "rygel-http-get-test.c"
	}
#line 37 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	__vala_SoupMessageHeaders_free0 (headers);
#line 1116 "rygel-http-get-test.c"
}


void rygel_client_hacks_apply (RygelClientHacks* self, RygelMediaItem* item) {
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 1123 "rygel-http-get-test.c"
}


RygelClientHacks* rygel_client_hacks_construct (GType object_type) {
	RygelClientHacks* self = NULL;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelClientHacks*) g_type_create_instance (object_type);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 1133 "rygel-http-get-test.c"
}


RygelClientHacks* rygel_client_hacks_new (void) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_client_hacks_construct (RYGEL_TYPE_CLIENT_HACKS);
#line 1140 "rygel-http-get-test.c"
}


static void rygel_value_client_hacks_init (GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 1147 "rygel-http-get-test.c"
}


static void rygel_value_client_hacks_free_value (GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_unref (value->data[0].v_pointer);
#line 1156 "rygel-http-get-test.c"
	}
}


static void rygel_value_client_hacks_copy_value (const GValue* src_value, GValue* dest_value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_client_hacks_ref (src_value->data[0].v_pointer);
#line 1166 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1170 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_client_hacks_peek_pointer (const GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 1178 "rygel-http-get-test.c"
}


static gchar* rygel_value_client_hacks_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 1185 "rygel-http-get-test.c"
		RygelClientHacks* object;
		object = collect_values[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1192 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1196 "rygel-http-get-test.c"
		}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_client_hacks_ref (object);
#line 1200 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1204 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 1208 "rygel-http-get-test.c"
}


static gchar* rygel_value_client_hacks_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelClientHacks** object_p;
	object_p = collect_values[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1219 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 1225 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 1229 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_client_hacks_ref (value->data[0].v_pointer);
#line 1233 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 1237 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecClientHacks* spec;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_CLIENT_HACKS), NULL);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 1251 "rygel-http-get-test.c"
}


gpointer rygel_value_get_client_hacks (const GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS), NULL);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 1260 "rygel-http-get-test.c"
}


void rygel_value_set_client_hacks (GValue* value, gpointer v_object) {
	RygelClientHacks* old;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_ref (value->data[0].v_pointer);
#line 1280 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1284 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_unref (old);
#line 1290 "rygel-http-get-test.c"
	}
}


void rygel_value_take_client_hacks (GValue* value, gpointer v_object) {
	RygelClientHacks* old;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 1309 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1313 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_unref (old);
#line 1319 "rygel-http-get-test.c"
	}
}


static void rygel_client_hacks_class_init (RygelClientHacksClass * klass) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_client_hacks_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_CLIENT_HACKS_CLASS (klass)->finalize = rygel_client_hacks_finalize;
#line 1329 "rygel-http-get-test.c"
}


static void rygel_client_hacks_instance_init (RygelClientHacks * self) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 1336 "rygel-http-get-test.c"
}


static void rygel_client_hacks_finalize (RygelClientHacks* obj) {
	RygelClientHacks * self;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_CLIENT_HACKS (obj);
#line 1344 "rygel-http-get-test.c"
}


GType rygel_client_hacks_get_type (void) {
	static volatile gsize rygel_client_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_client_hacks_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_client_hacks_init, rygel_value_client_hacks_free_value, rygel_value_client_hacks_copy_value, rygel_value_client_hacks_peek_pointer, "p", rygel_value_client_hacks_collect_value, "p", rygel_value_client_hacks_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelClientHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_client_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelClientHacks), 0, (GInstanceInitFunc) rygel_client_hacks_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_client_hacks_type_id;
		rygel_client_hacks_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelClientHacks", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_client_hacks_type_id__volatile, rygel_client_hacks_type_id);
	}
	return rygel_client_hacks_type_id__volatile;
}


gpointer rygel_client_hacks_ref (gpointer instance) {
	RygelClientHacks* self;
	self = instance;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 1369 "rygel-http-get-test.c"
}


void rygel_client_hacks_unref (gpointer instance) {
	RygelClientHacks* self;
	self = instance;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_CLIENT_HACKS_GET_CLASS (self)->finalize (self);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1382 "rygel-http-get-test.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 56 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 1390 "rygel-http-get-test.c"
}


RygelTestRequestFactory* rygel_test_request_factory_construct (GType object_type, SoupMessage* msg, SoupKnownStatusCode expected_code) {
	RygelTestRequestFactory* self = NULL;
	SoupMessage* _tmp0_;
	SoupMessage* _tmp1_;
	SoupKnownStatusCode _tmp2_;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelTestRequestFactory*) g_type_create_instance (object_type);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = msg;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->msg);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->msg = _tmp1_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = expected_code;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->expected_code = _tmp2_;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 1417 "rygel-http-get-test.c"
}


RygelTestRequestFactory* rygel_test_request_factory_new (SoupMessage* msg, SoupKnownStatusCode expected_code) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_test_request_factory_construct (RYGEL_TYPE_TEST_REQUEST_FACTORY, msg, expected_code);
#line 1424 "rygel-http-get-test.c"
}


RygelHTTPGet* rygel_test_request_factory_create_get (RygelTestRequestFactory* self, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPGet* result = NULL;
	RygelHTTPServer* _tmp0_;
	SoupServer* _tmp1_;
	SoupMessage* _tmp2_;
	RygelHTTPGet* _tmp3_;
	RygelHTTPGet* request;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = http_server;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = server;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = msg;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = rygel_http_get_new (_tmp0_, _tmp1_, _tmp2_);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp3_;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_http_get_handler_unref0 (request->handler);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request->handler = NULL;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = request;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 1461 "rygel-http-get-test.c"
}


static void rygel_value_test_request_factory_init (GValue* value) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 1468 "rygel-http-get-test.c"
}


static void rygel_value_test_request_factory_free_value (GValue* value) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_test_request_factory_unref (value->data[0].v_pointer);
#line 1477 "rygel-http-get-test.c"
	}
}


static void rygel_value_test_request_factory_copy_value (const GValue* src_value, GValue* dest_value) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_test_request_factory_ref (src_value->data[0].v_pointer);
#line 1487 "rygel-http-get-test.c"
	} else {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1491 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_test_request_factory_peek_pointer (const GValue* value) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 1499 "rygel-http-get-test.c"
}


static gchar* rygel_value_test_request_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 1506 "rygel-http-get-test.c"
		RygelTestRequestFactory* object;
		object = collect_values[0].v_pointer;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1513 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1517 "rygel-http-get-test.c"
		}
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_test_request_factory_ref (object);
#line 1521 "rygel-http-get-test.c"
	} else {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1525 "rygel-http-get-test.c"
	}
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 1529 "rygel-http-get-test.c"
}


static gchar* rygel_value_test_request_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelTestRequestFactory** object_p;
	object_p = collect_values[0].v_pointer;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1540 "rygel-http-get-test.c"
	}
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 1546 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 1550 "rygel-http-get-test.c"
	} else {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_test_request_factory_ref (value->data[0].v_pointer);
#line 1554 "rygel-http-get-test.c"
	}
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 1558 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_test_request_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecTestRequestFactory* spec;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_TEST_REQUEST_FACTORY), NULL);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 1572 "rygel-http-get-test.c"
}


gpointer rygel_value_get_test_request_factory (const GValue* value) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TEST_REQUEST_FACTORY), NULL);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 1581 "rygel-http-get-test.c"
}


void rygel_value_set_test_request_factory (GValue* value, gpointer v_object) {
	RygelTestRequestFactory* old;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TEST_REQUEST_FACTORY));
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TEST_REQUEST_FACTORY));
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_test_request_factory_ref (value->data[0].v_pointer);
#line 1601 "rygel-http-get-test.c"
	} else {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1605 "rygel-http-get-test.c"
	}
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_test_request_factory_unref (old);
#line 1611 "rygel-http-get-test.c"
	}
}


void rygel_value_take_test_request_factory (GValue* value, gpointer v_object) {
	RygelTestRequestFactory* old;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TEST_REQUEST_FACTORY));
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TEST_REQUEST_FACTORY));
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 1630 "rygel-http-get-test.c"
	} else {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1634 "rygel-http-get-test.c"
	}
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_test_request_factory_unref (old);
#line 1640 "rygel-http-get-test.c"
	}
}


static void rygel_test_request_factory_class_init (RygelTestRequestFactoryClass * klass) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_test_request_factory_parent_class = g_type_class_peek_parent (klass);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_TEST_REQUEST_FACTORY_CLASS (klass)->finalize = rygel_test_request_factory_finalize;
#line 1650 "rygel-http-get-test.c"
}


static void rygel_test_request_factory_instance_init (RygelTestRequestFactory * self) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 1657 "rygel-http-get-test.c"
}


static void rygel_test_request_factory_finalize (RygelTestRequestFactory* obj) {
	RygelTestRequestFactory * self;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_TEST_REQUEST_FACTORY (obj);
#line 51 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->msg);
#line 1667 "rygel-http-get-test.c"
}


GType rygel_test_request_factory_get_type (void) {
	static volatile gsize rygel_test_request_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_test_request_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_test_request_factory_init, rygel_value_test_request_factory_free_value, rygel_value_test_request_factory_copy_value, rygel_value_test_request_factory_peek_pointer, "p", rygel_value_test_request_factory_collect_value, "p", rygel_value_test_request_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelTestRequestFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_test_request_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTestRequestFactory), 0, (GInstanceInitFunc) rygel_test_request_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_test_request_factory_type_id;
		rygel_test_request_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelTestRequestFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_test_request_factory_type_id__volatile, rygel_test_request_factory_type_id);
	}
	return rygel_test_request_factory_type_id__volatile;
}


gpointer rygel_test_request_factory_ref (gpointer instance) {
	RygelTestRequestFactory* self;
	self = instance;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 1692 "rygel-http-get-test.c"
}


void rygel_test_request_factory_unref (gpointer instance) {
	RygelTestRequestFactory* self;
	self = instance;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_TEST_REQUEST_FACTORY_GET_CLASS (self)->finalize (self);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1705 "rygel-http-get-test.c"
	}
}


gint rygel_http_get_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPGetTest* _tmp0_;
		RygelHTTPGetTest* test;
		RygelHTTPGetTest* _tmp1_;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp0_ = rygel_http_get_test_new (&_inner_error_);
#line 86 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		test = _tmp0_;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_ != NULL) {
#line 86 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 1725 "rygel-http-get-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp1_ = test;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_test_run (_tmp1_, &_inner_error_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_ != NULL) {
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_g_object_unref0 (test);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 1740 "rygel-http-get-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (test);
#line 1747 "rygel-http-get-test.c"
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		gint _tmp3_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_error_ = _inner_error_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp2_ = _error_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp3_ = _tmp2_->code;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = _tmp3_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_error_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 1769 "rygel-http-get-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_error_ = _inner_error_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = NULL;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp4_ = _error_;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp5_ = _tmp4_->message;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_critical ("rygel-http-get-test.vala:92: %s", _tmp5_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = -1;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_error_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 1793 "rygel-http-get-test.c"
	}
	__finally0:
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_inner_error_ != NULL) {
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_clear_error (&_inner_error_);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return 0;
#line 1804 "rygel-http-get-test.c"
	}
#line 97 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = 0;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 1810 "rygel-http-get-test.c"
}


int main (int argc, char ** argv) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_thread_init (NULL);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_init ();
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_get_test_main (argv, argc);
#line 1821 "rygel-http-get-test.c"
}


RygelHTTPGetTest* rygel_http_get_test_construct (GType object_type, GError** error) {
	RygelHTTPGetTest * self = NULL;
	RygelHTTPServer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	GUPnPContext* _tmp3_;
	RygelHTTPClient* _tmp4_;
	GMainLoop* _tmp5_;
	GError * _inner_error_ = NULL;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPGetTest*) g_object_new (object_type, NULL);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = rygel_http_server_new (&_inner_error_);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _tmp0_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_inner_error_ != NULL) {
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_propagate_error (error, _inner_error_);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (self);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return NULL;
#line 1848 "rygel-http-get-test.c"
	}
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->server);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->server = _tmp1_;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = self->server;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = _tmp2_->context;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = rygel_http_client_new (_tmp3_);
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->client);
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->client = _tmp4_;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = g_main_loop_new (NULL, FALSE);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->main_loop = _tmp5_;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_create_test_messages (self);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 1874 "rygel-http-get-test.c"
}


RygelHTTPGetTest* rygel_http_get_test_new (GError** error) {
#line 100 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_get_test_construct (RYGEL_TYPE_HTTP_GET_TEST, error);
#line 1881 "rygel-http-get-test.c"
}


static gboolean _rygel_http_get_test_on_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_get_test_on_timeout (self);
#line 108 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 1890 "rygel-http-get-test.c"
}


static void _rygel_http_get_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_on_message_received (self, _sender, message);
#line 1897 "rygel-http-get-test.c"
}


static void _rygel_http_get_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_on_client_completed (self, _sender);
#line 1904 "rygel-http-get-test.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? g_error_copy (self) : NULL;
#line 1911 "rygel-http-get-test.c"
}


static void rygel_http_get_test_real_run (RygelHTTPGetTest* self, GError** error) {
	RygelHTTPServer* _tmp0_;
	RygelHTTPClient* _tmp1_;
	GMainLoop* _tmp2_;
	GError* _tmp3_;
	GError * _inner_error_ = NULL;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _rygel_http_get_test_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->server;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_connect_object (_tmp0_, "message-received", (GCallback) _rygel_http_get_test_on_message_received_rygel_http_server_message_received, self, 0);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->client;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_connect_object ((RygelStateMachine*) _tmp1_, "completed", (GCallback) _rygel_http_get_test_on_client_completed_rygel_state_machine_completed, self, 0);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_start_next_test_request (self);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = self->priv->main_loop;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_main_loop_run (_tmp2_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->priv->error;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_tmp3_ != NULL) {
#line 1941 "rygel-http-get-test.c"
		GError* _tmp4_;
		GError* _tmp5_;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp4_ = self->priv->error;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = _tmp5_;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_propagate_error (error, _inner_error_);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return;
#line 1954 "rygel-http-get-test.c"
	}
}


void rygel_http_get_test_run (RygelHTTPGetTest* self, GError** error) {
#line 107 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_HTTP_GET_TEST_GET_CLASS (self)->run (self, error);
#line 1964 "rygel-http-get-test.c"
}


static void rygel_http_get_test_create_test_messages (RygelHTTPGetTest* self) {
	GeeArrayList* _tmp0_;
	RygelHTTPServer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessage* request;
	GeeArrayList* _tmp7_;
	SoupMessage* _tmp8_;
	RygelTestRequestFactory* _tmp9_;
	RygelTestRequestFactory* _tmp10_;
	RygelHTTPServer* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	SoupMessage* _tmp15_;
	GeeArrayList* _tmp16_;
	SoupMessage* _tmp17_;
	RygelTestRequestFactory* _tmp18_;
	RygelTestRequestFactory* _tmp19_;
	RygelHTTPServer* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	SoupMessage* _tmp24_;
	GeeArrayList* _tmp25_;
	SoupMessage* _tmp26_;
	RygelTestRequestFactory* _tmp27_;
	RygelTestRequestFactory* _tmp28_;
	RygelHTTPServer* _tmp29_;
	gchar* _tmp30_ = NULL;
	gchar* uri;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	SoupMessage* _tmp34_;
	GeeArrayList* _tmp35_;
	SoupMessage* _tmp36_;
	RygelTestRequestFactory* _tmp37_;
	RygelTestRequestFactory* _tmp38_;
	RygelHTTPServer* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	SoupMessage* _tmp43_;
	SoupMessage* _tmp44_;
	SoupMessageHeaders* _tmp45_;
	GeeArrayList* _tmp46_;
	SoupMessage* _tmp47_;
	RygelTestRequestFactory* _tmp48_;
	RygelTestRequestFactory* _tmp49_;
	RygelHTTPServer* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	SoupMessage* _tmp54_;
	SoupMessage* _tmp55_;
	SoupMessageHeaders* _tmp56_;
	GeeArrayList* _tmp57_;
	SoupMessage* _tmp58_;
	RygelTestRequestFactory* _tmp59_;
	RygelTestRequestFactory* _tmp60_;
	RygelHTTPServer* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	SoupMessage* _tmp65_;
	SoupMessage* _tmp66_;
	SoupMessageHeaders* _tmp67_;
	GeeArrayList* _tmp68_;
	SoupMessage* _tmp69_;
	RygelTestRequestFactory* _tmp70_;
	RygelTestRequestFactory* _tmp71_;
	RygelHTTPServer* _tmp72_;
	gchar* _tmp73_ = NULL;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	const gchar* _tmp76_;
	SoupMessage* _tmp77_;
	GeeArrayList* _tmp78_;
	SoupMessage* _tmp79_;
	RygelTestRequestFactory* _tmp80_;
	RygelTestRequestFactory* _tmp81_;
	RygelHTTPServer* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	SoupMessage* _tmp86_;
	SoupMessage* _tmp87_;
	SoupMessageHeaders* _tmp88_;
	GeeArrayList* _tmp89_;
	SoupMessage* _tmp90_;
	RygelTestRequestFactory* _tmp91_;
	RygelTestRequestFactory* _tmp92_;
	RygelHTTPServer* _tmp93_;
	gchar* _tmp94_ = NULL;
	const gchar* _tmp95_;
	SoupMessage* _tmp96_;
	SoupMessage* _tmp97_;
	SoupMessageHeaders* _tmp98_;
	GeeArrayList* _tmp99_;
	SoupMessage* _tmp100_;
	RygelTestRequestFactory* _tmp101_;
	RygelTestRequestFactory* _tmp102_;
	RygelHTTPServer* _tmp103_;
	gchar* _tmp104_ = NULL;
	const gchar* _tmp105_;
	SoupMessage* _tmp106_;
	SoupMessage* _tmp107_;
	SoupMessageHeaders* _tmp108_;
	GeeArrayList* _tmp109_;
	SoupMessage* _tmp110_;
	RygelTestRequestFactory* _tmp111_;
	RygelTestRequestFactory* _tmp112_;
	RygelHTTPServer* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	SoupMessage* _tmp117_;
	SoupMessage* _tmp118_;
	SoupMessageHeaders* _tmp119_;
	GeeArrayList* _tmp120_;
	SoupMessage* _tmp121_;
	RygelTestRequestFactory* _tmp122_;
	RygelTestRequestFactory* _tmp123_;
	RygelHTTPServer* _tmp124_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	SoupMessage* _tmp128_;
	SoupMessage* _tmp129_;
	SoupMessageHeaders* _tmp130_;
	GeeArrayList* _tmp131_;
	SoupMessage* _tmp132_;
	RygelTestRequestFactory* _tmp133_;
	RygelTestRequestFactory* _tmp134_;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_TEST_REQUEST_FACTORY, (GBoxedCopyFunc) rygel_test_request_factory_ref, rygel_test_request_factory_unref, NULL);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->requests);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->requests = _tmp0_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->server;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = rygel_http_server_get_uri (_tmp1_);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = _tmp2_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _tmp3_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = soup_message_new ("POST", _tmp4_);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = _tmp5_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp4_);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp6_;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = self->priv->requests;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp8_ = request;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp9_ = rygel_test_request_factory_new (_tmp8_, SOUP_STATUS_BAD_REQUEST);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp10_ = _tmp9_;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp10_);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp10_);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp11_ = self->server;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp12_ = rygel_http_server_get_uri (_tmp11_);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp13_ = _tmp12_;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp14_ = _tmp13_;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp15_ = soup_message_new ("HEAD", _tmp14_);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp15_;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp14_);
#line 129 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp16_ = self->priv->requests;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp17_ = request;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp18_ = rygel_test_request_factory_new (_tmp17_, SOUP_STATUS_OK);
#line 129 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp19_ = _tmp18_;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp19_);
#line 129 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp19_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp20_ = self->server;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp21_ = rygel_http_server_get_uri (_tmp20_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp22_ = _tmp21_;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp23_ = _tmp22_;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp24_ = soup_message_new ("GET", _tmp23_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp24_;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp23_);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp25_ = self->priv->requests;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp26_ = request;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp27_ = rygel_test_request_factory_new (_tmp26_, SOUP_STATUS_OK);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp28_ = _tmp27_;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp28_);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp28_);
#line 134 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp29_ = self->server;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp30_ = rygel_http_server_create_uri (_tmp29_, "VideoItem");
#line 134 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp30_;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp31_ = uri;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp32_ = g_strconcat (_tmp31_, "/tr/MP3", NULL);
#line 135 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 135 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp32_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp33_ = uri;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp34_ = soup_message_new ("HEAD", _tmp33_);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp34_;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp35_ = self->priv->requests;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp36_ = request;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp37_ = rygel_test_request_factory_new (_tmp36_, SOUP_STATUS_OK);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp38_ = _tmp37_;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp38_);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp38_);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp39_ = self->server;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp40_ = rygel_http_server_get_uri (_tmp39_);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp41_ = _tmp40_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp42_ = _tmp41_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp43_ = soup_message_new ("GET", _tmp42_);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp43_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp42_);
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp44_ = request;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp45_ = _tmp44_->request_headers;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp45_, "transferMode.dlna.org", "Streaming");
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp46_ = self->priv->requests;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp47_ = request;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp48_ = rygel_test_request_factory_new (_tmp47_, SOUP_STATUS_OK);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp49_ = _tmp48_;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp49_);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp49_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp50_ = self->server;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp51_ = rygel_http_server_get_uri (_tmp50_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp52_ = _tmp51_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp53_ = _tmp52_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp54_ = soup_message_new ("GET", _tmp53_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp54_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp53_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp55_ = request;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp56_ = _tmp55_->request_headers;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp56_, "transferMode.dlna.org", "Interactive");
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp57_ = self->priv->requests;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp58_ = request;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp59_ = rygel_test_request_factory_new (_tmp58_, SOUP_STATUS_NOT_ACCEPTABLE);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp60_ = _tmp59_;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp57_, _tmp60_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp60_);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp61_ = self->server;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp62_ = rygel_http_server_get_uri (_tmp61_);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp63_ = _tmp62_;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp64_ = _tmp63_;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp65_ = soup_message_new ("GET", _tmp64_);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp65_;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp64_);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp66_ = request;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp67_ = _tmp66_->request_headers;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp67_, "Range", "bytes=1-2");
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp68_ = self->priv->requests;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp69_ = request;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp70_ = rygel_test_request_factory_new (_tmp69_, SOUP_STATUS_OK);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp71_ = _tmp70_;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp68_, _tmp71_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp71_);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp72_ = self->server;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp73_ = rygel_http_server_create_uri (_tmp72_, "AudioItem");
#line 153 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp73_;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp74_ = uri;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp75_ = g_strconcat (_tmp74_, "/th/0", NULL);
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp75_;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp76_ = uri;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp77_ = soup_message_new ("GET", _tmp76_);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp77_;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp78_ = self->priv->requests;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp79_ = request;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp80_ = rygel_test_request_factory_new (_tmp79_, SOUP_STATUS_NOT_FOUND);
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp81_ = _tmp80_;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp78_, _tmp81_);
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp81_);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp82_ = self->server;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp83_ = rygel_http_server_get_uri (_tmp82_);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp84_ = _tmp83_;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp85_ = _tmp84_;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp86_ = soup_message_new ("GET", _tmp85_);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp86_;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp85_);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp87_ = request;
#line 161 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp88_ = _tmp87_->request_headers;
#line 161 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp88_, "TimeSeekRange.dlna.org", "0");
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp89_ = self->priv->requests;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp90_ = request;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp91_ = rygel_test_request_factory_new (_tmp90_, SOUP_STATUS_NOT_ACCEPTABLE);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp92_ = _tmp91_;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp89_, _tmp92_);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp92_);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp93_ = self->server;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp94_ = rygel_http_server_create_uri (_tmp93_, "AudioItem");
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp94_;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp95_ = uri;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp96_ = soup_message_new ("GET", _tmp95_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp96_;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp97_ = request;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp98_ = _tmp97_->request_headers;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp98_, "TimeSeekRange.dlna.org", "0");
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp99_ = self->priv->requests;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp100_ = request;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp101_ = rygel_test_request_factory_new (_tmp100_, SOUP_STATUS_BAD_REQUEST);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp102_ = _tmp101_;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp99_, _tmp102_);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp102_);
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp103_ = self->server;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp104_ = rygel_http_server_create_uri (_tmp103_, "AudioItem");
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp104_;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp105_ = uri;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp106_ = soup_message_new ("GET", _tmp105_);
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp106_;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp107_ = request;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp108_ = _tmp107_->request_headers;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp108_, "TimeSeekRange.dlna.org", "npt=1-2049");
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp109_ = self->priv->requests;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp110_ = request;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp111_ = rygel_test_request_factory_new (_tmp110_, SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp112_ = _tmp111_;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp109_, _tmp112_);
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp112_);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp113_ = self->server;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp114_ = rygel_http_server_get_uri (_tmp113_);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp115_ = _tmp114_;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp116_ = _tmp115_;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp117_ = soup_message_new ("GET", _tmp116_);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp117_;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp116_);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp118_ = request;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp119_ = _tmp118_->request_headers;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp119_, "clienthacks.test.rygel", "f");
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp120_ = self->priv->requests;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp121_ = request;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp122_ = rygel_test_request_factory_new (_tmp121_, SOUP_STATUS_OK);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp123_ = _tmp122_;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp120_, _tmp123_);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp123_);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp124_ = self->server;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp125_ = rygel_http_server_get_uri (_tmp124_);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp126_ = _tmp125_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp127_ = _tmp126_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp128_ = soup_message_new ("GET", _tmp127_);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp128_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp127_);
#line 183 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp129_ = request;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp130_ = _tmp129_->request_headers;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp130_, "clienthacks.test.rygel", "t");
#line 184 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp131_ = self->priv->requests;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp132_ = request;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp133_ = rygel_test_request_factory_new (_tmp132_, SOUP_STATUS_OK);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp134_ = _tmp133_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp131_, _tmp134_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp134_);
#line 121 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 121 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 2544 "rygel-http-get-test.c"
}


static RygelHTTPGet* rygel_http_get_test_create_request (RygelHTTPGetTest* self, SoupMessage* msg, GError** error) {
	RygelHTTPGet* result = NULL;
	RygelTestRequestFactory* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	GUPnPContext* _tmp3_;
	SoupServer* _tmp4_;
	SoupServer* _tmp5_;
	SoupMessage* _tmp6_;
	RygelHTTPGet* _tmp7_ = NULL;
	RygelHTTPGet* request;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->current_request;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->server;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = self->server;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = _tmp2_->context;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = gupnp_context_get_server (_tmp3_);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = _tmp4_;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = msg;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = rygel_test_request_factory_create_get (_tmp0_, _tmp1_, _tmp5_, _tmp6_);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp7_;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = request;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2585 "rygel-http-get-test.c"
}


static void rygel_http_get_test_on_client_completed (RygelHTTPGetTest* self, RygelStateMachine* client) {
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (client != NULL);
#line 195 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->requests;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
#line 195 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _tmp1_;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_tmp2_ > 0) {
#line 196 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_test_start_next_test_request (self);
#line 2607 "rygel-http-get-test.c"
	} else {
		GMainLoop* _tmp3_;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp3_ = self->priv->main_loop;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_main_loop_quit (_tmp3_);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self->priv->client_done = TRUE;
#line 2616 "rygel-http-get-test.c"
	}
}


static void rygel_http_get_test_start_next_test_request (RygelHTTPGetTest* self) {
	GeeArrayList* _tmp0_;
	gpointer _tmp1_ = NULL;
	RygelHTTPClient* _tmp2_;
	RygelTestRequestFactory* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	RygelHTTPClient* _tmp6_;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->requests;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp0_, 0);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (self->priv->current_request);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->current_request = (RygelTestRequestFactory*) _tmp1_;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = self->client;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->priv->current_request;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _tmp3_->msg;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_tmp2_->msg);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_->msg = _tmp5_;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = self->client;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp6_, NULL, NULL);
#line 2655 "rygel-http-get-test.c"
}


static void rygel_http_get_test_on_message_received (RygelHTTPGetTest* self, RygelHTTPServer* server, SoupMessage* msg) {
	SoupMessage* _tmp0_;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (server != NULL);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = msg;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_handle_client_message (self, _tmp0_, NULL, NULL);
#line 2671 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message_data_free (gpointer _data) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	_data_ = _data;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->msg);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->self);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelHttpGetTestHandleClientMessageData, _data_);
#line 2684 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message (RygelHTTPGetTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	RygelHTTPGetTest* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelHttpGetTestHandleClientMessageData);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_test_handle_client_message);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_test_handle_client_message_data_free);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = msg;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->msg = _tmp2_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_handle_client_message_co (_data_);
#line 2711 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message_finish (RygelHTTPGetTest* self, GAsyncResult* _res_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2719 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = _user_data_;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_source_object_ = source_object;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_res_ = _res_;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_handle_client_message_co (_data_);
#line 2733 "rygel-http-get-test.c"
}


static gboolean rygel_http_get_test_handle_client_message_co (RygelHttpGetTestHandleClientMessageData* _data_) {
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 2742 "rygel-http-get-test.c"
		goto _state_0;
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 2746 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 2751 "rygel-http-get-test.c"
	}
	_state_0:
	{
#line 216 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp0_ = _data_->msg;
#line 216 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp1_ = NULL;
#line 216 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp1_ = rygel_http_get_test_create_request (_data_->self, _data_->_tmp0_, &_data_->_inner_error_);
#line 216 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->request = _data_->_tmp1_;
#line 216 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_inner_error_ != NULL) {
#line 2765 "rygel-http-get-test.c"
			goto __catch1_g_error;
		}
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp2_ = _data_->request;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_state_ = 1;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp2_, rygel_http_get_test_handle_client_message_ready, _data_);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 2776 "rygel-http-get-test.c"
		_state_1:
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp2_, _data_->_res_);
#line 220 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp3_ = _data_->request;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp4_ = ((RygelHTTPRequest*) (RYGEL_IS_HTTP_GET (_data_->_tmp3_) ? ((RygelHTTPGet*) _data_->_tmp3_) : NULL))->item;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert (_data_->_tmp4_ != NULL);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp5_ = _data_->msg;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp6_ = 0U;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_get (_data_->_tmp5_, "status-code", &_data_->_tmp6_, NULL);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_debug ("rygel-http-get-test.vala:222: status.code: %d", (gint) _data_->_tmp7_);
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp8_ = _data_->msg;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp9_ = 0U;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_get (_data_->_tmp8_, "status-code", &_data_->_tmp9_, NULL);
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp10_ = _data_->_tmp9_;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp11_ = _data_->self->priv->current_request;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp12_ = _data_->_tmp11_->expected_code;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert (_data_->_tmp10_ == ((guint) _data_->_tmp12_));
#line 225 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp13_ = _data_->self->priv->client_done;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_tmp13_) {
#line 226 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_tmp14_ = _data_->self->priv->main_loop;
#line 226 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_main_loop_quit (_data_->_tmp14_);
#line 2818 "rygel-http-get-test.c"
		}
#line 229 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->self->priv->server_done = TRUE;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (_data_->request);
#line 2824 "rygel-http-get-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_inner_error_ = NULL;
#line 231 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp15_ = _data_->_error_;
#line 231 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
#line 231 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_data_->self->priv->error);
#line 231 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->self->priv->error = _data_->_tmp16_;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp17_ = _data_->self->priv->main_loop;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_main_loop_quit (_data_->_tmp17_);
#line 234 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_data_->_error_);
#line 234 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_state_ == 0) {
#line 234 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2851 "rygel-http-get-test.c"
		} else {
#line 234 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2855 "rygel-http-get-test.c"
		}
#line 234 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_unref (_data_->_async_result);
#line 234 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 2861 "rygel-http-get-test.c"
	}
	__finally1:
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_clear_error (&_data_->_inner_error_);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 2872 "rygel-http-get-test.c"
	}
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2878 "rygel-http-get-test.c"
	} else {
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2882 "rygel-http-get-test.c"
	}
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 2888 "rygel-http-get-test.c"
}


static gboolean rygel_http_get_test_on_timeout (RygelHTTPGetTest* self) {
	gboolean result = FALSE;
	GError* _tmp0_;
	GMainLoop* _tmp1_;
#line 238 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 239 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout");
#line 239 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_error_free0 (self->priv->error);
#line 239 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->error = _tmp0_;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->priv->main_loop;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_main_loop_quit (_tmp1_);
#line 242 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 242 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2912 "rygel-http-get-test.c"
}


static void rygel_http_get_test_class_init (RygelHTTPGetTestClass * klass) {
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_parent_class = g_type_class_peek_parent (klass);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPGetTestPrivate));
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_HTTP_GET_TEST_CLASS (klass)->run = rygel_http_get_test_real_run;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_test_finalize;
#line 2925 "rygel-http-get-test.c"
}


static void rygel_http_get_test_instance_init (RygelHTTPGetTest * self) {
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_HTTP_GET_TEST_GET_PRIVATE (self);
#line 2932 "rygel-http-get-test.c"
}


static void rygel_http_get_test_finalize (GObject* obj) {
	RygelHTTPGetTest * self;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_HTTP_GET_TEST (obj);
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->server);
#line 72 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->client);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_error_free0 (self->priv->error);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->requests);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (self->priv->current_request);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_get_test_parent_class)->finalize (obj);
#line 2954 "rygel-http-get-test.c"
}


GType rygel_http_get_test_get_type (void) {
	static volatile gsize rygel_http_get_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetTest), 0, (GInstanceInitFunc) rygel_http_get_test_instance_init, NULL };
		GType rygel_http_get_test_type_id;
		rygel_http_get_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGetTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_test_type_id__volatile, rygel_http_get_test_type_id);
	}
	return rygel_http_get_test_type_id__volatile;
}


gchar* rygel_http_server_create_uri (RygelHTTPServer* self, const gchar* item_id) {
	gchar* result = NULL;
	RygelVideoItem* _tmp0_;
	RygelVideoItem* item;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	RygelHTTPItemURI* _tmp3_;
	RygelHTTPItemURI* item_uri;
	gchar* _tmp4_ = NULL;
#line 263 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 263 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (item_id != NULL, NULL);
#line 264 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = rygel_video_item_new ();
#line 264 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	item = _tmp0_;
#line 265 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = item_id;
#line 265 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 265 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (((RygelMediaObject*) item)->id);
#line 265 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	((RygelMediaObject*) item)->id = _tmp2_;
#line 267 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = rygel_http_item_uri_new ((RygelMediaItem*) item, self, -1, -1, NULL);
#line 267 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	item_uri = _tmp3_;
#line 269 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = rygel_http_item_uri_to_string (item_uri);
#line 269 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp4_;
#line 269 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (item_uri);
#line 269 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (item);
#line 269 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3009 "rygel-http-get-test.c"
}


static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self) {
#line 285 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_server_server_cb (self, server, msg, path, query, client);
#line 3016 "rygel-http-get-test.c"
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp3_;
	GUPnPContext* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GUPnPContext* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	GUPnPContext* _tmp10_;
	SoupServer* _tmp11_;
	SoupServer* _tmp12_;
	RygelMediaContainer* _tmp13_;
	GError * _inner_error_ = NULL;
#line 274 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 3036 "rygel-http-get-test.c"
	{
		GUPnPContext* _tmp0_;
		GUPnPContext* _tmp1_;
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp1_ = _tmp0_;
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_ != NULL) {
#line 3046 "rygel-http-get-test.c"
			goto __catch2_g_error;
		}
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (self->context);
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self->context = _tmp1_;
#line 3053 "rygel-http-get-test.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_error_ = _inner_error_;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = NULL;
#line 278 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp2_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
#line 278 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = _tmp2_;
#line 278 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_error_);
#line 3070 "rygel-http-get-test.c"
		goto __finally2;
	}
	__finally2:
#line 275 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_inner_error_ != NULL) {
#line 275 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
#line 275 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_propagate_error (error, _inner_error_);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_g_object_unref0 (self);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return NULL;
#line 3084 "rygel-http-get-test.c"
		} else {
#line 275 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_clear_error (&_inner_error_);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return NULL;
#line 3092 "rygel-http-get-test.c"
		}
	}
#line 281 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->context;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_assert (_tmp3_ != NULL);
#line 282 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = self->context;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp4_);
#line 282 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = _tmp5_;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_assert (_tmp6_ != NULL);
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = self->context;
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp8_ = gupnp_context_get_port (_tmp7_);
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp9_ = _tmp8_;
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_assert (_tmp9_ > ((guint) 0));
#line 285 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp10_ = self->context;
#line 285 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp11_ = gupnp_context_get_server (_tmp10_);
#line 285 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp12_ = _tmp11_;
#line 285 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_server_add_handler (_tmp12_, RYGEL_HTTP_SERVER_SERVER_PATH, _rygel_http_server_server_cb_soup_server_callback, g_object_ref (self), g_object_unref);
#line 287 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp13_ = rygel_media_container_new ();
#line 287 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (self->root_container);
#line 287 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->root_container = _tmp13_;
#line 274 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3131 "rygel-http-get-test.c"
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 274 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 3138 "rygel-http-get-test.c"
}


static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client) {
	GUPnPContext* _tmp0_;
	SoupServer* _tmp1_;
	SoupServer* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
#line 290 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 290 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (server != NULL);
#line 290 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 290 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (path != NULL);
#line 290 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (client != NULL);
#line 295 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->context;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = gupnp_context_get_server (_tmp0_);
#line 295 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _tmp1_;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = msg;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_server_pause_message (_tmp2_, _tmp3_);
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = msg;
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_emit_by_name (self, "message-received", _tmp4_);
#line 3172 "rygel-http-get-test.c"
}


RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error) {
	RygelTranscoder* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GError * _inner_error_ = NULL;
#line 299 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 299 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 300 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = target;
#line 300 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_strcmp0 (_tmp0_, "MP3") == 0) {
#line 3190 "rygel-http-get-test.c"
		RygelTranscoder* _tmp1_;
#line 301 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp1_ = rygel_transcoder_new ("mp3");
#line 301 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = _tmp1_;
#line 301 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 3198 "rygel-http-get-test.c"
	}
#line 303 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = target;
#line 303 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No transcoder available for target format '%s'", _tmp2_);
#line 303 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_inner_error_ = _tmp3_;
#line 303 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_propagate_error (error, _inner_error_);
#line 303 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 3210 "rygel-http-get-test.c"
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
#line 249 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 250 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = RYGEL_HTTP_SERVER_SERVER_PATH;
#line 250 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3222 "rygel-http-get-test.c"
}


gchar* rygel_http_server_get_uri (RygelHTTPServer* self) {
	gchar* result;
	gchar* _tmp0_ = NULL;
#line 258 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 259 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = rygel_http_server_create_uri (self, "VideoItem");
#line 259 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 259 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3237 "rygel-http-get-test.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, soup_message_get_type ());
#line 3254 "rygel-http-get-test.c"
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_HTTP_SERVER (obj);
#line 254 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (self->root_container);
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->context);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
#line 3272 "rygel-http-get-test.c"
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_string (value, rygel_http_server_get_path_root (self));
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_SERVER_URI:
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_take_string (value, rygel_http_server_get_uri (self));
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3305 "rygel-http-get-test.c"
		default:
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3311 "rygel-http-get-test.c"
	}
}


RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context) {
	RygelHTTPClient * self = NULL;
	GUPnPContext* _tmp0_;
	GUPnPContext* _tmp1_;
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
#line 316 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = context;
#line 316 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 316 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->context);
#line 316 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->context = _tmp1_;
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3334 "rygel-http-get-test.c"
}


RygelHTTPClient* rygel_http_client_new (GUPnPContext* context) {
#line 315 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context);
#line 3341 "rygel-http-get-test.c"
}


static void rygel_http_client_real_run_data_free (gpointer _data) {
	RygelHttpClientRunData* _data_;
	_data_ = _data;
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->self);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelHttpClientRunData, _data_);
#line 3352 "rygel-http-get-test.c"
}


static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPClient * self;
	RygelHttpClientRunData* _data_;
	RygelHTTPClient* _tmp0_;
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) base;
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelHttpClientRunData);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_real_run);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_real_run_data_free);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_client_real_run_co (_data_);
#line 3374 "rygel-http-get-test.c"
}


static void rygel_http_client_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3382 "rygel-http-get-test.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return _data1_;
#line 3391 "rygel-http-get-test.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 3400 "rygel-http-get-test.c"
		RygelHTTPClient * self;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self = _data1_->self;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		(_data1_->run_continue_target_destroy_notify == NULL) ? NULL : (_data1_->run_continue_target_destroy_notify (_data1_->run_continue_target), NULL);
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data1_->run_continue = NULL;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data1_->run_continue_target = NULL;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data1_->run_continue_target_destroy_notify = NULL;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (self);
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_slice_free (Block1Data, _data1_);
#line 3416 "rygel-http-get-test.c"
	}
}


static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_client_real_run_co (self);
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3426 "rygel-http-get-test.c"
}


static void __lambda5_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg) {
	RygelHTTPClient * self;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = _data1_->self;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (session != NULL);
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 323 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data1_->run_continue (_data1_->run_continue_target);
#line 3440 "rygel-http-get-test.c"
}


static void ___lambda5__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	__lambda5_ (self, session, msg);
#line 3447 "rygel-http-get-test.c"
}


static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_) {
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 3456 "rygel-http-get-test.c"
		goto _state_0;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 3460 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 3465 "rygel-http-get-test.c"
	}
	_state_0:
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->run_continue = _rygel_http_client_real_run_co_gsource_func;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->run_continue_target = _data_;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->run_continue_target_destroy_notify = NULL;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = _data_->self->context;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp1_ = gupnp_context_get_session (_data_->_tmp0_);
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp3_ = _data_->self->msg;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_session_queue_message (_data_->_tmp2_, _data_->_tmp4_, ___lambda5__soup_session_callback, _data_->_data1_);
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_state_ = 1;
#line 326 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 3498 "rygel-http-get-test.c"
	_state_1:
	;
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	block1_data_unref (_data_->_data1_);
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_ = NULL;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3511 "rygel-http-get-test.c"
	} else {
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3515 "rygel-http-get-test.c"
	}
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 3521 "rygel-http-get-test.c"
}


static GCancellable* rygel_http_client_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
#line 313 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) base;
#line 313 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_cancellable;
#line 313 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 313 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3537 "rygel-http-get-test.c"
}


static void rygel_http_client_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 313 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) base;
#line 313 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 313 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 313 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 313 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_cancellable = _tmp1_;
#line 313 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 3557 "rygel-http-get-test.c"
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPClientPrivate));
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_client_get_property;
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_client_set_property;
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_CLIENT_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", G_TYPE_CANCELLABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3574 "rygel-http-get-test.c"
}


static void rygel_http_client_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_client_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_client_real_run;
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run_finish = rygel_http_client_real_run_finish;
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_cancellable = rygel_http_client_real_get_cancellable;
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_cancellable = rygel_http_client_real_set_cancellable;
#line 3589 "rygel-http-get-test.c"
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_HTTP_CLIENT_GET_PRIVATE (self);
#line 3596 "rygel-http-get-test.c"
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_HTTP_CLIENT (obj);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->context);
#line 311 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->msg);
#line 313 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
#line 3612 "rygel-http-get-test.c"
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_client_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_client_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3641 "rygel-http-get-test.c"
		default:
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3647 "rygel-http-get-test.c"
	}
}


static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3663 "rygel-http-get-test.c"
		default:
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3669 "rygel-http-get-test.c"
	}
}


static void rygel_media_container_find_object_data_free (gpointer _data) {
	RygelMediaContainerFindObjectData* _data_;
	_data_ = _data;
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_data_->item_id);
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (_data_->result);
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (_data_->self);
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelMediaContainerFindObjectData, _data_);
#line 3687 "rygel-http-get-test.c"
}


static gpointer _rygel_media_object_ref0 (gpointer self) {
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? rygel_media_object_ref (self) : NULL;
#line 3694 "rygel-http-get-test.c"
}


void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* _data_;
	RygelMediaContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelMediaContainerFindObjectData);
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_media_container_find_object);
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_find_object_data_free);
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _rygel_media_object_ref0 (self);
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = item_id;
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->item_id = _tmp2_;
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = cancellable;
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->cancellable = _tmp4_;
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_container_find_object_co (_data_);
#line 3729 "rygel-http-get-test.c"
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaContainerFindObjectData* _data_;
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return NULL;
#line 3740 "rygel-http-get-test.c"
	}
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _data_->result;
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->result = NULL;
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3750 "rygel-http-get-test.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return _data2_;
#line 3759 "rygel-http-get-test.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 3768 "rygel-http-get-test.c"
		RygelMediaContainer * self;
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self = _data2_->self;
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		(_data2_->find_object_continue_target_destroy_notify == NULL) ? NULL : (_data2_->find_object_continue_target_destroy_notify (_data2_->find_object_continue_target), NULL);
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data2_->find_object_continue = NULL;
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data2_->find_object_continue_target = NULL;
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data2_->find_object_continue_target_destroy_notify = NULL;
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_rygel_media_object_unref0 (self);
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_slice_free (Block2Data, _data2_);
#line 3784 "rygel-http-get-test.c"
	}
}


static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_media_container_find_object_co (self);
#line 337 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3794 "rygel-http-get-test.c"
}


static gboolean __lambda2_ (Block2Data* _data2_) {
	RygelMediaContainer * self;
	gboolean result = FALSE;
	GSourceFunc _tmp0_;
	void* _tmp0__target;
#line 338 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = _data2_->self;
#line 339 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _data2_->find_object_continue;
#line 339 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0__target = _data2_->find_object_continue_target;
#line 339 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ (_tmp0__target);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3815 "rygel-http-get-test.c"
}


static gboolean ___lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda2_ (self);
#line 338 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3824 "rygel-http-get-test.c"
}


static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* _data_) {
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 3833 "rygel-http-get-test.c"
		goto _state_0;
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 3837 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 3842 "rygel-http-get-test.c"
	}
	_state_0:
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->self = rygel_media_object_ref (_data_->self);
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 337 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->find_object_continue = _rygel_media_container_find_object_co_gsource_func;
#line 337 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->find_object_continue_target = _data_;
#line 337 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->find_object_continue_target_destroy_notify = NULL;
#line 338 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda2__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_state_ = 1;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 3865 "rygel-http-get-test.c"
	_state_1:
	;
#line 346 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = _data_->item_id;
#line 346 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_debug ("rygel-http-get-test.vala:346: item id: %s", _data_->_tmp0_);
#line 347 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp1_ = _data_->item_id;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_strcmp0 (_data_->_tmp1_, "VideoItem") == 0) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp2_ = rygel_video_item_new ();
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->result = (RygelMediaObject*) _data_->_tmp2_;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		block2_data_unref (_data_->_data2_);
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_data2_ = NULL;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_state_ == 0) {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3888 "rygel-http-get-test.c"
		} else {
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3892 "rygel-http-get-test.c"
		}
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_unref (_data_->_async_result);
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 3898 "rygel-http-get-test.c"
	} else {
#line 349 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp3_ = _data_->item_id;
#line 349 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (g_strcmp0 (_data_->_tmp3_, "AudioItem") == 0) {
#line 350 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_tmp4_ = rygel_audio_item_new ();
#line 350 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->result = (RygelMediaObject*) _data_->_tmp4_;
#line 350 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			block2_data_unref (_data_->_data2_);
#line 350 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_data2_ = NULL;
#line 350 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			if (_data_->_state_ == 0) {
#line 350 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3916 "rygel-http-get-test.c"
			} else {
#line 350 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3920 "rygel-http-get-test.c"
			}
#line 350 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_object_unref (_data_->_async_result);
#line 350 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return FALSE;
#line 3926 "rygel-http-get-test.c"
		} else {
#line 352 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->result = NULL;
#line 352 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			block2_data_unref (_data_->_data2_);
#line 352 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_data2_ = NULL;
#line 352 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			if (_data_->_state_ == 0) {
#line 352 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3938 "rygel-http-get-test.c"
			} else {
#line 352 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3942 "rygel-http-get-test.c"
			}
#line 352 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_object_unref (_data_->_async_result);
#line 352 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return FALSE;
#line 3948 "rygel-http-get-test.c"
		}
	}
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	block2_data_unref (_data_->_data2_);
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_ = NULL;
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3959 "rygel-http-get-test.c"
	} else {
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3963 "rygel-http-get-test.c"
	}
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 334 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 3969 "rygel-http-get-test.c"
}


RygelMediaContainer* rygel_media_container_construct (GType object_type) {
	RygelMediaContainer* self = NULL;
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3979 "rygel-http-get-test.c"
}


RygelMediaContainer* rygel_media_container_new (void) {
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
#line 3986 "rygel-http-get-test.c"
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
#line 3993 "rygel-http-get-test.c"
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request) {
	RygelHTTPResponse* result = NULL;
	RygelHTTPGet* _tmp0_;
	RygelHTTPResponse* _tmp1_;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (get_request != NULL, NULL);
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = get_request;
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = rygel_http_response_new (_tmp0_);
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp1_;
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4029 "rygel-http-get-test.c"
}


void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request) {
#line 362 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 362 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (get_request != NULL);
#line 4038 "rygel-http-get-test.c"
}


gboolean rygel_http_get_handler_knows_size (RygelHTTPGetHandler* self, RygelHTTPGet* request) {
	gboolean result = FALSE;
#line 364 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 364 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 364 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 364 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4052 "rygel-http-get-test.c"
}


RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type) {
	RygelHTTPGetHandler* self = NULL;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPGetHandler*) g_type_create_instance (object_type);
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4062 "rygel-http-get-test.c"
}


static void rygel_value_http_get_handler_init (GValue* value) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 4069 "rygel-http-get-test.c"
}


static void rygel_value_http_get_handler_free_value (GValue* value) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_unref (value->data[0].v_pointer);
#line 4078 "rygel-http-get-test.c"
	}
}


static void rygel_value_http_get_handler_copy_value (const GValue* src_value, GValue* dest_value) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_http_get_handler_ref (src_value->data[0].v_pointer);
#line 4088 "rygel-http-get-test.c"
	} else {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4092 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_http_get_handler_peek_pointer (const GValue* value) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 4100 "rygel-http-get-test.c"
}


static gchar* rygel_value_http_get_handler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 4107 "rygel-http-get-test.c"
		RygelHTTPGetHandler* object;
		object = collect_values[0].v_pointer;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4114 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4118 "rygel-http-get-test.c"
		}
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_http_get_handler_ref (object);
#line 4122 "rygel-http-get-test.c"
	} else {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4126 "rygel-http-get-test.c"
	}
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 4130 "rygel-http-get-test.c"
}


static gchar* rygel_value_http_get_handler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelHTTPGetHandler** object_p;
	object_p = collect_values[0].v_pointer;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4141 "rygel-http-get-test.c"
	}
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 4147 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 4151 "rygel-http-get-test.c"
	} else {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_http_get_handler_ref (value->data[0].v_pointer);
#line 4155 "rygel-http-get-test.c"
	}
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 4159 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecHTTPGetHandler* spec;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_HTTP_GET_HANDLER), NULL);
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 4173 "rygel-http-get-test.c"
}


gpointer rygel_value_get_http_get_handler (const GValue* value) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER), NULL);
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 4182 "rygel-http-get-test.c"
}


void rygel_value_set_http_get_handler (GValue* value, gpointer v_object) {
	RygelHTTPGetHandler* old;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_ref (value->data[0].v_pointer);
#line 4202 "rygel-http-get-test.c"
	} else {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4206 "rygel-http-get-test.c"
	}
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_unref (old);
#line 4212 "rygel-http-get-test.c"
	}
}


void rygel_value_take_http_get_handler (GValue* value, gpointer v_object) {
	RygelHTTPGetHandler* old;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 4231 "rygel-http-get-test.c"
	} else {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4235 "rygel-http-get-test.c"
	}
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_unref (old);
#line 4241 "rygel-http-get-test.c"
	}
}


static void rygel_http_get_handler_class_init (RygelHTTPGetHandlerClass * klass) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_handler_parent_class = g_type_class_peek_parent (klass);
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->finalize = rygel_http_get_handler_finalize;
#line 4251 "rygel-http-get-test.c"
}


static void rygel_http_get_handler_instance_init (RygelHTTPGetHandler * self) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 4258 "rygel-http-get-test.c"
}


static void rygel_http_get_handler_finalize (RygelHTTPGetHandler* obj) {
	RygelHTTPGetHandler * self;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_HTTP_GET_HANDLER (obj);
#line 4266 "rygel-http-get-test.c"
}


GType rygel_http_get_handler_get_type (void) {
	static volatile gsize rygel_http_get_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_handler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_http_get_handler_init, rygel_value_http_get_handler_free_value, rygel_value_http_get_handler_copy_value, rygel_value_http_get_handler_peek_pointer, "p", rygel_value_http_get_handler_collect_value, "p", rygel_value_http_get_handler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetHandler), 0, (GInstanceInitFunc) rygel_http_get_handler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_http_get_handler_type_id;
		rygel_http_get_handler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelHTTPGetHandler", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_http_get_handler_type_id__volatile, rygel_http_get_handler_type_id);
	}
	return rygel_http_get_handler_type_id__volatile;
}


gpointer rygel_http_get_handler_ref (gpointer instance) {
	RygelHTTPGetHandler* self;
	self = instance;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 4291 "rygel-http-get-test.c"
}


void rygel_http_get_handler_unref (gpointer instance) {
	RygelHTTPGetHandler* self;
	self = instance;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->finalize (self);
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4304 "rygel-http-get-test.c"
	}
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable) {
	RygelHTTPTranscodeHandler* self = NULL;
#line 368 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (transcoder != NULL, NULL);
#line 368 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 368 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPTranscodeHandler*) rygel_http_get_handler_construct (object_type);
#line 368 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4319 "rygel-http-get-test.c"
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable) {
#line 368 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_transcode_handler_construct (RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, transcoder, cancellable);
#line 4326 "rygel-http-get-test.c"
}


static void rygel_http_transcode_handler_class_init (RygelHTTPTranscodeHandlerClass * klass) {
#line 367 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_transcode_handler_parent_class = g_type_class_peek_parent (klass);
#line 4333 "rygel-http-get-test.c"
}


static void rygel_http_transcode_handler_instance_init (RygelHTTPTranscodeHandler * self) {
}


GType rygel_http_transcode_handler_get_type (void) {
	static volatile gsize rygel_http_transcode_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_transcode_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTranscodeHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_transcode_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTranscodeHandler), 0, (GInstanceInitFunc) rygel_http_transcode_handler_instance_init, NULL };
		GType rygel_http_transcode_handler_type_id;
		rygel_http_transcode_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPTranscodeHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_transcode_handler_type_id__volatile, rygel_http_transcode_handler_type_id);
	}
	return rygel_http_transcode_handler_type_id__volatile;
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable) {
	RygelHTTPIdentityHandler* self = NULL;
#line 373 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 373 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPIdentityHandler*) rygel_http_get_handler_construct (object_type);
#line 373 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4361 "rygel-http-get-test.c"
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable) {
#line 373 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_identity_handler_construct (RYGEL_TYPE_HTTP_IDENTITY_HANDLER, cancellable);
#line 4368 "rygel-http-get-test.c"
}


static void rygel_http_identity_handler_class_init (RygelHTTPIdentityHandlerClass * klass) {
#line 372 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_identity_handler_parent_class = g_type_class_peek_parent (klass);
#line 4375 "rygel-http-get-test.c"
}


static void rygel_http_identity_handler_instance_init (RygelHTTPIdentityHandler * self) {
}


GType rygel_http_identity_handler_get_type (void) {
	static volatile gsize rygel_http_identity_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_identity_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPIdentityHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_identity_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPIdentityHandler), 0, (GInstanceInitFunc) rygel_http_identity_handler_instance_init, NULL };
		GType rygel_http_identity_handler_type_id;
		rygel_http_identity_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPIdentityHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_identity_handler_type_id__volatile, rygel_http_identity_handler_type_id);
	}
	return rygel_http_identity_handler_type_id__volatile;
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
#line 384 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 385 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = ((RygelMediaObject*) self)->id;
#line 385 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_strcmp0 (_tmp0_, "VideoItem") == 0) {
#line 386 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = FALSE;
#line 386 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 4408 "rygel-http-get-test.c"
	} else {
#line 388 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = TRUE;
#line 388 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 4414 "rygel-http-get-test.c"
	}
}


gboolean rygel_media_item_streamable (RygelMediaItem* self) {
	gboolean result = FALSE;
#line 391 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 392 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = TRUE;
#line 392 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4427 "rygel-http-get-test.c"
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem* self = NULL;
#line 376 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 376 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4437 "rygel-http-get-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 376 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 376 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 4446 "rygel-http-get-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
#line 377 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->size = (glong) 1024;
#line 378 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, rygel_subtitle_unref, NULL);
#line 378 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->subtitles = _tmp0_;
#line 379 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_thumbnail_ref, rygel_thumbnail_unref, NULL);
#line 379 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->thumbnails = _tmp1_;
#line 380 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 380 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->uris = _tmp2_;
#line 382 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->place_holder = FALSE;
#line 4470 "rygel-http-get-test.c"
}


static void rygel_media_item_finalize (RygelMediaObject* obj) {
	RygelMediaItem * self;
#line 376 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_MEDIA_ITEM (obj);
#line 378 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->subtitles);
#line 379 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->thumbnails);
#line 380 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->uris);
#line 376 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
#line 4486 "rygel-http-get-test.c"
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelAudioItem* rygel_audio_item_construct (GType object_type) {
	RygelAudioItem* self = NULL;
	gchar* _tmp0_;
#line 399 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelAudioItem*) rygel_media_item_construct (object_type);
#line 400 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = g_strdup ("AudioItem");
#line 400 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (((RygelMediaObject*) self)->id);
#line 400 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	((RygelMediaObject*) self)->id = _tmp0_;
#line 399 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4515 "rygel-http-get-test.c"
}


RygelAudioItem* rygel_audio_item_new (void) {
#line 399 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_audio_item_construct (RYGEL_TYPE_AUDIO_ITEM);
#line 4522 "rygel-http-get-test.c"
}


static void rygel_audio_item_class_init (RygelAudioItemClass * klass) {
#line 396 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_audio_item_parent_class = g_type_class_peek_parent (klass);
#line 396 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_audio_item_finalize;
#line 4531 "rygel-http-get-test.c"
}


static void rygel_audio_item_instance_init (RygelAudioItem * self) {
#line 397 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->duration = (gint64) 2048;
#line 4538 "rygel-http-get-test.c"
}


static void rygel_audio_item_finalize (RygelMediaObject* obj) {
	RygelAudioItem * self;
#line 396 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_AUDIO_ITEM (obj);
#line 396 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_audio_item_parent_class)->finalize (obj);
#line 4548 "rygel-http-get-test.c"
}


GType rygel_audio_item_get_type (void) {
	static volatile gsize rygel_audio_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_audio_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAudioItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_audio_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAudioItem), 0, (GInstanceInitFunc) rygel_audio_item_instance_init, NULL };
		GType rygel_audio_item_type_id;
		rygel_audio_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelAudioItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_audio_item_type_id__volatile, rygel_audio_item_type_id);
	}
	return rygel_audio_item_type_id__volatile;
}


gboolean rygel_visual_item_is_live_stream (RygelVisualItem* self) {
	gboolean result = FALSE;
#line 414 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 414 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4570 "rygel-http-get-test.c"
}


gboolean rygel_visual_item_streamable (RygelVisualItem* self) {
	gboolean result = FALSE;
#line 418 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 418 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4580 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_width (RygelVisualItem* self) {
#line 405 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 405 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_width (self);
#line 4589 "rygel-http-get-test.c"
}


void rygel_visual_item_set_width (RygelVisualItem* self, gint value) {
#line 405 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 405 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_width (self, value);
#line 4598 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_height (RygelVisualItem* self) {
#line 406 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 406 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_height (self);
#line 4607 "rygel-http-get-test.c"
}


void rygel_visual_item_set_height (RygelVisualItem* self, gint value) {
#line 406 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 406 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_height (self, value);
#line 4616 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_pixel_width (RygelVisualItem* self) {
#line 407 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 407 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_pixel_width (self);
#line 4625 "rygel-http-get-test.c"
}


void rygel_visual_item_set_pixel_width (RygelVisualItem* self, gint value) {
#line 407 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 407 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_pixel_width (self, value);
#line 4634 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_pixel_height (RygelVisualItem* self) {
#line 408 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 408 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_pixel_height (self);
#line 4643 "rygel-http-get-test.c"
}


void rygel_visual_item_set_pixel_height (RygelVisualItem* self, gint value) {
#line 408 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 408 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_pixel_height (self, value);
#line 4652 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_color_depth (RygelVisualItem* self) {
#line 409 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 409 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_color_depth (self);
#line 4661 "rygel-http-get-test.c"
}


void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value) {
#line 409 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 409 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_color_depth (self, value);
#line 4670 "rygel-http-get-test.c"
}


GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self) {
#line 411 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 411 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_thumbnails (self);
#line 4679 "rygel-http-get-test.c"
}


void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value) {
#line 411 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 411 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_thumbnails (self, value);
#line 4688 "rygel-http-get-test.c"
}


static void rygel_visual_item_base_init (RygelVisualItemIface * iface) {
#line 404 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	static gboolean initialized = FALSE;
#line 404 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!initialized) {
#line 404 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		initialized = TRUE;
#line 4699 "rygel-http-get-test.c"
	}
}


GType rygel_visual_item_get_type (void) {
	static volatile gsize rygel_visual_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_visual_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVisualItemIface), (GBaseInitFunc) rygel_visual_item_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_visual_item_type_id;
		rygel_visual_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelVisualItem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_visual_item_type_id, RYGEL_TYPE_MEDIA_ITEM);
		g_once_init_leave (&rygel_visual_item_type_id__volatile, rygel_visual_item_type_id);
	}
	return rygel_visual_item_type_id__volatile;
}


RygelVideoItem* rygel_video_item_construct (GType object_type) {
	RygelVideoItem* self = NULL;
	gchar* _tmp0_;
#line 431 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) rygel_audio_item_construct (object_type);
#line 432 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = g_strdup ("VideoItem");
#line 432 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (((RygelMediaObject*) self)->id);
#line 432 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	((RygelMediaObject*) self)->id = _tmp0_;
#line 431 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4730 "rygel-http-get-test.c"
}


RygelVideoItem* rygel_video_item_new (void) {
#line 431 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM);
#line 4737 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_width;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4753 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_width = _tmp0_;
#line 4766 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_height;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4782 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_height = _tmp0_;
#line 4795 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_pixel_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_pixel_width;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4811 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_pixel_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_pixel_width = _tmp0_;
#line 4824 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_pixel_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_pixel_height;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4840 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_pixel_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_pixel_height = _tmp0_;
#line 4853 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_color_depth (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
#line 427 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 427 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_color_depth;
#line 427 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 427 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4869 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_color_depth (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
#line 427 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 427 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 427 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_color_depth = _tmp0_;
#line 4882 "rygel-http-get-test.c"
}


static GeeArrayList* rygel_video_item_real_get_thumbnails (RygelVisualItem* base) {
	GeeArrayList* result;
	RygelVideoItem* self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	RygelThumbnail* _tmp2_;
	RygelThumbnail* _tmp3_;
	GeeArrayList* _tmp4_;
#line 436 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 437 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_thumbnail_ref, rygel_thumbnail_unref, NULL);
#line 437 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->ts);
#line 437 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->ts = _tmp0_;
#line 438 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->priv->ts;
#line 438 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = rygel_thumbnail_new ();
#line 438 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = _tmp2_;
#line 438 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp3_);
#line 438 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_thumbnail_unref0 (_tmp3_);
#line 439 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = self->priv->ts;
#line 439 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp4_;
#line 439 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4918 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_thumbnails (RygelVisualItem* base, GeeArrayList* value) {
	RygelVideoItem* self;
#line 442 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 4926 "rygel-http-get-test.c"
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelVideoItemPrivate));
#line 4937 "rygel-http-get-test.c"
}


static void rygel_video_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface) {
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_video_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_width = rygel_video_item_real_get_width;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_width = rygel_video_item_real_set_width;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_height = rygel_video_item_real_get_height;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_height = rygel_video_item_real_set_height;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_pixel_width = rygel_video_item_real_get_pixel_width;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_pixel_width = rygel_video_item_real_set_pixel_width;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_pixel_height = rygel_video_item_real_get_pixel_height;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_pixel_height = rygel_video_item_real_set_pixel_height;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_color_depth = rygel_video_item_real_get_color_depth;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_color_depth = rygel_video_item_real_set_color_depth;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_thumbnails = rygel_video_item_real_get_thumbnails;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_thumbnails = rygel_video_item_real_set_thumbnails;
#line 4968 "rygel-http-get-test.c"
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_VIDEO_ITEM_GET_PRIVATE (self);
#line 423 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_width = -1;
#line 424 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_height = -1;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_pixel_width = -1;
#line 426 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_pixel_height = -1;
#line 427 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_color_depth = -1;
#line 4985 "rygel-http-get-test.c"
}


static void rygel_video_item_finalize (RygelMediaObject* obj) {
	RygelVideoItem * self;
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_VIDEO_ITEM (obj);
#line 429 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->ts);
#line 445 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->subtitles);
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
#line 4999 "rygel-http-get-test.c"
}


GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_video_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_video_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


RygelMusicItem* rygel_music_item_construct (GType object_type) {
	RygelMusicItem* self = NULL;
#line 448 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMusicItem*) rygel_audio_item_construct (object_type);
#line 448 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 5023 "rygel-http-get-test.c"
}


RygelMusicItem* rygel_music_item_new (void) {
#line 448 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM);
#line 5030 "rygel-http-get-test.c"
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
#line 448 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
#line 448 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
#line 5039 "rygel-http-get-test.c"
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
}


static void rygel_music_item_finalize (RygelMediaObject* obj) {
	RygelMusicItem * self;
#line 448 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_MUSIC_ITEM (obj);
#line 449 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_thumbnail_unref0 (self->album_art);
#line 448 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
#line 5055 "rygel-http-get-test.c"
}


GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail* self = NULL;
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelThumbnail*) g_type_create_instance (object_type);
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 5077 "rygel-http-get-test.c"
}


RygelThumbnail* rygel_thumbnail_new (void) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
#line 5084 "rygel-http-get-test.c"
}


static void rygel_value_thumbnail_init (GValue* value) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 5091 "rygel-http-get-test.c"
}


static void rygel_value_thumbnail_free_value (GValue* value) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_unref (value->data[0].v_pointer);
#line 5100 "rygel-http-get-test.c"
	}
}


static void rygel_value_thumbnail_copy_value (const GValue* src_value, GValue* dest_value) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_thumbnail_ref (src_value->data[0].v_pointer);
#line 5110 "rygel-http-get-test.c"
	} else {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5114 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_thumbnail_peek_pointer (const GValue* value) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 5122 "rygel-http-get-test.c"
}


static gchar* rygel_value_thumbnail_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 5129 "rygel-http-get-test.c"
		RygelThumbnail* object;
		object = collect_values[0].v_pointer;
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5136 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5140 "rygel-http-get-test.c"
		}
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_thumbnail_ref (object);
#line 5144 "rygel-http-get-test.c"
	} else {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5148 "rygel-http-get-test.c"
	}
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 5152 "rygel-http-get-test.c"
}


static gchar* rygel_value_thumbnail_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelThumbnail** object_p;
	object_p = collect_values[0].v_pointer;
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5163 "rygel-http-get-test.c"
	}
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 5169 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 5173 "rygel-http-get-test.c"
	} else {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_thumbnail_ref (value->data[0].v_pointer);
#line 5177 "rygel-http-get-test.c"
	}
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 5181 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecThumbnail* spec;
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_THUMBNAIL), NULL);
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 5195 "rygel-http-get-test.c"
}


gpointer rygel_value_get_thumbnail (const GValue* value) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL), NULL);
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 5204 "rygel-http-get-test.c"
}


void rygel_value_set_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_ref (value->data[0].v_pointer);
#line 5224 "rygel-http-get-test.c"
	} else {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5228 "rygel-http-get-test.c"
	}
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_unref (old);
#line 5234 "rygel-http-get-test.c"
	}
}


void rygel_value_take_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 5253 "rygel-http-get-test.c"
	} else {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5257 "rygel-http-get-test.c"
	}
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_unref (old);
#line 5263 "rygel-http-get-test.c"
	}
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_THUMBNAIL_CLASS (klass)->finalize = rygel_thumbnail_finalize;
#line 5273 "rygel-http-get-test.c"
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
#line 453 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->size = (glong) 1024;
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 5282 "rygel-http-get-test.c"
}


static void rygel_thumbnail_finalize (RygelThumbnail* obj) {
	RygelThumbnail * self;
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_THUMBNAIL (obj);
#line 454 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->file_extension);
#line 5292 "rygel-http-get-test.c"
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_thumbnail_init, rygel_value_thumbnail_free_value, rygel_value_thumbnail_copy_value, rygel_value_thumbnail_peek_pointer, "p", rygel_value_thumbnail_collect_value, "p", rygel_value_thumbnail_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelThumbnail", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


gpointer rygel_thumbnail_ref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 5317 "rygel-http-get-test.c"
}


void rygel_thumbnail_unref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_THUMBNAIL_GET_CLASS (self)->finalize (self);
#line 452 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5330 "rygel-http-get-test.c"
	}
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle* self = NULL;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelSubtitle*) g_type_create_instance (object_type);
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 5341 "rygel-http-get-test.c"
}


RygelSubtitle* rygel_subtitle_new (void) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
#line 5348 "rygel-http-get-test.c"
}


static void rygel_value_subtitle_init (GValue* value) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 5355 "rygel-http-get-test.c"
}


static void rygel_value_subtitle_free_value (GValue* value) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_unref (value->data[0].v_pointer);
#line 5364 "rygel-http-get-test.c"
	}
}


static void rygel_value_subtitle_copy_value (const GValue* src_value, GValue* dest_value) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_subtitle_ref (src_value->data[0].v_pointer);
#line 5374 "rygel-http-get-test.c"
	} else {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5378 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_subtitle_peek_pointer (const GValue* value) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 5386 "rygel-http-get-test.c"
}


static gchar* rygel_value_subtitle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 5393 "rygel-http-get-test.c"
		RygelSubtitle* object;
		object = collect_values[0].v_pointer;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5400 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5404 "rygel-http-get-test.c"
		}
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_subtitle_ref (object);
#line 5408 "rygel-http-get-test.c"
	} else {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5412 "rygel-http-get-test.c"
	}
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 5416 "rygel-http-get-test.c"
}


static gchar* rygel_value_subtitle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelSubtitle** object_p;
	object_p = collect_values[0].v_pointer;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5427 "rygel-http-get-test.c"
	}
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 5433 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 5437 "rygel-http-get-test.c"
	} else {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_subtitle_ref (value->data[0].v_pointer);
#line 5441 "rygel-http-get-test.c"
	}
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 5445 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecSubtitle* spec;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_SUBTITLE), NULL);
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 5459 "rygel-http-get-test.c"
}


gpointer rygel_value_get_subtitle (const GValue* value) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE), NULL);
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 5468 "rygel-http-get-test.c"
}


void rygel_value_set_subtitle (GValue* value, gpointer v_object) {
	RygelSubtitle* old;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_ref (value->data[0].v_pointer);
#line 5488 "rygel-http-get-test.c"
	} else {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5492 "rygel-http-get-test.c"
	}
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_unref (old);
#line 5498 "rygel-http-get-test.c"
	}
}


void rygel_value_take_subtitle (GValue* value, gpointer v_object) {
	RygelSubtitle* old;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 5517 "rygel-http-get-test.c"
	} else {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5521 "rygel-http-get-test.c"
	}
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_unref (old);
#line 5527 "rygel-http-get-test.c"
	}
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_SUBTITLE_CLASS (klass)->finalize = rygel_subtitle_finalize;
#line 5537 "rygel-http-get-test.c"
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
#line 458 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->size = (glong) 1024;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 5546 "rygel-http-get-test.c"
}


static void rygel_subtitle_finalize (RygelSubtitle* obj) {
	RygelSubtitle * self;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_SUBTITLE (obj);
#line 459 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->caption_type);
#line 5556 "rygel-http-get-test.c"
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_subtitle_init, rygel_value_subtitle_free_value, rygel_value_subtitle_copy_value, rygel_value_subtitle_peek_pointer, "p", rygel_value_subtitle_collect_value, "p", rygel_value_subtitle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelSubtitle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


gpointer rygel_subtitle_ref (gpointer instance) {
	RygelSubtitle* self;
	self = instance;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 5581 "rygel-http-get-test.c"
}


void rygel_subtitle_unref (gpointer instance) {
	RygelSubtitle* self;
	self = instance;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_SUBTITLE_GET_CLASS (self)->finalize (self);
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5594 "rygel-http-get-test.c"
	}
}


RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* get_request) {
	RygelHTTPResponse * self = NULL;
	RygelHTTPGet* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessageHeaders* _tmp4_;
	RygelHTTPGet* _tmp5_;
	SoupServer* _tmp6_;
	SoupServer* _tmp7_;
#line 468 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (get_request != NULL, NULL);
#line 468 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) g_object_new (object_type, NULL);
#line 469 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = get_request;
#line 469 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 469 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 469 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->msg);
#line 469 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->msg = _tmp2_;
#line 470 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->priv->msg;
#line 470 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _tmp3_->response_headers;
#line 470 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_set_encoding (_tmp4_, SOUP_ENCODING_CONTENT_LENGTH);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = get_request;
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = ((RygelHTTPRequest*) _tmp5_)->server;
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->server);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->server = _tmp7_;
#line 468 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 5641 "rygel-http-get-test.c"
}


RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* get_request) {
#line 468 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_response_construct (RYGEL_TYPE_HTTP_RESPONSE, get_request);
#line 5648 "rygel-http-get-test.c"
}


static void rygel_http_response_real_run_data_free (gpointer _data) {
	RygelHttpResponseRunData* _data_;
	_data_ = _data;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->self);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelHttpResponseRunData, _data_);
#line 5659 "rygel-http-get-test.c"
}


static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPResponse * self;
	RygelHttpResponseRunData* _data_;
	RygelHTTPResponse* _tmp0_;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) base;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelHttpResponseRunData);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_response_real_run);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_response_real_run_data_free);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_response_real_run_co (_data_);
#line 5681 "rygel-http-get-test.c"
}


static void rygel_http_response_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpResponseRunData* _data_;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 5689 "rygel-http-get-test.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return _data3_;
#line 5698 "rygel-http-get-test.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 5707 "rygel-http-get-test.c"
		RygelHTTPResponse * self;
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self = _data3_->self;
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		(_data3_->run_continue_target_destroy_notify == NULL) ? NULL : (_data3_->run_continue_target_destroy_notify (_data3_->run_continue_target), NULL);
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data3_->run_continue = NULL;
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data3_->run_continue_target = NULL;
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data3_->run_continue_target_destroy_notify = NULL;
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (self);
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_slice_free (Block3Data, _data3_);
#line 5723 "rygel-http-get-test.c"
	}
}


static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_response_real_run_co (self);
#line 475 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 5733 "rygel-http-get-test.c"
}


static gboolean __lambda3_ (Block3Data* _data3_) {
	RygelHTTPResponse * self;
	gboolean result = FALSE;
#line 477 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = _data3_->self;
#line 478 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data3_->run_continue (_data3_->run_continue_target);
#line 480 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 480 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 5748 "rygel-http-get-test.c"
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
#line 477 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 5757 "rygel-http-get-test.c"
}


static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_) {
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 5766 "rygel-http-get-test.c"
		goto _state_0;
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 5770 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 5775 "rygel-http-get-test.c"
	}
	_state_0:
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_ = g_slice_new0 (Block3Data);
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->_ref_count_ = 1;
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->self = g_object_ref (_data_->self);
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->_async_data_ = _data_;
#line 475 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->run_continue = _rygel_http_response_real_run_co_gsource_func;
#line 475 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->run_continue_target = _data_;
#line 475 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->run_continue_target_destroy_notify = NULL;
#line 477 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda3__gsource_func, block3_data_ref (_data_->_data3_), block3_data_unref);
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_state_ = 1;
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 5798 "rygel-http-get-test.c"
	_state_1:
	;
#line 485 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = _data_->self->priv->msg;
#line 485 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_set_status (_data_->_tmp0_, (guint) SOUP_STATUS_OK);
#line 486 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp1_ = _data_->self->priv->server;
#line 486 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp2_ = _data_->self->priv->msg;
#line 486 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_server_unpause_message (_data_->_tmp1_, _data_->_tmp2_);
#line 488 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	block3_data_unref (_data_->_data3_);
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_ = NULL;
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 5821 "rygel-http-get-test.c"
	} else {
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 5825 "rygel-http-get-test.c"
	}
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 5831 "rygel-http-get-test.c"
}


static GCancellable* rygel_http_response_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
#line 463 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) base;
#line 463 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_cancellable;
#line 463 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 463 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 5847 "rygel-http-get-test.c"
}


static void rygel_http_response_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 463 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) base;
#line 463 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 463 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 463 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 463 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_cancellable = _tmp1_;
#line 463 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 5867 "rygel-http-get-test.c"
}


static void rygel_http_response_class_init (RygelHTTPResponseClass * klass) {
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_response_parent_class = g_type_class_peek_parent (klass);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPResponsePrivate));
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_response_get_property;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_response_set_property;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_finalize;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", G_TYPE_CANCELLABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 5884 "rygel-http-get-test.c"
}


static void rygel_http_response_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_response_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_response_real_run;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run_finish = rygel_http_response_real_run_finish;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_cancellable = rygel_http_response_real_get_cancellable;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_cancellable = rygel_http_response_real_set_cancellable;
#line 5899 "rygel-http-get-test.c"
}


static void rygel_http_response_instance_init (RygelHTTPResponse * self) {
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_HTTP_RESPONSE_GET_PRIVATE (self);
#line 5906 "rygel-http-get-test.c"
}


static void rygel_http_response_finalize (GObject* obj) {
	RygelHTTPResponse * self;
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_HTTP_RESPONSE (obj);
#line 463 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 465 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->msg);
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->server);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_response_parent_class)->finalize (obj);
#line 5922 "rygel-http-get-test.c"
}


GType rygel_http_response_get_type (void) {
	static volatile gsize rygel_http_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponse), 0, (GInstanceInitFunc) rygel_http_response_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_response_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_response_type_id;
		rygel_http_response_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponse", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_response_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_response_type_id__volatile, rygel_http_response_type_id);
	}
	return rygel_http_response_type_id__volatile;
}


static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 5951 "rygel-http-get-test.c"
		default:
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 5957 "rygel-http-get-test.c"
	}
}


static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 5973 "rygel-http-get-test.c"
		default:
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 5979 "rygel-http-get-test.c"
	}
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject* self = NULL;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMediaObject*) g_type_create_instance (object_type);
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 5990 "rygel-http-get-test.c"
}


RygelMediaObject* rygel_media_object_new (void) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
#line 5997 "rygel-http-get-test.c"
}


static void rygel_value_media_object_init (GValue* value) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 6004 "rygel-http-get-test.c"
}


static void rygel_value_media_object_free_value (GValue* value) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_unref (value->data[0].v_pointer);
#line 6013 "rygel-http-get-test.c"
	}
}


static void rygel_value_media_object_copy_value (const GValue* src_value, GValue* dest_value) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_media_object_ref (src_value->data[0].v_pointer);
#line 6023 "rygel-http-get-test.c"
	} else {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 6027 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_media_object_peek_pointer (const GValue* value) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 6035 "rygel-http-get-test.c"
}


static gchar* rygel_value_media_object_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 6042 "rygel-http-get-test.c"
		RygelMediaObject* object;
		object = collect_values[0].v_pointer;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6049 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6053 "rygel-http-get-test.c"
		}
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_media_object_ref (object);
#line 6057 "rygel-http-get-test.c"
	} else {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 6061 "rygel-http-get-test.c"
	}
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 6065 "rygel-http-get-test.c"
}


static gchar* rygel_value_media_object_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaObject** object_p;
	object_p = collect_values[0].v_pointer;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 6076 "rygel-http-get-test.c"
	}
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 6082 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 6086 "rygel-http-get-test.c"
	} else {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_media_object_ref (value->data[0].v_pointer);
#line 6090 "rygel-http-get-test.c"
	}
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 6094 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecMediaObject* spec;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_MEDIA_OBJECT), NULL);
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 6108 "rygel-http-get-test.c"
}


gpointer rygel_value_get_media_object (const GValue* value) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT), NULL);
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 6117 "rygel-http-get-test.c"
}


void rygel_value_set_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_ref (value->data[0].v_pointer);
#line 6137 "rygel-http-get-test.c"
	} else {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 6141 "rygel-http-get-test.c"
	}
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_unref (old);
#line 6147 "rygel-http-get-test.c"
	}
}


void rygel_value_take_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 6166 "rygel-http-get-test.c"
	} else {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 6170 "rygel-http-get-test.c"
	}
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_unref (old);
#line 6176 "rygel-http-get-test.c"
	}
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
#line 6186 "rygel-http-get-test.c"
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	gchar* _tmp0_;
#line 494 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = g_strdup ("");
#line 494 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->mime_type = _tmp0_;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 6198 "rygel-http-get-test.c"
}


static void rygel_media_object_finalize (RygelMediaObject* obj) {
	RygelMediaObject * self;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_MEDIA_OBJECT (obj);
#line 493 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->id);
#line 494 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->mime_type);
#line 6210 "rygel-http-get-test.c"
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_media_object_init, rygel_value_media_object_free_value, rygel_value_media_object_copy_value, rygel_value_media_object_peek_pointer, "p", rygel_value_media_object_collect_value, "p", rygel_value_media_object_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaObject", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


gpointer rygel_media_object_ref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 6235 "rygel-http-get-test.c"
}


void rygel_media_object_unref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_MEDIA_OBJECT_GET_CLASS (self)->finalize (self);
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 6248 "rygel-http-get-test.c"
	}
}


RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* extension) {
	RygelTranscoder * self = NULL;
	const gchar* _tmp0_;
#line 500 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 500 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelTranscoder*) g_object_new (object_type, NULL);
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = extension;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_transcoder_set_extension (self, _tmp0_);
#line 500 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 6266 "rygel-http-get-test.c"
}


RygelTranscoder* rygel_transcoder_new (const gchar* extension) {
#line 500 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_transcoder_construct (RYGEL_TYPE_TRANSCODER, extension);
#line 6273 "rygel-http-get-test.c"
}


const gchar* rygel_transcoder_get_extension (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 498 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 498 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_extension;
#line 498 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 498 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 6288 "rygel-http-get-test.c"
}


void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 498 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 498 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 498 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 498 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->priv->_extension);
#line 498 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_extension = _tmp1_;
#line 498 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_notify ((GObject *) self, "extension");
#line 6307 "rygel-http-get-test.c"
}


static void rygel_transcoder_class_init (RygelTranscoderClass * klass) {
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelTranscoderPrivate));
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_transcoder_get_property;
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_transcoder_set_property;
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_transcoder_finalize;
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 6324 "rygel-http-get-test.c"
}


static void rygel_transcoder_instance_init (RygelTranscoder * self) {
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_TRANSCODER_GET_PRIVATE (self);
#line 6331 "rygel-http-get-test.c"
}


static void rygel_transcoder_finalize (GObject* obj) {
	RygelTranscoder * self;
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = RYGEL_TRANSCODER (obj);
#line 498 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->priv->_extension);
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_transcoder_parent_class)->finalize (obj);
#line 6343 "rygel-http-get-test.c"
}


GType rygel_transcoder_get_type (void) {
	static volatile gsize rygel_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscoder), 0, (GInstanceInitFunc) rygel_transcoder_instance_init, NULL };
		GType rygel_transcoder_type_id;
		rygel_transcoder_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_transcoder_type_id__volatile, rygel_transcoder_type_id);
	}
	return rygel_transcoder_type_id__volatile;
}


static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = RYGEL_TRANSCODER (object);
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_TRANSCODER_EXTENSION:
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_string (value, rygel_transcoder_get_extension (self));
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6370 "rygel-http-get-test.c"
		default:
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6376 "rygel-http-get-test.c"
	}
}


static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = RYGEL_TRANSCODER (object);
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_TRANSCODER_EXTENSION:
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_transcoder_set_extension (self, g_value_get_string (value));
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6392 "rygel-http-get-test.c"
		default:
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6398 "rygel-http-get-test.c"
	}
}



