/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-message-manager.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_MESSAGE_MANAGER_H_
#define _IANJUTA_MESSAGE_MANAGER_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-message-view.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_MESSAGE_MANAGER (ianjuta_message_manager_get_type ())
#define IANJUTA_MESSAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_MESSAGE_MANAGER, IAnjutaMessageManager))
#define IANJUTA_IS_MESSAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_MESSAGE_MANAGER))
#define IANJUTA_MESSAGE_MANAGER_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_MESSAGE_MANAGER, IAnjutaMessageManagerIface))

#define IANJUTA_TYPE_MESSAGE_MANAGER_ERROR (ianjuta_message_manager_error_get_type())

#define IANJUTA_MESSAGE_MANAGER_ERROR ianjuta_message_manager_error_quark()

typedef struct _IAnjutaMessageManager IAnjutaMessageManager;
typedef struct _IAnjutaMessageManagerIface IAnjutaMessageManagerIface;

typedef enum {
	IANJUTA_MESSAGE_MANAGER_DOESNT_EXIST
} IAnjutaMessageManagerError;


struct _IAnjutaMessageManagerIface {
	GTypeInterface g_iface;
	

	IAnjutaMessageView* (*add_view) (IAnjutaMessageManager *obj, const gchar *name,  const gchar *icon, GError **err);
	GList* (*get_all_views) (IAnjutaMessageManager *obj, GError **err);
	IAnjutaMessageView* (*get_current_view) (IAnjutaMessageManager *obj, GError **err);
	IAnjutaMessageView* (*get_view_by_name) (IAnjutaMessageManager *obj, const gchar *name, GError **err);
	void (*remove_view) (IAnjutaMessageManager *obj, IAnjutaMessageView *view, GError **err);
	void (*set_current_view) (IAnjutaMessageManager *obj, IAnjutaMessageView *view, GError **err);
	void (*set_view_icon) (IAnjutaMessageManager *obj, IAnjutaMessageView *view,  GdkPixbufAnimation *icon, GError **err);
	void (*set_view_icon_from_stock) (IAnjutaMessageManager *obj, IAnjutaMessageView *view,  const gchar *icon, GError **err);
	void (*set_view_title) (IAnjutaMessageManager *obj, IAnjutaMessageView *view,  const gchar *title, GError **err);

};

GType ianjuta_message_manager_error_get_type (void);

GQuark ianjuta_message_manager_error_quark     (void);
GType  ianjuta_message_manager_get_type        (void);

IAnjutaMessageView* ianjuta_message_manager_add_view (IAnjutaMessageManager *obj, const gchar *name,  const gchar *icon, GError **err);

GList* ianjuta_message_manager_get_all_views (IAnjutaMessageManager *obj, GError **err);

IAnjutaMessageView* ianjuta_message_manager_get_current_view (IAnjutaMessageManager *obj, GError **err);

IAnjutaMessageView* ianjuta_message_manager_get_view_by_name (IAnjutaMessageManager *obj, const gchar *name, GError **err);

void ianjuta_message_manager_remove_view (IAnjutaMessageManager *obj, IAnjutaMessageView *view, GError **err);

void ianjuta_message_manager_set_current_view (IAnjutaMessageManager *obj, IAnjutaMessageView *view, GError **err);

void ianjuta_message_manager_set_view_icon (IAnjutaMessageManager *obj, IAnjutaMessageView *view,  GdkPixbufAnimation *icon, GError **err);

void ianjuta_message_manager_set_view_icon_from_stock (IAnjutaMessageManager *obj, IAnjutaMessageView *view,  const gchar *icon, GError **err);

void ianjuta_message_manager_set_view_title (IAnjutaMessageManager *obj, IAnjutaMessageView *view,  const gchar *title, GError **err);


G_END_DECLS

#endif
