/* world.c generated by valac 0.20.1.4-f5a54, the Vala compiler
 * generated from world.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "libgweather/gweather.h"
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <libgd/gd.h>

#define __vala_GWeatherLocation_free0(var) ((var == NULL) ? NULL : (var = (_vala_GWeatherLocation_free (var), NULL)))

#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;

#define CLOCKS_WORLD_TYPE_ITEM (clocks_world_item_get_type ())
#define CLOCKS_WORLD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem))
#define CLOCKS_WORLD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))
#define CLOCKS_WORLD_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))

typedef struct _ClocksWorldItem ClocksWorldItem;
typedef struct _ClocksWorldItemClass ClocksWorldItemClass;
typedef struct _ClocksWorldItemPrivate ClocksWorldItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GWeatherTimezone_free0(var) ((var == NULL) ? NULL : (var = (_vala_GWeatherTimezone_free (var), NULL)))

#define CLOCKS_UTILS_TYPE_WALL_CLOCK (clocks_utils_wall_clock_get_type ())
#define CLOCKS_UTILS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock))
#define CLOCKS_UTILS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))
#define CLOCKS_UTILS_IS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_IS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_WALL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))

typedef struct _ClocksUtilsWallClock ClocksUtilsWallClock;
typedef struct _ClocksUtilsWallClockClass ClocksUtilsWallClockClass;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))

#define CLOCKS_WORLD_TYPE_LOCATION_DIALOG (clocks_world_location_dialog_get_type ())
#define CLOCKS_WORLD_LOCATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialog))
#define CLOCKS_WORLD_LOCATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialogClass))
#define CLOCKS_WORLD_IS_LOCATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG))
#define CLOCKS_WORLD_IS_LOCATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_LOCATION_DIALOG))
#define CLOCKS_WORLD_LOCATION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialogClass))

typedef struct _ClocksWorldLocationDialog ClocksWorldLocationDialog;
typedef struct _ClocksWorldLocationDialogClass ClocksWorldLocationDialogClass;
typedef struct _ClocksWorldLocationDialogPrivate ClocksWorldLocationDialogPrivate;

#define CLOCKS_WORLD_TYPE_STANDALONE_PANEL (clocks_world_standalone_panel_get_type ())
#define CLOCKS_WORLD_STANDALONE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_STANDALONE_PANEL, ClocksWorldStandalonePanel))
#define CLOCKS_WORLD_STANDALONE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_STANDALONE_PANEL, ClocksWorldStandalonePanelClass))
#define CLOCKS_WORLD_IS_STANDALONE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_STANDALONE_PANEL))
#define CLOCKS_WORLD_IS_STANDALONE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_STANDALONE_PANEL))
#define CLOCKS_WORLD_STANDALONE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_STANDALONE_PANEL, ClocksWorldStandalonePanelClass))

typedef struct _ClocksWorldStandalonePanel ClocksWorldStandalonePanel;
typedef struct _ClocksWorldStandalonePanelClass ClocksWorldStandalonePanelClass;
typedef struct _ClocksWorldStandalonePanelPrivate ClocksWorldStandalonePanelPrivate;

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;

#define CLOCKS_TYPE_HEADER_BAR (clocks_header_bar_get_type ())
#define CLOCKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar))
#define CLOCKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))
#define CLOCKS_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))

typedef struct _ClocksHeaderBar ClocksHeaderBar;
typedef struct _ClocksHeaderBarClass ClocksHeaderBarClass;

#define CLOCKS_WORLD_TYPE_MAIN_PANEL (clocks_world_main_panel_get_type ())
#define CLOCKS_WORLD_MAIN_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_MAIN_PANEL, ClocksWorldMainPanel))
#define CLOCKS_WORLD_MAIN_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_MAIN_PANEL, ClocksWorldMainPanelClass))
#define CLOCKS_WORLD_IS_MAIN_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_MAIN_PANEL))
#define CLOCKS_WORLD_IS_MAIN_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_MAIN_PANEL))
#define CLOCKS_WORLD_MAIN_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_MAIN_PANEL, ClocksWorldMainPanelClass))

typedef struct _ClocksWorldMainPanel ClocksWorldMainPanel;
typedef struct _ClocksWorldMainPanelClass ClocksWorldMainPanelClass;
typedef struct _ClocksWorldMainPanelPrivate ClocksWorldMainPanelPrivate;

#define CLOCKS_TYPE_CONTENT_VIEW (clocks_content_view_get_type ())
#define CLOCKS_CONTENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentView))
#define CLOCKS_CONTENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentViewClass))
#define CLOCKS_IS_CONTENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_VIEW))
#define CLOCKS_IS_CONTENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_CONTENT_VIEW))
#define CLOCKS_CONTENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentViewClass))

typedef struct _ClocksContentView ClocksContentView;
typedef struct _ClocksContentViewClass ClocksContentViewClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block2Data Block2Data;

#define CLOCKS_HEADER_BAR_TYPE_MODE (clocks_header_bar_mode_get_type ())
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*get_thumb_properties) (ClocksContentItem* self, gchar** text, gchar** subtext, GdkPixbuf** pixbuf, gchar** css_class);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
};

struct _ClocksWorldItem {
	GObject parent_instance;
	ClocksWorldItemPrivate * priv;
};

struct _ClocksWorldItemClass {
	GObjectClass parent_class;
};

struct _ClocksWorldItemPrivate {
	GWeatherLocation* _location;
	gchar* _name;
	GTimeZone* time_zone;
	GDateTime* local_time;
	GDateTime* date_time;
	GWeatherInfo* weather_info;
};

struct _ClocksWorldLocationDialog {
	GtkDialog parent_instance;
	ClocksWorldLocationDialogPrivate * priv;
};

struct _ClocksWorldLocationDialogClass {
	GtkDialogClass parent_class;
};

struct _ClocksWorldLocationDialogPrivate {
	GWeatherLocationEntry* entry;
	GThemedIcon* find_icon;
	GThemedIcon* clear_icon;
};

struct _ClocksWorldStandalonePanel {
	GtkEventBox parent_instance;
	ClocksWorldStandalonePanelPrivate * priv;
};

struct _ClocksWorldStandalonePanelClass {
	GtkEventBoxClass parent_class;
};

struct _ClocksWorldStandalonePanelPrivate {
	ClocksWorldItem* _location;
	GtkLabel* time_label;
	GtkLabel* day_label;
	GtkLabel* sunrise_label;
	GtkLabel* sunset_label;
};

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	void (*activate_select_all) (ClocksClock* self);
	void (*activate_select_none) (ClocksClock* self);
	gboolean (*escape_pressed) (ClocksClock* self);
	void (*update_header_bar) (ClocksClock* self);
	const gchar* (*get_label) (ClocksClock* self);
	void (*set_label) (ClocksClock* self, const gchar* value);
	ClocksHeaderBar* (*get_header_bar) (ClocksClock* self);
	void (*set_header_bar) (ClocksClock* self, ClocksHeaderBar* value);
};

struct _ClocksWorldMainPanel {
	GdStack parent_instance;
	ClocksWorldMainPanelPrivate * priv;
};

struct _ClocksWorldMainPanelClass {
	GdStackClass parent_class;
};

struct _ClocksWorldMainPanelPrivate {
	gchar* _label;
	ClocksHeaderBar* _header_bar;
	GList* locations;
	GSettings* settings;
	GdHeaderSimpleButton* new_button;
	GdHeaderSimpleButton* back_button;
	GdkPixbuf* day_pixbuf;
	GdkPixbuf* night_pixbuf;
	ClocksContentView* content_view;
	ClocksWorldStandalonePanel* standalone;
};

struct _Block2Data {
	int _ref_count_;
	ClocksWorldMainPanel * self;
	ClocksHeaderBar* header_bar;
};

typedef enum  {
	CLOCKS_HEADER_BAR_MODE_NORMAL,
	CLOCKS_HEADER_BAR_MODE_SELECTION,
	CLOCKS_HEADER_BAR_MODE_STANDALONE
} ClocksHeaderBarMode;


extern GWeatherLocation* clocks_world_gweather_world;
GWeatherLocation* clocks_world_gweather_world = NULL;
static gpointer clocks_world_item_parent_class = NULL;
static GdkPixbuf* clocks_world_item_day_pixbuf;
static GdkPixbuf* clocks_world_item_day_pixbuf = NULL;
static GdkPixbuf* clocks_world_item_night_pixbuf;
static GdkPixbuf* clocks_world_item_night_pixbuf = NULL;
static ClocksContentItemIface* clocks_world_item_clocks_content_item_parent_iface = NULL;
static gpointer clocks_world_location_dialog_parent_class = NULL;
static gpointer clocks_world_standalone_panel_parent_class = NULL;
static gpointer clocks_world_main_panel_parent_class = NULL;
static ClocksClockIface* clocks_world_main_panel_clocks_clock_parent_iface = NULL;

GWeatherLocation* clocks_world_get_world_location (void);
static void _vala_GWeatherLocation_free (GWeatherLocation* self);
static GWeatherLocation* _vala_GWeatherLocation_copy (GWeatherLocation* self);
GType clocks_content_item_get_type (void) G_GNUC_CONST;
GType clocks_world_item_get_type (void) G_GNUC_CONST;
#define CLOCKS_WORLD_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemPrivate))
enum  {
	CLOCKS_WORLD_ITEM_DUMMY_PROPERTY,
	CLOCKS_WORLD_ITEM_LOCATION,
	CLOCKS_WORLD_ITEM_NAME,
	CLOCKS_WORLD_ITEM_CITY_NAME,
	CLOCKS_WORLD_ITEM_NATION_NAME,
	CLOCKS_WORLD_ITEM_IS_DAYTIME,
	CLOCKS_WORLD_ITEM_SUNRISE_LABEL,
	CLOCKS_WORLD_ITEM_SUNSET_LABEL,
	CLOCKS_WORLD_ITEM_TIME_LABEL,
	CLOCKS_WORLD_ITEM_DAY_LABEL
};
GdkPixbuf* clocks_utils_load_image (const gchar* image);
ClocksWorldItem* clocks_world_item_new (GWeatherLocation* location);
ClocksWorldItem* clocks_world_item_construct (GType object_type, GWeatherLocation* location);
static GWeatherTimezone* _vala_GWeatherTimezone_copy (GWeatherTimezone* self);
void clocks_world_item_tick (ClocksWorldItem* self);
static void _vala_GWeatherTimezone_free (GWeatherTimezone* self);
GType clocks_utils_wall_clock_get_type (void) G_GNUC_CONST;
ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void);
GDateTime* clocks_utils_wall_clock_get_date_time (ClocksUtilsWallClock* self);
GWeatherLocation* clocks_world_item_get_location (ClocksWorldItem* self);
static void clocks_world_item_real_get_thumb_properties (ClocksContentItem* base, gchar** text, gchar** subtext, GdkPixbuf** pixbuf, gchar** css_class);
gchar* clocks_world_item_get_time_label (ClocksWorldItem* self);
const gchar* clocks_world_item_get_day_label (ClocksWorldItem* self);
gboolean clocks_world_item_get_is_daytime (ClocksWorldItem* self);
void clocks_world_item_serialize (ClocksWorldItem* self, GVariantBuilder* builder);
ClocksWorldItem* clocks_world_item_deserialize (GVariant* location_variant);
void clocks_world_item_set_location (ClocksWorldItem* self, GWeatherLocation* value);
gchar* clocks_world_item_get_nation_name (ClocksWorldItem* self);
gchar* clocks_world_item_get_city_name (ClocksWorldItem* self);
gchar* clocks_world_item_get_sunrise_label (ClocksWorldItem* self);
gchar* clocks_world_item_get_sunset_label (ClocksWorldItem* self);
gchar* clocks_utils_wall_clock_format_time (ClocksUtilsWallClock* self, GDateTime* date_time);
static void clocks_world_item_finalize (GObject* obj);
const gchar* clocks_content_item_get_name (ClocksContentItem* self);
static void _vala_clocks_world_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void clocks_content_item_set_name (ClocksContentItem* self, const gchar* value);
static void _vala_clocks_world_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_world_location_dialog_get_type (void) G_GNUC_CONST;
#define CLOCKS_WORLD_LOCATION_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialogPrivate))
enum  {
	CLOCKS_WORLD_LOCATION_DIALOG_DUMMY_PROPERTY
};
ClocksWorldLocationDialog* clocks_world_location_dialog_new (GtkWindow* parent);
ClocksWorldLocationDialog* clocks_world_location_dialog_construct (GType object_type, GtkWindow* parent);
GtkBuilder* clocks_utils_load_ui (const gchar* ui);
static void __lambda25_ (ClocksWorldLocationDialog* self);
static void clocks_world_location_dialog_location_changed (ClocksWorldLocationDialog* self);
static void ___lambda25__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void __lambda26_ (ClocksWorldLocationDialog* self);
static void ___lambda26__gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void __lambda27_ (ClocksWorldLocationDialog* self);
static void ___lambda27__gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
ClocksWorldItem* clocks_world_location_dialog_get_location (ClocksWorldLocationDialog* self);
static void clocks_world_location_dialog_finalize (GObject* obj);
GType clocks_world_standalone_panel_get_type (void) G_GNUC_CONST;
#define CLOCKS_WORLD_STANDALONE_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_WORLD_TYPE_STANDALONE_PANEL, ClocksWorldStandalonePanelPrivate))
enum  {
	CLOCKS_WORLD_STANDALONE_PANEL_DUMMY_PROPERTY,
	CLOCKS_WORLD_STANDALONE_PANEL_LOCATION
};
ClocksWorldStandalonePanel* clocks_world_standalone_panel_new (void);
ClocksWorldStandalonePanel* clocks_world_standalone_panel_construct (GType object_type);
void clocks_world_standalone_panel_update (ClocksWorldStandalonePanel* self);
ClocksWorldItem* clocks_world_standalone_panel_get_location (ClocksWorldStandalonePanel* self);
void clocks_world_standalone_panel_set_location (ClocksWorldStandalonePanel* self, ClocksWorldItem* value);
static void clocks_world_standalone_panel_finalize (GObject* obj);
static void _vala_clocks_world_standalone_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_world_standalone_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_header_bar_get_type (void) G_GNUC_CONST;
GType clocks_clock_get_type (void) G_GNUC_CONST;
GType clocks_world_main_panel_get_type (void) G_GNUC_CONST;
GType clocks_content_view_get_type (void) G_GNUC_CONST;
#define CLOCKS_WORLD_MAIN_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_WORLD_TYPE_MAIN_PANEL, ClocksWorldMainPanelPrivate))
enum  {
	CLOCKS_WORLD_MAIN_PANEL_DUMMY_PROPERTY,
	CLOCKS_WORLD_MAIN_PANEL_LABEL,
	CLOCKS_WORLD_MAIN_PANEL_HEADER_BAR
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
ClocksWorldMainPanel* clocks_world_main_panel_new (ClocksHeaderBar* header_bar);
ClocksWorldMainPanel* clocks_world_main_panel_construct (GType object_type, ClocksHeaderBar* header_bar);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda20_ (ClocksWorldMainPanel* self);
static void ___lambda20__gtk_button_clicked (GtkButton* _sender, gpointer self);
ClocksContentView* clocks_content_view_new (GtkWidget* e, ClocksHeaderBar* b);
ClocksContentView* clocks_content_view_construct (GType object_type, GtkWidget* e, ClocksHeaderBar* b);
static void __lambda21_ (ClocksWorldMainPanel* self, GObject* item);
static void ___lambda21__clocks_content_view_item_activated (ClocksContentView* _sender, GObject* item, gpointer self);
static void __lambda22_ (ClocksWorldMainPanel* self);
GList* clocks_content_view_get_selected_items (ClocksContentView* self);
static void clocks_world_main_panel_save (ClocksWorldMainPanel* self);
static void ___lambda22__clocks_content_view_delete_selected (ClocksContentView* _sender, gpointer self);
static void clocks_world_main_panel_load (ClocksWorldMainPanel* self);
static void __lambda23_ (Block2Data* _data2_);
GType clocks_header_bar_mode_get_type (void) G_GNUC_CONST;
void clocks_header_bar_set_mode (ClocksHeaderBar* self, ClocksHeaderBarMode value);
static void ___lambda23__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda24_ (ClocksWorldMainPanel* self);
static void ___lambda24__clocks_utils_wall_clock_tick (ClocksUtilsWallClock* _sender, gpointer self);
void clocks_content_view_add_item (ClocksContentView* self, ClocksContentItem* item);
static void clocks_world_main_panel_real_activate_new (ClocksClock* base);
static void __lambda28_ (ClocksWorldMainPanel* self, GtkDialog* dialog, gint response);
static void ___lambda28__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void clocks_world_main_panel_real_activate_select_all (ClocksClock* base);
void clocks_content_view_select_all (ClocksContentView* self);
static void clocks_world_main_panel_real_activate_select_none (ClocksClock* base);
void clocks_content_view_unselect_all (ClocksContentView* self);
static gboolean clocks_world_main_panel_real_escape_pressed (ClocksClock* base);
gboolean clocks_content_view_escape_pressed (ClocksContentView* self);
static void clocks_world_main_panel_real_update_header_bar (ClocksClock* base);
ClocksHeaderBar* clocks_clock_get_header_bar (ClocksClock* self);
ClocksHeaderBarMode clocks_header_bar_get_mode (ClocksHeaderBar* self);
void clocks_content_view_update_header_bar (ClocksContentView* self);
static void clocks_world_main_panel_finalize (GObject* obj);
const gchar* clocks_clock_get_label (ClocksClock* self);
static void _vala_clocks_world_main_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void clocks_clock_set_label (ClocksClock* self, const gchar* value);
void clocks_clock_set_header_bar (ClocksClock* self, ClocksHeaderBar* value);
static void _vala_clocks_world_main_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _vala_GWeatherLocation_free (GWeatherLocation* self) {
	g_boxed_free (gweather_location_get_type (), self);
}


static GWeatherLocation* _vala_GWeatherLocation_copy (GWeatherLocation* self) {
	return g_boxed_copy (gweather_location_get_type (), self);
}


static gpointer __vala_GWeatherLocation_copy0 (gpointer self) {
	return self ? _vala_GWeatherLocation_copy (self) : NULL;
}


GWeatherLocation* clocks_world_get_world_location (void) {
	GWeatherLocation* result = NULL;
	GWeatherLocation* _tmp0_;
	GWeatherLocation* _tmp2_;
	GWeatherLocation* _tmp3_;
	_tmp0_ = clocks_world_gweather_world;
	if (_tmp0_ == NULL) {
		GWeatherLocation* _tmp1_;
		_tmp1_ = gweather_location_new_world (TRUE);
		__vala_GWeatherLocation_free0 (clocks_world_gweather_world);
		clocks_world_gweather_world = _tmp1_;
	}
	_tmp2_ = clocks_world_gweather_world;
	_tmp3_ = __vala_GWeatherLocation_copy0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static GWeatherTimezone* _vala_GWeatherTimezone_copy (GWeatherTimezone* self) {
	return g_boxed_copy (gweather_timezone_get_type (), self);
}


static gpointer __vala_GWeatherTimezone_copy0 (gpointer self) {
	return self ? _vala_GWeatherTimezone_copy (self) : NULL;
}


static void _vala_GWeatherTimezone_free (GWeatherTimezone* self) {
	g_boxed_free (gweather_timezone_get_type (), self);
}


ClocksWorldItem* clocks_world_item_construct (GType object_type, GWeatherLocation* location) {
	ClocksWorldItem * self = NULL;
	GWeatherLocation* _tmp0_;
	GWeatherLocation* _tmp1_;
	GWeatherTimezone* _tmp2_ = NULL;
	GWeatherTimezone* _tmp3_;
	GWeatherTimezone* weather_time_zone;
	const gchar* _tmp4_ = NULL;
	GTimeZone* _tmp5_;
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = location;
	self = (ClocksWorldItem*) g_object_new (object_type, "location", _tmp0_, NULL);
	_tmp1_ = location;
	_tmp2_ = gweather_location_get_timezone (_tmp1_);
	_tmp3_ = __vala_GWeatherTimezone_copy0 (_tmp2_);
	weather_time_zone = _tmp3_;
	_tmp4_ = gweather_timezone_get_tzid (weather_time_zone);
	_tmp5_ = g_time_zone_new (_tmp4_);
	_g_time_zone_unref0 (self->priv->time_zone);
	self->priv->time_zone = _tmp5_;
	clocks_world_item_tick (self);
	__vala_GWeatherTimezone_free0 (weather_time_zone);
	return self;
}


ClocksWorldItem* clocks_world_item_new (GWeatherLocation* location) {
	return clocks_world_item_construct (CLOCKS_WORLD_TYPE_ITEM, location);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


void clocks_world_item_tick (ClocksWorldItem* self) {
	ClocksUtilsWallClock* _tmp0_ = NULL;
	ClocksUtilsWallClock* wallclock;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GTimeZone* _tmp5_;
	GDateTime* _tmp6_ = NULL;
	GWeatherLocation* _tmp7_ = NULL;
	GWeatherLocation* _tmp8_;
	GWeatherLocation* _tmp9_;
	GWeatherInfo* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	wallclock = _tmp0_;
	_tmp1_ = clocks_utils_wall_clock_get_date_time (wallclock);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_date_time_ref0 (_tmp2_);
	_g_date_time_unref0 (self->priv->local_time);
	self->priv->local_time = _tmp3_;
	_tmp4_ = self->priv->local_time;
	_tmp5_ = self->priv->time_zone;
	_tmp6_ = g_date_time_to_timezone (_tmp4_, _tmp5_);
	_g_date_time_unref0 (self->priv->date_time);
	self->priv->date_time = _tmp6_;
	_tmp7_ = clocks_world_get_world_location ();
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->_location;
	_tmp10_ = gweather_info_new_for_world (_tmp8_, _tmp9_, GWEATHER_FORECAST_LIST);
	_g_object_unref0 (self->priv->weather_info);
	self->priv->weather_info = _tmp10_;
	__vala_GWeatherLocation_free0 (_tmp8_);
	_g_object_unref0 (wallclock);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void clocks_world_item_real_get_thumb_properties (ClocksContentItem* base, gchar** text, gchar** subtext, GdkPixbuf** pixbuf, gchar** css_class) {
	ClocksWorldItem * self;
	gchar* _vala_text = NULL;
	gchar* _vala_subtext = NULL;
	GdkPixbuf* _vala_pixbuf = NULL;
	gchar* _vala_css_class = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	self = (ClocksWorldItem*) base;
	_tmp0_ = clocks_world_item_get_time_label (self);
	_tmp1_ = _tmp0_;
	_g_free0 (_vala_text);
	_vala_text = _tmp1_;
	_tmp2_ = clocks_world_item_get_day_label (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_vala_subtext);
	_vala_subtext = _tmp4_;
	_tmp5_ = clocks_world_item_get_is_daytime (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = clocks_world_item_day_pixbuf;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (_vala_pixbuf);
		_vala_pixbuf = _tmp8_;
		_tmp9_ = g_strdup ("light");
		_g_free0 (_vala_css_class);
		_vala_css_class = _tmp9_;
	} else {
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = clocks_world_item_night_pixbuf;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_g_object_unref0 (_vala_pixbuf);
		_vala_pixbuf = _tmp11_;
		_tmp12_ = g_strdup ("dark");
		_g_free0 (_vala_css_class);
		_vala_css_class = _tmp12_;
	}
	if (text) {
		*text = _vala_text;
	} else {
		_g_free0 (_vala_text);
	}
	if (subtext) {
		*subtext = _vala_subtext;
	} else {
		_g_free0 (_vala_subtext);
	}
	if (pixbuf) {
		*pixbuf = _vala_pixbuf;
	} else {
		_g_object_unref0 (_vala_pixbuf);
	}
	if (css_class) {
		*css_class = _vala_css_class;
	} else {
		_g_free0 (_vala_css_class);
	}
}


void clocks_world_item_serialize (ClocksWorldItem* self, GVariantBuilder* builder) {
	GVariantBuilder* _tmp0_;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	GVariantBuilder* _tmp3_;
	GWeatherLocation* _tmp4_;
	GVariant* _tmp5_ = NULL;
	GVariantBuilder* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = builder;
	_tmp1_ = g_variant_type_new ("a{sv}");
	_tmp2_ = _tmp1_;
	g_variant_builder_open (_tmp0_, _tmp2_);
	_g_variant_type_free0 (_tmp2_);
	_tmp3_ = builder;
	_tmp4_ = self->priv->_location;
	_tmp5_ = gweather_location_serialize (_tmp4_);
	g_variant_builder_add (_tmp3_, "{sv}", "location", _tmp5_, NULL);
	_tmp6_ = builder;
	g_variant_builder_close (_tmp6_);
}


ClocksWorldItem* clocks_world_item_deserialize (GVariant* location_variant) {
	ClocksWorldItem* result = NULL;
	GWeatherLocation* location;
	ClocksWorldItem* _tmp20_ = NULL;
	GWeatherLocation* _tmp21_;
	g_return_val_if_fail (location_variant != NULL, NULL);
	location = NULL;
	{
		GVariant* _tmp0_;
		GVariantIter* _tmp1_ = NULL;
		GVariantIter* _v_it;
		GVariant* v = NULL;
		_tmp0_ = location_variant;
		_tmp1_ = g_variant_iter_new (_tmp0_);
		_v_it = _tmp1_;
		while (TRUE) {
			GVariantIter* _tmp2_;
			GVariant* _tmp3_ = NULL;
			GVariant* _tmp4_;
			GVariant* _tmp5_;
			GVariant* _tmp6_ = NULL;
			GVariant* _tmp7_;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* key;
			const gchar* _tmp11_;
			_tmp2_ = _v_it;
			_tmp3_ = g_variant_iter_next_value (_tmp2_);
			_g_variant_unref0 (v);
			v = _tmp3_;
			_tmp4_ = v;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = v;
			_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 0);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_variant_get_string (_tmp7_, NULL);
			_tmp9_ = g_strdup (_tmp8_);
			_tmp10_ = _tmp9_;
			_g_variant_unref0 (_tmp7_);
			key = _tmp10_;
			_tmp11_ = key;
			if (g_strcmp0 (_tmp11_, "location") == 0) {
				GWeatherLocation* _tmp12_ = NULL;
				GWeatherLocation* _tmp13_;
				GVariant* _tmp14_;
				GVariant* _tmp15_ = NULL;
				GVariant* _tmp16_;
				GVariant* _tmp17_ = NULL;
				GVariant* _tmp18_;
				GWeatherLocation* _tmp19_ = NULL;
				_tmp12_ = clocks_world_get_world_location ();
				_tmp13_ = _tmp12_;
				_tmp14_ = v;
				_tmp15_ = g_variant_get_child_value (_tmp14_, (gsize) 1);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_variant_get_child_value (_tmp16_, (gsize) 0);
				_tmp18_ = _tmp17_;
				_tmp19_ = gweather_location_deserialize (_tmp13_, _tmp18_);
				__vala_GWeatherLocation_free0 (location);
				location = _tmp19_;
				_g_variant_unref0 (_tmp18_);
				_g_variant_unref0 (_tmp16_);
				__vala_GWeatherLocation_free0 (_tmp13_);
			}
			_g_free0 (key);
		}
		_g_variant_unref0 (v);
		_g_variant_iter_free0 (_v_it);
	}
	_tmp21_ = location;
	if (_tmp21_ != NULL) {
		GWeatherLocation* _tmp22_;
		ClocksWorldItem* _tmp23_;
		_tmp22_ = location;
		_tmp23_ = clocks_world_item_new (_tmp22_);
		_g_object_unref0 (_tmp20_);
		_tmp20_ = _tmp23_;
	} else {
		_g_object_unref0 (_tmp20_);
		_tmp20_ = NULL;
	}
	result = _tmp20_;
	__vala_GWeatherLocation_free0 (location);
	return result;
}


GWeatherLocation* clocks_world_item_get_location (ClocksWorldItem* self) {
	GWeatherLocation* result;
	GWeatherLocation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}


void clocks_world_item_set_location (ClocksWorldItem* self, GWeatherLocation* value) {
	GWeatherLocation* _tmp0_;
	GWeatherLocation* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __vala_GWeatherLocation_copy0 (_tmp0_);
	__vala_GWeatherLocation_free0 (self->priv->_location);
	self->priv->_location = _tmp1_;
	g_object_notify ((GObject *) self, "location");
}


static const gchar* clocks_world_item_real_get_name (ClocksContentItem* base) {
	const gchar* result;
	ClocksWorldItem* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp13_;
	self = (ClocksWorldItem*) base;
	_tmp0_ = clocks_world_item_get_nation_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		_tmp4_ = clocks_world_item_get_city_name (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = clocks_world_item_get_nation_name (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("%s, %s", _tmp6_, _tmp9_);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp10_;
		_g_free0 (_tmp9_);
		_g_free0 (_tmp6_);
	} else {
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = clocks_world_item_get_city_name (self);
		_tmp12_ = _tmp11_;
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp12_;
	}
	_tmp13_ = self->priv->_name;
	result = _tmp13_;
	return result;
}


static void clocks_world_item_real_set_name (ClocksContentItem* base, const gchar* value) {
	ClocksWorldItem* self;
	self = (ClocksWorldItem*) base;
	g_object_notify ((GObject *) self, "name");
}


gchar* clocks_world_item_get_city_name (ClocksWorldItem* self) {
	gchar* result;
	GWeatherLocation* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	_tmp1_ = gweather_location_get_city_name (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* clocks_world_item_get_nation_name (ClocksWorldItem* self) {
	gchar* result;
	GWeatherLocation* _tmp0_;
	GWeatherLocation* _tmp1_;
	GWeatherLocation* nation;
	const gchar* _tmp10_ = NULL;
	GWeatherLocation* _tmp11_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	_tmp1_ = __vala_GWeatherLocation_copy0 (_tmp0_);
	nation = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		GWeatherLocation* _tmp3_;
		gboolean _tmp6_;
		GWeatherLocation* _tmp7_;
		GWeatherLocation* _tmp8_ = NULL;
		GWeatherLocation* _tmp9_;
		_tmp3_ = nation;
		if (_tmp3_ != NULL) {
			GWeatherLocation* _tmp4_;
			GWeatherLocationLevel _tmp5_ = 0;
			_tmp4_ = nation;
			_tmp5_ = gweather_location_get_level (_tmp4_);
			_tmp2_ = _tmp5_ != GWEATHER_LOCATION_COUNTRY;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp6_ = _tmp2_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = nation;
		_tmp8_ = gweather_location_get_parent (_tmp7_);
		_tmp9_ = __vala_GWeatherLocation_copy0 (_tmp8_);
		__vala_GWeatherLocation_free0 (nation);
		nation = _tmp9_;
	}
	_tmp11_ = nation;
	if (_tmp11_ != NULL) {
		GWeatherLocation* _tmp12_;
		const gchar* _tmp13_ = NULL;
		_tmp12_ = nation;
		_tmp13_ = gweather_location_get_name (_tmp12_);
		_tmp10_ = _tmp13_;
	} else {
		_tmp10_ = NULL;
	}
	_tmp14_ = _tmp10_;
	_tmp15_ = g_strdup (_tmp14_);
	result = _tmp15_;
	__vala_GWeatherLocation_free0 (nation);
	return result;
}


gboolean clocks_world_item_get_is_daytime (ClocksWorldItem* self) {
	gboolean result;
	GWeatherInfo* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->weather_info;
	_tmp1_ = gweather_info_is_daytime (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* clocks_world_item_get_sunrise_label (ClocksWorldItem* self) {
	gchar* result;
	GWeatherInfo* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->weather_info;
	_tmp1_ = gweather_info_get_sunrise (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* clocks_world_item_get_sunset_label (ClocksWorldItem* self) {
	gchar* result;
	GWeatherInfo* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->weather_info;
	_tmp1_ = gweather_info_get_sunset (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* clocks_world_item_get_time_label (ClocksWorldItem* self) {
	gchar* result;
	ClocksUtilsWallClock* _tmp0_ = NULL;
	ClocksUtilsWallClock* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->date_time;
	_tmp3_ = clocks_utils_wall_clock_format_time (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


const gchar* clocks_world_item_get_day_label (ClocksWorldItem* self) {
	const gchar* result;
	GDateTime* _tmp0_;
	gint _tmp1_ = 0;
	gint d;
	GDateTime* _tmp2_;
	gint _tmp3_ = 0;
	gint t;
	gint _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->date_time;
	_tmp1_ = g_date_time_get_day_of_year (_tmp0_);
	d = _tmp1_;
	_tmp2_ = self->priv->local_time;
	_tmp3_ = g_date_time_get_day_of_year (_tmp2_);
	t = _tmp3_;
	_tmp4_ = d;
	_tmp5_ = t;
	if (_tmp4_ < _tmp5_) {
		const gchar* _tmp6_ = NULL;
		gint _tmp7_;
		const gchar* _tmp10_;
		_tmp7_ = d;
		if (_tmp7_ == 1) {
			const gchar* _tmp8_ = NULL;
			_tmp8_ = _ ("Tomorrow");
			_tmp6_ = _tmp8_;
		} else {
			const gchar* _tmp9_ = NULL;
			_tmp9_ = _ ("Yesterday");
			_tmp6_ = _tmp9_;
		}
		_tmp10_ = _tmp6_;
		result = _tmp10_;
		return result;
	} else {
		gint _tmp11_;
		gint _tmp12_;
		_tmp11_ = d;
		_tmp12_ = t;
		if (_tmp11_ > _tmp12_) {
			const gchar* _tmp13_ = NULL;
			gint _tmp14_;
			const gchar* _tmp17_;
			_tmp14_ = t;
			if (_tmp14_ == 1) {
				const gchar* _tmp15_ = NULL;
				_tmp15_ = _ ("Yesterday");
				_tmp13_ = _tmp15_;
			} else {
				const gchar* _tmp16_ = NULL;
				_tmp16_ = _ ("Tomorrow");
				_tmp13_ = _tmp16_;
			}
			_tmp17_ = _tmp13_;
			result = _tmp17_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}


static void clocks_world_item_class_init (ClocksWorldItemClass * klass) {
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	clocks_world_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksWorldItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_world_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_world_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_world_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_LOCATION, g_param_spec_boxed ("location", "location", "location", gweather_location_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_CITY_NAME, g_param_spec_string ("city-name", "city-name", "city-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_NATION_NAME, g_param_spec_string ("nation-name", "nation-name", "nation-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_IS_DAYTIME, g_param_spec_boolean ("is-daytime", "is-daytime", "is-daytime", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_SUNRISE_LABEL, g_param_spec_string ("sunrise-label", "sunrise-label", "sunrise-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_SUNSET_LABEL, g_param_spec_string ("sunset-label", "sunset-label", "sunset-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_TIME_LABEL, g_param_spec_string ("time-label", "time-label", "time-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_DAY_LABEL, g_param_spec_string ("day-label", "day-label", "day-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = clocks_utils_load_image ("day.png");
	clocks_world_item_day_pixbuf = _tmp0_;
	_tmp1_ = clocks_utils_load_image ("night.png");
	clocks_world_item_night_pixbuf = _tmp1_;
}


static void clocks_world_item_clocks_content_item_interface_init (ClocksContentItemIface * iface) {
	clocks_world_item_clocks_content_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_thumb_properties = (void (*)(ClocksContentItem*, gchar**, gchar**, GdkPixbuf**, gchar**)) clocks_world_item_real_get_thumb_properties;
	iface->get_name = clocks_world_item_real_get_name;
	iface->set_name = clocks_world_item_real_set_name;
}


static void clocks_world_item_instance_init (ClocksWorldItem * self) {
	self->priv = CLOCKS_WORLD_ITEM_GET_PRIVATE (self);
}


static void clocks_world_item_finalize (GObject* obj) {
	ClocksWorldItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem);
	__vala_GWeatherLocation_free0 (self->priv->_location);
	_g_free0 (self->priv->_name);
	_g_time_zone_unref0 (self->priv->time_zone);
	_g_date_time_unref0 (self->priv->local_time);
	_g_date_time_unref0 (self->priv->date_time);
	_g_object_unref0 (self->priv->weather_info);
	G_OBJECT_CLASS (clocks_world_item_parent_class)->finalize (obj);
}


GType clocks_world_item_get_type (void) {
	static volatile gsize clocks_world_item_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_world_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldItem), 0, (GInstanceInitFunc) clocks_world_item_instance_init, NULL };
		static const GInterfaceInfo clocks_content_item_info = { (GInterfaceInitFunc) clocks_world_item_clocks_content_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType clocks_world_item_type_id;
		clocks_world_item_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksWorldItem", &g_define_type_info, 0);
		g_type_add_interface_static (clocks_world_item_type_id, CLOCKS_TYPE_CONTENT_ITEM, &clocks_content_item_info);
		g_once_init_leave (&clocks_world_item_type_id__volatile, clocks_world_item_type_id);
	}
	return clocks_world_item_type_id__volatile;
}


static void _vala_clocks_world_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksWorldItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem);
	switch (property_id) {
		case CLOCKS_WORLD_ITEM_LOCATION:
		g_value_set_boxed (value, clocks_world_item_get_location (self));
		break;
		case CLOCKS_WORLD_ITEM_NAME:
		g_value_set_string (value, clocks_content_item_get_name ((ClocksContentItem*) self));
		break;
		case CLOCKS_WORLD_ITEM_CITY_NAME:
		g_value_take_string (value, clocks_world_item_get_city_name (self));
		break;
		case CLOCKS_WORLD_ITEM_NATION_NAME:
		g_value_take_string (value, clocks_world_item_get_nation_name (self));
		break;
		case CLOCKS_WORLD_ITEM_IS_DAYTIME:
		g_value_set_boolean (value, clocks_world_item_get_is_daytime (self));
		break;
		case CLOCKS_WORLD_ITEM_SUNRISE_LABEL:
		g_value_take_string (value, clocks_world_item_get_sunrise_label (self));
		break;
		case CLOCKS_WORLD_ITEM_SUNSET_LABEL:
		g_value_take_string (value, clocks_world_item_get_sunset_label (self));
		break;
		case CLOCKS_WORLD_ITEM_TIME_LABEL:
		g_value_take_string (value, clocks_world_item_get_time_label (self));
		break;
		case CLOCKS_WORLD_ITEM_DAY_LABEL:
		g_value_set_string (value, clocks_world_item_get_day_label (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_world_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksWorldItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem);
	switch (property_id) {
		case CLOCKS_WORLD_ITEM_LOCATION:
		clocks_world_item_set_location (self, g_value_get_boxed (value));
		break;
		case CLOCKS_WORLD_ITEM_NAME:
		clocks_content_item_set_name ((ClocksContentItem*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void __lambda25_ (ClocksWorldLocationDialog* self) {
	clocks_world_location_dialog_location_changed (self);
}


static void ___lambda25__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda25_ (self);
}


static void __lambda26_ (ClocksWorldLocationDialog* self) {
	clocks_world_location_dialog_location_changed (self);
}


static void ___lambda26__gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	__lambda26_ (self);
}


static void __lambda27_ (ClocksWorldLocationDialog* self) {
	GWeatherLocationEntry* _tmp0_;
	GIcon* _tmp1_ = NULL;
	GThemedIcon* _tmp2_;
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_icon_gicon ((GtkEntry*) _tmp0_, GTK_ENTRY_ICON_SECONDARY);
	_tmp2_ = self->priv->clear_icon;
	if (_tmp1_ == _tmp2_) {
		GWeatherLocationEntry* _tmp3_;
		_tmp3_ = self->priv->entry;
		gtk_entry_set_text ((GtkEntry*) _tmp3_, "");
	}
}


static void ___lambda27__gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	__lambda27_ (self);
}


ClocksWorldLocationDialog* clocks_world_location_dialog_construct (GType object_type, GtkWindow* parent) {
	ClocksWorldLocationDialog * self = NULL;
	GtkWindow* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* builder;
	GObject* _tmp3_ = NULL;
	GtkGrid* _tmp4_;
	GtkGrid* grid;
	GtkBox* _tmp5_ = NULL;
	GWeatherLocation* _tmp6_ = NULL;
	GWeatherLocation* _tmp7_;
	GWeatherLocationEntry* _tmp8_;
	GWeatherLocationEntry* _tmp9_;
	GThemedIcon* _tmp10_;
	GThemedIcon* _tmp11_;
	GWeatherLocationEntry* _tmp12_;
	GThemedIcon* _tmp13_;
	GWeatherLocationEntry* _tmp14_;
	GWeatherLocationEntry* _tmp15_;
	GWeatherLocationEntry* _tmp16_;
	GWeatherLocationEntry* _tmp17_;
	GWeatherLocationEntry* _tmp18_;
	GWeatherLocationEntry* _tmp19_;
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = parent;
	_tmp1_ = _ ("Add a New World Clock");
	self = (ClocksWorldLocationDialog*) g_object_new (object_type, "transient-for", _tmp0_, "modal", TRUE, "title", _tmp1_, NULL);
	gtk_dialog_add_buttons ((GtkDialog*) self, GTK_STOCK_CANCEL, 0, GTK_STOCK_ADD, 1, NULL);
	gtk_dialog_set_default_response ((GtkDialog*) self, 1);
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, 1, FALSE);
	_tmp2_ = clocks_utils_load_ui ("world.ui");
	builder = _tmp2_;
	_tmp3_ = gtk_builder_get_object (builder, "location_dialog_content");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp3_) : NULL);
	grid = _tmp4_;
	_tmp5_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) grid);
	_tmp6_ = clocks_world_get_world_location ();
	_tmp7_ = _tmp6_;
	_tmp8_ = (GWeatherLocationEntry*) gweather_location_entry_new (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp8_;
	__vala_GWeatherLocation_free0 (_tmp7_);
	_tmp9_ = self->priv->entry;
	gtk_widget_set_size_request ((GtkWidget*) _tmp9_, 400, -1);
	_tmp10_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("edit-find-symbolic");
	_g_object_unref0 (self->priv->find_icon);
	self->priv->find_icon = _tmp10_;
	_tmp11_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("edit-clear-symbolic");
	_g_object_unref0 (self->priv->clear_icon);
	self->priv->clear_icon = _tmp11_;
	_tmp12_ = self->priv->entry;
	_tmp13_ = self->priv->find_icon;
	gtk_entry_set_icon_from_gicon ((GtkEntry*) _tmp12_, GTK_ENTRY_ICON_SECONDARY, (GIcon*) _tmp13_);
	_tmp14_ = self->priv->entry;
	gtk_entry_set_activates_default ((GtkEntry*) _tmp14_, TRUE);
	_tmp15_ = self->priv->entry;
	gtk_widget_show ((GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->entry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp16_, 0, 1, 1, 1);
	_tmp17_ = self->priv->entry;
	g_signal_connect_object ((GtkEditable*) _tmp17_, "changed", (GCallback) ___lambda25__gtk_editable_changed, self, 0);
	_tmp18_ = self->priv->entry;
	g_signal_connect_object ((GtkEntry*) _tmp18_, "activate", (GCallback) ___lambda26__gtk_entry_activate, self, 0);
	_tmp19_ = self->priv->entry;
	g_signal_connect_object ((GtkEntry*) _tmp19_, "icon-release", (GCallback) ___lambda27__gtk_entry_icon_release, self, 0);
	_g_object_unref0 (grid);
	_g_object_unref0 (builder);
	return self;
}


ClocksWorldLocationDialog* clocks_world_location_dialog_new (GtkWindow* parent) {
	return clocks_world_location_dialog_construct (CLOCKS_WORLD_TYPE_LOCATION_DIALOG, parent);
}


static void clocks_world_location_dialog_location_changed (ClocksWorldLocationDialog* self) {
	GWeatherLocation* l;
	GWeatherTimezone* t;
	GWeatherLocationEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp16_ = FALSE;
	GWeatherLocation* _tmp17_;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	l = NULL;
	t = NULL;
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	if (g_strcmp0 (_tmp1_, "") == 0) {
		GWeatherLocationEntry* _tmp2_;
		GThemedIcon* _tmp3_;
		_tmp2_ = self->priv->entry;
		_tmp3_ = self->priv->find_icon;
		gtk_entry_set_icon_from_gicon ((GtkEntry*) _tmp2_, GTK_ENTRY_ICON_SECONDARY, (GIcon*) _tmp3_);
	} else {
		GWeatherLocationEntry* _tmp4_;
		GThemedIcon* _tmp5_;
		GWeatherLocationEntry* _tmp6_;
		GWeatherLocation* _tmp7_ = NULL;
		GWeatherLocation* _tmp8_;
		_tmp4_ = self->priv->entry;
		_tmp5_ = self->priv->clear_icon;
		gtk_entry_set_icon_from_gicon ((GtkEntry*) _tmp4_, GTK_ENTRY_ICON_SECONDARY, (GIcon*) _tmp5_);
		_tmp6_ = self->priv->entry;
		_tmp7_ = gweather_location_entry_get_location (_tmp6_);
		__vala_GWeatherLocation_free0 (l);
		l = _tmp7_;
		_tmp8_ = l;
		if (_tmp8_ != NULL) {
			GWeatherLocation* _tmp9_;
			GWeatherTimezone* _tmp10_ = NULL;
			GWeatherTimezone* _tmp11_;
			GWeatherTimezone* _tmp12_;
			_tmp9_ = l;
			_tmp10_ = gweather_location_get_timezone (_tmp9_);
			_tmp11_ = __vala_GWeatherTimezone_copy0 (_tmp10_);
			__vala_GWeatherTimezone_free0 (t);
			t = _tmp11_;
			_tmp12_ = t;
			if (_tmp12_ == NULL) {
				GWeatherLocation* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				_tmp13_ = l;
				_tmp14_ = gweather_location_get_city_name (_tmp13_);
				_tmp15_ = _tmp14_;
				g_warning ("world.vala:217: Timezone not defined for %s. This is a bug in libgweat" \
"her database", _tmp15_);
				_g_free0 (_tmp15_);
			}
		}
	}
	_tmp17_ = l;
	if (_tmp17_ != NULL) {
		GWeatherTimezone* _tmp18_;
		_tmp18_ = t;
		_tmp16_ = _tmp18_ != NULL;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp19_ = _tmp16_;
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, 1, _tmp19_);
	__vala_GWeatherTimezone_free0 (t);
	__vala_GWeatherLocation_free0 (l);
}


ClocksWorldItem* clocks_world_location_dialog_get_location (ClocksWorldLocationDialog* self) {
	ClocksWorldItem* result = NULL;
	GWeatherLocationEntry* _tmp0_;
	GWeatherLocation* _tmp1_ = NULL;
	GWeatherLocation* location;
	ClocksWorldItem* _tmp2_ = NULL;
	GWeatherLocation* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = gweather_location_entry_get_location (_tmp0_);
	location = _tmp1_;
	_tmp3_ = location;
	if (_tmp3_ != NULL) {
		GWeatherLocation* _tmp4_;
		ClocksWorldItem* _tmp5_;
		_tmp4_ = location;
		_tmp5_ = clocks_world_item_new (_tmp4_);
		_g_object_unref0 (_tmp2_);
		_tmp2_ = _tmp5_;
	} else {
		_g_object_unref0 (_tmp2_);
		_tmp2_ = NULL;
	}
	result = _tmp2_;
	__vala_GWeatherLocation_free0 (location);
	return result;
}


static void clocks_world_location_dialog_class_init (ClocksWorldLocationDialogClass * klass) {
	clocks_world_location_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksWorldLocationDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = clocks_world_location_dialog_finalize;
}


static void clocks_world_location_dialog_instance_init (ClocksWorldLocationDialog * self) {
	self->priv = CLOCKS_WORLD_LOCATION_DIALOG_GET_PRIVATE (self);
}


static void clocks_world_location_dialog_finalize (GObject* obj) {
	ClocksWorldLocationDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialog);
	_g_object_unref0 (self->priv->entry);
	_g_object_unref0 (self->priv->find_icon);
	_g_object_unref0 (self->priv->clear_icon);
	G_OBJECT_CLASS (clocks_world_location_dialog_parent_class)->finalize (obj);
}


GType clocks_world_location_dialog_get_type (void) {
	static volatile gsize clocks_world_location_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_world_location_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldLocationDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_location_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldLocationDialog), 0, (GInstanceInitFunc) clocks_world_location_dialog_instance_init, NULL };
		GType clocks_world_location_dialog_type_id;
		clocks_world_location_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "ClocksWorldLocationDialog", &g_define_type_info, 0);
		g_once_init_leave (&clocks_world_location_dialog_type_id__volatile, clocks_world_location_dialog_type_id);
	}
	return clocks_world_location_dialog_type_id__volatile;
}


ClocksWorldStandalonePanel* clocks_world_standalone_panel_construct (GType object_type) {
	ClocksWorldStandalonePanel * self = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* builder;
	GObject* _tmp3_ = NULL;
	GtkGrid* _tmp4_;
	GtkGrid* grid;
	GObject* _tmp5_ = NULL;
	GtkLabel* _tmp6_;
	GObject* _tmp7_ = NULL;
	GtkLabel* _tmp8_;
	GObject* _tmp9_ = NULL;
	GtkLabel* _tmp10_;
	GObject* _tmp11_ = NULL;
	GtkLabel* _tmp12_;
	self = (ClocksWorldStandalonePanel*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "view");
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "content-view");
	_tmp2_ = clocks_utils_load_ui ("world.ui");
	builder = _tmp2_;
	_tmp3_ = gtk_builder_get_object (builder, "standalone_content");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp3_) : NULL);
	grid = _tmp4_;
	_tmp5_ = gtk_builder_get_object (builder, "time_label");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp5_) : NULL);
	_g_object_unref0 (self->priv->time_label);
	self->priv->time_label = _tmp6_;
	_tmp7_ = gtk_builder_get_object (builder, "day_label");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp7_) : NULL);
	_g_object_unref0 (self->priv->day_label);
	self->priv->day_label = _tmp8_;
	_tmp9_ = gtk_builder_get_object (builder, "sunrise_label");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp9_) : NULL);
	_g_object_unref0 (self->priv->sunrise_label);
	self->priv->sunrise_label = _tmp10_;
	_tmp11_ = gtk_builder_get_object (builder, "sunset_label");
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp11_) : NULL);
	_g_object_unref0 (self->priv->sunset_label);
	self->priv->sunset_label = _tmp12_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	_g_object_unref0 (grid);
	_g_object_unref0 (builder);
	return self;
}


ClocksWorldStandalonePanel* clocks_world_standalone_panel_new (void) {
	return clocks_world_standalone_panel_construct (CLOCKS_WORLD_TYPE_STANDALONE_PANEL);
}


void clocks_world_standalone_panel_update (ClocksWorldStandalonePanel* self) {
	ClocksWorldItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ != NULL) {
		GtkLabel* _tmp1_;
		ClocksWorldItem* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GtkLabel* _tmp6_;
		ClocksWorldItem* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GtkLabel* _tmp10_;
		ClocksWorldItem* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GtkLabel* _tmp15_;
		ClocksWorldItem* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp1_ = self->priv->time_label;
		_tmp2_ = self->priv->_location;
		_tmp3_ = clocks_world_item_get_time_label (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		gtk_label_set_label (_tmp1_, _tmp5_);
		_g_free0 (_tmp5_);
		_tmp6_ = self->priv->day_label;
		_tmp7_ = self->priv->_location;
		_tmp8_ = clocks_world_item_get_day_label (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_label_set_label (_tmp6_, _tmp9_);
		_tmp10_ = self->priv->sunrise_label;
		_tmp11_ = self->priv->_location;
		_tmp12_ = clocks_world_item_get_sunrise_label (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		gtk_label_set_label (_tmp10_, _tmp14_);
		_g_free0 (_tmp14_);
		_tmp15_ = self->priv->sunset_label;
		_tmp16_ = self->priv->_location;
		_tmp17_ = clocks_world_item_get_sunset_label (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		gtk_label_set_label (_tmp15_, _tmp19_);
		_g_free0 (_tmp19_);
	}
}


ClocksWorldItem* clocks_world_standalone_panel_get_location (ClocksWorldStandalonePanel* self) {
	ClocksWorldItem* result;
	ClocksWorldItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}


void clocks_world_standalone_panel_set_location (ClocksWorldStandalonePanel* self, ClocksWorldItem* value) {
	ClocksWorldItem* _tmp0_;
	ClocksWorldItem* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_location);
	self->priv->_location = _tmp1_;
	g_object_notify ((GObject *) self, "location");
}


static void clocks_world_standalone_panel_class_init (ClocksWorldStandalonePanelClass * klass) {
	clocks_world_standalone_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksWorldStandalonePanelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_world_standalone_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_world_standalone_panel_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_world_standalone_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_STANDALONE_PANEL_LOCATION, g_param_spec_object ("location", "location", "location", CLOCKS_WORLD_TYPE_ITEM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void clocks_world_standalone_panel_instance_init (ClocksWorldStandalonePanel * self) {
	self->priv = CLOCKS_WORLD_STANDALONE_PANEL_GET_PRIVATE (self);
}


static void clocks_world_standalone_panel_finalize (GObject* obj) {
	ClocksWorldStandalonePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_STANDALONE_PANEL, ClocksWorldStandalonePanel);
	_g_object_unref0 (self->priv->_location);
	_g_object_unref0 (self->priv->time_label);
	_g_object_unref0 (self->priv->day_label);
	_g_object_unref0 (self->priv->sunrise_label);
	_g_object_unref0 (self->priv->sunset_label);
	G_OBJECT_CLASS (clocks_world_standalone_panel_parent_class)->finalize (obj);
}


GType clocks_world_standalone_panel_get_type (void) {
	static volatile gsize clocks_world_standalone_panel_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_world_standalone_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldStandalonePanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_standalone_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldStandalonePanel), 0, (GInstanceInitFunc) clocks_world_standalone_panel_instance_init, NULL };
		GType clocks_world_standalone_panel_type_id;
		clocks_world_standalone_panel_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "ClocksWorldStandalonePanel", &g_define_type_info, 0);
		g_once_init_leave (&clocks_world_standalone_panel_type_id__volatile, clocks_world_standalone_panel_type_id);
	}
	return clocks_world_standalone_panel_type_id__volatile;
}


static void _vala_clocks_world_standalone_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksWorldStandalonePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_STANDALONE_PANEL, ClocksWorldStandalonePanel);
	switch (property_id) {
		case CLOCKS_WORLD_STANDALONE_PANEL_LOCATION:
		g_value_set_object (value, clocks_world_standalone_panel_get_location (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_world_standalone_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksWorldStandalonePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_STANDALONE_PANEL, ClocksWorldStandalonePanel);
	switch (property_id) {
		case CLOCKS_WORLD_STANDALONE_PANEL_LOCATION:
		clocks_world_standalone_panel_set_location (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ClocksWorldMainPanel * self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->header_bar);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda20_ (ClocksWorldMainPanel* self) {
	ClocksContentView* _tmp0_;
	_tmp0_ = self->priv->content_view;
	gd_stack_set_visible_child ((GdStack*) self, (GtkWidget*) _tmp0_);
}


static void ___lambda20__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda20_ (self);
}


static void __lambda21_ (ClocksWorldMainPanel* self, GObject* item) {
	GObject* _tmp0_;
	ClocksWorldItem* _tmp1_;
	ClocksWorldItem* location;
	ClocksWorldStandalonePanel* _tmp2_;
	ClocksWorldStandalonePanel* _tmp3_;
	ClocksWorldStandalonePanel* _tmp4_;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
	location = _tmp1_;
	_tmp2_ = self->priv->standalone;
	clocks_world_standalone_panel_set_location (_tmp2_, location);
	_tmp3_ = self->priv->standalone;
	clocks_world_standalone_panel_update (_tmp3_);
	_tmp4_ = self->priv->standalone;
	gd_stack_set_visible_child ((GdStack*) self, (GtkWidget*) _tmp4_);
	_g_object_unref0 (location);
}


static void ___lambda21__clocks_content_view_item_activated (ClocksContentView* _sender, GObject* item, gpointer self) {
	__lambda21_ (self, item);
}


static void __lambda22_ (ClocksWorldMainPanel* self) {
	ClocksContentView* _tmp0_;
	GList* _tmp1_ = NULL;
	_tmp0_ = self->priv->content_view;
	_tmp1_ = clocks_content_view_get_selected_items (_tmp0_);
	{
		GList* i_collection = NULL;
		GList* i_it = NULL;
		i_collection = _tmp1_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			GObject* _tmp2_;
			GObject* i = NULL;
			_tmp2_ = _g_object_ref0 ((GObject*) i_it->data);
			i = _tmp2_;
			{
				GObject* _tmp3_;
				_tmp3_ = i;
				self->priv->locations = g_list_remove (self->priv->locations, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
				_g_object_unref0 (i);
			}
		}
		__g_list_free__g_object_unref0_0 (i_collection);
	}
	clocks_world_main_panel_save (self);
}


static void ___lambda22__clocks_content_view_delete_selected (ClocksContentView* _sender, gpointer self) {
	__lambda22_ (self);
}


static void __lambda23_ (Block2Data* _data2_) {
	ClocksWorldMainPanel * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	ClocksContentView* _tmp2_;
	self = _data2_->self;
	_tmp0_ = gd_stack_get_visible_child ((GdStack*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->content_view;
	if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GTK_TYPE_WIDGET, GtkWidget)) {
		ClocksHeaderBar* _tmp3_;
		_tmp3_ = _data2_->header_bar;
		clocks_header_bar_set_mode (_tmp3_, CLOCKS_HEADER_BAR_MODE_NORMAL);
	} else {
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		ClocksWorldStandalonePanel* _tmp6_;
		_tmp4_ = gd_stack_get_visible_child ((GdStack*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->standalone;
		if (_tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_WIDGET, GtkWidget)) {
			ClocksHeaderBar* _tmp7_;
			_tmp7_ = _data2_->header_bar;
			clocks_header_bar_set_mode (_tmp7_, CLOCKS_HEADER_BAR_MODE_STANDALONE);
		}
	}
}


static void ___lambda23__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda23_ (self);
}


static void __lambda24_ (ClocksWorldMainPanel* self) {
	GList* _tmp0_;
	ClocksContentView* _tmp3_;
	ClocksWorldStandalonePanel* _tmp4_;
	_tmp0_ = self->priv->locations;
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
		l_collection = _tmp0_;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			ClocksWorldItem* _tmp1_;
			ClocksWorldItem* l = NULL;
			_tmp1_ = _g_object_ref0 ((ClocksWorldItem*) l_it->data);
			l = _tmp1_;
			{
				ClocksWorldItem* _tmp2_;
				_tmp2_ = l;
				clocks_world_item_tick (_tmp2_);
				_g_object_unref0 (l);
			}
		}
	}
	_tmp3_ = self->priv->content_view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->standalone;
	clocks_world_standalone_panel_update (_tmp4_);
}


static void ___lambda24__clocks_utils_wall_clock_tick (ClocksUtilsWallClock* _sender, gpointer self) {
	__lambda24_ (self);
}


ClocksWorldMainPanel* clocks_world_main_panel_construct (GType object_type, ClocksHeaderBar* header_bar) {
	ClocksWorldMainPanel * self = NULL;
	Block2Data* _data2_;
	ClocksHeaderBar* _tmp0_;
	ClocksHeaderBar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	ClocksHeaderBar* _tmp3_;
	GSettings* _tmp4_;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_ = NULL;
	GdHeaderSimpleButton* _tmp7_;
	GdHeaderSimpleButton* _tmp8_;
	const gchar* _tmp9_ = NULL;
	GdHeaderSimpleButton* _tmp10_;
	GdHeaderSimpleButton* _tmp11_;
	ClocksHeaderBar* _tmp12_;
	GdHeaderSimpleButton* _tmp13_;
	GdHeaderSimpleButton* _tmp14_;
	GdHeaderSimpleButton* _tmp15_;
	GdHeaderSimpleButton* _tmp16_;
	GdHeaderSimpleButton* _tmp17_;
	ClocksHeaderBar* _tmp18_;
	GdHeaderSimpleButton* _tmp19_;
	GtkBuilder* _tmp20_ = NULL;
	GtkBuilder* builder;
	GObject* _tmp21_ = NULL;
	GtkWidget* _tmp22_;
	GtkWidget* empty_view;
	ClocksHeaderBar* _tmp23_;
	ClocksContentView* _tmp24_;
	ClocksContentView* _tmp25_;
	ClocksContentView* _tmp26_;
	ClocksContentView* _tmp27_;
	ClocksWorldStandalonePanel* _tmp28_;
	ClocksWorldStandalonePanel* _tmp29_;
	ClocksContentView* _tmp30_;
	ClocksUtilsWallClock* _tmp31_ = NULL;
	ClocksUtilsWallClock* _tmp32_;
	g_return_val_if_fail (header_bar != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = header_bar;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data2_->header_bar);
	_data2_->header_bar = _tmp1_;
	_tmp2_ = _ ("World");
	_tmp3_ = _data2_->header_bar;
	self = (ClocksWorldMainPanel*) g_object_new (object_type, "label", _tmp2_, "header-bar", _tmp3_, "transition-type", GD_STACK_TRANSITION_TYPE_CROSSFADE, NULL);
	_data2_->self = g_object_ref (self);
	__g_list_free__g_object_unref0_0 (self->priv->locations);
	self->priv->locations = NULL;
	_tmp4_ = g_settings_new ("org.gnome.clocks");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	_tmp5_ = clocks_utils_load_image ("day.png");
	_g_object_unref0 (self->priv->day_pixbuf);
	self->priv->day_pixbuf = _tmp5_;
	_tmp6_ = clocks_utils_load_image ("night.png");
	_g_object_unref0 (self->priv->night_pixbuf);
	self->priv->night_pixbuf = _tmp6_;
	_tmp7_ = (GdHeaderSimpleButton*) gd_header_simple_button_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->new_button);
	self->priv->new_button = _tmp7_;
	_tmp8_ = self->priv->new_button;
	_tmp9_ = _ ("New");
	g_object_set ((GdHeaderButton*) _tmp8_, "label", _tmp9_, NULL);
	_tmp10_ = self->priv->new_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp10_, TRUE);
	_tmp11_ = self->priv->new_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp11_, "win.new");
	_tmp12_ = _data2_->header_bar;
	_tmp13_ = self->priv->new_button;
	gd_header_bar_pack_start ((GdHeaderBar*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = (GdHeaderSimpleButton*) gd_header_simple_button_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->back_button);
	self->priv->back_button = _tmp14_;
	_tmp15_ = self->priv->back_button;
	g_object_set ((GdHeaderButton*) _tmp15_, "symbolic-icon-name", "go-previous-symbolic", NULL);
	_tmp16_ = self->priv->back_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp16_, TRUE);
	_tmp17_ = self->priv->back_button;
	g_signal_connect_object ((GtkButton*) _tmp17_, "clicked", (GCallback) ___lambda20__gtk_button_clicked, self, 0);
	_tmp18_ = _data2_->header_bar;
	_tmp19_ = self->priv->back_button;
	gd_header_bar_pack_start ((GdHeaderBar*) _tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = clocks_utils_load_ui ("world.ui");
	builder = _tmp20_;
	_tmp21_ = gtk_builder_get_object (builder, "empty_panel");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp21_) : NULL);
	empty_view = _tmp22_;
	_tmp23_ = _data2_->header_bar;
	_tmp24_ = clocks_content_view_new (empty_view, _tmp23_);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->content_view);
	self->priv->content_view = _tmp24_;
	_tmp25_ = self->priv->content_view;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->content_view;
	g_signal_connect_object (_tmp26_, "item-activated", (GCallback) ___lambda21__clocks_content_view_item_activated, self, 0);
	_tmp27_ = self->priv->content_view;
	g_signal_connect_object (_tmp27_, "delete-selected", (GCallback) ___lambda22__clocks_content_view_delete_selected, self, 0);
	_tmp28_ = clocks_world_standalone_panel_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->standalone);
	self->priv->standalone = _tmp28_;
	_tmp29_ = self->priv->standalone;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp29_);
	clocks_world_main_panel_load (self);
	g_signal_connect_data ((GObject*) self, "notify::visible-child", (GCallback) ___lambda23__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp30_ = self->priv->content_view;
	gd_stack_set_visible_child ((GdStack*) self, (GtkWidget*) _tmp30_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp31_ = clocks_utils_wall_clock_get_default ();
	_tmp32_ = _tmp31_;
	g_signal_connect_object (_tmp32_, "tick", (GCallback) ___lambda24__clocks_utils_wall_clock_tick, self, 0);
	_g_object_unref0 (_tmp32_);
	_g_object_unref0 (empty_view);
	_g_object_unref0 (builder);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}


ClocksWorldMainPanel* clocks_world_main_panel_new (ClocksHeaderBar* header_bar) {
	return clocks_world_main_panel_construct (CLOCKS_WORLD_TYPE_MAIN_PANEL, header_bar);
}


static void clocks_world_main_panel_load (ClocksWorldMainPanel* self) {
	g_return_if_fail (self != NULL);
	{
		GSettings* _tmp0_;
		GVariant* _tmp1_ = NULL;
		GVariant* _tmp2_;
		GVariantIter* _tmp3_ = NULL;
		GVariantIter* _tmp4_;
		GVariantIter* _l_it;
		GVariant* l = NULL;
		_tmp0_ = self->priv->settings;
		_tmp1_ = g_settings_get_value (_tmp0_, "world-clocks");
		_tmp2_ = _tmp1_;
		_tmp3_ = g_variant_iter_new (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_variant_unref0 (_tmp2_);
		_l_it = _tmp4_;
		while (TRUE) {
			GVariantIter* _tmp5_;
			GVariant* _tmp6_ = NULL;
			GVariant* _tmp7_;
			GVariant* _tmp8_;
			ClocksWorldItem* _tmp9_ = NULL;
			ClocksWorldItem* location;
			ClocksWorldItem* _tmp10_;
			_tmp5_ = _l_it;
			_tmp6_ = g_variant_iter_next_value (_tmp5_);
			_g_variant_unref0 (l);
			l = _tmp6_;
			_tmp7_ = l;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = l;
			_tmp9_ = clocks_world_item_deserialize (_tmp8_);
			location = _tmp9_;
			_tmp10_ = location;
			if (_tmp10_ != NULL) {
				ClocksWorldItem* _tmp11_;
				ClocksWorldItem* _tmp12_;
				ClocksContentView* _tmp13_;
				ClocksWorldItem* _tmp14_;
				_tmp11_ = location;
				_tmp12_ = _g_object_ref0 (_tmp11_);
				self->priv->locations = g_list_prepend (self->priv->locations, _tmp12_);
				_tmp13_ = self->priv->content_view;
				_tmp14_ = location;
				clocks_content_view_add_item (_tmp13_, (ClocksContentItem*) _tmp14_);
			}
			_g_object_unref0 (location);
		}
		_g_variant_unref0 (l);
		_g_variant_iter_free0 (_l_it);
	}
	self->priv->locations = g_list_reverse (self->priv->locations);
}


static void clocks_world_main_panel_save (ClocksWorldMainPanel* self) {
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* builder;
	GList* _tmp4_;
	GSettings* _tmp8_;
	GVariantBuilder* _tmp9_;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_variant_type_new ("aa{sv}");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	builder = _tmp3_;
	_tmp4_ = self->priv->locations;
	{
		GList* i_collection = NULL;
		GList* i_it = NULL;
		i_collection = _tmp4_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			ClocksWorldItem* _tmp5_;
			ClocksWorldItem* i = NULL;
			_tmp5_ = _g_object_ref0 ((ClocksWorldItem*) i_it->data);
			i = _tmp5_;
			{
				ClocksWorldItem* _tmp6_;
				GVariantBuilder* _tmp7_;
				_tmp6_ = i;
				_tmp7_ = builder;
				clocks_world_item_serialize (_tmp6_, _tmp7_);
				_g_object_unref0 (i);
			}
		}
	}
	_tmp8_ = self->priv->settings;
	_tmp9_ = builder;
	_tmp10_ = g_variant_builder_end (_tmp9_);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	g_settings_set_value (_tmp8_, "world-clocks", _tmp11_);
	_g_variant_unref0 (_tmp11_);
	_g_variant_builder_unref0 (builder);
}


static void __lambda28_ (ClocksWorldMainPanel* self, GtkDialog* dialog, gint response) {
	gint _tmp0_;
	GtkDialog* _tmp7_;
	g_return_if_fail (dialog != NULL);
	_tmp0_ = response;
	if (_tmp0_ == 1) {
		GtkDialog* _tmp1_;
		ClocksWorldItem* _tmp2_ = NULL;
		ClocksWorldItem* location;
		ClocksWorldItem* _tmp3_;
		ClocksWorldItem* _tmp4_;
		ClocksContentView* _tmp5_;
		ClocksWorldItem* _tmp6_;
		_tmp1_ = dialog;
		_tmp2_ = clocks_world_location_dialog_get_location (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialog));
		location = _tmp2_;
		_tmp3_ = location;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		self->priv->locations = g_list_append (self->priv->locations, _tmp4_);
		_tmp5_ = self->priv->content_view;
		_tmp6_ = location;
		clocks_content_view_add_item (_tmp5_, (ClocksContentItem*) _tmp6_);
		clocks_world_main_panel_save (self);
		_g_object_unref0 (location);
	}
	_tmp7_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp7_);
}


static void ___lambda28__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda28_ (self, _sender, response_id);
}


static void clocks_world_main_panel_real_activate_new (ClocksClock* base) {
	ClocksWorldMainPanel * self;
	GtkWidget* _tmp0_ = NULL;
	ClocksWorldLocationDialog* _tmp1_;
	ClocksWorldLocationDialog* dialog;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = clocks_world_location_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GTK_TYPE_WINDOW, GtkWindow));
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	g_signal_connect_object ((GtkDialog*) dialog, "response", (GCallback) ___lambda28__gtk_dialog_response, self, 0);
	gtk_widget_show ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


static void clocks_world_main_panel_real_activate_select_all (ClocksClock* base) {
	ClocksWorldMainPanel * self;
	ClocksContentView* _tmp0_;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = self->priv->content_view;
	clocks_content_view_select_all (_tmp0_);
}


static void clocks_world_main_panel_real_activate_select_none (ClocksClock* base) {
	ClocksWorldMainPanel * self;
	ClocksContentView* _tmp0_;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = self->priv->content_view;
	clocks_content_view_unselect_all (_tmp0_);
}


static gboolean clocks_world_main_panel_real_escape_pressed (ClocksClock* base) {
	ClocksWorldMainPanel * self;
	gboolean result = FALSE;
	ClocksContentView* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = self->priv->content_view;
	_tmp1_ = clocks_content_view_escape_pressed (_tmp0_);
	result = _tmp1_;
	return result;
}


static void clocks_world_main_panel_real_update_header_bar (ClocksClock* base) {
	ClocksWorldMainPanel * self;
	ClocksHeaderBar* _tmp0_;
	ClocksHeaderBar* _tmp1_;
	ClocksHeaderBarMode _tmp2_;
	ClocksHeaderBarMode _tmp3_;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = clocks_clock_get_header_bar ((ClocksClock*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = clocks_header_bar_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case CLOCKS_HEADER_BAR_MODE_NORMAL:
		{
			GdHeaderSimpleButton* _tmp4_;
			ClocksContentView* _tmp5_;
			_tmp4_ = self->priv->new_button;
			gtk_widget_show ((GtkWidget*) _tmp4_);
			_tmp5_ = self->priv->content_view;
			clocks_content_view_update_header_bar (_tmp5_);
			break;
		}
		case CLOCKS_HEADER_BAR_MODE_SELECTION:
		{
			ClocksContentView* _tmp6_;
			_tmp6_ = self->priv->content_view;
			clocks_content_view_update_header_bar (_tmp6_);
			break;
		}
		case CLOCKS_HEADER_BAR_MODE_STANDALONE:
		{
			ClocksHeaderBar* _tmp7_;
			ClocksHeaderBar* _tmp8_;
			ClocksWorldStandalonePanel* _tmp9_;
			ClocksWorldItem* _tmp10_;
			ClocksWorldItem* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			ClocksHeaderBar* _tmp17_;
			ClocksHeaderBar* _tmp18_;
			ClocksWorldStandalonePanel* _tmp19_;
			ClocksWorldItem* _tmp20_;
			ClocksWorldItem* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			GdHeaderSimpleButton* _tmp27_;
			_tmp7_ = clocks_clock_get_header_bar ((ClocksClock*) self);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->priv->standalone;
			_tmp10_ = clocks_world_standalone_panel_get_location (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = clocks_world_item_get_city_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _tmp13_;
			_tmp15_ = g_markup_escape_text (_tmp14_, (gssize) (-1));
			_tmp16_ = _tmp15_;
			gd_header_bar_set_title ((GdHeaderBar*) _tmp8_, _tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
			_tmp17_ = clocks_clock_get_header_bar ((ClocksClock*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = self->priv->standalone;
			_tmp20_ = clocks_world_standalone_panel_get_location (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = clocks_world_item_get_nation_name (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = _tmp23_;
			_tmp25_ = g_markup_escape_text (_tmp24_, (gssize) (-1));
			_tmp26_ = _tmp25_;
			gd_header_bar_set_subtitle ((GdHeaderBar*) _tmp18_, _tmp26_);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp24_);
			_tmp27_ = self->priv->back_button;
			gtk_widget_show ((GtkWidget*) _tmp27_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static const gchar* clocks_world_main_panel_real_get_label (ClocksClock* base) {
	const gchar* result;
	ClocksWorldMainPanel* self;
	const gchar* _tmp0_;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}


static void clocks_world_main_panel_real_set_label (ClocksClock* base, const gchar* value) {
	ClocksWorldMainPanel* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_label);
	self->priv->_label = _tmp1_;
	g_object_notify ((GObject *) self, "label");
}


static ClocksHeaderBar* clocks_world_main_panel_real_get_header_bar (ClocksClock* base) {
	ClocksHeaderBar* result;
	ClocksWorldMainPanel* self;
	ClocksHeaderBar* _tmp0_;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = self->priv->_header_bar;
	result = _tmp0_;
	return result;
}


static void clocks_world_main_panel_real_set_header_bar (ClocksClock* base, ClocksHeaderBar* value) {
	ClocksWorldMainPanel* self;
	ClocksHeaderBar* _tmp0_;
	ClocksHeaderBar* _tmp1_;
	self = (ClocksWorldMainPanel*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_header_bar);
	self->priv->_header_bar = _tmp1_;
	g_object_notify ((GObject *) self, "header-bar");
}


static void clocks_world_main_panel_class_init (ClocksWorldMainPanelClass * klass) {
	clocks_world_main_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksWorldMainPanelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_world_main_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_world_main_panel_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_world_main_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_MAIN_PANEL_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_MAIN_PANEL_HEADER_BAR, g_param_spec_object ("header-bar", "header-bar", "header-bar", CLOCKS_TYPE_HEADER_BAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void clocks_world_main_panel_clocks_clock_interface_init (ClocksClockIface * iface) {
	clocks_world_main_panel_clocks_clock_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate_new = (void (*)(ClocksClock*)) clocks_world_main_panel_real_activate_new;
	iface->activate_select_all = (void (*)(ClocksClock*)) clocks_world_main_panel_real_activate_select_all;
	iface->activate_select_none = (void (*)(ClocksClock*)) clocks_world_main_panel_real_activate_select_none;
	iface->escape_pressed = (gboolean (*)(ClocksClock*)) clocks_world_main_panel_real_escape_pressed;
	iface->update_header_bar = (void (*)(ClocksClock*)) clocks_world_main_panel_real_update_header_bar;
	iface->get_label = clocks_world_main_panel_real_get_label;
	iface->set_label = clocks_world_main_panel_real_set_label;
	iface->get_header_bar = clocks_world_main_panel_real_get_header_bar;
	iface->set_header_bar = clocks_world_main_panel_real_set_header_bar;
}


static void clocks_world_main_panel_instance_init (ClocksWorldMainPanel * self) {
	self->priv = CLOCKS_WORLD_MAIN_PANEL_GET_PRIVATE (self);
}


static void clocks_world_main_panel_finalize (GObject* obj) {
	ClocksWorldMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_MAIN_PANEL, ClocksWorldMainPanel);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->_header_bar);
	__g_list_free__g_object_unref0_0 (self->priv->locations);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->new_button);
	_g_object_unref0 (self->priv->back_button);
	_g_object_unref0 (self->priv->day_pixbuf);
	_g_object_unref0 (self->priv->night_pixbuf);
	_g_object_unref0 (self->priv->content_view);
	_g_object_unref0 (self->priv->standalone);
	G_OBJECT_CLASS (clocks_world_main_panel_parent_class)->finalize (obj);
}


GType clocks_world_main_panel_get_type (void) {
	static volatile gsize clocks_world_main_panel_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_world_main_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldMainPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_main_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldMainPanel), 0, (GInstanceInitFunc) clocks_world_main_panel_instance_init, NULL };
		static const GInterfaceInfo clocks_clock_info = { (GInterfaceInitFunc) clocks_world_main_panel_clocks_clock_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType clocks_world_main_panel_type_id;
		clocks_world_main_panel_type_id = g_type_register_static (gd_stack_get_type (), "ClocksWorldMainPanel", &g_define_type_info, 0);
		g_type_add_interface_static (clocks_world_main_panel_type_id, CLOCKS_TYPE_CLOCK, &clocks_clock_info);
		g_once_init_leave (&clocks_world_main_panel_type_id__volatile, clocks_world_main_panel_type_id);
	}
	return clocks_world_main_panel_type_id__volatile;
}


static void _vala_clocks_world_main_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksWorldMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_MAIN_PANEL, ClocksWorldMainPanel);
	switch (property_id) {
		case CLOCKS_WORLD_MAIN_PANEL_LABEL:
		g_value_set_string (value, clocks_clock_get_label ((ClocksClock*) self));
		break;
		case CLOCKS_WORLD_MAIN_PANEL_HEADER_BAR:
		g_value_set_object (value, clocks_clock_get_header_bar ((ClocksClock*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_world_main_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksWorldMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_MAIN_PANEL, ClocksWorldMainPanel);
	switch (property_id) {
		case CLOCKS_WORLD_MAIN_PANEL_LABEL:
		clocks_clock_set_label ((ClocksClock*) self, g_value_get_string (value));
		break;
		case CLOCKS_WORLD_MAIN_PANEL_HEADER_BAR:
		clocks_clock_set_header_bar ((ClocksClock*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



