/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-project-manager.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_PROJECT_MANAGER_H_
#define _IANJUTA_PROJECT_MANAGER_H_

#include <glib-object.h>
#include <libanjuta/anjuta-project.h>
#include <libanjuta/interfaces/ianjuta-project.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_PROJECT_MANAGER (ianjuta_project_manager_get_type ())
#define IANJUTA_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_PROJECT_MANAGER, IAnjutaProjectManager))
#define IANJUTA_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_PROJECT_MANAGER))
#define IANJUTA_PROJECT_MANAGER_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_PROJECT_MANAGER, IAnjutaProjectManagerIface))

#define IANJUTA_PROJECT_MANAGER_ERROR ianjuta_project_manager_error_quark()

/**
* IANJUTA_PROJECT_MANAGER_PROJECT_ROOT_URI:
*
* Anjuta shell value set by project manager to the project root uri.
*/
#define	IANJUTA_PROJECT_MANAGER_PROJECT_ROOT_URI	"project_root_uri"

/**
* IANJUTA_PROJECT_MANAGER_CURRENT_PROJECT:
*
* Anjuta shell value set by project manager to the current project object
* which implement #IAnjutaProject interface.
*/
#define	IANJUTA_PROJECT_MANAGER_CURRENT_PROJECT	"project_manager_current_project"

/**
* IANJUTA_PROJECT_MANAGER_CURRENT_URI:
*
* Anjuta shell value set by project manager to the current uri.
*/
#define	IANJUTA_PROJECT_MANAGER_CURRENT_URI	"project_manager_current_uri"


typedef struct _IAnjutaProjectManager IAnjutaProjectManager;
typedef struct _IAnjutaProjectManagerIface IAnjutaProjectManagerIface;


struct _IAnjutaProjectManagerIface {
	GTypeInterface g_iface;
	
	/* Signal */
	void (*element_added) (IAnjutaProjectManager *obj, GFile *element);
	/* Signal */
	void (*element_removed) (IAnjutaProjectManager *obj, GFile *element);
	/* Signal */
	void (*element_selected) (IAnjutaProjectManager *obj, GFile *element);
	/* Signal */
	void (*project_loaded) (IAnjutaProjectManager *obj, GError *error);

	GFile* (*add_group) (IAnjutaProjectManager *obj, const gchar *name,  GFile *default_group, GError **err);
	GFile* (*add_source) (IAnjutaProjectManager *obj, const gchar *name,  GFile *default_target, GError **err);
	GFile* (*add_source_quiet) (IAnjutaProjectManager *obj, const gchar *name,  GFile *target, GError **err);
	GList* (*add_sources) (IAnjutaProjectManager *obj, GList* names,  GFile *default_target, GError **err);
	GFile* (*add_target) (IAnjutaProjectManager *obj, const gchar *name,  GFile *default_group, GError **err);
	guint (*get_capabilities) (IAnjutaProjectManager *obj, GError **err);
	GList* (*get_children) (IAnjutaProjectManager *obj, GFile *parent,  gint children_type, GError **err);
	IAnjutaProject* (*get_current_project) (IAnjutaProjectManager *obj, GError **err);
	GList* (*get_elements) (IAnjutaProjectManager *obj, AnjutaProjectNodeType element_type, GError **err);
	GList* (*get_packages) (IAnjutaProjectManager *obj, GError **err);
	GFile* (*get_parent) (IAnjutaProjectManager *obj, GFile *element, GError **err);
	GFile* (*get_selected) (IAnjutaProjectManager *obj, GError **err);
	AnjutaProjectNodeType (*get_target_type) (IAnjutaProjectManager *obj, GFile *target, GError **err);
	GList* (*get_targets) (IAnjutaProjectManager *obj, AnjutaProjectNodeType target_type, GError **err);
	gboolean (*is_open) (IAnjutaProjectManager *obj, GError **err);

};


GQuark ianjuta_project_manager_error_quark     (void);
GType  ianjuta_project_manager_get_type        (void);

GFile* ianjuta_project_manager_add_group (IAnjutaProjectManager *obj, const gchar *name,  GFile *default_group, GError **err);

GFile* ianjuta_project_manager_add_source (IAnjutaProjectManager *obj, const gchar *name,  GFile *default_target, GError **err);

GFile* ianjuta_project_manager_add_source_quiet (IAnjutaProjectManager *obj, const gchar *name,  GFile *target, GError **err);

GList* ianjuta_project_manager_add_sources (IAnjutaProjectManager *obj, GList* names,  GFile *default_target, GError **err);

GFile* ianjuta_project_manager_add_target (IAnjutaProjectManager *obj, const gchar *name,  GFile *default_group, GError **err);

guint ianjuta_project_manager_get_capabilities (IAnjutaProjectManager *obj, GError **err);

GList* ianjuta_project_manager_get_children (IAnjutaProjectManager *obj, GFile *parent,  gint children_type, GError **err);

IAnjutaProject* ianjuta_project_manager_get_current_project (IAnjutaProjectManager *obj, GError **err);

GList* ianjuta_project_manager_get_elements (IAnjutaProjectManager *obj, AnjutaProjectNodeType element_type, GError **err);

GList* ianjuta_project_manager_get_packages (IAnjutaProjectManager *obj, GError **err);

GFile* ianjuta_project_manager_get_parent (IAnjutaProjectManager *obj, GFile *element, GError **err);

GFile* ianjuta_project_manager_get_selected (IAnjutaProjectManager *obj, GError **err);

AnjutaProjectNodeType ianjuta_project_manager_get_target_type (IAnjutaProjectManager *obj, GFile *target, GError **err);

GList* ianjuta_project_manager_get_targets (IAnjutaProjectManager *obj, AnjutaProjectNodeType target_type, GError **err);

gboolean ianjuta_project_manager_is_open (IAnjutaProjectManager *obj, GError **err);


G_END_DECLS

#endif
