/* cheese-window.c generated by valac 0.20.1.38-e560, the Vala compiler
 * generated from cheese-window.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cheese-fileutil.h>
#include <clutter/clutter.h>
#include <gio/gio.h>
#include <clutter-gtk/clutter-gtk.h>
#include <thumbview/eog-thumb-nav.h>
#include <thumbview/cheese-thumb-view.h>
#include <stdlib.h>
#include <string.h>
#include <cheese-camera.h>
#include <cheese-flash.h>
#include <cheese-effect.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cheese-camera-device.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <cheese-config.h>
#include <stdio.h>


#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
typedef struct _CheeseMainWindowPrivate CheeseMainWindowPrivate;

#define CHEESE_TYPE_EFFECTS_MANAGER (cheese_effects_manager_get_type ())
#define CHEESE_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManager))
#define CHEESE_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))
#define CHEESE_IS_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_IS_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))

typedef struct _CheeseEffectsManager CheeseEffectsManager;
typedef struct _CheeseEffectsManagerClass CheeseEffectsManagerClass;

#define CHEESE_TYPE_COUNTDOWN (cheese_countdown_get_type ())
#define CHEESE_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdown))
#define CHEESE_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))
#define CHEESE_IS_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_IS_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_COUNTDOWN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))

typedef struct _CheeseCountdown CheeseCountdown;
typedef struct _CheeseCountdownClass CheeseCountdownClass;

#define CHEESE_MAIN_WINDOW_TYPE_DELETE_RESPONSE (cheese_main_window_delete_response_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _CheeseCountdownPrivate CheeseCountdownPrivate;
typedef struct _CheeseEffectsManagerPrivate CheeseEffectsManagerPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))

struct _CheeseMainWindow {
	GtkApplicationWindow parent_instance;
	CheeseMainWindowPrivate * priv;
};

struct _CheeseMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _CheeseMainWindowPrivate {
	CheeseMediaMode current_mode;
	GtkBuilder* gtk_builder;
	ClutterScript* clutter_builder;
	GSettings* settings;
	GtkWidget* thumbnails;
	GtkClutterEmbed* viewport_widget;
	GtkGrid* main_vbox;
	EogThumbNav* thumb_nav;
	CheeseThumbView* thumb_view;
	GtkAlignment* thumbnails_right;
	GtkAlignment* thumbnails_bottom;
	GtkGrid* leave_fullscreen_button_container;
	GtkToggleButton* photo_toggle_button;
	GtkToggleButton* video_toggle_button;
	GtkToggleButton* burst_toggle_button;
	GtkButton* take_action_button;
	GtkLabel* take_action_button_label;
	GtkImage* take_action_button_image;
	GtkToggleButton* effects_toggle_button;
	GtkButton* leave_fullscreen_button;
	GtkGrid* buttons_area;
	GtkMenu* thumbnail_popup;
	ClutterStage* viewport;
	ClutterActor* viewport_layout;
	ClutterTexture* video_preview;
	ClutterBinLayout* viewport_layout_manager;
	ClutterText* countdown_layer;
	ClutterActor* background_layer;
	ClutterText* error_layer;
	ClutterText* timeout_layer;
	ClutterActor* current_effects_grid;
	guint current_effects_page;
	GList* effects_grids;
	GHashTable* action_sensitivities;
	GtkToggleAction* wide_mode_action;
	GtkAction* countdown_action;
	GtkAction* effects_page_prev_action;
	GtkAction* effects_page_next_action;
	gboolean is_fullscreen;
	gboolean is_wide_mode;
	gboolean is_recording;
	gboolean is_bursting;
	gboolean is_effects_selector_active;
	gboolean is_camera_actions_sensitive;
	gboolean action_cancelled;
	gboolean is_command_line_startup;
	GtkButton** buttons;
	gint buttons_length1;
	gint _buttons_size_;
	CheeseCamera* camera;
	CheeseFileUtil* fileutil;
	CheeseFlash* flash;
	CheeseEffectsManager* effects_manager;
	CheeseEffect* selected_effect;
	GSource* fullscreen_timeout;
	CheeseCountdown* current_countdown;
	gint burst_count;
	guint burst_callback_id;
};

typedef enum  {
	CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP = 1,
	CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL = 2
} CheeseMainWindowDeleteResponse;

typedef void (*CheeseCountdownCountdownCallback) (void* user_data);
struct _CheeseCountdown {
	GObject parent_instance;
	CheeseCountdownPrivate * priv;
	gboolean running;
};

struct _CheeseCountdownClass {
	GObjectClass parent_class;
};

struct _CheeseEffectsManager {
	GObject parent_instance;
	CheeseEffectsManagerPrivate * priv;
	GList* effects;
};

struct _CheeseEffectsManagerClass {
	GObjectClass parent_class;
};


static gpointer cheese_main_window_parent_class = NULL;

#define FULLSCREEN_TIMEOUT_INTERVAL (5 * 1000)
#define EFFECTS_PER_PAGE ((guint) 9)
GType cheese_main_window_get_type (void) G_GNUC_CONST;
GType cheese_effects_manager_get_type (void) G_GNUC_CONST;
GType cheese_countdown_get_type (void) G_GNUC_CONST;
#define CHEESE_MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowPrivate))
enum  {
	CHEESE_MAIN_WINDOW_DUMMY_PROPERTY
};
static GType cheese_main_window_delete_response_get_type (void) G_GNUC_UNUSED;
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
CheeseMainWindow* cheese_main_window_new (GtkApplication* application);
CheeseMainWindow* cheese_main_window_construct (GType object_type, GtkApplication* application);
gboolean cheese_main_window_on_thumbnail_mouse_button_press (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event);
void cheese_main_window_on_file_open (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_delete (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_move_to_trash (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_move_to_trash_all (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_trash_enumerated_files (CheeseMainWindow* self, const gchar* directory, GFileEnumerator* enumerator);
void cheese_main_window_on_file_save_as (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_layout_wide_mode (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode);
void cheese_main_window_set_fullscreen (gboolean fullscreen, CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen_mode);
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_set_resolution (CheeseMainWindow* self, CheeseMediaMode mode);
static void cheese_main_window_set_mode (CheeseMainWindow* self, CheeseMediaMode mode);
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self);
static gboolean __lambda4_ (CheeseMainWindow* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e);
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags);
void cheese_main_window_on_countdown_toggle (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self);
void cheese_main_window_take_photo (CheeseMainWindow* self);
CheeseCountdown* cheese_countdown_new (ClutterText* countdown_actor);
CheeseCountdown* cheese_countdown_construct (GType object_type, ClutterText* countdown_actor);
void cheese_countdown_start (CheeseCountdown* self, CheeseCountdownCountdownCallback completed_callback, void* completed_callback_target);
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self);
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self);
void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self, gboolean is_start);
static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self, GdkEventKey* event);
void cheese_countdown_stop (CheeseCountdown* self);
void cheese_main_window_toggle_video_recording (CheeseMainWindow* self, gboolean is_start);
static gboolean cheese_main_window_update_timeout_layer (CheeseMainWindow* self);
static gboolean _cheese_main_window_update_timeout_layer_gsource_func (gpointer self);
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self);
void cheese_main_window_shoot (CheeseMainWindow* self);
void cheese_main_window_set_effects (gboolean effects, CheeseMainWindow* self);
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active);
gboolean cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, ClutterActor* source, ClutterButtonEvent* event);
void cheese_main_window_on_prev_effects_page (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number);
void cheese_main_window_on_next_effects_page (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self);
static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self);
CheeseEffectsManager* cheese_effects_manager_new (void);
CheeseEffectsManager* cheese_effects_manager_construct (GType object_type);
void cheese_effects_manager_load_effects (CheeseEffectsManager* self);
static gboolean _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
void cheese_main_window_toggle_camera_actions_sensitivities (CheeseMainWindow* self, gboolean active);
static void _g_free0_ (gpointer var);
void cheese_main_window_camera_state_change_playing (CheeseMainWindow* self);
CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const gchar* name);
void cheese_main_window_set_startup_wide_mode (CheeseMainWindow* self);
void cheese_main_window_set_startup_fullscreen_mode (CheeseMainWindow* self);
void cheese_main_window_setup_ui (CheeseMainWindow* self);
static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self);
static gboolean _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
ClutterTexture* cheese_main_window_get_video_preview (CheeseMainWindow* self);
void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self);
void cheese_main_window_set_current_mode (CheeseMainWindow* self, CheeseMediaMode mode);
void cheese_main_window_set_camera (CheeseMainWindow* self, CheeseCamera* camera);
static void cheese_main_window_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
   * Responses from the delete files confirmation dialog.
   *
   * @param SKIP skip a single file
   * @param SKIP_ALL skill all following files
   */
static GType cheese_main_window_delete_response_get_type (void) {
	static volatile gsize cheese_main_window_delete_response_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_delete_response_type_id__volatile)) {
		static const GEnumValue values[] = {{CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP, "CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP", "skip"}, {CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL, "CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL", "skip-all"}, {0, NULL, NULL}};
		GType cheese_main_window_delete_response_type_id;
		cheese_main_window_delete_response_type_id = g_enum_register_static ("CheeseMainWindowDeleteResponse", values);
		g_once_init_leave (&cheese_main_window_delete_response_type_id__volatile, cheese_main_window_delete_response_type_id);
	}
	return cheese_main_window_delete_response_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


CheeseMainWindow* cheese_main_window_construct (GType object_type, GtkApplication* application) {
	CheeseMainWindow * self = NULL;
	GtkApplication* _tmp0_ = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	_tmp0_ = application;
	self = (CheeseMainWindow*) g_object_new (object_type, "application", _tmp0_, NULL);
	return self;
}


CheeseMainWindow* cheese_main_window_new (GtkApplication* application) {
	return cheese_main_window_construct (CHEESE_TYPE_MAIN_WINDOW, application);
}


/**
   * Popup a context menu when right-clicking on a thumbnail.
   *
   * @param iconview the thumbnail view that emitted the signal
   * @param event the event
   * @return false, to allow further processing of the event
   */
static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


gboolean cheese_main_window_on_thumbnail_mouse_button_press (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	CheeseThumbView* _tmp0_ = NULL;
	GdkEventButton _tmp1_ = {0};
	gdouble _tmp2_ = 0.0;
	GdkEventButton _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	GtkTreePath* _tmp5_ = NULL;
	GtkTreePath* _tmp6_ = NULL;
	GtkTreePath* _tmp7_ = NULL;
	CheeseThumbView* _tmp8_ = NULL;
	GtkTreePath* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GdkEventButton _tmp16_ = {0};
	GdkEventType _tmp17_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iconview != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.x;
	_tmp3_ = *event;
	_tmp4_ = _tmp3_.y;
	_tmp5_ = gtk_icon_view_get_path_at_pos ((GtkIconView*) _tmp0_, (gint) _tmp2_, (gint) _tmp4_);
	_tmp6_ = _gtk_tree_path_copy0 (_tmp5_);
	_gtk_tree_path_free0 (path);
	path = _tmp6_;
	_tmp7_ = path;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_gtk_tree_path_free0 (path);
		return result;
	}
	_tmp8_ = self->priv->thumb_view;
	_tmp9_ = path;
	_tmp10_ = gtk_icon_view_path_is_selected ((GtkIconView*) _tmp8_, _tmp9_);
	if (!_tmp10_) {
		CheeseThumbView* _tmp11_ = NULL;
		CheeseThumbView* _tmp12_ = NULL;
		GtkTreePath* _tmp13_ = NULL;
		CheeseThumbView* _tmp14_ = NULL;
		GtkTreePath* _tmp15_ = NULL;
		_tmp11_ = self->priv->thumb_view;
		g_signal_emit_by_name ((GtkIconView*) _tmp11_, "unselect-all");
		_tmp12_ = self->priv->thumb_view;
		_tmp13_ = path;
		gtk_icon_view_select_path ((GtkIconView*) _tmp12_, _tmp13_);
		_tmp14_ = self->priv->thumb_view;
		_tmp15_ = path;
		gtk_icon_view_set_cursor ((GtkIconView*) _tmp14_, _tmp15_, NULL, FALSE);
	}
	_tmp16_ = *event;
	_tmp17_ = _tmp16_.type;
	if (_tmp17_ == GDK_BUTTON_PRESS) {
		GdkEventButton _tmp18_ = {0};
		guint _tmp19_ = 0U;
		_tmp18_ = *event;
		_tmp19_ = _tmp18_.button;
		if (_tmp19_ == ((guint) 3)) {
			GtkMenu* _tmp20_ = NULL;
			CheeseThumbView* _tmp21_ = NULL;
			GdkEventButton _tmp22_ = {0};
			guint _tmp23_ = 0U;
			GdkEventButton _tmp24_ = {0};
			guint32 _tmp25_ = 0U;
			_tmp20_ = self->priv->thumbnail_popup;
			_tmp21_ = self->priv->thumb_view;
			_tmp22_ = *event;
			_tmp23_ = _tmp22_.button;
			_tmp24_ = *event;
			_tmp25_ = _tmp24_.time;
			gtk_menu_popup (_tmp20_, NULL, (GtkWidget*) _tmp21_, NULL, NULL, _tmp23_, _tmp25_);
		}
	} else {
		GdkEventButton _tmp26_ = {0};
		GdkEventType _tmp27_ = 0;
		_tmp26_ = *event;
		_tmp27_ = _tmp26_.type;
		if (_tmp27_ == GDK_2BUTTON_PRESS) {
			cheese_main_window_on_file_open (NULL, self);
		}
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	return result;
}


/**
   * Open an image associated with a thumbnail in the default application.
   *
   * @param action the action that emitted the signal, or null
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void cheese_main_window_on_file_open (GtkAction* action, CheeseMainWindow* self) {
	gchar* filename = NULL;
	gchar* uri = NULL;
	GdkScreen* screen = NULL;
	CheeseThumbView* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		return;
	}
	{
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GdkScreen* _tmp6_ = NULL;
		GdkScreen* _tmp7_ = NULL;
		GdkScreen* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		guint32 _tmp10_ = 0U;
		_tmp4_ = filename;
		_tmp5_ = g_filename_to_uri (_tmp4_, NULL, &_inner_error_);
		_tmp3_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_g_free0 (uri);
		uri = _tmp3_;
		_tmp6_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (screen);
		screen = _tmp7_;
		_tmp8_ = screen;
		_tmp9_ = uri;
		_tmp10_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp8_, _tmp9_, _tmp10_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GtkMessageDialog* error_dialog = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GtkMessageDialog* _tmp13_ = NULL;
		GtkMessageDialog* _tmp14_ = NULL;
		GtkMessageDialog* _tmp15_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = _ ("Could not open %s");
		_tmp12_ = filename;
		_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp11_, _tmp12_);
		g_object_ref_sink (_tmp13_);
		error_dialog = _tmp13_;
		_tmp14_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp14_);
		_tmp15_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp15_);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (err);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (screen);
	_g_free0 (uri);
	_g_free0 (filename);
}


/**
   * Delete the requested image or images in the thumbview from storage.
   *
   * A confirmation dialog is shown to the user before deleting any files.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_file_delete (GtkAction* action, CheeseMainWindow* self) {
	gint response = 0;
	gint error_response = 0;
	gboolean skip_all_errors = FALSE;
	GList* files = NULL;
	CheeseThumbView* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint files_length = 0U;
	GList* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GtkMessageDialog* confirmation_dialog = NULL;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	GtkMessageDialog* _tmp7_ = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	GtkMessageDialog* _tmp9_ = NULL;
	GtkMessageDialog* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	const gchar* _tmp12_ = NULL;
	GtkMessageDialog* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GtkMessageDialog* _tmp36_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	skip_all_errors = FALSE;
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	_tmp2_ = files;
	_tmp3_ = g_list_length (_tmp2_);
	files_length = _tmp3_;
	_tmp4_ = files_length;
	_tmp5_ = ngettext ("Are you sure you want to permanently delete the file?", "Are you sure you want to permanently delete %d files?", (gulong) _tmp4_);
	_tmp6_ = files_length;
	_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, _tmp5_, _tmp6_);
	g_object_ref_sink (_tmp7_);
	confirmation_dialog = _tmp7_;
	_tmp8_ = confirmation_dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp8_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp9_ = confirmation_dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp9_, GTK_STOCK_DELETE, (gint) GTK_RESPONSE_ACCEPT);
	_tmp10_ = confirmation_dialog;
	_tmp11_ = files_length;
	_tmp12_ = ngettext ("If you delete an item, it will be permanently lost", "If you delete the items, they will be permanently lost", (gulong) _tmp11_);
	gtk_message_dialog_format_secondary_text (_tmp10_, "%s", _tmp12_);
	_tmp13_ = confirmation_dialog;
	_tmp14_ = gtk_dialog_run ((GtkDialog*) _tmp13_);
	response = _tmp14_;
	_tmp15_ = response;
	if (_tmp15_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		GList* _tmp16_ = NULL;
		_tmp16_ = files;
		{
			GList* file_collection = NULL;
			GList* file_it = NULL;
			file_collection = _tmp16_;
			for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
				GFile* _tmp17_ = NULL;
				GFile* file = NULL;
				_tmp17_ = _g_object_ref0 ((GFile*) file_it->data);
				file = _tmp17_;
				{
					GFile* _tmp18_ = NULL;
					_tmp18_ = file;
					if (_tmp18_ == NULL) {
						_g_object_unref0 (file);
						_g_object_unref0 (confirmation_dialog);
						__g_list_free__g_object_unref0_0 (files);
						return;
					}
					{
						GFile* _tmp19_ = NULL;
						_tmp19_ = file;
						g_file_delete (_tmp19_, NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch3_g_error;
						}
					}
					goto __finally3;
					__catch3_g_error:
					{
						GError* err = NULL;
						GError* _tmp20_ = NULL;
						const gchar* _tmp21_ = NULL;
						gboolean _tmp22_ = FALSE;
						err = _inner_error_;
						_inner_error_ = NULL;
						_tmp20_ = err;
						_tmp21_ = _tmp20_->message;
						g_warning ("cheese-window.vala:235: Unable to delete file: %s", _tmp21_);
						_tmp22_ = skip_all_errors;
						if (!_tmp22_) {
							GtkMessageDialog* error_dialog = NULL;
							GFile* _tmp23_ = NULL;
							gchar* _tmp24_ = NULL;
							gchar* _tmp25_ = NULL;
							GtkMessageDialog* _tmp26_ = NULL;
							GtkMessageDialog* _tmp27_ = NULL;
							GtkMessageDialog* _tmp28_ = NULL;
							GtkMessageDialog* _tmp29_ = NULL;
							GtkMessageDialog* _tmp30_ = NULL;
							GtkMessageDialog* _tmp31_ = NULL;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							GtkMessageDialog* _tmp35_ = NULL;
							_tmp23_ = file;
							_tmp24_ = g_file_get_path (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp26_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "Could not delete %s", _tmp25_);
							g_object_ref_sink (_tmp26_);
							_tmp27_ = _tmp26_;
							_g_free0 (_tmp25_);
							error_dialog = _tmp27_;
							_tmp28_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp28_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
							_tmp29_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp29_, "Skip", (gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP);
							_tmp30_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp30_, "Skip all", (gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL);
							_tmp31_ = error_dialog;
							_tmp32_ = gtk_dialog_run ((GtkDialog*) _tmp31_);
							error_response = _tmp32_;
							_tmp33_ = error_response;
							if (_tmp33_ == ((gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL)) {
								skip_all_errors = TRUE;
							} else {
								gint _tmp34_ = 0;
								_tmp34_ = error_response;
								if (_tmp34_ == ((gint) GTK_RESPONSE_CANCEL)) {
									_g_object_unref0 (error_dialog);
									_g_error_free0 (err);
									_g_object_unref0 (file);
									break;
								}
							}
							_tmp35_ = error_dialog;
							gtk_widget_destroy ((GtkWidget*) _tmp35_);
							_g_object_unref0 (error_dialog);
						}
						_g_error_free0 (err);
					}
					__finally3:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (file);
						_g_object_unref0 (confirmation_dialog);
						__g_list_free__g_object_unref0_0 (files);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (file);
				}
			}
		}
	}
	_tmp36_ = confirmation_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp36_);
	_g_object_unref0 (confirmation_dialog);
	__g_list_free__g_object_unref0_0 (files);
}


/**
   * Move the requested image in the thumbview to the trash.
   *
   * A confirmation dialog is shown to the user before moving the file.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_file_move_to_trash (GtkAction* action, CheeseMainWindow* self) {
	GFile* file = NULL;
	GList* files = NULL;
	CheeseThumbView* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp5_ = 0;
				GList* _tmp6_ = NULL;
				guint _tmp7_ = 0U;
				GList* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				GList* _tmp10_ = NULL;
				gconstpointer _tmp11_ = NULL;
				GFile* _tmp12_ = NULL;
				GFile* _tmp13_ = NULL;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = files;
				_tmp7_ = g_list_length (_tmp6_);
				if (!(((guint) _tmp5_) < _tmp7_)) {
					break;
				}
				_tmp8_ = files;
				_tmp9_ = i;
				_tmp10_ = g_list_nth (_tmp8_, (guint) _tmp9_);
				_tmp11_ = _tmp10_->data;
				_tmp12_ = _g_object_ref0 ((GFile*) _tmp11_);
				_g_object_unref0 (file);
				file = _tmp12_;
				_tmp13_ = file;
				if (_tmp13_ == NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					return;
				}
				{
					GFile* _tmp14_ = NULL;
					_tmp14_ = file;
					g_file_trash (_tmp14_, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch4_g_error;
					}
				}
				goto __finally4;
				__catch4_g_error:
				{
					GError* err = NULL;
					GtkMessageDialog* error_dialog = NULL;
					const gchar* _tmp15_ = NULL;
					GFile* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					GtkMessageDialog* _tmp19_ = NULL;
					GtkMessageDialog* _tmp20_ = NULL;
					GtkMessageDialog* _tmp21_ = NULL;
					GtkMessageDialog* _tmp22_ = NULL;
					err = _inner_error_;
					_inner_error_ = NULL;
					_tmp15_ = _ ("Could not move %s to trash");
					_tmp16_ = file;
					_tmp17_ = g_file_get_path (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp15_, _tmp18_);
					g_object_ref_sink (_tmp19_);
					_tmp20_ = _tmp19_;
					_g_free0 (_tmp18_);
					error_dialog = _tmp20_;
					_tmp21_ = error_dialog;
					gtk_dialog_run ((GtkDialog*) _tmp21_);
					_tmp22_ = error_dialog;
					gtk_widget_destroy ((GtkWidget*) _tmp22_);
					_g_object_unref0 (error_dialog);
					_g_error_free0 (err);
				}
				__finally4:
				if (_inner_error_ != NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	__g_list_free__g_object_unref0_0 (files);
	_g_object_unref0 (file);
}


/**
   * Move all images in the thumbview to the trash.
   *
   * No confirmation dialog is shown to the user before moving the files!
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_file_move_to_trash_all (GtkAction* action, CheeseMainWindow* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GFile* directory = NULL;
		CheeseFileUtil* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp3_ = NULL;
		GFileEnumerator* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GFileEnumerator* _tmp8_ = NULL;
		CheeseFileUtil* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GFile* _tmp11_ = NULL;
		GFileEnumerator* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		GFileEnumerator* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		GFileEnumerator* _tmp18_ = NULL;
		_tmp0_ = self->priv->fileutil;
		_tmp1_ = cheese_fileutil_get_photo_path (_tmp0_);
		_tmp2_ = g_file_new_for_path (_tmp1_);
		directory = _tmp2_;
		_tmp3_ = directory;
		_tmp4_ = g_file_enumerate_children (_tmp3_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		enumerator = _tmp4_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (directory);
			goto __catch5_g_error;
		}
		_tmp5_ = directory;
		_tmp6_ = g_file_get_path (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = enumerator;
		cheese_main_window_trash_enumerated_files (self, _tmp7_, _tmp8_);
		_g_free0 (_tmp7_);
		_tmp9_ = self->priv->fileutil;
		_tmp10_ = cheese_fileutil_get_video_path (_tmp9_);
		_tmp11_ = g_file_new_for_path (_tmp10_);
		_g_object_unref0 (directory);
		directory = _tmp11_;
		_tmp13_ = directory;
		_tmp14_ = g_file_enumerate_children (_tmp13_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		_tmp12_ = _tmp14_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (enumerator);
			_g_object_unref0 (directory);
			goto __catch5_g_error;
		}
		_g_object_unref0 (enumerator);
		enumerator = _tmp12_;
		_tmp15_ = directory;
		_tmp16_ = g_file_get_path (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = enumerator;
		cheese_main_window_trash_enumerated_files (self, _tmp17_, _tmp18_);
		_g_free0 (_tmp17_);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (directory);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = _error_;
		_tmp20_ = _tmp19_->message;
		g_warning ("cheese-window.vala:326: Error while building file trash list: %s", _tmp20_);
		_g_error_free0 (_error_);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
   * Send the enumerated files to the trash.
   *
   * @param directory the directory containing the enumerated files
   * @param enumerator the enumeration of files to send to the trash
   */
static void cheese_main_window_trash_enumerated_files (CheeseMainWindow* self, const gchar* directory, GFileEnumerator* enumerator) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (enumerator != NULL);
	{
		GFileInfo* file_info = NULL;
		while (TRUE) {
			GFileInfo* _tmp0_ = NULL;
			GFileEnumerator* _tmp1_ = NULL;
			GFileInfo* _tmp2_ = NULL;
			GFileInfo* _tmp3_ = NULL;
			GFile* file_to_trash = NULL;
			const gchar* _tmp4_ = NULL;
			GFileInfo* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			GFile* _tmp9_ = NULL;
			GFile* _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
			_tmp1_ = enumerator;
			_tmp2_ = g_file_enumerator_next_file (_tmp1_, NULL, &_inner_error_);
			_tmp0_ = _tmp2_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file_info);
				goto __catch6_g_error;
			}
			_g_object_unref0 (file_info);
			file_info = _tmp0_;
			_tmp3_ = file_info;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = directory;
			_tmp5_ = file_info;
			_tmp6_ = g_file_info_get_name (_tmp5_);
			_tmp7_ = g_build_filename (_tmp4_, _tmp6_, NULL);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_file_new_for_path (_tmp8_);
			_tmp10_ = _tmp9_;
			_g_free0 (_tmp8_);
			file_to_trash = _tmp10_;
			_tmp11_ = file_to_trash;
			g_file_trash (_tmp11_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file_to_trash);
				_g_object_unref0 (file_info);
				goto __catch6_g_error;
			}
			_g_object_unref0 (file_to_trash);
		}
		_g_object_unref0 (file_info);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		g_warning ("cheese-window.vala:347: Error while trashing files: %s", _tmp13_);
		_g_error_free0 (_error_);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
   * Save the selected file in the thumbview to an alternate storage location.
   *
   * A file chooser dialog is shown to the user, asking where the file should
   * be saved and the filename.
   *
   * @param action the action that emitted the signal.
   */
void cheese_main_window_on_file_save_as (GtkAction* action, CheeseMainWindow* self) {
	gchar* filename = NULL;
	gchar* basename = NULL;
	GtkFileChooserDialog* save_as_dialog = NULL;
	gint response = 0;
	CheeseThumbView* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkFileChooserDialog* _tmp4_ = NULL;
	GtkFileChooserDialog* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GtkFileChooserDialog* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkFileChooserDialog* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GtkFileChooserDialog* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GtkFileChooserDialog* _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (save_as_dialog);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	_tmp3_ = _ ("Save File");
	_tmp4_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp3_, (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (save_as_dialog);
	save_as_dialog = _tmp4_;
	_tmp5_ = save_as_dialog;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp5_, TRUE);
	_tmp6_ = filename;
	_tmp7_ = g_filename_display_basename (_tmp6_);
	_g_free0 (basename);
	basename = _tmp7_;
	_tmp8_ = save_as_dialog;
	_tmp9_ = basename;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp8_, _tmp9_);
	_tmp10_ = save_as_dialog;
	_tmp11_ = g_get_home_dir ();
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp10_, _tmp11_);
	_tmp12_ = save_as_dialog;
	_tmp13_ = gtk_dialog_run ((GtkDialog*) _tmp12_);
	response = _tmp13_;
	_tmp14_ = save_as_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp14_);
	_tmp15_ = response;
	if (_tmp15_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* target_filename = NULL;
		GtkFileChooserDialog* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		GFile* src = NULL;
		const gchar* _tmp18_ = NULL;
		GFile* _tmp19_ = NULL;
		GFile* dest = NULL;
		const gchar* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		_tmp16_ = save_as_dialog;
		_tmp17_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp16_);
		_g_free0 (target_filename);
		target_filename = _tmp17_;
		_tmp18_ = filename;
		_tmp19_ = g_file_new_for_path (_tmp18_);
		src = _tmp19_;
		_tmp20_ = target_filename;
		_tmp21_ = g_file_new_for_path (_tmp20_);
		dest = _tmp21_;
		{
			GFile* _tmp22_ = NULL;
			GFile* _tmp23_ = NULL;
			_tmp22_ = src;
			_tmp23_ = dest;
			g_file_copy (_tmp22_, _tmp23_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch7_g_error;
			}
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* err = NULL;
			GtkMessageDialog* error_dialog = NULL;
			const gchar* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			GtkMessageDialog* _tmp26_ = NULL;
			GtkMessageDialog* _tmp27_ = NULL;
			GtkMessageDialog* _tmp28_ = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = _ ("Could not save %s");
			_tmp25_ = target_filename;
			_tmp26_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp24_, _tmp25_);
			g_object_ref_sink (_tmp26_);
			error_dialog = _tmp26_;
			_tmp27_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp27_);
			_tmp28_ = error_dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp28_);
			_g_object_unref0 (error_dialog);
			_g_error_free0 (err);
		}
		__finally7:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dest);
			_g_object_unref0 (src);
			_g_free0 (target_filename);
			_g_object_unref0 (save_as_dialog);
			_g_free0 (basename);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (dest);
		_g_object_unref0 (src);
		_g_free0 (target_filename);
	}
	_tmp29_ = save_as_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp29_);
	_g_object_unref0 (save_as_dialog);
	_g_free0 (basename);
	_g_free0 (filename);
}


/**
   * Toggle wide mode and save the preference to GSettings.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_layout_wide_mode (GtkToggleAction* action, CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	GtkToggleAction* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->is_command_line_startup;
	if (!_tmp0_) {
		GSettings* _tmp1_ = NULL;
		GtkToggleAction* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp1_ = self->priv->settings;
		_tmp2_ = action;
		_tmp3_ = gtk_toggle_action_get_active (_tmp2_);
		_tmp4_ = _tmp3_;
		g_settings_set_boolean (_tmp1_, "wide-mode", _tmp4_);
	}
	_tmp5_ = action;
	_tmp6_ = gtk_toggle_action_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	cheese_main_window_set_wide_mode (self, _tmp7_);
}


/**
     * Toggle fullscreen mode and save the preference to GSettings.
     *
     * @param fullscreen whether the window should be fullscreean
     */
void cheese_main_window_set_fullscreen (gboolean fullscreen, CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_command_line_startup;
	if (!_tmp0_) {
		GSettings* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = self->priv->settings;
		_tmp2_ = fullscreen;
		g_settings_set_boolean (_tmp1_, "fullscreen", _tmp2_);
	}
	_tmp3_ = fullscreen;
	cheese_main_window_set_fullscreen_mode (self, _tmp3_);
}


/**
     * Make the media capture mode actions sensitive.
     */
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
}


/**
     * Make the media capture mode actions insensitive.
     */
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
}


/**
   * Set the capture resolution, based on the current capture mode.
   *
   * @param mode the current capture mode (photo, video or burst)
   */
static void cheese_main_window_set_resolution (CheeseMainWindow* self, CheeseMediaMode mode) {
	CheeseCamera* _tmp0_ = NULL;
	GList* formats = NULL;
	CheeseCamera* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	CheeseVideoFormat* format = NULL;
	gint width = 0;
	gint height = 0;
	CheeseMediaMode _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->camera;
	_tmp2_ = cheese_camera_get_video_formats (_tmp1_);
	formats = _tmp2_;
	_tmp3_ = formats;
	if (_tmp3_ == NULL) {
		return;
	}
	width = 0;
	height = 0;
	_tmp4_ = mode;
	switch (_tmp4_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		case CHEESE_MEDIA_MODE_BURST:
		{
			GSettings* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			GSettings* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			_tmp5_ = self->priv->settings;
			_tmp6_ = g_settings_get_int (_tmp5_, "photo-x-resolution");
			width = _tmp6_;
			_tmp7_ = self->priv->settings;
			_tmp8_ = g_settings_get_int (_tmp7_, "photo-y-resolution");
			height = _tmp8_;
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GSettings* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			GSettings* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			_tmp9_ = self->priv->settings;
			_tmp10_ = g_settings_get_int (_tmp9_, "video-x-resolution");
			width = _tmp10_;
			_tmp11_ = self->priv->settings;
			_tmp12_ = g_settings_get_int (_tmp11_, "video-y-resolution");
			height = _tmp12_;
			break;
		}
		default:
		break;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_ = FALSE;
				gint _tmp16_ = 0;
				GList* _tmp17_ = NULL;
				guint _tmp18_ = 0U;
				GList* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				GList* _tmp21_ = NULL;
				gconstpointer _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
				gint _tmp24_ = 0;
				CheeseVideoFormat* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gboolean _tmp30_ = FALSE;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_ = 0;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				_tmp17_ = formats;
				_tmp18_ = g_list_length (_tmp17_);
				if (!(((guint) _tmp16_) < _tmp18_)) {
					break;
				}
				_tmp19_ = formats;
				_tmp20_ = i;
				_tmp21_ = g_list_nth (_tmp19_, (guint) _tmp20_);
				_tmp22_ = _tmp21_->data;
				format = (CheeseVideoFormat*) _tmp22_;
				_tmp24_ = width;
				_tmp25_ = format;
				_tmp26_ = _tmp25_->width;
				if (_tmp24_ == _tmp26_) {
					gint _tmp27_ = 0;
					CheeseVideoFormat* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					_tmp27_ = height;
					_tmp28_ = format;
					_tmp29_ = _tmp28_->height;
					_tmp23_ = _tmp27_ == _tmp29_;
				} else {
					_tmp23_ = FALSE;
				}
				_tmp30_ = _tmp23_;
				if (_tmp30_) {
					CheeseCamera* _tmp31_ = NULL;
					CheeseVideoFormat* _tmp32_ = NULL;
					_tmp31_ = self->priv->camera;
					_tmp32_ = format;
					cheese_camera_set_video_format (_tmp31_, _tmp32_);
					break;
				}
			}
		}
	}
}


/**
   * Set the current media capture mode, and update the UI sensitivities.
   *
   * @param mode the new capture mode to set
   */
static void cheese_main_window_set_mode (CheeseMainWindow* self, CheeseMediaMode mode) {
	g_return_if_fail (self != NULL);
}


/**
   * Clear the fullscreen activity timeout.
   */
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self) {
	GSource* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fullscreen_timeout;
	if (_tmp0_ != NULL) {
		GSource* _tmp1_ = NULL;
		_tmp1_ = self->priv->fullscreen_timeout;
		g_source_destroy (_tmp1_);
		_g_source_unref0 (self->priv->fullscreen_timeout);
		self->priv->fullscreen_timeout = NULL;
	}
}


/**
   * Set the fullscreen timeout, for hiding the UI if there is no mouse
   * movement.
   */
static gboolean __lambda4_ (CheeseMainWindow* self) {
	gboolean result = FALSE;
	GtkGrid* _tmp0_ = NULL;
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	cheese_main_window_clear_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ (self);
	return result;
}


static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self) {
	GSource* _tmp0_ = NULL;
	GSource* _tmp1_ = NULL;
	GSource* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_timeout_source_new ((guint) FULLSCREEN_TIMEOUT_INTERVAL);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	self->priv->fullscreen_timeout = _tmp0_;
	_tmp1_ = self->priv->fullscreen_timeout;
	g_source_attach (_tmp1_, NULL);
	_tmp2_ = self->priv->fullscreen_timeout;
	g_source_set_callback (_tmp2_, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}


/**
   * Show the UI in fullscreen if there is any mouse activity.
   *
   * Start a new timeout at the end of every mouse pointer movement. All
   * timeouts will be cancelled, except one created during the last movement
   * event. Show() is called even if the button is not hidden.
   *
   * @param viewport the widget to check for mouse activity on
   * @param e the (unused) event
   */
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e) {
	gboolean result = FALSE;
	GtkGrid* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (viewport != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	cheese_main_window_clear_fullscreen_timeout (self);
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	cheese_main_window_set_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


/**
   * Enable or disable fullscreen mode to the requested state.
   *
   * @param fullscreen_mode whether to enable or disable fullscreen mode
   */
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_fullscreen_motion_notify_callback (self, _sender, event);
	return result;
}


static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen_mode) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = fullscreen_mode;
	self->priv->is_fullscreen = _tmp0_;
	_tmp1_ = fullscreen_mode;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		GtkGrid* _tmp5_ = NULL;
		GtkGrid* _tmp6_ = NULL;
		GtkButton** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		GtkClutterEmbed* _tmp12_ = NULL;
		_tmp2_ = self->priv->is_wide_mode;
		if (_tmp2_) {
			GtkAlignment* _tmp3_ = NULL;
			_tmp3_ = self->priv->thumbnails_right;
			gtk_widget_hide ((GtkWidget*) _tmp3_);
		} else {
			GtkAlignment* _tmp4_ = NULL;
			_tmp4_ = self->priv->thumbnails_bottom;
			gtk_widget_hide ((GtkWidget*) _tmp4_);
		}
		_tmp5_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp5_, FALSE);
		_tmp6_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_show_all ((GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->buttons;
		_tmp7__length1 = self->priv->buttons_length1;
		{
			GtkButton** b_collection = NULL;
			gint b_collection_length1 = 0;
			gint _b_collection_size_ = 0;
			gint b_it = 0;
			b_collection = _tmp7_;
			b_collection_length1 = _tmp7__length1;
			for (b_it = 0; b_it < _tmp7__length1; b_it = b_it + 1) {
				GtkButton* _tmp8_ = NULL;
				GtkButton* b = NULL;
				_tmp8_ = _g_object_ref0 (b_collection[b_it]);
				b = _tmp8_;
				{
					GtkButton* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					_tmp9_ = b;
					_tmp10_ = gtk_buildable_get_name ((GtkBuildable*) _tmp9_);
					if (g_strcmp0 (_tmp10_, "take_action_button") != 0) {
						GtkButton* _tmp11_ = NULL;
						_tmp11_ = b;
						gtk_button_set_relief (_tmp11_, GTK_RELIEF_NONE);
					}
					_g_object_unref0 (b);
				}
			}
		}
		gtk_window_fullscreen ((GtkWindow*) self);
		_tmp12_ = self->priv->viewport_widget;
		g_signal_connect_object ((GtkWidget*) _tmp12_, "motion-notify-event", (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self, 0);
		cheese_main_window_set_fullscreen_timeout (self);
	} else {
		gboolean _tmp13_ = FALSE;
		GtkGrid* _tmp16_ = NULL;
		GtkButton** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		GtkGrid* _tmp22_ = NULL;
		GtkClutterEmbed* _tmp23_ = NULL;
		guint _tmp24_ = 0U;
		_tmp13_ = self->priv->is_wide_mode;
		if (_tmp13_) {
			GtkAlignment* _tmp14_ = NULL;
			_tmp14_ = self->priv->thumbnails_right;
			gtk_widget_show_all ((GtkWidget*) _tmp14_);
		} else {
			GtkAlignment* _tmp15_ = NULL;
			_tmp15_ = self->priv->thumbnails_bottom;
			gtk_widget_show_all ((GtkWidget*) _tmp15_);
		}
		_tmp16_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_hide ((GtkWidget*) _tmp16_);
		_tmp17_ = self->priv->buttons;
		_tmp17__length1 = self->priv->buttons_length1;
		{
			GtkButton** b_collection = NULL;
			gint b_collection_length1 = 0;
			gint _b_collection_size_ = 0;
			gint b_it = 0;
			b_collection = _tmp17_;
			b_collection_length1 = _tmp17__length1;
			for (b_it = 0; b_it < _tmp17__length1; b_it = b_it + 1) {
				GtkButton* _tmp18_ = NULL;
				GtkButton* b = NULL;
				_tmp18_ = _g_object_ref0 (b_collection[b_it]);
				b = _tmp18_;
				{
					GtkButton* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					_tmp19_ = b;
					_tmp20_ = gtk_buildable_get_name ((GtkBuildable*) _tmp19_);
					if (g_strcmp0 (_tmp20_, "take_action_button") != 0) {
						GtkButton* _tmp21_ = NULL;
						_tmp21_ = b;
						gtk_button_set_relief (_tmp21_, GTK_RELIEF_NORMAL);
					}
					_g_object_unref0 (b);
				}
			}
		}
		cheese_main_window_clear_fullscreen_timeout (self);
		_tmp22_ = self->priv->buttons_area;
		gtk_widget_show ((GtkWidget*) _tmp22_);
		_tmp23_ = self->priv->viewport_widget;
		g_signal_parse_name ("motion-notify-event", GTK_TYPE_WIDGET, &_tmp24_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp23_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp24_, 0, NULL, (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self);
		gtk_window_unfullscreen ((GtkWindow*) self);
	}
}


/**
   * Enable or disable wide mode to the requested state.
   *
   * @param wide_mode whether to enable or disable wide mode
   */
static void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode) {
	gboolean _tmp0_ = FALSE;
	GtkAllocation alloc = {0};
	GtkClutterEmbed* _tmp1_ = NULL;
	GtkAllocation _tmp2_ = {0};
	GtkClutterEmbed* _tmp3_ = NULL;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	GtkRequisition req = {0};
	GtkRequisition _tmp31_ = {0};
	GtkRequisition _tmp32_ = {0};
	GtkRequisition _tmp33_ = {0};
	gint _tmp34_ = 0;
	GtkRequisition _tmp35_ = {0};
	gint _tmp36_ = 0;
	GtkClutterEmbed* _tmp37_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = wide_mode;
	self->priv->is_wide_mode = _tmp0_;
	_tmp1_ = self->priv->viewport_widget;
	gtk_widget_get_allocation ((GtkWidget*) _tmp1_, &_tmp2_);
	alloc = _tmp2_;
	_tmp3_ = self->priv->viewport_widget;
	_tmp4_ = alloc;
	_tmp5_ = _tmp4_.width;
	_tmp6_ = alloc;
	_tmp7_ = _tmp6_.height;
	gtk_widget_set_size_request ((GtkWidget*) _tmp3_, _tmp5_, _tmp7_);
	_tmp8_ = self->priv->is_wide_mode;
	if (_tmp8_) {
		CheeseThumbView* _tmp9_ = NULL;
		EogThumbNav* _tmp10_ = NULL;
		GtkAlignment* _tmp11_ = NULL;
		GtkWidget* _tmp12_ = NULL;
		GtkAlignment* _tmp15_ = NULL;
		EogThumbNav* _tmp16_ = NULL;
		GtkAlignment* _tmp17_ = NULL;
		GtkAlignment* _tmp18_ = NULL;
		GtkAlignment* _tmp19_ = NULL;
		_tmp9_ = self->priv->thumb_view;
		cheese_thumb_view_set_vertical (_tmp9_, TRUE);
		_tmp10_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp10_, TRUE);
		_tmp11_ = self->priv->thumbnails_bottom;
		_tmp12_ = gtk_bin_get_child ((GtkBin*) _tmp11_);
		if (_tmp12_ != NULL) {
			GtkAlignment* _tmp13_ = NULL;
			EogThumbNav* _tmp14_ = NULL;
			_tmp13_ = self->priv->thumbnails_bottom;
			_tmp14_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
		}
		_tmp15_ = self->priv->thumbnails_right;
		_tmp16_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
		_tmp17_ = self->priv->thumbnails_right;
		gtk_widget_show_all ((GtkWidget*) _tmp17_);
		_tmp18_ = self->priv->thumbnails_right;
		gtk_container_resize_children ((GtkContainer*) _tmp18_);
		_tmp19_ = self->priv->thumbnails_bottom;
		gtk_widget_hide ((GtkWidget*) _tmp19_);
	} else {
		CheeseThumbView* _tmp20_ = NULL;
		EogThumbNav* _tmp21_ = NULL;
		GtkAlignment* _tmp22_ = NULL;
		GtkWidget* _tmp23_ = NULL;
		GtkAlignment* _tmp26_ = NULL;
		EogThumbNav* _tmp27_ = NULL;
		GtkAlignment* _tmp28_ = NULL;
		GtkAlignment* _tmp29_ = NULL;
		GtkAlignment* _tmp30_ = NULL;
		_tmp20_ = self->priv->thumb_view;
		cheese_thumb_view_set_vertical (_tmp20_, FALSE);
		_tmp21_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp21_, FALSE);
		_tmp22_ = self->priv->thumbnails_right;
		_tmp23_ = gtk_bin_get_child ((GtkBin*) _tmp22_);
		if (_tmp23_ != NULL) {
			GtkAlignment* _tmp24_ = NULL;
			EogThumbNav* _tmp25_ = NULL;
			_tmp24_ = self->priv->thumbnails_right;
			_tmp25_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
		}
		_tmp26_ = self->priv->thumbnails_bottom;
		_tmp27_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
		_tmp28_ = self->priv->thumbnails_bottom;
		gtk_widget_show_all ((GtkWidget*) _tmp28_);
		_tmp29_ = self->priv->thumbnails_bottom;
		gtk_container_resize_children ((GtkContainer*) _tmp29_);
		_tmp30_ = self->priv->thumbnails_right;
		gtk_widget_hide ((GtkWidget*) _tmp30_);
	}
	gtk_widget_get_preferred_size ((GtkWidget*) self, &_tmp31_, &_tmp32_);
	req = _tmp31_;
	req = _tmp32_;
	_tmp33_ = req;
	_tmp34_ = _tmp33_.width;
	_tmp35_ = req;
	_tmp36_ = _tmp35_.height;
	gtk_window_resize ((GtkWindow*) self, _tmp34_, _tmp36_);
	_tmp37_ = self->priv->viewport_widget;
	gtk_widget_set_size_request ((GtkWidget*) _tmp37_, -1, -1);
}


/**
   * Make sure that the layout manager manages the entire stage.
   *
   * @param actor unused
   * @param box unused
   * @param flags unused
   */
void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags) {
	ClutterActor* _tmp0_ = NULL;
	ClutterStage* _tmp1_ = NULL;
	gfloat _tmp2_ = 0.0F;
	gfloat _tmp3_ = 0.0F;
	ClutterStage* _tmp4_ = NULL;
	gfloat _tmp5_ = 0.0F;
	gfloat _tmp6_ = 0.0F;
	ClutterActor* _tmp7_ = NULL;
	ClutterStage* _tmp8_ = NULL;
	gfloat _tmp9_ = 0.0F;
	gfloat _tmp10_ = 0.0F;
	ClutterStage* _tmp11_ = NULL;
	gfloat _tmp12_ = 0.0F;
	gfloat _tmp13_ = 0.0F;
	ClutterText* _tmp14_ = NULL;
	ClutterTexture* _tmp15_ = NULL;
	gfloat _tmp16_ = 0.0F;
	gfloat _tmp17_ = 0.0F;
	ClutterStage* _tmp18_ = NULL;
	gfloat _tmp19_ = 0.0F;
	gfloat _tmp20_ = 0.0F;
	ClutterStage* _tmp21_ = NULL;
	gfloat _tmp22_ = 0.0F;
	gfloat _tmp23_ = 0.0F;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	g_return_if_fail (box != NULL);
	_tmp0_ = self->priv->viewport_layout;
	_tmp1_ = self->priv->viewport;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->viewport;
	_tmp5_ = clutter_actor_get_height ((ClutterActor*) _tmp4_);
	_tmp6_ = _tmp5_;
	clutter_actor_set_size (_tmp0_, _tmp3_, _tmp6_);
	_tmp7_ = self->priv->background_layer;
	_tmp8_ = self->priv->viewport;
	_tmp9_ = clutter_actor_get_width ((ClutterActor*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->viewport;
	_tmp12_ = clutter_actor_get_height ((ClutterActor*) _tmp11_);
	_tmp13_ = _tmp12_;
	clutter_actor_set_size (_tmp7_, _tmp10_, _tmp13_);
	_tmp14_ = self->priv->timeout_layer;
	_tmp15_ = self->priv->video_preview;
	_tmp16_ = clutter_actor_get_width ((ClutterActor*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->viewport;
	_tmp19_ = clutter_actor_get_width ((ClutterActor*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->viewport;
	_tmp22_ = clutter_actor_get_height ((ClutterActor*) _tmp21_);
	_tmp23_ = _tmp22_;
	clutter_actor_set_position ((ClutterActor*) _tmp14_, (_tmp17_ / 3) + (_tmp20_ / 2), _tmp23_ - 20);
}


/**
   * Toggle whether the countdown is active.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_countdown_toggle (GtkToggleAction* action, CheeseMainWindow* self) {
	GSettings* _tmp0_ = NULL;
	GtkToggleAction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = action;
	_tmp2_ = gtk_toggle_action_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (_tmp0_, "countdown", _tmp3_);
}


/**
   * The method to call when the countdown is finished.
   */
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	CheeseMediaMode _tmp12_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->action_cancelled;
	if (_tmp0_ == FALSE) {
		gchar* file_name = NULL;
		CheeseFileUtil* _tmp1_ = NULL;
		CheeseMediaMode _tmp2_ = 0;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GSettings* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		GtkGrid* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		CheeseCamera* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp1_ = self->priv->fileutil;
		_tmp2_ = self->priv->current_mode;
		_tmp3_ = cheese_fileutil_get_new_media_filename (_tmp1_, _tmp2_);
		_tmp4_ = g_strdup (_tmp3_);
		file_name = _tmp4_;
		_tmp5_ = self->priv->settings;
		_tmp6_ = g_settings_get_boolean (_tmp5_, "flash");
		if (_tmp6_) {
			CheeseFlash* _tmp7_ = NULL;
			_tmp7_ = self->priv->flash;
			cheese_flash_fire (_tmp7_);
		}
		_tmp8_ = self->priv->main_vbox;
		_tmp9_ = _ ("Shutter sound");
		ca_gtk_play_for_widget ((GtkWidget*) _tmp8_, (guint32) 0, CA_PROP_EVENT_ID, "camera-shutter", CA_PROP_MEDIA_ROLE, "event", CA_PROP_EVENT_DESCRIPTION, _tmp9_, NULL, NULL);
		_tmp10_ = self->priv->camera;
		_tmp11_ = file_name;
		cheese_camera_take_photo (_tmp10_, _tmp11_);
		_g_free0 (file_name);
	}
	_tmp12_ = self->priv->current_mode;
	if (_tmp12_ == CHEESE_MEDIA_MODE_PHOTO) {
		cheese_main_window_enable_mode_change (self);
	}
}


/**
   * Start to take a photo, starting a countdown if it is enabled.
   */
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self) {
	cheese_main_window_finish_countdown_callback (self);
}


void cheese_main_window_take_photo (CheeseMainWindow* self) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "countdown");
	if (_tmp1_) {
		CheeseMediaMode _tmp2_ = 0;
		ClutterText* _tmp3_ = NULL;
		CheeseCountdown* _tmp4_ = NULL;
		CheeseCountdown* _tmp5_ = NULL;
		_tmp2_ = self->priv->current_mode;
		if (_tmp2_ == CHEESE_MEDIA_MODE_PHOTO) {
			cheese_main_window_disable_mode_change (self);
		}
		_tmp3_ = self->priv->countdown_layer;
		_tmp4_ = cheese_countdown_new (_tmp3_);
		_g_object_unref0 (self->priv->current_countdown);
		self->priv->current_countdown = _tmp4_;
		_tmp5_ = self->priv->current_countdown;
		cheese_countdown_start (_tmp5_, _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback, self);
	} else {
		cheese_main_window_finish_countdown_callback (self);
	}
}


/**
   * Take a photo during burst mode, and increment the burst count.
   *
   * @return true if there are more photos to be taken in the current burst,
   * false otherwise
   */
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->is_bursting;
	if (_tmp1_) {
		gint _tmp2_ = 0;
		GSettings* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp2_ = self->priv->burst_count;
		_tmp3_ = self->priv->settings;
		_tmp4_ = g_settings_get_int (_tmp3_, "burst-repeat");
		_tmp0_ = _tmp2_ < _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		gint _tmp6_ = 0;
		cheese_main_window_take_photo (self);
		_tmp6_ = self->priv->burst_count;
		self->priv->burst_count = _tmp6_ + 1;
		result = TRUE;
		return result;
	} else {
		cheese_main_window_toggle_photo_bursting (self, FALSE);
		result = FALSE;
		return result;
	}
}


/**
   * Cancel the current activity if the escape key is pressed.
   *
   * @param event the key event, to check which key was pressed
   * @return false, to allow further processing of the event
   */
static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gchar* key = NULL;
	GdkEventKey _tmp0_ = {0};
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GCompareFunc _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.keyval;
	_tmp2_ = gdk_keyval_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (key);
	key = _tmp3_;
	_tmp4_ = g_strcmp0;
	_tmp5_ = key;
	_tmp6_ = _tmp4_ (_tmp5_, "Escape");
	if (_tmp6_ == 0) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		CheeseCountdown* _tmp10_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp17_ = FALSE;
		_tmp10_ = self->priv->current_countdown;
		if (_tmp10_ != NULL) {
			CheeseCountdown* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			_tmp11_ = self->priv->current_countdown;
			_tmp12_ = _tmp11_->running;
			_tmp9_ = _tmp12_;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp13_ = _tmp9_;
		if (_tmp13_) {
			_tmp8_ = TRUE;
		} else {
			gboolean _tmp14_ = FALSE;
			_tmp14_ = self->priv->is_bursting;
			_tmp8_ = _tmp14_;
		}
		_tmp15_ = _tmp8_;
		if (_tmp15_) {
			_tmp7_ = TRUE;
		} else {
			gboolean _tmp16_ = FALSE;
			_tmp16_ = self->priv->is_recording;
			_tmp7_ = _tmp16_;
		}
		_tmp17_ = _tmp7_;
		if (_tmp17_) {
			CheeseMediaMode _tmp18_ = 0;
			self->priv->action_cancelled = TRUE;
			_tmp18_ = self->priv->current_mode;
			switch (_tmp18_) {
				case CHEESE_MEDIA_MODE_PHOTO:
				{
					CheeseCountdown* _tmp19_ = NULL;
					_tmp19_ = self->priv->current_countdown;
					cheese_countdown_stop (_tmp19_);
					cheese_main_window_finish_countdown_callback (self);
					break;
				}
				case CHEESE_MEDIA_MODE_BURST:
				{
					cheese_main_window_toggle_photo_bursting (self, FALSE);
					break;
				}
				case CHEESE_MEDIA_MODE_VIDEO:
				{
					cheese_main_window_toggle_video_recording (self, FALSE);
					break;
				}
				default:
				break;
			}
			self->priv->action_cancelled = FALSE;
		} else {
			gboolean _tmp20_ = FALSE;
			_tmp20_ = self->priv->is_effects_selector_active;
			if (_tmp20_) {
			}
		}
	}
	result = FALSE;
	_g_free0 (key);
	return result;
}


/**
   * Toggle whether video recording is active.
   *
   * @param is_start whether to start video recording
   */
static gboolean _cheese_main_window_update_timeout_layer_gsource_func (gpointer self) {
	gboolean result;
	result = cheese_main_window_update_timeout_layer (self);
	return result;
}


void cheese_main_window_toggle_video_recording (CheeseMainWindow* self, gboolean is_start) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_start;
	if (_tmp0_) {
		CheeseCamera* _tmp1_ = NULL;
		CheeseFileUtil* _tmp2_ = NULL;
		CheeseMediaMode _tmp3_ = 0;
		const gchar* _tmp4_ = NULL;
		GtkLabel* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GtkButton* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GtkImage* _tmp13_ = NULL;
		_tmp1_ = self->priv->camera;
		_tmp2_ = self->priv->fileutil;
		_tmp3_ = self->priv->current_mode;
		_tmp4_ = cheese_fileutil_get_new_media_filename (_tmp2_, _tmp3_);
		cheese_camera_start_video_recording (_tmp1_, _tmp4_);
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _cheese_main_window_update_timeout_layer_gsource_func, g_object_ref (self), g_object_unref);
		_tmp5_ = self->priv->take_action_button_label;
		_tmp6_ = _ ("Stop _Recording");
		_tmp7_ = g_strconcat ("<b>", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, "</b>", NULL);
		_tmp10_ = _tmp9_;
		gtk_label_set_label (_tmp5_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_tmp11_ = self->priv->take_action_button;
		_tmp12_ = _ ("Stop recording");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp11_, _tmp12_);
		_tmp13_ = self->priv->take_action_button_image;
		gtk_image_set_from_stock (_tmp13_, GTK_STOCK_MEDIA_STOP, GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = TRUE;
		cheese_main_window_disable_mode_change (self);
	} else {
		CheeseCamera* _tmp14_ = NULL;
		ClutterText* _tmp15_ = NULL;
		GtkLabel* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		GtkButton* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		GtkImage* _tmp24_ = NULL;
		_tmp14_ = self->priv->camera;
		cheese_camera_stop_video_recording (_tmp14_);
		_tmp15_ = self->priv->timeout_layer;
		clutter_text_set_text (_tmp15_, "00:00:00");
		_tmp16_ = self->priv->take_action_button_label;
		_tmp17_ = _ ("_Record a Video");
		_tmp18_ = g_strconcat ("<b>", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, "</b>", NULL);
		_tmp21_ = _tmp20_;
		gtk_label_set_label (_tmp16_, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_tmp22_ = self->priv->take_action_button;
		_tmp23_ = _ ("Record a video");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp22_, _tmp23_);
		_tmp24_ = self->priv->take_action_button_image;
		gtk_image_set_from_stock (_tmp24_, GTK_STOCK_MEDIA_RECORD, GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = FALSE;
		cheese_main_window_enable_mode_change (self);
	}
}


/**
   * Update the timeout layer displayed timer.
   *
   * @return false, if the source, Timeout.add_seconds (used
   * in the toogle_video_recording method), should be removed.
   */
static gboolean cheese_main_window_update_timeout_layer (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->is_recording;
	if (_tmp0_) {
		ClutterText* _tmp1_ = NULL;
		CheeseCamera* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp1_ = self->priv->timeout_layer;
		_tmp2_ = self->priv->camera;
		_tmp3_ = cheese_camera_get_recorded_time (_tmp2_);
		_tmp4_ = _tmp3_;
		clutter_text_set_text (_tmp1_, _tmp4_);
		_g_free0 (_tmp4_);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


/**
   * Toggle whether photo bursting is active.
   *
   * @param is_start whether to start capturing a photo burst
   */
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self) {
	gboolean result;
	result = cheese_main_window_burst_take_photo (self);
	return result;
}


void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self, gboolean is_start) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_start;
	if (_tmp0_) {
		GtkLabel* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GtkButton* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint burst_delay = 0;
		GSettings* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint countdown_duration = 0;
		GSettings* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gboolean _tmp13_ = FALSE;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gboolean _tmp18_ = FALSE;
		self->priv->is_bursting = TRUE;
		cheese_main_window_disable_mode_change (self);
		_tmp1_ = self->priv->take_action_button_label;
		_tmp2_ = _ ("Stop _Taking Pictures");
		_tmp3_ = g_strconcat ("<b>", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp4_, "</b>", NULL);
		_tmp6_ = _tmp5_;
		gtk_label_set_label (_tmp1_, _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_tmp7_ = self->priv->take_action_button;
		_tmp8_ = _ ("Stop taking pictures");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp7_, _tmp8_);
		cheese_main_window_burst_take_photo (self);
		_tmp9_ = self->priv->settings;
		_tmp10_ = g_settings_get_int (_tmp9_, "burst-delay");
		burst_delay = _tmp10_;
		_tmp11_ = self->priv->settings;
		_tmp12_ = g_settings_get_int (_tmp11_, "countdown-duration");
		countdown_duration = 500 + (_tmp12_ * 1000);
		_tmp14_ = burst_delay;
		_tmp15_ = countdown_duration;
		if ((_tmp14_ - _tmp15_) < 1000) {
			GSettings* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			_tmp16_ = self->priv->settings;
			_tmp17_ = g_settings_get_boolean (_tmp16_, "countdown");
			_tmp13_ = _tmp17_;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp18_ = _tmp13_;
		if (_tmp18_) {
			gint _tmp19_ = 0;
			guint _tmp20_ = 0U;
			_tmp19_ = countdown_duration;
			_tmp20_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp19_, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->burst_callback_id = _tmp20_;
		} else {
			gint _tmp21_ = 0;
			guint _tmp22_ = 0U;
			_tmp21_ = burst_delay;
			_tmp22_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp21_, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->burst_callback_id = _tmp22_;
		}
	} else {
		gboolean _tmp23_ = FALSE;
		CheeseCountdown* _tmp24_ = NULL;
		gboolean _tmp27_ = FALSE;
		GtkLabel* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		GtkButton* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		CheeseFileUtil* _tmp37_ = NULL;
		guint _tmp38_ = 0U;
		_tmp24_ = self->priv->current_countdown;
		if (_tmp24_ != NULL) {
			CheeseCountdown* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			_tmp25_ = self->priv->current_countdown;
			_tmp26_ = _tmp25_->running;
			_tmp23_ = _tmp26_;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp27_ = _tmp23_;
		if (_tmp27_) {
			CheeseCountdown* _tmp28_ = NULL;
			_tmp28_ = self->priv->current_countdown;
			cheese_countdown_stop (_tmp28_);
		}
		self->priv->is_bursting = FALSE;
		cheese_main_window_enable_mode_change (self);
		_tmp29_ = self->priv->take_action_button_label;
		_tmp30_ = _ ("Take Multiple Photos");
		_tmp31_ = g_strconcat ("<b>", _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_tmp32_, "</b>", NULL);
		_tmp34_ = _tmp33_;
		gtk_label_set_label (_tmp29_, _tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
		_tmp35_ = self->priv->take_action_button;
		_tmp36_ = _ ("Take multiple photos");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp35_, _tmp36_);
		self->priv->burst_count = 0;
		_tmp37_ = self->priv->fileutil;
		cheese_fileutil_reset_burst (_tmp37_);
		_tmp38_ = self->priv->burst_callback_id;
		g_source_remove (_tmp38_);
	}
}


/**
     * Take a photo or burst of photos, or record a video, based on the current
     * capture mode.
     */
void cheese_main_window_shoot (CheeseMainWindow* self) {
	CheeseMediaMode _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_mode;
	switch (_tmp0_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			cheese_main_window_take_photo (self);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = self->priv->is_recording;
			cheese_main_window_toggle_video_recording (self, !_tmp1_);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = self->priv->is_bursting;
			cheese_main_window_toggle_photo_bursting (self, !_tmp2_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


/**
     * Toggle the display of the effect selector.
     *
     * @param effects whether effects should be enabled
     */
void cheese_main_window_set_effects (gboolean effects, CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = effects;
	cheese_main_window_toggle_effects_selector (self, _tmp0_);
}


/**
   * Change the selected effect, as a new one was selected.
   *
   * @param source unused
   * @param event unused
   * @return false, to allow further event processing
   */
gboolean cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, ClutterActor* source, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	ClutterActor* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	CheeseEffect* _tmp2_ = NULL;
	CheeseCamera* _tmp3_ = NULL;
	CheeseEffect* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	CheeseEffect* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	cheese_main_window_toggle_effects_selector (self, FALSE);
	_tmp0_ = source;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "effect");
	_tmp2_ = _g_object_ref0 ((CheeseEffect*) _tmp1_);
	_g_object_unref0 (self->priv->selected_effect);
	self->priv->selected_effect = _tmp2_;
	_tmp3_ = self->priv->camera;
	_tmp4_ = self->priv->selected_effect;
	cheese_camera_set_effect (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->settings;
	_tmp6_ = self->priv->selected_effect;
	_tmp7_ = cheese_effect_get_name (_tmp6_);
	_tmp8_ = _tmp7_;
	g_settings_set_string (_tmp5_, "selected-effect", _tmp8_);
	result = FALSE;
	return result;
}


/**
   * Navigate back one page of effects.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_prev_effects_page (GtkAction* action, CheeseMainWindow* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->current_effects_page;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->current_effects_page;
		cheese_main_window_activate_effects_page (self, ((gint) _tmp1_) - 1);
	}
}


/**
   * Navigate forward one page of effects.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_next_effects_page (GtkAction* action, CheeseMainWindow* self) {
	guint _tmp0_ = 0U;
	CheeseEffectsManager* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->current_effects_page;
	_tmp1_ = self->priv->effects_manager;
	_tmp2_ = _tmp1_->effects;
	_tmp3_ = g_list_length (_tmp2_);
	if (_tmp0_ != (_tmp3_ / EFFECTS_PER_PAGE)) {
		guint _tmp4_ = 0U;
		_tmp4_ = self->priv->current_effects_page;
		cheese_main_window_activate_effects_page (self, ((gint) _tmp4_) + 1);
	}
}


/**
   * Switch to the supplied page of effects.
   *
   * @param number the effects page to switch to
   */
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	ClutterActor* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	GList* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gconstpointer _tmp12_ = NULL;
	ClutterActor* _tmp13_ = NULL;
	ClutterActor* _tmp14_ = NULL;
	ClutterActor* _tmp15_ = NULL;
	ClutterActor* _tmp16_ = NULL;
	ClutterActor* _tmp17_ = NULL;
	ClutterActor* _tmp18_ = NULL;
	ClutterActor* _tmp19_ = NULL;
	ClutterActor* _tmp20_ = NULL;
	ClutterActor* _tmp21_ = NULL;
	guint i = 0U;
	CheeseEffectsManager* _tmp22_ = NULL;
	GList* _tmp23_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_effects_selector_active;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = number;
	self->priv->current_effects_page = (guint) _tmp1_;
	_tmp2_ = self->priv->viewport_layout;
	_tmp3_ = clutter_actor_get_children (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->current_effects_grid;
	_tmp6_ = g_list_index (_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_ != (-1);
	_g_list_free0 (_tmp4_);
	if (_tmp7_) {
		ClutterActor* _tmp8_ = NULL;
		ClutterActor* _tmp9_ = NULL;
		_tmp8_ = self->priv->viewport_layout;
		_tmp9_ = self->priv->current_effects_grid;
		clutter_actor_remove_child (_tmp8_, _tmp9_);
	}
	_tmp10_ = self->priv->effects_grids;
	_tmp11_ = number;
	_tmp12_ = g_list_nth_data (_tmp10_, (guint) _tmp11_);
	_tmp13_ = _g_object_ref0 ((ClutterActor*) _tmp12_);
	_g_object_unref0 (self->priv->current_effects_grid);
	self->priv->current_effects_grid = _tmp13_;
	_tmp14_ = self->priv->current_effects_grid;
	clutter_actor_set_opacity (_tmp14_, (guint) 0);
	_tmp15_ = self->priv->viewport_layout;
	_tmp16_ = self->priv->current_effects_grid;
	clutter_actor_add_child (_tmp15_, _tmp16_);
	_tmp17_ = self->priv->current_effects_grid;
	clutter_actor_save_easing_state (_tmp17_);
	_tmp18_ = self->priv->current_effects_grid;
	clutter_actor_set_easing_mode (_tmp18_, CLUTTER_LINEAR);
	_tmp19_ = self->priv->current_effects_grid;
	clutter_actor_set_easing_duration (_tmp19_, (guint) 500);
	_tmp20_ = self->priv->current_effects_grid;
	clutter_actor_set_opacity (_tmp20_, (guint) 255);
	_tmp21_ = self->priv->current_effects_grid;
	clutter_actor_restore_easing_state (_tmp21_);
	i = (guint) 0;
	_tmp22_ = self->priv->effects_manager;
	_tmp23_ = _tmp22_->effects;
	{
		GList* effect_collection = NULL;
		GList* effect_it = NULL;
		effect_collection = _tmp23_;
		for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
			CheeseEffect* _tmp24_ = NULL;
			CheeseEffect* effect = NULL;
			_tmp24_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
			effect = _tmp24_;
			{
				guint page_nr = 0U;
				guint _tmp25_ = 0U;
				guint _tmp26_ = 0U;
				gint _tmp27_ = 0;
				guint _tmp40_ = 0U;
				_tmp25_ = i;
				page_nr = _tmp25_ / EFFECTS_PER_PAGE;
				_tmp26_ = page_nr;
				_tmp27_ = number;
				if (_tmp26_ == ((guint) _tmp27_)) {
					CheeseEffect* _tmp28_ = NULL;
					gboolean _tmp29_ = FALSE;
					CheeseEffect* _tmp36_ = NULL;
					_tmp28_ = effect;
					_tmp29_ = cheese_effect_is_preview_connected (_tmp28_);
					if (!_tmp29_) {
						ClutterTexture* texture = NULL;
						CheeseEffect* _tmp30_ = NULL;
						gconstpointer _tmp31_ = NULL;
						ClutterTexture* _tmp32_ = NULL;
						CheeseCamera* _tmp33_ = NULL;
						CheeseEffect* _tmp34_ = NULL;
						ClutterTexture* _tmp35_ = NULL;
						_tmp30_ = effect;
						_tmp31_ = g_object_get_data ((GObject*) _tmp30_, "texture");
						_tmp32_ = _g_object_ref0 ((ClutterTexture*) _tmp31_);
						texture = _tmp32_;
						_tmp33_ = self->priv->camera;
						_tmp34_ = effect;
						_tmp35_ = texture;
						cheese_camera_connect_effect_texture (_tmp33_, _tmp34_, _tmp35_);
						_g_object_unref0 (texture);
					}
					_tmp36_ = effect;
					cheese_effect_enable_preview (_tmp36_);
				} else {
					CheeseEffect* _tmp37_ = NULL;
					gboolean _tmp38_ = FALSE;
					_tmp37_ = effect;
					_tmp38_ = cheese_effect_is_preview_connected (_tmp37_);
					if (_tmp38_) {
						CheeseEffect* _tmp39_ = NULL;
						_tmp39_ = effect;
						cheese_effect_disable_preview (_tmp39_);
					}
				}
				_tmp40_ = i;
				i = _tmp40_ + 1;
				_g_object_unref0 (effect);
			}
		}
	}
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


/**
   * Control the sensitivity of the effects page navigation buttons.
   */
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkAction* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GtkAction* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->is_effects_selector_active;
	if (_tmp1_) {
		guint _tmp2_ = 0U;
		_tmp2_ = self->priv->current_effects_page;
		_tmp0_ = _tmp2_ != ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = self->priv->effects_page_prev_action;
	_tmp4_ = _tmp0_;
	gtk_action_set_sensitive (_tmp3_, _tmp4_);
	_tmp6_ = self->priv->is_effects_selector_active;
	if (_tmp6_) {
		guint _tmp7_ = 0U;
		CheeseEffectsManager* _tmp8_ = NULL;
		GList* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		_tmp7_ = self->priv->current_effects_page;
		_tmp8_ = self->priv->effects_manager;
		_tmp9_ = _tmp8_->effects;
		_tmp10_ = g_list_length (_tmp9_);
		_tmp5_ = _tmp7_ != (_tmp10_ / EFFECTS_PER_PAGE);
	} else {
		_tmp5_ = FALSE;
	}
	_tmp11_ = self->priv->effects_page_next_action;
	_tmp12_ = _tmp5_;
	gtk_action_set_sensitive (_tmp11_, _tmp12_);
}


/**
   * Toggle the visibility of the effects selector.
   *
   * @param active whether the selector should be active
   */
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CheeseCamera* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = active;
	self->priv->is_effects_selector_active = _tmp0_;
	_tmp1_ = active;
	if (_tmp1_) {
		ClutterTexture* _tmp2_ = NULL;
		GList* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		_tmp2_ = self->priv->video_preview;
		clutter_actor_hide ((ClutterActor*) _tmp2_);
		_tmp3_ = self->priv->effects_grids;
		_tmp4_ = g_list_length (_tmp3_);
		if (_tmp4_ == ((guint) 0)) {
			ClutterText* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			ClutterText* _tmp7_ = NULL;
			_tmp5_ = self->priv->error_layer;
			_tmp6_ = _ ("No effects found");
			clutter_text_set_text (_tmp5_, _tmp6_);
			_tmp7_ = self->priv->error_layer;
			clutter_actor_show ((ClutterActor*) _tmp7_);
		} else {
			ClutterActor* _tmp8_ = NULL;
			guint _tmp9_ = 0U;
			_tmp8_ = self->priv->current_effects_grid;
			clutter_actor_show (_tmp8_);
			_tmp9_ = self->priv->current_effects_page;
			cheese_main_window_activate_effects_page (self, (gint) _tmp9_);
		}
	} else {
		GList* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		ClutterTexture* _tmp14_ = NULL;
		_tmp10_ = self->priv->effects_grids;
		_tmp11_ = g_list_length (_tmp10_);
		if (_tmp11_ == ((guint) 0)) {
			ClutterText* _tmp12_ = NULL;
			_tmp12_ = self->priv->error_layer;
			clutter_actor_hide ((ClutterActor*) _tmp12_);
		} else {
			ClutterActor* _tmp13_ = NULL;
			_tmp13_ = self->priv->current_effects_grid;
			clutter_actor_hide (_tmp13_);
		}
		_tmp14_ = self->priv->video_preview;
		clutter_actor_show ((ClutterActor*) _tmp14_);
	}
	_tmp15_ = self->priv->camera;
	_tmp16_ = active;
	cheese_camera_toggle_effects_pipeline (_tmp15_, _tmp16_);
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


/**
   * Create the effects selector.
   */
static gboolean _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_selected_effect_change (self, _sender, event);
	return result;
}


static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self) {
	ClutterActor* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_effects_grid;
	if (_tmp0_ == NULL) {
		CheeseEffectsManager* _tmp1_ = NULL;
		CheeseEffectsManager* _tmp2_ = NULL;
		CheeseEffectsManager* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		CheeseEffectsManager* _tmp6_ = NULL;
		GList* _tmp7_ = NULL;
		guint i = 0U;
		CheeseEffectsManager* _tmp17_ = NULL;
		GList* _tmp18_ = NULL;
		GList* _tmp74_ = NULL;
		gconstpointer _tmp75_ = NULL;
		ClutterActor* _tmp76_ = NULL;
		_tmp1_ = cheese_effects_manager_new ();
		_g_object_unref0 (self->priv->effects_manager);
		self->priv->effects_manager = _tmp1_;
		_tmp2_ = self->priv->effects_manager;
		cheese_effects_manager_load_effects (_tmp2_);
		__g_list_free__g_object_unref0_0 (self->priv->effects_grids);
		self->priv->effects_grids = NULL;
		_tmp3_ = self->priv->effects_manager;
		_tmp4_ = _tmp3_->effects;
		_tmp5_ = g_list_length (_tmp4_);
		if (_tmp5_ == ((guint) 0)) {
			g_warning ("cheese-window.vala:1120: gnome-video-effects is not installed.");
			return;
		}
		_tmp6_ = self->priv->effects_manager;
		_tmp7_ = _tmp6_->effects;
		{
			GList* effect_collection = NULL;
			GList* effect_it = NULL;
			effect_collection = _tmp7_;
			for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
				CheeseEffect* _tmp8_ = NULL;
				CheeseEffect* effect = NULL;
				_tmp8_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
				effect = _tmp8_;
				{
					ClutterTableLayout* table_layout = NULL;
					ClutterTableLayout* _tmp9_ = NULL;
					ClutterActor* grid = NULL;
					ClutterActor* _tmp10_ = NULL;
					ClutterActor* _tmp11_ = NULL;
					ClutterTableLayout* _tmp12_ = NULL;
					ClutterActor* _tmp13_ = NULL;
					ClutterActor* _tmp14_ = NULL;
					ClutterTableLayout* _tmp15_ = NULL;
					ClutterTableLayout* _tmp16_ = NULL;
					_tmp9_ = (ClutterTableLayout*) clutter_table_layout_new ();
					g_object_ref_sink (_tmp9_);
					table_layout = _tmp9_;
					_tmp10_ = clutter_actor_new ();
					g_object_ref_sink (_tmp10_);
					grid = _tmp10_;
					_tmp11_ = grid;
					_tmp12_ = table_layout;
					clutter_actor_set_layout_manager (_tmp11_, (ClutterLayoutManager*) _tmp12_);
					_tmp13_ = grid;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					self->priv->effects_grids = g_list_append (self->priv->effects_grids, _tmp14_);
					_tmp15_ = table_layout;
					clutter_table_layout_set_column_spacing (_tmp15_, (guint) 10);
					_tmp16_ = table_layout;
					clutter_table_layout_set_row_spacing (_tmp16_, (guint) 10);
					_g_object_unref0 (grid);
					_g_object_unref0 (table_layout);
					_g_object_unref0 (effect);
				}
			}
		}
		i = (guint) 0;
		_tmp17_ = self->priv->effects_manager;
		_tmp18_ = _tmp17_->effects;
		{
			GList* effect_collection = NULL;
			GList* effect_it = NULL;
			effect_collection = _tmp18_;
			for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
				CheeseEffect* _tmp19_ = NULL;
				CheeseEffect* effect = NULL;
				_tmp19_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
				effect = _tmp19_;
				{
					ClutterTexture* texture = NULL;
					ClutterTexture* _tmp20_ = NULL;
					ClutterBinLayout* layout = NULL;
					ClutterBinLayout* _tmp21_ = NULL;
					ClutterActor* box = NULL;
					ClutterActor* _tmp22_ = NULL;
					ClutterActor* _tmp23_ = NULL;
					ClutterBinLayout* _tmp24_ = NULL;
					ClutterText* text = NULL;
					ClutterText* _tmp25_ = NULL;
					ClutterActor* rect = NULL;
					ClutterActor* _tmp26_ = NULL;
					ClutterActor* _tmp27_ = NULL;
					ClutterActor* _tmp28_ = NULL;
					ClutterColor _tmp29_ = {0};
					ClutterTexture* _tmp30_ = NULL;
					ClutterActor* _tmp31_ = NULL;
					ClutterTexture* _tmp32_ = NULL;
					ClutterActor* _tmp33_ = NULL;
					ClutterActor* _tmp34_ = NULL;
					CheeseEffect* _tmp35_ = NULL;
					CheeseEffect* _tmp36_ = NULL;
					CheeseEffect* _tmp37_ = NULL;
					ClutterTexture* _tmp38_ = NULL;
					ClutterTexture* _tmp39_ = NULL;
					ClutterActor* _tmp40_ = NULL;
					ClutterText* _tmp41_ = NULL;
					CheeseEffect* _tmp42_ = NULL;
					const gchar* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					ClutterText* _tmp45_ = NULL;
					ClutterColor _tmp46_ = {0};
					ClutterActor* _tmp47_ = NULL;
					ClutterText* _tmp48_ = NULL;
					gfloat _tmp49_ = 0.0F;
					gfloat _tmp50_ = 0.0F;
					ClutterActor* _tmp51_ = NULL;
					ClutterActor* _tmp52_ = NULL;
					ClutterActor* _tmp53_ = NULL;
					ClutterActor* _tmp54_ = NULL;
					ClutterActor* _tmp55_ = NULL;
					ClutterActor* _tmp56_ = NULL;
					ClutterText* _tmp57_ = NULL;
					ClutterText* _tmp58_ = NULL;
					ClutterText* _tmp59_ = NULL;
					ClutterText* _tmp60_ = NULL;
					ClutterActor* _tmp61_ = NULL;
					ClutterText* _tmp62_ = NULL;
					ClutterTableLayout* table_layout = NULL;
					GList* _tmp63_ = NULL;
					guint _tmp64_ = 0U;
					gconstpointer _tmp65_ = NULL;
					ClutterLayoutManager* _tmp66_ = NULL;
					ClutterLayoutManager* _tmp67_ = NULL;
					ClutterTableLayout* _tmp68_ = NULL;
					ClutterTableLayout* _tmp69_ = NULL;
					ClutterActor* _tmp70_ = NULL;
					guint _tmp71_ = 0U;
					guint _tmp72_ = 0U;
					guint _tmp73_ = 0U;
					_tmp20_ = (ClutterTexture*) clutter_texture_new ();
					g_object_ref_sink (_tmp20_);
					texture = _tmp20_;
					_tmp21_ = (ClutterBinLayout*) clutter_bin_layout_new (CLUTTER_BIN_ALIGNMENT_CENTER, CLUTTER_BIN_ALIGNMENT_CENTER);
					g_object_ref_sink (_tmp21_);
					layout = _tmp21_;
					_tmp22_ = clutter_actor_new ();
					g_object_ref_sink (_tmp22_);
					box = _tmp22_;
					_tmp23_ = box;
					_tmp24_ = layout;
					clutter_actor_set_layout_manager (_tmp23_, (ClutterLayoutManager*) _tmp24_);
					_tmp25_ = (ClutterText*) clutter_text_new ();
					g_object_ref_sink (_tmp25_);
					text = _tmp25_;
					_tmp26_ = clutter_actor_new ();
					g_object_ref_sink (_tmp26_);
					rect = _tmp26_;
					_tmp27_ = rect;
					clutter_actor_set_opacity (_tmp27_, (guint) 128);
					_tmp28_ = rect;
					clutter_color_from_string (&_tmp29_, "black");
					clutter_actor_set_background_color (_tmp28_, &_tmp29_);
					_tmp30_ = texture;
					clutter_texture_set_keep_aspect_ratio (_tmp30_, TRUE);
					_tmp31_ = box;
					_tmp32_ = texture;
					clutter_actor_add_child (_tmp31_, (ClutterActor*) _tmp32_);
					_tmp33_ = box;
					clutter_actor_set_reactive (_tmp33_, TRUE);
					_tmp34_ = box;
					_tmp35_ = effect;
					_tmp36_ = _g_object_ref0 (_tmp35_);
					g_object_set_data_full ((GObject*) _tmp34_, "effect", _tmp36_, g_object_unref);
					_tmp37_ = effect;
					_tmp38_ = texture;
					_tmp39_ = _g_object_ref0 (_tmp38_);
					g_object_set_data_full ((GObject*) _tmp37_, "texture", _tmp39_, g_object_unref);
					_tmp40_ = box;
					g_signal_connect_object (_tmp40_, "button-release-event", (GCallback) _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event, self, 0);
					_tmp41_ = text;
					_tmp42_ = effect;
					_tmp43_ = cheese_effect_get_name (_tmp42_);
					_tmp44_ = _tmp43_;
					clutter_text_set_text (_tmp41_, _tmp44_);
					_tmp45_ = text;
					clutter_color_from_string (&_tmp46_, "white");
					clutter_text_set_color (_tmp45_, &_tmp46_);
					_tmp47_ = rect;
					_tmp48_ = text;
					_tmp49_ = clutter_actor_get_height ((ClutterActor*) _tmp48_);
					_tmp50_ = _tmp49_;
					clutter_actor_set_height (_tmp47_, _tmp50_ + 5);
					_tmp51_ = rect;
					clutter_actor_set_x_align (_tmp51_, CLUTTER_ACTOR_ALIGN_FILL);
					_tmp52_ = rect;
					clutter_actor_set_y_align (_tmp52_, CLUTTER_ACTOR_ALIGN_END);
					_tmp53_ = rect;
					clutter_actor_set_x_expand (_tmp53_, TRUE);
					_tmp54_ = rect;
					clutter_actor_set_y_expand (_tmp54_, TRUE);
					_tmp55_ = box;
					_tmp56_ = rect;
					clutter_actor_add_child (_tmp55_, _tmp56_);
					_tmp57_ = text;
					clutter_actor_set_x_align ((ClutterActor*) _tmp57_, CLUTTER_ACTOR_ALIGN_CENTER);
					_tmp58_ = text;
					clutter_actor_set_y_align ((ClutterActor*) _tmp58_, CLUTTER_ACTOR_ALIGN_END);
					_tmp59_ = text;
					clutter_actor_set_x_expand ((ClutterActor*) _tmp59_, TRUE);
					_tmp60_ = text;
					clutter_actor_set_y_expand ((ClutterActor*) _tmp60_, TRUE);
					_tmp61_ = box;
					_tmp62_ = text;
					clutter_actor_add_child (_tmp61_, (ClutterActor*) _tmp62_);
					_tmp63_ = self->priv->effects_grids;
					_tmp64_ = i;
					_tmp65_ = g_list_nth_data (_tmp63_, _tmp64_ / EFFECTS_PER_PAGE);
					_tmp66_ = clutter_actor_get_layout_manager ((ClutterActor*) _tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, clutter_table_layout_get_type (), ClutterTableLayout));
					table_layout = _tmp68_;
					_tmp69_ = table_layout;
					_tmp70_ = box;
					_tmp71_ = i;
					_tmp72_ = i;
					clutter_table_layout_pack (_tmp69_, _tmp70_, ((gint) (_tmp71_ % EFFECTS_PER_PAGE)) % 3, ((gint) (_tmp72_ % EFFECTS_PER_PAGE)) / 3);
					_tmp73_ = i;
					i = _tmp73_ + 1;
					_g_object_unref0 (table_layout);
					_g_object_unref0 (rect);
					_g_object_unref0 (text);
					_g_object_unref0 (box);
					_g_object_unref0 (layout);
					_g_object_unref0 (texture);
					_g_object_unref0 (effect);
				}
			}
		}
		cheese_main_window_setup_effects_page_switch_sensitivity (self);
		_tmp74_ = self->priv->effects_grids;
		_tmp75_ = g_list_nth_data (_tmp74_, (guint) 0);
		_tmp76_ = _g_object_ref0 ((ClutterActor*) _tmp75_);
		_g_object_unref0 (self->priv->current_effects_grid);
		self->priv->current_effects_grid = _tmp76_;
	}
}


/**
   * Toggle the sensitvity of the camera actions.
   *
   * @param active whether the camera actions should be sensitive
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


void cheese_main_window_toggle_camera_actions_sensitivities (CheeseMainWindow* self, gboolean active) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = active;
	self->priv->is_camera_actions_sensitive = _tmp0_;
	_tmp1_ = active;
	if (_tmp1_) {
		GList* keys = NULL;
		GHashTable* _tmp2_ = NULL;
		GList* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
		_tmp2_ = self->priv->action_sensitivities;
		_tmp3_ = g_hash_table_get_keys (_tmp2_);
		keys = _tmp3_;
		_tmp4_ = keys;
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
			key_collection = _tmp4_;
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
				const gchar* key = NULL;
				key = (const gchar*) key_it->data;
				{
					GtkAction* action = NULL;
					GtkBuilder* _tmp5_ = NULL;
					const gchar* _tmp6_ = NULL;
					GObject* _tmp7_ = NULL;
					GtkAction* _tmp8_ = NULL;
					GtkAction* _tmp9_ = NULL;
					GHashTable* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					gconstpointer _tmp12_ = NULL;
					_tmp5_ = self->priv->gtk_builder;
					_tmp6_ = key;
					_tmp7_ = gtk_builder_get_object (_tmp5_, _tmp6_);
					_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_ACTION) ? ((GtkAction*) _tmp7_) : NULL);
					action = _tmp8_;
					_tmp9_ = action;
					_tmp10_ = self->priv->action_sensitivities;
					_tmp11_ = key;
					_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
					gtk_action_set_sensitive (_tmp9_, (gboolean) ((gintptr) _tmp12_));
					_g_object_unref0 (action);
				}
			}
		}
		_g_list_free0 (keys);
	} else {
		GHashFunc _tmp13_ = NULL;
		GEqualFunc _tmp14_ = NULL;
		GHashTable* _tmp15_ = NULL;
		GSList* objects = NULL;
		GtkBuilder* _tmp16_ = NULL;
		GSList* _tmp17_ = NULL;
		GSList* _tmp18_ = NULL;
		gchar** active_actions = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar** _tmp39_ = NULL;
		gint active_actions_length1 = 0;
		gint _active_actions_size_ = 0;
		gboolean flag = FALSE;
		GSList* _tmp40_ = NULL;
		_tmp13_ = g_str_hash;
		_tmp14_ = g_direct_equal;
		_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, _g_free0_, NULL);
		_g_hash_table_unref0 (self->priv->action_sensitivities);
		self->priv->action_sensitivities = _tmp15_;
		_tmp16_ = self->priv->gtk_builder;
		_tmp17_ = gtk_builder_get_objects (_tmp16_);
		objects = _tmp17_;
		_tmp18_ = objects;
		{
			GSList* obj_collection = NULL;
			GSList* obj_it = NULL;
			obj_collection = _tmp18_;
			for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
				GObject* _tmp19_ = NULL;
				GObject* obj = NULL;
				_tmp19_ = _g_object_ref0 ((GObject*) obj_it->data);
				obj = _tmp19_;
				{
					GObject* _tmp20_ = NULL;
					_tmp20_ = obj;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, GTK_TYPE_ACTION)) {
						GtkAction* action = NULL;
						GObject* _tmp21_ = NULL;
						GtkAction* _tmp22_ = NULL;
						GHashTable* _tmp23_ = NULL;
						GtkAction* _tmp24_ = NULL;
						const gchar* _tmp25_ = NULL;
						const gchar* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						GtkAction* _tmp28_ = NULL;
						gboolean _tmp29_ = FALSE;
						gboolean _tmp30_ = FALSE;
						_tmp21_ = obj;
						_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GTK_TYPE_ACTION, GtkAction));
						action = _tmp22_;
						_tmp23_ = self->priv->action_sensitivities;
						_tmp24_ = action;
						_tmp25_ = gtk_action_get_name (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = g_strdup (_tmp26_);
						_tmp28_ = action;
						_tmp29_ = gtk_action_get_sensitive (_tmp28_);
						_tmp30_ = _tmp29_;
						g_hash_table_insert (_tmp23_, _tmp27_, (gpointer) ((gintptr) _tmp30_));
						_g_object_unref0 (action);
					}
					_g_object_unref0 (obj);
				}
			}
		}
		_tmp31_ = g_strdup ("quit");
		_tmp32_ = g_strdup ("help_contents");
		_tmp33_ = g_strdup ("about");
		_tmp34_ = g_strdup ("open");
		_tmp35_ = g_strdup ("save_as");
		_tmp36_ = g_strdup ("move_to_trash");
		_tmp37_ = g_strdup ("delete");
		_tmp38_ = g_strdup ("move_all_to_trash");
		_tmp39_ = g_new0 (gchar*, 8 + 1);
		_tmp39_[0] = _tmp31_;
		_tmp39_[1] = _tmp32_;
		_tmp39_[2] = _tmp33_;
		_tmp39_[3] = _tmp34_;
		_tmp39_[4] = _tmp35_;
		_tmp39_[5] = _tmp36_;
		_tmp39_[6] = _tmp37_;
		_tmp39_[7] = _tmp38_;
		active_actions = _tmp39_;
		active_actions_length1 = 8;
		_active_actions_size_ = active_actions_length1;
		_tmp40_ = objects;
		{
			GSList* obj_collection = NULL;
			GSList* obj_it = NULL;
			obj_collection = _tmp40_;
			for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
				GObject* _tmp41_ = NULL;
				GObject* obj = NULL;
				_tmp41_ = _g_object_ref0 ((GObject*) obj_it->data);
				obj = _tmp41_;
				{
					GObject* _tmp42_ = NULL;
					flag = FALSE;
					_tmp42_ = obj;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, GTK_TYPE_ACTION)) {
						GtkAction* action = NULL;
						GObject* _tmp43_ = NULL;
						GtkAction* _tmp44_ = NULL;
						gchar** _tmp45_ = NULL;
						gint _tmp45__length1 = 0;
						gboolean _tmp51_ = FALSE;
						_tmp43_ = obj;
						_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GTK_TYPE_ACTION, GtkAction));
						action = _tmp44_;
						_tmp45_ = active_actions;
						_tmp45__length1 = active_actions_length1;
						{
							gchar** s_collection = NULL;
							gint s_collection_length1 = 0;
							gint _s_collection_size_ = 0;
							gint s_it = 0;
							s_collection = _tmp45_;
							s_collection_length1 = _tmp45__length1;
							for (s_it = 0; s_it < _tmp45__length1; s_it = s_it + 1) {
								gchar* _tmp46_ = NULL;
								gchar* s = NULL;
								_tmp46_ = g_strdup (s_collection[s_it]);
								s = _tmp46_;
								{
									GtkAction* _tmp47_ = NULL;
									const gchar* _tmp48_ = NULL;
									const gchar* _tmp49_ = NULL;
									const gchar* _tmp50_ = NULL;
									_tmp47_ = action;
									_tmp48_ = gtk_action_get_name (_tmp47_);
									_tmp49_ = _tmp48_;
									_tmp50_ = s;
									if (g_strcmp0 (_tmp49_, _tmp50_) == 0) {
										flag = TRUE;
									}
									_g_free0 (s);
								}
							}
						}
						_tmp51_ = flag;
						if (!_tmp51_) {
							GObject* _tmp52_ = NULL;
							_tmp52_ = obj;
							gtk_action_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GTK_TYPE_ACTION, GtkAction), FALSE);
						}
						_g_object_unref0 (action);
					}
					_g_object_unref0 (obj);
				}
			}
		}
		active_actions = (_vala_array_free (active_actions, active_actions_length1, (GDestroyNotify) g_free), NULL);
		_g_slist_free0 (objects);
	}
}


/**
     * Update the UI when the camera starts playing.
     */
void cheese_main_window_camera_state_change_playing (CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	CheeseEffect* effect = NULL;
	CheeseEffectsManager* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	CheeseEffect* _tmp5_ = NULL;
	CheeseEffect* _tmp6_ = NULL;
	CheeseEffect* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_camera_actions_sensitive;
	if (!_tmp0_) {
		cheese_main_window_toggle_camera_actions_sensitivities (self, TRUE);
	}
	_tmp1_ = self->priv->effects_manager;
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_string (_tmp2_, "selected-effect");
	_tmp4_ = _tmp3_;
	_tmp5_ = cheese_effects_manager_get_effect (_tmp1_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	effect = _tmp6_;
	_tmp7_ = effect;
	if (_tmp7_ != NULL) {
		CheeseCamera* _tmp8_ = NULL;
		CheeseEffect* _tmp9_ = NULL;
		_tmp8_ = self->priv->camera;
		_tmp9_ = effect;
		cheese_camera_set_effect (_tmp8_, _tmp9_);
	}
	_g_object_unref0 (effect);
}


/**
   * Set wide mode active when started from the command line (and do not change
   * the GSetting).
   */
void cheese_main_window_set_startup_wide_mode (CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	GtkToggleAction* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_wide_mode;
	if (_tmp0_) {
		return;
	}
	self->priv->is_command_line_startup = TRUE;
	_tmp1_ = self->priv->wide_mode_action;
	gtk_toggle_action_set_active (_tmp1_, TRUE);
	self->priv->is_command_line_startup = FALSE;
}


/**
   * Set fullscreen mode active when started from the command line (and do not
   * change the GSetting).
   */
void cheese_main_window_set_startup_fullscreen_mode (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	self->priv->is_command_line_startup = TRUE;
	cheese_main_window_set_fullscreen (TRUE, self);
	self->priv->is_command_line_startup = FALSE;
}


/**
   * Load the UI from the GtkBuilder description.
   */
static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self) {
	cheese_main_window_on_stage_resize (self, _sender, box, flags);
}


static gboolean _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_thumbnail_mouse_button_press (self, _sender, event);
	return result;
}


static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_key_release (self, event);
	return result;
}


void cheese_main_window_setup_ui (CheeseMainWindow* self) {
	GtkBuilder* _tmp0_ = NULL;
	ClutterScript* _tmp1_ = NULL;
	CheeseFileUtil* _tmp2_ = NULL;
	CheeseFlash* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	GtkBuilder* _tmp16_ = NULL;
	GObject* _tmp17_ = NULL;
	GtkGrid* _tmp18_ = NULL;
	GtkBuilder* _tmp19_ = NULL;
	GObject* _tmp20_ = NULL;
	GtkWidget* _tmp21_ = NULL;
	GtkBuilder* _tmp22_ = NULL;
	GObject* _tmp23_ = NULL;
	GtkClutterEmbed* _tmp24_ = NULL;
	GtkClutterEmbed* _tmp25_ = NULL;
	ClutterActor* _tmp26_ = NULL;
	ClutterStage* _tmp27_ = NULL;
	GtkBuilder* _tmp28_ = NULL;
	GObject* _tmp29_ = NULL;
	GtkAlignment* _tmp30_ = NULL;
	GtkBuilder* _tmp31_ = NULL;
	GObject* _tmp32_ = NULL;
	GtkAlignment* _tmp33_ = NULL;
	GtkBuilder* _tmp34_ = NULL;
	GObject* _tmp35_ = NULL;
	GtkGrid* _tmp36_ = NULL;
	GtkBuilder* _tmp37_ = NULL;
	GObject* _tmp38_ = NULL;
	GtkToggleButton* _tmp39_ = NULL;
	GtkBuilder* _tmp40_ = NULL;
	GObject* _tmp41_ = NULL;
	GtkToggleButton* _tmp42_ = NULL;
	GtkBuilder* _tmp43_ = NULL;
	GObject* _tmp44_ = NULL;
	GtkToggleButton* _tmp45_ = NULL;
	GtkBuilder* _tmp46_ = NULL;
	GObject* _tmp47_ = NULL;
	GtkButton* _tmp48_ = NULL;
	GtkBuilder* _tmp49_ = NULL;
	GObject* _tmp50_ = NULL;
	GtkLabel* _tmp51_ = NULL;
	GtkBuilder* _tmp52_ = NULL;
	GObject* _tmp53_ = NULL;
	GtkImage* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	GObject* _tmp56_ = NULL;
	GtkToggleButton* _tmp57_ = NULL;
	GtkBuilder* _tmp58_ = NULL;
	GObject* _tmp59_ = NULL;
	GtkButton* _tmp60_ = NULL;
	GtkBuilder* _tmp61_ = NULL;
	GObject* _tmp62_ = NULL;
	GtkGrid* _tmp63_ = NULL;
	GtkBuilder* _tmp64_ = NULL;
	GObject* _tmp65_ = NULL;
	GtkMenu* _tmp66_ = NULL;
	GtkBuilder* _tmp67_ = NULL;
	GObject* _tmp68_ = NULL;
	GtkAction* _tmp69_ = NULL;
	GtkBuilder* _tmp70_ = NULL;
	GObject* _tmp71_ = NULL;
	GtkToggleAction* _tmp72_ = NULL;
	GtkBuilder* _tmp73_ = NULL;
	GObject* _tmp74_ = NULL;
	GtkAction* _tmp75_ = NULL;
	GtkBuilder* _tmp76_ = NULL;
	GObject* _tmp77_ = NULL;
	GtkAction* _tmp78_ = NULL;
	GtkToggleButton* _tmp79_ = NULL;
	GtkButton* _tmp80_ = NULL;
	GtkToggleButton* _tmp81_ = NULL;
	GtkButton* _tmp82_ = NULL;
	GtkToggleButton* _tmp83_ = NULL;
	GtkButton* _tmp84_ = NULL;
	GtkButton* _tmp85_ = NULL;
	GtkButton* _tmp86_ = NULL;
	GtkToggleButton* _tmp87_ = NULL;
	GtkButton* _tmp88_ = NULL;
	GtkButton* _tmp89_ = NULL;
	GtkButton* _tmp90_ = NULL;
	GtkButton** _tmp91_ = NULL;
	ClutterScript* _tmp92_ = NULL;
	GObject* _tmp93_ = NULL;
	ClutterTexture* _tmp94_ = NULL;
	ClutterScript* _tmp95_ = NULL;
	GObject* _tmp96_ = NULL;
	ClutterActor* _tmp97_ = NULL;
	ClutterScript* _tmp98_ = NULL;
	GObject* _tmp99_ = NULL;
	ClutterBinLayout* _tmp100_ = NULL;
	ClutterScript* _tmp101_ = NULL;
	GObject* _tmp102_ = NULL;
	ClutterText* _tmp103_ = NULL;
	ClutterScript* _tmp104_ = NULL;
	GObject* _tmp105_ = NULL;
	ClutterActor* _tmp106_ = NULL;
	ClutterScript* _tmp107_ = NULL;
	GObject* _tmp108_ = NULL;
	ClutterText* _tmp109_ = NULL;
	ClutterScript* _tmp110_ = NULL;
	GObject* _tmp111_ = NULL;
	ClutterText* _tmp112_ = NULL;
	ClutterTexture* _tmp113_ = NULL;
	ClutterTexture* _tmp114_ = NULL;
	ClutterStage* _tmp115_ = NULL;
	ClutterActor* _tmp116_ = NULL;
	ClutterActor* _tmp117_ = NULL;
	ClutterBinLayout* _tmp118_ = NULL;
	ClutterStage* _tmp119_ = NULL;
	ClutterActor* _tmp120_ = NULL;
	ClutterStage* _tmp121_ = NULL;
	ClutterText* _tmp122_ = NULL;
	ClutterStage* _tmp123_ = NULL;
	CheeseThumbView* _tmp124_ = NULL;
	CheeseThumbView* _tmp125_ = NULL;
	EogThumbNav* _tmp126_ = NULL;
	GtkCssProvider* css = NULL;
	GdkScreen* _tmp133_ = NULL;
	GdkScreen* _tmp134_ = NULL;
	CheeseThumbView* _tmp135_ = NULL;
	GtkGrid* _tmp136_ = NULL;
	GtkGrid* _tmp137_ = NULL;
	GtkClutterEmbed* _tmp138_ = NULL;
	GtkToggleAction* _tmp139_ = NULL;
	GSettings* _tmp140_ = NULL;
	gboolean _tmp141_ = FALSE;
	GSettings* _tmp142_ = NULL;
	gboolean _tmp143_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->gtk_builder);
	self->priv->gtk_builder = _tmp0_;
	_tmp1_ = clutter_script_new ();
	_g_object_unref0 (self->priv->clutter_builder);
	self->priv->clutter_builder = _tmp1_;
	_tmp2_ = cheese_fileutil_new ();
	_g_object_unref0 (self->priv->fileutil);
	self->priv->fileutil = _tmp2_;
	_tmp3_ = cheese_flash_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->flash);
	self->priv->flash = _tmp3_;
	_tmp4_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	{
		GtkBuilder* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GtkBuilder* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GtkBuilder* _tmp11_ = NULL;
		ClutterScript* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp5_ = self->priv->gtk_builder;
		_tmp6_ = g_build_filename (PACKAGE_DATADIR, "cheese-actions.ui", NULL);
		_tmp7_ = _tmp6_;
		gtk_builder_add_from_file (_tmp5_, _tmp7_, &_inner_error_);
		_g_free0 (_tmp7_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_tmp8_ = self->priv->gtk_builder;
		_tmp9_ = g_build_filename (PACKAGE_DATADIR, "cheese-main-window.ui", NULL);
		_tmp10_ = _tmp9_;
		gtk_builder_add_from_file (_tmp8_, _tmp10_, &_inner_error_);
		_g_free0 (_tmp10_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_tmp11_ = self->priv->gtk_builder;
		gtk_builder_connect_signals (_tmp11_, self);
		_tmp12_ = self->priv->clutter_builder;
		_tmp13_ = g_build_filename (PACKAGE_DATADIR, "cheese-viewport.json", NULL);
		_tmp14_ = _tmp13_;
		clutter_script_load_from_file (_tmp12_, _tmp14_, &_inner_error_);
		_g_free0 (_tmp14_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp15_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = err->message;
		g_error ("cheese-window.vala:1311: Error: %s", _tmp15_);
		_g_error_free0 (err);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp16_ = self->priv->gtk_builder;
	_tmp17_ = gtk_builder_get_object (_tmp16_, "mainbox_normal");
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp17_) : NULL);
	_g_object_unref0 (self->priv->main_vbox);
	self->priv->main_vbox = _tmp18_;
	_tmp19_ = self->priv->gtk_builder;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "thumbnails");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp20_) : NULL);
	_g_object_unref0 (self->priv->thumbnails);
	self->priv->thumbnails = _tmp21_;
	_tmp22_ = self->priv->gtk_builder;
	_tmp23_ = gtk_builder_get_object (_tmp22_, "viewport");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, gtk_clutter_embed_get_type ()) ? ((GtkClutterEmbed*) _tmp23_) : NULL);
	_g_object_unref0 (self->priv->viewport_widget);
	self->priv->viewport_widget = _tmp24_;
	_tmp25_ = self->priv->viewport_widget;
	_tmp26_ = gtk_clutter_embed_get_stage (_tmp25_);
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, clutter_stage_get_type ()) ? ((ClutterStage*) _tmp26_) : NULL);
	_g_object_unref0 (self->priv->viewport);
	self->priv->viewport = _tmp27_;
	_tmp28_ = self->priv->gtk_builder;
	_tmp29_ = gtk_builder_get_object (_tmp28_, "thumbnails_right");
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, GTK_TYPE_ALIGNMENT) ? ((GtkAlignment*) _tmp29_) : NULL);
	_g_object_unref0 (self->priv->thumbnails_right);
	self->priv->thumbnails_right = _tmp30_;
	_tmp31_ = self->priv->gtk_builder;
	_tmp32_ = gtk_builder_get_object (_tmp31_, "thumbnails_bottom");
	_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, GTK_TYPE_ALIGNMENT) ? ((GtkAlignment*) _tmp32_) : NULL);
	_g_object_unref0 (self->priv->thumbnails_bottom);
	self->priv->thumbnails_bottom = _tmp33_;
	_tmp34_ = self->priv->gtk_builder;
	_tmp35_ = gtk_builder_get_object (_tmp34_, "leave_fullscreen_button_bin");
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp35_) : NULL);
	_g_object_unref0 (self->priv->leave_fullscreen_button_container);
	self->priv->leave_fullscreen_button_container = _tmp36_;
	_tmp37_ = self->priv->gtk_builder;
	_tmp38_ = gtk_builder_get_object (_tmp37_, "photo_toggle_button");
	_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp38_) : NULL);
	_g_object_unref0 (self->priv->photo_toggle_button);
	self->priv->photo_toggle_button = _tmp39_;
	_tmp40_ = self->priv->gtk_builder;
	_tmp41_ = gtk_builder_get_object (_tmp40_, "video_toggle_button");
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp41_) : NULL);
	_g_object_unref0 (self->priv->video_toggle_button);
	self->priv->video_toggle_button = _tmp42_;
	_tmp43_ = self->priv->gtk_builder;
	_tmp44_ = gtk_builder_get_object (_tmp43_, "burst_toggle_button");
	_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp44_) : NULL);
	_g_object_unref0 (self->priv->burst_toggle_button);
	self->priv->burst_toggle_button = _tmp45_;
	_tmp46_ = self->priv->gtk_builder;
	_tmp47_ = gtk_builder_get_object (_tmp46_, "take_action_button");
	_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp47_) : NULL);
	_g_object_unref0 (self->priv->take_action_button);
	self->priv->take_action_button = _tmp48_;
	_tmp49_ = self->priv->gtk_builder;
	_tmp50_ = gtk_builder_get_object (_tmp49_, "take_action_button_internal_label");
	_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp50_) : NULL);
	_g_object_unref0 (self->priv->take_action_button_label);
	self->priv->take_action_button_label = _tmp51_;
	_tmp52_ = self->priv->gtk_builder;
	_tmp53_ = gtk_builder_get_object (_tmp52_, "take_action_button_internal_image");
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, GTK_TYPE_IMAGE) ? ((GtkImage*) _tmp53_) : NULL);
	_g_object_unref0 (self->priv->take_action_button_image);
	self->priv->take_action_button_image = _tmp54_;
	_tmp55_ = self->priv->gtk_builder;
	_tmp56_ = gtk_builder_get_object (_tmp55_, "effects_toggle_button");
	_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp56_) : NULL);
	_g_object_unref0 (self->priv->effects_toggle_button);
	self->priv->effects_toggle_button = _tmp57_;
	_tmp58_ = self->priv->gtk_builder;
	_tmp59_ = gtk_builder_get_object (_tmp58_, "leave_fullscreen_button");
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp59_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp59_) : NULL);
	_g_object_unref0 (self->priv->leave_fullscreen_button);
	self->priv->leave_fullscreen_button = _tmp60_;
	_tmp61_ = self->priv->gtk_builder;
	_tmp62_ = gtk_builder_get_object (_tmp61_, "buttons_area");
	_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp62_) : NULL);
	_g_object_unref0 (self->priv->buttons_area);
	self->priv->buttons_area = _tmp63_;
	_tmp64_ = self->priv->gtk_builder;
	_tmp65_ = gtk_builder_get_object (_tmp64_, "thumbnail_popup");
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp65_, GTK_TYPE_MENU) ? ((GtkMenu*) _tmp65_) : NULL);
	_g_object_unref0 (self->priv->thumbnail_popup);
	self->priv->thumbnail_popup = _tmp66_;
	_tmp67_ = self->priv->gtk_builder;
	_tmp68_ = gtk_builder_get_object (_tmp67_, "countdown");
	_tmp69_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, GTK_TYPE_ACTION) ? ((GtkAction*) _tmp68_) : NULL);
	_g_object_unref0 (self->priv->countdown_action);
	self->priv->countdown_action = _tmp69_;
	_tmp70_ = self->priv->gtk_builder;
	_tmp71_ = gtk_builder_get_object (_tmp70_, "wide_mode");
	_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, GTK_TYPE_TOGGLE_ACTION) ? ((GtkToggleAction*) _tmp71_) : NULL);
	_g_object_unref0 (self->priv->wide_mode_action);
	self->priv->wide_mode_action = _tmp72_;
	_tmp73_ = self->priv->gtk_builder;
	_tmp74_ = gtk_builder_get_object (_tmp73_, "effects_page_next");
	_tmp75_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, GTK_TYPE_ACTION) ? ((GtkAction*) _tmp74_) : NULL);
	_g_object_unref0 (self->priv->effects_page_next_action);
	self->priv->effects_page_next_action = _tmp75_;
	_tmp76_ = self->priv->gtk_builder;
	_tmp77_ = gtk_builder_get_object (_tmp76_, "effects_page_prev");
	_tmp78_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, GTK_TYPE_ACTION) ? ((GtkAction*) _tmp77_) : NULL);
	_g_object_unref0 (self->priv->effects_page_prev_action);
	self->priv->effects_page_prev_action = _tmp78_;
	_tmp79_ = self->priv->photo_toggle_button;
	_tmp80_ = _g_object_ref0 ((GtkButton*) _tmp79_);
	_tmp81_ = self->priv->video_toggle_button;
	_tmp82_ = _g_object_ref0 ((GtkButton*) _tmp81_);
	_tmp83_ = self->priv->burst_toggle_button;
	_tmp84_ = _g_object_ref0 ((GtkButton*) _tmp83_);
	_tmp85_ = self->priv->take_action_button;
	_tmp86_ = _g_object_ref0 (_tmp85_);
	_tmp87_ = self->priv->effects_toggle_button;
	_tmp88_ = _g_object_ref0 ((GtkButton*) _tmp87_);
	_tmp89_ = self->priv->leave_fullscreen_button;
	_tmp90_ = _g_object_ref0 (_tmp89_);
	_tmp91_ = g_new0 (GtkButton*, 6 + 1);
	_tmp91_[0] = _tmp80_;
	_tmp91_[1] = _tmp82_;
	_tmp91_[2] = _tmp84_;
	_tmp91_[3] = _tmp86_;
	_tmp91_[4] = _tmp88_;
	_tmp91_[5] = _tmp90_;
	self->priv->buttons = (_vala_array_free (self->priv->buttons, self->priv->buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->buttons = _tmp91_;
	self->priv->buttons_length1 = 6;
	self->priv->_buttons_size_ = self->priv->buttons_length1;
	_tmp92_ = self->priv->clutter_builder;
	_tmp93_ = clutter_script_get_object (_tmp92_, "video_preview");
	_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp93_, clutter_texture_get_type ()) ? ((ClutterTexture*) _tmp93_) : NULL);
	_g_object_unref0 (self->priv->video_preview);
	self->priv->video_preview = _tmp94_;
	_tmp95_ = self->priv->clutter_builder;
	_tmp96_ = clutter_script_get_object (_tmp95_, "viewport_layout");
	_tmp97_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp96_, clutter_actor_get_type ()) ? ((ClutterActor*) _tmp96_) : NULL);
	_g_object_unref0 (self->priv->viewport_layout);
	self->priv->viewport_layout = _tmp97_;
	_tmp98_ = self->priv->clutter_builder;
	_tmp99_ = clutter_script_get_object (_tmp98_, "viewport_layout_manager");
	_tmp100_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, clutter_bin_layout_get_type ()) ? ((ClutterBinLayout*) _tmp99_) : NULL);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	self->priv->viewport_layout_manager = _tmp100_;
	_tmp101_ = self->priv->clutter_builder;
	_tmp102_ = clutter_script_get_object (_tmp101_, "countdown_layer");
	_tmp103_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp102_, clutter_text_get_type ()) ? ((ClutterText*) _tmp102_) : NULL);
	_g_object_unref0 (self->priv->countdown_layer);
	self->priv->countdown_layer = _tmp103_;
	_tmp104_ = self->priv->clutter_builder;
	_tmp105_ = clutter_script_get_object (_tmp104_, "background");
	_tmp106_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp105_, clutter_actor_get_type ()) ? ((ClutterActor*) _tmp105_) : NULL);
	_g_object_unref0 (self->priv->background_layer);
	self->priv->background_layer = _tmp106_;
	_tmp107_ = self->priv->clutter_builder;
	_tmp108_ = clutter_script_get_object (_tmp107_, "error_layer");
	_tmp109_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, clutter_text_get_type ()) ? ((ClutterText*) _tmp108_) : NULL);
	_g_object_unref0 (self->priv->error_layer);
	self->priv->error_layer = _tmp109_;
	_tmp110_ = self->priv->clutter_builder;
	_tmp111_ = clutter_script_get_object (_tmp110_, "timeout_layer");
	_tmp112_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp111_, clutter_text_get_type ()) ? ((ClutterText*) _tmp111_) : NULL);
	_g_object_unref0 (self->priv->timeout_layer);
	self->priv->timeout_layer = _tmp112_;
	_tmp113_ = self->priv->video_preview;
	clutter_texture_set_keep_aspect_ratio (_tmp113_, TRUE);
	_tmp114_ = self->priv->video_preview;
	clutter_actor_set_request_mode ((ClutterActor*) _tmp114_, CLUTTER_REQUEST_HEIGHT_FOR_WIDTH);
	_tmp115_ = self->priv->viewport;
	_tmp116_ = self->priv->background_layer;
	clutter_actor_add_child ((ClutterActor*) _tmp115_, _tmp116_);
	_tmp117_ = self->priv->viewport_layout;
	_tmp118_ = self->priv->viewport_layout_manager;
	clutter_actor_set_layout_manager (_tmp117_, (ClutterLayoutManager*) _tmp118_);
	_tmp119_ = self->priv->viewport;
	_tmp120_ = self->priv->viewport_layout;
	clutter_actor_add_child ((ClutterActor*) _tmp119_, _tmp120_);
	_tmp121_ = self->priv->viewport;
	_tmp122_ = self->priv->timeout_layer;
	clutter_actor_add_child ((ClutterActor*) _tmp121_, (ClutterActor*) _tmp122_);
	_tmp123_ = self->priv->viewport;
	g_signal_connect_object ((ClutterActor*) _tmp123_, "allocation-changed", (GCallback) _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed, self, 0);
	_tmp124_ = cheese_thumb_view_new ();
	g_object_ref_sink (_tmp124_);
	_g_object_unref0 (self->priv->thumb_view);
	self->priv->thumb_view = _tmp124_;
	_tmp125_ = self->priv->thumb_view;
	_tmp126_ = eog_thumb_nav_new ((GtkWidget*) _tmp125_, FALSE);
	g_object_ref_sink (_tmp126_);
	_g_object_unref0 (self->priv->thumb_nav);
	self->priv->thumb_nav = _tmp126_;
	{
		GtkCssProvider* _tmp127_ = NULL;
		gchar* _tmp128_ = NULL;
		gchar* _tmp129_ = NULL;
		_tmp127_ = gtk_css_provider_new ();
		_g_object_unref0 (css);
		css = _tmp127_;
		_tmp128_ = g_build_filename (PACKAGE_DATADIR, "cheese.css", NULL);
		_tmp129_ = _tmp128_;
		gtk_css_provider_load_from_path (css, _tmp129_, &_inner_error_);
		_g_free0 (_tmp129_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		FILE* _tmp130_ = NULL;
		GError* _tmp131_ = NULL;
		const gchar* _tmp132_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp130_ = stdout;
		_tmp131_ = e;
		_tmp132_ = _tmp131_->message;
		fprintf (_tmp130_, "Error: %s\n", _tmp132_);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (css);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp133_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp134_ = _tmp133_;
	gtk_style_context_add_provider_for_screen (_tmp134_, (GtkStyleProvider*) css, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	_tmp135_ = self->priv->thumb_view;
	g_signal_connect_object ((GtkWidget*) _tmp135_, "button-press-event", (GCallback) _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event, self, 0);
	_tmp136_ = self->priv->main_vbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp136_);
	_tmp137_ = self->priv->main_vbox;
	gtk_widget_show_all ((GtkWidget*) _tmp137_);
	_tmp138_ = self->priv->viewport_widget;
	gtk_widget_realize ((GtkWidget*) _tmp138_);
	_tmp139_ = self->priv->wide_mode_action;
	_tmp140_ = self->priv->settings;
	_tmp141_ = g_settings_get_boolean (_tmp140_, "wide-mode");
	gtk_toggle_action_set_active (_tmp139_, _tmp141_);
	_tmp142_ = self->priv->settings;
	_tmp143_ = g_settings_get_boolean (_tmp142_, "wide-mode");
	if (!_tmp143_) {
		GtkToggleAction* _tmp144_ = NULL;
		_tmp144_ = self->priv->wide_mode_action;
		gtk_toggle_action_toggled (_tmp144_);
	}
	cheese_main_window_set_mode (self, CHEESE_MEDIA_MODE_PHOTO);
	cheese_main_window_setup_effects_selector (self);
	cheese_main_window_toggle_camera_actions_sensitivities (self, FALSE);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _cheese_main_window_on_key_release_gtk_widget_key_release_event, self, 0);
	_g_object_unref0 (css);
}


ClutterTexture* cheese_main_window_get_video_preview (CheeseMainWindow* self) {
	ClutterTexture* result = NULL;
	ClutterTexture* _tmp0_ = NULL;
	ClutterTexture* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->video_preview;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
   * Setup the thumbview thumbnail monitors.
   */
void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self) {
	CheeseThumbView* _tmp0_ = NULL;
	CheeseFileUtil* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	CheeseThumbView* _tmp3_ = NULL;
	CheeseFileUtil* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = self->priv->fileutil;
	_tmp2_ = cheese_fileutil_get_video_path (_tmp1_);
	cheese_thumb_view_start_monitoring_video_path (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->thumb_view;
	_tmp4_ = self->priv->fileutil;
	_tmp5_ = cheese_fileutil_get_photo_path (_tmp4_);
	cheese_thumb_view_start_monitoring_photo_path (_tmp3_, _tmp5_);
}


/**
     * Set the current media mode (photo, video or burst).
     *
     * @param mode the media mode to set
     */
void cheese_main_window_set_current_mode (CheeseMainWindow* self, CheeseMediaMode mode) {
	CheeseMediaMode _tmp0_ = 0;
	CheeseMediaMode _tmp1_ = 0;
	ClutterText* _tmp2_ = NULL;
	CheeseMediaMode _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	self->priv->current_mode = _tmp0_;
	_tmp1_ = self->priv->current_mode;
	cheese_main_window_set_resolution (self, _tmp1_);
	_tmp2_ = self->priv->timeout_layer;
	clutter_actor_hide ((ClutterActor*) _tmp2_);
	_tmp3_ = self->priv->current_mode;
	switch (_tmp3_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			GtkLabel* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			GtkButton* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			_tmp4_ = self->priv->take_action_button_label;
			_tmp5_ = _ ("_Take a Photo");
			_tmp6_ = g_strconcat ("<b>", _tmp5_, NULL);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strconcat (_tmp7_, "</b>", NULL);
			_tmp9_ = _tmp8_;
			gtk_label_set_label (_tmp4_, _tmp9_);
			_g_free0 (_tmp9_);
			_g_free0 (_tmp7_);
			_tmp10_ = self->priv->take_action_button;
			_tmp11_ = _ ("Take a photo using a webcam");
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _tmp11_);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GtkLabel* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			GtkButton* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			ClutterText* _tmp20_ = NULL;
			ClutterText* _tmp21_ = NULL;
			_tmp12_ = self->priv->take_action_button_label;
			_tmp13_ = _ ("_Record a Video");
			_tmp14_ = g_strconcat ("<b>", _tmp13_, NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp15_, "</b>", NULL);
			_tmp17_ = _tmp16_;
			gtk_label_set_label (_tmp12_, _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
			_tmp18_ = self->priv->take_action_button;
			_tmp19_ = _ ("Record a video using a webcam");
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp18_, _tmp19_);
			_tmp20_ = self->priv->timeout_layer;
			clutter_text_set_text (_tmp20_, "00:00:00");
			_tmp21_ = self->priv->timeout_layer;
			clutter_actor_show ((ClutterActor*) _tmp21_);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			GtkLabel* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			GtkButton* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			_tmp22_ = self->priv->take_action_button_label;
			_tmp23_ = _ ("Take _Multiple Photos");
			_tmp24_ = g_strconcat ("<b>", _tmp23_, NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strconcat (_tmp25_, "</b>", NULL);
			_tmp27_ = _tmp26_;
			gtk_label_set_label (_tmp22_, _tmp27_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			_tmp28_ = self->priv->take_action_button;
			_tmp29_ = _ ("Take multiple photos using a webcam");
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp28_, _tmp29_);
			break;
		}
		default:
		break;
	}
}


/**
     * Set the camera.
     *
     * @param camera the camera to set
     */
void cheese_main_window_set_camera (CheeseMainWindow* self, CheeseCamera* camera) {
	CheeseCamera* _tmp0_ = NULL;
	CheeseCamera* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (camera != NULL);
	_tmp0_ = camera;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp1_;
}


static void cheese_main_window_class_init (CheeseMainWindowClass * klass) {
	cheese_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheeseMainWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_main_window_finalize;
}


static void cheese_main_window_instance_init (CheeseMainWindow * self) {
	self->priv = CHEESE_MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->current_effects_page = (guint) 0;
}


static void cheese_main_window_finalize (GObject* obj) {
	CheeseMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow);
	_g_object_unref0 (self->priv->gtk_builder);
	_g_object_unref0 (self->priv->clutter_builder);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->thumbnails);
	_g_object_unref0 (self->priv->viewport_widget);
	_g_object_unref0 (self->priv->main_vbox);
	_g_object_unref0 (self->priv->thumb_nav);
	_g_object_unref0 (self->priv->thumb_view);
	_g_object_unref0 (self->priv->thumbnails_right);
	_g_object_unref0 (self->priv->thumbnails_bottom);
	_g_object_unref0 (self->priv->leave_fullscreen_button_container);
	_g_object_unref0 (self->priv->photo_toggle_button);
	_g_object_unref0 (self->priv->video_toggle_button);
	_g_object_unref0 (self->priv->burst_toggle_button);
	_g_object_unref0 (self->priv->take_action_button);
	_g_object_unref0 (self->priv->take_action_button_label);
	_g_object_unref0 (self->priv->take_action_button_image);
	_g_object_unref0 (self->priv->effects_toggle_button);
	_g_object_unref0 (self->priv->leave_fullscreen_button);
	_g_object_unref0 (self->priv->buttons_area);
	_g_object_unref0 (self->priv->thumbnail_popup);
	_g_object_unref0 (self->priv->viewport);
	_g_object_unref0 (self->priv->viewport_layout);
	_g_object_unref0 (self->priv->video_preview);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	_g_object_unref0 (self->priv->countdown_layer);
	_g_object_unref0 (self->priv->background_layer);
	_g_object_unref0 (self->priv->error_layer);
	_g_object_unref0 (self->priv->timeout_layer);
	_g_object_unref0 (self->priv->current_effects_grid);
	__g_list_free__g_object_unref0_0 (self->priv->effects_grids);
	_g_hash_table_unref0 (self->priv->action_sensitivities);
	_g_object_unref0 (self->priv->wide_mode_action);
	_g_object_unref0 (self->priv->countdown_action);
	_g_object_unref0 (self->priv->effects_page_prev_action);
	_g_object_unref0 (self->priv->effects_page_next_action);
	self->priv->buttons = (_vala_array_free (self->priv->buttons, self->priv->buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->fileutil);
	_g_object_unref0 (self->priv->flash);
	_g_object_unref0 (self->priv->effects_manager);
	_g_object_unref0 (self->priv->selected_effect);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	_g_object_unref0 (self->priv->current_countdown);
	G_OBJECT_CLASS (cheese_main_window_parent_class)->finalize (obj);
}


GType cheese_main_window_get_type (void) {
	static volatile gsize cheese_main_window_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseMainWindow), 0, (GInstanceInitFunc) cheese_main_window_instance_init, NULL };
		GType cheese_main_window_type_id;
		cheese_main_window_type_id = g_type_register_static (GTK_TYPE_APPLICATION_WINDOW, "CheeseMainWindow", &g_define_type_info, 0);
		g_once_init_leave (&cheese_main_window_type_id__volatile, cheese_main_window_type_id);
	}
	return cheese_main_window_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



