/* chess-pgn.c generated by valac 0.20.1, the Vala compiler
 * generated from chess-pgn.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PGN_GAME (pgn_game_get_type ())
#define PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN_GAME, PGNGame))
#define PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN_GAME, PGNGameClass))
#define IS_PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN_GAME))
#define IS_PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN_GAME))
#define PGN_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN_GAME, PGNGameClass))

typedef struct _PGNGame PGNGame;
typedef struct _PGNGameClass PGNGameClass;
typedef struct _PGNGamePrivate PGNGamePrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecPGNGame ParamSpecPGNGame;

#define TYPE_STATE (state_get_type ())

#define TYPE_PGN (pgn_get_type ())
#define PGN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN, PGN))
#define PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN, PGNClass))
#define IS_PGN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN))
#define IS_PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN))
#define PGN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN, PGNClass))

typedef struct _PGN PGN;
typedef struct _PGNClass PGNClass;
typedef struct _PGNPrivate PGNPrivate;
#define __g_list_free__pgn_game_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__pgn_game_unref0_ (var), NULL)))
#define _pgn_game_unref0(var) ((var == NULL) ? NULL : (var = (pgn_game_unref (var), NULL)))
#define _pgn_unref0(var) ((var == NULL) ? NULL : (var = (pgn_unref (var), NULL)))
typedef struct _ParamSpecPGN ParamSpecPGN;

typedef enum  {
	PGN_ERROR_LOAD_ERROR
} PGNError;
#define PGN_ERROR pgn_error_quark ()
struct _PGNGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNGamePrivate * priv;
	GHashTable* tags;
	GList* moves;
};

struct _PGNGameClass {
	GTypeClass parent_class;
	void (*finalize) (PGNGame *self);
};

struct _ParamSpecPGNGame {
	GParamSpec parent_instance;
};

typedef enum  {
	STATE_TAGS,
	STATE_MOVE_TEXT,
	STATE_LINE_COMMENT,
	STATE_BRACE_COMMENT,
	STATE_TAG_START,
	STATE_TAG_NAME,
	STATE_PRE_TAG_VALUE,
	STATE_TAG_VALUE,
	STATE_POST_TAG_VALUE,
	STATE_SYMBOL,
	STATE_PERIOD,
	STATE_NAG,
	STATE_ERROR
} State;

struct _PGN {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNPrivate * priv;
	GList* games;
};

struct _PGNClass {
	GTypeClass parent_class;
	void (*finalize) (PGN *self);
};

struct _ParamSpecPGN {
	GParamSpec parent_instance;
};


static gpointer pgn_game_parent_class = NULL;
extern gchar* pgn_game_RESULT_IN_PROGRESS;
gchar* pgn_game_RESULT_IN_PROGRESS = NULL;
extern gchar* pgn_game_RESULT_DRAW;
gchar* pgn_game_RESULT_DRAW = NULL;
extern gchar* pgn_game_RESULT_WHITE;
gchar* pgn_game_RESULT_WHITE = NULL;
extern gchar* pgn_game_RESULT_BLACK;
gchar* pgn_game_RESULT_BLACK = NULL;
extern gchar* pgn_game_TERMINATE_ABANDONED;
gchar* pgn_game_TERMINATE_ABANDONED = NULL;
extern gchar* pgn_game_TERMINATE_ADJUDICATION;
gchar* pgn_game_TERMINATE_ADJUDICATION = NULL;
extern gchar* pgn_game_TERMINATE_DEATH;
gchar* pgn_game_TERMINATE_DEATH = NULL;
extern gchar* pgn_game_TERMINATE_EMERGENCY;
gchar* pgn_game_TERMINATE_EMERGENCY = NULL;
extern gchar* pgn_game_TERMINATE_NORMAL;
gchar* pgn_game_TERMINATE_NORMAL = NULL;
extern gchar* pgn_game_TERMINATE_RULES_INFRACTION;
gchar* pgn_game_TERMINATE_RULES_INFRACTION = NULL;
extern gchar* pgn_game_TERMINATE_TIME_FORFEIT;
gchar* pgn_game_TERMINATE_TIME_FORFEIT = NULL;
extern gchar* pgn_game_TERMINATE_UNTERMINATED;
gchar* pgn_game_TERMINATE_UNTERMINATED = NULL;
static gpointer pgn_parent_class = NULL;

gint str_index (const gchar* name);
gint compare_tag (const gchar* name0, const gchar* name1);
GQuark pgn_error_quark (void);
gpointer pgn_game_ref (gpointer instance);
void pgn_game_unref (gpointer instance);
GParamSpec* param_spec_pgn_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn_game (GValue* value, gpointer v_object);
void value_take_pgn_game (GValue* value, gpointer v_object);
gpointer value_get_pgn_game (const GValue* value);
GType pgn_game_get_type (void) G_GNUC_CONST;
enum  {
	PGN_GAME_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
PGNGame* pgn_game_new (void);
PGNGame* pgn_game_construct (GType object_type);
gchar* pgn_game_escape (PGNGame* self, const gchar* value);
void pgn_game_write (PGNGame* self, GFile* file, GError** error);
const gchar* pgn_game_get_result (PGNGame* self);
const gchar* pgn_game_get_event (PGNGame* self);
void pgn_game_set_event (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_site (PGNGame* self);
void pgn_game_set_site (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_date (PGNGame* self);
void pgn_game_set_date (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_time (PGNGame* self);
void pgn_game_set_time (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_round (PGNGame* self);
void pgn_game_set_round (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_white (PGNGame* self);
void pgn_game_set_white (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_black (PGNGame* self);
void pgn_game_set_black (PGNGame* self, const gchar* value);
void pgn_game_set_result (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_annotator (PGNGame* self);
void pgn_game_set_annotator (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_time_control (PGNGame* self);
void pgn_game_set_time_control (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_white_time_left (PGNGame* self);
void pgn_game_set_white_time_left (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_black_time_left (PGNGame* self);
void pgn_game_set_black_time_left (PGNGame* self, const gchar* value);
gboolean pgn_game_get_set_up (PGNGame* self);
void pgn_game_set_set_up (PGNGame* self, gboolean value);
const gchar* pgn_game_get_fen (PGNGame* self);
void pgn_game_set_fen (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_termination (PGNGame* self);
void pgn_game_set_termination (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_white_ai (PGNGame* self);
void pgn_game_set_white_ai (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_white_level (PGNGame* self);
void pgn_game_set_white_level (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_black_ai (PGNGame* self);
void pgn_game_set_black_ai (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_black_level (PGNGame* self);
void pgn_game_set_black_level (PGNGame* self, const gchar* value);
static void pgn_game_finalize (PGNGame* obj);
GType state_get_type (void) G_GNUC_CONST;
gpointer pgn_ref (gpointer instance);
void pgn_unref (gpointer instance);
GParamSpec* param_spec_pgn (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn (GValue* value, gpointer v_object);
void value_take_pgn (GValue* value, gpointer v_object);
gpointer value_get_pgn (const GValue* value);
GType pgn_get_type (void) G_GNUC_CONST;
enum  {
	PGN_DUMMY_PROPERTY
};
static void _pgn_game_unref0_ (gpointer var);
static void _g_list_free__pgn_game_unref0_ (GList* self);
PGN* pgn_new (void);
PGN* pgn_construct (GType object_type);
PGN* pgn_new_from_string (const gchar* data, GError** error);
PGN* pgn_construct_from_string (GType object_type, const gchar* data, GError** error);
PGN* pgn_new_from_file (GFile* file, GError** error);
PGN* pgn_construct_from_file (GType object_type, GFile* file, GError** error);
static void pgn_finalize (PGN* obj);


gint str_index (const gchar* name) {
	gint result = 0;
	const gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "Event") == 0) {
		result = 0;
		return result;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = name;
		if (g_strcmp0 (_tmp1_, "Site") == 0) {
			result = 1;
			return result;
		} else {
			const gchar* _tmp2_;
			_tmp2_ = name;
			if (g_strcmp0 (_tmp2_, "Date") == 0) {
				result = 2;
				return result;
			} else {
				const gchar* _tmp3_;
				_tmp3_ = name;
				if (g_strcmp0 (_tmp3_, "Round") == 0) {
					result = 3;
					return result;
				} else {
					const gchar* _tmp4_;
					_tmp4_ = name;
					if (g_strcmp0 (_tmp4_, "White") == 0) {
						result = 4;
						return result;
					} else {
						const gchar* _tmp5_;
						_tmp5_ = name;
						if (g_strcmp0 (_tmp5_, "Black") == 0) {
							result = 5;
							return result;
						} else {
							const gchar* _tmp6_;
							_tmp6_ = name;
							if (g_strcmp0 (_tmp6_, "Result") == 0) {
								result = 6;
								return result;
							} else {
								result = 7;
								return result;
							}
						}
					}
				}
			}
		}
	}
}


gint compare_tag (const gchar* name0, const gchar* name1) {
	gint result = 0;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint str_index0;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	gint str_index1;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gboolean _tmp7_;
	g_return_val_if_fail (name0 != NULL, 0);
	g_return_val_if_fail (name1 != NULL, 0);
	_tmp0_ = name0;
	_tmp1_ = str_index (_tmp0_);
	str_index0 = _tmp1_;
	_tmp2_ = name1;
	_tmp3_ = str_index (_tmp2_);
	str_index1 = _tmp3_;
	_tmp5_ = str_index0;
	if (_tmp5_ == 7) {
		gint _tmp6_;
		_tmp6_ = str_index1;
		_tmp4_ = _tmp6_ == 7;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		GCompareFunc _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_ = 0;
		_tmp8_ = g_strcmp0;
		_tmp9_ = name0;
		_tmp10_ = name1;
		_tmp11_ = _tmp8_ (_tmp9_, _tmp10_);
		result = _tmp11_;
		return result;
	} else {
		gint _tmp12_;
		gint _tmp13_;
		_tmp12_ = str_index0;
		_tmp13_ = str_index1;
		result = _tmp12_ - _tmp13_;
		return result;
	}
}


GQuark pgn_error_quark (void) {
	return g_quark_from_static_string ("pgn_error-quark");
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


PGNGame* pgn_game_construct (GType object_type) {
	PGNGame* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GHashTable* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GHashTable* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GHashTable* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	self = (PGNGame*) g_type_create_instance (object_type);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->tags);
	self->tags = _tmp2_;
	_tmp3_ = self->tags;
	_tmp4_ = g_strdup ("Event");
	_tmp5_ = g_strdup ("?");
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = self->tags;
	_tmp7_ = g_strdup ("Site");
	_tmp8_ = g_strdup ("?");
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
	_tmp9_ = self->tags;
	_tmp10_ = g_strdup ("Date");
	_tmp11_ = g_strdup ("????.??.??");
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = self->tags;
	_tmp13_ = g_strdup ("Round");
	_tmp14_ = g_strdup ("?");
	g_hash_table_insert (_tmp12_, _tmp13_, _tmp14_);
	_tmp15_ = self->tags;
	_tmp16_ = g_strdup ("White");
	_tmp17_ = g_strdup ("?");
	g_hash_table_insert (_tmp15_, _tmp16_, _tmp17_);
	_tmp18_ = self->tags;
	_tmp19_ = g_strdup ("Black");
	_tmp20_ = g_strdup ("?");
	g_hash_table_insert (_tmp18_, _tmp19_, _tmp20_);
	_tmp21_ = self->tags;
	_tmp22_ = g_strdup ("Result");
	_tmp23_ = pgn_game_RESULT_IN_PROGRESS;
	_tmp24_ = g_strdup (_tmp23_);
	g_hash_table_insert (_tmp21_, _tmp22_, _tmp24_);
	return self;
}


PGNGame* pgn_game_new (void) {
	return pgn_game_construct (TYPE_PGN_GAME);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch16_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch16_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally16;
	__catch16_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally16:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* pgn_game_escape (PGNGame* self, const gchar* value) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* a;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = value;
	_tmp1_ = string_replace (_tmp0_, "\\", "\\\\");
	a = _tmp1_;
	_tmp2_ = string_replace (a, "\"", "\\\"");
	result = _tmp2_;
	_g_free0 (a);
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void pgn_game_write (PGNGame* self, GFile* file, GError** error) {
	GString* _tmp0_;
	GString* data;
	GHashTable* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* keys;
	GList* _tmp3_;
	GString* _tmp13_;
	gint i;
	GList* _tmp14_;
	GString* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GString* _tmp28_;
	GFile* _tmp29_;
	GString* _tmp30_;
	const gchar* _tmp31_;
	guint8* _tmp32_;
	gint _tmp32__length1;
	guint8* _tmp33_;
	gint _tmp33__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_string_new ("");
	data = _tmp0_;
	_tmp1_ = self->tags;
	_tmp2_ = g_hash_table_get_keys (_tmp1_);
	keys = _tmp2_;
	keys = g_list_sort (keys, (GCompareFunc) compare_tag);
	_tmp3_ = keys;
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp3_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			const gchar* key = NULL;
			key = (const gchar*) key_it->data;
			{
				GString* _tmp4_;
				const gchar* _tmp5_;
				GHashTable* _tmp6_;
				const gchar* _tmp7_;
				gconstpointer _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				_tmp4_ = data;
				_tmp5_ = key;
				_tmp6_ = self->tags;
				_tmp7_ = key;
				_tmp8_ = g_hash_table_lookup (_tmp6_, _tmp7_);
				_tmp9_ = pgn_game_escape (self, (const gchar*) _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strdup_printf ("[%s \"%s\"]\n", _tmp5_, _tmp10_);
				_tmp12_ = _tmp11_;
				g_string_append (_tmp4_, _tmp12_);
				_g_free0 (_tmp12_);
				_g_free0 (_tmp10_);
			}
		}
	}
	_tmp13_ = data;
	g_string_append (_tmp13_, "\n");
	i = 0;
	_tmp14_ = self->moves;
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
		move_collection = _tmp14_;
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
			gchar* _tmp15_;
			gchar* move = NULL;
			_tmp15_ = g_strdup ((const gchar*) move_it->data);
			move = _tmp15_;
			{
				gint _tmp16_;
				GString* _tmp21_;
				const gchar* _tmp22_;
				GString* _tmp23_;
				gint _tmp24_;
				_tmp16_ = i;
				if ((_tmp16_ % 2) == 0) {
					GString* _tmp17_;
					gint _tmp18_;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_;
					_tmp17_ = data;
					_tmp18_ = i;
					_tmp19_ = g_strdup_printf ("%d. ", (_tmp18_ / 2) + 1);
					_tmp20_ = _tmp19_;
					g_string_append (_tmp17_, _tmp20_);
					_g_free0 (_tmp20_);
				}
				_tmp21_ = data;
				_tmp22_ = move;
				g_string_append (_tmp21_, _tmp22_);
				_tmp23_ = data;
				g_string_append (_tmp23_, " ");
				_tmp24_ = i;
				i = _tmp24_ + 1;
				_g_free0 (move);
			}
		}
	}
	_tmp25_ = data;
	_tmp26_ = pgn_game_get_result (self);
	_tmp27_ = _tmp26_;
	g_string_append (_tmp25_, _tmp27_);
	_tmp28_ = data;
	g_string_append (_tmp28_, "\n");
	_tmp29_ = file;
	_tmp30_ = data;
	_tmp31_ = _tmp30_->str;
	_tmp32_ = string_get_data (_tmp31_, &_tmp32__length1);
	_tmp33_ = _tmp32_;
	_tmp33__length1 = _tmp32__length1;
	g_file_replace_contents (_tmp29_, _tmp33_, (gsize) _tmp33__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_list_free0 (keys);
		_g_string_free0 (data);
		return;
	}
	_g_list_free0 (keys);
	_g_string_free0 (data);
}


const gchar* pgn_game_get_event (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Event");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_event (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Event");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_site (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Site");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_site (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Site");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_date (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Date");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_date (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Date");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_time (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Time");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_time (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Time");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_round (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Round");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_round (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Round");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_white (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "White");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_white (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("White");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_black (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Black");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_black (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Black");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_result (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Result");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_result (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Result");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_annotator (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Annotator");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_annotator (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Annotator");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_time_control (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "TimeControl");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_time_control (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("TimeControl");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_white_time_left (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "WhiteTimeLeft");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_white_time_left (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("WhiteTimeLeft");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_black_time_left (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "BlackTimeLeft");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_black_time_left (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("BlackTimeLeft");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


gboolean pgn_game_get_set_up (PGNGame* self) {
	gboolean result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* v;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "SetUp");
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	v = _tmp2_;
	_tmp5_ = v;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = v;
		_tmp4_ = g_strcmp0 (_tmp6_, "1") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp8_ = _tmp3_;
	result = _tmp8_;
	_g_free0 (v);
	return result;
}


void pgn_game_set_set_up (PGNGame* self, gboolean value) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_) {
		_tmp0_ = "1";
	} else {
		_tmp0_ = "0";
	}
	_tmp2_ = self->tags;
	_tmp3_ = g_strdup ("SetUp");
	_tmp4_ = _tmp0_;
	_tmp5_ = g_strdup (_tmp4_);
	g_hash_table_insert (_tmp2_, _tmp3_, _tmp5_);
}


const gchar* pgn_game_get_fen (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "FEN");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_fen (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("FEN");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_termination (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Termination");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_termination (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Termination");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_white_ai (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "WhiteAI");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_white_ai (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("WhiteAI");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_white_level (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "WhiteLevel");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_white_level (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("WhiteLevel");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_black_ai (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "BlackAI");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_black_ai (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("BlackAI");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


const gchar* pgn_game_get_black_level (PGNGame* self) {
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "BlackLevel");
	result = (const gchar*) _tmp1_;
	return result;
}


void pgn_game_set_black_level (PGNGame* self, const gchar* value) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("BlackLevel");
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
}


static void value_pgn_game_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_pgn_game_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		pgn_game_unref (value->data[0].v_pointer);
	}
}


static void value_pgn_game_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pgn_game_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_pgn_game_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_pgn_game_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PGNGame* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pgn_game_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_pgn_game_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PGNGame** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pgn_game_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_pgn_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPGNGame* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PGN_GAME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_pgn_game (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PGN_GAME), NULL);
	return value->data[0].v_pointer;
}


void value_set_pgn_game (GValue* value, gpointer v_object) {
	PGNGame* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PGN_GAME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PGN_GAME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pgn_game_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pgn_game_unref (old);
	}
}


void value_take_pgn_game (GValue* value, gpointer v_object) {
	PGNGame* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PGN_GAME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PGN_GAME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pgn_game_unref (old);
	}
}


static void pgn_game_class_init (PGNGameClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	pgn_game_parent_class = g_type_class_peek_parent (klass);
	PGN_GAME_CLASS (klass)->finalize = pgn_game_finalize;
	_tmp0_ = g_strdup ("*");
	pgn_game_RESULT_IN_PROGRESS = _tmp0_;
	_tmp1_ = g_strdup ("1/2-1/2");
	pgn_game_RESULT_DRAW = _tmp1_;
	_tmp2_ = g_strdup ("1-0");
	pgn_game_RESULT_WHITE = _tmp2_;
	_tmp3_ = g_strdup ("0-1");
	pgn_game_RESULT_BLACK = _tmp3_;
	_tmp4_ = g_strdup ("abandoned");
	pgn_game_TERMINATE_ABANDONED = _tmp4_;
	_tmp5_ = g_strdup ("adjudication");
	pgn_game_TERMINATE_ADJUDICATION = _tmp5_;
	_tmp6_ = g_strdup ("death");
	pgn_game_TERMINATE_DEATH = _tmp6_;
	_tmp7_ = g_strdup ("emergency");
	pgn_game_TERMINATE_EMERGENCY = _tmp7_;
	_tmp8_ = g_strdup ("normal");
	pgn_game_TERMINATE_NORMAL = _tmp8_;
	_tmp9_ = g_strdup ("rules infraction");
	pgn_game_TERMINATE_RULES_INFRACTION = _tmp9_;
	_tmp10_ = g_strdup ("time forfeit");
	pgn_game_TERMINATE_TIME_FORFEIT = _tmp10_;
	_tmp11_ = g_strdup ("unterminated");
	pgn_game_TERMINATE_UNTERMINATED = _tmp11_;
}


static void pgn_game_instance_init (PGNGame * self) {
	self->ref_count = 1;
}


static void pgn_game_finalize (PGNGame* obj) {
	PGNGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PGN_GAME, PGNGame);
	_g_hash_table_unref0 (self->tags);
	__g_list_free__g_free0_0 (self->moves);
}


GType pgn_game_get_type (void) {
	static volatile gsize pgn_game_type_id__volatile = 0;
	if (g_once_init_enter (&pgn_game_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pgn_game_init, value_pgn_game_free_value, value_pgn_game_copy_value, value_pgn_game_peek_pointer, "p", value_pgn_game_collect_value, "p", value_pgn_game_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PGNGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pgn_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PGNGame), 0, (GInstanceInitFunc) pgn_game_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pgn_game_type_id;
		pgn_game_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PGNGame", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pgn_game_type_id__volatile, pgn_game_type_id);
	}
	return pgn_game_type_id__volatile;
}


gpointer pgn_game_ref (gpointer instance) {
	PGNGame* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void pgn_game_unref (gpointer instance) {
	PGNGame* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PGN_GAME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType state_get_type (void) {
	static volatile gsize state_type_id__volatile = 0;
	if (g_once_init_enter (&state_type_id__volatile)) {
		static const GEnumValue values[] = {{STATE_TAGS, "STATE_TAGS", "tags"}, {STATE_MOVE_TEXT, "STATE_MOVE_TEXT", "move-text"}, {STATE_LINE_COMMENT, "STATE_LINE_COMMENT", "line-comment"}, {STATE_BRACE_COMMENT, "STATE_BRACE_COMMENT", "brace-comment"}, {STATE_TAG_START, "STATE_TAG_START", "tag-start"}, {STATE_TAG_NAME, "STATE_TAG_NAME", "tag-name"}, {STATE_PRE_TAG_VALUE, "STATE_PRE_TAG_VALUE", "pre-tag-value"}, {STATE_TAG_VALUE, "STATE_TAG_VALUE", "tag-value"}, {STATE_POST_TAG_VALUE, "STATE_POST_TAG_VALUE", "post-tag-value"}, {STATE_SYMBOL, "STATE_SYMBOL", "symbol"}, {STATE_PERIOD, "STATE_PERIOD", "period"}, {STATE_NAG, "STATE_NAG", "nag"}, {STATE_ERROR, "STATE_ERROR", "error"}, {0, NULL, NULL}};
		GType state_type_id;
		state_type_id = g_enum_register_static ("State", values);
		g_once_init_leave (&state_type_id__volatile, state_type_id);
	}
	return state_type_id__volatile;
}


static void _pgn_game_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (pgn_game_unref (var), NULL));
}


static void _g_list_free__pgn_game_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _pgn_game_unref0_, NULL);
	g_list_free (self);
}


PGN* pgn_construct (GType object_type) {
	PGN* self = NULL;
	self = (PGN*) g_type_create_instance (object_type);
	return self;
}


PGN* pgn_new (void) {
	return pgn_construct (TYPE_PGN);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gpointer _pgn_game_ref0 (gpointer self) {
	return self ? pgn_game_ref (self) : NULL;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


PGN* pgn_construct_from_string (GType object_type, const gchar* data, GError** error) {
	PGN* self = NULL;
	State state;
	State home_state;
	PGNGame* _tmp0_;
	PGNGame* game;
	gboolean in_escape;
	gsize token_start;
	gsize line_offset;
	gchar* _tmp1_;
	gchar* tag_name;
	GString* _tmp2_;
	GString* tag_value;
	gint line;
	gint rav_level;
	gboolean _tmp188_ = FALSE;
	PGNGame* _tmp189_;
	GList* _tmp190_;
	guint _tmp191_ = 0U;
	gboolean _tmp195_;
	GList* _tmp198_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (data != NULL, NULL);
	self = (PGN*) g_type_create_instance (object_type);
	state = STATE_TAGS;
	home_state = STATE_TAGS;
	_tmp0_ = pgn_game_new ();
	game = _tmp0_;
	in_escape = FALSE;
	token_start = (gsize) 0;
	line_offset = (gsize) 0;
	_tmp1_ = g_strdup ("");
	tag_name = _tmp1_;
	_tmp2_ = g_string_new ("");
	tag_value = _tmp2_;
	line = 1;
	rav_level = 0;
	{
		gsize offset;
		offset = (gsize) 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gsize _tmp6_;
				const gchar* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				const gchar* _tmp10_;
				gsize _tmp11_;
				gchar _tmp12_ = '\0';
				gunichar c;
				gunichar _tmp13_;
				State _tmp16_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gsize _tmp5_;
					_tmp5_ = offset;
					offset = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = offset;
				_tmp7_ = data;
				_tmp8_ = strlen (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!(_tmp6_ <= ((gsize) _tmp9_))) {
					break;
				}
				_tmp10_ = data;
				_tmp11_ = offset;
				_tmp12_ = string_get (_tmp10_, (glong) _tmp11_);
				c = (gunichar) _tmp12_;
				_tmp13_ = c;
				if (_tmp13_ == ((gunichar) '\n')) {
					gint _tmp14_;
					gsize _tmp15_;
					_tmp14_ = line;
					line = _tmp14_ + 1;
					_tmp15_ = offset;
					line_offset = _tmp15_ + 1;
				}
				_tmp16_ = state;
				switch (_tmp16_) {
					case STATE_TAGS:
					{
						gunichar _tmp17_;
						gboolean _tmp18_ = FALSE;
						home_state = STATE_TAGS;
						_tmp17_ = c;
						_tmp18_ = g_unichar_isspace (_tmp17_);
						if (_tmp18_) {
						} else {
							gunichar _tmp19_;
							_tmp19_ = c;
							if (_tmp19_ == ((gunichar) ';')) {
								state = STATE_LINE_COMMENT;
							} else {
								gunichar _tmp20_;
								_tmp20_ = c;
								if (_tmp20_ == ((gunichar) '{')) {
									state = STATE_BRACE_COMMENT;
								} else {
									gunichar _tmp21_;
									_tmp21_ = c;
									if (_tmp21_ == ((gunichar) '[')) {
										state = STATE_TAG_START;
									} else {
										gsize _tmp22_;
										_tmp22_ = offset;
										offset = _tmp22_ - 1;
										state = STATE_MOVE_TEXT;
										continue;
									}
								}
							}
						}
						break;
					}
					case STATE_MOVE_TEXT:
					{
						gunichar _tmp23_;
						gboolean _tmp24_ = FALSE;
						home_state = STATE_MOVE_TEXT;
						_tmp23_ = c;
						_tmp24_ = g_unichar_isspace (_tmp23_);
						if (_tmp24_) {
						} else {
							gunichar _tmp25_;
							_tmp25_ = c;
							if (_tmp25_ == ((gunichar) ';')) {
								state = STATE_LINE_COMMENT;
							} else {
								gunichar _tmp26_;
								_tmp26_ = c;
								if (_tmp26_ == ((gunichar) '{')) {
									state = STATE_BRACE_COMMENT;
								} else {
									gunichar _tmp27_;
									_tmp27_ = c;
									if (_tmp27_ == ((gunichar) '*')) {
										gint _tmp28_;
										_tmp28_ = rav_level;
										if (_tmp28_ == 0) {
											PGNGame* _tmp29_;
											const gchar* _tmp30_;
											PGNGame* _tmp31_;
											PGNGame* _tmp32_;
											PGNGame* _tmp33_;
											_tmp29_ = game;
											_tmp30_ = pgn_game_RESULT_IN_PROGRESS;
											pgn_game_set_result (_tmp29_, _tmp30_);
											_tmp31_ = game;
											_tmp32_ = _pgn_game_ref0 (_tmp31_);
											self->games = g_list_append (self->games, _tmp32_);
											_tmp33_ = pgn_game_new ();
											_pgn_game_unref0 (game);
											game = _tmp33_;
											state = STATE_TAGS;
										}
									} else {
										gunichar _tmp34_;
										_tmp34_ = c;
										if (_tmp34_ == ((gunichar) '.')) {
											gsize _tmp35_;
											_tmp35_ = offset;
											offset = _tmp35_ - 1;
											state = STATE_PERIOD;
										} else {
											gunichar _tmp36_;
											gboolean _tmp37_ = FALSE;
											_tmp36_ = c;
											_tmp37_ = g_unichar_isalnum (_tmp36_);
											if (_tmp37_) {
												gsize _tmp38_;
												_tmp38_ = offset;
												token_start = _tmp38_;
												state = STATE_SYMBOL;
											} else {
												gunichar _tmp39_;
												_tmp39_ = c;
												if (_tmp39_ == ((gunichar) '$')) {
													gsize _tmp40_;
													_tmp40_ = offset;
													token_start = _tmp40_ + 1;
													state = STATE_NAG;
												} else {
													gunichar _tmp41_;
													_tmp41_ = c;
													if (_tmp41_ == ((gunichar) '(')) {
														gint _tmp42_;
														_tmp42_ = rav_level;
														rav_level = _tmp42_ + 1;
														continue;
													} else {
														gunichar _tmp43_;
														_tmp43_ = c;
														if (_tmp43_ == ((gunichar) ')')) {
															gint _tmp44_;
															_tmp44_ = rav_level;
															if (_tmp44_ == 0) {
																state = STATE_ERROR;
															} else {
																gint _tmp45_;
																_tmp45_ = rav_level;
																rav_level = _tmp45_ - 1;
															}
														} else {
															state = STATE_ERROR;
														}
													}
												}
											}
										}
									}
								}
							}
						}
						break;
					}
					case STATE_LINE_COMMENT:
					{
						gunichar _tmp46_;
						_tmp46_ = c;
						if (_tmp46_ == ((gunichar) '\n')) {
							State _tmp47_;
							_tmp47_ = home_state;
							state = _tmp47_;
						}
						break;
					}
					case STATE_BRACE_COMMENT:
					{
						gunichar _tmp48_;
						_tmp48_ = c;
						if (_tmp48_ == ((gunichar) '}')) {
							State _tmp49_;
							_tmp49_ = home_state;
							state = _tmp49_;
						}
						break;
					}
					case STATE_TAG_START:
					{
						gunichar _tmp50_;
						gboolean _tmp51_ = FALSE;
						_tmp50_ = c;
						_tmp51_ = g_unichar_isspace (_tmp50_);
						if (_tmp51_) {
							continue;
						} else {
							gunichar _tmp52_;
							gboolean _tmp53_ = FALSE;
							_tmp52_ = c;
							_tmp53_ = g_unichar_isalnum (_tmp52_);
							if (_tmp53_) {
								gsize _tmp54_;
								_tmp54_ = offset;
								token_start = _tmp54_;
								state = STATE_TAG_NAME;
							} else {
								state = STATE_ERROR;
							}
						}
						break;
					}
					case STATE_TAG_NAME:
					{
						gunichar _tmp55_;
						gboolean _tmp56_ = FALSE;
						_tmp55_ = c;
						_tmp56_ = g_unichar_isspace (_tmp55_);
						if (_tmp56_) {
							const gchar* _tmp57_;
							gsize _tmp58_;
							gsize _tmp59_;
							gchar* _tmp60_ = NULL;
							_tmp57_ = data;
							_tmp58_ = token_start;
							_tmp59_ = offset;
							_tmp60_ = string_slice (_tmp57_, (glong) _tmp58_, (glong) _tmp59_);
							_g_free0 (tag_name);
							tag_name = _tmp60_;
							state = STATE_PRE_TAG_VALUE;
						} else {
							gboolean _tmp61_ = FALSE;
							gboolean _tmp62_ = FALSE;
							gboolean _tmp63_ = FALSE;
							gboolean _tmp64_ = FALSE;
							gboolean _tmp65_ = FALSE;
							gboolean _tmp66_ = FALSE;
							gunichar _tmp67_;
							gboolean _tmp68_ = FALSE;
							gboolean _tmp70_;
							gboolean _tmp72_;
							gboolean _tmp74_;
							gboolean _tmp76_;
							gboolean _tmp78_;
							gboolean _tmp80_;
							_tmp67_ = c;
							_tmp68_ = g_unichar_isalnum (_tmp67_);
							if (_tmp68_) {
								_tmp66_ = TRUE;
							} else {
								gunichar _tmp69_;
								_tmp69_ = c;
								_tmp66_ = _tmp69_ == ((gunichar) '_');
							}
							_tmp70_ = _tmp66_;
							if (_tmp70_) {
								_tmp65_ = TRUE;
							} else {
								gunichar _tmp71_;
								_tmp71_ = c;
								_tmp65_ = _tmp71_ == ((gunichar) '+');
							}
							_tmp72_ = _tmp65_;
							if (_tmp72_) {
								_tmp64_ = TRUE;
							} else {
								gunichar _tmp73_;
								_tmp73_ = c;
								_tmp64_ = _tmp73_ == ((gunichar) '#');
							}
							_tmp74_ = _tmp64_;
							if (_tmp74_) {
								_tmp63_ = TRUE;
							} else {
								gunichar _tmp75_;
								_tmp75_ = c;
								_tmp63_ = _tmp75_ == ((gunichar) '=');
							}
							_tmp76_ = _tmp63_;
							if (_tmp76_) {
								_tmp62_ = TRUE;
							} else {
								gunichar _tmp77_;
								_tmp77_ = c;
								_tmp62_ = _tmp77_ == ((gunichar) ':');
							}
							_tmp78_ = _tmp62_;
							if (_tmp78_) {
								_tmp61_ = TRUE;
							} else {
								gunichar _tmp79_;
								_tmp79_ = c;
								_tmp61_ = _tmp79_ == ((gunichar) '-');
							}
							_tmp80_ = _tmp61_;
							if (_tmp80_) {
								continue;
							} else {
								state = STATE_ERROR;
							}
						}
						break;
					}
					case STATE_PRE_TAG_VALUE:
					{
						gunichar _tmp81_;
						gboolean _tmp82_ = FALSE;
						_tmp81_ = c;
						_tmp82_ = g_unichar_isspace (_tmp81_);
						if (_tmp82_) {
							continue;
						} else {
							gunichar _tmp83_;
							_tmp83_ = c;
							if (_tmp83_ == ((gunichar) '"')) {
								GString* _tmp84_;
								state = STATE_TAG_VALUE;
								_tmp84_ = tag_value;
								g_string_erase (_tmp84_, (gssize) 0, (gssize) (-1));
								in_escape = FALSE;
							} else {
								state = STATE_ERROR;
							}
						}
						break;
					}
					case STATE_TAG_VALUE:
					{
						gboolean _tmp85_ = FALSE;
						gunichar _tmp86_;
						gboolean _tmp88_;
						_tmp86_ = c;
						if (_tmp86_ == ((gunichar) '\\')) {
							gboolean _tmp87_;
							_tmp87_ = in_escape;
							_tmp85_ = !_tmp87_;
						} else {
							_tmp85_ = FALSE;
						}
						_tmp88_ = _tmp85_;
						if (_tmp88_) {
							in_escape = TRUE;
						} else {
							gboolean _tmp89_ = FALSE;
							gunichar _tmp90_;
							gboolean _tmp92_;
							_tmp90_ = c;
							if (_tmp90_ == ((gunichar) '"')) {
								gboolean _tmp91_;
								_tmp91_ = in_escape;
								_tmp89_ = !_tmp91_;
							} else {
								_tmp89_ = FALSE;
							}
							_tmp92_ = _tmp89_;
							if (_tmp92_) {
								state = STATE_POST_TAG_VALUE;
							} else {
								gunichar _tmp93_;
								gboolean _tmp94_ = FALSE;
								_tmp93_ = c;
								_tmp94_ = g_unichar_isprint (_tmp93_);
								if (_tmp94_) {
									GString* _tmp95_;
									gunichar _tmp96_;
									_tmp95_ = tag_value;
									_tmp96_ = c;
									g_string_append_unichar (_tmp95_, _tmp96_);
									in_escape = FALSE;
								} else {
									state = STATE_ERROR;
								}
							}
						}
						break;
					}
					case STATE_POST_TAG_VALUE:
					{
						gunichar _tmp97_;
						gboolean _tmp98_ = FALSE;
						_tmp97_ = c;
						_tmp98_ = g_unichar_isspace (_tmp97_);
						if (_tmp98_) {
							continue;
						} else {
							gunichar _tmp99_;
							_tmp99_ = c;
							if (_tmp99_ == ((gunichar) ']')) {
								PGNGame* _tmp100_;
								GHashTable* _tmp101_;
								const gchar* _tmp102_;
								gchar* _tmp103_;
								GString* _tmp104_;
								const gchar* _tmp105_;
								gchar* _tmp106_;
								_tmp100_ = game;
								_tmp101_ = _tmp100_->tags;
								_tmp102_ = tag_name;
								_tmp103_ = g_strdup (_tmp102_);
								_tmp104_ = tag_value;
								_tmp105_ = _tmp104_->str;
								_tmp106_ = g_strdup (_tmp105_);
								g_hash_table_insert (_tmp101_, _tmp103_, _tmp106_);
								state = STATE_TAGS;
							} else {
								state = STATE_ERROR;
							}
						}
						break;
					}
					case STATE_SYMBOL:
					{
						gboolean _tmp107_ = FALSE;
						gboolean _tmp108_ = FALSE;
						gboolean _tmp109_ = FALSE;
						gboolean _tmp110_ = FALSE;
						gboolean _tmp111_ = FALSE;
						gboolean _tmp112_ = FALSE;
						gboolean _tmp113_ = FALSE;
						gunichar _tmp114_;
						gboolean _tmp115_ = FALSE;
						gboolean _tmp117_;
						gboolean _tmp119_;
						gboolean _tmp121_;
						gboolean _tmp123_;
						gboolean _tmp125_;
						gboolean _tmp127_;
						gboolean _tmp129_;
						_tmp114_ = c;
						_tmp115_ = g_unichar_isalnum (_tmp114_);
						if (_tmp115_) {
							_tmp113_ = TRUE;
						} else {
							gunichar _tmp116_;
							_tmp116_ = c;
							_tmp113_ = _tmp116_ == ((gunichar) '_');
						}
						_tmp117_ = _tmp113_;
						if (_tmp117_) {
							_tmp112_ = TRUE;
						} else {
							gunichar _tmp118_;
							_tmp118_ = c;
							_tmp112_ = _tmp118_ == ((gunichar) '+');
						}
						_tmp119_ = _tmp112_;
						if (_tmp119_) {
							_tmp111_ = TRUE;
						} else {
							gunichar _tmp120_;
							_tmp120_ = c;
							_tmp111_ = _tmp120_ == ((gunichar) '#');
						}
						_tmp121_ = _tmp111_;
						if (_tmp121_) {
							_tmp110_ = TRUE;
						} else {
							gunichar _tmp122_;
							_tmp122_ = c;
							_tmp110_ = _tmp122_ == ((gunichar) '=');
						}
						_tmp123_ = _tmp110_;
						if (_tmp123_) {
							_tmp109_ = TRUE;
						} else {
							gunichar _tmp124_;
							_tmp124_ = c;
							_tmp109_ = _tmp124_ == ((gunichar) ':');
						}
						_tmp125_ = _tmp109_;
						if (_tmp125_) {
							_tmp108_ = TRUE;
						} else {
							gunichar _tmp126_;
							_tmp126_ = c;
							_tmp108_ = _tmp126_ == ((gunichar) '-');
						}
						_tmp127_ = _tmp108_;
						if (_tmp127_) {
							_tmp107_ = TRUE;
						} else {
							gunichar _tmp128_;
							_tmp128_ = c;
							_tmp107_ = _tmp128_ == ((gunichar) '/');
						}
						_tmp129_ = _tmp107_;
						if (_tmp129_) {
							continue;
						} else {
							const gchar* _tmp130_;
							gsize _tmp131_;
							gsize _tmp132_;
							gchar* _tmp133_ = NULL;
							gchar* symbol;
							gboolean is_number;
							gsize _tmp145_;
							gboolean _tmp146_ = FALSE;
							gboolean _tmp147_ = FALSE;
							const gchar* _tmp148_;
							const gchar* _tmp149_;
							gboolean _tmp152_;
							gboolean _tmp155_;
							_tmp130_ = data;
							_tmp131_ = token_start;
							_tmp132_ = offset;
							_tmp133_ = string_slice (_tmp130_, (glong) _tmp131_, (glong) _tmp132_);
							symbol = _tmp133_;
							is_number = TRUE;
							{
								gint i;
								i = 0;
								{
									gboolean _tmp134_;
									_tmp134_ = TRUE;
									while (TRUE) {
										gboolean _tmp135_;
										gint _tmp137_;
										const gchar* _tmp138_;
										gint _tmp139_;
										gint _tmp140_;
										const gchar* _tmp141_;
										gint _tmp142_;
										gchar _tmp143_ = '\0';
										gboolean _tmp144_ = FALSE;
										_tmp135_ = _tmp134_;
										if (!_tmp135_) {
											gint _tmp136_;
											_tmp136_ = i;
											i = _tmp136_ + 1;
										}
										_tmp134_ = FALSE;
										_tmp137_ = i;
										_tmp138_ = symbol;
										_tmp139_ = strlen (_tmp138_);
										_tmp140_ = _tmp139_;
										if (!(_tmp137_ < _tmp140_)) {
											break;
										}
										_tmp141_ = symbol;
										_tmp142_ = i;
										_tmp143_ = string_get (_tmp141_, (glong) _tmp142_);
										_tmp144_ = g_ascii_isdigit (_tmp143_);
										if (!_tmp144_) {
											is_number = FALSE;
										}
									}
								}
							}
							state = STATE_MOVE_TEXT;
							_tmp145_ = offset;
							offset = _tmp145_ - 1;
							_tmp148_ = symbol;
							_tmp149_ = pgn_game_RESULT_DRAW;
							if (g_strcmp0 (_tmp148_, _tmp149_) == 0) {
								_tmp147_ = TRUE;
							} else {
								const gchar* _tmp150_;
								const gchar* _tmp151_;
								_tmp150_ = symbol;
								_tmp151_ = pgn_game_RESULT_WHITE;
								_tmp147_ = g_strcmp0 (_tmp150_, _tmp151_) == 0;
							}
							_tmp152_ = _tmp147_;
							if (_tmp152_) {
								_tmp146_ = TRUE;
							} else {
								const gchar* _tmp153_;
								const gchar* _tmp154_;
								_tmp153_ = symbol;
								_tmp154_ = pgn_game_RESULT_BLACK;
								_tmp146_ = g_strcmp0 (_tmp153_, _tmp154_) == 0;
							}
							_tmp155_ = _tmp146_;
							if (_tmp155_) {
								gint _tmp156_;
								_tmp156_ = rav_level;
								if (_tmp156_ == 0) {
									PGNGame* _tmp157_;
									const gchar* _tmp158_;
									PGNGame* _tmp159_;
									PGNGame* _tmp160_;
									PGNGame* _tmp161_;
									_tmp157_ = game;
									_tmp158_ = symbol;
									pgn_game_set_result (_tmp157_, _tmp158_);
									_tmp159_ = game;
									_tmp160_ = _pgn_game_ref0 (_tmp159_);
									self->games = g_list_append (self->games, _tmp160_);
									_tmp161_ = pgn_game_new ();
									_pgn_game_unref0 (game);
									game = _tmp161_;
									state = STATE_TAGS;
								}
							} else {
								gboolean _tmp162_;
								_tmp162_ = is_number;
								if (!_tmp162_) {
									gint _tmp163_;
									_tmp163_ = rav_level;
									if (_tmp163_ == 0) {
										PGNGame* _tmp164_;
										const gchar* _tmp165_;
										gchar* _tmp166_;
										_tmp164_ = game;
										_tmp165_ = symbol;
										_tmp166_ = g_strdup (_tmp165_);
										_tmp164_->moves = g_list_append (_tmp164_->moves, _tmp166_);
									}
								}
							}
							_g_free0 (symbol);
						}
						break;
					}
					case STATE_PERIOD:
					{
						state = STATE_MOVE_TEXT;
						break;
					}
					case STATE_NAG:
					{
						gunichar _tmp167_;
						gboolean _tmp168_ = FALSE;
						_tmp167_ = c;
						_tmp168_ = g_unichar_isdigit (_tmp167_);
						if (_tmp168_) {
							continue;
						} else {
							gsize _tmp169_;
							state = STATE_MOVE_TEXT;
							_tmp169_ = offset;
							offset = _tmp169_ - 1;
						}
						break;
					}
					case STATE_ERROR:
					{
						gsize _tmp170_;
						gsize _tmp171_;
						gsize char_offset;
						FILE* _tmp172_;
						gint _tmp173_;
						gsize _tmp174_;
						FILE* _tmp175_;
						const gchar* _tmp176_;
						gsize _tmp177_;
						gsize _tmp178_;
						gchar* _tmp179_ = NULL;
						gchar* _tmp180_;
						FILE* _tmp187_;
						_tmp170_ = offset;
						_tmp171_ = line_offset;
						char_offset = (_tmp170_ - _tmp171_) - 1;
						_tmp172_ = stderr;
						_tmp173_ = line;
						_tmp174_ = char_offset;
						fprintf (_tmp172_, "%d.%d: error: Unexpected character\n", _tmp173_, (gint) (_tmp174_ + 1));
						_tmp175_ = stderr;
						_tmp176_ = data;
						_tmp177_ = line_offset;
						_tmp178_ = offset;
						_tmp179_ = string_slice (_tmp176_, (glong) _tmp177_, (glong) _tmp178_);
						_tmp180_ = _tmp179_;
						fprintf (_tmp175_, "%s\n", _tmp180_);
						_g_free0 (_tmp180_);
						{
							gint i;
							i = 0;
							{
								gboolean _tmp181_;
								_tmp181_ = TRUE;
								while (TRUE) {
									gboolean _tmp182_;
									gint _tmp184_;
									gsize _tmp185_;
									FILE* _tmp186_;
									_tmp182_ = _tmp181_;
									if (!_tmp182_) {
										gint _tmp183_;
										_tmp183_ = i;
										i = _tmp183_ + 1;
									}
									_tmp181_ = FALSE;
									_tmp184_ = i;
									_tmp185_ = char_offset;
									if (!(((gsize) _tmp184_) < _tmp185_)) {
										break;
									}
									_tmp186_ = stderr;
									fprintf (_tmp186_, " ");
								}
							}
						}
						_tmp187_ = stderr;
						fprintf (_tmp187_, "^\n");
						_g_string_free0 (tag_value);
						_g_free0 (tag_name);
						_pgn_game_unref0 (game);
						return self;
					}
					default:
					break;
				}
			}
		}
	}
	_tmp189_ = game;
	_tmp190_ = _tmp189_->moves;
	_tmp191_ = g_list_length (_tmp190_);
	if (_tmp191_ > ((guint) 0)) {
		_tmp188_ = TRUE;
	} else {
		PGNGame* _tmp192_;
		GHashTable* _tmp193_;
		guint _tmp194_ = 0U;
		_tmp192_ = game;
		_tmp193_ = _tmp192_->tags;
		_tmp194_ = g_hash_table_size (_tmp193_);
		_tmp188_ = _tmp194_ > ((guint) 0);
	}
	_tmp195_ = _tmp188_;
	if (_tmp195_) {
		PGNGame* _tmp196_;
		PGNGame* _tmp197_;
		_tmp196_ = game;
		_tmp197_ = _pgn_game_ref0 (_tmp196_);
		self->games = g_list_append (self->games, _tmp197_);
	}
	_tmp198_ = self->games;
	if (_tmp198_ == NULL) {
		GError* _tmp199_;
		_tmp199_ = g_error_new_literal (PGN_ERROR, PGN_ERROR_LOAD_ERROR, "No games in PGN file");
		_inner_error_ = _tmp199_;
		if (_inner_error_->domain == PGN_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (tag_value);
			_g_free0 (tag_name);
			_pgn_game_unref0 (game);
			_pgn_unref0 (self);
			return NULL;
		} else {
			_g_string_free0 (tag_value);
			_g_free0 (tag_name);
			_pgn_game_unref0 (game);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_string_free0 (tag_value);
	_g_free0 (tag_name);
	_pgn_game_unref0 (game);
	return self;
}


PGN* pgn_new_from_string (const gchar* data, GError** error) {
	return pgn_construct_from_string (TYPE_PGN, data, error);
}


PGN* pgn_construct_from_file (GType object_type, GFile* file, GError** error) {
	PGN* self = NULL;
	guint8* contents = NULL;
	gint contents_length1 = 0;
	gint _contents_size_ = 0;
	GFile* _tmp0_;
	guint8* _tmp1_ = NULL;
	gsize _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = file;
	g_file_load_contents (_tmp0_, NULL, &_tmp1_, &_tmp2_, NULL, &_inner_error_);
	contents = (g_free (contents), NULL);
	contents = _tmp1_;
	contents_length1 = _tmp2_;
	_contents_size_ = contents_length1;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		contents = (g_free (contents), NULL);
		_pgn_unref0 (self);
		return NULL;
	}
	_tmp3_ = contents;
	_tmp3__length1 = contents_length1;
	self = (PGN*) pgn_construct_from_string (object_type, (const gchar*) _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		contents = (g_free (contents), NULL);
		_pgn_unref0 (self);
		return NULL;
	}
	contents = (g_free (contents), NULL);
	return self;
}


PGN* pgn_new_from_file (GFile* file, GError** error) {
	return pgn_construct_from_file (TYPE_PGN, file, error);
}


static void value_pgn_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_pgn_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		pgn_unref (value->data[0].v_pointer);
	}
}


static void value_pgn_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pgn_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_pgn_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_pgn_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PGN* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pgn_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_pgn_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PGN** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pgn_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_pgn (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPGN* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PGN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_pgn (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PGN), NULL);
	return value->data[0].v_pointer;
}


void value_set_pgn (GValue* value, gpointer v_object) {
	PGN* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PGN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PGN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pgn_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pgn_unref (old);
	}
}


void value_take_pgn (GValue* value, gpointer v_object) {
	PGN* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PGN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PGN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pgn_unref (old);
	}
}


static void pgn_class_init (PGNClass * klass) {
	pgn_parent_class = g_type_class_peek_parent (klass);
	PGN_CLASS (klass)->finalize = pgn_finalize;
}


static void pgn_instance_init (PGN * self) {
	self->ref_count = 1;
}


static void pgn_finalize (PGN* obj) {
	PGN * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PGN, PGN);
	__g_list_free__pgn_game_unref0_0 (self->games);
}


GType pgn_get_type (void) {
	static volatile gsize pgn_type_id__volatile = 0;
	if (g_once_init_enter (&pgn_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pgn_init, value_pgn_free_value, value_pgn_copy_value, value_pgn_peek_pointer, "p", value_pgn_collect_value, "p", value_pgn_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PGNClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pgn_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PGN), 0, (GInstanceInitFunc) pgn_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pgn_type_id;
		pgn_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PGN", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pgn_type_id__volatile, pgn_type_id);
	}
	return pgn_type_id__volatile;
}


gpointer pgn_ref (gpointer instance) {
	PGN* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void pgn_unref (gpointer instance) {
	PGN* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PGN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



