/* rygel-root-device-factory.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-root-device-factory.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2007 OpenedHand Ltd.
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Authors: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                                <zeeshan.ali@nokia.com>
 *          Jorn Baayen <jorn@openedhand.com>
 *          Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <config.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <libgssdp/gssdp.h>
#include <uuid/uuid.h>


#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;
typedef struct _RygelRootDeviceFactoryPrivate RygelRootDeviceFactoryPrivate;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_DESCRIPTION_FILE (rygel_description_file_get_type ())
#define RYGEL_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile))
#define RYGEL_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))
#define RYGEL_IS_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_IS_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_DESCRIPTION_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))

typedef struct _RygelDescriptionFile RygelDescriptionFile;
typedef struct _RygelDescriptionFileClass RygelDescriptionFileClass;

#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;

typedef enum  {
	ROOT_DEVICE_FACTORY_ERROR_XML_PARSE
} RootDeviceFactoryError;
#define ROOT_DEVICE_FACTORY_ERROR root_device_factory_error_quark ()
struct _RygelRootDeviceFactory {
	GObject parent_instance;
	RygelRootDeviceFactoryPrivate * priv;
};

struct _RygelRootDeviceFactoryClass {
	GObjectClass parent_class;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelRootDeviceFactoryPrivate {
	GUPnPContext* _context;
	RygelConfiguration* config;
	gchar* desc_dir;
};

typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4
} RygelPluginCapabilities;

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};


static gpointer rygel_root_device_factory_parent_class = NULL;
static GInitableIface* rygel_root_device_factory_g_initable_parent_iface = NULL;

GQuark root_device_factory_error_quark (void);
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
#define RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryPrivate))
enum  {
	RYGEL_ROOT_DEVICE_FACTORY_DUMMY_PROPERTY,
	RYGEL_ROOT_DEVICE_FACTORY_CONTEXT
};
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
static gboolean rygel_root_device_factory_real_init (GInitable* base, GCancellable* cancellable, GError** error);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const gchar* dir_path, GError** error);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
const gchar* rygel_plugin_get_name (RygelPlugin* self);
const gchar* rygel_plugin_get_desc_path (RygelPlugin* self);
static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const gchar* desc_path, const gchar* template_path, GError** error);
GUPnPContext* rygel_root_device_factory_get_context (RygelRootDeviceFactory* self);
RygelRootDevice* rygel_root_device_new (GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
RygelRootDevice* rygel_root_device_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
void rygel_plugin_apply_hacks (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
static GUPnPXMLDoc* rygel_root_device_factory_get_latest_doc (RygelRootDeviceFactory* self, const gchar* path1, const gchar* path2, GError** error);
static void rygel_root_device_factory_prepare_desc_for_plugin (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, RygelPlugin* plugin);
RygelDescriptionFile* rygel_description_file_new_from_xml_document (GUPnPXMLDoc* doc);
RygelDescriptionFile* rygel_description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc);
GType rygel_description_file_get_type (void) G_GNUC_CONST;
GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
void rygel_description_file_set_dlna_caps (RygelDescriptionFile* self, RygelPluginCapabilities capabilities);
RygelPluginCapabilities rygel_plugin_get_capabilities (RygelPlugin* self);
void rygel_description_file_save (RygelDescriptionFile* self, const gchar* path, GError** error);
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
static void rygel_root_device_factory_set_friendly_name_and_udn (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* plugin_name, const gchar* plugin_title);
const gchar* rygel_plugin_get_title (RygelPlugin* self);
const gchar* rygel_plugin_get_description (RygelPlugin* self);
static void rygel_root_device_factory_set_description (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* description);
static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin);
static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin);
gchar* rygel_configuration_get_title (RygelConfiguration* self, const gchar* section, GError** error);
static gchar* rygel_root_device_factory_generate_random_udn (RygelRootDeviceFactory* self);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_plugin_get_resource_infos (RygelPlugin* self);
static void rygel_root_device_factory_add_service_to_desc (RygelRootDeviceFactory* self, xmlNode* service_list_node, const gchar* plugin_name, RygelResourceInfo* resource_info);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_plugin_get_icon_infos (RygelPlugin* self);
GeeArrayList* rygel_plugin_get_default_icons (RygelPlugin* self);
static void rygel_root_device_factory_add_icon_to_desc (RygelRootDeviceFactory* self, xmlNode* icon_list_node, RygelIconInfo* icon_info, RygelPlugin* plugin);
static void rygel_root_device_factory_set_context (RygelRootDeviceFactory* self, GUPnPContext* value);
static void rygel_root_device_factory_finalize (GObject* obj);
static void _vala_rygel_root_device_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_root_device_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark root_device_factory_error_quark (void) {
	return g_quark_from_static_string ("root_device_factory_error-quark");
}


RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error) {
	RygelRootDeviceFactory * self = NULL;
	GUPnPContext* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = context;
	self = (RygelRootDeviceFactory*) g_object_new (object_type, "context", _tmp0_, NULL);
	g_initable_init ((GInitable*) self, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error) {
	return rygel_root_device_factory_construct (RYGEL_TYPE_ROOT_DEVICE_FACTORY, context, error);
}


static gboolean rygel_root_device_factory_real_init (GInitable* base, GCancellable* cancellable, GError** error) {
	RygelRootDeviceFactory * self;
	gboolean result = FALSE;
	RygelConfiguration* _tmp0_;
	RygelMetaConfig* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* config_dir;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (RygelRootDeviceFactory*) base;
	_tmp0_ = self->priv->config;
	if (_tmp0_ != NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->config);
	self->priv->config = (RygelConfiguration*) _tmp1_;
	_tmp2_ = g_get_user_config_dir ();
	_tmp3_ = g_strdup (_tmp2_);
	config_dir = _tmp3_;
	_tmp4_ = config_dir;
	rygel_root_device_factory_ensure_dir_exists (self, _tmp4_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (config_dir);
		return FALSE;
	}
	_tmp5_ = config_dir;
	_tmp6_ = g_get_application_name ();
	_tmp7_ = g_build_filename (_tmp5_, _tmp6_, NULL);
	_g_free0 (self->priv->desc_dir);
	self->priv->desc_dir = _tmp7_;
	_tmp8_ = self->priv->desc_dir;
	rygel_root_device_factory_ensure_dir_exists (self, _tmp8_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (config_dir);
		return FALSE;
	}
	result = TRUE;
	_g_free0 (config_dir);
	return result;
}


RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error) {
	RygelRootDevice* result = NULL;
	const gchar* _tmp0_;
	RygelPlugin* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* desc_path;
	RygelPlugin* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* template_path;
	RygelPlugin* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GUPnPXMLDoc* _tmp15_ = NULL;
	GUPnPXMLDoc* doc;
	GUPnPContext* _tmp16_;
	RygelPlugin* _tmp17_;
	GUPnPXMLDoc* _tmp18_;
	const gchar* _tmp19_;
	RygelRootDevice* _tmp20_;
	RygelRootDevice* device;
	RygelPlugin* _tmp21_;
	RygelRootDevice* _tmp22_;
	const gchar* _tmp23_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	_tmp0_ = self->priv->desc_dir;
	_tmp1_ = plugin;
	_tmp2_ = rygel_plugin_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ".xml", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_filename (_tmp0_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	desc_path = _tmp7_;
	_tmp8_ = plugin;
	_tmp9_ = rygel_plugin_get_desc_path (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup (_tmp10_);
	template_path = _tmp11_;
	_tmp12_ = plugin;
	_tmp13_ = desc_path;
	_tmp14_ = template_path;
	_tmp15_ = rygel_root_device_factory_create_desc (self, _tmp12_, _tmp13_, _tmp14_, &_inner_error_);
	doc = _tmp15_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (template_path);
		_g_free0 (desc_path);
		return NULL;
	}
	_tmp16_ = self->priv->_context;
	_tmp17_ = plugin;
	_tmp18_ = doc;
	_tmp19_ = desc_path;
	_tmp20_ = rygel_root_device_new (_tmp16_, _tmp17_, _tmp18_, _tmp19_, DATA_DIR);
	device = _tmp20_;
	_tmp21_ = plugin;
	_tmp22_ = device;
	_tmp23_ = desc_path;
	rygel_plugin_apply_hacks (_tmp21_, _tmp22_, _tmp23_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (device);
		_g_object_unref0 (doc);
		_g_free0 (template_path);
		_g_free0 (desc_path);
		return NULL;
	}
	result = device;
	_g_object_unref0 (doc);
	_g_free0 (template_path);
	_g_free0 (desc_path);
	return result;
}


static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const gchar* desc_path, const gchar* template_path, GError** error) {
	GUPnPXMLDoc* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GUPnPXMLDoc* _tmp2_ = NULL;
	GUPnPXMLDoc* doc;
	GUPnPXMLDoc* _tmp3_;
	RygelPlugin* _tmp4_;
	GUPnPXMLDoc* _tmp5_;
	RygelDescriptionFile* _tmp6_;
	RygelDescriptionFile* file;
	RygelDescriptionFile* _tmp7_;
	RygelPlugin* _tmp8_;
	RygelPluginCapabilities _tmp9_;
	RygelPluginCapabilities _tmp10_;
	RygelDescriptionFile* _tmp11_;
	const gchar* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	g_return_val_if_fail (desc_path != NULL, NULL);
	g_return_val_if_fail (template_path != NULL, NULL);
	_tmp0_ = desc_path;
	_tmp1_ = template_path;
	_tmp2_ = rygel_root_device_factory_get_latest_doc (self, _tmp0_, _tmp1_, &_inner_error_);
	doc = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = doc;
	_tmp4_ = plugin;
	rygel_root_device_factory_prepare_desc_for_plugin (self, _tmp3_, _tmp4_);
	_tmp5_ = doc;
	_tmp6_ = rygel_description_file_new_from_xml_document (_tmp5_);
	file = _tmp6_;
	_tmp7_ = file;
	_tmp8_ = plugin;
	_tmp9_ = rygel_plugin_get_capabilities (_tmp8_);
	_tmp10_ = _tmp9_;
	rygel_description_file_set_dlna_caps (_tmp7_, _tmp10_);
	_tmp11_ = file;
	_tmp12_ = desc_path;
	rygel_description_file_save (_tmp11_, _tmp12_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		_g_object_unref0 (doc);
		return NULL;
	}
	result = doc;
	_g_object_unref0 (file);
	return result;
}


static void rygel_root_device_factory_prepare_desc_for_plugin (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, RygelPlugin* plugin) {
	xmlNode* device_element = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_ = NULL;
	xmlNode* _tmp3_;
	xmlNode* _tmp5_;
	RygelPlugin* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	RygelPlugin* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	RygelPlugin* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	xmlNode* _tmp19_;
	RygelPlugin* _tmp20_;
	xmlNode* _tmp21_;
	RygelPlugin* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", NULL, NULL);
	device_element = _tmp2_;
	_tmp3_ = device_element;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = _ ("XML node '%s' not found.");
		g_warning (_tmp4_, "/root/device");
		return;
	}
	_tmp5_ = device_element;
	_tmp6_ = plugin;
	_tmp7_ = rygel_plugin_get_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = plugin;
	_tmp10_ = rygel_plugin_get_title (_tmp9_);
	_tmp11_ = _tmp10_;
	rygel_root_device_factory_set_friendly_name_and_udn (self, _tmp5_, _tmp8_, _tmp11_);
	_tmp12_ = plugin;
	_tmp13_ = rygel_plugin_get_description (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		xmlNode* _tmp15_;
		RygelPlugin* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp15_ = device_element;
		_tmp16_ = plugin;
		_tmp17_ = rygel_plugin_get_description (_tmp16_);
		_tmp18_ = _tmp17_;
		rygel_root_device_factory_set_description (self, _tmp15_, _tmp18_);
	}
	_tmp19_ = device_element;
	_tmp20_ = plugin;
	rygel_root_device_factory_add_icons_to_desc (self, _tmp19_, _tmp20_);
	_tmp21_ = device_element;
	_tmp22_ = plugin;
	rygel_root_device_factory_add_services_to_desc (self, _tmp21_, _tmp22_);
}


/**
     * Fills the description doc @doc with a friendly name, and UDN from gconf.
     * If these keys are not present in gconf, they are set with default values.
     */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void rygel_root_device_factory_set_friendly_name_and_udn (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* plugin_name, const gchar* plugin_title) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* element;
	xmlNode* _tmp2_;
	gchar* title = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	xmlNode* _tmp19_;
	const gchar* _tmp20_;
	xmlNode* _tmp21_;
	xmlNode* _tmp22_ = NULL;
	xmlNode* _tmp23_;
	xmlNode* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* udn;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_;
	gboolean _tmp30_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_name != NULL);
	g_return_if_fail (plugin_title != NULL);
	_tmp0_ = device_element;
	_tmp1_ = rygel_xml_utils_get_element (_tmp0_, "friendlyName", NULL, NULL);
	element = _tmp1_;
	_tmp2_ = element;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _ ("XML node '%s' not found.");
		g_warning (_tmp3_, "/root/device/friendlyName");
		return;
	}
	{
		RygelConfiguration* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp4_ = self->priv->config;
		_tmp5_ = plugin_name;
		_tmp6_ = rygel_configuration_get_title (_tmp4_, _tmp5_, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_g_free0 (title);
		title = _tmp7_;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = plugin_title;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (title);
		title = _tmp9_;
		_g_error_free0 (err);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (title);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = title;
	_tmp11_ = g_get_real_name ();
	_tmp12_ = string_replace (_tmp10_, "@REALNAME@", _tmp11_);
	_g_free0 (title);
	title = _tmp12_;
	_tmp13_ = title;
	_tmp14_ = g_get_user_name ();
	_tmp15_ = string_replace (_tmp13_, "@USERNAME@", _tmp14_);
	_g_free0 (title);
	title = _tmp15_;
	_tmp16_ = title;
	_tmp17_ = g_get_host_name ();
	_tmp18_ = string_replace (_tmp16_, "@HOSTNAME@", _tmp17_);
	_g_free0 (title);
	title = _tmp18_;
	_tmp19_ = element;
	_tmp20_ = title;
	xmlNodeSetContent (_tmp19_, _tmp20_);
	_tmp21_ = device_element;
	_tmp22_ = rygel_xml_utils_get_element (_tmp21_, "UDN", NULL);
	element = _tmp22_;
	_tmp23_ = element;
	if (_tmp23_ == NULL) {
		const gchar* _tmp24_ = NULL;
		_tmp24_ = _ ("XML node '%s' not found.");
		g_warning (_tmp24_, "/root/device/UDN");
		_g_free0 (title);
		return;
	}
	_tmp25_ = element;
	_tmp26_ = xmlNodeGetContent (_tmp25_);
	udn = _tmp26_;
	_tmp28_ = udn;
	if (_tmp28_ == NULL) {
		_tmp27_ = TRUE;
	} else {
		const gchar* _tmp29_;
		_tmp29_ = udn;
		_tmp27_ = g_strcmp0 (_tmp29_, "") == 0;
	}
	_tmp30_ = _tmp27_;
	if (_tmp30_) {
		gchar* _tmp31_ = NULL;
		xmlNode* _tmp32_;
		const gchar* _tmp33_;
		_tmp31_ = rygel_root_device_factory_generate_random_udn (self);
		_g_free0 (udn);
		udn = _tmp31_;
		_tmp32_ = element;
		_tmp33_ = udn;
		xmlNodeSetContent (_tmp32_, _tmp33_);
	}
	_g_free0 (udn);
	_g_free0 (title);
}


static void rygel_root_device_factory_set_description (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* description) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* element;
	xmlNode* _tmp2_;
	xmlNode* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (description != NULL);
	_tmp0_ = device_element;
	_tmp1_ = rygel_xml_utils_get_element (_tmp0_, "modelDescription", NULL, NULL);
	element = _tmp1_;
	_tmp2_ = element;
	if (_tmp2_ == NULL) {
		xmlNode* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = device_element;
		_tmp4_ = description;
		xmlNewChild (_tmp3_, NULL, "modelDescription", _tmp4_);
	}
	_tmp5_ = element;
	_tmp6_ = description;
	xmlNodeSetContent (_tmp5_, _tmp6_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* service_list_node;
	xmlNode* _tmp2_;
	xmlNode* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = device_element;
	_tmp1_ = rygel_xml_utils_get_element (_tmp0_, "serviceList", NULL, NULL);
	service_list_node = _tmp1_;
	_tmp2_ = service_list_node;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _ ("XML node '%s' not found.");
		g_warning (_tmp3_, "/root/device/serviceList");
		return;
	}
	_tmp4_ = service_list_node;
	xmlNodeSetContent (_tmp4_, "");
	{
		RygelPlugin* _tmp5_;
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
		GeeArrayList* _resource_info_list;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _resource_info_size;
		gint _resource_info_index;
		_tmp5_ = plugin;
		_tmp6_ = rygel_plugin_get_resource_infos (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_resource_info_list = _tmp8_;
		_tmp9_ = _resource_info_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_resource_info_size = _tmp11_;
		_resource_info_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			GeeArrayList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_ = NULL;
			RygelResourceInfo* resource_info;
			RygelResourceInfo* _tmp18_;
			GType _tmp19_;
			gboolean _tmp20_ = FALSE;
			_tmp12_ = _resource_info_index;
			_resource_info_index = _tmp12_ + 1;
			_tmp13_ = _resource_info_index;
			_tmp14_ = _resource_info_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _resource_info_list;
			_tmp16_ = _resource_info_index;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
			resource_info = (RygelResourceInfo*) _tmp17_;
			_tmp18_ = resource_info;
			_tmp19_ = _tmp18_->type;
			_tmp20_ = g_type_is_a (_tmp19_, gupnp_service_get_type ());
			if (_tmp20_) {
				xmlNode* _tmp21_;
				RygelPlugin* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				RygelResourceInfo* _tmp25_;
				_tmp21_ = service_list_node;
				_tmp22_ = plugin;
				_tmp23_ = rygel_plugin_get_name (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = resource_info;
				rygel_root_device_factory_add_service_to_desc (self, _tmp21_, _tmp24_, _tmp25_);
			}
			_rygel_resource_info_unref0 (resource_info);
		}
		_g_object_unref0 (_resource_info_list);
	}
}


static void rygel_root_device_factory_add_service_to_desc (RygelRootDeviceFactory* self, xmlNode* service_list_node, const gchar* plugin_name, RygelResourceInfo* resource_info) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* service_node;
	RygelResourceInfo* _tmp2_;
	const gchar* _tmp3_;
	RygelResourceInfo* _tmp4_;
	const gchar* _tmp5_;
	RygelResourceInfo* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* url;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	RygelResourceInfo* _tmp15_;
	GType _tmp16_;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	RygelResourceInfo* _tmp25_;
	GType _tmp26_;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_name != NULL);
	g_return_if_fail (resource_info != NULL);
	_tmp0_ = service_list_node;
	_tmp1_ = xmlNewChild (_tmp0_, NULL, "service", NULL);
	service_node = _tmp1_;
	_tmp2_ = resource_info;
	_tmp3_ = _tmp2_->upnp_type;
	xmlNewChild (service_node, NULL, "serviceType", _tmp3_);
	_tmp4_ = resource_info;
	_tmp5_ = _tmp4_->upnp_id;
	xmlNewChild (service_node, NULL, "serviceId", _tmp5_);
	_tmp6_ = resource_info;
	_tmp7_ = _tmp6_->description_path;
	_tmp8_ = g_strconcat ("/", _tmp7_, NULL);
	url = _tmp8_;
	_tmp9_ = url;
	xmlNewChild (service_node, NULL, "SCPDURL", _tmp9_);
	_tmp10_ = plugin_name;
	_tmp11_ = g_strconcat ("/Event/", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, "/", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = resource_info;
	_tmp16_ = _tmp15_->type;
	_tmp17_ = g_type_name (_tmp16_);
	_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
	_g_free0 (url);
	url = _tmp18_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp19_ = url;
	xmlNewChild (service_node, NULL, "eventSubURL", _tmp19_);
	_tmp20_ = plugin_name;
	_tmp21_ = g_strconcat ("/Control/", _tmp20_, NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat (_tmp22_, "/", NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = resource_info;
	_tmp26_ = _tmp25_->type;
	_tmp27_ = g_type_name (_tmp26_);
	_tmp28_ = g_strconcat (_tmp24_, _tmp27_, NULL);
	_g_free0 (url);
	url = _tmp28_;
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	_tmp29_ = url;
	xmlNewChild (service_node, NULL, "controlURL", _tmp29_);
	_g_free0 (url);
}


static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin) {
	RygelPlugin* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* icons;
	gboolean _tmp4_ = FALSE;
	GeeArrayList* _tmp5_;
	gboolean _tmp9_;
	xmlNode* _tmp17_;
	xmlNode* _tmp18_ = NULL;
	xmlNode* icon_list_node;
	xmlNode* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = plugin;
	_tmp1_ = rygel_plugin_get_icon_infos (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	icons = _tmp3_;
	_tmp5_ = icons;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = icons;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ == 0;
	}
	_tmp9_ = _tmp4_;
	if (_tmp9_) {
		RygelPlugin* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		RygelPlugin* _tmp13_;
		GeeArrayList* _tmp14_;
		GeeArrayList* _tmp15_;
		GeeArrayList* _tmp16_;
		_tmp10_ = plugin;
		_tmp11_ = rygel_plugin_get_name (_tmp10_);
		_tmp12_ = _tmp11_;
		g_debug ("rygel-root-device-factory.vala:242: No icon provided by plugin '%s'. U" \
"sing Rygel logo.", _tmp12_);
		_tmp13_ = plugin;
		_tmp14_ = rygel_plugin_get_default_icons (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		_g_object_unref0 (icons);
		icons = _tmp16_;
	}
	_tmp17_ = device_element;
	_tmp18_ = rygel_xml_utils_get_element (_tmp17_, "iconList", NULL, NULL);
	icon_list_node = _tmp18_;
	_tmp19_ = icon_list_node;
	if (_tmp19_ == NULL) {
		xmlNode* _tmp20_;
		xmlNode* _tmp21_ = NULL;
		_tmp20_ = device_element;
		_tmp21_ = xmlNewChild (_tmp20_, NULL, "iconList", NULL);
		icon_list_node = _tmp21_;
	} else {
		xmlNode* _tmp22_;
		_tmp22_ = icon_list_node;
		xmlNodeSetContent (_tmp22_, "");
	}
	{
		GeeArrayList* _tmp23_;
		GeeArrayList* _tmp24_;
		GeeArrayList* _icon_list;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _icon_size;
		gint _icon_index;
		_tmp23_ = icons;
		_tmp24_ = _g_object_ref0 (_tmp23_);
		_icon_list = _tmp24_;
		_tmp25_ = _icon_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_icon_size = _tmp27_;
		_icon_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			GeeArrayList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_ = NULL;
			RygelIconInfo* icon;
			xmlNode* _tmp34_;
			RygelIconInfo* _tmp35_;
			RygelPlugin* _tmp36_;
			_tmp28_ = _icon_index;
			_icon_index = _tmp28_ + 1;
			_tmp29_ = _icon_index;
			_tmp30_ = _icon_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _icon_list;
			_tmp32_ = _icon_index;
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
			icon = (RygelIconInfo*) _tmp33_;
			_tmp34_ = icon_list_node;
			_tmp35_ = icon;
			_tmp36_ = plugin;
			rygel_root_device_factory_add_icon_to_desc (self, _tmp34_, _tmp35_, _tmp36_);
			_rygel_icon_info_unref0 (icon);
		}
		_g_object_unref0 (_icon_list);
	}
	_g_object_unref0 (icons);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void rygel_root_device_factory_add_icon_to_desc (RygelRootDeviceFactory* self, xmlNode* icon_list_node, RygelIconInfo* icon_info, RygelPlugin* plugin) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* icon_node;
	RygelIconInfo* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* width;
	RygelIconInfo* _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* height;
	RygelIconInfo* _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* depth;
	xmlNode* _tmp11_;
	RygelIconInfo* _tmp12_;
	const gchar* _tmp13_;
	xmlNode* _tmp14_;
	const gchar* _tmp15_;
	xmlNode* _tmp16_;
	const gchar* _tmp17_;
	xmlNode* _tmp18_;
	const gchar* _tmp19_;
	RygelIconInfo* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* uri;
	const gchar* _tmp23_;
	gboolean _tmp24_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_info != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = icon_list_node;
	_tmp1_ = xmlNewChild (_tmp0_, NULL, "icon", NULL);
	icon_node = _tmp1_;
	_tmp2_ = icon_info;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	width = _tmp4_;
	_tmp5_ = icon_info;
	_tmp6_ = _tmp5_->height;
	_tmp7_ = g_strdup_printf ("%i", _tmp6_);
	height = _tmp7_;
	_tmp8_ = icon_info;
	_tmp9_ = _tmp8_->depth;
	_tmp10_ = g_strdup_printf ("%i", _tmp9_);
	depth = _tmp10_;
	_tmp11_ = icon_node;
	_tmp12_ = icon_info;
	_tmp13_ = _tmp12_->mime_type;
	xmlNewChild (_tmp11_, NULL, "mimetype", _tmp13_);
	_tmp14_ = icon_node;
	_tmp15_ = width;
	xmlNewChild (_tmp14_, NULL, "width", _tmp15_);
	_tmp16_ = icon_node;
	_tmp17_ = height;
	xmlNewChild (_tmp16_, NULL, "height", _tmp17_);
	_tmp18_ = icon_node;
	_tmp19_ = depth;
	xmlNewChild (_tmp18_, NULL, "depth", _tmp19_);
	_tmp20_ = icon_info;
	_tmp21_ = _tmp20_->uri;
	_tmp22_ = g_strdup (_tmp21_);
	uri = _tmp22_;
	_tmp23_ = uri;
	_tmp24_ = g_str_has_prefix (_tmp23_, "file://");
	if (_tmp24_) {
		RygelPlugin* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		RygelIconInfo* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* remote_path;
		const gchar* _tmp51_;
		gchar* _tmp52_ = NULL;
		gchar* local_path;
		GUPnPContext* _tmp53_;
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		xmlNode* _tmp56_;
		const gchar* _tmp57_;
		_tmp25_ = plugin;
		_tmp26_ = rygel_plugin_get_name (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat ("/", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp29_, "-", NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = width;
		_tmp33_ = g_strconcat (_tmp31_, _tmp32_, NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat (_tmp34_, "x", NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = height;
		_tmp38_ = g_strconcat (_tmp36_, _tmp37_, NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp39_, "x", NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = depth;
		_tmp43_ = g_strconcat (_tmp41_, _tmp42_, NULL);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strconcat (_tmp44_, ".", NULL);
		_tmp46_ = _tmp45_;
		_tmp47_ = icon_info;
		_tmp48_ = _tmp47_->file_extension;
		_tmp49_ = g_strconcat (_tmp46_, _tmp48_, NULL);
		_tmp50_ = _tmp49_;
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp36_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		remote_path = _tmp50_;
		_tmp51_ = uri;
		_tmp52_ = string_substring (_tmp51_, (glong) 7, (glong) (-1));
		local_path = _tmp52_;
		_tmp53_ = self->priv->_context;
		_tmp54_ = local_path;
		_tmp55_ = remote_path;
		gupnp_context_host_path (_tmp53_, _tmp54_, _tmp55_);
		_tmp56_ = icon_node;
		_tmp57_ = remote_path;
		xmlNewChild (_tmp56_, NULL, "url", _tmp57_);
		_g_free0 (local_path);
		_g_free0 (remote_path);
	} else {
		const gchar* _tmp58_;
		GUPnPContext* _tmp59_;
		const gchar* _tmp60_;
		const gchar* _tmp61_;
		gchar* _tmp62_ = NULL;
		xmlNode* _tmp63_;
		const gchar* _tmp64_;
		_tmp58_ = uri;
		_tmp59_ = self->priv->_context;
		_tmp60_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = string_replace (_tmp58_, "@ADDRESS@", _tmp61_);
		_g_free0 (uri);
		uri = _tmp62_;
		_tmp63_ = icon_node;
		_tmp64_ = uri;
		xmlNewChild (_tmp63_, NULL, "url", _tmp64_);
	}
	_g_free0 (uri);
	_g_free0 (depth);
	_g_free0 (height);
	_g_free0 (width);
}


static GUPnPXMLDoc* rygel_root_device_factory_get_latest_doc (RygelRootDeviceFactory* self, const gchar* path1, const gchar* path2, GError** error) {
	GUPnPXMLDoc* result = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp7_;
	GFileInfo* _tmp8_ = NULL;
	GFileInfo* info;
	GFileInfo* _tmp9_;
	guint64 _tmp10_ = 0ULL;
	guint64 mod1;
	const gchar* _tmp11_;
	GFile* _tmp12_ = NULL;
	GFile* _tmp13_;
	GFileInfo* _tmp14_ = NULL;
	GFileInfo* _tmp15_;
	GFileInfo* _tmp16_;
	guint64 _tmp17_ = 0ULL;
	guint64 mod2;
	guint64 _tmp18_;
	guint64 _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path1 != NULL, NULL);
	g_return_val_if_fail (path2 != NULL, NULL);
	_tmp0_ = path1;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (!_tmp3_) {
		const gchar* _tmp4_;
		GUPnPXMLDoc* _tmp5_;
		GUPnPXMLDoc* _tmp6_;
		_tmp4_ = path2;
		_tmp5_ = gupnp_xml_doc_new_from_path (_tmp4_, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			return NULL;
		}
		result = _tmp6_;
		_g_object_unref0 (file);
		return result;
	}
	_tmp7_ = file;
	_tmp8_ = g_file_query_info (_tmp7_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp8_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp9_ = info;
	_tmp10_ = g_file_info_get_attribute_uint64 (_tmp9_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	mod1 = _tmp10_;
	_tmp11_ = path2;
	_tmp12_ = g_file_new_for_path (_tmp11_);
	_g_object_unref0 (file);
	file = _tmp12_;
	_tmp13_ = file;
	_tmp14_ = g_file_query_info (_tmp13_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return NULL;
	}
	_g_object_unref0 (info);
	info = _tmp15_;
	_tmp16_ = info;
	_tmp17_ = g_file_info_get_attribute_uint64 (_tmp16_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	mod2 = _tmp17_;
	_tmp18_ = mod1;
	_tmp19_ = mod2;
	if (_tmp18_ > _tmp19_) {
		{
			const gchar* _tmp20_;
			GUPnPXMLDoc* _tmp21_;
			GUPnPXMLDoc* _tmp22_;
			_tmp20_ = path1;
			_tmp21_ = gupnp_xml_doc_new_from_path (_tmp20_, &_inner_error_);
			_tmp22_ = _tmp21_;
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
			result = _tmp22_;
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return result;
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* _error_ = NULL;
			const gchar* _tmp23_;
			GUPnPXMLDoc* _tmp24_;
			GUPnPXMLDoc* _tmp25_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp23_ = path2;
			_tmp24_ = gupnp_xml_doc_new_from_path (_tmp23_, &_inner_error_);
			_tmp25_ = _tmp24_;
			if (_inner_error_ != NULL) {
				_g_error_free0 (_error_);
				goto __finally4;
			}
			result = _tmp25_;
			_g_error_free0 (_error_);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return result;
		}
		__finally4:
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return NULL;
	} else {
		const gchar* _tmp26_;
		GUPnPXMLDoc* _tmp27_;
		GUPnPXMLDoc* _tmp28_;
		_tmp26_ = path2;
		_tmp27_ = gupnp_xml_doc_new_from_path (_tmp26_, &_inner_error_);
		_tmp28_ = _tmp27_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return NULL;
		}
		result = _tmp28_;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_g_object_unref0 (info);
	_g_object_unref0 (file);
}


static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const gchar* dir_path, GError** error) {
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir_path != NULL);
	_tmp0_ = dir_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (!_tmp3_) {
		GFile* _tmp4_;
		_tmp4_ = file;
		g_file_make_directory (_tmp4_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			return;
		}
	}
	_g_object_unref0 (file);
}


static gchar* rygel_root_device_factory_generate_random_udn (RygelRootDeviceFactory* self) {
	gchar* result = NULL;
	guchar* _tmp0_ = NULL;
	guchar* udn;
	gint udn_length1;
	gint _udn_size_;
	guchar* _tmp1_ = NULL;
	guchar* id;
	gint id_length1;
	gint _id_size_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (guchar, 50);
	udn = _tmp0_;
	udn_length1 = 50;
	_udn_size_ = udn_length1;
	_tmp1_ = g_new0 (guchar, 16);
	id = _tmp1_;
	id_length1 = 16;
	_id_size_ = id_length1;
	uuid_generate (id);
	uuid_unparse (id, udn);
	_tmp2_ = g_strconcat ("uuid:", (const gchar*) udn, NULL);
	result = _tmp2_;
	id = (g_free (id), NULL);
	udn = (g_free (udn), NULL);
	return result;
}


GUPnPContext* rygel_root_device_factory_get_context (RygelRootDeviceFactory* self) {
	GUPnPContext* result;
	GUPnPContext* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_context;
	result = _tmp0_;
	return result;
}


static void rygel_root_device_factory_set_context (RygelRootDeviceFactory* self, GUPnPContext* value) {
	GUPnPContext* _tmp0_;
	GUPnPContext* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_context);
	self->priv->_context = _tmp1_;
	g_object_notify ((GObject *) self, "context");
}


static void rygel_root_device_factory_class_init (RygelRootDeviceFactoryClass * klass) {
	rygel_root_device_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelRootDeviceFactoryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_root_device_factory_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_root_device_factory_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_root_device_factory_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_ROOT_DEVICE_FACTORY_CONTEXT, g_param_spec_object ("context", "context", "context", gupnp_context_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void rygel_root_device_factory_g_initable_interface_init (GInitableIface * iface) {
	rygel_root_device_factory_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*)(GInitable*, GCancellable*, GError**)) rygel_root_device_factory_real_init;
}


static void rygel_root_device_factory_instance_init (RygelRootDeviceFactory * self) {
	self->priv = RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE (self);
}


static void rygel_root_device_factory_finalize (GObject* obj) {
	RygelRootDeviceFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
	_g_object_unref0 (self->priv->_context);
	_g_object_unref0 (self->priv->config);
	_g_free0 (self->priv->desc_dir);
	G_OBJECT_CLASS (rygel_root_device_factory_parent_class)->finalize (obj);
}


/**
 * This is a factory to create #RygelRootDevice objects for
 * a given UPnP context.
 *
 * Call rygel_root_device_factory_create() with a plugin
 * to create a root device for the plugin.
 */
GType rygel_root_device_factory_get_type (void) {
	static volatile gsize rygel_root_device_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_root_device_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRootDeviceFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_root_device_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRootDeviceFactory), 0, (GInstanceInitFunc) rygel_root_device_factory_instance_init, NULL };
		static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) rygel_root_device_factory_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_root_device_factory_type_id;
		rygel_root_device_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelRootDeviceFactory", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_root_device_factory_type_id, G_TYPE_INITABLE, &g_initable_info);
		g_once_init_leave (&rygel_root_device_factory_type_id__volatile, rygel_root_device_factory_type_id);
	}
	return rygel_root_device_factory_type_id__volatile;
}


static void _vala_rygel_root_device_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelRootDeviceFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
	switch (property_id) {
		case RYGEL_ROOT_DEVICE_FACTORY_CONTEXT:
		g_value_set_object (value, rygel_root_device_factory_get_context (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_root_device_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelRootDeviceFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
	switch (property_id) {
		case RYGEL_ROOT_DEVICE_FACTORY_CONTEXT:
		rygel_root_device_factory_set_context (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



