/* rygel-player-controller.c generated by valac 0.20.1.64-fa28c, the Vala compiler
 * generated from rygel-player-controller.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-core.h>


#define RYGEL_TYPE_PLAYER_CONTROLLER (rygel_player_controller_get_type ())
#define RYGEL_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController))
#define RYGEL_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerClass))
#define RYGEL_IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_IS_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerClass))

typedef struct _RygelPlayerController RygelPlayerController;
typedef struct _RygelPlayerControllerClass RygelPlayerControllerClass;
typedef struct _RygelPlayerControllerPrivate RygelPlayerControllerPrivate;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _RygelPlayerController {
	GObject parent_instance;
	RygelPlayerControllerPrivate * priv;
};

struct _RygelPlayerControllerClass {
	GObjectClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
};

struct _RygelPlayerControllerPrivate {
	RygelMediaPlayer* _player;
	gchar* _protocol_info;
	guint _n_tracks;
	gchar* _uri;
	GUPnPMediaCollection* collection;
	GList* collection_items;
	guint timeout_id;
	guint default_image_timeout;
	RygelConfiguration* config;
	gchar* _metadata;
	guint _track;
	gchar* _playback_state;
};


static gpointer rygel_player_controller_parent_class = NULL;

GType rygel_player_controller_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAYER_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerPrivate))
enum  {
	RYGEL_PLAYER_CONTROLLER_DUMMY_PROPERTY,
	RYGEL_PLAYER_CONTROLLER_PLAYER,
	RYGEL_PLAYER_CONTROLLER_PROTOCOL_INFO,
	RYGEL_PLAYER_CONTROLLER_PLAYBACK_STATE,
	RYGEL_PLAYER_CONTROLLER_N_TRACKS,
	RYGEL_PLAYER_CONTROLLER_TRACK,
	RYGEL_PLAYER_CONTROLLER_URI,
	RYGEL_PLAYER_CONTROLLER_METADATA,
	RYGEL_PLAYER_CONTROLLER_CURRENT_TRANSPORT_ACTIONS
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define RYGEL_PLAYER_CONTROLLER_DEFAULT_IMAGE_TIMEOUT 15
#define RYGEL_PLAYER_CONTROLLER_CONFIG_SECTION "Renderer"
#define RYGEL_PLAYER_CONTROLLER_TIMEOUT_KEY "image-timeout"
#define RYGEL_PLAYER_CONTROLLER_DIDL_FRAME_TEMPLATE "<DIDL-Lite " "xmlns:dc=\"http://purl.org/dc/elements/1.1/\" " "xmlns:upnp=\"urn:schemas-upnp-org:metadata-1-0/upnp/\" " "xmlns:dlna=\"urn:schemas-dlna-org:metadata-1-0/\" " "xmlns=\"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/\">" "%s</DIDL-Lite>"
RygelPlayerController* rygel_player_controller_new (RygelMediaPlayer* player, const gchar* protocol_info);
RygelPlayerController* rygel_player_controller_construct (GType object_type, RygelMediaPlayer* player, const gchar* protocol_info);
static void rygel_player_controller_real_constructed (GObject* base);
static RygelMediaPlayer* rygel_player_controller_get_player (RygelPlayerController* self);
static void rygel_player_controller_notify_state_cb (RygelPlayerController* self, GObject* player, GParamSpec* p);
static void _rygel_player_controller_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_player_controller_on_setting_changed (RygelPlayerController* self, const gchar* section, const gchar* key);
static void _rygel_player_controller_on_setting_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender, const gchar* section, const gchar* key, gpointer self);
gboolean rygel_player_controller_next (RygelPlayerController* self);
guint rygel_player_controller_get_track (RygelPlayerController* self);
guint rygel_player_controller_get_n_tracks (RygelPlayerController* self);
void rygel_player_controller_set_track (RygelPlayerController* self, guint value);
gboolean rygel_player_controller_previous (RygelPlayerController* self);
void rygel_player_controller_set_playlist (RygelPlayerController* self, GUPnPMediaCollection* collection);
void rygel_player_controller_set_n_tracks (RygelPlayerController* self, guint value);
gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self);
static gboolean ____lambda2_ (RygelPlayerController* self);
void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value);
static gboolean _____lambda2__gsource_func (gpointer self);
static void rygel_player_controller_reset (RygelPlayerController* self);
void rygel_player_controller_set_playback_state (RygelPlayerController* self, const gchar* value);
static void rygel_player_controller_apply_track (RygelPlayerController* self);
static const gchar* rygel_player_controller_get_protocol_info (RygelPlayerController* self);
void rygel_media_player_set_metadata (RygelMediaPlayer* self, const gchar* value);
void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value);
static void rygel_player_controller_setup_image_timeouts (RygelPlayerController* self, glong lifetime);
static gboolean __lambda3_ (RygelPlayerController* self);
static gboolean ___lambda3__gsource_func (gpointer self);
static gchar* rygel_player_controller_unescape (RygelPlayerController* self, const gchar* input);
static void rygel_player_controller_set_player (RygelPlayerController* self, RygelMediaPlayer* value);
static void rygel_player_controller_set_protocol_info (RygelPlayerController* self, const gchar* value);
const gchar* rygel_player_controller_get_playback_state (RygelPlayerController* self);
const gchar* rygel_player_controller_get_uri (RygelPlayerController* self);
void rygel_player_controller_set_uri (RygelPlayerController* self, const gchar* value);
gchar* rygel_player_controller_get_metadata (RygelPlayerController* self);
void rygel_player_controller_set_metadata (RygelPlayerController* self, const gchar* value);
gchar* rygel_player_controller_get_current_transport_actions (RygelPlayerController* self);
gboolean rygel_media_player_get_can_seek (RygelMediaPlayer* self);
gchar** rygel_media_player_get_allowed_playback_speeds (RygelMediaPlayer* self, int* result_length1);
static void rygel_player_controller_finalize (GObject* obj);
static void _vala_rygel_player_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_player_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


RygelPlayerController* rygel_player_controller_construct (GType object_type, RygelMediaPlayer* player, const gchar* protocol_info) {
	RygelPlayerController * self = NULL;
	RygelMediaPlayer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (player != NULL, NULL);
	g_return_val_if_fail (protocol_info != NULL, NULL);
	_tmp0_ = player;
	_tmp1_ = protocol_info;
	self = (RygelPlayerController*) g_object_new (object_type, "player", _tmp0_, "protocol-info", _tmp1_, NULL);
	return self;
}


RygelPlayerController* rygel_player_controller_new (RygelMediaPlayer* player, const gchar* protocol_info) {
	return rygel_player_controller_construct (RYGEL_TYPE_PLAYER_CONTROLLER, player, protocol_info);
}


static void _rygel_player_controller_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_player_controller_notify_state_cb (self, _sender, pspec);
}


static void _rygel_player_controller_on_setting_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender, const gchar* section, const gchar* key, gpointer self) {
	rygel_player_controller_on_setting_changed (self, section, key);
}


static void rygel_player_controller_real_constructed (GObject* base) {
	RygelPlayerController * self;
	RygelMediaPlayer* _tmp0_ = NULL;
	RygelMetaConfig* _tmp1_ = NULL;
	RygelConfiguration* _tmp2_ = NULL;
	self = (RygelPlayerController*) base;
	G_OBJECT_CLASS (rygel_player_controller_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	_tmp0_ = self->priv->_player;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::playback-state", (GCallback) _rygel_player_controller_notify_state_cb_g_object_notify, self, 0);
	_tmp1_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->config);
	self->priv->config = (RygelConfiguration*) _tmp1_;
	_tmp2_ = self->priv->config;
	g_signal_connect_object (_tmp2_, "setting-changed", (GCallback) _rygel_player_controller_on_setting_changed_rygel_configuration_setting_changed, self, 0);
	self->priv->default_image_timeout = (guint) RYGEL_PLAYER_CONTROLLER_DEFAULT_IMAGE_TIMEOUT;
	rygel_player_controller_on_setting_changed (self, RYGEL_PLAYER_CONTROLLER_CONFIG_SECTION, RYGEL_PLAYER_CONTROLLER_TIMEOUT_KEY);
}


gboolean rygel_player_controller_next (RygelPlayerController* self) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_player_controller_get_track (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_n_tracks;
	if ((_tmp1_ + 1) > _tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = rygel_player_controller_get_track (self);
	_tmp4_ = _tmp3_;
	rygel_player_controller_set_track (self, _tmp4_ + 1);
	result = TRUE;
	return result;
}


gboolean rygel_player_controller_previous (RygelPlayerController* self) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_player_controller_get_track (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ <= ((guint) 1)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = rygel_player_controller_get_track (self);
	_tmp3_ = _tmp2_;
	rygel_player_controller_set_track (self, _tmp3_ - 1);
	result = TRUE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_player_controller_set_playlist (RygelPlayerController* self, GUPnPMediaCollection* collection) {
	GUPnPMediaCollection* _tmp0_ = NULL;
	GUPnPMediaCollection* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GUPnPMediaCollection* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = collection;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->collection);
	self->priv->collection = _tmp1_;
	_tmp2_ = self->priv->timeout_id;
	if (_tmp2_ != ((guint) 0)) {
		guint _tmp3_ = 0U;
		self->priv->timeout_id = (guint) 0;
		_tmp3_ = self->priv->timeout_id;
		g_source_remove (_tmp3_);
	}
	_tmp4_ = self->priv->collection;
	if (_tmp4_ != NULL) {
		GUPnPMediaCollection* _tmp5_ = NULL;
		GList* _tmp6_ = NULL;
		GList* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		_tmp5_ = collection;
		_tmp6_ = gupnp_media_collection_get_items (_tmp5_);
		__g_list_free__g_object_unref0_0 (self->priv->collection_items);
		self->priv->collection_items = _tmp6_;
		_tmp7_ = self->priv->collection_items;
		_tmp8_ = g_list_length (_tmp7_);
		rygel_player_controller_set_n_tracks (self, _tmp8_);
		rygel_player_controller_set_track (self, (guint) 1);
	} else {
		__g_list_free__g_object_unref0_0 (self->priv->collection_items);
		self->priv->collection_items = NULL;
	}
}


static gboolean ____lambda2_ (RygelPlayerController* self) {
	gboolean result = FALSE;
	RygelMediaPlayer* _tmp0_ = NULL;
	_tmp0_ = self->priv->_player;
	rygel_media_player_set_playback_state (_tmp0_, "STOPPED");
	result = FALSE;
	return result;
}


static gboolean _____lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda2_ (self);
	return result;
}


static void rygel_player_controller_notify_state_cb (RygelPlayerController* self, GObject* player, GParamSpec* p) {
	gchar* state = NULL;
	RygelMediaPlayer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->_player;
	_tmp1_ = rygel_media_player_get_playback_state (_tmp0_);
	_tmp2_ = _tmp1_;
	state = _tmp2_;
	_tmp3_ = state;
	if (g_strcmp0 (_tmp3_, "EOS") == 0) {
		GUPnPMediaCollection* _tmp4_ = NULL;
		_tmp4_ = self->priv->collection;
		if (_tmp4_ == NULL) {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda2__gsource_func, g_object_ref (self), g_object_unref);
			_g_free0 (state);
			return;
		} else {
			gboolean _tmp5_ = FALSE;
			_tmp5_ = rygel_player_controller_next (self);
			if (!_tmp5_) {
				rygel_player_controller_reset (self);
			}
		}
	} else {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = state;
		rygel_player_controller_set_playback_state (self, _tmp6_);
	}
	_g_free0 (state);
}


static void rygel_player_controller_apply_track (RygelPlayerController* self) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->collection_items;
	if (_tmp0_ != NULL) {
		GUPnPDIDLLiteItem* item = NULL;
		GList* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		guint _tmp3_ = 0U;
		GList* _tmp4_ = NULL;
		gconstpointer _tmp5_ = NULL;
		GUPnPDIDLLiteItem* _tmp6_ = NULL;
		GUPnPDIDLLiteResource* res = NULL;
		GUPnPDIDLLiteItem* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GUPnPDIDLLiteResource* _tmp9_ = NULL;
		RygelMediaPlayer* _tmp10_ = NULL;
		GUPnPDIDLLiteItem* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		RygelMediaPlayer* _tmp16_ = NULL;
		GUPnPDIDLLiteResource* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		GUPnPDIDLLiteItem* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp25_ = FALSE;
		_tmp1_ = self->priv->collection_items;
		_tmp2_ = rygel_player_controller_get_track (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_list_nth (_tmp1_, _tmp3_ - 1);
		_tmp5_ = _tmp4_->data;
		_tmp6_ = _g_object_ref0 ((GUPnPDIDLLiteItem*) _tmp5_);
		item = _tmp6_;
		_tmp7_ = item;
		_tmp8_ = self->priv->_protocol_info;
		_tmp9_ = gupnp_didl_lite_object_get_compat_resource ((GUPnPDIDLLiteObject*) _tmp7_, _tmp8_, TRUE);
		res = _tmp9_;
		_tmp10_ = self->priv->_player;
		_tmp11_ = item;
		_tmp12_ = gupnp_didl_lite_object_get_xml_string ((GUPnPDIDLLiteObject*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf (RYGEL_PLAYER_CONTROLLER_DIDL_FRAME_TEMPLATE, _tmp13_);
		_tmp15_ = _tmp14_;
		rygel_media_player_set_metadata (_tmp10_, _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_tmp16_ = self->priv->_player;
		_tmp17_ = res;
		_tmp18_ = gupnp_didl_lite_resource_get_uri (_tmp17_);
		rygel_media_player_set_uri (_tmp16_, _tmp18_);
		_tmp20_ = item;
		_tmp21_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_str_has_prefix (_tmp22_, "object.item.image");
		if (_tmp23_) {
			GUPnPMediaCollection* _tmp24_ = NULL;
			_tmp24_ = self->priv->collection;
			_tmp19_ = _tmp24_ != NULL;
		} else {
			_tmp19_ = FALSE;
		}
		_tmp25_ = _tmp19_;
		if (_tmp25_) {
			GUPnPDIDLLiteItem* _tmp26_ = NULL;
			glong _tmp27_ = 0L;
			glong _tmp28_ = 0L;
			_tmp26_ = item;
			_tmp27_ = gupnp_didl_lite_item_get_lifetime (_tmp26_);
			_tmp28_ = _tmp27_;
			rygel_player_controller_setup_image_timeouts (self, _tmp28_);
		}
		_g_object_unref0 (res);
		_g_object_unref0 (item);
	}
}


static void rygel_player_controller_reset (RygelPlayerController* self) {
	RygelMediaPlayer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_player;
	rygel_media_player_set_playback_state (_tmp0_, "STOPPED");
	rygel_player_controller_set_track (self, (guint) 1);
}


static gboolean __lambda3_ (RygelPlayerController* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self->priv->timeout_id = (guint) 0;
	_tmp0_ = rygel_player_controller_next (self);
	if (!_tmp0_) {
		rygel_player_controller_reset (self);
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
	return result;
}


static void rygel_player_controller_setup_image_timeouts (RygelPlayerController* self, glong lifetime) {
	guint timeout = 0U;
	guint _tmp0_ = 0U;
	glong _tmp1_ = 0L;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->default_image_timeout;
	timeout = _tmp0_;
	_tmp1_ = lifetime;
	if (_tmp1_ > ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = lifetime;
		timeout = (guint) _tmp2_;
	}
	_tmp3_ = timeout;
	g_debug ("rygel-player-controller.vala:236: Item is image, setup timer: %ld", (glong) _tmp3_);
	_tmp4_ = self->priv->timeout_id;
	if (_tmp4_ != ((guint) 0)) {
		guint _tmp5_ = 0U;
		_tmp5_ = self->priv->timeout_id;
		g_source_remove (_tmp5_);
	}
	_tmp6_ = timeout;
	_tmp7_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp6_, ___lambda3__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->timeout_id = _tmp7_;
}


static void rygel_player_controller_on_setting_changed (RygelPlayerController* self, const gchar* section, const gchar* key) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	guint _tmp8_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	_tmp1_ = section;
	if (g_strcmp0 (_tmp1_, RYGEL_PLAYER_CONTROLLER_CONFIG_SECTION) != 0) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = key;
		_tmp0_ = g_strcmp0 (_tmp2_, RYGEL_PLAYER_CONTROLLER_TIMEOUT_KEY) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		return;
	}
	{
		gint _tmp4_ = 0;
		RygelConfiguration* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp5_ = self->priv->config;
		_tmp6_ = G_MAXINT;
		_tmp7_ = rygel_configuration_get_int (_tmp5_, RYGEL_PLAYER_CONTROLLER_CONFIG_SECTION, RYGEL_PLAYER_CONTROLLER_TIMEOUT_KEY, 0, _tmp6_, &_inner_error_);
		_tmp4_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		self->priv->default_image_timeout = (guint) _tmp4_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		self->priv->default_image_timeout = (guint) RYGEL_PLAYER_CONTROLLER_DEFAULT_IMAGE_TIMEOUT;
		_g_error_free0 (_error_);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = self->priv->default_image_timeout;
	g_debug ("rygel-player-controller.vala:266: New image timeout: %lu", (gulong) _tmp8_);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp5_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* rygel_player_controller_unescape (RygelPlayerController* self, const gchar* input) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = string_replace (_tmp0_, "&quot;", "\"");
	_result_ = _tmp1_;
	_tmp2_ = _result_;
	_tmp3_ = string_replace (_tmp2_, "&lt;", "<");
	_g_free0 (_result_);
	_result_ = _tmp3_;
	_tmp4_ = _result_;
	_tmp5_ = string_replace (_tmp4_, "&gt;", ">");
	_g_free0 (_result_);
	_result_ = _tmp5_;
	_tmp6_ = _result_;
	_tmp7_ = string_replace (_tmp6_, "&apos;", "'");
	_g_free0 (_result_);
	_result_ = _tmp7_;
	_tmp8_ = _result_;
	_tmp9_ = string_replace (_tmp8_, "&amp;", "&");
	_g_free0 (_result_);
	_result_ = _tmp9_;
	result = _result_;
	return result;
}


static RygelMediaPlayer* rygel_player_controller_get_player (RygelPlayerController* self) {
	RygelMediaPlayer* result;
	RygelMediaPlayer* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_player;
	result = _tmp0_;
	return result;
}


static void rygel_player_controller_set_player (RygelPlayerController* self, RygelMediaPlayer* value) {
	RygelMediaPlayer* _tmp0_ = NULL;
	RygelMediaPlayer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_player);
	self->priv->_player = _tmp1_;
	g_object_notify ((GObject *) self, "player");
}


static const gchar* rygel_player_controller_get_protocol_info (RygelPlayerController* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_protocol_info;
	result = _tmp0_;
	return result;
}


static void rygel_player_controller_set_protocol_info (RygelPlayerController* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_protocol_info);
	self->priv->_protocol_info = _tmp1_;
	g_object_notify ((GObject *) self, "protocol-info");
}


const gchar* rygel_player_controller_get_playback_state (RygelPlayerController* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_playback_state;
	result = _tmp0_;
	return result;
}


void rygel_player_controller_set_playback_state (RygelPlayerController* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_playback_state;
	_tmp1_ = value;
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = value;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (self->priv->_playback_state);
		self->priv->_playback_state = _tmp3_;
		g_object_notify ((GObject*) self, "playback-state");
	}
}


guint rygel_player_controller_get_n_tracks (RygelPlayerController* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_n_tracks;
	result = _tmp0_;
	return result;
}


void rygel_player_controller_set_n_tracks (RygelPlayerController* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_n_tracks = _tmp0_;
	g_object_notify ((GObject *) self, "n-tracks");
}


guint rygel_player_controller_get_track (RygelPlayerController* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_track;
	result = _tmp0_;
	return result;
}


void rygel_player_controller_set_track (RygelPlayerController* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_track = _tmp0_;
	rygel_player_controller_apply_track (self);
	g_object_notify ((GObject *) self, "track");
}


const gchar* rygel_player_controller_get_uri (RygelPlayerController* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}


void rygel_player_controller_set_uri (RygelPlayerController* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp1_;
	g_object_notify ((GObject *) self, "uri");
}


gchar* rygel_player_controller_get_metadata (RygelPlayerController* self) {
	gchar* result;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_metadata;
	_tmp2_ = g_strdup (_tmp1_);
	_tmp0_ = _tmp2_;
	_tmp3_ = _tmp0_;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}


void rygel_player_controller_set_metadata (RygelPlayerController* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = rygel_player_controller_unescape (self, _tmp0_);
	_g_free0 (self->priv->_metadata);
	self->priv->_metadata = _tmp1_;
	g_object_notify ((GObject *) self, "metadata");
}


gchar* rygel_player_controller_get_current_transport_actions (RygelPlayerController* self) {
	gchar* result;
	gchar* actions = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp31_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	actions = NULL;
	_tmp0_ = self->priv->_playback_state;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("PLAYING")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("TRANSITIONING"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_ = NULL;
				_tmp4_ = g_strdup ("Stop,Seek,Pause");
				_g_free0 (actions);
				actions = _tmp4_;
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("STOPPED")))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("PAUSED_PLAYBACK"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_ = NULL;
				_tmp5_ = g_strdup ("Play,Seek");
				_g_free0 (actions);
				actions = _tmp5_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_tmp7_ = actions;
	if (_tmp7_ != NULL) {
		RygelMediaPlayer* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp8_ = self->priv->_player;
		_tmp9_ = rygel_media_player_get_can_seek (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* play_speeds = NULL;
		gchar* _tmp14_ = NULL;
		RygelMediaPlayer* _tmp15_ = NULL;
		gchar** _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		_tmp12_ = actions;
		_tmp13_ = g_strconcat (_tmp12_, ",X_DLNA_SeekTime", NULL);
		_g_free0 (actions);
		actions = _tmp13_;
		_tmp14_ = g_strdup ("");
		play_speeds = _tmp14_;
		_tmp15_ = self->priv->_player;
		_tmp16_ = rygel_media_player_get_allowed_playback_speeds (_tmp15_, &_tmp16__length1);
		_tmp17_ = _tmp16_;
		_tmp17__length1 = _tmp16__length1;
		{
			gchar** speed_collection = NULL;
			gint speed_collection_length1 = 0;
			gint _speed_collection_size_ = 0;
			gint speed_it = 0;
			speed_collection = _tmp17_;
			speed_collection_length1 = _tmp17__length1;
			for (speed_it = 0; speed_it < _tmp17__length1; speed_it = speed_it + 1) {
				gchar* _tmp18_ = NULL;
				gchar* speed = NULL;
				_tmp18_ = g_strdup (speed_collection[speed_it]);
				speed = _tmp18_;
				{
					const gchar* _tmp19_ = NULL;
					_tmp19_ = speed;
					if (g_strcmp0 (_tmp19_, "1") != 0) {
						const gchar* _tmp20_ = NULL;
						_tmp20_ = play_speeds;
						if (g_strcmp0 (_tmp20_, "") == 0) {
							const gchar* _tmp21_ = NULL;
							gchar* _tmp22_ = NULL;
							_tmp21_ = speed;
							_tmp22_ = g_strconcat (",X_DLNA_PS=", _tmp21_, NULL);
							_g_free0 (play_speeds);
							play_speeds = _tmp22_;
						} else {
							const gchar* _tmp23_ = NULL;
							const gchar* _tmp24_ = NULL;
							gchar* _tmp25_ = NULL;
							gchar* _tmp26_ = NULL;
							gchar* _tmp27_ = NULL;
							_tmp23_ = play_speeds;
							_tmp24_ = speed;
							_tmp25_ = g_strconcat ("\\,", _tmp24_, NULL);
							_tmp26_ = _tmp25_;
							_tmp27_ = g_strconcat (_tmp23_, _tmp26_, NULL);
							_g_free0 (play_speeds);
							play_speeds = _tmp27_;
							_g_free0 (_tmp26_);
						}
					}
					_g_free0 (speed);
				}
			}
			speed_collection = (_vala_array_free (speed_collection, speed_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp28_ = actions;
		_tmp29_ = play_speeds;
		_tmp30_ = g_strconcat (_tmp28_, _tmp29_, NULL);
		_g_free0 (actions);
		actions = _tmp30_;
		_g_free0 (play_speeds);
	}
	_tmp31_ = actions;
	if (_tmp31_ == NULL) {
		gchar* _tmp32_ = NULL;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		_g_free0 (actions);
		return result;
	}
	result = actions;
	return result;
}


static void rygel_player_controller_class_init (RygelPlayerControllerClass * klass) {
	rygel_player_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelPlayerControllerPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_player_controller_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_player_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_player_controller_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_player_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_PLAYER, g_param_spec_object ("player", "player", "player", RYGEL_TYPE_MEDIA_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_PROTOCOL_INFO, g_param_spec_string ("protocol-info", "protocol-info", "protocol-info", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_PLAYBACK_STATE, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_N_TRACKS, g_param_spec_uint ("n-tracks", "n-tracks", "n-tracks", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_TRACK, g_param_spec_uint ("track", "track", "track", 0, G_MAXUINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_CURRENT_TRANSPORT_ACTIONS, g_param_spec_string ("current-transport-actions", "current-transport-actions", "current-transport-actions", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_player_controller_instance_init (RygelPlayerController * self) {
	gchar* _tmp0_ = NULL;
	self->priv = RYGEL_PLAYER_CONTROLLER_GET_PRIVATE (self);
	self->priv->_n_tracks = (guint) 0;
	_tmp0_ = g_strdup ("");
	self->priv->_uri = _tmp0_;
	rygel_player_controller_set_playback_state (self, "NO_MEDIA_PRESENT");
	rygel_player_controller_set_metadata (self, "");
}


static void rygel_player_controller_finalize (GObject* obj) {
	RygelPlayerController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController);
	_g_object_unref0 (self->priv->_player);
	_g_free0 (self->priv->_protocol_info);
	_g_free0 (self->priv->_uri);
	_g_object_unref0 (self->priv->collection);
	__g_list_free__g_object_unref0_0 (self->priv->collection_items);
	_g_object_unref0 (self->priv->config);
	_g_free0 (self->priv->_metadata);
	_g_free0 (self->priv->_playback_state);
	G_OBJECT_CLASS (rygel_player_controller_parent_class)->finalize (obj);
}


/**
 * This class keeps track of global states that are not dependant on the
 * RygelMediaPlayer.
 *
 * These states are:
 * # URI
 * # MetaData
 * # Number of tracks
 * # Current track
 * # Playback state
 *
 * In case of playlists this class will also control the player. It needs to
 * proxy the playback state to react on end of item to be able to switch to
 * the next item.
 */
GType rygel_player_controller_get_type (void) {
	static volatile gsize rygel_player_controller_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_player_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlayerControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_player_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlayerController), 0, (GInstanceInitFunc) rygel_player_controller_instance_init, NULL };
		GType rygel_player_controller_type_id;
		rygel_player_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlayerController", &g_define_type_info, 0);
		g_once_init_leave (&rygel_player_controller_type_id__volatile, rygel_player_controller_type_id);
	}
	return rygel_player_controller_type_id__volatile;
}


static void _vala_rygel_player_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlayerController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController);
	switch (property_id) {
		case RYGEL_PLAYER_CONTROLLER_PLAYER:
		g_value_set_object (value, rygel_player_controller_get_player (self));
		break;
		case RYGEL_PLAYER_CONTROLLER_PROTOCOL_INFO:
		g_value_set_string (value, rygel_player_controller_get_protocol_info (self));
		break;
		case RYGEL_PLAYER_CONTROLLER_PLAYBACK_STATE:
		g_value_set_string (value, rygel_player_controller_get_playback_state (self));
		break;
		case RYGEL_PLAYER_CONTROLLER_N_TRACKS:
		g_value_set_uint (value, rygel_player_controller_get_n_tracks (self));
		break;
		case RYGEL_PLAYER_CONTROLLER_TRACK:
		g_value_set_uint (value, rygel_player_controller_get_track (self));
		break;
		case RYGEL_PLAYER_CONTROLLER_URI:
		g_value_set_string (value, rygel_player_controller_get_uri (self));
		break;
		case RYGEL_PLAYER_CONTROLLER_METADATA:
		g_value_take_string (value, rygel_player_controller_get_metadata (self));
		break;
		case RYGEL_PLAYER_CONTROLLER_CURRENT_TRANSPORT_ACTIONS:
		g_value_take_string (value, rygel_player_controller_get_current_transport_actions (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_player_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlayerController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController);
	switch (property_id) {
		case RYGEL_PLAYER_CONTROLLER_PLAYER:
		rygel_player_controller_set_player (self, g_value_get_object (value));
		break;
		case RYGEL_PLAYER_CONTROLLER_PROTOCOL_INFO:
		rygel_player_controller_set_protocol_info (self, g_value_get_string (value));
		break;
		case RYGEL_PLAYER_CONTROLLER_PLAYBACK_STATE:
		rygel_player_controller_set_playback_state (self, g_value_get_string (value));
		break;
		case RYGEL_PLAYER_CONTROLLER_N_TRACKS:
		rygel_player_controller_set_n_tracks (self, g_value_get_uint (value));
		break;
		case RYGEL_PLAYER_CONTROLLER_TRACK:
		rygel_player_controller_set_track (self, g_value_get_uint (value));
		break;
		case RYGEL_PLAYER_CONTROLLER_URI:
		rygel_player_controller_set_uri (self, g_value_get_string (value));
		break;
		case RYGEL_PLAYER_CONTROLLER_METADATA:
		rygel_player_controller_set_metadata (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



