# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=hicolor-icon-theme
VER=0.10
REV=1
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev

(

set -x

CC='gcc -mtune=pentium3 -mthreads' ./configure --prefix=$TARGET &&

make install &&

cd /devel/target/$HEX &&
rm -f /tmp/$RUNZIP &&

# Don't use -D here, do add the shitload of (empty) directories
zip -r /tmp/$RUNZIP share/icons &&

# No real contents in the dev zipfile, but must have one still for
# consistency...
rm -f /tmp/$DEVZIP &&
zip /tmp/$DEVZIP nul: &&
zip -d /tmp/$DEVZIP nul:.

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
