# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=librsvg
VER=2.22.2
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`

DEPS=`/devel/src/tml/latest.sh glib atk cairo pango gtk+ libgsf libcroco`

# Avoid the silly "relink" stuff in libtool
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I
# can only do this if you have shared version of the
# library, which you do not appear to have."

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

patch <<'EOF'
--- librsvg-zip.in
+++ librsvg-zip.in
@@ -20,0 +20,0 @@
 rm $DEVZIP
 zip -r $DEVZIP -@ <<EOF
-bin/rsvg.exe
+bin/rsvg-convert.exe
 bin/rsvg-view.exe
 include/librsvg-2
 lib/librsvg-2.dll.a
EOF

usedev
usemsvs6

unset MY_PKG_CONFIG_PATH
for D in $DEPS; do
    PATH=/devel/dist/$D/bin:$PATH
    MY_PKG_CONFIG_PATH=/devel/dist/$D/lib/pkgconfig:$MY_PKG_CONFIG_PATH
done
(PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH CC='gcc -mtune=pentium3' CPPFLAGS='-I/opt/win_iconv/include -I/opt/proxy-libintl/include -I/opt/misc/include' LDFLAGS='-L/opt/proxy-libintl/lib -L/opt/misc/lib' CFLAGS=-O2 ./configure --disable-gtk-doc --disable-static --prefix=c:/devel/target/$HEX &&
libtoolcacheize &&
make -j3 install &&
./librsvg-zip &&

(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
manifestify /tmp/$MOD*-$VER.zip)

