// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMEUIMM_THUMBNAIL_H
#define _LIBGNOMEUIMM_THUMBNAIL_H

#include <glibmm.h>

/* thumbnail.hg
 * 
 * Copyright (C) 1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gdkmm/pixbuf.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GnomeThumbnailFactory GnomeThumbnailFactory;
typedef struct _GnomeThumbnailFactoryClass GnomeThumbnailFactoryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace UI
{ class ThumbnailFactory_Class; } // namespace UI

} // namespace Gnome
namespace Gnome
{

namespace UI
{

/** @addtogroup libgnomeuimmEnums Enums and Flags */

/**
 * @ingroup libgnomeuimmEnums
 */
enum ThumbnailSize
{
  THUMBNAIL_SIZE_NORMAL,
  THUMBNAIL_SIZE_LARGE
};


class ThumbnailFactory : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ThumbnailFactory CppObjectType;
  typedef ThumbnailFactory_Class CppClassType;
  typedef GnomeThumbnailFactory BaseObjectType;
  typedef GnomeThumbnailFactoryClass BaseClassType;

private:  friend class ThumbnailFactory_Class;
  static CppClassType thumbnailfactory_class_;

private:
  // noncopyable
  ThumbnailFactory(const ThumbnailFactory&);
  ThumbnailFactory& operator=(const ThumbnailFactory&);

protected:
  explicit ThumbnailFactory(const Glib::ConstructParams& construct_params);
  explicit ThumbnailFactory(GnomeThumbnailFactory* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ThumbnailFactory();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GnomeThumbnailFactory*       gobj()       { return reinterpret_cast<GnomeThumbnailFactory*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GnomeThumbnailFactory* gobj() const { return reinterpret_cast<GnomeThumbnailFactory*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GnomeThumbnailFactory* gobj_copy();

private:

public:
  static Glib::RefPtr<ThumbnailFactory> create(ThumbnailSize size);

  
  Glib::ustring lookup(const Glib::ustring& uri, time_t mtime) const;
  
  bool has_valid_failed_thumbnail(const Glib::ustring& uri, time_t mtime) const;
  
  bool can_thumbnail(const Glib::ustring& uri, const Glib::ustring& mime_type, time_t mtime) const;
  
  Glib::RefPtr<Gdk::Pixbuf> generate_thumbnail(const Glib::ustring& uri, const Glib::ustring& mime_type) const;
  
  void save_thumbnail(const Glib::RefPtr<Gdk::Pixbuf>& thumbnail, const Glib::ustring& uri, time_t original_mtime);
  
  void create_failed_thumbnail(const Glib::ustring& uri, time_t mtime) const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

/* Thumbnailing utils: */
bool thumbnail_has_uri(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf, const Glib::ustring& uri);
bool thumbnail_is_valid(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf, const Glib::ustring& uri, time_t mtime);

Glib::ustring thumbnail_md5(const Glib::ustring& uri);
Glib::ustring thumbnail_path_for_uri(const Glib::ustring& uri, ThumbnailSize size);

/* Pixbuf utils: */
Glib::RefPtr<Gdk::Pixbuf> thumbnail_scale_down_pixbuf(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf, int dest_width, int dest_height);

} /* namespace UI */
} /* namespace Gnome */


namespace Glib
{
  /** @relates Gnome::UI::ThumbnailFactory
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::UI::ThumbnailFactory> wrap(GnomeThumbnailFactory* object, bool take_copy = false);
}


#endif /* _LIBGNOMEUIMM_THUMBNAIL_H */

