// Generated by gtkmmproc -- DO NOT MODIFY!

#include <gconfmm/client.h>
#include <gconfmm/private/client_p.h>

// -*- Mode: C++; c-basic-offset: 4  -*-

/* client.ccg
 * 
 * Copyright (C) 2000-2002 GConfmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/private/object_p.h>
#include <glib/gerror.h>
#include <gconf/gconf-client.h>
#include "gconfmm/value.h"

namespace 
{

using namespace Gnome::Conf;

class PrimitiveHolder 
{
public:
  union
  {
    gboolean as_bool;
    gint as_int;
    gdouble as_float;
    char* as_string;
    GConfSchema* as_schema;
  };

  ValueType type;

  PrimitiveHolder(ValueType t)
  : type(t)
  {}

  gpointer get_addr()
  {
    switch (type)
    {
      case VALUE_INT:
        return &as_int;
        break;
      case VALUE_STRING:
        return &as_string;
        break;
      case VALUE_FLOAT:
        return &as_float;
        break;
      case VALUE_BOOL:
        return &as_bool;
        break;
      case VALUE_SCHEMA:
        return &as_schema;
        break;
      default:
        g_assert_not_reached();
        return NULL; /* for warnings */
        break;
    }
  }

  GConfValue* make_value()
  {
    GConfValue* v = gconf_value_new((GConfValueType)type);

    switch (type)
    {
      case VALUE_INT:
        gconf_value_set_int(v,as_int);
        break;
      case VALUE_STRING:
        gconf_value_set_string(v,as_string);
        g_free(as_string);
        break;
      case VALUE_FLOAT:
        gconf_value_set_float(v,as_float);
        break;
      case VALUE_BOOL:
        gconf_value_set_bool(v,as_bool);
        break;
      case VALUE_SCHEMA:
        gconf_value_set_schema_nocopy(v,as_schema);
        break;
        default:
        g_assert_not_reached();
        return NULL; /* for warnings */
        break;
    }

    return v;
  }

};

} //anonymous namespace

namespace Gnome
{
namespace Conf
{
   
Glib::RefPtr<Client> Client::get_default_client()
{
  return Glib::wrap( gconf_client_get_default() );
}

Glib::RefPtr<Client> Client::get_client_for_engine(GConfEngine* engine)
{
  return Glib::wrap( gconf_client_get_for_engine(engine) );
}


guint Client::notify_add(const Glib::ustring& namespace_section, Callback callback)
{
  CallbackHolder* pHolder = new CallbackHolder(callback); //destroyed by callback_destroy.

  GError* error = 0;
  guint iResult = 
    gconf_client_notify_add(gobj(),
          namespace_section.c_str(),
          &CallbackHolder::call,
          (gpointer)pHolder, //used by GConfClient as an arg to callback_call and callback_destroy.
          &CallbackHolder::destroy,
          &error);
  handle_error(error);

  return iResult;
}

SListHandle_ValueFloat Client::get_float_list(const Glib::ustring& key) const
{
    return SListHandle_ValueFloat(get_list(key,GCONF_VALUE_FLOAT),Glib::OWNERSHIP_DEEP);
}

SListHandle_ValueInt Client::get_int_list(const Glib::ustring& key) const
{
    return SListHandle_ValueInt(get_list(key,GCONF_VALUE_INT),Glib::OWNERSHIP_DEEP);
}

SListHandle_ValueBool Client::get_bool_list(const Glib::ustring& key) const
{
    return SListHandle_ValueBool(get_list(key,GCONF_VALUE_BOOL),Glib::OWNERSHIP_DEEP);
}

SListHandle_ValueSchema Client::get_schema_list(const Glib::ustring& key) const
{
    return SListHandle_ValueSchema(get_list(key,GCONF_VALUE_SCHEMA),Glib::OWNERSHIP_DEEP);
}

SListHandle_ValueString Client::get_string_list(const Glib::ustring& key) const
{
    return SListHandle_ValueString(get_list(key,GCONF_VALUE_STRING),Glib::OWNERSHIP_DEEP);
}

void Client::set_int_list(const Glib::ustring& key, const SListHandleInts& what)
{
  /* debugging code:
  std::list<int> testListIntFromGet = what;
  for(std::list<int>::iterator iter = testListIntFromGet.begin(); iter != testListIntFromGet.end(); ++iter)
  {
    int a = *iter;
    g_warning("set_int_list(): %d", a);
  }
  
  GSList* slist = what.data();
  GSList* next = slist;
  while(next)
  {
    g_warning("next->data: %d", *((int*)(next->data)));
    next = next->next;
  }
  */
  
  GError* error = 0;
  gconf_client_set_list(gobj(), key.c_str(), GCONF_VALUE_INT, what.data(), &error);
  if(error) ::Glib::Error::throw_exception(error);
}

void Client::set_bool_list(const Glib::ustring& key, const SListHandleBools& what)
{
  GError* error = 0;
  gconf_client_set_list(gobj(), key.c_str(), GCONF_VALUE_BOOL, what.data(), &error);
  if(error) ::Glib::Error::throw_exception(error);
}

void Client::set_float_list(const Glib::ustring& key, const SListHandleFloats& what)
{
  GError* error = 0;
  gconf_client_set_list(gobj(), key.c_str(), GCONF_VALUE_FLOAT, what.data(), &error);
  if(error) ::Glib::Error::throw_exception(error);
}

void Client::set_schema_list(const Glib::ustring& key, const Glib::SListHandle<Schema>& what)
{
  GError* error = 0;
  gconf_client_set_list(gobj(), key.c_str(), GCONF_VALUE_SCHEMA, what.data(), &error);
  if(error) ::Glib::Error::throw_exception(error);
}

void Client::set_string_list(const Glib::ustring& key, const Glib::SListHandle<Glib::ustring>& what)
{
  GError* error = 0;
  gconf_client_set_list(gobj(), key.c_str(), GCONF_VALUE_STRING, what.data(), &error);
  if(error) ::Glib::Error::throw_exception(error);
}

GSList* Client::get_list(const Glib::ustring& key, GConfValueType list_type) const
{
  GError* error = 0;
  GSList* list = gconf_client_get_list(const_cast<GConfClient*>(gobj()), key.c_str(), list_type, &error);
  handle_error(error);
  for(GSList *i=list;i!=NULL;i=i->next)
  {
    GConfValue* v = gconf_value_new(list_type);
    switch(list_type)
    {
      case GCONF_VALUE_INT:
        gconf_value_set_int(v,(int)i->data);
        break;
      case GCONF_VALUE_BOOL:
        gconf_value_set_bool(v,(gboolean)i->data);
        break;
      case GCONF_VALUE_FLOAT:
        gconf_value_set_float(v,*(gdouble*)i->data);
        g_free(i->data);
        break;
      case GCONF_VALUE_STRING:
        gconf_value_set_string(v,(char*)i->data);
        g_free(i->data);
        break;
      case GCONF_VALUE_SCHEMA:
        gconf_value_set_schema_nocopy(v,(GConfSchema*)i->data);
        break;
      default:
        g_assert_not_reached();
    }

    i->data=v;
  }

  return list;
}

ValuePair Client::get_pair(const Glib::ustring& key, ValueTypePair types) const
{
  PrimitiveHolder carp(types.first),cdrp(types.second);
  GError* error = 0;

  gconf_client_get_pair(const_cast<GConfClient*>(gobj()),
    key.c_str(),
    (GConfValueType)types.first, (GConfValueType)types.second,
    carp.get_addr(), cdrp.get_addr(),
    &error);
  handle_error(error);
    
  return ValuePair(Value(carp.make_value()), Value(cdrp.make_value()));
}


void Client::handle_error(GError* error) const
{
  if(error)
    Glib::Error::throw_exception(error);
}

Entry Client::get_entry(const Glib::ustring& key, bool use_schema_default) const
{
  GError *error = 0;
  Entry retvalue = Entry(gconf_client_get_entry(const_cast<GConfClient*>(gobj()), key.c_str(), 0, static_cast<int>(use_schema_default), &(error)));
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

} /* namespace Conf */
} /* namespace Gnome */


namespace
{

void Client_signal_value_changed_callback(GConfClient* self, const gchar* p0,GConfValue* p1,void* data)
{
  using namespace Gnome::Conf;
  typedef sigc::slot< void,const Glib::ustring&,const Value& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::convert_const_gchar_ptr_to_ustring(p0)
, Value(p1, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

const Glib::SignalProxyInfo Client_signal_value_changed_info =
{
  "value_changed",
  (GCallback) &Client_signal_value_changed_callback,
  (GCallback) &Client_signal_value_changed_callback
};


void Client_signal_unreturned_error_callback(GConfClient* self, GError* p0,void* data)
{
  using namespace Gnome::Conf;
  typedef sigc::slot< void,const Glib::Error& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::Error(p0, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

const Glib::SignalProxyInfo Client_signal_unreturned_error_info =
{
  "unreturned_error",
  (GCallback) &Client_signal_unreturned_error_callback,
  (GCallback) &Client_signal_unreturned_error_callback
};


void Client_signal_error_callback(GConfClient* self, GError* p0,void* data)
{
  using namespace Gnome::Conf;
  typedef sigc::slot< void,const Glib::Error& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::Error(p0, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

const Glib::SignalProxyInfo Client_signal_error_info =
{
  "error",
  (GCallback) &Client_signal_error_callback,
  (GCallback) &Client_signal_error_callback
};

} // anonymous namespace

// static
GType Glib::Value<Gnome::Conf::ClientErrorHandlingMode>::value_type()
{
  return gconf_client_error_handling_mode_get_type();
}

// static
GType Glib::Value<Gnome::Conf::ClientPreloadType>::value_type()
{
  return gconf_client_preload_type_get_type();
}


Gnome::Conf::Error::Error(Gnome::Conf::Error::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (GCONF_ERROR, error_code, error_message)
{}

Gnome::Conf::Error::Error(GError* gobject)
:
  Glib::Error (gobject)
{}

Gnome::Conf::Error::Code Gnome::Conf::Error::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

void Gnome::Conf::Error::throw_func(GError* gobject)
{
  throw Gnome::Conf::Error(gobject);
}

// static
GType Glib::Value<Gnome::Conf::Error::Code>::value_type()
{
  return gconf_error_get_type();
}


namespace Glib
{

Glib::RefPtr<Gnome::Conf::Client> wrap(GConfClient* object, bool take_copy)
{
  return Glib::RefPtr<Gnome::Conf::Client>( dynamic_cast<Gnome::Conf::Client*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gnome
{

namespace Conf
{


/* The *_Class implementation: */

const Glib::Class& Client_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Client_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gconf_client_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void Client_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->value_changed = &value_changed_callback;
  klass->unreturned_error = &unreturned_error_callback;
  klass->error = &error_callback;
}


void Client_Class::value_changed_callback(GConfClient* self, const gchar* p0, GConfValue* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_value_changed(Glib::convert_const_gchar_ptr_to_ustring(p0)
, Value(p1, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->value_changed)
      (*base->value_changed)(self, p0, p1);
  }
}

void Client_Class::unreturned_error_callback(GConfClient* self, GError* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_unreturned_error(Glib::Error(p0, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->unreturned_error)
      (*base->unreturned_error)(self, p0);
  }
}

void Client_Class::error_callback(GConfClient* self, GError* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_error(Glib::Error(p0, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->error)
      (*base->error)(self, p0);
  }
}


Glib::ObjectBase* Client_Class::wrap_new(GObject* object)
{
  return new Client((GConfClient*)object);
}


/* The implementation: */

GConfClient* Client::gobj_copy()
{
  reference();
  return gobj();
}

Client::Client(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{}

Client::Client(GConfClient* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

Client::~Client()
{}


Client::CppClassType Client::client_class_; // initialize static member

GType Client::get_type()
{
  return client_class_.init().get_type();
}

GType Client::get_base_type()
{
  return gconf_client_get_type();
}


void Client::add_dir(const Glib::ustring& dir, ClientPreloadType preload)
{
  GError *error = 0;
  gconf_client_add_dir(gobj(), dir.c_str(), ((GConfClientPreloadType)(preload)), &(error));
  if(error) ::Glib::Error::throw_exception(error);

}

void Client::remove_dir(const Glib::ustring& dir)
{
  GError *error = 0;
  gconf_client_remove_dir(gobj(), dir.c_str(), &(error));
  if(error) ::Glib::Error::throw_exception(error);

}

void Client::notify_remove(guint cnxn)
{
  GError *error = 0;
  gconf_client_notify_remove(gobj(), cnxn);
  if(error) ::Glib::Error::throw_exception(error);

}

void Client::set_error_handling(ClientErrorHandlingMode mode)
{
  gconf_client_set_error_handling(gobj(), ((GConfClientErrorHandlingMode)(mode)));
}

void Client::clear_cache()
{
  gconf_client_clear_cache(gobj());
}

void Client::preload(const Glib::ustring& dirname, ClientPreloadType type)
{
  GError *error = 0;
  gconf_client_preload(gobj(), dirname.c_str(), ((GConfClientPreloadType)(type)), &(error));
  if(error) ::Glib::Error::throw_exception(error);

}

Value Client::get(const Glib::ustring& key) const
{
  GError *error = 0;
  Value retvalue = Value(gconf_client_get(const_cast<GConfClient*>(gobj()), key.c_str(), &(error)));
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

Value Client::get_without_default(const Glib::ustring& key) const
{
  GError *error = 0;
  Value retvalue = Value(gconf_client_get_without_default(const_cast<GConfClient*>(gobj()), key.c_str(), &(error)));
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

Value Client::get_default_from_schema(const Glib::ustring& key) const
{
  GError *error = 0;
  Value retvalue = Value(gconf_client_get_default_from_schema(const_cast<GConfClient*>(gobj()), key.c_str(), &(error)));
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

Entry Client::get_entry(const Glib::ustring& key, const char* locale, bool use_schema_default) const
{
  GError *error = 0;
  Entry retvalue = Entry(gconf_client_get_entry(const_cast<GConfClient*>(gobj()), key.c_str(), locale, static_cast<int>(use_schema_default), &(error)));
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

void Client::unset(const Glib::ustring& key)
{
  GError *error = 0;
  gconf_client_unset(gobj(), key.c_str(), &(error));
  if(error) ::Glib::Error::throw_exception(error);

}

Glib::SListHandle<Entry> Client::all_entries(const Glib::ustring& dir) const
{
  GError *error = 0;
  Glib::SListHandle<Entry> retvalue = Glib::SListHandle<Entry>(gconf_client_all_entries(const_cast<GConfClient*>(gobj()), dir.c_str(), &(error)), Glib::OWNERSHIP_SHALLOW);
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

Glib::SListHandle<Glib::ustring> Client::all_dirs(const Glib::ustring& dir) const
{
  GError *error = 0;
  Glib::SListHandle<Glib::ustring> retvalue = Glib::SListHandle<Glib::ustring>(gconf_client_all_dirs(const_cast<GConfClient*>(gobj()), dir.c_str(), &(error)), Glib::OWNERSHIP_DEEP);
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

void Client::suggest_sync()
{
  GError *error = 0;
  gconf_client_suggest_sync(gobj(), &(error));
  if(error) ::Glib::Error::throw_exception(error);

}

bool Client::dir_exists(const Glib::ustring& p1) const
{
  GError *error = 0;
  bool retvalue = gconf_client_dir_exists(const_cast<GConfClient*>(gobj()), p1.c_str(), &(error));
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

bool Client::key_is_writable(const Glib::ustring& p1) const
{
  GError *error = 0;
  bool retvalue = gconf_client_key_is_writable(const_cast<GConfClient*>(gobj()), p1.c_str(), &(error));
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

double Client::get_float(const Glib::ustring& key) const
{
  GError *error = 0;
  double retvalue = gconf_client_get_float(const_cast<GConfClient*>(gobj()), key.c_str(), &(error));
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

gint Client::get_int(const Glib::ustring& key) const
{
  GError *error = 0;
  gint retvalue = gconf_client_get_int(const_cast<GConfClient*>(gobj()), key.c_str(), &(error));
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

bool Client::get_bool(const Glib::ustring& key) const
{
  GError *error = 0;
  bool retvalue = gconf_client_get_bool(const_cast<GConfClient*>(gobj()), key.c_str(), &(error));
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

Glib::ustring Client::get_string(const Glib::ustring& key) const
{
  GError *error = 0;
  Glib::ustring retvalue = Glib::convert_return_gchar_ptr_to_ustring(gconf_client_get_string(const_cast<GConfClient*>(gobj()), key.c_str(), &(error)));
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

Schema Client::get_schema(const Glib::ustring& key) const
{
  GError *error = 0;
  Schema retvalue = Schema(gconf_client_get_schema(const_cast<GConfClient*>(gobj()), key.c_str(), &(error)));
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

void Client::set(const Glib::ustring& key, int what)
{
  GError *error = 0;
  gconf_client_set_int(gobj(), key.c_str(), what, &(error));
  if(error) ::Glib::Error::throw_exception(error);

}

void Client::set(const Glib::ustring& key, bool what)
{
  GError *error = 0;
  gconf_client_set_bool(gobj(), key.c_str(), static_cast<int>(what), &(error));
  if(error) ::Glib::Error::throw_exception(error);

}

void Client::set(const Glib::ustring& key, double what)
{
  GError *error = 0;
  gconf_client_set_float(gobj(), key.c_str(), what, &(error));
  if(error) ::Glib::Error::throw_exception(error);

}

void Client::set(const Glib::ustring& key, const Glib::ustring& what)
{
  GError *error = 0;
  gconf_client_set_string(gobj(), key.c_str(), what.c_str(), &(error));
  if(error) ::Glib::Error::throw_exception(error);

}

void Client::set(const Glib::ustring& key, const Schema& what)
{
  GError *error = 0;
  gconf_client_set_schema(gobj(), key.c_str(), (what).gobj(), &(error));
  if(error) ::Glib::Error::throw_exception(error);

}

void Client::set(const Glib::ustring& key, const Value& what)
{
  GError *error = 0;
  gconf_client_set(gobj(), key.c_str(), (what).gobj(), &(error));
  if(error) ::Glib::Error::throw_exception(error);

}

ChangeSet Client::change_set_from_current(const Glib::SArray& set)
{
  GError *error = 0;
  ChangeSet retvalue = ChangeSet(gconf_client_change_set_from_currentv(gobj(), const_cast<const char**>((set).data()), &(error)));
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

void Client::change_set_commit(ChangeSet& set, bool remove_commited)
{
  GError *error = 0;
  gconf_client_commit_change_set(gobj(), (set).gobj(), static_cast<int>(remove_commited), &(error));
  if(error) ::Glib::Error::throw_exception(error);

}

ChangeSet Client::change_set_reverse(const ChangeSet& set)
{
  GError *error = 0;
  ChangeSet retvalue = ChangeSet(gconf_client_reverse_change_set(gobj(), const_cast<GConfChangeSet*>((set).gobj()), &(error)));
  if(error) ::Glib::Error::throw_exception(error);
  return retvalue;
}

void Client::value_changed(const Glib::ustring& key, const Value& value)
{
  gconf_client_value_changed(gobj(), key.c_str(), const_cast<GConfValue*>(value.gobj()));
}

void Client::unreturned_error(const Glib::Error& error)
{
  gconf_client_unreturned_error(gobj(), const_cast<GError*>(error.gobj()));
}

void Client::error(const Glib::Error& error)
{
  gconf_client_error(gobj(), const_cast<GError*>(error.gobj()));
}


Glib::SignalProxy2< void,const Glib::ustring&,const Value& > Client::signal_value_changed()
{
  return Glib::SignalProxy2< void,const Glib::ustring&,const Value& >(this, &Client_signal_value_changed_info);
}

Glib::SignalProxy1< void,const Glib::Error& > Client::signal_unreturned_error()
{
  return Glib::SignalProxy1< void,const Glib::Error& >(this, &Client_signal_unreturned_error_info);
}

Glib::SignalProxy1< void,const Glib::Error& > Client::signal_error()
{
  return Glib::SignalProxy1< void,const Glib::Error& >(this, &Client_signal_error_info);
}


void Gnome::Conf::Client::on_value_changed(const Glib::ustring& key, const Value& value)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->value_changed)
    (*base->value_changed)(gobj(),key.c_str(),const_cast<GConfValue*>(value.gobj()));
}

void Gnome::Conf::Client::on_unreturned_error(const Glib::Error& error)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unreturned_error)
    (*base->unreturned_error)(gobj(),const_cast<GError*>(error.gobj()));
}

void Gnome::Conf::Client::on_error(const Glib::Error& error)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->error)
    (*base->error)(gobj(),const_cast<GError*>(error.gobj()));
}


} // namespace Conf

} // namespace Gnome


