/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.atk.AtkObject;
import org.gnu.glib.Type;
import org.gnu.glib.Handle;

/**
 *
 */
public class Accessible extends AtkObject 
{
	
	public Accessible(Handle handle) {
		super(handle);
	}
    
    /**
     * Internal static factory method to be used by Java-Gnome only.
     */
    public static Accessible getAccessible(Handle handle) {
        if (handle == null)
            return null;
        
        Accessible obj = (Accessible) getGObjectFromHandle(handle);
        if (obj == null)
            obj = new Accessible(handle);
        
        return obj;
    }
	
	public Widget getWidget() {
		Handle hndl = getWidget(getHandle());
		return Widget.getWidget(hndl);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_accessible_get_type());
	}
	

    native static final protected Handle getWidget (Handle cptr);
    native static final protected int gtk_accessible_get_type ();

}

