/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.glib.Handle;

/**
 * This widget is a horizontal slot containing a slider that can be
 * moved by the mouse.  It is used to allow the user to select a value
 * using the horizontal slide.  
 */
public class HScale extends Scale 
{
	/**
	 * Creates a new HScale widget.
	 * @param adjustment The {@link Adjustment} which sets the range of the 
	 * scale.
	 */
	public HScale(Adjustment adjustment){
		super(gtk_hscale_new(adjustment.getHandle()));
	}

	/**
	 * Creates a new horizontal scale widget that lets the user input a number 
	 * between min and max (including min and max) with the increment step. 
	 * Step must be nonzero; it's the distance the slider moves when using the 
	 * arrow keys to adjust the scale value.
	 * @param min Minimum value
	 * @param max Maximum value
	 * @param step Step increment (tick size) used with keyboard shortcuts
	 */
	public HScale(double min, double max, double step){
		super(gtk_hscale_new_with_range (min, max, step));
	}
	
	/**
	 * Construct a HScale using a handle to a native resource.
	 */
	public HScale(Handle handle) {
	    super(handle);
	}
    
    /**
     * Internal static factory method to be used by Java-Gnome only.
     */
    public static HScale getHScale(Handle handle) {
        if (handle == null)
            return null;
        
        HScale obj = (HScale) getGObjectFromHandle(handle);
        if (obj == null)
            obj = new HScale(handle);
        
        return obj;
    }

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_hscale_get_type());
	}

    native static final protected int gtk_hscale_get_type ();
    native static final protected Handle gtk_hscale_new (Handle adjustment);
    native static final protected Handle gtk_hscale_new_with_range (double min, double max, double step);
}

