// Generated by gtkmmproc -- DO NOT MODIFY!


#include <libgnomevfsmm/file-info.h>
#include <libgnomevfsmm/private/file-info_p.h>

/* $Id: file-info.ccg,v 1.5 2004/04/07 17:39:05 murrayc Exp $ */
// -*- C++ -*- // this is for the .ccg, I realize gensig puts one in

/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomevfs/gnome-vfs-file-info.h>
 
namespace Gnome
{

namespace Vfs
{

bool FileInfo::is_symlink() const
{
  return GNOME_VFS_FILE_INFO_SYMLINK(gobj());
}


} //namespace Vfs

} //namespace Gnome


namespace
{
} // anonymous namespace


/* Why reinterpret_cast<FileInfo*>(gobject) is needed:
 *
 * A FileInfo instance is in fact always a GnomeVFSFileInfo instance.
 * Unfortunately, GnomeVFSFileInfo cannot be a member of FileInfo,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because FileInfo does not have any member data, and
 * it is impossible to derive from it.  This is ensured by not implementing
 * the (protected) default constructor.  The ctor is protected rather than
 * private just to avoid a compile warning.
 */

namespace Glib
{

Glib::RefPtr<Gnome::Vfs::FileInfo> wrap(GnomeVFSFileInfo* object, bool take_copy)
{
  if(take_copy && object)
    gnome_vfs_file_info_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gnome::Vfs::FileInfo>(reinterpret_cast<Gnome::Vfs::FileInfo*>(object));
}

} // namespace Glib


namespace Gnome
{

namespace Vfs
{


// static
Glib::RefPtr<FileInfo> FileInfo::create()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<FileInfo>(reinterpret_cast<FileInfo*>(gnome_vfs_file_info_new()));
}

void FileInfo::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gnome_vfs_file_info_ref(reinterpret_cast<GnomeVFSFileInfo*>(const_cast<FileInfo*>(this)));
}

void FileInfo::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gnome_vfs_file_info_unref(reinterpret_cast<GnomeVFSFileInfo*>(const_cast<FileInfo*>(this)));
}

GnomeVFSFileInfo* FileInfo::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GnomeVFSFileInfo*>(this);
}

const GnomeVFSFileInfo* FileInfo::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GnomeVFSFileInfo*>(this);
}

GnomeVFSFileInfo* FileInfo::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  GnomeVFSFileInfo *const gobject = reinterpret_cast<GnomeVFSFileInfo*>(const_cast<FileInfo*>(this));
  gnome_vfs_file_info_ref(gobject);
  return gobject;
}


void FileInfo::clear()
{
  gnome_vfs_file_info_clear(gobj());
}


Glib::ustring FileInfo::get_mime_type() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_vfs_file_info_get_mime_type(const_cast<GnomeVFSFileInfo*>(gobj())));
}


Glib::RefPtr<FileInfo> FileInfo::duplicate()
{
  return Glib::wrap(gnome_vfs_file_info_dup(gobj()));
}


bool operator==(const FileInfo& lhs, const FileInfo& rhs)
{
  return (gnome_vfs_file_info_matches(lhs.gobj(), rhs.gobj()) != 0);
}

bool operator!=(const FileInfo& lhs, const FileInfo& rhs)
{
  return (gnome_vfs_file_info_matches(lhs.gobj(), rhs.gobj()) == 0);
}


 std::string FileInfo::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(gobj()->name);
}
 
 FileType FileInfo::get_type() const
{
  return (FileType)(gobj()->type);
}
 
 FilePermissions FileInfo::get_permissions() const
{
  return (FilePermissions)(gobj()->permissions);
}
 
 FileFlags FileInfo::get_flags() const
{
  return (FileFlags)(gobj()->flags);
}
 
 guint FileInfo::get_link_count() const
{
  return gobj()->link_count;
}
 
 guint FileInfo::get_uid() const
{
  return gobj()->uid;
}
 
 guint FileInfo::get_gid() const
{
  return gobj()->gid;
}
 
 FileSize FileInfo::get_size() const
{
  return (FileSize)(gobj()->size);
}
 
 FileSize FileInfo::get_block_count() const
{
  return (FileSize)(gobj()->block_count);
}
 
 guint FileInfo::get_io_block_size() const
{
  return gobj()->io_block_size;
}
 
 time_t FileInfo::get_access_time() const
{
  return gobj()->atime;
}
 
 time_t FileInfo::get_modification_time() const
{
  return gobj()->mtime;
}
 
 time_t FileInfo::get_creation_time() const
{
  return gobj()->ctime;
}
 
 std::string FileInfo::get_symlink_name() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(gobj()->symlink_name);
}
 

} // namespace Vfs

} // namespace Gnome


