package colorpicker;

import java.text.NumberFormat;

import org.gnu.gnome.App;
import org.gnu.gnome.ColorPicker;
import org.gnu.gnome.Program;
import org.gnu.gnome.event.ColorPickerEvent;
import org.gnu.gnome.event.ColorPickerListener;
import org.gnu.gtk.Gtk;
import org.gnu.gtk.event.LifeCycleEvent;
import org.gnu.gtk.event.LifeCycleListener;

public class ColorPickerTest implements ColorPickerListener {

    ColorPicker colorPicker;

    public ColorPickerTest() {

        App app = new App("colorpicker", "ColorPicker example");
        app.addListener(new LifeCycleListener() {
            public void lifeCycleEvent(LifeCycleEvent event) {
            }

            public boolean lifeCycleQuery(LifeCycleEvent event) {
                if (event.isOfType(LifeCycleEvent.Type.DELETE)
                        || event.isOfType(LifeCycleEvent.Type.DESTROY))
                    Gtk.mainQuit();
                return false;
            }
        });
        app.setBorderWidth(20);

        colorPicker = new ColorPicker();
        colorPicker.setColorDouble(0.3, 0.2, 0.75, 1.0);
        colorPicker.addListener(this);
        app.setContent(colorPicker);

        System.out.println("The initial values are: 0.3, 0.2, 0.75, 1.0");

        app.showAll();
    }

    public void colorPickerEvent(ColorPickerEvent cpe) {
        Object o = cpe.getSource();
        if (o == colorPicker) {
            StringBuffer sb = new StringBuffer("The updated values are: ");
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(3);
            sb.append(nf.format(colorPicker.getRedDouble()));
            sb.append(", ");
            sb.append(nf.format(colorPicker.getGreenDouble()));
            sb.append(", ");
            sb.append(nf.format(colorPicker.getBlueDouble()));
            sb.append(", ");
            sb.append(nf.format(colorPicker.getAlphaDouble()));
            System.out.println(sb.toString());
        }
    }

    public static void main(String[] args) {

        Program.initGnomeUI("ColorPickerTest", "1.0", args);

        ColorPickerTest cp = new ColorPickerTest();

        Gtk.main();
    }
}
