/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.glib.Handle;

/**
 * VButtonBox is a container designed to display a collection of buttons
 * vertically.
 * <p>
 * The methods for manipulating this widget are all stored in it's super class,
 * ButtonBox.
 * 
 * @see ButtonBox
 * @see HButtonBox
 */
public class VButtonBox extends ButtonBox {
    /**
     * Creates a new VButtonBox Object, ready to have widgets added to it.
     */
    public VButtonBox() {
        super(gtk_vbutton_box_new());
    }

    /**
     * Construct a new VButtonBox from a handle to a native resource.
     */
    public VButtonBox(Handle handle) {
        super(handle);
    }

    /**
     * Internal static factory method to be used by Java-Gnome only.
     */
    public static VButtonBox getVButtonBox(Handle handle) {
        if (handle == null)
            return null;

        VButtonBox obj = (VButtonBox) getGObjectFromHandle(handle);
        if (obj == null)
            obj = new VButtonBox(handle);

        return obj;
    }

    /**
     * Retrieve the runtime type used by the GLib library.
     */
    public static Type getType() {
        return new Type(gtk_vbutton_box_get_type());
    }

    native static final protected int gtk_vbutton_box_get_type();

    native static final protected Handle gtk_vbutton_box_new();

    /*
     * native static final private int gtk_vbutton_box_get_spacing_default();
     * native static final private void gtk_vbutton_box_set_spacing_default(int
     * spacing); native static final private int
     * gtk_vbutton_box_get_layout_default(); native static final private void
     * gtk_vbutton_box_set_layout_default(int layout);
     */
}
