// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_RECENTMANAGER_H
#define _GTKMM_RECENTMANAGER_H


#include <glibmm.h>

/* Copyright (C) 2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdkmm/screen.h>
#include <gdkmm/pixbuf.h>

#include <gtkmm/recentinfo.h>

#include <glibmm/object.h>
#include <glibmm/containers.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkRecentManager GtkRecentManager;
typedef struct _GtkRecentManagerClass GtkRecentManagerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class RecentManager_Class; } // namespace Gtk
namespace Gtk
{

/** Exception class for Gtk::RecentManager errors.
 */
class RecentManagerError : public Glib::Error
{
public:
  enum Code
  {
    NOT_FOUND,
    INVALID_URI,
    INVALID_ENCODING,
    NOT_REGISTERED,
    READ,
    WRITE,
    UNKNOWN
  };

  RecentManagerError(Code error_code, const Glib::ustring& error_message);
  explicit RecentManagerError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::RecentManagerError::Code> : public Glib::Value_Enum<Gtk::RecentManagerError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** @defgroup RecentFiles RecentFiles
 */

/** RecentManager provides a facility for adding, removing and
 * looking up recently used files.  Each recently used file is
 * identified by its URI, and has meta-data associated to it, like
 * the names and command lines of the applications that have
 * registered it, the number of time each application has registered
 * the same file, the mime type of the file and whether the file
 * should be displayed only by the applications that have
 * registered it.
 *
 * The RecentManager acts like a database of all the recently
 * used files.  You can create new RecentManager objects, but
 * it is more efficient to use the standard recent manager for
 * the Gdk::Screen so that informations about the recently used
 * files is shared with other people using them. Normally, you
 * retrieve the recent manager for a particular screen using
 * get_for_screen() and it will contain information about current
 * recent manager for that screen.
 *
 * @newin2p10
 *
 * @ingroup RecentFiles
 */

class RecentManager : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef RecentManager CppObjectType;
  typedef RecentManager_Class CppClassType;
  typedef GtkRecentManager BaseObjectType;
  typedef GtkRecentManagerClass BaseClassType;

private:  friend class RecentManager_Class;
  static CppClassType recentmanager_class_;

private:
  // noncopyable
  RecentManager(const RecentManager&);
  RecentManager& operator=(const RecentManager&);

protected:
  explicit RecentManager(const Glib::ConstructParams& construct_params);
  explicit RecentManager(GtkRecentManager* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~RecentManager();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkRecentManager*       gobj()       { return reinterpret_cast<GtkRecentManager*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkRecentManager* gobj() const { return reinterpret_cast<GtkRecentManager*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkRecentManager* gobj_copy();

private:


protected:
  RecentManager();

public:
  
  static Glib::RefPtr<RecentManager> create();


  static Glib::RefPtr<RecentManager> get_default();
  
  static Glib::RefPtr<RecentManager> get_for_screen(const Glib::RefPtr<Gdk::Screen>& screen);

  /** Meta-data passed to add_item().  You should
   * use RecentManager::Data if you want to control the meta-data associated
   * to an entry of the recently used files list when you are adding
   * a new file to it.
   *
   * - display_name: the string to be used when displaying the file inside a RecentChooser
   * - description: a user readable description of the file
   * - mime_type: the mime type of the file
   * - app_name: the name of the application that is registering the file
   * - app_exec: the command line that should be used when launching the file
   * - groups: the list of group names to which the file belongs to
   * - is_private: whether the file should be displayed only by the applications that have registered it
  */
  class Data
  { 
  public:
    Glib::ustring display_name;
    Glib::ustring description;
    
    Glib::ustring mime_type;
    
    Glib::ustring app_name;
    Glib::ustring app_exec;
    
    Glib::StringArrayHandle groups;
  
    bool is_private;
  };

 
  void set_screen(const Glib::RefPtr<Gdk::Screen>& screen);
  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool add_item(const Glib::ustring& uri);
#else
  bool add_item(const Glib::ustring& uri, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  bool add_item(const Glib::ustring& uri, const Data& recent_data);
  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool remove_item(const Glib::ustring& uri);
#else
  bool remove_item(const Glib::ustring& uri, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<RecentInfo> lookup_item(const Glib::ustring& uri);
#else
  Glib::RefPtr<RecentInfo> lookup_item(const Glib::ustring& uri, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<const RecentInfo> lookup_item(const Glib::ustring& uri) const;
#else
  Glib::RefPtr<const RecentInfo> lookup_item(const Glib::ustring& uri, std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  bool has_item(const Glib::ustring& uri) const;
  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool move_item(const Glib::ustring& uri, const Glib::ustring& new_uri);
#else
  bool move_item(const Glib::ustring& uri, const Glib::ustring& new_uri, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  void set_limit(int limit);
  
  int get_limit() const;

  typedef Glib::ListHandle<RecentInfo, RecentInfoTraits> ListHandle_RecentInfos;
  

  ListHandle_RecentInfos get_items() const;

  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  int purge_items();
#else
  int purge_items(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /// For instance, void on_changed();
  typedef sigc::slot<void> SlotChanged;

  /** The "changed" signal is emitted when an item in the recently used resources list is changed.
  *
   * @par Prototype:
   * <tt>void %changed()</tt>
   */

  Glib::SignalProxy0< void > signal_changed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The full path to the file to be used to store and read the list.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_filename() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The maximum number of items to be returned by gtk_recent_manager_get_items.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_limit() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The maximum number of items to be returned by gtk_recent_manager_get_items.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_limit() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The size of the recently used resources list.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_size() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_changed();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::RecentManager
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gtk::RecentManager> wrap(GtkRecentManager* object, bool take_copy = false);
}


#endif /* _GTKMM_RECENTMANAGER_H */

