// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_INPUTSTREAM_H
#define _GIOMM_INPUTSTREAM_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>

#include <giomm/asyncresult.h>
#include <giomm/cancellable.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GInputStream GInputStream;
typedef struct _GInputStreamClass GInputStreamClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class InputStream_Class; } // namespace Gio
namespace Gio
{

//TODO: Implement operator << and >> for streams?

/** Base class for implementing streaming input.
 *
 * @newin2p16
 */

class InputStream : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef InputStream CppObjectType;
  typedef InputStream_Class CppClassType;
  typedef GInputStream BaseObjectType;
  typedef GInputStreamClass BaseClassType;

private:  friend class InputStream_Class;
  static CppClassType inputstream_class_;

private:
  // noncopyable
  InputStream(const InputStream&);
  InputStream& operator=(const InputStream&);

protected:
  explicit InputStream(const Glib::ConstructParams& construct_params);
  explicit InputStream(GInputStream* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~InputStream();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GInputStream*       gobj()       { return reinterpret_cast<GInputStream*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GInputStream* gobj() const { return reinterpret_cast<GInputStream*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GInputStream* gobj_copy();

private:


public:
  
  /** Tries to read @a count  bytes from the stream into the buffer starting at
   *  @a buffer . Will block during this read.
   * 
   * If count is zero returns zero and does nothing. A value of @a count 
   * larger than G::MAXSSIZE will cause a G::IO_ERROR_INVALID_ARGUMENT error.
   * 
   * On success, the number of bytes read into the buffer is returned.
   * It is not an error if this is not the same as the requested size, as it
   * can happen e.g. near the end of a file. Zero is returned on end of file
   * (or if @a count  is zero),  but never otherwise.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G_IO_ERROR_CANCELLED will be returned. If an
   * operation was partially finished when the operation was cancelled the
   * partial result will be returned, without an error.
   * 
   * On error -1 is returned and @a error  is set accordingly.
   * @param buffer A buffer to read data into (which should be at least count bytes long).
   * @param count The number of bytes that will be read from the stream.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error Location to store the error occuring, or <tt>0</tt> to ignore.
   * @return Number of bytes read, or -1 on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize read(void* buffer, gsize count, const Glib::RefPtr<Cancellable>& cancellable);
#else
  gssize read(void* buffer, gsize count, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Tries to read @a count bytes from the stream into the buffer starting at
   *  @a buffer. Will block during this read.
   * 
   * If count is zero returns zero and does nothing. A value of @a count 
   * larger than MAXSSIZE will cause an IO_ERROR_INVALID_ARGUMENT error.
   * 
   * On success, the number of bytes read into the buffer is returned.
   * It is not an error if this is not the same as the requested size, as it
   * can happen e.g. near the end of a file. Zero is returned on end of file
   * (or if @a count is zero), but never otherwise.
   * 
   * On error -1 is returned and @a error is set accordingly.
   * @param buffer A buffer to read data into (which should be at least count bytes long).
   * @param count The number of bytes that will be read from the stream.
   * @return Number of bytes read, or -1 on error.
   */
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize read(void* buffer, gsize count);
  #else
  gssize read(void* buffer, gsize count, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  //TODO: gssize read(std::string& buffer, const Glib::RefPtr<Cancellable>& cancellable);
  //TODO: gssize read(std::string& buffer);

  
  /** Tries to read @a count  bytes from the stream into the buffer starting at
   *  @a buffer . Will block during this read.
   * 
   * This function is similar to g_input_stream_read(), except it tries to
   * read as many bytes as requested, only stopping on an error or end of stream.
   * 
   * On a successful read of @a count  bytes, or if we reached the end of the
   * stream,  <tt>true</tt> is returned, and @a bytes_read  is set to the number of bytes
   * read into @a buffer .
   * 
   * If there is an error during the operation <tt>false</tt> is returned and @a error 
   * is set to indicate the error status, @a bytes_read  is updated to contain
   * the number of bytes read into @a buffer  before the error occured.
   * @param buffer A buffer to read data into (which should be at least count bytes long).
   * @param count The number of bytes that will be read from the stream.
   * @param bytes_read Location to store the number of bytes that was read from the stream.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error Location to store the error occuring, or <tt>0</tt> to ignore.
   * @return <tt>true</tt> on success, <tt>false</tt> if there was an error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool read_all(void* buffer, gsize count, gsize& bytes_read, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool read_all(void* buffer, gsize count, gsize& bytes_read, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Tries to read @a count bytes from the stream into the buffer starting at
   *  @a buffer. Will block during this read.
   * 
   * This function is similar to read(), except it tries to
   * read as many bytes as requested, only stopping on an error or end of stream.
   * 
   * On a successful read of @a count bytes, or if we reached the end of the
   * stream, <tt>true</tt> is returned, and @a bytes_read is set to the number of bytes
   * read into @a buffer .
   * 
   * If there is an error during the operation <tt>false</tt> is returned and @a error 
   * is set to indicate the error status, @a bytes_read is updated to contain
   * the number of bytes read into @a buffer before the error occured.
   * @param buffer A buffer to read data into (which should be at least count bytes long).
   * @param count The number of bytes that will be read from the stream.
   * @param bytes_read Location to store the number of bytes that was read from the stream.
   * @return <tt>true</tt> on success, <tt>false</tt> if there was an error.
   */  
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool read_all(void* buffer, gsize count, gsize& bytes_read);
  #else
  bool read_all(void* buffer, gsize count, gsize& bytes_read, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  //TODO: bool read_all(std::string& buffer, gsize count, gsize& bytes_read, const Glib::RefPtr<Cancellable>& cancellable);
  //TODO: bool read_all(std::string& buffer, gsize count, gsize& bytes_read)

  
  /** Tries to skip @a count  bytes from the stream. Will block during the operation.
   * 
   * This is identical to g_input_stream_read(), from a behaviour standpoint,
   * but the bytes that are skipped are not returned to the user. Some
   * streams have an implementation that is more efficient than reading the data.
   * 
   * This function is optional for inherited classes, as the default implementation
   * emulates it using read.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned. If an
   * operation was partially finished when the operation was cancelled the
   * partial result will be returned, without an error.
   * @param count The number of bytes that will be skipped from the stream.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error Location to store the error occuring, or <tt>0</tt> to ignore.
   * @return Number of bytes skipped, or -1 on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize skip(gsize count, const Glib::RefPtr<Cancellable>& cancellable);
#else
  gssize skip(gsize count, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Tries to skip @a count bytes from the stream. Will block during the operation.
   * 
   * This is identical to read(), from a behaviour standpoint,
   * but the bytes that are skipped are not returned to the user. Some
   * streams have an implementation that is more efficient than reading the data.
   * 
   * This function is optional for inherited classes, as the default implementation
   * emulates it using read.
   * 
   * @param count The number of bytes that will be skipped from the stream.
   * @return Number of bytes skipped, or -1 on error.
   */
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize skip(gsize count);
  #else
  gssize skip(gsize count, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Closes the stream, releasing resources related to it.
   * 
   * Once the stream is closed, all other operations will return G::IO_ERROR_CLOSED.
   * Closing a stream multiple times will not return an error.
   * 
   * Streams will be automatically closed when the last reference
   * is dropped, but you might want to call make sure resources
   * are released as early as possible.
   * 
   * Some streams might keep the backing store of the stream (e.g. a file descriptor)
   * open after the stream is closed. See the documentation for the individual
   * stream for details.
   * 
   * On failure the first error that happened will be reported, but the close
   * operation will finish as much as possible. A stream that failed to
   * close will still return G::IO_ERROR_CLOSED all operations. Still, it
   * is important to check and report the error to the user.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * Cancelling a close will still leave the stream closed, but some streams
   * can use a faster close that doesn't block to e.g. check errors.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error Location to store the error occuring, or <tt>0</tt> to ignore.
   * @return <tt>true</tt> on success, <tt>false</tt> on failure.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool close(const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool close(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Closes the stream, releasing resources related to it.
   * 
   * Once the stream is closed, all other operations will return IO_ERROR_CLOSED.
   * Closing a stream multiple times will not return an error.
   * 
   * Streams will be automatically closed when the last reference
   * is dropped, but you might want to call this make sure resources
   * are released as early as possible.
   * 
   * Some streams might keep the backing store of the stream (e.g. a file descriptor)
   * open after the stream is closed. See the documentation for the individual
   * stream for details.
   * 
   * On failure the first error that happened will be reported, but the close
   * operation will finish as much as possible. A stream that failed to
   * close will still return IO_ERROR_CLOSED all operations. Still, it
   * is important to check and report the error to the user.
   * 
   * @return <tt>true</tt> on success, <tt>false</tt> on failure.
   */
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool close();
  #else
  bool close(std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  /** Request an asynchronous read of @a count bytes from the stream into the buffer
   * starting at @a buffer. When the operation is finished @a slot will be called. 
   * You can then call read_finish() to get the result of the 
   * operation.
   *
   * During an async request no other sync and async calls are allowed, and will
   * result in IO_ERROR_PENDING errors. 
   *
   * A value of @a count larger than MAXSSIZE will cause an IO_ERROR_INVALID_ARGUMENT error.
   *
   * On success, the number of bytes read into the buffer will be passed to the
   * @a slot callback. It is not an error if this is not the same as the requested size, as it
   * can happen e.g. near the end of a file, but generally we try to read
   * as many bytes as requested. Zero is returned on end of file
   * (or if @a count is zero), but never otherwise.
   *
   * Any outstanding i/o request with higher priority (lower numerical value) will
   * be executed before an outstanding request with lower priority. Default
   * priority is PRIORITY_DEFAULT.
   *
   * The asyncronous methods have a default fallback that uses threads to implement
   * asynchronicity, so they are optional for inheriting classes. However, if you
   * override one you must override all.
   *
   * @param buffer A buffer to read data into (which should be at least count bytes long).
   * @param count The number of bytes that will be read from the stream.
   * @param slot Callback to call when the request is satisfied.
   * @param cancellable A Cancellable object.
   * @param io_priority The I/O priority of the request. 
   */
  void read_async(void* buffer, gsize count, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, int io_priority = G_PRIORITY_DEFAULT);

  /** Request an asynchronous read of @a count bytes from the stream into the buffer
   * starting at @a buffer. When the operation is finished @a slot will be called. 
   * You can then call read_finish() to get the result of the 
   * operation.
   *
   * During an async request no other sync and async calls are allowed, and will
   * result in IO_ERROR_PENDING errors. 
   *
   * A value of @a count larger than MAXSSIZE will cause an IO_ERROR_INVALID_ARGUMENT error.
   *
   * On success, the number of bytes read into the buffer will be passed to the
   * @a slot callback. It is not an error if this is not the same as the requested size, as it
   * can happen e.g. near the end of a file, but generally we try to read
   * as many bytes as requested. Zero is returned on end of file
   * (or if @a count is zero), but never otherwise.
   *
   * Any outstanding i/o request with higher priority (lower numerical value) will
   * be executed before an outstanding request with lower priority. Default
   * priority is PRIORITY_DEFAULT.
   *
   * The asyncronous methods have a default fallback that uses threads to implement
   * asynchronicity, so they are optional for inheriting classes. However, if you
   * override one you must override all.
   *
   * @param buffer A buffer to read data into (which should be at least count bytes long).
   * @param count The number of bytes that will be read from the stream.
   * @param slot Callback to call when the request is satisfied.
   * @param io_priority The I/O priority of the request. 
   */
  void read_async(void* buffer, gsize count, const SlotAsyncReady& slot, int io_priority = G_PRIORITY_DEFAULT);
  

  /** Finishes an asynchronous stream read operation.
   * @param result A G::AsyncResult.
   * @param error A G::Error location to store the error occuring, or <tt>0</tt> to 
   * ignore.
   * @return Number of bytes read in, or -1 on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize read_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  gssize read_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  //TODO: Use std::size_type instead of gsize?

  /** Request an asynchronous skip of @a count bytes from the stream into the buffer
   * starting at @a buffer. When the operation is finished @a slot will be called. 
   * You can then call skip_finish() to get the result of the operation.
   *
   * During an async request no other sync and async calls are allowed, and will
   * result in IO_ERROR_PENDING errors. 
   *
   * A value of @a count larger than MAXSSIZE will cause an IO_ERROR_INVALID_ARGUMENT error.
   *
   * On success, the number of bytes skipped will be passed to the
   * callback. It is not an error if this is not the same as the requested size, as it
   * can happen e.g. near the end of a file, but generally we try to skip
   * as many bytes as requested. Zero is returned on end of file
   * (or if @a count is zero), but never otherwise.
   *
   * Any outstanding i/o request with higher priority (lower numerical value) will
   * be executed before an outstanding request with lower priority. Default
   * priority is PRIORITY_DEFAULT.
   *
   * The asyncronous methods have a default fallback that uses threads to implement
   * asynchronicity, so they are optional for inheriting classes. However, if you
   * override one you must override all.
   *
   * @param count The number of bytes that will be skipped from the stream.
   * @param slot Callback to call when the request is satisfied.
   * @param cancellable A Cancellable object.
   * @param io_priority The I/O priority of the request. 
   */
  void skip_async(gsize count, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, int io_priority = G_PRIORITY_DEFAULT);

  /** Request an asynchronous skip of @a count bytes from the stream into the buffer
   * starting at @a buffer. When the operation is finished @a slot will be called. 
   * You can then call skip_finish() to get the result of the operation.
   *
   * During an async request no other sync and async calls are allowed, and will
   * result in IO_ERROR_PENDING errors. 
   *
   * A value of @a count larger than MAXSSIZE will cause an IO_ERROR_INVALID_ARGUMENT error.
   *
   * On success, the number of bytes skipped will be passed to the
   * callback. It is not an error if this is not the same as the requested size, as it
   * can happen e.g. near the end of a file, but generally we try to skip
   * as many bytes as requested. Zero is returned on end of file
   * (or if @a count is zero), but never otherwise.
   *
   * Any outstanding i/o request with higher priority (lower numerical value) will
   * be executed before an outstanding request with lower priority. Default
   * priority is PRIORITY_DEFAULT.
   *
   * The asyncronous methods have a default fallback that uses threads to implement
   * asynchronicity, so they are optional for inheriting classes. However, if you
   * override one you must override all.
   *
   * @param count The number of bytes that will be skipped from the stream.
   * @param slot Callback to call when the request is satisfied.
   * @param io_priority The I/O priority of the request. 
   */
  void skip_async(gsize count, const SlotAsyncReady& slot, int io_priority = G_PRIORITY_DEFAULT);
  

  /** Finishes a stream skip operation.
   * @param result A G::AsyncResult.
   * @param error A G::Error location to store the error occuring, or <tt>0</tt> to 
   * ignore.
   * @return The size of the bytes skipped, or %-1 on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize skip_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  gssize skip_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Requests an asynchronous closes of the stream, releasing resources related to it.
   * When the operation is finished @a slot will be called. 
   * You can then call close_finish() to get the result of the 
   * operation.
   *
   * For behaviour details see close().
   *
   * The asyncronous methods have a default fallback that uses threads to implement
   * asynchronicity, so they are optional for inheriting classes. However, if you
   * override one you must override all.
   *
   * @param slot Callback to call when the request is satisfied.
   * @param cancellable A Cancellable object.
   * @param io_priority The I/O priority of the request. 
   */
  void close_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, int io_priority = G_PRIORITY_DEFAULT);

  /** Requests an asynchronous closes of the stream, releasing resources related to it.
   * When the operation is finished @a slot will be called. 
   * You can then call close_finish() to get the result of the 
   * operation.
   *
   * For behaviour details see close().
   *
   * The asyncronous methods have a default fallback that uses threads to implement
   * asynchronicity, so they are optional for inheriting classes. However, if you
   * override one you must override all.
   *
   * @param slot Callback to call when the request is satisfied.
   * @param io_priority The I/O priority of the request. 
   */
  void close_async(const SlotAsyncReady& slot, int io_priority = G_PRIORITY_DEFAULT);
  

  /** Finishes closing a stream asynchronously, started from g_input_stream_close_async().
   * @param result A G::AsyncResult.
   * @param error A G::Error location to store the error occuring, or <tt>0</tt> to 
   * ignore.
   * @return <tt>true</tt> if the stream was closed successfully.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gboolean close_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  gboolean close_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  // These are private inside the module (for implementations)
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::InputStream
   */
  Glib::RefPtr<Gio::InputStream> wrap(GInputStream* object, bool take_copy = false);
}


#endif /* _GIOMM_INPUTSTREAM_H */

