// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DATAOUTPUTSTREAM_H
#define _GIOMM_DATAOUTPUTSTREAM_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <giomm/bufferedoutputstream.h>
#include <giomm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GDataOutputStream GDataOutputStream;
typedef struct _GDataOutputStreamClass GDataOutputStreamClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class DataOutputStream_Class; } // namespace Gio
namespace Gio
{

/**
 * An implementation of BufferedOutputStream that allows for high-level data
 * manipulation of arbitrary data (including binary operations).
 *
 * @newin2p16
 */

class DataOutputStream : public Gio::BufferedOutputStream
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataOutputStream CppObjectType;
  typedef DataOutputStream_Class CppClassType;
  typedef GDataOutputStream BaseObjectType;
  typedef GDataOutputStreamClass BaseClassType;

private:  friend class DataOutputStream_Class;
  static CppClassType dataoutputstream_class_;

private:
  // noncopyable
  DataOutputStream(const DataOutputStream&);
  DataOutputStream& operator=(const DataOutputStream&);

protected:
  explicit DataOutputStream(const Glib::ConstructParams& construct_params);
  explicit DataOutputStream(GDataOutputStream* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataOutputStream();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GDataOutputStream*       gobj()       { return reinterpret_cast<GDataOutputStream*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GDataOutputStream* gobj() const { return reinterpret_cast<GDataOutputStream*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDataOutputStream* gobj_copy();

private:


  explicit DataOutputStream(const Glib::RefPtr<OutputStream>& base_stream);
public:

  
  static Glib::RefPtr<DataOutputStream> create(const Glib::RefPtr<OutputStream>& base_stream);


  /** Sets the byte order of the data output stream to @a order.
   * @param order A DataStreamByteOrder.
   */
  void set_byte_order(DataStreamByteOrder order);
  
  /** Gets the byte order for the stream.
   * @return The DataStreamByteOrder for the @a stream.
   */
  DataStreamByteOrder get_byte_order() const;
  //gtkmmproc error: g_data_output_stream_set_newline_type : method defs lookup failed (1)
  //gtkmmproc error: g_data_output_stream_get_newline_type : method defs lookup failed (1)

  
  /** Puts a byte into the output stream.
   * @param data A #guchar.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return <tt>true</tt> if @a data was successfully added to the @a stream.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_byte(guchar data, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool put_byte(guchar data, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** non-cancellable version of put_byte()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_byte(guchar data);
#else
  bool put_byte(guchar data, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Puts a signed 16-bit integer into the output stream.
   * @param data A #gint16.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return <tt>true</tt> if @a data was successfully added to the @a stream.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_int16(gint16 data, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool put_int16(gint16 data, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** non-cancellable version of put_int16()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_int16(gint16 data);
#else
  bool put_int16(gint16 data, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Puts an unsigned 16-bit integer into the output stream.
   * @param data A #guint16.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return <tt>true</tt> if @a data was successfully added to the @a stream.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_uint16(guint16 data, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool put_uint16(guint16 data, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** non-cancellable version of put_uint16()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_uint16(guint16 data);
#else
  bool put_uint16(guint16 data, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Puts a signed 32-bit integer into the output stream.
   * @param data A #gint32.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return <tt>true</tt> if @a data was successfully added to the @a stream.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_int32(gint32 data, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool put_int32(gint32 data, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** non-cancellable version of put_int32()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_int32(gint32 data);
#else
  bool put_int32(gint32 data, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Puts an unsigned 32-bit integer into the stream.
   * @param data A #guint32.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return <tt>true</tt> if @a data was successfully added to the @a stream.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_uint32(guint32 data, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool put_uint32(guint32 data, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** non-cancellable version of put_uint32()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_uint32(guint32 data);
#else
  bool put_uint32(guint32 data, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Puts a signed 64-bit integer into the stream.
   * @param data A #gint64.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return <tt>true</tt> if @a data was successfully added to the @a stream.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_int64(gint64 data, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool put_int64(gint64 data, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** non-cancellable version of put_int64()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_int64(gint64 data);
#else
  bool put_int64(gint64 data, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Puts an unsigned 64-bit integer into the stream.
   * @param data A #guint64.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return <tt>true</tt> if @a data was successfully added to the @a stream.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_uint64(guint64 data, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool put_uint64(guint64 data, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** non-cancellable version of put_uint64()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_uint64(guint64 data);
#else
  bool put_uint64(guint64 data, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Puts a string into the output stream.
   * @param str A string.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return <tt>true</tt> if @a string was successfully added to the @a stream.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_string(std::string str, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool put_string(std::string str, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** non-cancellable version of put_string()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool put_string(std::string str);
#else
  bool put_string(std::string str, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DataOutputStream
   */
  Glib::RefPtr<Gio::DataOutputStream> wrap(GDataOutputStream* object, bool take_copy = false);
}


#endif /* _GIOMM_DATAOUTPUTSTREAM_H */

