// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_EMBLEM_H
#define _GIOMM_EMBLEM_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <giomm/icon.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GEmblem GEmblem;
typedef struct _GEmblemClass GEmblemClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class Emblem_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums Enums and Flags */

/**
 * @ingroup giommEnums
 */
enum EmblemOrigin
{
  EMBLEM_ORIGIN_UNKNOWN,
  EMBLEM_ORIGIN_DEVICE,
  EMBLEM_ORIGIN_LIVEMETADATA,
  EMBLEM_ORIGIN_TAG
};


/** An object for emblems
 *
 * Emblem is an implementation of GIcon that supports having an emblem, which
 * is an icon with additional properties. It can than be added to a
 * EmblemedIcon.
 *
 * Currently, only metainformation about the emblem's origin is supported. More
 * may be added in the future.
 *
 * @newin2p20
 */

class Emblem
: public Glib::Object,
  public Icon
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Emblem CppObjectType;
  typedef Emblem_Class CppClassType;
  typedef GEmblem BaseObjectType;
  typedef GEmblemClass BaseClassType;

private:  friend class Emblem_Class;
  static CppClassType emblem_class_;

private:
  // noncopyable
  Emblem(const Emblem&);
  Emblem& operator=(const Emblem&);

protected:
  explicit Emblem(const Glib::ConstructParams& construct_params);
  explicit Emblem(GEmblem* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Emblem();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GEmblem*       gobj()       { return reinterpret_cast<GEmblem*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GEmblem* gobj() const { return reinterpret_cast<GEmblem*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GEmblem* gobj_copy();

private:

  
protected:
  //TODO: Documentation:
 explicit Emblem(const Glib::RefPtr<Icon>& icon);
 explicit Emblem(const Glib::RefPtr<Icon>& icon, EmblemOrigin origin);

public:
  
  static Glib::RefPtr<Emblem> create(const Glib::RefPtr<Icon>& icon);

  
  static Glib::RefPtr<Emblem> create(const Glib::RefPtr<Icon>& icon, EmblemOrigin origin);


  /** Gives back the icon from @a emblem.
   * @return A Icon. The returned object belongs to the emblem
   * and should not be modified or freed.
   * 
   * @newin2p18.
   */
  Glib::RefPtr<Icon> get_icon();
  
  /** Gives back the icon from @a emblem.
   * @return A Icon. The returned object belongs to the emblem
   * and should not be modified or freed.
   * 
   * @newin2p18.
   */
  Glib::RefPtr<const Icon> get_icon() const;
  
  /** Gets the origin of the emblem.
   * @return The origin of the emblem
   * 
   * @newin2p18.
   */
  EmblemOrigin get_origin() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::Emblem
   */
  Glib::RefPtr<Gio::Emblem> wrap(GEmblem* object, bool take_copy = false);
}


#endif /* _GIOMM_EMBLEM_H */

