// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DBUSCONNECTION_H
#define _GIOMM_DBUSCONNECTION_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <giomm/iostream.h>
#include <giomm/asyncresult.h>
#include <giomm/credentials.h>
#include <giomm/dbusmessage.h>


//TODO: Use a GDbus namespace, and remove the DBus prefixes.
#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GDBusConnection GDBusConnection;
typedef struct _GDBusConnectionClass GDBusConnectionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class DBusConnection_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums giomm Enums and Flags */

/**
 * @ingroup giommEnums
 */
enum BusType
{
  BUS_TYPE_STARTER = -1,
  BUS_TYPE_NONE,
  BUS_TYPE_SYSTEM,
  BUS_TYPE_SESSION
};

} // namespace Gio


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gio::BusType> : public Glib::Value_Enum<Gio::BusType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{

/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%DBusCapabilityFlags operator|(DBusCapabilityFlags, DBusCapabilityFlags)</tt><br>
 * <tt>%DBusCapabilityFlags operator&(DBusCapabilityFlags, DBusCapabilityFlags)</tt><br>
 * <tt>%DBusCapabilityFlags operator^(DBusCapabilityFlags, DBusCapabilityFlags)</tt><br>
 * <tt>%DBusCapabilityFlags operator~(DBusCapabilityFlags)</tt><br>
 * <tt>%DBusCapabilityFlags& operator|=(DBusCapabilityFlags&, DBusCapabilityFlags)</tt><br>
 * <tt>%DBusCapabilityFlags& operator&=(DBusCapabilityFlags&, DBusCapabilityFlags)</tt><br>
 * <tt>%DBusCapabilityFlags& operator^=(DBusCapabilityFlags&, DBusCapabilityFlags)</tt><br>
 */
enum DBusCapabilityFlags
{
  DBUS_CAPABILITY_FLAGS_NONE = 0x0,
  DBUS_CAPABILITY_FLAGS_UNIX_FD_PASSING = (1<<0)
};

/** @ingroup giommEnums */
inline DBusCapabilityFlags operator|(DBusCapabilityFlags lhs, DBusCapabilityFlags rhs)
  { return static_cast<DBusCapabilityFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusCapabilityFlags operator&(DBusCapabilityFlags lhs, DBusCapabilityFlags rhs)
  { return static_cast<DBusCapabilityFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusCapabilityFlags operator^(DBusCapabilityFlags lhs, DBusCapabilityFlags rhs)
  { return static_cast<DBusCapabilityFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusCapabilityFlags operator~(DBusCapabilityFlags flags)
  { return static_cast<DBusCapabilityFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline DBusCapabilityFlags& operator|=(DBusCapabilityFlags& lhs, DBusCapabilityFlags rhs)
  { return (lhs = static_cast<DBusCapabilityFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusCapabilityFlags& operator&=(DBusCapabilityFlags& lhs, DBusCapabilityFlags rhs)
  { return (lhs = static_cast<DBusCapabilityFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusCapabilityFlags& operator^=(DBusCapabilityFlags& lhs, DBusCapabilityFlags rhs)
  { return (lhs = static_cast<DBusCapabilityFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%DBusSendMessageFlags operator|(DBusSendMessageFlags, DBusSendMessageFlags)</tt><br>
 * <tt>%DBusSendMessageFlags operator&(DBusSendMessageFlags, DBusSendMessageFlags)</tt><br>
 * <tt>%DBusSendMessageFlags operator^(DBusSendMessageFlags, DBusSendMessageFlags)</tt><br>
 * <tt>%DBusSendMessageFlags operator~(DBusSendMessageFlags)</tt><br>
 * <tt>%DBusSendMessageFlags& operator|=(DBusSendMessageFlags&, DBusSendMessageFlags)</tt><br>
 * <tt>%DBusSendMessageFlags& operator&=(DBusSendMessageFlags&, DBusSendMessageFlags)</tt><br>
 * <tt>%DBusSendMessageFlags& operator^=(DBusSendMessageFlags&, DBusSendMessageFlags)</tt><br>
 */
enum DBusSendMessageFlags
{
  DBUS_SEND_MESSAGE_FLAGS_NONE = 0x0,
  DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL = (1<<0)
};

/** @ingroup giommEnums */
inline DBusSendMessageFlags operator|(DBusSendMessageFlags lhs, DBusSendMessageFlags rhs)
  { return static_cast<DBusSendMessageFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusSendMessageFlags operator&(DBusSendMessageFlags lhs, DBusSendMessageFlags rhs)
  { return static_cast<DBusSendMessageFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusSendMessageFlags operator^(DBusSendMessageFlags lhs, DBusSendMessageFlags rhs)
  { return static_cast<DBusSendMessageFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusSendMessageFlags operator~(DBusSendMessageFlags flags)
  { return static_cast<DBusSendMessageFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline DBusSendMessageFlags& operator|=(DBusSendMessageFlags& lhs, DBusSendMessageFlags rhs)
  { return (lhs = static_cast<DBusSendMessageFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusSendMessageFlags& operator&=(DBusSendMessageFlags& lhs, DBusSendMessageFlags rhs)
  { return (lhs = static_cast<DBusSendMessageFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusSendMessageFlags& operator^=(DBusSendMessageFlags& lhs, DBusSendMessageFlags rhs)
  { return (lhs = static_cast<DBusSendMessageFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


//TODO: Add example from C API in class docs.
/** DBusConnection - D-Bus Connections.
 * The DBusConnection type is used for D-Bus connections to remote peers such
 * as a message buses. It is a low-level API that offers a lot of flexibility.
 * For instance, it lets you establish a connection over any transport that
 * can by represented as an IOStream.
 *
 * This class is rarely used directly in D-Bus clients. If you are writing an
 * D-Bus client, it is often easier to use the Gio::DBus::own_name(),
 * Gio::DBus::watch_name() or DBusProxy::create_for_bus() APIs.
 *
 * @newin{2,26}
 */

class DBusConnection : public Glib::Object
{
protected:
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DBusConnection CppObjectType;
  typedef DBusConnection_Class CppClassType;
  typedef GDBusConnection BaseObjectType;
  typedef GDBusConnectionClass BaseClassType;

private:  friend class DBusConnection_Class;
  static CppClassType dbusconnection_class_;

private:
  // noncopyable
  DBusConnection(const DBusConnection&);
  DBusConnection& operator=(const DBusConnection&);

protected:
  explicit DBusConnection(const Glib::ConstructParams& construct_params);
  explicit DBusConnection(GDBusConnection* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DBusConnection();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GDBusConnection*       gobj()       { return reinterpret_cast<GDBusConnection*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GDBusConnection* gobj() const { return reinterpret_cast<GDBusConnection*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusConnection* gobj_copy();

private:


public:


  //TODO: Documentation.
  void close();
  
  //TODO: Documentation.
  void close(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable);
  
  //TODO: Documentation.
  void close(const SlotAsyncReady& slot);
  
  
  bool close_finish(const Glib::RefPtr<AsyncResult>& result);
               
  //TODO: Documentation.
  void close_sync();
  
  //TODO: Documentation.
  
  void close_sync(const Glib::RefPtr<Cancellable>& cancellable);


  //TODO: Documentation.
  void flush();
  
  //TODO: Documentation.
  void flush(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable);
  
  //TODO: Documentation.
  void flush(const SlotAsyncReady& slot);
  
  
  bool flush_finish(const Glib::RefPtr<AsyncResult>& result);
               
  //TODO: Documentation.
  void flush_sync();
  
  //TODO: Documentation.
  
  void flush_sync(const Glib::RefPtr<Cancellable>& cancellable);

  //TODO: In the C API, out_serial is volatile, but gmmproc can't parse that.
   

  bool send_message(const Glib::RefPtr<DBusMessage>& message, DBusSendMessageFlags flags, guint32* out_serial);
                                                                   
    //TODO: Documentation.
  
  void send_message_with_reply(const Glib::RefPtr<DBusMessage>& message, int timeout_msec, const Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot);

  
  Glib::RefPtr<DBusMessage> send_message_with_reply_finish(const Glib::RefPtr<AsyncResult>& result);

  
  void start_message_processing();
  
  bool is_closed() const;
  
  
  Glib::RefPtr<IOStream> get_stream();
  
  Glib::RefPtr<const IOStream> get_stream() const;
  
  
  Glib::ustring get_guid() const;
  
  Glib::ustring get_unique_name() const;
  
  
  Glib::RefPtr<Credentials> get_peer_credentials();
  
  Glib::RefPtr<const Credentials> get_peer_credentials() const;
  
  
  bool get_exit_on_close() const;
  
  void set_exit_on_close(bool exit_on_close = true);
  
  DBusCapabilityFlags get_capabilities() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};


} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusConnection
   */
  Glib::RefPtr<Gio::DBusConnection> wrap(GDBusConnection* object, bool take_copy = false);
}


#endif /* _GIOMM_DBUSCONNECTION_H */

