// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gtkmm/printjob.h>
#include <gtkmm/private/printjob_p.h>

// -*- c++ -*-
/* Copyright (C) 2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkunixprint.h>

// This Signal Proxy allows the C++ coder to specify a sigc::slot instead of a static function.

static void SignalProxy_Custom_gtk_callback(GtkPrintJob* print_job, gpointer data, GError* gerror)
{
  const Gtk::PrintJob::SlotPrintJobComplete* the_slot = static_cast<Gtk::PrintJob::SlotPrintJobComplete*>(data);

  try
  {

    // Create a suitable C++ instance to pass to the C++ method;
    Glib::RefPtr<Gtk::PrintJob> job = Glib::wrap(print_job);

    if (gerror) Glib::Error::throw_exception(gerror);
    (*the_slot)(job);

  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

static void SignalProxy_Custom_gtk_callback_destroy(void* data)
{
  delete static_cast<Gtk::PrintJob::SlotPrintJobComplete*>(data);
}

namespace Gtk
{

void PrintJob::send(const SlotPrintJobComplete& slot)
{
  // Create a copy of the slot. A pointer to this will be passed through the callback's data parameter.
  // It will be deleted when SignalProxy_Custom_gtk_callback_destroy() is called.
  SlotPrintJobComplete* slot_copy = new SlotPrintJobComplete(slot);
      
  gtk_print_job_send(gobj(), &SignalProxy_Custom_gtk_callback, slot_copy, &SignalProxy_Custom_gtk_callback_destroy);
}

} // namespace Gtk

namespace
{


static const Glib::SignalProxyInfo PrintJob_signal_status_changed_info =
{
  "status_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::PrintJob> wrap(GtkPrintJob* object, bool take_copy)
{
  return Glib::RefPtr<Gtk::PrintJob>( dynamic_cast<Gtk::PrintJob*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& PrintJob_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &PrintJob_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_print_job_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void PrintJob_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->status_changed = &status_changed_callback;
}


void PrintJob_Class::status_changed_callback(GtkPrintJob* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_status_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->status_changed)
    (*base->status_changed)(self);
}


Glib::ObjectBase* PrintJob_Class::wrap_new(GObject* object)
{
  return new PrintJob((GtkPrintJob*)object);
}


/* The implementation: */

GtkPrintJob* PrintJob::gobj_copy()
{
  reference();
  return gobj();
}

PrintJob::PrintJob(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

PrintJob::PrintJob(GtkPrintJob* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


PrintJob::~PrintJob()
{}


PrintJob::CppClassType PrintJob::printjob_class_; // initialize static member

GType PrintJob::get_type()
{
  return printjob_class_.init().get_type();
}


GType PrintJob::get_base_type()
{
  return gtk_print_job_get_type();
}


PrintJob::PrintJob(const Glib::ustring& title, const Glib::RefPtr<Printer>& printer, const Glib::RefPtr<PrintSettings>& settings, const Glib::RefPtr<PageSetup>& page_setup)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(printjob_class_.init(), "title", title.c_str(), "printer", Glib::unwrap(printer), "settings", Glib::unwrap(settings), "page_setup", Glib::unwrap(page_setup), static_cast<char*>(0)))
{
  

}

Glib::RefPtr<PrintJob> PrintJob::create(const Glib::ustring& title, const Glib::RefPtr<Printer>& printer, const Glib::RefPtr<PrintSettings>& settings, const Glib::RefPtr<PageSetup>& page_setup)
{
  return Glib::RefPtr<PrintJob>( new PrintJob(title, printer, settings, page_setup) );
}
Glib::RefPtr<PrintSettings> PrintJob::get_settings()
{

  Glib::RefPtr<PrintSettings> retvalue = Glib::wrap(gtk_print_job_get_settings(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const PrintSettings> PrintJob::get_settings() const
{
  return const_cast<PrintJob*>(this)->get_settings();
}

Glib::RefPtr<Printer> PrintJob::get_printer()
{

  Glib::RefPtr<Printer> retvalue = Glib::wrap(gtk_print_job_get_printer(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Printer> PrintJob::get_printer() const
{
  return const_cast<PrintJob*>(this)->get_printer();
}

Glib::ustring PrintJob::get_title() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_print_job_get_title(const_cast<GtkPrintJob*>(gobj())));
}

PrintStatus PrintJob::get_status() const
{
  return (PrintStatus)gtk_print_job_get_status(const_cast<GtkPrintJob*>(gobj()));
}

void PrintJob::set_source_file(const std::string& filename)
{
  GError* gerror = 0;
  gtk_print_job_set_source_file(gobj(), filename.c_str(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);


}

Cairo::RefPtr<Cairo::Surface> PrintJob::get_surface()
{
  GError* gerror = 0;
  Cairo::RefPtr<Cairo::Surface> retvalue = Cairo::RefPtr<Cairo::Surface>(new Cairo::Surface(gtk_print_job_get_surface(gobj(), &(gerror)), false /* take reference */));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

Cairo::RefPtr<const Cairo::Surface> PrintJob::get_surface() const
{
  GError* gerror = 0;
  Cairo::RefPtr<const Cairo::Surface> retvalue = Cairo::RefPtr<Cairo::Surface>(new Cairo::Surface(gtk_print_job_get_surface(const_cast<GtkPrintJob*>(gobj()), &(gerror)), false /* take reference */));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

void PrintJob::set_track_print_status(bool track_status)
{
gtk_print_job_set_track_print_status(gobj(), static_cast<int>(track_status)); 
}

bool PrintJob::get_track_print_status() const
{
  return gtk_print_job_get_track_print_status(const_cast<GtkPrintJob*>(gobj()));
}


Glib::SignalProxy0< void > PrintJob::signal_status_changed()
{
  return Glib::SignalProxy0< void >(this, &PrintJob_signal_status_changed_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> PrintJob::property_title() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "title");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Printer> > PrintJob::property_printer() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Printer> >(this, "printer");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<PrintSettings> > PrintJob::property_settings() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<PrintSettings> >(this, "settings");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<PageSetup> > PrintJob::property_page_setup() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<PageSetup> >(this, "page-setup");
}
#endif //GLIBMM_PROPERTIES_ENABLED


void Gtk::PrintJob::on_status_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->status_changed)
    (*base->status_changed)(gobj());
}


} // namespace Gtk


