/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:31 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * This is a container widget that is capable of controlling the size
 * of a single child widget. The scale values are from 0.0 to 1.0,
 * indicating the maximum amount the child can expand to fill the space
 * allocated to the Alignment widget. The align values determine the
 * x and y positions relative to the top left and bottom right corners
 * of the Alignment rectangle. The align values are from 0.0 to the
 * top or left side, and 1.0 for the bottom or right side.
 */
public class Alignment extends Bin {
	
	/**
	 * Construct a new Alignment.
	 * @param xAlign The horizontal alignment of the child widget from 0 (left)
	 * to 1 (right).
	 * @param yAlign The vertical alignment of the child widget from 0 (top)
	 * to 1 (bottom).
	 * @param xScale The amount that the child widget expands horizontally to
	 * fill up unused space, from 0 to 1.  A value of 0 indicates that the child
	 * widget should never expand.  A value of 1 indicates that the child widget
	 * will expand to fill all of the space allocated for the Alignment.
	 * @param yScale The amount that the child widget expands vertically to
	 * fill up unused space, from 0 to 1.  The values are similar to xScale.
	 */
	public Alignment(double xAlign, double yAlign, double xScale, double yScale) {
		handle = Alignment.gtk_alignment_new(xAlign, yAlign, xScale, yScale);
		initializeEventHandlers();
	}
	
	/**
	 * Construct an alignment using a handle to a native resource.
	 */
	public Alignment(int handle) {
	    super(handle);
	}

	protected void noopInit() {}
	
	/**
	 * Set the alignment and scale for an already created Alignment object.
	 * @param xAlign The horizontal alignment of the child widget from 0 (left)
	 * to 1 (right).
	 * @param yAlign The vertical alignment of the child widget from 0 (top)
	 * to 1 (bottom).
	 * @param xScale The amount that the child widget expands horizontally to
	 * fill up unused space, from 0 to 1.  A value of 0 indicates that the child
	 * widget should never expand.  A value of 1 indicates that the child widget
	 * will expand to fill all of the space allocated for the Alignment.
	 * @param yScale The amount that the child widget expands vertically to
	 * fill up unused space, from 0 to 1.  The values are similar to xScale.
	 */
	public void set(double xAlign, double yAlign, double xScale, double yScale) {
		Alignment.gtk_alignment_set(handle, xAlign, yAlign, xScale, yScale);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_alignment_get_type());
	}
	
	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_alignment_get_type();
	native static final protected int gtk_alignment_new(double xalign, double yalign, double xscale, double yscale);
	native static final protected void gtk_alignment_set(int alignment, double xalign, double yalign, double xscale, double yscale);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
