/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:36 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * A Viewport is a container that does not resize to fit in the
 * space allocated to it. Instead, it adds scrollbars as necessary so
 * you can view any part of the window.
 */
public class Viewport extends Bin 
{
	/**
	 * Construct a new Viewport with the given Adjustments.
	 * 
	 * @param hadj The horizontal Adjustment to use for the Viewport.
	 * @param vadj The vertical Adjustment to use for the Viewport.
	 */
	public Viewport(Adjustment hadj, Adjustment vadj) {
		int horizontal = 0;
		int vertical = 0;
		if (null != hadj) {
			horizontal = hadj.getHandle();
		}
		if (null != vadj) {
			vertical = vadj.getHandle();
		}
		handle = Viewport.gtk_viewport_new(horizontal, vertical);
		initializeEventHandlers();
	}
	
	/**
	 * Construct a Viewport using a handle to a native resource.
	 */
	public Viewport(int handle) {
	    super(handle);
	}

	protected void noopInit() {}
	
	/**
	 * Returns the horizontal Viewport's Adjustment.  This can be used
	 * to connect the horizontal scrollbar to the child Widget's 
	 * horizontal scroll functionality.
	 * 
	 * @return The horizontal Viewport's Adjustment.
	 */
	public Adjustment getHAdjustment() {
		int hndl = Viewport.gtk_viewport_get_hadjustment(handle);
		return new Adjustment(hndl);
	}

	/**
	 * Sets the horizontal Viewport's Adjustment.
	 * 
	 * @param hadj The horizontal Adjustment.
	 */
	public void setHAdjustment(Adjustment hadj) {
		Viewport.gtk_viewport_set_hadjustment(handle, hadj.getHandle());
	}

	/**
	 * Returns the vertical Viewport's Adjustment.  This can be used
	 * to connect the vertical scrollbar to the child Widget's 
	 * vertical scroll functionality.
	 * 
	 * @return The vertical Viewport's Adjustment.
	 */
	public Adjustment getVAdjustment() {
		int hndl = Viewport.gtk_viewport_get_vadjustment(handle);
		return new Adjustment(hndl);
	}

	/**
	 * Sets the vertical Viewport's Adjustment.
	 * 
	 * @param vadj The vertical Adjustment.
	 */
	public void setVAdjustment(Adjustment vadj) {
		Viewport.gtk_viewport_set_vadjustment(handle, vadj.getHandle());
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_viewport_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_viewport_get_type ();
    native static final protected int gtk_viewport_new (int hadjustment, int vadjustment);
    native static final protected int gtk_viewport_get_hadjustment (int viewport);
    native static final protected void gtk_viewport_set_hadjustment (int viewport, int adjustment);
    native static final protected int gtk_viewport_get_vadjustment (int viewport);
    native static final protected void gtk_viewport_set_vadjustment (int viewport, int adjustment);
    native static final protected void gtk_viewport_set_shadow_type (int viewport, int type);
    native static final protected int gtk_viewport_get_shadow_type (int viewport);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

