// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_FILECHOOSER_H
#define _GTKMM_FILECHOOSER_H

#include <glibmm.h>

/* $Id: filechooser.hg,v 1.16 2004/03/25 14:36:10 murrayc Exp $ */

/* Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>
#include <gtkmm/filefilter.h>
#include <glibmm/interface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkFileChooser GtkFileChooser;
typedef struct _GtkFileChooserClass GtkFileChooserClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class FileChooser_Class; } // namespace Gtk
namespace Gtk
{

/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum FileChooserAction
{
  FILE_CHOOSER_ACTION_OPEN,
  FILE_CHOOSER_ACTION_SAVE,
  FILE_CHOOSER_ACTION_SELECT_FOLDER,
  FILE_CHOOSER_ACTION_CREATE_FOLDER
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::FileChooserAction> : public Glib::Value_Enum<Gtk::FileChooserAction>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/**
 *
 */

class FileChooser : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef FileChooser CppObjectType;
  typedef FileChooser_Class CppClassType;
  typedef GtkFileChooser BaseObjectType;
  typedef GtkFileChooserClass BaseClassType;

private:
  friend class FileChooser_Class;
  static CppClassType filechooser_class_;

  // noncopyable
  FileChooser(const FileChooser&);
  FileChooser& operator=(const FileChooser&);

protected:
  FileChooser(); // you must derive from this class
  explicit FileChooser(GtkFileChooser* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~FileChooser();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkFileChooser*       gobj()       { return reinterpret_cast<GtkFileChooser*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GtkFileChooser* gobj() const { return reinterpret_cast<GtkFileChooser*>(gobject_); }

private:

public:

  
  /** Sets the type of operation that that the chooser is performing; the
   * user interface is adapted to suit the selected action. For example,
   * an option to create a new folder might be shown if the action is
   * Gtk::FILE_CHOOSER_ACTION_SAVE but not if the action is
   * Gtk::FILE_CHOOSER_ACTION_OPEN.
   * 
   * Since: 2.4
   * @param action The action that the file selector is performing.
   */
  void set_action(FileChooserAction action);
  
  /** Gets the type of operation that the file chooser is performing; see
   * set_action().
   * @return The action that the file selector is performing
   * 
   * Since: 2.4.
   */
  FileChooserAction get_action() const;
  
  /** Sets whether only local files can be selected in the
   * file selector. If @a local_only  is <tt>true</tt> (the default),
   * then the selected file are files are guaranteed to be
   * accessible through the operating systems native file
   * file system and therefore the application only
   * needs to worry about the filename functions in
   * Gtk::FileChooser, like get_filename(),
   * rather than the URI functions like
   * get_uri(),
   * 
   * Since: 2.4
   * @param local_only <tt>true</tt> if only local files can be selected.
   */
  void set_local_only(bool local_only = true);
  
  /** Gets whether only local files can be selected in the
   * file selector. See set_local_only()
   * @return <tt>true</tt> if only local files can be selected.
   * 
   * Since: 2.4.
   */
  bool get_local_only() const;
  
  /** Sets whether multiple files can be selected in the file selector.  This is
   * only relevant if the action is set to be GTK_FILE_CHOOSER_ACTION_OPEN or
   * GTK_FILE_CHOOSER_ACTION_SAVE.  It cannot be set with either of the folder
   * actions.
   * 
   * Since: 2.4
   * @param select_multiple <tt>true</tt> if multiple files can be selected.
   */
  void set_select_multiple(bool select_multiple = true);
  
  /** Gets whether multiple files can be selected in the file
   * selector. See set_select_multiple().
   * @return <tt>true</tt> if multiple files can be selected.
   * 
   * Since: 2.4.
   */
  bool get_select_multiple() const;

  
  /** Sets the current name in the file selector, as if entered
   * by the user. Note that the name passed in here is a UTF-8
   * string rather than a filename. This function is meant for
   * such uses as a suggested name in a "Save As..." dialog.
   * 
   * If you want to preselect a particular existing file, you
   * should use set_filename() instead.
   * 
   * Since: 2.4
   * @param name The filename to use, as a UTF-8 string.
   */
  void set_current_name(const Glib::ustring& name);
  
  /** Gets the filename for the currently selected file in
   * the file selector. If multiple files are selected,
   * one of the filenames will be returned at random.
   * 
   * If the file chooser is in folder mode, this function returns the selected
   * folder.
   * @return The currently selected filename, or an empty string
   * if no file is selected, or the selected file can't
   * be represented with a local filename.
   */
  Glib::ustring get_filename() const;
  
  /** Sets @a filename  as the current filename for the the file chooser;
   * If the file name isn't in the current folder of @a chooser , then the
   * current folder of @a chooser  will be changed to the folder containing
   *  @a filename . This is equivalent to a sequence of
   * unselect_all() followed by select_filename().
   * 
   * Note that the file must exist, or nothing will be done except
   * for the directory change. To pre-enter a filename for the user, as in
   * a save-as dialog, use set_current_name()
   * @param filename The filename to set as current.
   * @return <tt>true</tt> if both the folder could be changed and the file was
   * selected successfully, <tt>false</tt> otherwise.
   * 
   * Since: 2.4.
   */
  bool set_filename(const Glib::ustring& filename);
  
  /** Selects a filename. If the file name isn't in the current
   * folder of @a chooser , then the current folder of @a chooser  will
   * be changed to the folder containing @a filename .
   * @param filename The filename to select.
   * @return <tt>true</tt> if both the folder could be changed and the file was
   * selected successfully, <tt>false</tt> otherwise.
   * 
   * Since: 2.4.
   */
  bool select_filename(const Glib::ustring& filename);
  
  /** Unselects a currently selected filename. If the filename
   * is not in the current directory, does not exist, or
   * is otherwise not currently selected, does nothing.
   * 
   * Since: 2.4
   * @param filename The filename to unselect.
   */
  void unselect_filename(const Glib::ustring& filename);
  
  /** Selects all the files in the current folder of a file chooser.
   * 
   * Since: 2.4
   */
  void select_all();
  
  /** Unselects all the files in the current folder of a file chooser.
   * 
   * Since: 2.4
   */
  void unselect_all();
  
  /** Lists all the selected files and subfolders in the current folder of
   *  @a chooser . The returned names are full absolute paths. If files in the current
   * folder cannot be represented as local filenames they will be ignored. (See
   * get_uris())
   * @return A G::SList containing the filenames of all selected
   * files and subfolders in the current folder. Free the returned list
   * with Glib::slist_free(), and the filenames with Glib::free().
   * 
   * Since: 2.4.
   */
  Glib::SListHandle<Glib::ustring> get_filenames() const;
  
  /** Sets the current folder for @a chooser  from a local filename.
   * The user will be shown the full contents of the current folder,
   * plus user interface elements for navigating to other folders.
   * @param filename The full path of the new current folder.
   * @return <tt>true</tt> if the folder could be changed successfully, <tt>false</tt>
   * otherwise.
   * 
   * Since: 2.4.
   */
  bool set_current_folder(const Glib::ustring& filename);
  
  /** Gets the current folder of @a chooser  as a local filename.
   * See set_current_folder().
   * @return The full path of the current folder, or <tt>0</tt>
   * if the current path cannot be represented as a local filename.
   * Free with Glib::free().
   * 
   * Since: 2.4.
   */
  Glib::ustring get_current_folder() const;


/* URI manipulation
 */
  
  /** Gets the URI for the currently selected file in
   * the file selector. If multiple files are selected,
   * one of the filenames will be returned at random.
   * 
   * If the file chooser is in folder mode, this function returns the selected
   * folder.
   * @return The currently selected URI, or an empty string
   * if no file is selected.
   */
  Glib::ustring get_uri() const;
  
  /** Sets the file referred to by @a uri  as the current file for the the
   * file chooser; If the file name isn't in the current folder of @a chooser ,
   * then the current folder of @a chooser  will be changed to the folder containing
   *  @a uri . This is equivalent to a sequence of unselect_all()
   * followed by select_uri().
   * 
   * Note that the file must exist, or nothing will be done except
   * for the directory change. To pre-enter a filename for the user, as in
   * a save-as dialog, use set_current_name()
   * @param uri The URI to set as current.
   * @return <tt>true</tt> if both the folder could be changed and the URI was
   * selected successfully, <tt>false</tt> otherwise.
   * 
   * Since: 2.4.
   */
  bool set_uri(const Glib::ustring& uri);
  
  /** Selects the file to by @a uri . If the URI doesn't refer to a
   * file in the current folder of @a chooser , then the current folder of
   *  @a chooser  will be changed to the folder containing @a filename .
   * @param uri The URI to select.
   * @return <tt>true</tt> if both the folder could be changed and the URI was
   * selected successfully, <tt>false</tt> otherwise.
   * 
   * Since: 2.4.
   */
  bool select_uri(const Glib::ustring& uri);
  
  /** Unselects the file referred to by @a uri . If the file
   * is not in the current directory, does not exist, or
   * is otherwise not currently selected, does nothing.
   * 
   * Since: 2.4
   * @param uri The URI to unselect.
   */
  void unselect_uri(const Glib::ustring& uri);
  
  /** Lists all the selected files and subfolders in the current folder of
   *  @a chooser . The returned names are full absolute URIs.
   * @return A G::SList containing the URIs of all selected
   * files and subfolders in the current folder. Free the returned list
   * with Glib::slist_free(), and the filenames with Glib::free().
   * 
   * Since: 2.4.
   */
  Glib::SListHandle<Glib::ustring> get_uris() const;

  
  /** Sets the current folder for @a chooser  from an URI.
   * The user will be shown the full contents of the current folder,
   * plus user interface elements for navigating to other folders.
   * @param uri The URI for the new current folder.
   * @return <tt>true</tt> if the folder could be changed successfully, <tt>false</tt>
   * otherwise.
   * 
   * Since: 2.4.
   */
  bool set_current_folder_uri(const Glib::ustring& uri);
  
  /** Gets the current folder of @a chooser  as an URI.
   * See set_current_folder_uri().
   * @return The URI for the current folder.
   */
  Glib::ustring get_current_folder_uri() const;

/* Preview widget
 */
  
  /** Sets an application-supplied widget to use to display a custom preview
   * of the currently selected file. To implement a preview, after setting the
   * preview widget, you connect to the ::selection-changed
   * signal, and call get_preview_filename() or
   * get_preview_uri() on each change. If you can
   * display a preview of the new file, update your widget and
   * set the preview active using set_preview_widget_active().
   * Otherwise, set the preview inactive.
   * 
   * When there is no application-supplied preview widget, or the
   * application-supplied preview widget is not active, the file chooser
   * may display an internally generated preview of the current file or
   * it may display no preview at all.
   * 
   * Since: 2.4
   * @param preview_widget Widget for displaying preview.
   */
  void set_preview_widget(Gtk::Widget& preview_widget);
  
  /** Gets the current preview widget; see
   * set_preview_widget().
   * @return The current preview widget, or <tt>0</tt>
   * 
   * Since: 2.4.
   */
  const Gtk::Widget* get_preview_widget() const;
  
  /** Gets the current preview widget; see
   * set_preview_widget().
   * @return The current preview widget, or <tt>0</tt>
   * 
   * Since: 2.4.
   */
  Gtk::Widget* get_preview_widget();
  
  /** Sets whether the preview widget set by
   * set_preview_widget_active() should be shown for the
   * current filename. When @a active  is set to false, the file chooser
   * may display an internally generated preview of the current file
   * or it may display no preview at all. See
   * set_preview_widget() for more details.
   * 
   * Since: 2.4
   * @param active Whether to display the user-specified preview widget.
   */
  void set_preview_widget_active(bool active = true);
  
  /** Gets whether the preview widget set by set_preview_widget()
   * should be shown for the current filename. See
   * set_preview_widget_active().
   * @return <tt>true</tt> if the preview widget is active for the current filename.
   * 
   * Since: 2.4.
   */
  bool get_preview_widget_active() const;

  
  /** Sets whether the file chooser should display a stock label with the name of
   * the file that is being previewed; the default is <tt>true</tt>.  Applications that
   * want to draw the whole preview area themselves should set this to <tt>false</tt> and
   * display the name themselves in their preview widget.
   * 
   * See also: set_preview_widget()
   * 
   * Since: 2.4
   * @param use_label Whether to display a stock label with the name of the previewed file.
   */
  void set_use_preview_label(bool use_label = true);
  
  /** Gets whether a stock label should be drawn with the name of the previewed
   * file.  See set_use_preview_label().
   * @return <tt>true</tt> if the file chooser is set to display a label with the
   * name of the previewed file, <tt>false</tt> otherwise.
   */
  bool get_use_preview_label() const;

  
  /** Gets the filename that should be previewed in a custom preview
   * widget. See set_preview_widget().
   * @return The filename to preview, or an empty string if no file
   * is selected, or if the selected file cannot be represented
   * as a local filename.
   */
  Glib::ustring get_preview_filename() const;
  
  /** Gets the URI that should be previewed in a custom preview
   * widget. See set_preview_widget().
   * @return The URI for the file to preview, or an empty string if no file is
   * selected.
   */
  Glib::ustring get_preview_uri() const;

/* Extra widget
 */
  
  /** Sets an application-supplied widget to provide extra options to the user.
   * 
   * Since: 2.4
   * @param extra_widget Widget for extra options.
   */
  void set_extra_widget(Gtk::Widget& extra_widget);
  
  /** Gets the current preview widget; see
   * set_extra_widget().
   * @return The current extra widget, or <tt>0</tt>
   * 
   * Since: 2.4.
   */
  Gtk::Widget* get_extra_widget();
  
  /** Gets the current preview widget; see
   * set_extra_widget().
   * @return The current extra widget, or <tt>0</tt>
   * 
   * Since: 2.4.
   */
  const Gtk::Widget* get_extra_widget() const;

/* List of user selectable filters
 */
  
  /** Adds @a filter  to the list of filters that the user can select between.
   * When a filter is selected, only files that are passed by that
   * filter are displayed.
   * 
   * Since: 2.4
   * @param filter A Gtk::FileFilter.
   */
  void add_filter(const FileFilter& filter);
  
  /** Removes @a filter  from the list of filters that the user can select between.
   * 
   * Since: 2.4
   * @param filter A Gtk::FileFilter.
   */
  void remove_filter (const FileFilter& filter);

  
  /** Lists the current set of user-selectable filters; see
   * add_filter(), remove_filter().
   * @return A G::SList containing the current set of
   * user selectable filters. The contents of the list are
   * owned by GTK+, but you must free the list itself with
   * Glib::slist_free() when you are done with it.
   * 
   * Since: 2.4.
   */
  Glib::SListHandle< FileFilter* > list_filters();
  
  /** Lists the current set of user-selectable filters; see
   * add_filter(), remove_filter().
   * @return A G::SList containing the current set of
   * user selectable filters. The contents of the list are
   * owned by GTK+, but you must free the list itself with
   * Glib::slist_free() when you are done with it.
   * 
   * Since: 2.4.
   */
  Glib::SListHandle< const FileFilter* > list_filters() const;
  
/* Current filter
 */
  
  /** Sets the current filter; only the files that pass the
   * filter will be displayed. If the user-selectable list of filters
   * is non-empty, then the filter should be one of the filters
   * in that list. Setting the current filter when the list of
   * filters is empty is useful if you want to restrict the displayed
   * set of files without letting the user change it.
   * 
   * Since: 2.4
   * @param filter A Gtk::FileFilter.
   */
  void set_filter(const FileFilter& filter);
  
  /** Gets the current filter; see set_filter().
   * @return The current filter, or <tt>0</tt>
   * 
   * Since: 2.4.
   */
  FileFilter* get_filter();
  
  /** Gets the current filter; see set_filter().
   * @return The current filter, or <tt>0</tt>
   * 
   * Since: 2.4.
   */
  const FileFilter* get_filter() const;
  
/* Per-application shortcut folders */

  
  /** Adds a folder to be displayed with the shortcut folders in a file chooser.
   * Note that shortcut folders do not get saved, as they are provided by the
   * application.  For example, you can use this to add a
   * "/usr/share/mydrawprogram/Clipart" folder to the volume list.
   * @param folder Filename of the folder to add.
   * @return <tt>true</tt> if the folder could be added successfully, <tt>false</tt>
   * otherwise.  In the latter case, the @a error  will be set as appropriate.
   * 
   * Since: 2.4.
   */
  bool add_shortcut_folder(const Glib::ustring& folder);
  
  /** Removes a folder from a file chooser's list of shortcut folders.
   * @param folder Filename of the folder to remove.
   * @return <tt>true</tt> if the operation succeeds, <tt>false</tt> otherwise.  
   * In the latter case, the @a error  will be set as appropriate.
   * 
   * See also: add_shortcut_folder()
   * 
   * Since: 2.4.
   */
  bool remove_shortcut_folder(const Glib::ustring& folder);
  
  /** Queries the list of shortcut folders in the file chooser, as set by
   * gtk_file_chooser_set_shortcut_folders().
   * @return A list of folder filenames, or <tt>0</tt> if there are no shortcut
   * folders.  Free the returned list with Glib::slist_free(), and the filenames with
   * Glib::free().
   * 
   * Since: 2.4.
   */
  Glib::SListHandle<Glib::ustring> list_shortcut_folders() const;

  
  /** Adds a folder URI to be displayed with the shortcut folders in a file
   * chooser.  Note that shortcut folders do not get saved, as they are provided
   * by the application.  For example, you can use this to add a
   * "file:///usr/share/mydrawprogram/Clipart" folder to the volume list.
   * @param uri URI of the folder to add.
   * @return <tt>true</tt> if the folder could be added successfully, <tt>false</tt>
   * otherwise.  In the latter case, the @a error  will be set as appropriate.
   * 
   * Since: 2.4.
   */
  bool add_shortcut_folder_uri(const Glib::ustring& uri);
  
  /** Removes a folder URI from a file chooser's list of shortcut folders.
   * @param uri URI of the folder to remove.
   * @return <tt>true</tt> if the operation succeeds, <tt>false</tt> otherwise.  
   * In the latter case, the @a error  will be set as appropriate.
   * 
   * See also: add_shortcut_folder_uri()
   * 
   * Since: 2.4.
   */
  bool remove_shortcut_folder_uri(const Glib::ustring& uri);
  
  /** Queries the list of shortcut folders in the file chooser, as set by
   * gtk_file_chooser_set_shortcut_folder_uris().
   * @return A list of folder URIs, or <tt>0</tt> if there are no shortcut
   * folders.  Free the returned list with Glib::slist_free(), and the URIs with
   * Glib::free().
   * 
   * Since: 2.4.
   */
  Glib::SListHandle<Glib::ustring> list_shortcut_folder_uris() const;


  Glib::SignalProxy0< void > signal_current_folder_changed();

  
  Glib::SignalProxy0< void > signal_selection_changed();

  
  Glib::SignalProxy0< void > signal_update_preview();

  
  Glib::SignalProxy0< void > signal_file_activated();


    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<FileChooserAction> property_action() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<FileChooserAction> property_action() const;

  //TODO: _WRAP_PROPERTY("file-system", FileSystem) //FileSystem is not really public API.
    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<FileFilter*> property_filter() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<FileFilter*> property_filter() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_folder_mode() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_folder_mode() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_local_only() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_local_only() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Widget*> property_preview_widget() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Widget*> property_preview_widget() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_preview_widget_active() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_preview_widget_active() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_preview_label() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_preview_label() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Widget*> property_extra_widget() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Widget*> property_extra_widget() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_select_multiple() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_select_multiple() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_hidden() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_hidden() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::FileChooser
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gtk::FileChooser> wrap(GtkFileChooser* object, bool take_copy = false);

} // namespace Glib

#endif /* _GTKMM_FILECHOOSER_H */

