/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * An event represeting action by a {@link org.gnu.gtk.StatusBar} widget.
 */
public class StatusBarEvent extends GtkEvent {
	
	private String text;

	/**
	 * Type of a StatusBarEvent
	 */
	public static class Type extends GtkEventType {
		private Type(int id, String name) {
			super(id, name);
		}

		public static final Type TEXT_PUSHED = new Type(1, "TEXT_PUSHED");

		public static final Type TEXT_POPPED = new Type(2, "TEXT_POPPED");
	}
	
	/**
	 * Creates a new StatusBar Event. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public StatusBarEvent(Object source, StatusBarEvent.Type type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(StatusBarEvent.Type aType) {
		return (type.getID() == aType.getID());
	}
	/**
	 * @return Returns the text.
	 */
	public String getText() {
		return text;
	}

	/**
	 * @param text The text to set.
	 */
	public void setText(String text) {
		this.text = text;
	}

}
