/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

/**
 */
public class RadioToolButton extends ToggleToolButton {
	
	public RadioToolButton(RadioToolButton[] group) {
		super(init1(group));
	}
	
	private static Handle init1(RadioToolButton[] group) {
		if (null == group)
			return gtk_radio_tool_button_new(null);
		else {
		    Handle[] hndls = new Handle[group.length];
			for (int i = 0; i < group.length; i++) {
				hndls[i] = group[i].getHandle();
			}
			return gtk_radio_tool_button_new(hndls);
		}
	}

	public RadioToolButton(RadioToolButton[] group, String stockId) {
		super(init2(group, stockId));
	}
	
	private static Handle init2(RadioToolButton[] group, String stockId) {
		if (null == group)
			return gtk_radio_tool_button_new_from_stock(null, stockId);
		else {
		    Handle[] hndls = new Handle[group.length];
			for (int i = 0; i < group.length; i++) {
				hndls[i] = group[i].getHandle();
			}
			return gtk_radio_tool_button_new_from_stock(hndls, stockId);
		}
	}
	
	public RadioToolButton(RadioToolButton button) {
		super(gtk_radio_tool_button_new_from_widget(button.getHandle()));
	}
	
	public RadioToolButton(RadioToolButton button, String stockId) {
		super(gtk_radio_tool_button_new_with_stock_from_widget(button.getHandle(), stockId));
	}
	
	private RadioToolButton(Handle hndl) {
		super(hndl);
	}
	
	public RadioToolButton[] getGroup() {
	    Handle[] hndls = gtk_radio_tool_button_get_group(getHandle());
		if (null == hndls)
			return null;
		RadioToolButton[] group = new RadioToolButton[hndls.length];
		for (int i = 0; i < hndls.length; i++) {
			GObject obj = retrieveGObject(hndls[i]);
			if (null != obj)
				group[i] = (RadioToolButton)obj;
			else
				group[i] = new RadioToolButton(hndls[i]);
		}
		return group;
	}
	
	public void setGroup(RadioToolButton[] group) {
		if (null == group)
			gtk_radio_tool_button_set_group(getHandle(), null);
		else {
		    Handle[] hndls = new Handle[group.length];
			for (int i = 0; i < group.length; i++) {
				hndls[i] = group[i].getHandle();
			}
			gtk_radio_tool_button_set_group(getHandle(), hndls);
		}
	}
	

	native static final protected int gtk_radio_tool_button_get_type();
	native static final protected Handle gtk_radio_tool_button_new(Handle[] group);
	native static final protected Handle gtk_radio_tool_button_new_from_stock(Handle[] group, String stockId);
	native static final protected Handle gtk_radio_tool_button_new_from_widget(Handle widget);
	native static final protected Handle gtk_radio_tool_button_new_with_stock_from_widget(Handle widget, String stockId);
	native static final protected Handle[] gtk_radio_tool_button_get_group(Handle button);
	native static final protected void gtk_radio_tool_button_set_group(Handle button, Handle[] group);

	
}
