// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DBUSPROXY_H
#define _GIOMM_DBUSPROXY_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <giomm/initable.h>
#include <giomm/asyncinitable.h>
#include <giomm/dbusconnection.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GDBusProxy GDBusProxy;
typedef struct _GDBusProxyClass GDBusProxyClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class DBusProxy_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums giomm Enums and Flags */

/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%DBusProxyFlags operator|(DBusProxyFlags, DBusProxyFlags)</tt><br>
 * <tt>%DBusProxyFlags operator&(DBusProxyFlags, DBusProxyFlags)</tt><br>
 * <tt>%DBusProxyFlags operator^(DBusProxyFlags, DBusProxyFlags)</tt><br>
 * <tt>%DBusProxyFlags operator~(DBusProxyFlags)</tt><br>
 * <tt>%DBusProxyFlags& operator|=(DBusProxyFlags&, DBusProxyFlags)</tt><br>
 * <tt>%DBusProxyFlags& operator&=(DBusProxyFlags&, DBusProxyFlags)</tt><br>
 * <tt>%DBusProxyFlags& operator^=(DBusProxyFlags&, DBusProxyFlags)</tt><br>
 */
enum DBusProxyFlags
{
  DBUS_PROXY_FLAGS_NONE = 0x0,
  DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES = (1<<0),
  DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS = (1<<1),
  DBUS_PROXY_FLAGS_DO_NOT_AUTO_START = (1<<2)
};

/** @ingroup giommEnums */
inline DBusProxyFlags operator|(DBusProxyFlags lhs, DBusProxyFlags rhs)
  { return static_cast<DBusProxyFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusProxyFlags operator&(DBusProxyFlags lhs, DBusProxyFlags rhs)
  { return static_cast<DBusProxyFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusProxyFlags operator^(DBusProxyFlags lhs, DBusProxyFlags rhs)
  { return static_cast<DBusProxyFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusProxyFlags operator~(DBusProxyFlags flags)
  { return static_cast<DBusProxyFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline DBusProxyFlags& operator|=(DBusProxyFlags& lhs, DBusProxyFlags rhs)
  { return (lhs = static_cast<DBusProxyFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusProxyFlags& operator&=(DBusProxyFlags& lhs, DBusProxyFlags rhs)
  { return (lhs = static_cast<DBusProxyFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusProxyFlags& operator^=(DBusProxyFlags& lhs, DBusProxyFlags rhs)
  { return (lhs = static_cast<DBusProxyFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


class AsyncResult;
class DBusConnection;
class DBusInterfaceInfo;

/** DBusProxy - Client-side proxies.
 * DBusProxy is a base class used for proxies to access a D-Bus interface on
 * a remote object. A DBusProxy can be constructed for both well-known and
 * unique names.
 *
 * By default, DBusProxy will cache all properties (and listen to changes) of
 * the remote object, and proxy all signals that gets emitted. This behaviour
 * can be changed by passing suitable DBusProxyFlags when the proxy is
 * created. If the proxy is for a well-known name, the property cache is
 * flushed when the name owner vanishes and reloaded when a name owner
 * appears.
 *
 * If a DBusProxy is used for a well-known name, the owner of the name is
 * tracked and can be read from property_g_name_owner(). Connect to the
 * signal_notify() signal to get notified of changes. Additionally, only
 * signals and property changes emitted from the current name owner are
 * considered. This avoids a number of race conditions when the name is lost
 * by one owner and claimed by another.
 *
 * The generic signal_g_properties_changed() and signal_g_signal() signals are
 * not very convenient to work with. Therefore, the recommended way of working
 * with proxies is to subclass DBusProxy, and have more natural properties and
 * signals in your derived class.
 *
 * The C API docs has more information and an example.
 *
 * @newin{2,26}
 */

class DBusProxy
: public Glib::Object,
  public Initable,
  public AsyncInitable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DBusProxy CppObjectType;
  typedef DBusProxy_Class CppClassType;
  typedef GDBusProxy BaseObjectType;
  typedef GDBusProxyClass BaseClassType;

private:  friend class DBusProxy_Class;
  static CppClassType dbusproxy_class_;

private:
  // noncopyable
  DBusProxy(const DBusProxy&);
  DBusProxy& operator=(const DBusProxy&);

protected:
  explicit DBusProxy(const Glib::ConstructParams& construct_params);
  explicit DBusProxy(GDBusProxy* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DBusProxy();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GDBusProxy*       gobj()       { return reinterpret_cast<GDBusProxy*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GDBusProxy* gobj() const { return reinterpret_cast<GDBusProxy*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusProxy* gobj_copy();

private:


protected:
  DBusProxy(const Glib::RefPtr<DBusConnection>& connection,
    DBusProxyFlags flags, const Glib::RefPtr<DBusInterfaceInfo>& info,
    const Glib::ustring& name, const Glib::ustring& object_path,
    const Glib::ustring& interface_name, const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable);

  DBusProxy(const Glib::RefPtr<DBusConnection>& connection,
    DBusProxyFlags flags, const Glib::RefPtr<DBusInterfaceInfo>& info,
    const Glib::ustring& name, const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const Glib::RefPtr<Cancellable>& cancellable);

  DBusProxy(BusType bus_type, DBusProxyFlags flags,
    const Glib::RefPtr<DBusInterfaceInfo>& info, const Glib::ustring& name,
    const Glib::ustring& object_path, const Glib::ustring& interface_name,
    const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable);

  DBusProxy(BusType bus_type, DBusProxyFlags flags,
    const Glib::RefPtr<DBusInterfaceInfo>& info, const Glib::ustring& name,
    const Glib::ustring& object_path, const Glib::ustring& interface_name,
    const Glib::RefPtr<Cancellable>& cancellable);

public:

  
  /** Creates a proxy for accessing @a interface_name on the remote object
   * at @a object_path owned by @a name at @a connection and asynchronously
   * loads D-Bus properties unless the
   * DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES flag is used. Connect to
   * the DBusProxy::g-properties-changed signal to get notified about
   * property changes.
   * 
   * If the DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS flag is not set, also sets up
   * match rules for signals. Connect to the DBusProxy::g-signal signal
   * to handle signals from the remote object.
   * 
   * If @a name is a well-known name and the
   * DBUS_PROXY_FLAGS_DO_NOT_AUTO_START flag isn't set and no name
   * owner currently exists, the message bus will be requested to launch
   * a name owner for the name.
   * 
   * This is a failable asynchronous constructor - when the proxy is
   * ready, @a callback will be invoked and you can use
   * g_dbus_proxy_new_finish() to get the result.
   * 
   * See g_dbus_proxy_new_sync() and for a synchronous version of this constructor.
   * 
   * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how DBusProxy can be used.
   * 
   * @newin{2,26}
   * @param connection A DBusConnection.
   * @param flags Flags used when constructing the proxy.
   * @param info A DBusInterfaceInfo specifying the minimal interface that @a proxy conforms to or <tt>0</tt>.
   * @param name A bus name (well-known or unique) or <tt>0</tt> if @a connection is not a message bus connection.
   * @param object_path An object path.
   * @param interface_name A D-Bus interface name.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @param callback Callback function to invoke when the proxy is ready.
   * @param user_data User data to pass to @a callback.
   */

  static void create(const Glib::RefPtr<DBusConnection>& connection,
    DBusProxyFlags flags, const Glib::RefPtr<DBusInterfaceInfo>& info,
    const Glib::ustring& name, const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable = Glib::RefPtr<Cancellable>());

  
  /** @throw Glib::Error.
   */
  static Glib::RefPtr<DBusProxy> create_finish(const Glib::RefPtr<AsyncResult>& result);

  
  /** Creates a proxy for accessing @a interface_name on the remote object
   * at @a object_path owned by @a name at @a connection and synchronously
   * loads D-Bus properties unless the
   * DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES flag is used.
   * 
   * If the DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS flag is not set, also sets up
   * match rules for signals. Connect to the DBusProxy::g-signal signal
   * to handle signals from the remote object.
   * 
   * If @a name is a well-known name and the
   * DBUS_PROXY_FLAGS_DO_NOT_AUTO_START flag isn't set and no name
   * owner currently exists, the message bus will be requested to launch
   * a name owner for the name.
   * 
   * This is a synchronous failable constructor. See g_dbus_proxy_new()
   * and g_dbus_proxy_new_finish() for the asynchronous version.
   * 
   * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how DBusProxy can be used.
   * 
   * @newin{2,26}
   * @param connection A DBusConnection.
   * @param flags Flags used when constructing the proxy.
   * @param info A DBusInterfaceInfo specifying the minimal interface that @a proxy conforms to or <tt>0</tt>.
   * @param name A bus name (well-known or unique) or <tt>0</tt> if @a connection is not a message bus connection.
   * @param object_path An object path.
   * @param interface_name A D-Bus interface name.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @return A DBusProxy or <tt>0</tt> if error is set. Free with Glib::object_unref().
   */

  static Glib::RefPtr<DBusProxy>
  create(const Glib::RefPtr<DBusConnection>& connection, DBusProxyFlags flags,
    const Glib::RefPtr<DBusInterfaceInfo>& info, const Glib::ustring& name,
    const Glib::ustring& object_path, const Glib::ustring& interface_name,
    const Glib::RefPtr<Cancellable>& cancellable = Glib::RefPtr<Cancellable>());

  
  /** Like g_dbus_proxy_new() but takes a BusType instead of a DBusConnection.
   * 
   * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how DBusProxy can be used.
   * 
   * @newin{2,26}
   * @param bus_type A BusType.
   * @param flags Flags used when constructing the proxy.
   * @param info A DBusInterfaceInfo specifying the minimal interface that @a proxy conforms to or <tt>0</tt>.
   * @param name A bus name (well-known or unique).
   * @param object_path An object path.
   * @param interface_name A D-Bus interface name.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @param callback Callback function to invoke when the proxy is ready.
   * @param user_data User data to pass to @a callback.
   */

  static void create_for_bus(BusType bus_type, DBusProxyFlags flags,
    const Glib::RefPtr<DBusInterfaceInfo>& info, const Glib::ustring& name,
    const Glib::ustring& object_path, const Glib::ustring& interface_name,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable = Glib::RefPtr<Cancellable>());

  
  /** @throw Glib::Error.
   */
  static Glib::RefPtr<DBusProxy> create_for_bus_finish(const Glib::RefPtr<AsyncResult>& result);

  //gtkmmproc error: g_dbus_proxy_new__for_bus_sync : method defs lookup failed (1)
  static Glib::RefPtr<DBusProxy>
  create_for_bus(BusType bus_type, DBusProxyFlags flags,
    const Glib::RefPtr<DBusInterfaceInfo>& info, const Glib::ustring& name,
    const Glib::ustring& object_path, const Glib::ustring& interface_name,
    const Glib::RefPtr<Cancellable>& cancellable = Glib::RefPtr<Cancellable>());

  
  /** Gets the flags that @a proxy was constructed with.
   * 
   * @newin{2,26}
   * @return Flags from the DBusProxyFlags enumeration.
   */
  DBusProxyFlags get_flags() const;

  
  /** Gets the connection @a proxy is for.
   * 
   * @newin{2,26}
   * @return A DBusConnection owned by @a proxy. Do not free.
   */
  Glib::RefPtr<DBusConnection> get_connection();
  
  /** Gets the connection @a proxy is for.
   * 
   * @newin{2,26}
   * @return A DBusConnection owned by @a proxy. Do not free.
   */
  Glib::RefPtr<const DBusConnection> get_connection() const;

  
  /** Gets the name that @a proxy was constructed for.
   * 
   * @newin{2,26}
   * @return A string owned by @a proxy. Do not free.
   */
  Glib::ustring get_name() const;
  
  /** The unique name that owns the name that @a proxy is for or <tt>0</tt> if
   * no-one currently owns that name. You may connect to the
   * Object::notify signal to track changes to the
   * DBusProxy:g-name-owner property.
   * 
   * @newin{2,26}
   * @return The name owner or <tt>0</tt> if no name owner exists. Free with Glib::free().
   */
  Glib::ustring get_name_owner() const;
  
  /** Gets the object path @a proxy is for.
   * 
   * @newin{2,26}
   * @return A string owned by @a proxy. Do not free.
   */
  Glib::ustring get_object_path() const;
  
  /** Gets the D-Bus interface name @a proxy is for.
   * 
   * @newin{2,26}
   * @return A string owned by @a proxy. Do not free.
   */
  Glib::ustring get_interface_name() const;

  
  /** Gets the timeout to use if -1 (specifying default timeout) is
   * passed as @a timeout_msec in the g_dbus_proxy_call() and
   * g_dbus_proxy_call_sync() functions.
   * 
   * See the DBusProxy:g-default-timeout property for more details.
   * 
   * @newin{2,26}
   * @return Timeout to use for @a proxy.
   */
  int get_default_timeout() const;
  
  /** Sets the timeout to use if -1 (specifying default timeout) is
   * passed as @a timeout_msec in the g_dbus_proxy_call() and
   * g_dbus_proxy_call_sync() functions.
   * 
   * See the DBusProxy:g-default-timeout property for more details.
   * 
   * @newin{2,26}
   * @param timeout_msec Timeout in milliseconds.
   */
  void set_default_timeout(int timeout_msec);

  //TODO: _WRAP_METHOD(Variant* get_cached_property(const gchar* property_name), g_dbus_proxy_get_cached_property)
  
  /** If @a value is not <tt>0</tt>, sets the cached value for the property with
   * name @a property_name to the value in @a value.
   * 
   * If @a value is <tt>0</tt>, then the cached value is removed from the
   * property cache.
   * 
   * If @a proxy has an expected interface (see
   * DBusProxy:g-interface-info), then @a property_name (for existence)
   * and @a value (for the type) is checked against it.
   * 
   * If the @a value Variant is floating, it is consumed. This allows
   * convenient 'inline' use of Glib::variant_new(), e.g.
   * |[
   * g_dbus_proxy_set_cached_property (proxy,
   * "SomeProperty",
   * g_variant_new ("(si)",
   * "A String",
   * 42));
   * ]|
   * 
   * Normally you will not need to use this method since @a proxy is
   * tracking changes using the
   * <literal>org.freedesktop.DBus.Properties.PropertiesChanged</literal>
   * D-Bus signal. However, for performance reasons an object may decide
   * to not use this signal for some properties and instead use a
   * proprietary out-of-band mechanism to transmit changes.
   * 
   * As a concrete example, consider an object with a property
   * <literal>ChatroomParticipants</literal> which is an array of
   * strings. Instead of transmitting the same (long) array every time
   * the property changes, it is more efficient to only transmit the
   * delta using e.g. signals <literal>ChatroomParticipantJoined(String
   * name)</literal> and <literal>ChatroomParticipantParted(String
   * name)</literal>.
   * 
   * @newin{2,26}
   * @param property_name Property name.
   * @param value Value for the property or <tt>0</tt> to remove it from the cache.
   */
  void set_cached_property(const Glib::ustring& property_name, const Glib::VariantBase& value);

 
  /** Gets the names of all cached properties on @a proxy.
   * 
   * @newin{2,26}
   * @return A <tt>0</tt>-terminated array of strings or <tt>0</tt> if @a proxy has
   * no cached properties. Free the returned array with Glib::strfreev().
   */
  Glib::StringArrayHandle get_cached_property_names() const;

  
  /** Ensure that interactions with @a proxy conform to the given
   * interface.  For example, when completing a method call, if the type
   * signature of the message isn't what's expected, the given Error
   * is set.  Signals that have a type signature mismatch are simply
   * dropped.
   * 
   * See the DBusProxy:g-interface-info property for more details.
   * 
   * @newin{2,26}
   * @param info Minimum interface this proxy conforms to or <tt>0</tt> to unset.
   */
  void set_interface_info(const Glib::RefPtr<DBusInterfaceInfo>& info);
  
  /** Returns the DBusInterfaceInfo, if any, specifying the minimal
   * interface that @a proxy conforms to.
   * 
   * See the DBusProxy:g-interface-info property for more details.
   * 
   * @newin{2,26}
   * @return A DBusInterfaceInfo or <tt>0</tt>. Do not unref the returned
   * object, it is owned by @a proxy.
   */
  Glib::RefPtr<DBusInterfaceInfo> get_interface_info();
  
  /** Returns the DBusInterfaceInfo, if any, specifying the minimal
   * interface that @a proxy conforms to.
   * 
   * See the DBusProxy:g-interface-info property for more details.
   * 
   * @newin{2,26}
   * @return A DBusInterfaceInfo or <tt>0</tt>. Do not unref the returned
   * object, it is owned by @a proxy.
   */
  Glib::RefPtr<const DBusInterfaceInfo> get_interface_info() const;

/* TODO:
  _WRAP_METHOD(void call(const gchar* method_name, GVariant* parameters, GDBusCallFlags flags, gint timeout_msec, GCancellable* cancellable, GAsyncReadyCallback callback, gpointer user_data), g_dbus_proxy_call)
  _WRAP_METHOD(GVariant* call_finish(GAsyncResult* res, GError** error),
g_dbus_proxy_call_finish)
  _WRAP_METHOD(GVariant* call_sync(const gchar* method_name, GVariant* parameters, GDBusCallFlags flags, gint timeout_msec, GCancellable* cancellable, GError** error), g_dbus_proxy_call_sync)
 */

 //TODO: Properties and signals.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusProxy
   */
  Glib::RefPtr<Gio::DBusProxy> wrap(GDBusProxy* object, bool take_copy = false);
}


#endif /* _GIOMM_DBUSPROXY_H */

