// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DBUSCONNECTION_H
#define _GIOMM_DBUSCONNECTION_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <giomm/initable.h>
#include <giomm/asyncinitable.h>
#include <giomm/iostream.h>
#include <giomm/asyncresult.h>
#include <giomm/credentials.h>
#include <giomm/dbusmessage.h>


//TODO: Use a GDbus namespace, and remove the DBus prefixes.
#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GDBusConnection GDBusConnection;
typedef struct _GDBusConnectionClass GDBusConnectionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class DBusConnection_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums giomm Enums and Flags */

/**
 * @ingroup giommEnums
 */
enum BusType
{
  BUS_TYPE_STARTER = -1,
  BUS_TYPE_NONE,
  BUS_TYPE_SYSTEM,
  BUS_TYPE_SESSION
};

} // namespace Gio


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gio::BusType> : public Glib::Value_Enum<Gio::BusType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{

/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%DBusConnectionFlags operator|(DBusConnectionFlags, DBusConnectionFlags)</tt><br>
 * <tt>%DBusConnectionFlags operator&(DBusConnectionFlags, DBusConnectionFlags)</tt><br>
 * <tt>%DBusConnectionFlags operator^(DBusConnectionFlags, DBusConnectionFlags)</tt><br>
 * <tt>%DBusConnectionFlags operator~(DBusConnectionFlags)</tt><br>
 * <tt>%DBusConnectionFlags& operator|=(DBusConnectionFlags&, DBusConnectionFlags)</tt><br>
 * <tt>%DBusConnectionFlags& operator&=(DBusConnectionFlags&, DBusConnectionFlags)</tt><br>
 * <tt>%DBusConnectionFlags& operator^=(DBusConnectionFlags&, DBusConnectionFlags)</tt><br>
 */
enum DBusConnectionFlags
{
  DBUS_CONNECTION_FLAGS_NONE = 0x0,
  DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT = (1<<0),
  DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER = (1<<1),
  DBUS_CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS = (1<<2),
  DBUS_CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION = (1<<3),
  DBUS_CONNECTION_FLAGS_DELAY_MESSAGE_PROCESSING = (1<<4)
};

/** @ingroup giommEnums */
inline DBusConnectionFlags operator|(DBusConnectionFlags lhs, DBusConnectionFlags rhs)
  { return static_cast<DBusConnectionFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusConnectionFlags operator&(DBusConnectionFlags lhs, DBusConnectionFlags rhs)
  { return static_cast<DBusConnectionFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusConnectionFlags operator^(DBusConnectionFlags lhs, DBusConnectionFlags rhs)
  { return static_cast<DBusConnectionFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusConnectionFlags operator~(DBusConnectionFlags flags)
  { return static_cast<DBusConnectionFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline DBusConnectionFlags& operator|=(DBusConnectionFlags& lhs, DBusConnectionFlags rhs)
  { return (lhs = static_cast<DBusConnectionFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusConnectionFlags& operator&=(DBusConnectionFlags& lhs, DBusConnectionFlags rhs)
  { return (lhs = static_cast<DBusConnectionFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusConnectionFlags& operator^=(DBusConnectionFlags& lhs, DBusConnectionFlags rhs)
  { return (lhs = static_cast<DBusConnectionFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%DBusSendMessageFlags operator|(DBusSendMessageFlags, DBusSendMessageFlags)</tt><br>
 * <tt>%DBusSendMessageFlags operator&(DBusSendMessageFlags, DBusSendMessageFlags)</tt><br>
 * <tt>%DBusSendMessageFlags operator^(DBusSendMessageFlags, DBusSendMessageFlags)</tt><br>
 * <tt>%DBusSendMessageFlags operator~(DBusSendMessageFlags)</tt><br>
 * <tt>%DBusSendMessageFlags& operator|=(DBusSendMessageFlags&, DBusSendMessageFlags)</tt><br>
 * <tt>%DBusSendMessageFlags& operator&=(DBusSendMessageFlags&, DBusSendMessageFlags)</tt><br>
 * <tt>%DBusSendMessageFlags& operator^=(DBusSendMessageFlags&, DBusSendMessageFlags)</tt><br>
 */
enum DBusSendMessageFlags
{
  DBUS_SEND_MESSAGE_FLAGS_NONE = 0x0,
  DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL = (1<<0)
};

/** @ingroup giommEnums */
inline DBusSendMessageFlags operator|(DBusSendMessageFlags lhs, DBusSendMessageFlags rhs)
  { return static_cast<DBusSendMessageFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusSendMessageFlags operator&(DBusSendMessageFlags lhs, DBusSendMessageFlags rhs)
  { return static_cast<DBusSendMessageFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusSendMessageFlags operator^(DBusSendMessageFlags lhs, DBusSendMessageFlags rhs)
  { return static_cast<DBusSendMessageFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusSendMessageFlags operator~(DBusSendMessageFlags flags)
  { return static_cast<DBusSendMessageFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline DBusSendMessageFlags& operator|=(DBusSendMessageFlags& lhs, DBusSendMessageFlags rhs)
  { return (lhs = static_cast<DBusSendMessageFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusSendMessageFlags& operator&=(DBusSendMessageFlags& lhs, DBusSendMessageFlags rhs)
  { return (lhs = static_cast<DBusSendMessageFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusSendMessageFlags& operator^=(DBusSendMessageFlags& lhs, DBusSendMessageFlags rhs)
  { return (lhs = static_cast<DBusSendMessageFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%DBusCallFlags operator|(DBusCallFlags, DBusCallFlags)</tt><br>
 * <tt>%DBusCallFlags operator&(DBusCallFlags, DBusCallFlags)</tt><br>
 * <tt>%DBusCallFlags operator^(DBusCallFlags, DBusCallFlags)</tt><br>
 * <tt>%DBusCallFlags operator~(DBusCallFlags)</tt><br>
 * <tt>%DBusCallFlags& operator|=(DBusCallFlags&, DBusCallFlags)</tt><br>
 * <tt>%DBusCallFlags& operator&=(DBusCallFlags&, DBusCallFlags)</tt><br>
 * <tt>%DBusCallFlags& operator^=(DBusCallFlags&, DBusCallFlags)</tt><br>
 */
enum DBusCallFlags
{
  DBUS_CALL_FLAGS_NONE = 0x0,
  DBUS_CALL_FLAGS_NO_AUTO_START = (1<<0)
};

/** @ingroup giommEnums */
inline DBusCallFlags operator|(DBusCallFlags lhs, DBusCallFlags rhs)
  { return static_cast<DBusCallFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusCallFlags operator&(DBusCallFlags lhs, DBusCallFlags rhs)
  { return static_cast<DBusCallFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusCallFlags operator^(DBusCallFlags lhs, DBusCallFlags rhs)
  { return static_cast<DBusCallFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusCallFlags operator~(DBusCallFlags flags)
  { return static_cast<DBusCallFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline DBusCallFlags& operator|=(DBusCallFlags& lhs, DBusCallFlags rhs)
  { return (lhs = static_cast<DBusCallFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusCallFlags& operator&=(DBusCallFlags& lhs, DBusCallFlags rhs)
  { return (lhs = static_cast<DBusCallFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusCallFlags& operator^=(DBusCallFlags& lhs, DBusCallFlags rhs)
  { return (lhs = static_cast<DBusCallFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


class DBusAuthObserver;

//TODO: Add example from C API in class docs.
/** DBusConnection - D-Bus Connections.
 * The DBusConnection type is used for D-Bus connections to remote peers such
 * as a message buses. It is a low-level API that offers a lot of flexibility.
 * For instance, it lets you establish a connection over any transport that
 * can by represented as an IOStream.
 *
 * This class is rarely used directly in D-Bus clients. If you are writing an
 * D-Bus client, it is often easier to use the Gio::DBus::own_name(),
 * Gio::DBus::watch_name() or DBusProxy::create_for_bus() APIs.
 *
 * @newin{2,28}
 */

class DBusConnection
: public Glib::Object, public Initable, public AsyncInitable
{
protected:
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DBusConnection CppObjectType;
  typedef DBusConnection_Class CppClassType;
  typedef GDBusConnection BaseObjectType;
  typedef GDBusConnectionClass BaseClassType;

private:  friend class DBusConnection_Class;
  static CppClassType dbusconnection_class_;

private:
  // noncopyable
  DBusConnection(const DBusConnection&);
  DBusConnection& operator=(const DBusConnection&);

protected:
  explicit DBusConnection(const Glib::ConstructParams& construct_params);
  explicit DBusConnection(GDBusConnection* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DBusConnection();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GDBusConnection*       gobj()       { return reinterpret_cast<GDBusConnection*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GDBusConnection* gobj() const { return reinterpret_cast<GDBusConnection*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusConnection* gobj_copy();

private:

  
protected:

  DBusConnection(const Glib::RefPtr<IOStream>& stream,
    const Glib::ustring& guid,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable,
    DBusConnectionFlags flags);

  DBusConnection(const Glib::RefPtr<IOStream>& stream,
    const Glib::ustring& guid,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    const SlotAsyncReady& slot,
    DBusConnectionFlags flags);

  DBusConnection(const Glib::RefPtr<IOStream>& stream,
    const Glib::ustring& guid,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    const Glib::RefPtr<Cancellable>& cancellable,
    DBusConnectionFlags flags);

  DBusConnection(const Glib::RefPtr<IOStream>& stream,
    const Glib::ustring& guid,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    DBusConnectionFlags flags);

  DBusConnection(const Glib::ustring& address,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable,
    DBusConnectionFlags flags);

  DBusConnection(const Glib::ustring& address,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    const SlotAsyncReady& slot,
    DBusConnectionFlags flags);

  DBusConnection(const Glib::ustring& address,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    const Glib::RefPtr<Cancellable>& cancellable,
    DBusConnectionFlags flags);

  DBusConnection(const Glib::ustring& address,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    DBusConnectionFlags flags);

public:

  /** Asynchronously connects to the message bus specified by @a bus_type.
   *
   * When the operation is finished, @a slot will be invoked. You can then
   * call get_finish() to get the result of the operation.
   *
   * This is a asynchronous failable function. See get_sync() for the
   * synchronous version.
   *
   * @param bus_type A BusType.
   * @param slot A SlotAsyncReady to call when the request is satisfied.
   * @param cancellable A Cancellable.
   *
   * @newin{2,28}
   */
  void get(BusType bus_type, const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable);
  

  /** Non-cancellable version of get().
   */
  void get(BusType bus_type, const SlotAsyncReady& slot);

  
  /** @throw Glib::Error.
   */
  static Glib::RefPtr<DBusConnection> get_finish(const Glib::RefPtr<AsyncResult>& res);

  
  /** Asynchronously sets up a D-Bus connection for exchanging D-Bus messages
   * with the end represented by @a stream.
   * 
   * If @a observer is not <tt>0</tt> it may be used to control the
   * authentication process.
   * 
   * When the operation is finished, @a callback will be invoked. You can
   * then call g_dbus_connection_new_finish() to get the result of the
   * operation.
   * 
   * This is a asynchronous failable constructor. See
   * g_dbus_connection_new_sync() for the synchronous
   * version.
   * 
   * @newin{2,26}
   * @param stream A IOStream.
   * @param guid The GUID to use if a authenticating as a server or <tt>0</tt>.
   * @param flags Flags describing how to make the connection.
   * @param observer A DBusAuthObserver or <tt>0</tt>.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @param callback A AsyncReadyCallback to call when the request is satisfied.
   * @param user_data The data to pass to @a callback.
   */

  void create(const Glib::RefPtr<IOStream>& stream,
    const Glib::ustring& guid,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable,
    DBusConnectionFlags flags = Gio::DBUS_CONNECTION_FLAGS_NONE);

  /// Non-cancellable version of create().
  void create(const Glib::RefPtr<IOStream>& stream,
    const Glib::ustring& guid,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    const SlotAsyncReady& slot,
    DBusConnectionFlags flags = Gio::DBUS_CONNECTION_FLAGS_NONE);


  /** @throw Glib::Error.
   */
  static Glib::RefPtr<DBusConnection> create_finish(const Glib::RefPtr<AsyncResult>& res);

  
  /** Asynchronously connects and sets up a D-Bus client connection for
   * exchanging D-Bus messages with an endpoint specified by @a address
   * which must be in the D-Bus address format.
   * 
   * This constructor can only be used to initiate client-side
   * connections - use g_dbus_connection_new() if you need to act as the
   * server. In particular, @a flags cannot contain the
   * DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER or
   * DBUS_CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS flags.
   * 
   * When the operation is finished, @a callback will be invoked. You can
   * then call g_dbus_connection_new_finish() to get the result of the
   * operation.
   * 
   * If @a observer is not <tt>0</tt> it may be used to control the
   * authentication process.
   * 
   * This is a asynchronous failable constructor. See
   * g_dbus_connection_new_for_address_sync() for the synchronous
   * version.
   * 
   * @newin{2,26}
   * @param address A D-Bus address.
   * @param flags Flags describing how to make the connection.
   * @param observer A DBusAuthObserver or <tt>0</tt>.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @param callback A AsyncReadyCallback to call when the request is satisfied.
   * @param user_data The data to pass to @a callback.
   */

  void create_for_address(const Glib::ustring& address,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable,
    DBusConnectionFlags flags = Gio::DBUS_CONNECTION_FLAGS_NONE);

  /// Non-cancellable version of create_for_address().
  void create_for_address(const Glib::ustring& address,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    const SlotAsyncReady& slot,
    DBusConnectionFlags flags = Gio::DBUS_CONNECTION_FLAGS_NONE);


  /** @throw Glib::Error.
   */
  static Glib::RefPtr<DBusConnection> create_for_address_finish(const Glib::RefPtr<AsyncResult>& res);

  
  /** Synchronously sets up a D-Bus connection for exchanging D-Bus messages
   * with the end represented by @a stream.
   * 
   * If @a observer is not <tt>0</tt> it may be used to control the
   * authentication process.
   * 
   * This is a synchronous failable constructor. See
   * g_dbus_connection_new() for the asynchronous version.
   * 
   * @newin{2,26}
   * @param stream A IOStream.
   * @param guid The GUID to use if a authenticating as a server or <tt>0</tt>.
   * @param flags Flags describing how to make the connection.
   * @param observer A DBusAuthObserver or <tt>0</tt>.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @return A DBusConnection or <tt>0</tt> if @a error is set. Free with Glib::object_unref().
   */

  /** @throw Glib::Error.
   */
  Glib::RefPtr<DBusConnection> create_sync(
    const Glib::RefPtr<IOStream>& stream,
    const Glib::ustring& guid,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    const Glib::RefPtr<Cancellable>& cancellable,
    DBusConnectionFlags flags = Gio::DBUS_CONNECTION_FLAGS_NONE);

  /** Non-cancellable version of create_sync().
   */
  Glib::RefPtr<DBusConnection> create_sync(
    const Glib::RefPtr<IOStream>& stream,
    const Glib::ustring& guid,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    DBusConnectionFlags flags = Gio::DBUS_CONNECTION_FLAGS_NONE);

  
  /** Synchronously connects and sets up a D-Bus client connection for
   * exchanging D-Bus messages with an endpoint specified by @a address
   * which must be in the D-Bus address format.
   * 
   * This constructor can only be used to initiate client-side
   * connections - use g_dbus_connection_new_sync() if you need to act
   * as the server. In particular, @a flags cannot contain the
   * DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER or
   * DBUS_CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS flags.
   * 
   * This is a synchronous failable constructor. See
   * g_dbus_connection_new_for_address() for the asynchronous version.
   * 
   * If @a observer is not <tt>0</tt> it may be used to control the
   * authentication process.
   * 
   * @newin{2,26}
   * @param address A D-Bus address.
   * @param flags Flags describing how to make the connection.
   * @param observer A DBusAuthObserver or <tt>0</tt>.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @return A DBusConnection or <tt>0</tt> if @a error is set. Free with Glib::object_unref().
   */

  /** @throw Glib::Error.
   */
  Glib::RefPtr<DBusConnection> create_for_address_sync(
    const Glib::ustring& address,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    const Glib::RefPtr<Cancellable>& cancellable,
    DBusConnectionFlags flags = Gio::DBUS_CONNECTION_FLAGS_NONE);

  /** Non-cancellable version of create_for_address_sync().
   */
  Glib::RefPtr<DBusConnection> create_for_address_sync(
    const Glib::ustring& address,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    DBusConnectionFlags flags = Gio::DBUS_CONNECTION_FLAGS_NONE);

  /** Closes the connection. Note that this never causes the process to exit
   * (this might only happen if the other end of a shared message bus
   * connection disconnects, see property_exit_on_close()).
   *
   * Once the connection is closed, operations such as sending a message will
   * return with the error Gio::IO_ERROR_CLOSED. Closing a connection will not
   * automatically flush the connection so queued messages may be lost. Use
   * flush() if you need such guarantees.
   *
   * If the connection is already closed, this method fails with
   * Gio::IO_ERROR_CLOSED.
   *
   * When the connection has been closed, the "closed" signal is emitted in
   * the thread-default main loop of the thread that connection was
   * constructed in.
   *
   * This is an asynchronous method.  See close_sync() for the synchronous
   * version.
   *
   * @newin{2,28}
   */
  void close();

  /** Closes the connection. Note that this never causes the process to exit
   * (this might only happen if the other end of a shared message bus
   * connection disconnects, see property_exit_on_close()).
   *
   * Once the connection is closed, operations such as sending a message will
   * return with the error Gio::IO_ERROR_CLOSED. Closing a connection will not
   * automatically flush the connection so queued messages may be lost. Use
   * flush() if you need such guarantees.
   *
   * If the connection is already closed, this method fails with
   * Gio::IO_ERROR_CLOSED.
   *
   * When the connection has been closed, the "closed" signal is emitted in
   * the thread-default main loop of the thread that connection was
   * constructed in.
   *
   * This is an asynchronous method. When the operation is finished, @a slot
   * will be invoked in the thread-default main loop of the thread you are
   * calling this method from. You can then call close_finish() to get the
   * result of the operation. See close_sync() for the synchronous version.
   *
   * @param slot A SlotAsyncReady to call when the request is satisfied.
   * @param cancellable A Cancellable.
   *
   * @newin{2,28}
   */
  void close(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable);

  /** Closes the connection. Note that this never causes the process to exit
   * (this might only happen if the other end of a shared message bus
   * connection disconnects, see property_exit_on_close()).
   *
   * Once the connection is closed, operations such as sending a message will
   * return with the error Gio::IO_ERROR_CLOSED. Closing a connection will not
   * automatically flush the connection so queued messages may be lost. Use
   * flush() if you need such guarantees.
   *
   * If the connection is already closed, this method fails with
   * Gio::IO_ERROR_CLOSED.
   *
   * When the connection has been closed, the "closed" signal is emitted in
   * the thread-default main loop of the thread that connection was
   * constructed in.
   *
   * This is an asynchronous method. When the operation is finished, @a slot
   * will be invoked in the thread-default main loop of the thread you are
   * calling this method from. You can then call close_finish() to get the
   * result of the operation. See close_sync() for the synchronous version.
   *
   * @param slot A SlotAsyncReady to call when the request is satisfied.
   *
   * @newin{2,28}
   */
  void close(const SlotAsyncReady& slot);
  

  /** Finishes an operation started with g_dbus_connection_close().
   * 
   * @newin{2,26}
   * @param res A AsyncResult obtained from the AsyncReadyCallback passed to g_dbus_connection_close().
   * @return <tt>true</tt> if the operation succeeded, <tt>false</tt> if @a error is set.
   */
  bool close_finish(const Glib::RefPtr<AsyncResult>& result);

  /** Synchronously closees the connection. The calling thread is blocked
   * until this is done. See close() for the asynchronous version of this
   * method and more details about what it does.
   *
   * @newin{2,28}
   *
   * @throw Glib::Error.
   */
  void close_sync();

  
  /** Synchronously closees @a connection. The calling thread is blocked
   * until this is done. See g_dbus_connection_close() for the
   * asynchronous version of this method and more details about what it
   * does.
   * 
   * @newin{2,26}
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @return <tt>true</tt> if the operation succeeded, <tt>false</tt> if @a error is set.
   */
  void close_sync(const Glib::RefPtr<Cancellable>& cancellable);

  /** Asynchronously flushes the connection, that is, writes all queued
   * outgoing message to the transport and then flushes the transport (using
   * Gio::OutputStream::flush_async()). This is useful in programs that wants
   * to emit a D-Bus signal and then exit immediately. Without flushing the
   * connection, there is no guarantee that the message has been sent to the
   * networking buffers in the OS kernel.
   *
   * This is an asynchronous method. See flush_sync() for the synchronous
   * version.
   *
   * @newin{2,28}
   */
  void flush();

  /** Asynchronously flushes the connection, that is, writes all queued
   * outgoing message to the transport and then flushes the transport (using
   * Gio::OutputStream::flush_async()). This is useful in programs that wants
   * to emit a D-Bus signal and then exit immediately. Without flushing the
   * connection, there is no guarantee that the message has been sent to the
   * networking buffers in the OS kernel.
   *
   * This is an asynchronous method. When the operation is finished, @a slot
   * will be invoked in the thread-default main loop of the thread you are
   * calling this method from. You can then call flush_finish() to get the
   * result of the operation. See flush_sync() for the synchronous version.
   *
   * @param slot A SlotAsyncReady to call when the request is satisfied.
   * @param cancellable A Cancellable.
   *
   * @newin{2,28}
   */
  void flush(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable);

  /** Asynchronously flushes the connection, that is, writes all queued
   * outgoing message to the transport and then flushes the transport (using
   * Gio::OutputStream::flush_async()). This is useful in programs that wants
   * to emit a D-Bus signal and then exit immediately. Without flushing the
   * connection, there is no guarantee that the message has been sent to the
   * networking buffers in the OS kernel.
   *
   * This is an asynchronous method. When the operation is finished, @a slot
   * will be invoked in the thread-default main loop of the thread you are
   * calling this method from. You can then call flush_finish() to get the
   * result of the operation. See flush_sync() for the synchronous version.
   *
   * @param slot A SlotAsyncReady to call when the request is satisfied.
   *
   * @newin{2,28}
   */
  void flush(const SlotAsyncReady& slot);
  

  /** Finishes an operation started with g_dbus_connection_flush().
   * 
   * @newin{2,26}
   * @param res A AsyncResult obtained from the AsyncReadyCallback passed to g_dbus_connection_flush().
   * @return <tt>true</tt> if the operation succeeded, <tt>false</tt> if @a error is set.
   */
  bool flush_finish(const Glib::RefPtr<AsyncResult>& result);

  /** Synchronously flushes the connection. The calling thread is blocked
   * until this is done. See flush() for the asynchronous version of this
   * method and more details about what it does.
   *
   * @newin{2,28}
   *
   * @throw Glib::Error.
   */
  void flush_sync();

  
  /** Synchronously flushes @a connection. The calling thread is blocked
   * until this is done. See g_dbus_connection_flush() for the
   * asynchronous version of this method and more details about what it
   * does.
   * 
   * @newin{2,26}
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @return <tt>true</tt> if the operation succeeded, <tt>false</tt> if @a error is set.
   */
  void flush_sync(const Glib::RefPtr<Cancellable>& cancellable);

  //TODO: In the C API, out_serial is volatile, but gmmproc can't parse that.
   

  /** Asynchronously sends @a message to the peer represented by @a connection.
   * 
   * Unless @a flags contain the
   * DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag, the serial number
   * will be assigned by @a connection and set on @a message via
   * g_dbus_message_set_serial(). If @a out_serial is not <tt>0</tt>, then the
   * serial number used will be written to this location prior to
   * submitting the message to the underlying transport.
   * 
   * If @a connection is closed then the operation will fail with
   * IO_ERROR_CLOSED. If @a message is not well-formed,
   * the operation fails with IO_ERROR_INVALID_ARGUMENT.
   * 
   * See <xref linkend="gdbus-server"/> and <xref
   * linkend="gdbus-unix-fd-client"/> for an example of how to use this
   * low-level API to send and receive UNIX file descriptors.
   * 
   * @newin{2,26}
   * @param message A DBusMessage.
   * @param flags Flags affecting how the message is sent.
   * @param out_serial Return location for serial number assigned to @a message when sending it or <tt>0</tt>.
   * @return <tt>true</tt> if the message was well-formed and queued for
   * transmission, <tt>false</tt> if @a error is set.
   */
  bool send_message(const Glib::RefPtr<DBusMessage>& message, DBusSendMessageFlags flags, guint32* out_serial);

  /** Asynchronously sends message to the peer represented by connection.
   *
   * Unless flags contain the Gio::DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL
   * flag, the serial number will be assigned by connection and set on message
   * via Gio::DBusMessage::set_serial().
   *
   * If the connection is closed then the operation will fail with
   * Gio::IO_ERROR_CLOSED. If @a cancellable is canceled, the operation will
   * fail with Gio::IO_ERROR_CANCELLED. If @a message is not well-formed, the
   * operation fails with Gio::IO_ERROR_INVALID_ARGUMENT.
   *
   * This is an asynchronous method. When the operation is finished, @a slot
   * will be invoked in the thread-default main loop of the thread you are
   * calling this method from. You can then call
   * send_message_with_reply_finish() to get the result of the operation. See
   * send_message_with_reply_sync() for the synchronous version.
   *
   * Note that message must be unlocked, unless flags contain the
   * Gio::DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag.
   *
   * See the C API docs for examples.
   *
   * @param message A DBusMessage.
   * @param timeout_msec The timeout in milliseconds or -1 to use the default
   * timeout.
   * @param slot A SlotAsyncReady to call when the request is satisfied.
   * @param cancellable A Cancellable.
   *
   * @newin{2,28}
   */
  void send_message_with_reply(const Glib::RefPtr<DBusMessage>& message,
    int timeout_msec,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable);
  

  /** Non-cancellable version of send_message_with_reply().
   */
  void send_message_with_reply(const Glib::RefPtr<DBusMessage>& message,
    int timeout_msec,
    const SlotAsyncReady& slot);


  /** @throw Glib::Error.
   */
  Glib::RefPtr<DBusMessage> send_message_with_reply_finish(const Glib::RefPtr<AsyncResult>& result);

  
  /** If @a connection was created with
   * DBUS_CONNECTION_FLAGS_DELAY_MESSAGE_PROCESSING, this method
   * starts processing messages. Does nothing on if @a connection wasn't
   * created with this flag or if the method has already been called.
   * 
   * @newin{2,26}
   */
  void start_message_processing();
  
  /** Gets whether @a connection is closed.
   * 
   * @newin{2,26}
   * @return <tt>true</tt> if the connection is closed, <tt>false</tt> otherwise.
   */
  bool is_closed() const;

  
  /** Gets the underlying stream used for IO.
   * 
   * @newin{2,26}
   * @return The stream used for IO.
   */
  Glib::RefPtr<IOStream> get_stream();
  
  /** Gets the underlying stream used for IO.
   * 
   * @newin{2,26}
   * @return The stream used for IO.
   */
  Glib::RefPtr<const IOStream> get_stream() const;

  
  /** The GUID of the peer performing the role of server when
   * authenticating. See DBusConnection:guid for more details.
   * 
   * @newin{2,26}
   * @return The GUID. Do not free this string, it is owned by
   *  @a connection.
   */
  Glib::ustring get_guid() const;
  
  /** Gets the unique name of @a connection as assigned by the message
   * bus. This can also be used to figure out if @a connection is a
   * message bus connection.
   * 
   * @newin{2,26}
   * @return The unique name or <tt>0</tt> if @a connection is not a message
   * bus connection. Do not free this string, it is owned by
   *  @a connection.
   */
  Glib::ustring get_unique_name() const;

  
  /** Gets the credentials of the authenticated peer. This will always
   * return <tt>0</tt> unless @a connection acted as a server
   * (e.g. DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER was passed)
   * when set up and the client passed credentials as part of the
   * authentication process.
   * 
   * In a message bus setup, the message bus is always the server and
   * each application is a client. So this method will always return
   * <tt>0</tt> for message bus clients.
   * 
   * @newin{2,26}
   * @return A Credentials or <tt>0</tt> if not available. Do not free
   * this object, it is owned by @a connection.
   */
  Glib::RefPtr<Credentials> get_peer_credentials();
  
  /** Gets the credentials of the authenticated peer. This will always
   * return <tt>0</tt> unless @a connection acted as a server
   * (e.g. DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER was passed)
   * when set up and the client passed credentials as part of the
   * authentication process.
   * 
   * In a message bus setup, the message bus is always the server and
   * each application is a client. So this method will always return
   * <tt>0</tt> for message bus clients.
   * 
   * @newin{2,26}
   * @return A Credentials or <tt>0</tt> if not available. Do not free
   * this object, it is owned by @a connection.
   */
  Glib::RefPtr<const Credentials> get_peer_credentials() const;

  /** Asynchronously invokes the @a method_name method on the @a
   * interface_name D-Bus interface on the remote object at @a object_path
   * owned by @a bus_name.
   *
   * If the connection is closed then the operation will fail with
   * Gio::IO_ERROR_CLOSED. If @a cancellable is cancelled, the operation will
   * fail with Gio::IO_ERROR_CANCELLED. If @a parameters contains a value not
   * compatible with the D-Bus protocol, the operation fails with
   * Gio::IO_ERROR_INVALID_ARGUMENT.
   *
   * If @a reply_type is non-<tt>0</tt> then the reply will be checked for
   * having this type and an error will be raised if it does not match. Said
   * another way, if you give a @a reply_type then any non-<tt>0</tt> return
   * value will be of this type.
   *
   * This is an asynchronous method. When the operation is finished, callback
   * will be invoked in the thread-default main loop of the thread you are
   * calling this method from. You can then call call_finish() to get the
   * result of the operation.  See call_sync() for the synchronous version of
   * this function.
   *
   * @param object_path Path of remote object.
   * @param interface_name D-Bus interface to invoke method on.
   * @param method_name The name of the method to invoke.
   * @param slot A SlotAsyncReady to call when the request is satisfied.
   * @param cancellable A Cancellable.
   * @param bus_name A unique or well-known bus name or <tt>0</tt> if the
   * connection is not a message bus connection.
   * @param timeout_msec The timeout in milliseconds, -1 to use the default
   * timeout or G_MAXINT for no timeout.
   * @param flags Flags from the Gio::DBusCallFlags enumeration.
   * @param parameters A Glib::VariantBase tuple with parameters for the
   * method or <tt>0</tt> if not passing parameters.
   * @param reply_type The expected type of the reply, or <tt>0</tt>.
   * @newin{2,28}
   */
  void call(
    const Glib::ustring&                object_path,
    const Glib::ustring&                interface_name,
    const Glib::ustring&                method_name,
    const SlotAsyncReady&               slot,
    const Glib::RefPtr<Cancellable>&    cancellable,
    int                                 timeout_msec = -1,
    const Glib::ustring&                bus_name = Glib::ustring(),
    DBusCallFlags                       flags = Gio::DBUS_CALL_FLAGS_NONE,
    const Glib::VariantBase&            parameters = Glib::VariantBase(),
    const Glib::VariantType&            reply_type = Glib::VariantType()
  );
  

  /// A non-cancellable version of call().
  void call(
    const Glib::ustring&                object_path,
    const Glib::ustring&                interface_name,
    const Glib::ustring&                method_name,
    const SlotAsyncReady&               slot,
    int                                 timeout_msec = -1,
    const Glib::ustring&                bus_name = Glib::ustring(),
    DBusCallFlags                       flags = Gio::DBUS_CALL_FLAGS_NONE,
    const Glib::VariantBase&            parameters = Glib::VariantBase(),
    const Glib::VariantType&            reply_type = Glib::VariantType()
  );

  /** Finishes an operation started with call().
   * @param output A location in which to return a tuple with return values.
   * @param res A AsyncResult obtained from the SlotAsyncReady passed to
   * call().
   * @throw Glib::Error.
   * @newin{2,28}
   */
  void call_finish(
    Glib::VariantBase&                   output,
    const Glib::RefPtr<AsyncResult>&     res
  );
  

  /** Synchronously invokes the @a method_name method on the @a interface_name
   * D-Bus interface on the remote object at @a object_path owned by @a
   * bus_name.
   *
   * If the connection is closed then the operation will fail with
   * Gio::IO_ERROR_CLOSED. If @a cancellable is cancelled, the operation will
   * fail with Gio::IO_ERROR_CANCELLED. If @a parameters contains a value not
   * compatible with the D-Bus protocol, the operation fails with
   * Gio::IO_ERROR_INVALID_ARGUMENT.
   *
   * If @a reply_type is non-<tt>0</tt> then the reply will be checked for
   * having this type and an error will be raised if it does not match. Said
   * another way, if you give a @a reply_type then any non-<tt>0</tt> return
   * value will be of this type.
   *
   * The calling thread is blocked until a reply is received. See call() for
   * the asynchronous version of this method.
   *
   * @param output A location in which to return a tuple with return values.
   * @param object_path Path of remote object.
   * @param interface_name D-Bus interface to invoke method on.
   * @param method_name The name of the method to invoke.
   * @param cancellable A Cancellable.
   * @param bus_name A unique or well-known bus name or <tt>0</tt> if the
   * connection is not a message bus connection.
   * @param timeout_msec The timeout in milliseconds, -1 to use the default
   * timeout or G_MAXINT for no timeout.
   * @param flags Flags from the Gio::DBusCallFlags enumeration.
   * @param parameters A Glib::VariantBase tuple with parameters for the
   * method or <tt>0</tt> if not passing parameters.
   * @param reply_type The expected type of the reply, or <tt>0</tt>.
   * @throw Glib::Error.
   * @newin{2,28}
   */
  void call_sync(
    Glib::VariantBase&                  output,
    const Glib::ustring&                object_path,
    const Glib::ustring&                interface_name,
    const Glib::ustring&                method_name,
    const Glib::RefPtr<Cancellable>&    cancellable,
    int                                 timeout_msec = -1,
    const Glib::ustring&                bus_name = Glib::ustring(),
    DBusCallFlags                       flags = Gio::DBUS_CALL_FLAGS_NONE,
    const Glib::VariantBase&            parameters = Glib::VariantBase(),
    const Glib::VariantType&            reply_type = Glib::VariantType()
  );
  

  /// A non-cancellable version of call_sync().
  void call_sync(
    Glib::VariantBase&                  output,
    const Glib::ustring&                object_path,
    const Glib::ustring&                interface_name,
    const Glib::ustring&                method_name,
    int                                 timeout_msec = -1,
    const Glib::ustring&                bus_name = Glib::ustring(),
    DBusCallFlags                       flags = Gio::DBUS_CALL_FLAGS_NONE,
    const Glib::VariantBase&            parameters = Glib::VariantBase(),
    const Glib::VariantType&            reply_type = Glib::VariantType()
  );

  /** Emits a signal.
   *
   * This can only fail if @a parameters is not compatible with the D-Bus
   * protocol.
   *
   * @param object_path Path of remote object.
   * @param interface_name D-Bus interface to emit a signal on.
   * @param signal_name The name of the signal to emit.
   * @param destination_bus_name The unique bus name for the destination for
   * the signal or <tt>0</tt> to emit to all listeners.
   * @param parameters A Glib::VariantBase tuple with parameters for the
   * signal or <tt>0</tt> if not passing parameters.
   * @throw Glib::Error.
   * @newin{2,28}
   */
  void emit_singal(
    const Glib::ustring&                object_path,
    const Glib::ustring&                interface_name,
    const Glib::ustring&                signal_name,
    const Glib::ustring&                destination_bus_name = Glib::ustring(),
    const Glib::VariantBase&            parameters = Glib::VariantBase()
  );

  
  /** Gets whether the process is terminated when @a connection is
   * closed by the remote peer. See
   * DBusConnection:exit-on-close for more details.
   * 
   * @newin{2,26}
   * @return Whether the process is terminated when @a connection is
   * closed by the remote peer.
   */
  bool get_exit_on_close() const;
  
  /** Sets whether the process should be terminated when @a connection is
   * closed by the remote peer. See DBusConnection:exit-on-close for
   * more details.
   * 
   * @newin{2,26}
   * @param exit_on_close Whether the process should be terminated
   * when @a connection is closed by the remote peer.
   */
  void set_exit_on_close(bool exit_on_close = true);
  
  /** Gets the capabilities negotiated with the remote peer
   * 
   * @newin{2,26}
   * @return Zero or more flags from the DBusCapabilityFlags enumeration.
   */
  DBusCapabilityFlags get_capabilities() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};


} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusConnection
   */
  Glib::RefPtr<Gio::DBusConnection> wrap(GDBusConnection* object, bool take_copy = false);
}


#endif /* _GIOMM_DBUSCONNECTION_H */

